<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%//@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="java.text.*"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import="egurkha.*"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.eg.supermanager.*"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");
	
%>

<%
	JSONObject json = new JSONObject();
try
{
	String compName = request.getParameter("hostName");
	String compType = request.getParameter("compType");
	String test = request.getParameter("test");
	String measure = request.getParameter("measure");
	String portNo = request.getParameter("portNo");
	String msmtHost = request.getParameter("msmtHost");
	String sid = request.getParameter("sid");
	String site = request.getParameter("site");
	String tab = request.getParameter("tab");
	String hostName = "";

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}
	String iniName="";
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	if(tab.equals("custom"))
	{
		iniName="eg_customdashboard.ini";
	}
	else
	{
		iniName="eg_serverdashboard.ini";
	}

	if(com.eg.EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String hostname = request.getParameter("hostName");
		//System.out.println("EgMoreInfosDial.jsp hostname " + hostname);
		if(hostname != null)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			//System.out.println("EgMoreInfosDial.jsp host " + hostname);
			ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
			//System.out.println("EgMoreInfosDial.jsp managerIds " + managerIds);
			if(managerIds != null && !managerIds.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIds);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
			}
		}
	}
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil();

	EgServerDashBoardDAO dashboardDAO = new EgServerDashBoardDAO();
	dashboardDAO.setUserObj(session.getId());
	EgServerDashboardModel egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		iniName = "eg_aggregateserverdashboard.ini";
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	IniFile iniObj=new IniFile(s_iniFile_dir+iniName);
	ErUtils  erutils=new  ErUtils();

	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);

	String isThresholdNeed="";
	String DialChartNeed="";
	String MaxDial="";
	int maxDialValue;
	if(tab!=null && !tab.equals("") && tab.equals("custom"))
	{
		isThresholdNeed=iniObj.getValue("DIAL_GRAPH_THRESHOLD_VIEW","ApplyThreshold");
		IniFile serverDashBrdIni=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
		DialChartNeed=serverDashBrdIni.getValue("Dashboard_Settings","UseDial");
		if(DialChartNeed==null || DialChartNeed.equals(""))
			DialChartNeed="yes";
		MaxDial=iniObj.getValue("MAX_DIAL_GRAPHS","count");
		maxDialValue=Integer.parseInt(MaxDial);
	}
	else
	{
		isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");
		DialChartNeed=iniObj.getValue("Dashboard_Settings","UseDial");
		
		if(DialChartNeed==null || DialChartNeed.equals(""))
			DialChartNeed="yes";
		
		MaxDial=iniObj.getValue("MAX_DIAL_GRAPHS","MaxDials");
		maxDialValue=Integer.parseInt(MaxDial);
	}
	String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp")+"?"+"isFullView=true&hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&msmtHost="+msmtHost+"&tab="+tab;

	if(session!=null)
		session.setAttribute("lastFullViewURLForDashboard",moreDescriptorUrl);

	String info = "";

	//Vector testInfo = new Vector();
	Vector allValuesForInfo = new Vector();

	//testInfo = dashboardDAO.getDescriptorsForTest(compName,compType,test,tab);

	String dial_measureMapping=iniObj.getValue("Dashboard_Dial_mapping",test+":"+measure);


	if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
		dial_measureMapping=mappingInfo.getMeasureDescription(test,measure);

	String unit=tablesInfo.getUnitForMeasure(test,measure);

	if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
		unit="%";

	String measuresForDB=dbInfo.getColumnForMeasure(test,measure);

	allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,test,measuresForDB,msmtHost);
	int totalInfoCnt = allValuesForInfo.size();// Info with measure value
	if(totalInfoCnt > 0)
		totalInfoCnt = totalInfoCnt/2;

	if(totalInfoCnt>maxDialValue)
	{
		JSONObject jsondata = new JSONObject();
		JSONArray jsonArrList = new JSONArray();

		jsondata.put("dialHeader",mappingInfo.getTextDescription("monitor.dashboard."+dial_measureMapping)+"-"+mappingInfo.getTextDescription("monitor.dashboard.All Descriptors"));

		JSONObject desHeader = new JSONObject();
		desHeader.put("COLUMN_1",mappingInfo.getTextDescription("monitor.common.Descriptor"));
		desHeader.put("width","60");
		desHeader.put("textType","string");

		JSONObject valHeader = new JSONObject();
		valHeader.put("COLUMN_2",mappingInfo.getTextDescription("monitor.common.Value"));
		valHeader.put("width","40");
		valHeader.put("textType","asFloat");

		jsonArrList.add(desHeader);
		jsonArrList.add(valHeader);

		jsondata.put("tableHeadersArray",jsonArrList);

		String descriptor="";
		String value="";
		JSONArray tableDataArray = new JSONArray();
		for(int i=0;i<allValuesForInfo.size();)
		{
			JSONObject tableDataObject = new JSONObject();

			descriptor=(String)allValuesForInfo.get(i);
			descriptor=com.egurkha.util.StringUtils.replace(descriptor,sid+"+","");
			descriptor=com.egurkha.util.StringUtils.replace(descriptor,"+","");
			value=(String)allValuesForInfo.get(i+1);
			if(value!=null && !value.equals("") && value.indexOf("-")!=-1)
			{
				value="-";
			}

			tableDataObject.put("COLUMN_0",descriptor);
			tableDataObject.put("COLUMN_1",value);

			tableDataArray.add(tableDataObject);

			i=i+2;
		}

		jsondata.put("tableDataArray",tableDataArray);

		json.put("MOREINFOS_DIAL_Table",jsondata);
	}
	else
	{
		JSONObject jsondata = new JSONObject();
		JSONArray jsonArrList = new JSONArray();
		JSONObject hiddens = new JSONObject();

		int dialChartCount=0;

		jsondata.put("dialHeader",mappingInfo.getTextDescription("monitor.dashboard."+dial_measureMapping)+"-"+mappingInfo.getTextDescription("monitor.dashboard.All Descriptors"));
		json.put("dialHeader",mappingInfo.getTextDescription("monitor.dashboard."+dial_measureMapping)+"-"+mappingInfo.getTextDescription("monitor.dashboard.All Descriptors"));
		if(enabledTests!=null && enabledTests.contains(test))
		{
			double defaultDialGraphWidth=300;  // default dial graph width for calculation
			double defaultDialGraphHeight=188;  // default dial graph height for calculation
			double dialGraphWidth=300;  
			double dialGraphHeight=188;
			double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
			double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
			double defaultGauageOuterRadius=105; // default dial graph width for calculation
			double defaultGaugeXPos=137; // default dial graph Gauge X position for calculation
			double defaultGaugeYPos=140; // default dial graph Gauge Y position for calculation 
			String gauageOuterRadius="105";
			String gaugeXPos="137";
			String gaugeYPos="140";
			dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
			dialGraphWidth=MathUtils.round(dialGraphWidth,0);
			dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
			dialGraphHeight=MathUtils.round(dialGraphHeight,0);
			double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
			double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
			gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
			double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
			double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
			double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
			gaugeXPos=erutils.round(gaugeXPosInDouble,0);
			double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
			gaugeYPos=erutils.round(gaugeYPosInDouble,0);
			double defaultLedGraphWidth=140;  // default led graph width for calculation
			double defaultLedGraphHeight=115;  // default led graph height for calculation
			double ledGraphWidth=140;  
			double ledGraphHeight=115;
			double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
			double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
			double defaultLedGap=1; // default led graph gap for calculation
			double defaultLedSize=1; // default led graph size for calculation
			String ledGap="1";
			String ledSize="1";
			ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
			ledGraphWidth=MathUtils.round(ledGraphWidth,0);
			ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
			ledGraphHeight=MathUtils.round(ledGraphHeight,0);
			double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
			double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
			ledGap=erutils.round(ledGapInDouble,0);
			double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
			double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
			ledSize=erutils.round(ledSizeInDouble,0);
			double defaultChartLeftMargin=42;
			double defaultChartRightMargin=25;
			String chartLeftMargin="42";
			String chartRightMargin="25";
			double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
			double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
			chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
			double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
			double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
			chartRightMargin=erutils.round(ledRightMarginInDouble,0);

			jsonArrList = new JSONArray();

			for(int i= 0; i < allValuesForInfo.size();i=i+2 )
			{
				JSONObject tableDataObject = new JSONObject();

				info = (String)allValuesForInfo.get(i);
				if(test!=null && (test.equals("XenHostDiskSpaceTest") || test.equals("XenHostNetworkTest") || test.equals("DiskSpaceTest") || test.equals("WinNetworkTrafficTest")) && compType!=null && (compType.equals("Xen_virtual_server") || compType.equals("Xen_desktop_server") || compType.equals("Hyperv_server") || compType.equals("HyperV_VDI_server")))
				{
					if(info!=null && info.equals("+Total"))
					{
						continue;
					}
				}
				String measureValue="";
				String measureForDB=dbInfo.getColumnForMeasure(test,measure);

				Vector dialChartAttributes=new Vector();

				String layerName=dashboardDAO.getLayerForTest(compType,test,measure);

				String compTypeForAlarm=compType;
				String infoForDial=info;
				if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
				{
					compTypeForAlarm="Host_system";
					infoForDial=info;
				}

				if(compType.equalsIgnoreCase("Oracle_server") && !compTypeForAlarm.equals("Host_system"))
				{
					infoForDial=sid+info;
				}
				Vector excludedInfo = dashboardDAO.getExcludedInfo(test,measure,compType,false,false);
				if (excludedInfo != null && excludedInfo.contains(infoForDial))
					continue;
				String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-"+info,measure);

				if(info!=null && info.indexOf("+")!=-1)
							info=info.substring(info.indexOf("+")+1);
						info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");
				//String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+EgURLEncoder.encode(info,"UTF-8")+"&tstate="+measureState+"&msmt_host=";
				String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage="+tab+"_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+EgURLEncoder.encode(info,"UTF-8")+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";

				dialChartAttributes.add("clickURL='javascript:dialOnclick(&apos;infodialUrl"+dialChartCount+"&apos;)'");
				dialChartAttributes.add("fillAngle='60'");
				dialChartAttributes.add("majorTMNumber='6'");
				dialChartAttributes.add("majorTMHeight='8'");
				dialChartAttributes.add("majorTMColor='e5e5e5'");
				dialChartAttributes.add("minorTMColor='e5e5e5'");
				dialChartAttributes.add("minorTMHeight='4'");
				dialChartAttributes.add("minorTMNumber='6'");
				dialChartAttributes.add("majorTMThickness='1'");
				dialChartAttributes.add("markerRadius='30'");
				dialChartAttributes.add("showGaugeBorder='0'");
				dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
				dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
				dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
				dialChartAttributes.add("gaugeInnerRadius='0'");
				dialChartAttributes.add("formatNumberScale='0'");
				dialChartAttributes.add("displayValueDistance='0'");
				dialChartAttributes.add("decimalPrecision='2'");
				dialChartAttributes.add("tickMarkDecimalPrecision='2'");
				dialChartAttributes.add("tickValueDistance='14'");
				dialChartAttributes.add("pivotRadius='6'");
				dialChartAttributes.add("showPivotBorder='1'");
				dialChartAttributes.add("pivotBorderColor='000000'");
				dialChartAttributes.add("pivotBorderThickness='5'");
				dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
				dialChartAttributes.add("paletteThemeColor='ffffff'");
				dialChartAttributes.add("pivotFillType='linear'");
				dialChartAttributes.add("showToolTip='1'");
				dialChartAttributes.add("chartLeftMargin='0'");
				dialChartAttributes.add("chartRightMargin='0'");
				dialChartAttributes.add("chartBottomMargin='0'");
				dialChartAttributes.add("chartTopMargin='0'");
				dialChartAttributes.add("baseFontColor='000000'");
				dialChartAttributes.add("adjustTM='0'");
				dialChartAttributes.add("borderAlpha='0'");
				dialChartAttributes.add("bgAlpha='_alpha'");
				dialChartAttributes.add("showToolTipShadow='1'");
				dialChartAttributes.add("toolTipBgColor='ffffff'");
				dialChartAttributes.add("toolTipBorderColor='555555'");
				dialChartAttributes.add("exportEnabled='0'");
				dialChartAttributes.add("exportAction='download'");
				dialChartAttributes.add("exportAtClient='0'");
				dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				String dialXMLData="";
				if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("yes"))
				{
					//dialXMLData=graphUtil.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",infoForDial,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,"dialUrl"+dialChartCount);
					dialXMLData=graphUtil.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",infoForDial,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,layerPageUrl);
				}
				else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
				{
					Vector jvmChartAttributes=new Vector();	
					jvmChartAttributes.add("clickURL='javascript:dialOnclick(&apos;infodialUrl"+dialChartCount+"&apos;)'");//jvmChartAttributes.add("clickURL='javascript:parent.goToLayerModel(&apos;"+EgURLEncoder.encode(layerPageUrl,"UTF-8")+"&apos;)'");
					jvmChartAttributes.add("upperLimit='100'");
					jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
					jvmChartAttributes.add("bgAlpha='0,0'");
					jvmChartAttributes.add("showBorder='0'");
					jvmChartAttributes.add("lowerLimit='0'");
					jvmChartAttributes.add("showToolTip='1'");
					jvmChartAttributes.add("showToolTipShadow='1'");
					jvmChartAttributes.add("toolTipBgColor='ffffff'");
					jvmChartAttributes.add("toolTipBorderColor='555555'");
					jvmChartAttributes.add("decimals='2'");
					jvmChartAttributes.add("showValue='0'");
					jvmChartAttributes.add("majorTMNumber='5'");
					jvmChartAttributes.add("majorTMColor='000000'");
					jvmChartAttributes.add("majorTMHeight='5'");
					jvmChartAttributes.add("minorTMNumber='2'");
					jvmChartAttributes.add("minorTMColor='000000'");
					jvmChartAttributes.add("minorTMHeight='2'");
					jvmChartAttributes.add("majorTMThickness='1'");
					jvmChartAttributes.add("decimalPrecision='0'");
					jvmChartAttributes.add("ledGap='"+ledGap+"'");
					jvmChartAttributes.add("ledSize='"+ledSize+"'");
					jvmChartAttributes.add("tickValueDistance='2'");
					jvmChartAttributes.add("tickMarkDistance='2'");
					jvmChartAttributes.add("tickValueStep='1'");
					jvmChartAttributes.add("tickValueDecimals='8'");
					jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
					jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
					jvmChartAttributes.add("chartTopMargin='4'");
					jvmChartAttributes.add("chartBottomMargin='25'");
					jvmChartAttributes.add("baseFontSize ='9'");
					jvmChartAttributes.add("baseFontColor  ='000000'");
					jvmChartAttributes.add("annRenderDelay='1.7'");
					jvmChartAttributes.add("exportEnabled='0'");
					jvmChartAttributes.add("exportAction='download'");
					jvmChartAttributes.add("exportAtClient='0'");
					jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					dialXMLData=fusionChart.getXMLDataForDial(test,measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",infoForDial,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight);
				}

				if(dialXMLData !=null && !dialXMLData.equals(""))
				{
					if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("Yes"))
					{
						String info_mapping=infoForDial;
						info_mapping=com.egurkha.util.StringUtils.replace(info_mapping,sid+"+","");
						info_mapping=com.egurkha.util.StringUtils.replace(info_mapping,"+","");
						String info_Display=info_mapping;
						tableDataObject.put("chartTitle",info_Display);
						tableDataObject.put("chartInd",String.valueOf(i));
						tableDataObject.put("divId",String.valueOf("MoreDialAngularGaugeContainer"+i));
						tableDataObject.put("fcId",String.valueOf("myMoreDialAngularGaugeChartId"+i));
						tableDataObject.put("chartName","AngularGauge");
						tableDataObject.put("movie","/final/FusionCharts/swf/AngularGauge.swf");
						tableDataObject.put("chartWidth",dialGraphWidth);
						tableDataObject.put("chartHeight",dialGraphHeight);
						tableDataObject.put("chartXMLData",dialXMLData);
					} 
					else if(DialChartNeed!=null && DialChartNeed.equalsIgnoreCase("No"))
					{
						String info_mapping=infoForDial;
						info_mapping=com.egurkha.util.StringUtils.replace(info_mapping,sid+"+","");
						info_mapping=com.egurkha.util.StringUtils.replace(info_mapping,"+","");
						String info_Display=info_mapping;
						if(info_mapping.length()>15)
						{
							info_Display=info_mapping.substring(0,15)+"...";
						}

						tableDataObject.put("chartTitle",info_Display);
						tableDataObject.put("chartTitleMap",info_mapping);
						tableDataObject.put("chartInd",String.valueOf(i));
						tableDataObject.put("divId",String.valueOf("MoreDialVLEDContainer"+i));
						tableDataObject.put("fcId",String.valueOf("myMoreDialVLEDChartId"+i));
						tableDataObject.put("chartName","VLED");
						tableDataObject.put("movie","/final/FusionCharts/swf/VLED.swf");
						tableDataObject.put("chartWidth",ledGraphWidth);
						tableDataObject.put("chartHeight",ledGraphHeight);
						tableDataObject.put("chartXMLData",dialXMLData);
					}
					tableDataObject.put("dialUrl"+dialChartCount,layerPageUrl);
					hiddens.put("dialUrl"+dialChartCount, layerPageUrl);
					jsonArrList.add(tableDataObject);
				}
				
				dialChartCount++;
				
			}
			jsondata.put("tableDataArray",jsonArrList);
		}
		else
		{
			jsondata.put("errMsg",mappingInfo.getTextDescription("monitor.dashboard.No Measures available"));
		}

		json.put("dialChartTable",jsondata);
		json.put("hiddens", hiddens);
	}
	response.getWriter().write(json.toString());
}
catch(Exception e)
{
	e.printStackTrace();
}
%>

