<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "egurkha.TransactionBean"%>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	response.setContentType("application/json");

	TransactionBean transBean = new TransactionBean();
	
	final String MAIL_TAGLINE = _mapping.getTextDescription("admin.tt.Integration using Mail");
	final String SNMP_TAGLINE = _mapping.getTextDescription("admin.tt.Integration using SNMP");
	final String CLI_TAGLINE = _mapping.getTextDescription("admin.tt.Integration using CLI");
	boolean isMailEnabled = false;
	boolean isEnabledSNMPTraps = false;
	boolean isEnabledCLI = false;
	boolean isEnabledTTIntegartion = false;
	String selectedEGUser=request.getParameter("selectedEGUser");
	selectedEGUser=com.egurkha.util.StringUtils.decodeSecurityChar(selectedEGUser);
	boolean isDefaultOrg=false;
	if(selectedEGUser!=null && (selectedEGUser.equalsIgnoreCase("egenterprise") || selectedEGUser.equalsIgnoreCase("admin")))
	{
		transBean.createFile("eg_services.ini");
		isDefaultOrg=true;
		selectedEGUser="egenterprise";
	}
	else
	{
		transBean.createFile("eg_ttconfig.ini");
	}
	//String strArr[] = {"Mail","JIRA","SLACK","HipChat","PAGERDUTY"};
	String ttSystems = transBean.getStrValue("TT_INTEGRATION", "TT_INTEGRATION_SYSTEMS");
	String enableTTIntegration = transBean.getStrValue("TT_INTEGRATION", "ENABLE_TT_INTEGRATION");
	String enabledTTSystem = "";
	if(isDefaultOrg)
	{
		enabledTTSystem=transBean.getStrValue("TT_INTEGRATION", "TT_INTEGRATION_ENABLED_SYSTEM");
	}
	else
	{
		enabledTTSystem=transBean.getStrValue("TT_INTEGRATION_ENABLED_SYSTEM", selectedEGUser);
	}
	
	String enableMail = transBean.getStrValue("TTMAIL", "EnableMail");
	String enableTTIntegrationForSNMPTraps = transBean.getStrValue("TTMAIL", "EnableTTIntegrationForSNMPTraps");
	String enableExecForTT = transBean.getStrValue("EXEC_TTMANAGER", "EnableExecForTT");

	if(enableMail != null && enableMail.equalsIgnoreCase("Yes") || enableMail.equalsIgnoreCase("true")){
		isMailEnabled = true;
	}
	if(enableTTIntegrationForSNMPTraps != null && enableTTIntegrationForSNMPTraps.equalsIgnoreCase("Yes") || enableTTIntegrationForSNMPTraps.equalsIgnoreCase("true")){
		isEnabledSNMPTraps = true;
	}
	if(enableExecForTT != null && enableExecForTT.equalsIgnoreCase("Yes") || enableExecForTT.equalsIgnoreCase("true")){
		isEnabledCLI = true;
	}
	if(enableTTIntegration != null && enableTTIntegration.equalsIgnoreCase("Yes") || enableTTIntegration.equalsIgnoreCase("true")){
		isEnabledTTIntegartion = true;
	}
	
	JSONObject root = new JSONObject();
	JSONArray integrationList = new JSONArray();
	

	//### Mail ##
	JSONObject cObj = new JSONObject();
	cObj.put("integrationName", "Mail");
	cObj.put("integrationType", "Mail");
	cObj.put("tagline", MAIL_TAGLINE);
	cObj.put("displayName", _mapping.getTextDescription("admin.tt.Mail"));
	cObj.put("iconClsName", "mail_icon");
	cObj.put("configuration", isMailEnabled);
	integrationList.add(cObj);
	
	//### SNMP ##
	/*cObj = new JSONObject();
	cObj.put("integrationName", "SNMP");
	cObj.put("integrationType", "SNMP");
	cObj.put("tagline", SNMP_TAGLINE);
	cObj.put("displayName", "SNMP");
	cObj.put("iconClsName", "snmp_icon");
	cObj.put("configuration", isEnabledSNMPTraps);
	integrationList.add(cObj);*/

	//### CLI ##
	cObj = new JSONObject();
	cObj.put("integrationName", "CLI");
	cObj.put("integrationType", "CLI");
	cObj.put("tagline", CLI_TAGLINE);
	cObj.put("displayName", _mapping.getTextDescription("admin.tt.CLI"));
	cObj.put("iconClsName", "cli_icon");
	cObj.put("configuration", isEnabledCLI);
	integrationList.add(cObj);

	//### Web services ##
	StringTokenizer integrationNames = new StringTokenizer(ttSystems, ",");	
	
	while (integrationNames.hasMoreTokens())
	{
		String integrationName = integrationNames.nextToken();

		JSONObject intgrObj = new JSONObject();

		intgrObj.put("integrationName", integrationName);
		intgrObj.put("integrationType", "Web_Services");
		
		String tagline = transBean.getStrValue("TT_INTEGRATION_" + integrationName, "tagline");
		String displayName = transBean.getStrValue("TT_INTEGRATION_" + integrationName, "displayName");

		intgrObj.put("tagline", _mapping.getTextDescription("admin.tt."+tagline));
		intgrObj.put("displayName", _mapping.getTextDescription("admin.tt."+displayName));
		
		if(integrationName != null && integrationName.trim().equalsIgnoreCase(enabledTTSystem)){
			if(isDefaultOrg && !isEnabledTTIntegartion)
			{
				intgrObj.put("configuration", false);
			}
			else
			{
				intgrObj.put("configuration", true);//configuration:true
			} 
		} else {
			intgrObj.put("configuration", false);//configuration:true
		}
		if(integrationName != null)
		{
			String iconClsName = "";
			if(integrationName!=null && integrationName.startsWith("SNOW"))
			{
				iconClsName = "service now";
			}
			else
			{
				iconClsName = 	integrationName.trim().toLowerCase();
			}
			iconClsName = iconClsName.replace(' ', '_'); // replace space with underscore (_)
			iconClsName += "_icon"; //End with _icon
			intgrObj.put("iconClsName", iconClsName);
		}

		integrationList.add(intgrObj);
	}
	
	//### Common Settings ##
		cObj = new JSONObject();

		cObj.put("integrationName", "Settings");//Common Settings
		cObj.put("integrationType", "Settings");//Common Settings
		cObj.put("tagline",  _mapping.getTextDescription("admin.tt.Common"));
		cObj.put("displayName", _mapping.getTextDescription("admin.tt.Settings"));
		cObj.put("iconClsName", "common_settings_icon");
		cObj.put("configuration", false);//configuration always false for Settings

		integrationList.add(cObj);

	root.put("integrationList", integrationList);
	//System.out.println("listJSON#########"+ root.toString());
	
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUUID = new IniFile(s_iniFile_dir + "eg_uuid.ini");
	String orgs [] = egUUID.getVariables("ORG_UUID");
	EgUuidInfo egUuidInfo = new EgUuidInfo();
	
	JSONArray jArray = new JSONArray();
	JSONArray jMainArray = new JSONArray();
	EgUserRole usrRole = _user.getUserRole();
	String uname = _user.getLoginID();
	
	String session_userid = (String)session.getAttribute("sess_userid");
	IniFile ServicesIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String managerModel = ServicesIni.getValue("MISC_ARGS","eGMgrModel");
	//String managerModel = transBean.getStrValue("MISC_ARGS","eGMgrModel");
	
	boolean hasAllComponentAccess = usrRole.hasAllComponentAccess();
	//System.out.println("managerModel "+managerModel+" hasAllComponentAccess "+hasAllComponentAccess);
	if (hasAllComponentAccess)
	{
		if(managerModel != null && managerModel.equalsIgnoreCase("msp"))
		{
			IniFile inifile1 = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_uuid.ini");
			String topLevelOrgs[] = inifile1.getVariables("ORG_UUID");

			ArrayList superOrgs = new ArrayList();
			if(topLevelOrgs != null && topLevelOrgs.length>0)
			{
				superOrgs.addAll(Arrays.asList(topLevelOrgs));
			}
			JSONArray exportDataArr = new JSONArray();
			for(int i=0;i<superOrgs.size();i++)
			{
				JSONObject exportDataObj = new JSONObject();
				String optVar = "";
				String optVal = "";

				String strDbChild = "";

				String orgname = (String)superOrgs.get(i);

				String uvalidtill = egUuidInfo.getExpiryDateOfUser(orgname);

				if (uvalidtill != null)
				{
					if (uvalidtill.trim().length() == 0)
					{
						continue;
					}
					if (uvalidtill.indexOf("9999-12-12 23:59:59") == -1)
					{
						uvalidtill = uvalidtill.substring(0,10);
						uvalidtill = com.egurkha.util.DateUtil.changeDateFormat(uvalidtill,"yyyy-MM-dd","MM/dd/yyyy");
					}
					else
					{
						uvalidtill = "12/12/9999";
					}

					java.util.Date today = new java.util.Date();
					SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date uvalidtilldate = new java.util.Date();
					try
					{
						uvalidtilldate = formatter.parse(uvalidtill+" 23:59:59");
					}
					catch(Exception e){}

					if (!uvalidtill.equalsIgnoreCase("12/12/9999") && uvalidtilldate.compareTo(today) < 0)
					{
						continue;
					}
				}

				optVar = (String)superOrgs.get(i);
				optVal = (String)superOrgs.get(i);

				JSONArray rootUserObjectArray = egUuidInfo.buildTreeJsonForAllUsers(orgname,session_userid,false,"active",new ArrayList());
				if ((rootUserObjectArray!=null && !rootUserObjectArray.isEmpty()) && orgname.equalsIgnoreCase("egenterprise"))
				{
					//if (!rootUserObjectArray.isEmpty())
					{
						if (!session_userid.equalsIgnoreCase("egenterprise"))
						{
							if (optVal.equalsIgnoreCase("egenterprise"))
							{
								exportDataObj.put("text","admin");
							}
							else
							{
								exportDataObj.put("text",optVal);
							}
							String defaultOrgLabel=(String)exportDataObj.get("text");
							if(defaultOrgLabel!=null && defaultOrgLabel.equalsIgnoreCase("admin"))
							{
								defaultOrgLabel=uname+" (Default Organization)";
								exportDataObj.put("text",defaultOrgLabel);
							}
							
							//System.out.println("exportDataObj 3333---->"+exportDataObj);
							exportDataObj.put("id",optVar);
							exportDataObj.put("iconCls","iconDomain");
							exportDataObj.put("expanded",true);
							exportDataObj.put("children",rootUserObjectArray);
							exportDataArr.add(exportDataObj);
						}
						else
						{
							JSONObject defaultOrganization=(JSONObject)rootUserObjectArray.get(0);
							String defaultOrgLabel=(String)defaultOrganization.get("text");
							if(defaultOrgLabel!=null && defaultOrgLabel.equalsIgnoreCase("admin"))
							{
								defaultOrgLabel=uname+" (Default Organization)";
							}
							defaultOrganization.put("text",defaultOrgLabel);
							//System.out.println("defaultOrganization 1111---->"+defaultOrganization);
				
							exportDataArr = rootUserObjectArray;
						}
					}
				}
				else if(rootUserObjectArray!=null && !rootUserObjectArray.isEmpty())
				{
					JSONObject defaultOrganization=(JSONObject)rootUserObjectArray.get(0);
					String defaultOrgLabel=(String)defaultOrganization.get("text");
					if(defaultOrgLabel!=null && defaultOrgLabel.equalsIgnoreCase("Default Organization"))
					{
						defaultOrgLabel=uname+" (Default Organization)";
					}
					defaultOrganization.put("text",defaultOrgLabel);
					//System.out.println("defaultOrganization 2222---->"+defaultOrganization);
					
					exportDataObj.put("text",optVal);
					exportDataObj.put("id",optVar);
					exportDataObj.put("iconCls","iconDomain");
					exportDataObj.put("expanded",true);
					exportDataObj.put("children",rootUserObjectArray);
					exportDataArr.add(exportDataObj);
				}
			}
			if (!exportDataArr.isEmpty())
			{
				root.put("exportDataArr",exportDataArr);
				root.put("RootNodeText","Choose Organization / Organizational Unit / User");
				if(com.egurkha.util.StringUtils.isNull(selectedEGUser))
				{
					JSONObject rtUsrObj=(JSONObject)exportDataArr.get(0);
					if(rtUsrObj!=null && rtUsrObj.containsKey("id"))
					{
						selectedEGUser=(String)rtUsrObj.get("id");
					}
				}
			}
		}
		else
		{
			JSONArray exportDataArr = new JSONArray();
			JSONObject exportDataObj = new JSONObject();

			JSONArray rootUserObjectArray = egUuidInfo.buildTreeJsonForAllUsers("egenterprise",session_userid,false,"active",new ArrayList());
			
			if (!session_userid.equalsIgnoreCase("egenterprise"))
			{
				IniFile egMgrMisc = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
				String defaultOrgName = egMgrMisc.getValue("MISC_ARGS","DefaultOrgName");
				if (!StringUtils.isNull(defaultOrgName))
				{
					exportDataObj.put("text",defaultOrgName);
				}
				else
				{
					exportDataObj.put("text",_mapping.getTextDescription("admin.user.egenterprise"));
				}
				exportDataObj.put("id","egenterprise");
				exportDataObj.put("iconCls","iconDomain");
				exportDataObj.put("expanded",true);
				exportDataObj.put("children",rootUserObjectArray);
				exportDataArr.add(exportDataObj);
				root.put("RootNodeText","Choose Organizational Unit / User");
			}
			else
			{
				exportDataArr = rootUserObjectArray;
				root.put("RootNodeText","Choose Organizational Unit / User");
			}

			if (!exportDataArr.isEmpty())
			{
				root.put("exportDataArr",exportDataArr);
				if(com.egurkha.util.StringUtils.isNull(selectedEGUser))
				{
					JSONObject rtUsrObj=(JSONObject)exportDataArr.get(0);
					if(rtUsrObj!=null && rtUsrObj.containsKey("id"))
					{
						selectedEGUser=(String)rtUsrObj.get("id");
					}
				}
			}
		}
	}
	else
	{

		boolean isUserExpired = egUuidInfo.isUserExpired(uname);

		String orgName = uname;
		boolean isSuperOU = egUuidInfo.isSuperOrg(uname);
		boolean isOU = egUuidInfo.isOrg(uname);
		boolean hasOURole = egUuidInfo.hasOURole(uname);
		if (!isSuperOU && !isOU && hasOURole)
		{
			orgName = egUuidInfo.getDirectDependentOU(uname);
		}

		if (!isUserExpired)
		{
			JSONArray rootUserObjectArray = egUuidInfo.buildTreeJsonForAllUsers(orgName,uname,false,"active",new ArrayList());

			if (!rootUserObjectArray.isEmpty())
			{
				JSONObject defaultOrganization=(JSONObject)rootUserObjectArray.get(0);
				String defaultOrgLabel=(String)defaultOrganization.get("text");
				if(defaultOrgLabel!=null && defaultOrgLabel.equalsIgnoreCase("Default Organization"))
				{
					defaultOrgLabel=uname+" (Default Organization)";
				}
				defaultOrganization.put("text",defaultOrgLabel);
				//System.out.println("defaultOrganization---->"+defaultOrganization);
				root.put("exportDataArr",rootUserObjectArray);
				root.put("RootNodeText","Choose Organizational Unit / User");
				
				if(com.egurkha.util.StringUtils.isNull(selectedEGUser))
				{
					JSONObject rtUsrObj=(JSONObject)rootUserObjectArray.get(0);
					if(rtUsrObj!=null && rtUsrObj.containsKey("id"))
					{
						selectedEGUser=(String)rtUsrObj.get("id");
					}
				}
			}
		}
	}
	
	if(!(com.egurkha.util.StringUtils.isNull(selectedEGUser)))
	{
		if (selectedEGUser.equalsIgnoreCase("egenterprise"))
		{
			root.put("RootNodeText","-1");
		}
		else
		{
			root.put("RootNodeText",selectedEGUser);
		}
	}
	
	out.println(root.toString());
%>
