Ext.define('ICTest.controller.DatasetController',{
	extend:'Ext.app.Controller',
	views:['AddNewDSN'],
	requires:['ICTest.view.AddNewDSN','ICTest.view.RESTHeaderGrid', 'ICTest.view.RESTParamsGrid','ICTest.view.RESTBodyUrlEncodedGrid','ICTest.view.RESTDataGrid','utilities.TreeScrollPanel','ICTest.view.RESTGenerate','ICTest.view.RESTMeasureMappingGrid'],
	refs:[
		{selector:'addnewdsn', ref:'addnewdsn'},
		{selector:'RESTParamsGrid', ref:'RESTParamsGrid'},
		{selector:'RESTHeaderGrid', ref:'RESTHeaderGrid'},
		{selector:'RESTBodyUrlEncodedGrid', ref:'RESTBodyUrlEncodedGrid'},
		{selector:'restgenerate', ref:'restgenerate'},
		{selector:'restMeasureMappingGrid', ref:'restMeasureMappingGrid'},
	],
	init:function(){
		if(Ext.isEmpty(datasetCtrlr))
		{
			datasetCtrlr = this;
		}
		this.control({
			'addnewdsn combo[id="restHttpMethod"]' :
			{
				'select' : this.restHttpMethodChange
			},
			'addnewdsn checkbox[id="User_Authentication_Required"]' : {
				'change' : this.enableUserAuthenticationSettings
			},
			'addnewdsn checkbox[id="Header_Required"]' : {
				'change' : this.enableHeaderRequiredSettings
			},
			'addnewdsn checkbox[id="params_Required"]' : {
				'change' : this.enableParamsRequiredSettings
			},
			'addnewdsn button[id="addHeader"]' :
			{
				'click' : this.addHeader
			},
			'addnewdsn button[id="rest_header"]' :
			{
				'click' : this.addBasicAuth
			},
			'addnewdsn button[id="addParam"]' :
			{
				'click' : this.addParam
			},
			'restgenerate button[id="addParam"]' :
			{
				'click' : this.addMeasureInternalValueConfiguration
			},
			'addnewdsn radiogroup[id="body_type"]' : {
				'change' : this.body_typeSettings
			},
			'addnewdsn button[id="addBody_urlencoded"]' :
			{
				'click' : this.addBody_urlencoded
			},
			'addnewdsn button[id="getData"]' :
			{
				'click' : this.saveRESTDSN
			},
			'addnewdsn combo[id="authType"]' : {
				'change' : this.changeAuthType
			},
			'addnewdsn button[id="addAPIKeyBtn"]' :
			{
				'click' : this.addAPIKey
			},
			'addnewdsn button[id="addBearerTokBtn"]' :
			{
				'click' : this.addBearerAuth
			},
			'addnewdsn combo[id="oAuth2GrantType"]' : {
				'change' : this.changeGrantType
			},
		/*	'addnewdsn button[id="saveFldsBtn"]' :
			{
				'click' : this.selectFields
			},*/
			'restgenerate checkbox[id="DescriptorRequired"]' : {
				'change' : this.enableDescriptorDataRestFldSelection
			},
			'restgenerate button[id="generate"]' : {
				'click':this.generateRESTTest
			}
		});
	},
	changeGrantType : function(comboObj)
	{
		var grantTypeVal = comboObj.getValue();

		if(grantTypeVal!=null && grantTypeVal == 'Client_Credentials')
		{
			Ext.getCmp('oAuth2Username').hide();
			Ext.getCmp('oAuth2Pwd').hide();
		}
		else
		{
			Ext.getCmp('oAuth2Username').show();
			Ext.getCmp('oAuth2Pwd').show();
		}
	},
	changeAuthType : function()
	{
		var authTypeValue = Ext.getCmp('authType').getValue();
		
		if(authTypeValue == 'NoAuth')
		{
			Ext.getCmp('basicAuthContr').hide();
			Ext.getCmp('apiTokenContr').hide();
			Ext.getCmp('bearerTokenContr').hide();
			Ext.getCmp('oAuth2TokenContr').hide();
			/*Ext.getCmp('headerContr').hide();
			Ext.getCmp('parametersContr').hide();
			Ext.getCmp('requestBodyContr').hide(); */
		}
		else if(authTypeValue == 'BasicAuth')
		{
			Ext.getCmp('basicAuthContr').show();
			Ext.getCmp('apiTokenContr').hide();
			Ext.getCmp('bearerTokenContr').hide();
			Ext.getCmp('oAuth2TokenContr').hide();
			/* Ext.getCmp('headerContr').hide();
			Ext.getCmp('parametersContr').hide();
			Ext.getCmp('requestBodyContr').hide(); */
		}
		else if(authTypeValue == 'APIKey')
		{
			Ext.getCmp('basicAuthContr').hide();
			Ext.getCmp('apiTokenContr').show();
			Ext.getCmp('bearerTokenContr').hide();
			Ext.getCmp('oAuth2TokenContr').hide();
		}
		else if(authTypeValue == 'BearerToken')
		{
			Ext.getCmp('basicAuthContr').hide();
			Ext.getCmp('apiTokenContr').hide();
			Ext.getCmp('bearerTokenContr').show();
			Ext.getCmp('oAuth2TokenContr').hide();
		}
		else if(authTypeValue == 'OAuth2.0')
		{
			Ext.getCmp('basicAuthContr').hide();
			Ext.getCmp('apiTokenContr').hide();
			Ext.getCmp('bearerTokenContr').hide();
			Ext.getCmp('oAuth2TokenContr').show();
			/* Ext.getCmp('rest_username').hide();
			Ext.getCmp('rest_password').hide();
			Ext.getCmp('apiKeyValue').hide();
			Ext.getCmp('bearerToken').hide();
			Ext.getCmp('bearer_header').hide();
			Ext.getCmp('addTo').hide();
			Ext.getCmp('apiKeyName').hide();*/
		}
	},
	addAPIKey : function()
	{
		var apiKeyName=Ext.getCmp('apiKeyName').getValue();
		var apiKeyValue=Ext.getCmp('apiKeyValue').getValue();
		if(this.validateAPIKey())
		{
			var addTo=Ext.getCmp('apiKeyAddTo').getValue();
			if(addTo == 'Param')
			{
				var gridObj = this.getRESTParamsGrid();
				var gridStore = gridObj.getStore();
				var configuredData = [];
				configuredData.push({
					key : apiKeyName,
					value : apiKeyValue
				});
				gridStore.add(configuredData);
				gridObj.doLayout();

				var viewTypeOptObj = Ext.getCmp('params_Required');
				viewTypeOptObj.suspendEvents(false);
				viewTypeOptObj.setValue(true);
				viewTypeOptObj.resumeEvents();
			}
			if(addTo == 'Header')
			{
				var gridObj = this.getRESTHeaderGrid();
				var gridStore = gridObj.getStore();
				var configuredData = [];
				configuredData.push({
					key : apiKeyName,
					value : apiKeyValue
				});
				gridStore.add(configuredData);
				gridObj.doLayout();

				var viewTypeOptObj = Ext.getCmp('Header_Required');
				viewTypeOptObj.suspendEvents(false);
				viewTypeOptObj.setValue(true);
				viewTypeOptObj.resumeEvents();
			}
		}
	},
	addBearerAuth : function()
	{
		var tokenObj=Ext.getCmp('bearerTokenValue').getValue();
		if(Ext.isEmpty(tokenObj))
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['bearerTokenAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			return;
		}
		//var value=tokenObj.getValue();
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredData = [];
		configuredData.push({
			key : "Authorization",
			value :tokenObj
		});
		gridStore.add(configuredData);
		gridObj.doLayout();
		var viewTypeOptObj = Ext.getCmp('Header_Required');
		viewTypeOptObj.suspendEvents(false);
		viewTypeOptObj.setValue(true);
		viewTypeOptObj.resumeEvents();
		//tokenObj.reset();
	},
	validateAPIKey : function()
	{
		var keyobj=Ext.getCmp('apiKeyName');
		var valueobj=Ext.getCmp('apiKeyValue');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var splChar = "=\"@()!^;?><:,";

		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['headerParamAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['headerValueAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if(key!="" || key!=null)
		{
			for ( var i = 0; i < key.length; i++)
			{
				check_char = splChar.indexOf(key.charAt(i))
				if (check_char >= 0) {
					Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: key+' '+screenLabelsObj['invalidHTTPHeaderAlert'],
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		}
		return true;
	},
	selectFields : function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var restDashMainPnl=Ext.getCmp('restDataConfigurationWindow');
		var isDescriptorDataField=false;
		var dataFieldMapping='';
		var checkedValue = [];
		var selectedFields="";
		var dataFieldParentNode='';
		var inputElements = document.getElementsByClassName('messageCheckbox');
		var dataTypeMapping='';
		if(restDashMainPnl!=null && restDashMainPnl.hasOwnProperty('dataTypeMapping'))
		{
			dataTypeMapping=restDashMainPnl.dataTypeMapping;
		}
		var chkCount=0;
		var isNonNumericDataType=false;
		var selectedMetrics=[];
		var descriptorFields=[];
		var restDataGridObj=Ext.getCmp('restDataGrid');
		var dataFieldParentNode=restDataGridObj.dataFieldParentNode;
		var selectedDataFldsArr=[];
		var noOFNodesSelected=0;
		if(!Ext.isEmpty(restDataGridObj) && restDataGridObj.hasOwnProperty('selectedDataFieldsMap'))
		{
			selectedDataFieldsMap=restDataGridObj.selectedDataFieldsMap;
			selectedFldsMapping=selectedDataFieldsMap;
			if(!Ext.isEmpty(selectedDataFieldsMap))
			{
				for (var d in selectedDataFieldsMap)
				{
					var parNod=d;

					noOFNodesSelected++;
					 if(parNod!=null && parNod==dataFieldParentNode)
						 continue;

					var selectedFields1=selectedDataFieldsMap[d];

					for(var s1 in selectedFields1)
					{
						var selectedDataFld=selectedFields1[s1];
						selectedMetrics.push(selectedDataFld+"|^|"+parNod);
					}
				}
				publicJSON.restFldMap=selectedDataFieldsMap;
			}
		}
		for(var i=0; inputElements[i]; ++i){
			  if(inputElements[i].checked){
				var selectedDataFld=inputElements[i].value;
				
				 if(dataTypeMapping!=null && dataTypeMapping.hasOwnProperty(selectedDataFld))
				  {
					  var dataTyp=dataTypeMapping[inputElements[i].value];
					  if(Ext.isEmpty(dataTyp) || (dataTyp!=null && dataTyp!="Number"))
					  {
						  isNonNumericDataType=true;
						   descriptorFields.push(selectedDataFld+"|^|"+dataFieldParentNode);
						   selectedMetrics.push(selectedDataFld+"|^|"+dataFieldParentNode);
					  }
					  else
					  {
						  selectedMetrics.push(selectedDataFld+"|^|"+dataFieldParentNode);
					  }
					  if(!Ext.isEmpty(dataTyp))
					  {
						   dataFieldMapping+="^_^"+selectedDataFld+"^:^"+dataTyp;
					  }
					  else
					  {
						  dataFieldMapping+="^_^"+selectedDataFld+"^:^String";
					  }
				  }
				  chkCount++;
			  }
		}
		/*if(Ext.isEmpty(selectedMetrics) && isNonNumericDataType)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['validMeasureDataFieldMsg'],
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		else */
		if(Ext.isEmpty(selectedMetrics))
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['selectFieldsAlert'],
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		
		if(dataFieldMapping!=null && dataFieldMapping.indexOf("^_^")>-1)
		{
			dataFieldMapping=dataFieldMapping.substring(dataFieldMapping.indexOf("^_^")+3,dataFieldMapping.length);
		}
	
		var restDashMainPnl = Ext.getCmp('restDataConfigurationWindow');
		 var restTreePnl=Ext.getCmp('restTreePnl');
		 if(!Ext.isEmpty(restTreePnl))
		 {
			 Ext.getCmp('restTreePnl').hide();
			// Ext.getCmp('restApiBackbtn').show();
			//var restPreviewBtn=Ext.getCmp('restPreviewBtnBox');
			//restPreviewBtn.show();

			
			var contArr=[];
			contArr.push({
				xtype : 'restgenerate',
				id : 'restGenCont',
				padding: '0 10 0 0',
				selectedMetrics : selectedMetrics,
				descriptorFields : descriptorFields,
				dataFieldParentNode : dataFieldParentNode,
				multipleNodes : (noOFNodesSelected>1?true:false),
				isSelectedFieldsHasTextBasedValues : isNonNumericDataType
			});
			restDashMainPnl.add({
				xtype: 'container',
				autoScroll: true,
				layout: {
					type: 'vbox',
					align:'stretch'
				},
				flex:1,
				margin: '0 0 10 10',
				id: 'apiConfigFields',
				ui: 'newTreePanelWithLines hideFolder DsTreePanel',
				cls: 'x-tree-arrows',
				name: 'restTreePnl',
				flex:1,
				items :	contArr
			 });
		 }
		 Ext.get('restApiBackbtn').show();
	},
	enableDescriptorDataRestFldSelection : function(radioGrpObj)
	{
		if(radioGrpObj.checked)
		{
			Ext.getCmp('descriptorDataRestFld').show();
		}
		else
		{
			Ext.getCmp('descriptorDataRestFld').hide();
		}
	},
	validateCheckboxSelection : function(obj,newValue,oldValue,eOpts)
	{
		var checked = obj.getValue();
		var inputElements = document.getElementsByClassName('messageCheckbox');
	
		if(checked)
		{
			for(var i=0; inputElements[i]; ++i){
			  if(!inputElements[i].checked){
				  inputElements[i].disable();
			  }
			}
		}
		else
		{
			for(var i=0; inputElements[i]; ++i){
				  inputElements[i].enable();
			}
		}
	},
	restPreviewBtn: function()
	{
		 var restDashMainPnl = Ext.getCmp('restDataConfigurationWindow');
		 var restTreePnl=Ext.getCmp('restTreePnl');
		 var restEmptyGrid=Ext.getCmp('restGenCont');
		 if(!Ext.isEmpty(restEmptyGrid)){
			Ext.getCmp('apiConfigFields').hide();
		 }
		 restDashMainPnl.remove('apiConfigFields');
		 Ext.getCmp('restPreviewBtnBox').hide();
		 var apiBackbtn = Ext.get('restApiBackbtn');
		 apiBackbtn.setVisibilityMode(Ext.Element.DISPLAY);
		 apiBackbtn.hide();
		 Ext.getCmp('restTreePnl').show();	
	},
	loadDatasetconfigWindow : function()
	{
		try
		{
		  var addDSNWinObj = Ext.widget('addnewdsn', {
			});
			
			addDSNWinObj.show();
		}
		catch (cex)
		{
			console.log("cex",cex);
		}
	},
	restHttpMethodChange : function()
	{
		var restHttpMethod=Ext.getCmp('restHttpMethod').getValue();
		if(restHttpMethod!="" && restHttpMethod=="GET")
		{
			Ext.getCmp('body_type').hide();
			Ext.getCmp('rawJsonBody').hide();
			Ext.getCmp('body_urlencoded_key').hide();
			Ext.getCmp('body_urlencoded_value').hide();
			Ext.getCmp('addBody_urlencoded').hide();
			Ext.getCmp('bodyUrlEncodedGrid').hide();
		}
		if(restHttpMethod!="" && restHttpMethod=="POST")
		{
			Ext.getCmp('body_type').show();
			var radioGrpObj=Ext.getCmp('body_type');
			var body_typeObj = radioGrpObj.getChecked();
			var body_name = body_typeObj[0].inputValue;
			if(body_name!=null && body_name=="x-www-form-urlencoded")
			{
				Ext.getCmp('rawJsonBody').hide();
				Ext.getCmp('body_urlencoded_key').show();
				Ext.getCmp('body_urlencoded_value').show();
				Ext.getCmp('addBody_urlencoded').show();
				Ext.getCmp('bodyUrlEncodedGrid').show();
			}
			else 
			{
				Ext.getCmp('rawJsonBody').show();
				Ext.getCmp('body_urlencoded_key').hide();
				Ext.getCmp('body_urlencoded_value').hide();
				Ext.getCmp('addBody_urlencoded').hide();
				Ext.getCmp('bodyUrlEncodedGrid').hide();
			}
		}
	},
	enableUserAuthenticationSettings : function(radioGrpObj)
	{
		if(radioGrpObj.checked)
		{
			Ext.getCmp('rest_username').show();
			Ext.getCmp('rest_password').show();
			Ext.getCmp('rest_header').show();
		}
		else
		{
			Ext.getCmp('rest_username').hide();
			Ext.getCmp('rest_password').hide();
			Ext.getCmp('rest_header').hide();
			
		}
	},
	enableHeaderRequiredSettings : function(radioGrpObj)
	{
		if(radioGrpObj.checked)
		{
			Ext.getCmp('key').show();
			Ext.getCmp('value').show();
			Ext.getCmp('addHeader').show();
			Ext.getCmp('header_grid').show();
		}
		else
		{
			Ext.getCmp('key').hide();
			Ext.getCmp('value').hide();
			Ext.getCmp('addHeader').hide();
			Ext.getCmp('header_grid').hide();
		}
	},
	enableParamsRequiredSettings : function(radioGrpObj)
	{
		if(radioGrpObj.checked)
		{
			Ext.getCmp('param_key').show();
			Ext.getCmp('param_value').show();
			Ext.getCmp('addParam').show();
			Ext.getCmp('param_grid').show();
		}
		else
		{
			Ext.getCmp('param_key').hide();
			Ext.getCmp('param_value').hide();
			Ext.getCmp('addParam').hide();
			Ext.getCmp('param_grid').hide();
		}
	},
	body_typeSettings : function(radioGrpObj)
	{
		var body_typeObj = radioGrpObj.getChecked();
		var body_name = body_typeObj[0].inputValue;
		if(body_name!=null && body_name=="x-www-form-urlencoded")
		{
			Ext.getCmp('rawJsonBody').hide();
			Ext.getCmp('body_urlencoded_key').show();
			Ext.getCmp('body_urlencoded_value').show();
			Ext.getCmp('addBody_urlencoded').show();
			Ext.getCmp('bodyUrlEncodedGrid').show();
		}
		else 
		{
			Ext.getCmp('rawJsonBody').show();
			Ext.getCmp('body_urlencoded_key').hide();
			Ext.getCmp('body_urlencoded_value').hide();
			Ext.getCmp('addBody_urlencoded').hide();
			Ext.getCmp('bodyUrlEncodedGrid').hide();
		}
	},
	basicAuthForm : function()
	{
		var keyobj=Ext.getCmp('rest_username');
		var valueobj=Ext.getCmp('rest_password');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var splChar = "=\"@()!^;?><:,";

		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['basicAuth_username_alert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['basicAuth_password_alert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if(key!="" || key!=null)
		{
			for ( var i = 0; i < key.length; i++)
			{
				check_char = splChar.indexOf(key.charAt(i))
				if (check_char >= 0) {
					Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: key+' '+screenLabelsObj['invalidHTTPHeaderAlert'],
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		}
		return true;
	},
	addBasicAuth : function()
	{
		var validationResult=this.basicAuthForm();
		if(validationResult)
		{
			var keyobj=Ext.getCmp('rest_username');
			var valueobj=Ext.getCmp('rest_password');
			var key=keyobj.getValue();
			var value=valueobj.getValue();
			var auth=btoa(key+':'+value);
			var gridObj = this.getRESTHeaderGrid();
			var gridStore = gridObj.getStore();
			var configuredData = [];
			configuredData.push({
				key : "Authorization",
				value : "Basic "+auth
			});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
			Ext.getCmp('key').show();
			Ext.getCmp('value').show();
			Ext.getCmp('addHeader').show();
			Ext.getCmp('header_grid').show();
		}
	},
	addHeader : function()
	{
		var keyobj=Ext.getCmp('key');
		var valueobj=Ext.getCmp('value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var validationResult=this.headerValForm();
		if(validationResult)
		{
			var gridObj = this.getRESTHeaderGrid();
			var gridStore = gridObj.getStore();
			var configuredData = [];
			configuredData.push({
				key : key,
				value : value
			});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
		}
	},
	addReqParamValidateForm : function()
	{
		var keyobj=Ext.getCmp('param_key');
		var valueobj=Ext.getCmp('param_value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		
		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['paramNameAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['paramValueAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		return true;
	},
	addParam : function()
	{
		var validationResult=this.addReqParamValidateForm();
		if(validationResult)
		{
			var keyobj=Ext.getCmp('param_key');
			var valueobj=Ext.getCmp('param_value');
			var key=keyobj.getValue();
			var value=valueobj.getValue();
			var gridObj = this.getRESTParamsGrid();
			var gridStore = gridObj.getStore();
			var configuredData = [];
			configuredData.push({
				key : key,
				value : value
			});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
		}
	},
	headerValForm : function()
	{
		var keyobj=Ext.getCmp('key');
		var valueobj=Ext.getCmp('value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		var splChar = "=\"@()!^;?><:,";

		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['headerParamAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['headerValueAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if(key!="" || key!=null)
		{
			for ( var i = 0; i < key.length; i++)
			{
				check_char = splChar.indexOf(key.charAt(i))
				if (check_char >= 0) {
					Ext.Msg.show({
					title: screenLabelsObj['DSNTitle'],
					msg: key+' '+screenLabelsObj['invalidHTTPHeaderAlert'],
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		}
		return true;
	},
	addBody_urlencoded : function()
	{
		var validationResult=this.bodyValForm();
		if(validationResult)
		{
			var keyobj=Ext.getCmp('body_urlencoded_key');
			var valueobj=Ext.getCmp('body_urlencoded_value');
			var key=keyobj.getValue();
			var value=valueobj.getValue();
			var validationResult=true;
			if(key!=null && key!="" && value!=null && value!="")
			{
				var gridObj = this.getRESTBodyUrlEncodedGrid();
				var gridStore = gridObj.getStore();
				var configuredData = [];
				configuredData.push({
					key : key,
					value : value
				});
					gridStore.add(configuredData);
					gridObj.doLayout();
					keyobj.reset();
					valueobj.reset();
			}
		}
	},
	bodyValForm : function()
	{
		var keyobj=Ext.getCmp('body_urlencoded_key');
		var valueobj=Ext.getCmp('body_urlencoded_value');
		var key=keyobj.getValue();
		var value=valueobj.getValue();
		
		if(key==null || key=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['bodyParamAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if( value==null || value=="")
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['bodyParamValueAlert'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		return true;
	},
	getData : function(btnObj)
	{
		var validationResult=this.valForm();
		if(!validationResult)
		{
			return;
		}
		var restdsnnameObj=Ext.getCmp('restdsnname');
		this.getResponseForRestURL(btnObj,restdsnnameObj,false);
		
	},
	getResponseForRestURL : function(btnObj,compObj,enableDataColumnSelection)
	{
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var selectedDSN='';
		if(compObj!=null && compObj.id=='restdsnname')
		{
			selectedDSN=compObj.getValue();
		}
		btnObj.setDisabled(true);
		var meC=this;

		var restdsnnameObj=Ext.getCmp('restdsnname');
		var restdsnname=restdsnnameObj.getValue();
		var urltextboxObj=Ext.getCmp('urltextbox');
		var restURL=urltextboxObj.getValue();
		var restPortNo=Ext.getCmp('restPortNo').getValue();
		var restHttpMethod=Ext.getCmp('restHttpMethod').getValue();
		var radioGrpObj=Ext.getCmp('body_type');
		var body_typeObj = radioGrpObj.getChecked();
		var body_name = body_typeObj[0].inputValue;
		var rawJsonBodyObj=Ext.getCmp('rawJsonBody');
		var rawBody=rawJsonBodyObj.getValue();
		var rawJsonBody="";
		var bodyUrlEncodedGridObj = this.getRESTBodyUrlEncodedGrid();
		var bodyUrlEncodedGridStore = bodyUrlEncodedGridObj.getStore();
		var configuredBodyUrlEncoded = '';
		var selectedBodyType = '';
		if(restHttpMethod == "POST")
		{
			selectedBodyType = body_name;
			if(body_name!=null && body_name=="x-www-form-urlencoded")
			{
				var  bodyUrlEncodedGridCount = bodyUrlEncodedGridObj.getStore().getCount();
				for ( var i = 0; i < bodyUrlEncodedGridCount; i++) {
					var key = bodyUrlEncodedGridObj.getStore().getAt(i).get('key');
					var value = bodyUrlEncodedGridObj.getStore().getAt(i).get('value');
					var bodyData=key+"$!$"+value;
					configuredBodyUrlEncoded=configuredBodyUrlEncoded+'!^!'+bodyData;
				}
				if (configuredBodyUrlEncoded != null && configuredBodyUrlEncoded.indexOf("!^!") == 0) {
					configuredBodyUrlEncoded = configuredBodyUrlEncoded.substring(3);
				}
			}
			else
			{
				if(rawBody!=null && rawBody!="")
				{
					var rawBodyJson = JSON.parse(rawBody);
					rawJsonBody=JSON.stringify(rawBodyJson);
				}
			}
		}
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredHeaders='';
		var gridRecordCount = gridObj.getStore().getCount();
		for ( var i = 0; i < gridRecordCount; i++) {
			var key = gridObj.getStore().getAt(i).get('key');
			var value = gridObj.getStore().getAt(i).get('value');
			var header=key+"$!$"+value;
			configuredHeaders=configuredHeaders+'!^!'+header;
		}

		//var authRequiredObj=Ext.getCmp('User_Authentication_Required');
		var rest_usernameObj=Ext.getCmp('rest_username');
		var rest_passwordObj=Ext.getCmp('rest_password');
		if(!Ext.isEmpty(rest_usernameObj) && !Ext.isEmpty(rest_passwordObj))
		{
			var rest_username=rest_usernameObj.getValue();
			var password=rest_passwordObj.getValue();
			var auth=btoa(rest_username+':'+password);
			var authHeader="Authorization"+"$!$"+"Basic "+auth;
			configuredHeaders=configuredHeaders+'!^!'+authHeader;
		}

		if (configuredHeaders != null && configuredHeaders.indexOf("!^!") == 0) {
			configuredHeaders = configuredHeaders.substring(3);
		}
		var paramGridObj = this.getRESTParamsGrid();
		var paramGridStore = paramGridObj.getStore();
		var configuredParams='';
		var paramGridRecordCount = paramGridStore.getCount();
		for ( var i = 0; i < paramGridRecordCount; i++) {
			var paramKey = paramGridStore.getAt(i).get('key');
			var paramValue = paramGridStore.getAt(i).get('value');
			var params=paramKey+"="+paramValue;
			configuredParams=configuredParams+'&'+params;
		}
		if (configuredParams != null && configuredParams.indexOf("&") == 0) {
			configuredParams = configuredParams.substring(1);
		}

		if (configuredParams != null && configuredParams != "") {
			if (restURL != null && restURL.indexOf("?") >= 0) {
				restURL = restURL.substring(0,restURL.indexOf('?'));
			}
			restURL = restURL+"?"+configuredParams;
			urltextboxObj.setValue(restURL);
		}
		
		var paramsForRestURL='action=loadDataForConfigWindow&restDSNName='+encodeURIComponent(filterEncode(restdsnname))+'&restWS_URL='+encodeURIComponent(filterEncode(restURL))+'&restWS_Port='+encodeURIComponent(restPortNo)+'&httpMethod='+encodeURIComponent(restHttpMethod)+'&configuredHeaders='+encodeURIComponent(filterEncode(configuredHeaders))+'&selectedBodyType='+encodeURIComponent(filterEncode(selectedBodyType))+'&rawJsonBody='+encodeURIComponent(filterEncode(rawJsonBody))+'&configuredBodyUrlEncoded='+encodeURIComponent(filterEncode(configuredBodyUrlEncoded));//+'&restWS_Fields='+encodeURIComponent(selectedFields)+'&dataFieldParentNode='+encodeURIComponent(dataFieldParentNode);

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: restDataLoadingMsg+'...'});
		tmpMask.show();

		Ext.Ajax.request({
					url : '/final/admin/ICTest/data/EgAddRESTTestp.jsp',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData=Ext.decode(jsonText);
							restDashMainPnl=Ext.getCmp('dsnSettingspopup');
							var rootNode = {};
							rootNode["expanded"]="true";
							rootNode["children"]=jsonData['jsonkeys']['restTree'];
							restDashMainPnl.remove('restTreePnl');
							Ext.EventManager.removeAll('restTreePnl');
							restDashMainPnl.remove('restfieldmappingpnl');
							Ext.EventManager.removeAll('restfieldmappingpnl');
							var tabview= Ext.getCmp('dsnConfigCont').hide();
							var dataTypeMapping = {};
							var restPreviewBtn=Ext.getCmp('restPreviewBtnBox');
							restPreviewBtn.show();
							btnObj.setDisabled(false);
							if(!Ext.isEmpty(rootNode.children))
							{
								 var contArr= new Array();
								 contArr.push({
									xtype: 'treescrollPanel',
									rootVisible: false,
									width:"100 px",
									height:300,
									ui:"newTreePanelWithLines",
									id:'treeP',
									store: Ext.create('Ext.data.TreeStore', {
											root: rootNode
									}),
									restTreeNodeData : jsonData['jsonkeys']['restTreeNodeData'],
									restTreeNodeFields : jsonData['jsonkeys']['resTreeNodefields'],
									listeners:
									{
										select: function (node, record, index, eOpts)
										{
											var fldsArr=[];
											var saveField=Ext.getCmp('saveFldsBtn');
											var restGridData=jsonData['jsonkeys']['restGrid'][record.raw.jPath];
											var gridCols=restGridData['gridCols'];
											var gridData=restGridData['gridData'];
											var colsArr = [];
											var fields2Store = [];
											var filtersArr = [];
											for ( var colVal in gridCols) {
												var colName = gridCols[colVal].toString();
												fields2Store.push({
													name : colName,
													type : 'string'
												});
												var flex1= 0.14;
												var colHdrContent='',colHrdClass='';
												if(enableDataColumnSelection)
												{
													colHdrContent="<span class='newFont_normal11 DsWrapText' style='display:block;' data-qtip='" + colName + "'><label class='dsCustomCheckBox' style='margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='"+colName+"' ><span class='labelCheckBOx'></span></label></span>";
													colHrdClass='x-grid-checkheader-editor';
												}
												else
												{
													colHdrContent="<span class='newFont_normal11 DsWrapText' style='display:block;' data-qtip='" + colName + "'>"+colName+"</span>";
												}

												colsArr.push({
														header : colHdrContent,
														dataIndex : colName,
														sortable: false,
														flex : 1,
														tdCls: 'DsWrapText',
														cls: colHrdClass,
														renderer : function(value, metaData, record, row, col, store, gridView) {
															 var value = '<span class="newFont_normal11 DsWrapText"  data-qtip="' + value + '">' + value + '</span>';
															return value;
														}
															
													});
											}
											var gridObj = Ext.getCmp('restDataGrid');
											gridObj.getStore().removeAll();
											var storeVal1 = Ext.create('Ext.data.Store',{
												fields:fields2Store,
												data:gridData
											});
											gridObj.reconfigure(storeVal1,colsArr);
											gridObj.dataFieldParentNode=record.raw.jPath;
											restDashMainPnl.dataTypeMapping=restGridData['dataTypeMapping'];
											gridObj.show();
											gridObj.view.refresh();
										}
									}
									});
									contArr.push({
											xtype : 'RESTDataGrid',
											flex:2.35,
											padding: 0,
											cls:'restGridPreview',
											tdCls: 'DsWrapText',
											margin: 0,			
										id : 'restDataGrid',
										hidden  : false
									});
									restDashMainPnl.add({
														xtype: 'panel',
														title: '<span class="font_bold11">Data Field Configuration</span>',
														autoScroll: true,
														layout: {
															type: 'hbox',
															align:'stretch'
														},
														margin: '0 15 0 20',
														id: 'restTreePnl',
														ui: 'newTreePanelWithLines hideFolder DsTreePanel',
														cls: 'x-tree-arrows',
														name: 'restTreePnl',
														flex:1,
														items :	contArr,
														dockedItems: [{
																xtype: 'toolbar',
																dock: 'bottom',
																items: ['->',{
																	xtype: 'button',
																	id: 'createDSN',
																	name: 'createDSN',
																	margin: '20 0 0 0',
																	width: 106,
																	height: 27,
																	cls: 'button20 restBgButton',
																	text: '<span class="newFont_normal14" style="color:#ffffff;line-height:26px;">Save DSN</span>',
																	tooltip: 'click here to Add',
																},'->']
														}]
												});
										
							}
							else
							{
								restDashMainPnl.add({
									xtype : 'container',
									id:'restEmptyGrid',
									flex:1,
									html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">No Data Available!</div></div></div>'
								});
							}
							tmpMask.hide();
						}
					},
					failure : function(response, opts) {
						tmpMask.hide();
					}
		  });
	},
	dsnBackBtn : function()
	{
		var restTree=Ext.getCmp('restTreePnl');
		if(!Ext.isEmpty(restTree))
		{
			restTree.hide();
		}
	},
	valForm : function()
	{
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var urltextboxObj=Ext.getCmp('urltextbox');
		var rawJsonBodyObj=Ext.getCmp('rawJsonBody');
		var rawJsonBody=rawJsonBodyObj.getValue();
		var restdsnname=restdsnnameObj.getValue();
		var url=urltextboxObj.getValue();
		var splChar = "%&+=\"?#:$!^~";
		var headerSplChar = "=\"@()!^;?><:,";
		var re = /^(http[s]?:\/\/){0,1}(www\.){0,1}[a-zA-Z0-9\.\-]+\.[a-zA-Z]{2,5}[\.]{0,1}/;
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredHeaders='';
		var gridRecordCount = gridObj.getStore().getCount();
		
		if(restdsnname=="" || restdsnname==null)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['emptyDSNAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
				});
			return false;
		}
		if(restdsnname!="" || restdsnname!=null)
		{
		for ( var i = 0; i < restdsnname.length; i++) {
			check_char = splChar.indexOf(restdsnname.charAt(i))
			// Returns value 1 if the special character listed
			if (check_char >= 0) {
				Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['specialCharsDSNAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
				});
				return false;
			}
		}
		}
		if(url=="" || url==null)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['emptyRESTURLAlertMsg'],
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
				});
			return false;
		}
		if(gridRecordCount>0)
		{
			for ( var i = 0; i < gridRecordCount; i++) 
				{
						var key = gridObj.getStore().getAt(i).get('key');
						if(key!="" || key!=null)
						{
						for ( var j = 0; j < key.length; j++) {
							check_char = headerSplChar.indexOf(key.charAt(j))
							// Returns value 1 if the special character listed
							if (check_char >= 0) {
								Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: key+' '+screenLabelsObj['invalidHTTPKeyAlertMsg'],
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
								});
								return false;
							}
						}
						}
				}
		}
		if(rawJsonBody!="" && rawJsonBody!=null)
		{
			try {
				var rawBodyJson = JSON.parse(rawJsonBody);
			} catch (e) {
				Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: screenLabelsObj['invalidJSONyAlertMsg'],
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
								});
				return false;
			}
		}
	return true;
	},
	saveRESTDSN : function(buttonObj)
	{	
		var meC=this;
		var validationResult=this.valForm();
		if(validationResult)
		{
			buttonObj.setDisabled(true);
		var dsnListContObj=Ext.getCmp('dsnListCont');
		var restdsnnameObj=Ext.getCmp('restdsnname');
		var restdsnname=restdsnnameObj.getValue();
		var txtFieldObj=Ext.getCmp('urltextbox');
		var restURL=txtFieldObj.getValue();
		var restPortNo=Ext.getCmp('restPortNo').getValue();
		var restHttpMethod=Ext.getCmp('restHttpMethod').getValue();
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var radioGrpObj=Ext.getCmp('body_type');
		var body_typeObj = radioGrpObj.getChecked();
		var body_name = body_typeObj[0].inputValue;
		var rawJsonBodyObj=Ext.getCmp('rawJsonBody');
		var rawBody=rawJsonBodyObj.getValue();
		var rawJsonBody="";
		var bodyUrlEncodedGridObj = this.getRESTBodyUrlEncodedGrid();
		var bodyUrlEncodedGridStore = bodyUrlEncodedGridObj.getStore();
		var configuredBodyUrlEncoded = '';
		var selectedBodyType = '';
		if(restHttpMethod == "POST")
		{
			selectedBodyType = body_name;
			if(body_name!=null && body_name=="x-www-form-urlencoded")
			{
				var  bodyUrlEncodedGridCount = bodyUrlEncodedGridObj.getStore().getCount();
				for ( var i = 0; i < bodyUrlEncodedGridCount; i++) {
					var key = bodyUrlEncodedGridObj.getStore().getAt(i).get('key');
					var value = bodyUrlEncodedGridObj.getStore().getAt(i).get('value');
					var bodyData=key+"$!$"+value;
					configuredBodyUrlEncoded=configuredBodyUrlEncoded+'!^!'+bodyData;
				}
				if (configuredBodyUrlEncoded != null && configuredBodyUrlEncoded.indexOf("!^!") == 0) {
					configuredBodyUrlEncoded = configuredBodyUrlEncoded.substring(3);
				}
			}
			else
			{
				if(rawBody!=null && rawBody!="")
				{
					var rawBodyJson = JSON.parse(rawBody);
					rawJsonBody=JSON.stringify(rawBodyJson);
				}
			}
		}
		var gridObj = this.getRESTHeaderGrid();
		var gridStore = gridObj.getStore();
		var configuredHeaders='';
		var gridRecordCount = gridObj.getStore().getCount();
		for ( var i = 0; i < gridRecordCount; i++) {
			var key = gridObj.getStore().getAt(i).get('key');
			var value = gridObj.getStore().getAt(i).get('value');
			var header=key+"$!$"+value;
			configuredHeaders=configuredHeaders+'!^!'+header;
		}
		var basicAuthCredentials="";
		//var authRequiredObj=Ext.getCmp('User_Authentication_Required');
		//if(authRequiredObj.checked)
		
		var rest_usernameObj=Ext.getCmp('rest_username');
		var rest_passwordObj=Ext.getCmp('rest_password');
		if(!Ext.isEmpty(rest_usernameObj) && !Ext.isEmpty(rest_passwordObj))
		{
			var rest_username=rest_usernameObj.getValue();
			var password=rest_passwordObj.getValue();
			if(!Ext.isEmpty(rest_username) && !Ext.isEmpty(password))
			{
				basicAuthCredentials="&basicAuth_Username="+encodeURIComponent(rest_username)+"&basicAuth_pwd="+encodeURIComponent(password);
			}
		//	var auth=btoa(rest_username+':'+password);
			//var authHeader="Authorization"+"$!$"+"Basic "+auth;
			//configuredHeaders=configuredHeaders+'!^!'+authHeader;
		}

		if (configuredHeaders != null && configuredHeaders.indexOf("!^!") == 0) {
			configuredHeaders = configuredHeaders.substring(3);
		}
		var configuredParams='';
		var authRequiredObj=Ext.getCmp('params_Required');
		if(authRequiredObj.checked)
		{
			var restParamsGridObj = this.getRESTParamsGrid();
			var paramsGridStore = restParamsGridObj.getStore();
			var configuredHeaders='';
			var gridRecordCount = paramsGridStore.getCount();
			for ( var i = 0; i < gridRecordCount; i++) {
				var key = paramsGridStore.getAt(i).get('key');
				var value = paramsGridStore.getAt(i).get('value');
				var reqParam=key+"$!$"+value;
				configuredParams=configuredParams+'!^!'+reqParam;
			}
			if (configuredParams != null && configuredParams.indexOf("!^!") == 0) {
				configuredParams = configuredParams.substring(3);
			}
		}
		restURL=meC.filterEncode(restURL);
		configuredHeaders=meC.filterEncode(configuredHeaders);
		rawJsonBody=meC.filterEncode(rawJsonBody);
		configuredBodyUrlEncoded=meC.filterEncode(configuredBodyUrlEncoded);

		var testName = Ext.getCmp('test').getValue();
		var paramsForRestURL='restDSNName='+encodeURIComponent(filterEncode(restdsnname))+'&restWS_URL='+encodeURIComponent(filterEncode(restURL))+'&restWS_Port='+encodeURIComponent(restPortNo)+'&httpMethod='+encodeURIComponent(restHttpMethod)+'&action=saveRESTDSN&configuredHeaders='+encodeURIComponent(filterEncode(configuredHeaders))+'&selectedBodyType='+encodeURIComponent(selectedBodyType)+'&rawJsonBody='+encodeURIComponent(filterEncode(rawJsonBody))+'&configuredBodyUrlEncoded='+encodeURIComponent(filterEncode(configuredBodyUrlEncoded))+'&test='+encodeURIComponent(testName);

		if (!Ext.isEmpty(configuredParams))
		{
			configuredParams=meC.filterEncode(configuredParams);
			paramsForRestURL=paramsForRestURL+'&configuredParams='+encodeURIComponent(configuredParams);
		}

		if(!Ext.isEmpty(basicAuthCredentials))
		{
			basicAuthCredentials=meC.filterEncode(basicAuthCredentials);
			paramsForRestURL=paramsForRestURL+basicAuthCredentials;
		}

		var authTypeValueObj = Ext.getCmp('authType');
		
		if(!Ext.isEmpty(authTypeValueObj))
		{
			var selectedAuthTyp=authTypeValueObj.getValue();
			paramsForRestURL=paramsForRestURL+'&authType='+encodeURIComponent(selectedAuthTyp);
			if(selectedAuthTyp == 'APIKey')
			{
				var apiKeyNameObj=Ext.getCmp('apiKeyName');
				if(!Ext.isEmpty(apiKeyNameObj))
				{
					var apiKey=apiKeyNameObj.getValue();
					apiKey=meC.filterEncode(apiKey);
					paramsForRestURL=paramsForRestURL+'&configuredAPIKey='+encodeURIComponent(apiKey);
				}

				var apiKeyValueObj=Ext.getCmp('apiKeyValue');
				if(!Ext.isEmpty(apiKeyValueObj))
				{
					var apiKeyValue=apiKeyValueObj.getValue();
					apiKeyValue=meC.filterEncode(apiKeyValue);
					paramsForRestURL=paramsForRestURL+'&configuredAPIValue='+encodeURIComponent(apiKeyValue);
				}

				var apiKeyAddToObj=Ext.getCmp('apiKeyAddTo');
				if(!Ext.isEmpty(apiKeyAddToObj))
				{
					var addToOpt=apiKeyAddToObj.getValue();
					paramsForRestURL=paramsForRestURL+'&configuredAddAPIKeyOpt='+encodeURIComponent(addToOpt);
				}
			}
			else if(selectedAuthTyp == 'BearerToken')
			{
				var bearerTokObj=Ext.getCmp('bearerTokenValue');
				if(!Ext.isEmpty(bearerTokObj))
				{
					var bearerTokValue=bearerTokObj.getValue();
					bearerTokValue=meC.filterEncode(bearerTokValue);
					paramsForRestURL=paramsForRestURL+'&configuredBearerToken='+encodeURIComponent(bearerTokValue);
				}
				else
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['bearerTokenAlert'],
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					false;
				}
			}
			else if(selectedAuthTyp == 'OAuth2.0')
			{
				var oAuth2GrantType=Ext.getCmp('oAuth2GrantType').getValue();
				var accessTokenURL=Ext.getCmp('accessTokenURL').getValue();
				var oAuth2ClientID=Ext.getCmp('oAuth2ClientID').getValue();
				var oAuth2ClientSecret=Ext.getCmp('oAuth2ClientSecret').getValue();
				var oAuth2Scope=Ext.getCmp('oAuth2Scope').getValue();
				var oAuth2ClientAuth=Ext.getCmp('oAuth2ClientAuth').getValue();

				paramsForRestURL=paramsForRestURL+'&oAuth2GrantType='+encodeURIComponent(oAuth2GrantType);

				if(!Ext.isEmpty(accessTokenURL))
				{
					if(accessTokenURL!=null && accessTokenURL.indexOf("https")==-1 && accessTokenURL.indexOf("http")==-1)
					{
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: screenLabelsObj['accessTokenValidURLAlert'],
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						false;
					}

					accessTokenURL=meC.filterEncode(accessTokenURL);
					paramsForRestURL=paramsForRestURL+'&accessTokenURL='+encodeURIComponent(accessTokenURL);
				}
				else
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['accessTokenURLAlert'],
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					false;
				}

				if(!Ext.isEmpty(oAuth2ClientID))
				{
					oAuth2ClientID=meC.filterEncode(oAuth2ClientID);
					paramsForRestURL=paramsForRestURL+'&oAuth2ClientID='+encodeURIComponent(oAuth2ClientID);
				}
				else
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['clientIDAlert'],
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					false;
				}

				if(!Ext.isEmpty(oAuth2ClientSecret))
				{
					oAuth2ClientSecret=meC.filterEncode(oAuth2ClientSecret);
					paramsForRestURL=paramsForRestURL+'&oAuth2ClientSecret='+encodeURIComponent(oAuth2ClientSecret);
				}
				else
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['clientSecretAlert'],
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					false;
				}

				if(!Ext.isEmpty(oAuth2Scope))
				{
					oAuth2Scope=meC.filterEncode(oAuth2Scope);
					paramsForRestURL=paramsForRestURL+'&oAuth2Scope='+encodeURIComponent(oAuth2Scope);
				}
				else
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['oAuth2ScopeAlert'],
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					false;
				}

				if(!Ext.isEmpty(oAuth2ClientAuth))
				{
					oAuth2ClientAuth=meC.filterEncode(oAuth2ClientAuth);
					paramsForRestURL=paramsForRestURL+'&oAuth2ClientAuth='+encodeURIComponent(oAuth2ClientAuth);
				}
				
				
				if(oAuth2GrantType!=null && oAuth2GrantType=='Password_Credentials')
				{
					var oAuth2Username=Ext.getCmp('oAuth2Username').getValue();
					var oAuth2Pwd=Ext.getCmp('oAuth2Pwd').getValue();

					if(!Ext.isEmpty(oAuth2Username))
					{
						oAuth2Username=meC.filterEncode(oAuth2Username);
						paramsForRestURL=paramsForRestURL+'&oAuth2Username='+encodeURIComponent(oAuth2Username);
					}
					else
					{
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: screenLabelsObj['basicAuth_username_alert'],
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						false;
					}

					if(!Ext.isEmpty(oAuth2Pwd))
					{
						oAuth2Pwd=meC.filterEncode(oAuth2Pwd);
						paramsForRestURL=paramsForRestURL+'&oAuth2Pwd='+encodeURIComponent(oAuth2Pwd);
					}
					else
					{
						Ext.Msg.show({
							title: screenLabelsObj['DSNTitle'],
							msg: screenLabelsObj['basicAuth_password_alert'],
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						false;
					}
				}
			}
		}

		Ext.Msg.show({
		title: pageTitle1,
		msg: screenLabelsObj['validateAPIConfiguration'],
		buttons: Ext.Msg.YESNO,
		icon: 'iconConfirmation',
		fn: function(response) {
			if(response === 'yes')
			{
				paramsForRestURL=paramsForRestURL+'&validateRESTResponse=yes';
				meC.updateDSNConfiguration(paramsForRestURL,buttonObj,restdsnname,true);
			}
			else
			{
				meC.updateDSNConfiguration(paramsForRestURL,buttonObj,restdsnname,false);
			}
		}});
		}
	},
	updateDSNConfiguration : function(paramsForRestURL,buttonObj,restdsnname,validateAPI)
	{
		try
		{
			var apiLoadingMsg=plsWait;
			var restAPISaveMsg=screenLabelsObj['restAPISaveMsg'];
			if(validateAPI)
			{
				apiLoadingMsg=restValidateLoadingMsg;
				restAPISaveMsg=screenLabelsObj['restAPIValidateSaveMsg'];
			}

			var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: apiLoadingMsg+'...'});
				tmpMask.show();

				Ext.Ajax.request({
					url : '/final/admin/ICTest/data/EgAddRESTTestp.jsp',
				method : 'POST',
				params : paramsForRestURL,
				scope : this,
				success : function(response) {
					
					Ext.getCmp('getData').enable();
					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') {
						var jsonData=Ext.decode(jsonText);
						
						var datasetconfigurationObj=Ext.getCmp('datasetconfiguration');
						tmpMask.hide();
						buttonObj.setDisabled(false);
						if(!Ext.isEmpty(jsonData))
						{
							var errorMsg=jsonData['errorMsg'];
							if(!Ext.isEmpty(errorMsg) && errorMsg!="-")
							{
									Ext.Msg.show({
											title: screenLabelsObj['DSNTitle'],
											msg: screenLabelsObj['connectFailureMsg'],
											buttons: Ext.MessageBox.OK,
									});
											return;
							}
							else
							{
								datasetconfigurationObj.removeAll();
								var win = Ext.getCmp('dsnSettingspopup');
								win.close();
								Ext.Msg.show({
									title: screenLabelsObj['DSNTitle'],
									msg: restAPISaveMsg,
									buttons: Ext.MessageBox.OK,
									});
							}
							var dsnItmArr=[];
							var dsnconfigDetailsArr=jsonData['dsnConfigDetailsArr'];
							datasetconfigurationObj.add(
								{
									xtype: 'panel',
										flex:1,
										layout: {
										type: 'vbox',
										align: 'stretch'
									}},
							{
								xtype: 'dataview',
								margin: '10 10 10 10',
								store : Ext.data.Store({
									fields : [ 'displayName','key','value','childTabHeaders'],
									data : dsnconfigDetailsArr
								}),
								jsonData : dsnconfigDetailsArr,
								itemSelector: 'div.thumb-wrap',
								tpl: new Ext.XTemplate(
								'<div class="newTable">',
									'<table border="1"  width="100%">',
										'<tr ><th colspan="2" class="Ictesttableheader" >',
												'<div  style="display:inline-block; margin: 3px 0 0 0;">'+screenLabelsObj['API_Configuration']+'</div>',
													'<div style="float:right;" ><a href="javascript:void(0)" class="iconModify" style="display:inline-block;" onclick="javascript:editAPIConfiguration(this,\''+restdsnname+'\',true)"  title="'+screenLabelsObj['Edit_API_Tooltip']+'"><img src="/final/images/Light/edit.png"/></a>',
												'</div>',
											'</th>',
										'</tr>',
										'<tpl for=".">',
											'<tpl if="key===\'ConfiguredHeaders\' || key===\'ConfiguredBodyUrlEncoded\' || key===\'configuredParams\'" >',
												'<tr>',
													'<td>{displayName} </td>',
													'<td>',
														'<table border="0" align="left" width="100%">',
															'<tr>',
															'<tpl for="childTabHeaders">',
																	'<th class="table_head" style="border-top:0px;padding:4px;padding-left:10px !important;text-align: start;">',
																		'{headerName}',
																	'</th>',
															'</tpl>',
															'</tr>',
															'<tpl for="value">',
																'<tr>',
																	'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																		'{childTabKey}',
																	'</td>',
																	'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																		'{childTabValue}',
																	'</td>',
																'</tr>',
															'</tpl>',
														'</table>',
													'</td>',
												'</tr>',
											'<tpl else>',
												'<tr>',
													'<td>{key} </td>',
													'<td>{value} </td>',
												'</tr>',
											'</tpl>',
										'</tpl>',
									'</table>',
								'</div>'
								)
							
							});
							datasetconfigurationObj.doLayout();
						}
					}
					else
					{
						tmpMask.hide();
							Ext.Msg.show({
								title: screenLabelsObj['DSNTitle'],
								msg: screenLabelsObj['connectFailureMsg'],
								buttons: Ext.MessageBox.OK,
						});
					}
				},
				failure : function()
				{
					buttonObj.setDisabled(false);
					tmpMask.hide();
				}
			});
		}
		catch (cp)
		{
			console.log("cp---->",cp);
		}
	},
	setMeasureRESTField : function()
	{	
		var dsnListContObj=Ext.getCmp('dsnListCont');
		var restDashMainPnl=Ext.getCmp('dsnSettingspopup');
		var descriptorDataRestFld=Ext.getCmp('restdatafld');
		var isDescriptorDataField=false;
		if(Ext.isEmpty(descriptorDataRestFld))
		{
			descriptorDataRestFld=Ext.getCmp('descriptorDataRestFld');
			isDescriptorDataField=true;
		}
		var dataFieldMapping='';
		var checkedValue = [];
		var selectedFields="";
		var dataFieldParentNode='';
		var inputElements = document.getElementsByClassName('messageCheckbox');
		var dataTypeMapping='';
		if(restDashMainPnl!=null && restDashMainPnl.hasOwnProperty('dataTypeMapping'))
		{
			dataTypeMapping=restDashMainPnl.dataTypeMapping;
		}
		var chkCount=0;
		var isMoreThanOneDataColumnSelected=false;
		var isNonNumericDataType=false;
		for(var i=0; inputElements[i]; ++i){
			  if(inputElements[i].checked){
				  if(chkCount>0)
				  {
					  isMoreThanOneDataColumnSelected=true;
					  break;
				  }
				var selectedDataFld=inputElements[i].value;
				selectedFields = selectedFields+","+selectedDataFld;
				 if(dataTypeMapping!=null && dataTypeMapping.hasOwnProperty(selectedDataFld))
				  {
					  var dataTyp=dataTypeMapping[inputElements[i].value];
					  if(!isDescriptorDataField && (dataTyp!=null && dataTyp!="Number"))
					  {
						  isNonNumericDataType=true;
					  }
					  if(!Ext.isEmpty(dataTyp))
					  {
						   dataFieldMapping+="^_^"+selectedDataFld+"^:^"+dataTyp;
					  }
					  else
					  {
						  dataFieldMapping+="^_^"+selectedDataFld+"^:^String";
					  }
				  }
				  chkCount++;
			  }
		}
		if (selectedFields != null && selectedFields.indexOf(",")==0) {
					selectedFields = selectedFields.substring(1);
		}
		if(isMoreThanOneDataColumnSelected)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['selectOneFieldAlert'],
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		if(selectedFields==null || selectedFields=='')
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['selectFieldsAlert'],
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		/*else if(!isDescriptorDataField && isNonNumericDataType)
		{
			Ext.Msg.show({
				title: screenLabelsObj['DSNTitle'],
				msg: screenLabelsObj['validMeasureDataFieldMsg'],
				buttons: Ext.MessageBox.OK
			});
			return;
		}*/
		if(dataFieldMapping!=null && dataFieldMapping.indexOf("^_^")>-1)
		{
			dataFieldMapping=dataFieldMapping.substring(dataFieldMapping.indexOf("^_^")+3,dataFieldMapping.length);
		}
		
		dataFieldParentNode=descriptorDataRestFld.dataFieldParentNode;
		descriptorDataRestFld.setValue(selectedFields);
		descriptorDataRestFld.dataFieldParentNode=dataFieldParentNode;
		if(!Ext.isEmpty(dataFieldMapping))
		{
			descriptorDataRestFld.dataFieldMapping=dataFieldMapping;
		}
		restDashMainPnl.close();
	},
	loadDatasetTab : function()
	{
		isRESTTestType=true;
		var testName = Ext.getCmp('test').getValue();
		var paramsForRestURL='action=loadDSNConfiguration&test='+encodeURIComponent(testName);
		Ext.Ajax.request({
					url : '/final/admin/ICTest/data/EgAddRESTTestp.jsp',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {

						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData=Ext.decode(jsonText);
							var datasetconfigurationObj=Ext.getCmp('datasetconfiguration');
							if(!Ext.isEmpty(jsonData))
							{
								datasetconfigurationObj.removeAll();
								var errorMsg=jsonData['errorMsg'];
								if(errorMsg!=null && errorMsg=="-")
								{
									var dsnArr=jsonData['dsnArr'];
									var dsnItmArr=[];
									for(var ds in dsnArr)
									{
										var dsnObj=dsnArr[ds];
										var dsnconfigDetailsArr=dsnObj['configDetails'];

										datasetconfigurationObj.add(
											{
												xtype: 'panel',
													flex:1,
													layout: {
													type: 'vbox',
													align: 'stretch'
												}},
										{
											xtype: 'dataview',
											margin: '10 10 10 10',
											store : Ext.data.Store({
												fields : [ 'displayName','key','value','childTabHeaders'],
												data : dsnconfigDetailsArr
											}),
											jsonData : dsnconfigDetailsArr,
											itemSelector: 'div.thumb-wrap',
											tpl: new Ext.XTemplate(
											'<div class="newTable">',
												'<table border="1"  width="100%">',
													'<tr ><th colspan="2" class="Ictesttableheader" >',
															'<div  style="display:inline-block; margin: 3px 0 0 0;">'+screenLabelsObj['API_Configuration']+'</div>',
															'<div style="float:right;" ><a href="javascript:void(0);" class="" style="display:inline-block;" onclick="javascript:editAPIConfiguration(this,\''+dsnObj['dsnName']+'\',true)" title="'+screenLabelsObj['Edit_API_Tooltip']+'"><img src="/final/images/Light/edit.png" /></a>',
													'</div>',
														'</th>',
													'</tr>',
													'<tpl for=".">',
														'<tpl if="key===\'ConfiguredHeaders\' || key===\'ConfiguredBodyUrlEncoded\' || key===\'configuredParams\'" >',
															'<tr>',
																'<td>{displayName}</td>',
																'<td>',
																	'<table border="0" align="left" width="100%">',
																		'<tr>',
																		'<tpl for="childTabHeaders">',
																				'<th class="table_head" style="border-top:0px;padding:4px;padding-left:10px !important;text-align: start;">',
																					'{headerName}',
																				'</th>',
																		'</tpl>',
																		'</tr>',
																		'<tpl for="value">',
																			'<tr>',
																				'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																					'{childTabKey}',
																				'</td>',
																				'<td class="font_bold12" style="width:25%;padding:6px 10px 5px 10px">',
																					'{childTabValue}',
																				'</td>',
																			'</tr>',
																		'</tpl>',
																	'</table>',
																'</td>',
															'</tr>',
														'<tpl else>',
															'<tr>',
																'<td>{key} </td>',
																'<td>{value} </td>',
															'</tr>',
														'</tpl>',
													'</tpl>',
												'</table>',
											'</div>'
											)
										
										});
									}
								}
								else
								{
									datasetconfigurationObj.add(
										{
											xtype: 'panel',
												flex:1,
												layout: {
												type: 'vbox',
												align: 'stretch'
											},
											dockedItems: [
															{
																dock: 'top',
																layout:{
																	type: 'hbox',
																	pack: 'end'
																},
																
																border: false,
																padding: 5,
																items: [
																	{
																		xtype: 'button',
																		cls:'button20',
																		id: 'configuredatasets',
																		text: 'Configure API',
																		handler : function() {
																			datasetCtrlr.loadDatasetconfigWindow();
																		}
																	}
																]
															}
														]},
									{
										xtype:'fieldset',
										title: screenLabelsObj['API_Configuration'],
										collapsible: false,
										style:{"box-shadow":"none","background":"none"},
										margin:'0 20 5 20',
										defaults: {
											labelAlign: 'top',
											labelSeparator:''
										},
										items: {
											xtype : 'container',
											height: 200,
											html: '<table width="100%" height="100%" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div styel="margin:10px auto">Please configure REST API</div></td></tr></table>',
											}
									});
								}
								datasetconfigurationObj.doLayout();
							}
						}
					}
				});
	},
	editDSN : function(btnObj,dsnName)
	{
		return editDSN(btnObj,dsnName,false);
	},
	editDSN : function(btnObj,dsnName,showData)
	{
		var testName = Ext.getCmp('test').getValue();
		var paramsForRestURL = 'action=modifyDSNConfiguration&restDSNName=' + encodeURIComponent(dsnName)+'&test='+encodeURIComponent(testName);
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: restConfigLoadingMsg+'...'});
		tmpMask.show();
		
		 Ext.Ajax.request({
                            url: '/final/admin/ICTest/data/EgAddRESTTestp.jsp',
                            method: 'POST',
                            params: paramsForRestURL,
                            scope: this,
                            success: function(response) {
								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonData=Ext.decode(jsonText);

											if (!Ext.isEmpty(jsonData)) {
													try
													{
													  var addDSNWinObj = Ext.widget('addnewdsn', {
														});
														addDSNWinObj.show();
														var restdsnname = Ext.getCmp('restdsnname');
														restdsnname.setValue(jsonData['restDSNName']);
														if(showData)
														{
															restdsnname.disable();
														}
														else
														{
															restdsnname.show();
														}
														var restDashMainPnl = Ext.getCmp('dsnSettingspopup');
														var urltextbox = Ext.getCmp('urltextbox');
														var restHttpMethod = Ext.getCmp('restHttpMethod');
														var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
														var addNewDSobj = Ext.getCmp('addNewDS');
														urltextbox.setValue(jsonData['dsnConfigDetails']['URL']);
														restHttpMethod.setValue(jsonData['dsnConfigDetails']['HTTP Method']);
														var configuredHeaders = jsonData['dsnConfigDetails']['ConfiguredHeaders'];
														var configuredParams = jsonData['dsnConfigDetails']['configuredParams'];
														var configuredBodyUrlEncoded = jsonData['dsnConfigDetails']['configuredBodyUrlEncoded'];
														var rawJsonBodyData = jsonData['dsnConfigDetails']['RawJsonBody'];
														var dataFieldParentNode = jsonData['dsnConfigDetails']['DataFieldParentNode'];
														var authTypeValue = jsonData['dsnConfigDetails']['authType'];
														if (!Ext.isEmpty(authTypeValue))
														{
															Ext.getCmp('authType').setValue(authTypeValue);
															if(authTypeValue == 'NoAuth')
															{
																Ext.getCmp('basicAuthContr').hide();
																Ext.getCmp('apiTokenContr').hide();
																Ext.getCmp('bearerTokenContr').hide();
																/*Ext.getCmp('headerContr').hide();
																Ext.getCmp('parametersContr').hide();
																Ext.getCmp('requestBodyContr').hide(); */
															}
															else if(authTypeValue == 'BasicAuth')
															{
																Ext.getCmp('basicAuthContr').show();
																Ext.getCmp('apiTokenContr').hide();
																Ext.getCmp('bearerTokenContr').hide();
																/* Ext.getCmp('headerContr').hide();
																Ext.getCmp('parametersContr').hide();
																Ext.getCmp('requestBodyContr').hide(); */
															}
															else if(authTypeValue == 'APIKey')
															{
																Ext.getCmp('basicAuthContr').hide();
																Ext.getCmp('apiTokenContr').show();
																Ext.getCmp('bearerTokenContr').hide();

																var configuredAPIKey = jsonData['dsnConfigDetails']['configuredAPIKey'];
																var configuredAPIValue = jsonData['dsnConfigDetails']['configuredAPIValue'];
																var configuredAddAPIKeyOpt = jsonData['dsnConfigDetails']['configuredAddAPIKeyOpt'];

																var apiKeyObj=Ext.getCmp('apiKeyName');
																
																if(!Ext.isEmpty(apiKeyObj))
																{
																	apiKeyObj.setValue(configuredAPIKey);
																}

																var apiKeyValueObj=Ext.getCmp('apiKeyValue');
																
																if(!Ext.isEmpty(apiKeyValueObj))
																{
																	apiKeyValueObj.setValue(configuredAPIValue);
																}

																var apiKeyAddToObj=Ext.getCmp('apiKeyAddTo');
																
																if(!Ext.isEmpty(apiKeyAddToObj))
																{
																	apiKeyAddToObj.setValue(configuredAddAPIKeyOpt);
																}
																
															}
															else if(authTypeValue == 'BearerToken')
															{
																Ext.getCmp('basicAuthContr').hide();
																Ext.getCmp('apiTokenContr').hide();
																Ext.getCmp('bearerTokenContr').show();
																var configuredBearerToken = jsonData['dsnConfigDetails']['configuredBearerToken'];

																var bearerTokenValueObj=Ext.getCmp('bearerTokenValue');

																if(!Ext.isEmpty(bearerTokenValueObj))
																{
																	bearerTokenValueObj.setValue(configuredBearerToken);
																}
															}
															else if(authTypeValue == 'OAuth2.0')
															{
																Ext.getCmp('basicAuthContr').hide();
																Ext.getCmp('apiTokenContr').hide();
																Ext.getCmp('bearerTokenContr').hide();
																var oAuth2GrantType = jsonData['dsnConfigDetails']['oAuth2GrantType'];
																var accessTokenURL = jsonData['dsnConfigDetails']['accessTokenURL'];
																var oAuth2ClientID = jsonData['dsnConfigDetails']['oAuth2ClientID'];
																var oAuth2ClientSecret = jsonData['dsnConfigDetails']['oAuth2ClientSecret'];
																var oAuth2Scope = jsonData['dsnConfigDetails']['oAuth2Scope'];
																var oAuth2Username = jsonData['dsnConfigDetails']['oAuth2Username'];
																var oAuth2Pwd = jsonData['dsnConfigDetails']['oAuth2Pwd'];
																var oAuth2ClientAuth = jsonData['dsnConfigDetails']['oAuth2ClientAuth'];

																var oAuth2GrantTypeObj=Ext.getCmp('oAuth2GrantType');

																if(!Ext.isEmpty(oAuth2GrantTypeObj))
																{
																	oAuth2GrantTypeObj.setValue(oAuth2GrantType);
																}

																var accessTokenURLObj=Ext.getCmp('accessTokenURL');

																if(!Ext.isEmpty(accessTokenURLObj))
																{
																	accessTokenURLObj.setValue(accessTokenURL);
																}

																var oAuth2ClientIDObj=Ext.getCmp('oAuth2ClientID');

																if(!Ext.isEmpty(oAuth2ClientIDObj))
																{
																	oAuth2ClientIDObj.setValue(oAuth2ClientID);
																}

																var oAuth2ClientSecretObj=Ext.getCmp('oAuth2ClientSecret');

																if(!Ext.isEmpty(oAuth2ClientSecretObj))
																{
																	oAuth2ClientSecretObj.setValue(oAuth2ClientSecret);
																}

																var oAuth2ScopeObj=Ext.getCmp('oAuth2Scope');

																if(!Ext.isEmpty(oAuth2ScopeObj))
																{
																	oAuth2ScopeObj.setValue(oAuth2Scope);
																}

																var oAuth2UsernameObj=Ext.getCmp('oAuth2Username');

																if(!Ext.isEmpty(oAuth2UsernameObj))
																{
																	oAuth2UsernameObj.setValue(oAuth2Username);
																}

																var oAuth2PwdObj=Ext.getCmp('oAuth2Pwd');

																if(!Ext.isEmpty(oAuth2PwdObj))
																{
																	oAuth2PwdObj.setValue(oAuth2Pwd);
																}

																var oAuth2ClientAuthObj=Ext.getCmp('oAuth2ClientAuth');

																if(!Ext.isEmpty(oAuth2ClientAuthObj))
																{
																	oAuth2ClientAuthObj.setValue(oAuth2ClientAuth);
																}
															}
														}
														if (!Ext.isEmpty(configuredHeaders)) {
															var viewTypeOptObj = Ext.getCmp('Header_Required');
															viewTypeOptObj.suspendEvents(false);
															var gridObj = Ext.getCmp('header_grid');
															var gridStore = gridObj.getStore();
															gridStore.removeAll();
															gridStore.add(configuredHeaders);
															gridObj.doLayout();
															Ext.getCmp('key').show();
															Ext.getCmp('value').show();
															Ext.getCmp('addHeader').show();
															Ext.getCmp('header_grid').show();
															viewTypeOptObj.setValue(true);
															viewTypeOptObj.resumeEvents();
														} else {
															var viewTypeOptObj = Ext.getCmp('Header_Required');
															viewTypeOptObj.suspendEvents(false);
															Ext.getCmp('key').hide();
															Ext.getCmp('value').hide();
															Ext.getCmp('addHeader').hide();
															Ext.getCmp('header_grid').hide();
															var gridObj = Ext.getCmp('header_grid');
															var gridStore = gridObj.getStore();
															gridStore.removeAll();
															viewTypeOptObj.setValue(false);
															viewTypeOptObj.resumeEvents();
														}
														if (!Ext.isEmpty(configuredParams)) {
															var viewTypeOptObj = Ext.getCmp('params_Required');
															viewTypeOptObj.suspendEvents(false);
															var gridObj = Ext.getCmp('param_grid');
															var gridStore = gridObj.getStore();
															gridStore.removeAll();
															gridStore.add(configuredParams);
															gridObj.doLayout();
															Ext.getCmp('key').show();
															Ext.getCmp('value').show();
															Ext.getCmp('addHeader').show();
															Ext.getCmp('param_grid').show();
															viewTypeOptObj.setValue(true);
															viewTypeOptObj.resumeEvents();
														} else {
															var viewTypeOptObj = Ext.getCmp('params_Required');
															viewTypeOptObj.suspendEvents(false);
															Ext.getCmp('param_key').hide();
															Ext.getCmp('param_value').hide();
															Ext.getCmp('addParam').hide();
															Ext.getCmp('param_grid').hide();
															var gridObj = Ext.getCmp('param_grid');
															var gridStore = gridObj.getStore();
															gridStore.removeAll();
															viewTypeOptObj.setValue(false);
															viewTypeOptObj.resumeEvents();
														}
														if (jsonData['dsnConfigDetails']['HTTP Method'] != "" && jsonData['dsnConfigDetails']['HTTP Method'] == "POST") {
															var body_type = Ext.getCmp('body_type');
															body_type.show();
															var body_typeObj = body_type.getChecked();
															var body_name = jsonData['dsnConfigDetails']['SelectedBodyType'];
															if (body_name != null && body_name == "x-www-form-urlencoded") {

																var bodyTypeObj = Ext.getCmp('body_type');
																bodyTypeObj.suspendEvents(false);
																bodyTypeObj.setValue({
																	body_name: body_name
																});
																bodyTypeObj.show();
																bodyTypeObj.resumeEvents();
																bodyTypeObj = null;
																delete bodyTypeObj;

																Ext.getCmp('rawJsonBody').hide();
																Ext.getCmp('body_urlencoded_key').show();
																Ext.getCmp('body_urlencoded_value').show();
																Ext.getCmp('addBody_urlencoded').show();
																Ext.getCmp('bodyUrlEncodedGrid').show();
																if (configuredBodyUrlEncoded != null) {
																		var bodyGridObj = Ext.getCmp('bodyUrlEncodedGrid');
																		var bodyGridStore = bodyGridObj.getStore();
																		bodyGridStore.removeAll();
																		bodyGridStore.add(configuredBodyUrlEncoded);
																		bodyGridObj.doLayout();
																}
															} else {
																var bodyTypeObj = Ext.getCmp('body_type');
																bodyTypeObj.suspendEvents(false);
																bodyTypeObj.setValue({
																	body_name: body_name
																});
																bodyTypeObj.show();
																bodyTypeObj.resumeEvents();
																bodyTypeObj = null;
																delete bodyTypeObj;
																var rawJsonBody = Ext.getCmp('rawJsonBody');
																rawJsonBody.show();
																if (rawJsonBodyData != null && rawJsonBodyData != "") {
																	var rawJsonBodyVal = JSON.stringify(rawJsonBodyData, undefined, 2);
																	rawJsonBody.setValue(rawJsonBodyVal);
																}
																Ext.getCmp('body_urlencoded_key').hide();
																Ext.getCmp('body_urlencoded_value').hide();
																Ext.getCmp('addBody_urlencoded').hide();
																Ext.getCmp('bodyUrlEncodedGrid').hide();
															}

														} else {
															Ext.getCmp('body_type').hide();
															Ext.getCmp('body_urlencoded_key').hide();
															Ext.getCmp('body_urlencoded_value').hide();
															Ext.getCmp('addBody_urlencoded').hide();
															Ext.getCmp('bodyUrlEncodedGrid').hide();
															var rawJsonBody = Ext.getCmp('rawJsonBody');
															rawJsonBody.reset();
															rawJsonBody.hide();
															var gridObj = Ext.getCmp('bodyUrlEncodedGrid');
															var gridStore = gridObj.getStore();
															gridStore.removeAll();
														}
														Ext.getCmp('getData').setText(btnText2);
														tmpMask.hide();
													}
													catch (cex)
													{
														tmpMask.hide();
														console.log("cex ",cex);
													}
												}
										}
										else
										{
											tmpMask.hide();
										}
										
							},
							failure : function(response, opts) {
								tmpMask.hide();
								//btnObj.setDisabled(false);
							}
		 });
	},
	addRESTDataFields : function(dsnName,btnObj)
	{
		var testName = Ext.getCmp('test').getValue();
		var paramsForRestURL = 'action=modifyDSNConfiguration&loadDataGrid=yes&restDSNName=' + encodeURIComponent(filterEncode(dsnName))+'&test='+encodeURIComponent(testName);
		btnObj.setDisabled(true);
		Ext.create('Ext.window.Window', {
				//title:'Detailed Diagnosis',
				//bodyPadding:'8 8 30 8',
				id : 'restDataConfigurationWindow',
				name : 'restDataConfigurationWindow',
				width: 900,
				modal: true,
				border: false,
				frame: false,
				title: '<div><span id="restApiBackbtn"></span>Metrics Configuration</div>',
				ui: 'newPopupWindow widgetOptionsWindowHeader',
				resizable: false,
				autoShow: false,
				ghost: false,
				padding: '0 0 0 0',
				autoScroll: true,
				scroll: true,
				header: {
					height: 48,
					padding: '0 20',
					margin: 0
				},
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				ui: 'newPopupWindow widgetOptionsWindowHeader',
				cls: 'myDashboardwindow',
				height: 560,
				scroll: true,
				autoScroll: true,
				closeAction: 'destroy',
				listeners:
				{
					show: function(win)
					{
						if (this.modal)
						{
							var dom = Ext.dom.Query.select('.x-mask');
							
							var el = Ext.fly(dom[dom.length-1]);
							
							el.addCls('windowModal');
						}
					},
					hide: function(win)
					{
						if (this.modal)
						{
							var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.fly(dom[dom.length-1]);
							el.removeCls('windowModal');
						}
					},
					afterrender: function()
					{
						Ext.EventManager.onWindowResize(function()
						{
							var me = this;
							me.center();
						}, this);
					}
				}
		}).show();
		
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: restDataLoadingMsg+'...', id : 'restDataLoadingMask'});
		tmpMask.show();
		 Ext.Ajax.request({
                            url: '/final/admin/ICTest/data/EgAddRESTTestp.jsp',
                            method: 'POST',
                            params: paramsForRestURL,
                            scope: this,
                            success: function(response) {
								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonData=Ext.decode(jsonText);

											if (!Ext.isEmpty(jsonData)) {
													try
													{
													//  var addDSNWinObj = Ext.widget('addnewdsn', {
													//	});
														
													//	addDSNWinObj.show();
															btnObj.setDisabled(false);
													var restDashMainPnl = Ext.getCmp('restDataConfigurationWindow');
													restDashMainPnl.removeAll();
													var dataFieldParentNode = '';
												
													if(publicJSON!=null && publicJSON.hasOwnProperty('measureParentNode'))
													{
														if(!Ext.isEmpty(publicJSON.measureParentNode))
														{
															dataFieldParentNode=publicJSON.measureParentNode;
														}
													}
													var rootNode = {};
													rootNode["expanded"] = "true";
													rootNode["children"] = jsonData['jsonkeys']['restTree'];
													restDashMainPnl.remove('restTreePnl');
													Ext.EventManager.removeAll('restTreePnl');
													restDashMainPnl.remove('restfieldmappingpnl');
													Ext.EventManager.removeAll('restfieldmappingpnl');
													var contArr = new Array();
													contArr.push({
														xtype: 'treescrollPanel',
														rootVisible: false,
														flex: 1,
														ui: 'newTreePanelWithLines',
														id: 'treeP',
														store: Ext.create('Ext.data.TreeStore', {
															root: rootNode
														}),
														restTreeNodeData: jsonData['jsonkeys']['restTreeNodeData'],
														restTreeNodeFields: jsonData['jsonkeys']['resTreeNodefields'],
														listeners: {
															afterrender: function() {
																if(publicJSON!=null && publicJSON.hasOwnProperty('restFldMap'))
																{
																	if(!Ext.isEmpty(publicJSON.restFldMap))
																	{
																		var gridObj = Ext.getCmp('restDataGrid');
																		gridObj.selectedDataFieldsMap=publicJSON.restFldMap;
																	}
																}
																var record = this.getStore().getNodeById(dataFieldParentNode);
																this.getSelectionModel().select(record);
															},
															select: function(node, record, index, eOpts) {
																var fldsArr = [];
																var gridObj = Ext.getCmp('restDataGrid');
																var previousSelectedNode=gridObj.dataFieldParentNode;
																var saveField = Ext.getCmp('saveFldsBtn');
																var restGridData = jsonData['jsonkeys']['restGrid'][record.raw.jPath];
																var gridCols = restGridData['gridCols'];
																var gridData = restGridData['gridData'];
																var colsArr = [];
																var fields2Store = [];
																var filtersArr = [];
																for (var colVal in gridCols) {
																	var colName = gridCols[colVal].toString();
																	fields2Store.push({
																		name: colName,
																		type: 'string'
																	});
																	colsArr
																		.push({
																			header: "<span class='newFont_normal11  DsWrapText' style='display:block ;' data-qtip='" + colName + "'><label class='dsCustomCheckBox' style=' margin: -2px 7px 0 0px;display: block;float: left;width:16px' ><input id='datacolumncheckbox' type='checkbox' name='datacolumncheckbox' class='messageCheckbox' value='" + colName + "' ><span class='labelCheckBOx'></span></label>" + colName + "</span>",
																			dataIndex: colName,
																			sortable: false,
																			
																			tdCls: 'DsWrapText',
																			cls: 'x-grid-checkheader-editor',
																			renderer: function(value, metaData, record, row, col, store, gridView) {
																				var value = '<span class="newFont_normal11 DsWrapText" data-qtip="' + value + '">' + value + '</span>';
																				return value;
																			}

																		});
																}
																
																restDashMainPnl.dataTypeMapping=restGridData['dataTypeMapping'];
																var selectedFieldsArr=[];
																if(!Ext.isEmpty(gridObj) && gridObj.hasOwnProperty('dataFieldParentNode'))
																{
																	var inputElements = document.getElementsByClassName('messageCheckbox');
																	var tmpDataTypeMapping=jsonData['jsonkeys']['restGrid'][previousSelectedNode].dataTypeMapping;
																	for (var i = 0; inputElements[i]; ++i)
																	{
																		if(inputElements[i].checked==true)
																		{
																			 var selectedDataFld=inputElements[i].value;
																			if(tmpDataTypeMapping!=null && tmpDataTypeMapping.hasOwnProperty(selectedDataFld))
																			  {
																				  var dataTyp=tmpDataTypeMapping[selectedDataFld];
																				  if(Ext.isEmpty(dataTyp) || (dataTyp!=null && dataTyp!="Number"))
																				  {
																					  // descriptorFields.push(selectedDataFld);
																				  }
																				  else
																				  {
																					  selectedFieldsArr.push(inputElements[i].value);
																				  }
																			  }
																		}
																	}
																	var selectedDataFieldsMap={};
																	if(gridObj!=null && gridObj.hasOwnProperty('selectedDataFieldsMap'))
																	{
																		selectedDataFieldsMap=gridObj.selectedDataFieldsMap;
																	}
																	if(!Ext.isEmpty(selectedFieldsArr))
																	{
																		selectedDataFieldsMap[previousSelectedNode]=selectedFieldsArr;
																		gridObj.selectedDataFieldsMap=selectedDataFieldsMap;
																	}
																}
																gridObj.getStore().removeAll();
																var storeVal1 = Ext.create('Ext.data.Store', {
																	fields: fields2Store,
																	data: gridData
																});
																gridObj.reconfigure(storeVal1, colsArr);
																gridObj.dataFieldParentNode = record.raw.jPath;
																if(publicJSON!=null && publicJSON.hasOwnProperty('restFldMap'))
																{
																	if(!Ext.isEmpty(publicJSON.restFldMap) && publicJSON.restFldMap.hasOwnProperty(gridObj.dataFieldParentNode))
																	{
																		var descriptorDataField='';
																		var checkDescField=false;
																		if(publicJSON!=null && publicJSON.hasOwnProperty('descriptorNode'))
																		{
																			if(!Ext.isEmpty(publicJSON.descriptorNode))
																			{
																				descriptorDataField=publicJSON.descriptorNode;
																				checkDescField=true;
																			}
																		}
																		var selectedDataFieldsArr=[];
																		selectedDataFieldsArr=publicJSON.restFldMap[gridObj.dataFieldParentNode];
																		if(!Ext.isEmpty(selectedDataFieldsArr))
																		{
																			var inputElements = document.getElementsByClassName('messageCheckbox');
																			for (var i = 0; inputElements[i]; ++i) {
																				var index = selectedDataFieldsArr.indexOf(inputElements[i].value);
																				if (index > -1) {
																					inputElements[i].checked = true;
																				}
																				else
																				{
																					if(checkDescField && descriptorDataField.indexOf(inputElements[i].value)>-1)
																					{
																						inputElements[i].checked = true;
																					}
																				}
																			}
																		}
																	}
																}
																else if(gridObj!=null && gridObj.hasOwnProperty('selectedDataFieldsMap'))
																{
																	if(!Ext.isEmpty(gridObj.selectedDataFieldsMap) && gridObj.selectedDataFieldsMap.hasOwnProperty(gridObj.dataFieldParentNode))
																	{
																		var selectedDataFieldsArr=[];
																		selectedDataFieldsArr=gridObj.selectedDataFieldsMap[gridObj.dataFieldParentNode];
																		if(!Ext.isEmpty(selectedDataFieldsArr))
																		{
																			var inputElements = document.getElementsByClassName('messageCheckbox');
																			for (var i = 0; inputElements[i]; ++i) {
																				var index = selectedDataFieldsArr.indexOf(inputElements[i].value);
																				if (index > -1) {
																					inputElements[i].checked = true;
																				}
																			}
																		}
																	}
																}
																gridObj.show();
																gridObj.view.refresh();
																//gridObj.view.fireEvent('resize',gridObj.view);
															//	Ext.getCmp('dsnConfigCont').hide();
																
															}
														}

													});
													contArr.push({
														xtype: 'RESTDataGrid',
														flex: 2.35,
														padding: 0,
														margin: 0,
														cls:'restGridPreview',
														id: 'restDataGrid',
														hidden: false,
														isGridLoaded : false,
														listeners : {
															'reconfigure' : function(dataGridObj)
															{
																if(dataGridObj.isGridLoaded==false)
																{
																	
																	
																	//tmpMask.hide();
																	dataGridObj.isGridLoaded=true;
																}
															}
														}
													});
													Ext.create('Ext.Button', {
														html: '',
														icon: '../images/' + strSkin + '/apiBackbtn.png', 
														renderTo: Ext.get('restApiBackbtn'),
														id: 'restPreviewBtn',
														style: {
															'background': 'none'
														},
														scale: 'medium',
														border: 0,
														buttonId: 'restPreviewBtn',
														//icon: '../images/' + strSkin + '/roundLeftArrow.png', // icons can also be specified inline
														handler : function()
														{
															datasetCtrlr.restPreviewBtn();
															
														}
													});
													restDashMainPnl.add(
														{
																xtype: 'container',
																//height:40,
																layout: {
																type:	'hbox',
																},
																id: 'restPreviewBtnBox',
																hidden: true,
																items: [

																	/*{
																		xtype: 'button',
																		//width: 100,
																		padding: '13 0 0 0',
																		margin: '0 5 0 20',
																		scale: 'medium',
																		border: 0,
																		style: {
																			'background': 'none'
																		},
																		html: '',
																		//overCls: 'buttonOver',
																		//id: 'restPreviewBtn',
																		//buttonId: 'restPreviewBtn',
																		//icon: '../images/' + strSkin + '/roundLeftArrow.png', // icons can also be specified inline
																		handler : function()
																		{
																			datasetCtrlr.restPreviewBtn();
																		}
																	},
																	{
																		xtype: 'box',
																		padding: '13 0 0 0',
																		html: '<div style=" padding: 3px 5px 0 0; " class="newFont_bold15"></div>',
																	}*/
																]
															}
															);
												//	Ext.getCmp('dsnConfigCont').hide();
												
													restDashMainPnl.add(
												   {
															xtype: 'panel',
															title: '<span class="font_bold11">'+screenLabelsObj['dataFieldConfig']+'</span>',
															autoScroll: true,
															layout: {
																type: 'hbox',
																align:'stretch'
															},
															margin: '10 15 0 20',
															id: 'restTreePnl',
															ui: 'newTreePanelWithLines hideFolder DsTreePanel',
															cls: 'x-tree-arrows',
															name: 'restTreePnl',
															flex:1,
															items :	contArr,
															dockedItems: [{
																	xtype: 'toolbar',
																	dock: 'bottom',
																	items: ['->',{
																		xtype: 'button',
																		id: 'saveFldsBtn',
																		name: 'saveFldsBtn',
																		margin: '20 0 0 0',
																		style:{'border':'none'},
																		padding:0,	
																		width: 106,
																		height: 27,

																		text: '<span class="newFont_normal14" style="color:#ffffff;line-height:24px;">'+screenLabelsObj['nextLbl']+'</span>',
																		tooltip: 'click here to Add',
																		cls: 'button20 restBgButton',
																		handler : function()
																		{
																			datasetCtrlr.selectFields();
																		}
																	},'->']
															}]
																
															} );


													if (dataFieldParentNode!= null) {
														var restGrid = jsonData['jsonkeys'];
														if (restGrid.hasOwnProperty('restGrid') && jsonData['jsonkeys']['restGrid'].hasOwnProperty(dataFieldParentNode)) {
															var fldsArr = [];
															var saveField = Ext.getCmp('saveFldsBtn');
															var restGridData = jsonData['jsonkeys']['restGrid'][dataFieldParentNode];
															var gridCols = restGridData['gridCols'];
															var gridData = restGridData['gridData'];
															var colsArr = [];
															var fields2Store = [];
															var filtersArr = [];
															for (var colVal in gridCols) {
																var colName = gridCols[colVal].toString();
																fields2Store.push({
																	name: colName,
																	type: 'string'
																});
																var clVal=colName;
																var clDispName=colName;
																if(clVal!=null && clVal.indexOf(" ")>-1)
																{
																	clVal=clVal.replace(' ','_bs_');
																	clDispName=clDispName.replace('_bs_',' ');
																}
																colsArr
																	.push({
																		header: "<span class='newFont_normal11  DsWrapText' data-qtip='" + clDispName + "' style='display:block;'><label class='dsCustomCheckBox' style=' margin: -2px 7px 0 0px;display: block;float: left;width:16px'   ><input id='datacolumncheckbox' type='checkbox' name='datacolumncheckbox' class='messageCheckbox' value='" + clVal + "' ><span class='labelCheckBOx'></span></label>" + clDispName + "</span>",
																		dataIndex: colName,
																		
																		sortable: false,
																		tdCls: 'DsWrapText',
																		cls: 'x-grid-checkheader-editor',
																		renderer: function(value, metaData, record, row, col, store, gridView) {
																			var value = '<span class="newFont_normal11 DsWrapText" data-qtip="' + value + '">' + value + '</span>';
																			return value;
																		}

																	});
															}
															var gridObj = Ext.getCmp('restDataGrid');
															gridObj.getStore().removeAll();
															var storeVal1 = Ext.create('Ext.data.Store', {
																fields: fields2Store,
																data: gridData
															});
															gridObj.reconfigure(storeVal1, colsArr);
															gridObj.dataFieldParentNode = dataFieldParentNode;
															restDashMainPnl.dataTypeMapping=restGridData['dataTypeMapping'];
															gridObj.show();
															 gridObj.view.fireEvent('resize',gridObj.view);

															var inputElements = document.getElementsByClassName('messageCheckbox');
																	var selectedDataFieldsArr = publicJSON['selectedRestFieldList'];
																	var descriptorDataField='';
																	var checkDescField=false;
																	if(publicJSON!=null && publicJSON.hasOwnProperty('descriptorNode'))
																	{
																		if(!Ext.isEmpty(publicJSON.descriptorNode))
																		{
																			descriptorDataField=publicJSON.descriptorNode;
																			checkDescField=true;
																		}
																	}
																	for (var i = 0; inputElements[i]; ++i) {
																		var index = selectedDataFieldsArr.indexOf(inputElements[i].value);
																		if (index > -1) {
																			inputElements[i].checked = true;
																		}
																		else
																		{
																			if(checkDescField && descriptorDataField.indexOf(inputElements[i].value)>-1)
																			{
																				inputElements[i].checked = true;
																			}
																		}
																	}

																
																	datasetCtrlr.selectFields();
																	if(checkDescField)
																	{
																		var descObj = Ext.getCmp('DescriptorRequired');
																		if(!Ext.isEmpty(descObj))
																		{
																			descObj.setValue(true);
																		}
																	}
																	Ext.defer(function(){
																//	tmpMask.hide();
																	},1000);
														}
														else
														{
															tmpMask.hide();
														}
													}
													else
													{
														tmpMask.hide();
													}
												//	tmpMask.hide();
												/*	var rest_output_window = Ext.getCmp('restfieldmappingpnl');
													if (!Ext.isEmpty(rest_output_window)) {
														rest_output_window.show();
													}*/
													}
													catch (cex)
													{
														tmpMask.hide();
														console.log("cex",cex);
													}
												}
										}
							}
		 });
	},
	loadAddMeasureTab: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var existingMeass = publicJSON.measuresList;
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		cntnrObj.removeAll();
		Ext.getCmp('addNewMeasure').hide();
		Ext.getCmp('configureMetricsBtn').show();
		if (publicJSON.noMeasuresAdded)
		{
			Ext.getCmp('noMeasureFnd').show();
			Ext.getCmp('generateCntnr').disable();
			Ext.getCmp('tab6Help').disable();
			
		}
		else
		{
			Ext.getCmp('noMeasureFnd').hide();
			for (var p=0; p<existingMeass.length; p++) {
					var measure = existingMeass[p];
					if(!(measure.measureName == "Installed"))
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+measure.measureIndex+'. '+measure.measureName+'</b>',
						width: 500,
						items: [
							{
								xtype: 'container',
								layout: {
									type: 'vbox',
									align: 'left',
									pack: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									margin: 5,
									labelWidth: 200 
								},
								items: [
									{
										xtype: 'displayfield',
										fieldLabel: dbColSize,
										id : 'dbSize'+p,
										value: measure.databaseColumnSize,
										hidden: measure.hideDatabaseColumnSize
									},
									{
										xtype: 'displayfield',
										id : 'unitVal'+p,
										fieldLabel: unit,
										value: measure.unit
									},
									{
										xtype: 'displayfield',
										fieldLabel: procMthd,
										id : 'processMethodVal'+p,
										value: measure.processMethod
									},
									{
										xtype: 'displayfield',
										fieldLabel: convFact,
										id : 'conFact'+p,
										value: measure.conversionFactor,
										hidden: measure.hideConversionFactor
									},
									{
										xtype: 'displayfield',
										fieldLabel: alrmDispStr,
										id : 'alarmDisp'+p,
										value: measure.alarmDispString,
										hidden: measure.hideAlarmDispStr
									},
									{
										xtype: 'displayfield',
										fieldLabel: screenLabelsObj['APIDataFieldLbl'],
										id : 'restTreeId'+p,
										value: measure.restdatafld,
									}
								]
							},
							{
								xtype: 'container',
								layout: {
									type: 'hbox',
									pack: 'center'
								},
								defaults: {
									width: 80
								},
								items:[
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: measure.modifyURL,
										handler: function() {
											me.showModifyMeasure(this.modifyURL);
										},
										margin: '5 0 10 0'
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										deleteURL: measure.deleteURL,
										measureName: measure.measureName,  
										handler: function() {
											me.deleteMeasure(this.deleteURL, this.measureName);
										},
										margin: '5 0 10 20'
									}
								]
							}
						]
					});
					var dbColSize1 = Ext.getCmp('dbSize'+p);
					var unitVal = Ext.getCmp('unitVal'+p);
					var processMethodVal = Ext.getCmp('processMethodVal'+p);
					var conFact = Ext.getCmp('conFact'+p);
					var alrmDisp = Ext.getCmp('alarmDisp'+p);
					var objId = Ext.getCmp('restTreeId'+p);
					if(isConfigTest)
					{
						dbColSize1.hide();
						unitVal.hide();
						processMethodVal.hide();
						conFact.hide();
						alrmDisp.hide();
						objId.show();
					}
				}
			}
		}
	},
	showConfigDescriptorPopup : function()
	{
		if(Ext.isEmpty(datasetCtrlr))
		{
			datasetCtrlr= this.getController('ICTest.controller.DatasetController');
		}
		
		var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
		datasetCtrlr.loadAddMeasureTab(urlStr);
		datasetCtrlr.addRESTDataFields(publicJSON['restDSNName'],this); 
	},
	showAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
		me.loadAddMeasureTab(urlStr);
		selMibFile = '';
		selElmtFile = '';
		selStusFile = '';
		oidFldName = '';
		elmtFldName = '';
		stusFldName = '';
		Ext.create('Ext.window.Window', {
			title: newMeasDetail,
			width: 500,
			id:'addRESTMeasureWindow',
			layout:{
				type:'vbox',
				pack:'start',
				align:'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 400,
				labelWidth: 200
			},
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measIdx,
					id:'index',
					name:'index',
					margin: '10 5 0 5'
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measName,
					id:'measure',
					name:'measure',
					maxLength: 24,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'dbsize',
					name:'dbsize',
					fieldLabel: dbColSize,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'un',
					name:'un',
					fieldLabel: unit,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					listeners:
					{
						select:{
							fn: function (id){
								me.otherUnit('add');
							}
						}
					}
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: other,
					id:'otherunit',
					name:'otherunit',
					hidden: true,
					maxLength: 64,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'process',
					name:'process',
					fieldLabel: procMthd,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false,
					listeners:
					{
						select:{
							fn: function (id){
								me.processMethodChange('add');
							}
						}
					}
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'cFactor',
					name:'cFactor',
					fieldLabel: convFact,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: alrmDispStr,
					id:'alarmdescription',
					name:'alarmdescription',
					maxLength: 75,
					enforceMaxLength: true
				},
				{
					xtype: 'container',
					layout:{
						type:'hbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
						labelWidth: 200
				},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: 'API Data Field',
							id:'restdatafld',
							name:'restdatafld',
							maxLength: 100,
							width: 380,
							enforceMaxLength: true
						},
						{
							xtype: 'button',
							iconCls:'iconUrlTree',
							border:0,
							style:{
								'background':'none'
							},
							listeners: {
								'click': function(btnObj) {
									datasetCtrlr.addRESTDataFields(publicJSON['restDSNName'],btnObj); 
								}
								
							}
						}
					]
				},
				{
					xtype: 'button',
					cls : 'button20',
					text: add,
					id:'addMeasureButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								me.doAddNewMeasure();
							}
						}
					},
					margin: '5 5 20 5'
				}
			]
		}).show();

		Ext.getCmp('index').setValue(publicJSON.measIndex);
		var dbSizeObj = Ext.getCmp('dbsize');
		var alrmDescObj = Ext.getCmp('alarmdescription');
		var processMethod = Ext.getCmp('process');
		var unitObj = Ext.getCmp('un');
		var process = '';
		if (isConfigTest)
		{
			dbSizeObj.hide();
			alrmDescObj.hide();
			processMethod.hide();
			unitObj.hide();
		}
		else
		{
			dbSizeObj.show();
			dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
			dbSizeObj.setValue("2");
			alrmDescObj.show();
			Ext.getCmp('process').getStore().loadRawData(publicJSON.processMethodList);
			process = publicJSON.selectedProcessMethod;
			Ext.getCmp('process').setValue(process);
			Ext.getCmp('un').getStore().loadRawData(publicJSON.unitsList);
			Ext.getCmp('un').setValue("-1");
		}
		var convFactObj = Ext.getCmp('cFactor');
		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			convFactObj.show();
			convFactObj.getStore().loadRawData(publicJSON.convFactorList);
			convFactObj.setValue(publicJSON.convFactorSelected);
		}
		else
		{
			convFactObj.hide();
		}
	},
	otherUnit: function(from)
	{
		var unitObj = Ext.getCmp('un');
		var otherUnitObj = Ext.getCmp('otherunit');
		if (from == 'modify')
		{
			unitObj = Ext.getCmp('s_un');
			otherUnitObj = Ext.getCmp('s_otherunit');
		}

		if(unitObj.getValue() == 'other')
		{
			otherUnitObj.show();
			otherUnitObj.enable();
		}
		else
		{
			otherUnitObj.hide();
			otherUnitObj.disable();
		}
	},
	processMethodChange: function(from)
	{
		var process;
		var factorObj;
		if (from == 'add')
		{
			process = Ext.getCmp('process').getValue();
			factorObj = Ext.getCmp('cFactor');
		}
		else if (from == 'modify')
		{
			process = Ext.getCmp('s_process').getValue();
			factorObj = Ext.getCmp('s_factor');
			factorObj.getStore().loadRawData(publicJSON.convFactorList);
			factorObj.setValue(publicJSON.convFactorSelected);
		}

		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			factorObj.show();
			factorObj.enable();
		}else
		{
			factorObj.hide();
			factorObj.disable();
		}		
	},
	doAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var index = Ext.getCmp('index').getValue();
		var measure = Ext.getCmp('measure').getValue();
		var factor = Ext.getCmp('cFactor').getValue();
		var dbSize = Ext.getCmp('dbsize').getValue();
		var otherUnit = Ext.getCmp('otherunit').getValue();
		var unit = Ext.getCmp('un').getValue();
		var alrmDesc = Ext.getCmp('alarmdescription').getValue();
		var process = Ext.getCmp('process').getValue();
		var restdatafld = Ext.getCmp('restdatafld').getValue();
		var restParentNode = Ext.getCmp('restdatafld').dataFieldParentNode;

		var restdatafldParam=me.filterEncode(restdatafld);
		var oidFldNameParam=me.filterEncode(oidFldName);
		var restParentNodeParam=me.filterEncode(restParentNode);
		if(process == null && isConfigTest)
		{
			process = 'UNALTERED';
			factor = '1';
		}
		if (process != 'UNALTERED' && process != 'DIFFERENCE')
		{
			factor = 'none';
		}
		var urlStr =  'ICTest/data/EgconfigrestmeasurepJson.jsp?add=add&test='+test+'&measure='+filterEncode(measure)+'&factor='+factor+'&restdatafld='+encodeURIComponent(filterEncode(restdatafldParam));
		urlStr += '&dbsize='+dbSize+'&otherunit='+encodeURIComponent(filterEncode(otherUnit))+'&un='+encodeURIComponent(filterEncode(unit))+'&alarmdescription='+encodeURIComponent(filterEncode(alrmDesc))+'&index='+index+'&process='+process;
		urlStr += '&fileName='+selMibFile+'&oid_fieldName='+encodeURIComponent(filterEncode(oidFldName))+'&restParentNode='+encodeURIComponent(filterEncode(restParentNodeParam));

		if (!this.measureValidation(measure,unit,otherUnit,alrmDesc,restdatafld))
		{
			return;
		}
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: error+': '+publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError',
				fn: function(btn)
				{
					if(btn == 'ok')
					{
						Ext.getCmp('addRESTMeasureWindow').close();
						me.showAddNewMeasure();
					}
				}
			});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('tab6Help').enable();
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg + '. '+ alertMsg80,
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				closable: false,
				fn: function(response) {
					if(response == 'yes') {
						Ext.getCmp('addRESTMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						me.showAddNewMeasure();
					}
					else if (response == 'no')
					{
						Ext.getCmp('addRESTMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						Ext.getCmp('newtest').setActiveTab(3);
					}
				}
			});
		}
	},
	measureValidation: function(meas,unit,otherUnit,alarmStr,restdatafld)
	{
		var me=this;
		var measObj = Ext.getCmp('measure');
		var alrmStrObj = Ext.getCmp('alarmdescription');
		var otherUnitObj = Ext.getCmp('otherunit');
		var restdatafldObj = Ext.getCmp('restdatafld');
		var keyArr = new Array("other","none","null","all");
		var isConfigTest = false;
		var alarmDispStr=true;
		var type = Ext.getCmp('type').getValue()
		if (type != null && type == 'Configuration')
		{
			isConfigTest = true;
		}
		if (!isConfigTest)
		{
			if(!me.checkSpecialChar(alarmStr,"~!@#$%^&*()|:,;'<>"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: splCharAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				alrmStrObj.focus(true);
				return false;
			}
			if(isDouble=="false")
			{
				alarmDispStr = validateSingleByte(alarmStr);
			}
		}
		meas = meas.toUpperCase();
		if(meas == "TRGT_HOST" || meas == "PORT_NO"
			|| meas == "SITE_NAME" || meas == "INFO"
			|| meas == "MSMT_HOST" || meas == "MSMT_TIME")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg14,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var ch = meas.charAt(0);
		var un=!isConfigTest?unit:"NONE";
		if(!checkblank(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspace(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: _checkblank + " " + valIn + " " + measName,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(meas, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch >= '0' && ch <= '9')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch == '_')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg18,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(un == "-1")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg19,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!alarmDispStr)
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg20,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			alrmStrObj.focus(true);
			return false;
		}
		else if(un == "other")
		{
			if(!checkblank(otherUnit))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg21,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			else if(!checkspace(otherUnit))
			{
				otherUnitObj.focus(true);
				return false;
			}
			else if(!checkspecialnomess(otherUnit, "`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
			else if (!checkKeywords(otherUnit,keyArr))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg22,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
		}
		else if(!checkblank(restdatafld))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg85,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			restdatafldObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(restdatafld))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg48,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			restdatafldObj.focus(true);
			return false;
		}
		return true;
	},
	deleteMeasure: function(deleteURL, measureName)
	{
		var me = this;
		Ext.Msg.show({
			title: addMeasure,
			msg:alertMsg45+ ' \''+measureName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddMeasureTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	},
	generateRESTTest: function()
	{
		var me=this;
		var descObj = Ext.getCmp('DescriptorRequired');
		var selDescRestFldVal = '',descVal='';

		if(!Ext.isEmpty(descObj))
		{
			descVal=descObj.getValue();
			
			if (descVal==true)
			{
				selDescRestFldVal = Ext.getCmp('descriptorDataRestFld').getValue();
				if(!checkblank(selDescRestFldVal))
				{
					Ext.Msg.show({
						title: generate,
						msg: alertMsg49,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								eleOidObj.focus(true);
							}
						}
					});
					return;
				}
				else if(!validateSingleByte(selDescRestFldVal))
				{
					Ext.Msg.show({
						title: generate,
						msg: alertMsg50,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(response) {
							if(response == 'ok') {
								eleOidObj.focus(true);
							}
						}
					});
					return;
				}
			}
		}
		var restMeasureMappingGridObj=Ext.getCmp('measureInternalValueMappingGrid');
		var test = Ext.getCmp('test').getValue();
		var restParentNode = Ext.getCmp('restGenCont').dataFieldParentNode;
		var selectedMetricsArr = Ext.getCmp('restGenCont').selectedMetrics;
		var selectedFldsMapping = Ext.getCmp('restGenCont').selectedFldsMapping;
		var selectedMetrics='';
		for(var m in selectedMetricsArr)
		{
			selectedMetrics=selectedMetrics+","+selectedMetricsArr[m];
		}
		if(selectedMetrics!=null && selectedMetrics.indexOf(",")==0)
		{
			selectedMetrics=selectedMetrics.substring(1);
		}
		selDescRestFldVal=me.filterEncode(selDescRestFldVal);
		selectedMetrics=me.filterEncode(selectedMetrics);
		restParentNode=me.filterEncode(restParentNode);
		var configuredMeasIntVals='';
		if(!Ext.isEmpty(restMeasureMappingGridObj))
		{
			var gridRecordCount = restMeasureMappingGridObj.getStore().getCount();
			for ( var i = 0; i < gridRecordCount; i++) {
			//	var measureNam = restMeasureMappingGridObj.getStore().getAt(i).get('measure');
				var key = restMeasureMappingGridObj.getStore().getAt(i).get('key');
				var value = restMeasureMappingGridObj.getStore().getAt(i).get('value');

				for(var m1 in selectedMetricsArr)
				{
					var measureNam=selectedMetricsArr[m1];
					if(measureNam!=null && measureNam.indexOf("|^|")>-1)
					{
						measureNam=measureNam.substring(0,measureNam.indexOf("|^|"));
					}
					var measIntVal=measureNam+":"+key+"$!$"+value;
					configuredMeasIntVals=configuredMeasIntVals+'!^!'+measIntVal;
				}
			}
		}
		
	//	restMeasureMappingGrid=me.filterEncode(restMeasureMappingGrid
		var urlStr =  'ICTest/data/EgconfigrestmeasurepJson.jsp';
		var reqPrms='add=gen&test='+test+'&descriptorbasedtest='+descVal+'&selDescRestFldVal='+encodeURIComponent(selDescRestFldVal)+"&restParentNode="+encodeURIComponent(restParentNode)+"&selectedMetrics="+encodeURIComponent(selectedMetrics);
		if(!Ext.isEmpty(configuredMeasIntVals))
		{
			if(configuredMeasIntVals.indexOf('!^!')==0)
			{
				configuredMeasIntVals=configuredMeasIntVals.substring(3);
			}
			configuredMeasIntVals=me.filterEncode(configuredMeasIntVals);
			reqPrms=reqPrms+'&configuredMeasIntVals='+encodeURIComponent(configuredMeasIntVals);
		}
			
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			params : reqPrms,
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		
		if (publicJSON.AlertType=='Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError'
			});
		}
		else if (publicJSON.AlertType=='Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'ok') {
						window.location.href= '/final/admin/EgUDTest.jsp';
					}
				}
			});
		}
		if (!Ext.isEmpty(publicJSON.forwardURL))
		{
			this.getController('ICTest.controller.ThresholdCtrlr').init();

			var genCntnrObj = Ext.getCmp('restDataConfigurationWindow');
			genCntnrObj.removeAll();
			var urlStr = publicJSON.forwardURL;
			qString = 'ICTest/data/'+urlStr;
			genCntnrObj.add({
				xtype : 'defaultthresholds'
			});
		}

	},
	showModifyMeasure: function(modifyURL)
	{
		var publicJSONTmp;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+modifyURL+'&testType=REST',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSONTmp = Ext.decode( jsonText );
				}
			}
		});
		Ext.create('Ext.window.Window', {
			title: modMeas,
		//	height: 350,
			width: 500,
			id:'modScriptMeasureWindow',
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'form',
					id: 'measureform',
					name: 'measureform',
					url: 'ICTest/data/EgmodifymeasurespJson.jsp',
				//	height: 350,
					width: 500,
					layout:{
						type:'vbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 400,
						labelWidth: 200
					},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: measName,
							id:'s_measure',
							name:'s_measure',
							maxLength: 24,
							enforceMaxLength: true,
							value: publicJSONTmp.measureName,
							margin: '10 5 0 5'
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_dbsize',
							name:'s_dbsize',
							fieldLabel: dbColSize,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_un',
							name:'s_un',
							fieldLabel: unit,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							//editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										datasetCtrlr.otherUnit('modify');
									}
								}
							}
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: other,
							id:'s_otherunit',
							name:'s_otherunit',
							hidden: true,
							maxLength: 64,
							enforceMaxLength: true
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_process',
							name:'s_process',
							fieldLabel: procMthd,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										datasetCtrlr.processMethodChange('modify');
									}
								}
							}
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_factor',
							name:'s_factor',
							fieldLabel: convFact,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: alrmDispStr,
							id:'alarmdescription',
							name:'alarmdescription',
							maxLength: 75,
							enforceMaxLength: true,
							value: publicJSONTmp.alarmDispStrValue,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'container',
							layout:{
								type:'hbox',
								pack:'center',
								align:'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								//width: 400,
								//labelWidth: 200
							},
							items:[
								{
									xtype: 'textfield',
									cls : 'textbox',
									fieldLabel: 'API Measure Field',
									id:'restdatafld',
									name:'restdatafld',
									maxLength: 100,
									enforceMaxLength: true,
									hidden : true,
									value: publicJSONTmp.restDataFld,
									dataFieldParentNode: publicJSONTmp.restParentNodeDataField,
									labelWidth: 200,
									width: 370
								}
							]
						},
						{
							xtype: 'button',
							cls : 'button20',
							text: modifyTooltip,
							id:'modMeasureButton',
							width: 80,
							margin: '5 5 20 5',
							listeners:
							{
								click:{
									fn: function (id){
										var measure = Ext.getCmp('s_measure').getValue();
										var otherUnit = Ext.getCmp('s_otherunit').getValue();
										var unit = Ext.getCmp('s_un').getValue();
										var alrmDesc = Ext.getCmp('alarmdescription').getValue();
										var oid = Ext.getCmp('restdatafld').getValue();
										if (!datasetCtrlr.measureValidation(measure,unit,otherUnit,alrmDesc,oid))
										{
											return;
										}
										var uploadformObj = Ext.getCmp('measureform').getForm();
										if (uploadformObj.isValid())
										{
											var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
											var restformParams = encodeFieldParams(uploadformObj);
											tmpMask.show();

											var restDataFldObj=Ext.getCmp('restdatafld');

											if(!Ext.isEmpty(restDataFldObj))
											{
												restformParams += "&restParentNode"+"="+encodeURIComponent(filterEncode(Ext.getCmp('restdatafld').dataFieldParentNode));
											}

											if(!Ext.isEmpty(oid))
											{
												restformParams += "&restdatafld"+"="+encodeURIComponent(filterEncode(oid));
											}
											uploadformObj.submit({
												params: restformParams,
												method: 'POST',
												success: function (form, action) {
													tmpMask.hide();
													var jsonText = action.response.responseText;
													var tmpResult = Ext.decode(jsonText);

													if(tmpResult.AlertType == 'Result')
													{
														var test = Ext.getCmp('test').getValue();
														var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
														datasetCtrlr.loadAddMeasureTab(urlStr);
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function(response) {
																if(response == 'ok') {
																	Ext.getCmp('newtest').setActiveTab(3);
																}
															}
														});
													}
													else if(tmpResult.AlertType == 'Error')
													{
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconError',
															fn: function(response) {
																if(response == 'ok') {
																	var test = Ext.getCmp('test').getValue();
																	var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
																	datasetCtrlr.loadAddMeasureTab(urlStr);
																}
															}
														});
													}
												}
											});
										}
										Ext.getCmp('modScriptMeasureWindow').close();
									}
								}
							}
						},
						{
							xtype: 'container',
							id:'hiddenContnr',
							hidden:true
						}
					]
				}
			]
		}).show();
		
		if (!isConfigTest)//new feed
		{
			Ext.getCmp('s_dbsize').getStore().loadRawData(publicJSONTmp.dbColSizeList);
			Ext.getCmp('s_dbsize').setValue(publicJSONTmp.dbColSizeSelected);
			Ext.getCmp('s_un').getStore().loadRawData(publicJSONTmp.unitsList);
			Ext.getCmp('s_un').setValue(publicJSONTmp.unitSelected);
			Ext.getCmp('s_process').getStore().loadRawData(publicJSONTmp.processMethodList);
			Ext.getCmp('s_process').setValue(publicJSONTmp.selectedProcessMethod);
			var convFactObj = Ext.getCmp('s_factor');
			if (!publicJSONTmp.hideConvFactor)
			{				
				convFactObj.show();
				convFactObj.getStore().loadRawData(publicJSONTmp.convFactorList);
				convFactObj.setValue(publicJSONTmp.convFactorSelected);
			}
			else{
				convFactObj.hide();
			}
		}
		else
		{
			Ext.getCmp('measureform').setHeight(100);
			Ext.getCmp('modScriptMeasureWindow').setHeight(150);
		}

		var hiddenParams = publicJSONTmp.hiddens;
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: filterEncode(hiddenParams[param])
				});
		}
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	},
	filterEncode: function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%','\'','&'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	addMeasureInternalValueConfiguration : function(btnObj)
	{
		var validationResult=this.addReqParamValidateForm();
		if(validationResult)
		{
			var keyobj=Ext.getCmp('param_key');
			var valueobj=Ext.getCmp('param_value');
			var key=keyobj.getValue();
			var value=valueobj.getValue();
			var gridObj = this.getRestMeasureMappingGrid();
			var gridStore = gridObj.getStore();
			var configuredData=[];
			if(!Ext.isEmpty(gridStore))
			{
				var measRecord = gridStore.findRecord('key',key, 0, false, true, true);
				var dsIdx = gridStore.indexOf(measRecord);
				if(dsIdx>-1)
				{
					Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['MeasureIntValueExist'],
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
						});
					return false;
				}
			}
			if(!Ext.isEmpty(value))
			{
				value=value.trim();
			}
			if(!Ext.isNumeric(value))
			{
				Ext.Msg.show({
						title: screenLabelsObj['DSNTitle'],
						msg: screenLabelsObj['validNumericvalueMsg'],
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
				});
				return false;
			}
			configuredData.push({
					//measure :metricName,
					key : key,
					value : value
				});
			gridStore.add(configuredData);
			gridObj.doLayout();
			keyobj.reset();
			valueobj.reset();
		}
	}
});