Ext.define('ICTest.controller.AddSnmpTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['ICTest.view.AddNewTest'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'},
		{selector:'defaultthresholds', ref:'defaultthresholds'},
	],
	init:function(){
		snmpCtrlr = this;
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
			'addnewtest combo[id="elements"]':
			{
				'select': this.elementsSelection
			},
			'addnewtest button[id="elmtMib"]':
			{
				'click': this.showElementMibTree
			},
			'addnewtest button[id="statusMib"]':
			{
				'click': this.showElementStatusTree
			}
		});
	},
	afterMainRender: function()
	{
	},
	loadAddMeasureTab: function(urlStr)
	{
		var me = this;
		Ext.getCmp('addNewMeasure').show();
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var existingMeass = publicJSON.measuresList;
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		cntnrObj.removeAll();
		if (publicJSON.noMeasuresAdded)
		{
			Ext.getCmp('noMeasureFnd').show();
			Ext.getCmp('generateCntnr').disable();
			Ext.getCmp('tab6Help').disable();
		}
		else
		{
			Ext.getCmp('noMeasureFnd').hide();
			for (var p=0; p<existingMeass.length; p++) {
					var measure = existingMeass[p];
					if(!(measure.measureName == "Installed"))
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+measure.measureIndex+'. '+measure.measureName+'</b>',
						width: 500,
						items: [
							{
								xtype: 'container',
								layout: {
									type: 'vbox',
									align: 'left',
									pack: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									margin: 5,
									labelWidth: 200 
								},
								items: [
									{
										xtype: 'displayfield',
										fieldLabel: dbColSize,
										id : 'dbSize'+p,
										value: measure.databaseColumnSize,
										hidden: measure.hideDatabaseColumnSize
									},
									{
										xtype: 'displayfield',
										id : 'unitVal'+p,
										fieldLabel: unit,
										value: filterDecode(measure.unit)
									},
									{
										xtype: 'displayfield',
										fieldLabel: procMthd,
										id : 'processMethodVal'+p,
										value: measure.processMethod
									},
									{
										xtype: 'displayfield',
										fieldLabel: convFact,
										id : 'conFact'+p,
										value: measure.conversionFactor,
										hidden: measure.hideConversionFactor
									},
									{
										xtype: 'displayfield',
										fieldLabel: alrmDispStr,
										id : 'alarmDisp'+p,
										value: measure.alarmDispString,
										hidden: measure.hideAlarmDispStr
									},
									{
										xtype: 'displayfield',
										fieldLabel: objOID,
										id : 'objId'+p,
										value: measure.objectOID,
									}
								]
							},
							{
								xtype: 'container',
								layout: {
									type: 'hbox',
									pack: 'center'
								},
								defaults: {
									width: 80
								},
								items:[
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: measure.modifyURL,
										handler: function() {
											me.showModifyMeasure(this.modifyURL);
										},
										margin: '5 0 10 0'
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										deleteURL: measure.deleteURL,
										measureName: measure.measureName,  
										handler: function() {
											me.deleteMeasure(this.deleteURL, this.measureName);
										},
										margin: '5 0 10 20'
									}
								]
							}
						]
					});
					var dbColSize1 = Ext.getCmp('dbSize'+p);
					var unitVal = Ext.getCmp('unitVal'+p);
					var processMethodVal = Ext.getCmp('processMethodVal'+p);
					var conFact = Ext.getCmp('conFact'+p);
					var alrmDisp = Ext.getCmp('alarmDisp'+p);
					var objId = Ext.getCmp('objId'+p);
					if(isConfigTest)
					{
						dbColSize1.hide();
						unitVal.hide();
						processMethodVal.hide();
						conFact.hide();
						alrmDisp.hide();
						objId.show();
					}
				//	else
				//	{
				//		dbColSize1.show();
				//		unitVal.show();
				//		processMethodVal.show();
				//		conFact.show();
				//		alrmDisp.show();
				//		objId.show();
				//	}
				}
			}
		}
	},
	showAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var urlStr = "EgConfigSnmpMeasureJson.jsp?test=" + test;
		me.loadAddMeasureTab(urlStr);
		selMibFile = '';
		selElmtFile = '';
		selStusFile = '';
		oidFldName = '';
		elmtFldName = '';
		stusFldName = '';
		Ext.create('Ext.window.Window', {
			title: newMeasDetail,
			width: 500,
			id:'addSnmpMeasureWindow',
			layout:{
				type:'vbox',
				pack:'start',
				align:'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 400,
				labelWidth: 200
			},
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measIdx,
					id:'index',
					name:'index',
					margin: '10 5 0 5'
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measName,
					id:'measure',
					name:'measure',
					maxLength: 24,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'dbsize',
					name:'dbsize',
					fieldLabel: dbColSize,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'un',
					name:'un',
					fieldLabel: unit,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					//editable: false,
					listeners:
					{
						select:{
							fn: function (id){
								me.otherUnit('add');
							}
						}
					}
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: other,
					id:'otherunit',
					name:'otherunit',
					hidden: true,
					maxLength: 64,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'process',
					name:'process',
					fieldLabel: procMthd,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false,
					listeners:
					{
						select:{
							fn: function (id){
								me.processMethodChange('add');
							}
						}
					}
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'cFactor',
					name:'cFactor',
					fieldLabel: convFact,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: alrmDispStr,
					id:'alarmdescription',
					name:'alarmdescription',
					maxLength: 75,
					enforceMaxLength: true
				},
				{
					xtype: 'container',
					layout:{
						type:'hbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
//						margin: 5,
//						width: 350,
						labelWidth: 200
				},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: objOID,
							id:'oid',
							name:'oid',
							//maxLength: 100,
							width: 380,
							//enforceMaxLength: true
						},
						{
							xtype: 'button',
							iconCls:'iconTree',
							border:0,
							style:{
								'background':'none'
							},
							listeners: {
								el: {
									click: function() {
										me.showMibTree('config','ObjectOID');
									}
								}
							}
						}
					]
				},
				{
					xtype: 'button',
					cls : 'button20',
					text: add,
					id:'addMeasureButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								me.doAddNewMeasure();
							}
						}
					},
					margin: '5 5 20 5'
				}
			]
		}).show();

		Ext.getCmp('index').setValue(publicJSON.measIndex);
		var dbSizeObj = Ext.getCmp('dbsize');
		var alrmDescObj = Ext.getCmp('alarmdescription');
		var processMethod = Ext.getCmp('process');
		var unitObj = Ext.getCmp('un');
		var process = '';
		if (isConfigTest)
		{
			dbSizeObj.hide();
			alrmDescObj.hide();
			processMethod.hide();
			unitObj.hide();
		}
		else
		{
			dbSizeObj.show();
			dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
			dbSizeObj.setValue("2");
			alrmDescObj.show();
			Ext.getCmp('process').getStore().loadRawData(publicJSON.processMethodList);
			process = publicJSON.selectedProcessMethod;
			Ext.getCmp('process').setValue(process);
			Ext.getCmp('un').getStore().loadRawData(publicJSON.unitsList);
			Ext.getCmp('un').setValue("-1");
		}
		var convFactObj = Ext.getCmp('cFactor');
		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			convFactObj.show();
			convFactObj.getStore().loadRawData(publicJSON.convFactorList);
			convFactObj.setValue(publicJSON.convFactorSelected);
		}
		else
		{
			convFactObj.hide();
		}
	},
	otherUnit: function(from)
	{
		var unitObj = Ext.getCmp('un');
		var otherUnitObj = Ext.getCmp('otherunit');
		if (from == 'modify')
		{
			unitObj = Ext.getCmp('s_un');
			otherUnitObj = Ext.getCmp('s_otherunit');
		}

		if(unitObj.getValue() == 'other')
		{
			otherUnitObj.show();
			otherUnitObj.enable();
		}
		else
		{
			otherUnitObj.hide();
			otherUnitObj.disable();
		}
	},
	processMethodChange: function(from)
	{
		var process;
		var factorObj;
		if (from == 'add')
		{
			process = Ext.getCmp('process').getValue();
			factorObj = Ext.getCmp('cFactor');
		}
		else if (from == 'modify')
		{
			process = Ext.getCmp('s_process').getValue();
			factorObj = Ext.getCmp('s_factor');
			factorObj.getStore().loadRawData(publicJSON.convFactorList);
			factorObj.setValue(publicJSON.convFactorSelected);
		}

		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			factorObj.show();
			factorObj.enable();
		}else
		{
			factorObj.hide();
			factorObj.disable();
		}		
	},
	doAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var index = Ext.getCmp('index').getValue();
		var measure = Ext.getCmp('measure').getValue();
		var factor = Ext.getCmp('cFactor').getValue();
		var dbSize = Ext.getCmp('dbsize').getValue();
		var otherUnit = Ext.getCmp('otherunit').getValue();
		var unit = Ext.getCmp('un').getValue();
		var alrmDesc = Ext.getCmp('alarmdescription').getValue();
		var process = Ext.getCmp('process').getValue();
		var oid = Ext.getCmp('oid').getValue();
		if(process == null && isConfigTest)
		{
			process = 'UNALTERED';
			factor = '1';
		}
		if (process != 'UNALTERED' && process != 'DIFFERENCE')
		{
			factor = 'none';
		}
		var urlStr =  'ICTest/data/EgconfigsnmpmeasurepJson.jsp?add=add&test='+test+'&measure='+measure+'&factor='+factor+'&oid='+oid;
		urlStr += '&dbsize='+dbSize+'&otherunit='+otherUnit+'&un='+encodeURIComponent(filterEncode(unit))+'&alarmdescription='+encodeURIComponent(alrmDesc)+'&index='+index+'&process='+process;
		urlStr += '&fileName='+encodeURIComponent(filterEncode(selMibFile))+'&oid_fieldName='+oidFldName;

		if (!this.measureValidation(measure,unit,otherUnit,alrmDesc,oid))
		{
			return;
		}
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: error+': '+publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError',
				fn: function(btn)
				{
					if(btn == 'ok')
					{
						Ext.getCmp('addSnmpMeasureWindow').close();
						me.showAddNewMeasure();
					}
				}
			});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('tab6Help').enable();
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg + '. '+ alertMsg80,
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				closable: false,
				fn: function(response) {
					if(response == 'yes') {
						Ext.getCmp('addSnmpMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						me.showAddNewMeasure();
					}
					else if (response == 'no')
					{
						Ext.getCmp('addSnmpMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);

						//Ext.getCmp('generateCntnr').enable();
						//Ext.getCmp('tab6Help').enable();
						Ext.getCmp('newtest').setActiveTab(4);
					}
				}
			});
		}
	},
	measureValidation: function(meas,unit,otherUnit,alarmStr,oid)
	{
		var me=this;
		var measObj = Ext.getCmp('measure');
		var alrmStrObj = Ext.getCmp('alarmdescription');
		var otherUnitObj = Ext.getCmp('otherunit');
		var oidObj = Ext.getCmp('oid');
		var keyArr = new Array("other","none","null","all");
		var isConfigTest = false;
		var alarmDispStr=true;
		var type = Ext.getCmp('type').getValue()
		if (type != null && type == 'Configuration')
		{
			isConfigTest = true;
		}
		if (!isConfigTest)
		{
			if(!me.checkSpecialChar(alarmStr,"~!@#$%^&*()|:,;'<>"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: splCharAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				alrmStrObj.focus(true);
				return false;
			}
			if(isDouble=="false")
			{
				alarmDispStr = validateSingleByte(alarmStr);
			}
		}
		meas = meas.toUpperCase();
		if(meas == "TRGT_HOST" || meas == "PORT_NO"
			|| meas == "SITE_NAME" || meas == "INFO"
			|| meas == "MSMT_HOST" || meas == "MSMT_TIME")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg14,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var ch = meas.charAt(0);
		var un=!isConfigTest?unit:"NONE";
		if(!checkblank(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspace(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: _checkblank + " " + valIn + " " + measName,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(meas, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch >= '0' && ch <= '9')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch == '_')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg18,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(un == "-1")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg19,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!alarmDispStr)
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg20,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			alrmStrObj.focus(true);
			return false;
		}
		else if(un == "other")
		{
			if(!checkblank(otherUnit))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg21,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			else if(!checkspace(otherUnit))
			{
				otherUnitObj.focus(true);
				return false;
			}
			else if(!checkspecialnomess(otherUnit, "`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
			else if (!checkKeywords(otherUnit,keyArr))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg22,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
		}
		else if(!checkblank(oid))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg46,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			oidObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(oid, "`~!@#$%^&*()+=-_?\'\"]{}[\\|;:,><"))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			oidObj.focus(true);
			return false;
		}
		else if(checkAlpha(oid))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg47,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			oidObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(oid))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg48,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			oidObj.focus(true);
			return false;
		}
		return true;
	},
	deleteMeasure: function(deleteURL, measureName)
	{
		var me = this;
		Ext.Msg.show({
			title: addMeasure,
			msg:alertMsg45+ ' \''+measureName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddMeasureTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	},
	elementsSelection: function()
	{
		var selVal = Ext.getCmp('elements').getValue();
		var textCntnrObj = Ext.getCmp('multiGroup');
		var dbSizeObj = Ext.getCmp('dbSizeGen');
		var isConfigTest = false;
		var descBasedObj = '';
		var type = Ext.getCmp('type').getValue()
		if (type != null && type == 'Configuration')
		{
			isConfigTest = true;
		}
		if (selVal == 'Single Element')
		{
			textCntnrObj.hide();
			textCntnrObj.disable();
			dbSizeObj.setWidth(450);
			if(isConfigTest)
			{
				descBasedObj = Ext.getCmp('isDescriptorBasedTestSnmp');
				descFielLabelObj = Ext.getCmp('descCheckBox');
				descBasedObj.hide();
				descFielLabelObj.hide();
			}
		}
		else if (selVal == 'Multiple Elements')
		{
			textCntnrObj.show();
			textCntnrObj.enable();
			dbSizeObj.setWidth(450);
			if(isConfigTest)
			{
				descBasedObj = Ext.getCmp('isDescriptorBasedTestSnmp');
				descFielLabelObj = Ext.getCmp('descCheckBox');
				descBasedObj.show();
				descFielLabelObj.show();
				descBasedObj.setValue(true);
				descBasedObj.setReadOnly(true);
			}
		}
	},
	generateSnmpTest: function()
	{
		var selVal = Ext.getCmp('elements').getValue();
		var eleOid = '';
		var valOid = '';
		var validVal = '';
		var rediscVal = '';
		if (selVal == 'Multiple Elements')
		{
			var eleOidObj = Ext.getCmp('elementOid');
			eleOid =  eleOidObj.getValue();
			var valoidObj = Ext.getCmp('validOid');
			valOid = valoidObj.getValue();
			var validObj = Ext.getCmp('validValue');
			validVal = validObj.getValue();
			var rediscObj = Ext.getCmp('rediscPeriod');
			rediscVal = rediscObj.getValue();
			if(!checkblank(eleOid))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg49,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							eleOidObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!checkspecialnomess(eleOid, "`~!@#$%^&*()+=-_?\'\"]{}[\\|;:,><"))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							eleOidObj.focus(true);
						}
					}
				});
				return;
			}
			else if(checkAlpha(eleOid))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg47,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							eleOidObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!validateSingleByte(eleOid))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg50,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							eleOidObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!validateSingleByte(valOid))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg51,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							valoidObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!validateSingleByte(validVal))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg52,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							valoidObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!checkblank(rediscVal))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg53,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							rediscObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!checkspecialnomess(rediscVal, "`~!@#$%^&*()+=-_?\'\"]{}[\\|;.:,><"))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							rediscObj.focus(true);
						}
					}
				});
				return;
			}
			else if(checkAlpha(rediscVal))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg47,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							rediscObj.focus(true);
						}
					}
				});
				return;
			}
			else if(rediscVal == 0)
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg54,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							rediscObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!validateSingleByte(rediscVal))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg55,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							rediscObj.focus(true);
						}
					}
				});
				return;
			}
			if (publicJSON.snmpElement != null && publicJSON.snmpElement != "" && publicJSON.snmpElement != undefined)
			{
				alert(alertMsg30);
			}
		}

		
		var test = Ext.getCmp('test').getValue();
		var urlStr =  'ICTest/data/EgconfigsnmpmeasurepJson.jsp?add=gen&test='+test+'&elementOid='+eleOid+'&validOid='+valOid+'&validValue='+validVal;
		urlStr += '&rediscPeriod='+rediscVal+'&element_fileName='+selElmtFile+'&status_fileName='+selStusFile+'&element_fieldName='+elmtFldName+'&status_fieldName='+stusFldName;
	
		if (isConfigTest)
		{
			var dbSize = Ext.getCmp('dbSizeGen').getValue();
			var descVal = Ext.getCmp('isDescriptorBasedTestSnmp').getValue();
			urlStr += '&dbsize='+dbSize+'&descVal='+descVal;
		}
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		
		if (publicJSON.AlertType=='Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError'
			});
		}
		else if (publicJSON.AlertType=='Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'ok') {
						window.location.href= '/final/admin/EgUDTest.jsp';
					}
				}
			});
		}
		if (!Ext.isEmpty(publicJSON.forwardURL))
		{
			this.getController('ICTest.controller.ThresholdCtrlr').init();
			var genCntnrObj = Ext.getCmp('generateCntnr');
			genCntnrObj.removeAll();
			var urlStr = publicJSON.forwardURL;
			qString = 'ICTest/data/'+urlStr;
			genCntnrObj.add({
				xtype : 'defaultthresholds'
			});
		}

	},
	showModifyMeasure: function(modifyURL)
	{
		var publicJSONTmp;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+modifyURL+'&testType=Snmp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSONTmp = Ext.decode( jsonText );
				}
			}
		});
		Ext.create('Ext.window.Window', {
			title: modMeas,
		//	height: 350,
			width: 500,
			id:'modScriptMeasureWindow',
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'form',
					id: 'measureform',
					name: 'measureform',
					url: 'ICTest/data/EgmodifymeasurespJson.jsp',
				//	height: 350,
					width: 500,
					layout:{
						type:'vbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 400,
						labelWidth: 200
					},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: measName,
							id:'s_measure',
							name:'s_measure',
							maxLength: 24,
							enforceMaxLength: true,
							value: publicJSONTmp.measureName,
							margin: '10 5 0 5'
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_dbsize',
							name:'s_dbsize',
							fieldLabel: dbColSize,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_un',
							name:'s_un',
							fieldLabel: unit,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							//editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										snmpCtrlr.otherUnit('modify');
									}
								}
							}
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: other,
							id:'s_otherunit',
							name:'s_otherunit',
							hidden: true,
							maxLength: 64,
							enforceMaxLength: true
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_process',
							name:'s_process',
							fieldLabel: procMthd,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										snmpCtrlr.processMethodChange('modify');
									}
								}
							}
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_factor',
							name:'s_factor',
							fieldLabel: convFact,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: alrmDispStr,
							id:'alarmdescription',
							name:'alarmdescription',
							maxLength: 75,
							enforceMaxLength: true,
							value: publicJSONTmp.alarmDispStrValue,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'container',
							layout:{
								type:'hbox',
								pack:'center',
								align:'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								//width: 400,
								//labelWidth: 200
							},
							items:[
								{
									xtype: 'textfield',
									cls : 'textbox',
									fieldLabel: objOID,
									id:'s_oid',
									name:'s_oid',
									//maxLength: 100,
									//enforceMaxLength: true,
									value: publicJSONTmp.oidValue,
									labelWidth: 200,
									width: 370
								},
								{
									xtype: 'button',
									iconCls:'iconTree',
									border:0,
									style:{
										'background':'none'
									},
									listeners: {
										el: {
											click: function() {
												snmpCtrlr.showMibTree('config','ObjectOID','modify',publicJSONTmp.oidValue,publicJSONTmp.hiddens.fileName);
											}
										}
									}
								}
							]
						},
						{
							xtype: 'button',
							cls : 'button20',
							text: modifyTooltip,
							id:'modMeasureButton',
							width: 80,
							margin: '5 5 20 5',
							listeners:
							{
								click:{
									fn: function (id){
										var measure = Ext.getCmp('s_measure').getValue();
										var otherUnit = Ext.getCmp('s_otherunit').getValue();
										var unit = Ext.getCmp('s_un').getValue();
										var alrmDesc = Ext.getCmp('alarmdescription').getValue();
										var oid = Ext.getCmp('s_oid').getValue();
										if (!snmpCtrlr.measureValidation(measure,unit,otherUnit,alrmDesc,oid))
										{
											return;
										}
										var uploadformObj = Ext.getCmp('measureform').getForm();
										if (uploadformObj.isValid())
										{
											var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
											var snmpform = encodeFieldParams(uploadformObj);
											var fileNme = Ext.getCmp('measureform').getForm().findField('fileName').getValue();
											Ext.getCmp('measureform').getForm().findField('fileName').setValue(filterEncode(fileNme));
											tmpMask.show();
											uploadformObj.submit({
												method: 'POST',
												params : snmpform,
												success: function (form, action) {
													tmpMask.hide();
													var jsonText = action.response.responseText;
													var tmpResult = Ext.decode(jsonText);

													if(tmpResult.AlertType == 'Result')
													{
														var test = Ext.getCmp('test').getValue();
														var urlStr = "EgConfigSnmpMeasureJson.jsp?test=" + test;
														snmpCtrlr.loadAddMeasureTab(urlStr);
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function(response) {
																if(response == 'ok') {
																	Ext.getCmp('newtest').setActiveTab(3);
																}
															}
														});
													}
													else if(tmpResult.AlertType == 'Error')
													{
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconError',
															fn: function(response) {
																if(response == 'ok') {
																	var test = Ext.getCmp('test').getValue();
																	var urlStr = "EgConfigSnmpMeasureJson.jsp?test=" + test;
																	snmpCtrlr.loadAddMeasureTab(urlStr);
																}
															}
														});
													}
												}
											});
										}
										Ext.getCmp('modScriptMeasureWindow').close();
									}
								}
							}
						},
						{
							xtype: 'container',
							id:'hiddenContnr',
							hidden:true
						}
					]
				}
			]
		}).show();
		
		if (!isConfigTest)//new feed
		{
			Ext.getCmp('s_dbsize').getStore().loadRawData(publicJSONTmp.dbColSizeList);
			Ext.getCmp('s_dbsize').setValue(publicJSONTmp.dbColSizeSelected);
			Ext.getCmp('s_un').getStore().loadRawData(publicJSONTmp.unitsList);
			Ext.getCmp('s_un').setValue(publicJSONTmp.unitSelected);
			Ext.getCmp('s_process').getStore().loadRawData(publicJSONTmp.processMethodList);
			Ext.getCmp('s_process').setValue(publicJSONTmp.selectedProcessMethod);
			var convFactObj = Ext.getCmp('s_factor');
			if (!publicJSONTmp.hideConvFactor)
			{				
				convFactObj.show();
				convFactObj.getStore().loadRawData(publicJSONTmp.convFactorList);
				convFactObj.setValue(publicJSONTmp.convFactorSelected);
			}
			else{
				convFactObj.hide();
			}
		}
		else
		{
			Ext.getCmp('measureform').setHeight(100);
			Ext.getCmp('modScriptMeasureWindow').setHeight(150);
		}

		var hiddenParams = publicJSONTmp.hiddens;
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
	},
	showMibTree: function(from, fieldName, action, oidValue, mibFileName)
	{
		var urlStr = 'showMibFilesJson.jsp?from='+from+'&fieldName='+fieldName;
		if (isModifyTest)
		{
			action = 'modify';
		}
		if (mibFileName == null || mibFileName=='' || mibFileName=='undefined')
		{
			mibFileName ='-1';
		}
		if (action != null && action == 'modify')
		{
			if (snmpElmtIDFile == '')
			{
				snmpElmtIDFile = publicJSON.hiddens.element_fileName;
			}
			if (snmpElmtStatusFile == '')
			{
				snmpElmtStatusFile = publicJSON.hiddens.status_fileName;
			}
			if (fieldName == 'ObjectOID')
			{
				urlStr += '&fileList='+encodeURIComponent(filterEncode(mibFileName))+'&OID='+oidValue;
			}
			else if (fieldName == 'ElementOID')
			{
				urlStr += '&fileList='+snmpElmtIDFile+'&OID='+snmpElmtID;
			}
			else if (fieldName == 'StatusOID')
			{
				urlStr += '&fileList='+snmpElmtStatusFile+'&OID='+snmpElmtStatus;
			}
		}
		
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		
		var me = this;
		Ext.create('Ext.window.Window', {
			title: 'MIB Tree',
			height: 478,
			width: 800,
			id:'mibWindow',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			listeners : {
				close : function()
				{
					Ext.Ajax.request({
					url:'ICTest/data/ictesthelpJson.jsp?selectTab=addMeasureTab&testType=Snmp',
					method:'POST'
					});
				}
			},

			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						pack:'center'
					},
					border: false,
					padding : '10 0 7 0',
					items: [
						{
							xtype: 'button',
							text: 'OK',
							id: 'ok',
							name: 'ok',
							width: 80,
							cls: 'quickMenuWhiteButton',
							listeners: {
								el: {
									click: function() {
										var curObjOid = Ext.getCmp('objOid').getValue();
										if (fieldName == 'ObjectOID')
										{
											var windowObj = Ext.getCmp('modScriptMeasureWindow');
											if(windowObj != undefined || windowObj != null)
											{
												Ext.getCmp('s_oid').setValue(curObjOid);
												var old_filename = Ext.getCmp('measureform').getForm().findField('fileName').getValue();
												var new_filename = Ext.getCmp('fileList').getValue();
												if(new_filename != null && old_filename !== new_filename)
												{
													Ext.getCmp('measureform').getForm().findField('fileName').setValue(new_filename);
												}
											}
											else
											{
												Ext.getCmp('oid').setValue(curObjOid);
											}
										}
										else if (fieldName == 'ElementOID')
										{
											Ext.getCmp('elementOid').setValue(curObjOid);
										}
										else if (fieldName == 'StatusOID')
										{
											Ext.getCmp('validOid').setValue(curObjOid);
										}
										Ext.getCmp('mibWindow').close();
									}
								}
							}
						}
					]
				}
			],

			items: [
				{
					xtype: 'container',
					border: true,
					//style: 'border: 1px solid lightGrey',
					cls:'border-theme',
					layout:{
						type:'vbox',
						align:'stretch'
					},
					flex: 0.5,
					margin: '5 0 5 5',
					items: [
						{
							xtype: 'fieldcontainer',
							layout: 'column',
							margin: 5,
							items: [
								{
									xtype: 'scrollcombo',
									cls : 'dropdown',
									id:'fileList',
									name:'fileList',
									fieldLabel: mibFiles,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									labelSeparator: '',
									editable: false,
									labelWidth: 60,
									listeners:
									{
										select:{
											fn: function (id){
												me.mibFileSelection(from,fieldName,action,true);
											}
										}
									},
									columnWidth: 0.9
								},
								{
									xtype: 'button',
									iconCls:'iconUpload',
									columnWidth: 0.1,
									border:0,
									style:{
										'background':'none'
									},
									tooltip: 'Upload',
									margin : '0 0 0 10',
									listeners:
									{
										click:{
											fn: function (){
												me.uploadMibFile(from,fieldName);
											}
										}
									},
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							id: 'treepanalCntnr',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							cls:'border-theme',
							margin: '0 5 5 5',
							flex: 1
						},
						{
							xtype: 'textfield',
							cls:'textbox',
							fieldLabel: 'OID',
							id: 'objOid',
							labelSeparator: '',
							labelWidth: 60,
							margin: '0 5 5 5'
						}
					]
				},
				{
					xtype: 'container',
					border: true,
					//style: 'border: 1px solid lightGrey',
					cls:'border-theme',
					flex: 0.5,
					layout: {
						type:'hbox',
						align:'stretch'
					},
					margin: '5 5 5 5',
					items: [
						{
							xtype: 'container',
							id:'displayFieldCntnr',
							layout: {
								type:'vbox',
								align:'stretch'
							},
							defaults: {
								labelSeparator: '',
								labelAlign: 'top',
								readOnly: true
							},
							flex: 1,
							hidden: true,
							items: [
								{
									xtype: 'textfield',
									cls:'textbox',
									fieldLabel: 'Name',
									id: 'name',
									margin: '9 5 5 5'
								},
								{
									xtype: 'textarea',
									fieldLabel: 'Fullname',
									cls:'text-area',
									id: 'fullname',
									margin: '5 5 5 5'
								},
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator: '',
										columnWidth: 0.5,
										labelAlign: 'top',
										readOnly: true
									},
									margin: '5 5 5 5',
									items: [
										{
											xtype: 'textfield',
											cls:'textbox',
											fieldLabel: 'Access',
											id: 'access'
										},
										{
											xtype: 'textfield',
											cls:'textbox',
											fieldLabel: 'Syntax',
											id: 'syntax',
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator: '',
										columnWidth: 0.33,
										labelAlign: 'top',
										readOnly: true
									},
									margin: '5 5 5 5',
									items: [
										{
											xtype: 'textfield',
											cls:'textbox',
											fieldLabel: 'Status',
											id: 'status',
											columnWidth: 0.34
										},
										{
											xtype: 'textfield',
											cls:'textbox',
											fieldLabel: 'IsIndexNode',
											id: 'isIndexNode',
											margin: '0 0 0 5'
										},
										{
											xtype: 'textfield',
											cls:'textbox',
											fieldLabel: 'IsV2Trap',
											id: 'isV2Trap',
											margin: '0 0 0 5'
										}
									]
								},
								{
									xtype: 'textarea',
									cls:'text-area',
									fieldLabel: 'Description',
									id: 'description',
									margin: '5 5 5 5',
									rows: 6
								}
							]
						}
					]
				}
			]
		}).show();
		Ext.getCmp('fileList').getStore().loadRawData(publicJSON.mibFilesList);
		if (action != null && action == 'modify')
		{
			if (fieldName == 'ElementOID')
			{
				if(snmpElmtIDFile == null || snmpElmtIDFile == undefined || snmpElmtIDFile == '')
				{
					Ext.getCmp('fileList').setValue("-1");
				}
				else
				{
					Ext.getCmp('fileList').setValue(snmpElmtIDFile);
					me.mibFileSelection(from,fieldName,action,false);
				}
			}
			else if (fieldName == 'StatusOID')
			{
				if(snmpElmtStatusFile == null || snmpElmtStatusFile == undefined || snmpElmtStatusFile == '')
				{
					Ext.getCmp('fileList').setValue("-1");
				}
				else
				{
					Ext.getCmp('fileList').setValue(snmpElmtStatusFile);
					me.mibFileSelection(from,fieldName,action,false);
				}
			}
			else
			{
				Ext.getCmp('fileList').setValue(publicJSON.hiddens.fileName);
				me.mibFileSelection(from,fieldName,action,false);
			}
		}
		else
		{
			Ext.getCmp('fileList').setValue("-1");
		}
	},
	uploadMibFile: function(from, fieldName)
	{
		var me = this;
		Ext.widget('window', {
			title: fileUpload,
			width: 350,
			height: 150,
			id: 'file',
			name: 'file',
			resizable: 'false',
			items: [{
				xtype: 'form',
				id: 'uploadform',
				name: 'uploadform',
				url: '../servlet/com.eg.EgUploadServlet',
				height: 150,
				items: [{
					xtype: 'fileuploadfield',
					cls: 'fileupload',
					id: 'file1',
					name: 'file1',
					labelSeparator: '',
					emptyText: noFileSel,
					fieldLabel: file2Upload,
					labelAlign: 'top',
					width: 290,
					buttonText: 'Browse',
					margin: '15 0 0 15',
				},
				{
					xtype: 'button',
					text: upload,
					id: 'upload',
					name: 'upload',
					action: 'upload',
					cls: 'button20',
					align: 'center',
					margin: '15 0 0 140',
					handler: function (button, e)
					{
						var selFile = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
						var n = selFile.lastIndexOf("fakepath");
						if(n > 0)
						{
							selFile = selFile.substring(n+9);
						}
						var exten_str="";
						var exten_idx = selFile.lastIndexOf(".");
						if(exten_idx > 0)
							exten_str = selFile.substring(exten_idx);
						exten_str = exten_str.toLowerCase();
		
						var validate = true;
						if(!validateSingleByte(selFile))
						{
							Ext.Msg.show({
								title: fileUpload,
								msg: alertMsg23,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if(selFile=="")
						{
							Ext.Msg.show({
								title: fileUpload,
								msg: alertMsg24,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if (exten_str != ".txt" && exten_str != ".mib")
						{
							Ext.Msg.show({
								title: fileUpload,
								msg: alertMsg74,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}

						if (!validate)
						{
							return false;
						}
						else
						{
							if(publicJSON.existingFiles.indexOf(selFile)!=-1)
							{
								Ext.Msg.show({
									title: fileUpload,
									msg: alertMsg73,
									buttons: Ext.Msg.OKCANCEL,
									icon: 'iconConfirmation',
									fn: function(response) {
										if(response == 'ok') {
											var uploadformObj = Ext.getCmp('uploadform').getForm();
											if (uploadformObj.isValid())
											{
												uploadformObj.submit({
													method: 'POST',
													success: function (form, action) {
														var jsonText = action.response.responseText;
														var tmpResult = Ext.decode(jsonText);
														if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
														{
															button.up('.window').close();
															//me.showMibTree(from, fieldName);
															Ext.Msg.show({
																title:fileUpload,
																msg:alertMsg82,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function(response)
																{
																	if (response == 'ok')
																	{
																		Ext.getCmp('mibWindow').close();
																		me.showMibTree(from, fieldName);
																	}
																}
															});
														}
														else
														{
															//button.up('.window').close();
															Ext.Msg.show({
																title: fileUpload,
																msg: tmpResult.statusMsg,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function(response)
																{
																	if (response == 'ok')
																	{
																		//Ext.getCmp('mibWindow').close();
																		//me.showMibTree(from, fieldName);
																	}
																}
															});
														}
													},
													failure: function (form, action) 
													{
														Ext.Msg.alert(fileUpload, 'Not able to upload the selected MIB file. Please try again');
													}
												});
											}
											else
											{}
										}
										else
										{
											button.up('.window').close();
										}
									}
								});
							}
							else
							{
								var uploadformObj = Ext.getCmp('uploadform').getForm();
								if (uploadformObj.isValid())
								{
									uploadformObj.submit({
										method: 'POST',
										success: function (form, action) {
											var jsonText = action.response.responseText;
											var tmpResult = Ext.decode(jsonText);
											if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
											{
												button.up('.window').close();
												//me.showMibTree(from, fieldName);
												Ext.Msg.show({
													title: fileUpload,
													msg: alertMsg82,
													buttons: Ext.Msg.OK,
													icon: 'iconInformation',
													fn: function(response)
													{
														if (response == 'ok')
														{
															Ext.getCmp('mibWindow').close();
															me.showMibTree(from, fieldName);
														}
													}
												});
											}
											else
											{
												//button.up('.window').close();

												Ext.Msg.show({
													title: fileUpload,
													msg: tmpResult.statusMsg,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function(response)
													{
														if (response == 'ok')
														{
															//Ext.getCmp('mibWindow').close();
															//me.showMibTree(from, fieldName);
														}
													}
												});
											}
										},
										failure: function (form, action) 
										{
											Ext.Msg.alert(fileUpload, 'Not able to upload the selected MIB file. Please try again');
										}
									});
								}
								else
								{}
							}
						}
					}
				}],
				listeners: {
					afterrender: function () {
						var formObj = Ext.getCmp('uploadform');
						formObj.add({
							xtype: 'hidden',
							name: 'uploadMIB',
							value: 'true'
						});
						formObj.add({
							xtype: 'hidden',
							name: 'fromMIBBrowser',
							value: 'true'
						});
						formObj.add({
							xtype: 'hidden',
							name: 'comeFrom',
							value: 'icMIB'
						});
					},
				}
			}]
		}).show()
	},
	mibFileSelection: function(from,fieldName,action,isViaSelection)
	{
		var oid = '';
		var expanded = false;
		var selFile = Ext.getCmp('fileList').getValue();
		if (fieldName == 'ElementOID')
		{
			selElmtFile = selFile;
			elmtFldName = fieldName;
		}
		else if (fieldName == 'StatusOID')
		{
			selStusFile = selFile;
			stusFldName = fieldName;
		}
		else
		{
			selMibFile = selFile;
			oidFldName = fieldName; 
		}
		var src = 'mibTree.jsp?MibFileName='+encodeURIComponent(filterEncode(selFile))+'&fieldName='+fieldName+'&from='+from+'&expanded='+expanded;
		if (action == 'modify')
		{
			var fileName = publicJSON.hiddens.fileName;
			var oidVal = publicJSON.oidValue;
			oid = oidVal;
			if (isViaSelection)
			{
				fileName = selFile;
				oidVal = '';
			}
			else
			{
				expanded = true;
				Ext.getCmp('fileList').setValue(fileName);
			}
			src = 'mibTree.jsp?MibFileName='+encodeURIComponent(filterEncode(fileName))+'&fieldName='+fieldName+'&from='+from+'&oid='+oidVal+'&expanded='+expanded;
		}
		if(selFile != '-1')
		{
			var treeStore = Ext.create('Ext.data.TreeStore', {
				fields: [
					{name: 'text', type: 'string'},
					{name: 'leaf', type: 'boolean'},
					{name: 'expanded', defaultValue: true},
					{name: 'id', type: 'string'},
					{name: 'name', type: 'string'},
					{name: 'fullName', type: 'string'},
					{name: 'syntax', type: 'string'},
					{name: 'access', type: 'string'},
					{name: 'status', type: 'string'},
					{name: 'isIndexNode', type: 'boolean'},
					{name: 'isV2Trap', type: 'boolean'},
					{name: 'description', type: 'string'},
				]
			});
			Ext.Ajax.request({
				url: src,
				success: function(response){
					var data = Ext.decode(response.responseText);
					if(data.jsonarray == null || data.jsonarray.length > 0)
					{
						treeStore.setRootNode({
							text: 'MIB Tree',
							id:'',
							iconCls: 'iconTree',
							expandable: false,
							children: data.jsonarray
						});
						Ext.getCmp('treepanalCntnr').show();
						Ext.getCmp('displayFieldCntnr').show();
						Ext.getCmp('objOid').show();
						Ext.getCmp('treepanalCntnr').removeAll();
						var treePanel = Ext.create('Ext.tree.Panel',{
							flex: 1,
							rootVisible: true,
							cls:'treePanelDesign',
							//useArrows: true,
							animate: false,
							store : treeStore,
							listeners: {
								itemclick : function(view, record){
									if(record.get('id') != "")
									{
										Ext.getCmp('objOid').setValue(record.get('id'));
										Ext.getCmp('name').setValue(record.get('name'));
										Ext.getCmp('fullname').setValue(record.get('fullName'));
										Ext.getCmp('syntax').setValue(record.get('syntax'));
										Ext.getCmp('access').setValue(record.get('access'));
										Ext.getCmp('status').setValue(record.get('status'));
										Ext.getCmp('isIndexNode').setValue(record.get('isIndexNode'));
										Ext.getCmp('isV2Trap').setValue(record.get('isV2Trap'));
										Ext.getCmp('description').setValue(record.get('description'));
									}
								}
							}
						});
						Ext.getCmp('treepanalCntnr').add(treePanel);
						if(oid != '')
						{
							if(isViaSelection)
							{
								Ext.getCmp('objOid').setValue("");
								Ext.getCmp('name').setValue("");
								Ext.getCmp('fullname').setValue("");
								Ext.getCmp('syntax').setValue("");
								Ext.getCmp('access').setValue("");
								Ext.getCmp('status').setValue("");
								Ext.getCmp('isIndexNode').setValue("");
								Ext.getCmp('isV2Trap').setValue("");
								Ext.getCmp('description').setValue("");
							}
							else
							{
								var record = treePanel.getStore().getNodeById(oid);
								treePanel.getSelectionModel().select(record);
								treeStore.getRootNode().cascadeBy(function(node){
									var nodeOid = node.raw.id;
									if(nodeOid == oid)
									{
										Ext.getCmp('objOid').setValue(node.raw.id);
										Ext.getCmp('name').setValue(node.raw.name);
										Ext.getCmp('fullname').setValue(node.raw.fullName);
										Ext.getCmp('syntax').setValue(node.raw.syntax);
										Ext.getCmp('access').setValue(node.raw.access);
										Ext.getCmp('status').setValue(node.raw.status);
										Ext.getCmp('isIndexNode').setValue(node.raw.isIndexNode);
										Ext.getCmp('isV2Trap').setValue(node.raw.isV2Trap);
										Ext.getCmp('description').setValue(node.raw.description);
									}
								});
							}
						}
					}
					else
					{
						var resultMsg = "Invalid MIB file";
						if (!Ext.isEmpty(data.validMsg))
						{
							resultMsg = data.validMsg;
						}
						Ext.getCmp('treepanalCntnr').show();
						Ext.getCmp('treepanalCntnr').removeAll();
						var emptyPanel = Ext.create('Ext.container.Container',{
							html: "<table align='center'><tr height=150><td valign='bottom' align='center'><div class='iconInformation'/></td></tr><tr><td valign='top' align='center'>"+resultMsg+"</td></tr></table>",
						});
						Ext.getCmp('objOid').setValue("");
						Ext.getCmp('treepanalCntnr').add(emptyPanel);
						Ext.getCmp('displayFieldCntnr').hide();
					}
				}
			});
		}
		else
		{
			Ext.getCmp('objOid').hide();
			Ext.getCmp('treepanalCntnr').hide();
			Ext.getCmp('displayFieldCntnr').hide();
		}
	},
	showElementMibTree: function()
	{
		var action = '';
		if (isModifyTest)
		{
			action = 'modify';
		}
		this.showMibTree('config','ElementOID',action);
	},
	showElementStatusTree: function()
	{
		var action = '';
		if (isModifyTest)
		{
			action = 'modify';
		}
		this.showMibTree('config','StatusOID',action);
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	}
	
});

