Ext.Msg.cls='adminAlert';
Ext.Msg.layout = {
	type: 'anchor',
	pack:'center',
	align: 'center'
};

Ext.define('GroupThreshold.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'componentgroups', ref:'componentgroups'},
		{selector:'componentgroup', ref:'componentgroup'},
		{selector:'componentgroupview', ref:'componentgroupview'},
		{selector:'thresholdrules', ref:'thresholdrules'},
		{selector:'thresholdrule', ref:'thresholdrule'},
		{selector:'configurethresholds', ref:'configurethresholds'},
		{selector:'associaterule', ref:'associaterule'},
		{selector:'associatedescriptors', ref:'associatedescriptors'}
	],
	init:function(){
		me = this,
		this.control({
			'componentgroups':
			{
				'afterrender': this.afterMainRender
			},
			'componentgroups trigger[id="searchTrigger"]':
			{
				'change': this.compGroupSearchEvent
			},
			'componentgroups button[id="fromSpecificBackBtn"]':
			{
				'click': this.specificThreshBack,
			},
			'componentgroups button[id="addCompGrpBtn"]':
			{
				'click': this.showAddCompGroupWindowEvent
			},
			'componentgroups button[id="rulePageBtn"]':
			{
				'click': this.showAddThresholdRuleWindowEvent
			},
			'componentgroups button[id="compGrpAssociateBtn"]':
			{
				'click': this.gotoAssociatePageEvent
			},
			'componentgroups grid[id="componentGroupGrid"]':
			{
				itemmouseenter: this.showTool,
				itemmouseleave: this.hideTool
			},
			'componentgroup':
			{
				'afterrender': this.afterAddComponentGroupRender
			},
			'componentgroup combo[id="compTypeCombo"]':
			{
				'select': this.compTypeComboEvent
			},
			'componentgroup button[id="updateBtnId"]':
			{
				'click': this.updateGroupEvent
			},
			'componentgroup button[id="newGroupPageBackBtn"]':
			{
				'click': this.newGroupPageBackEvent
			},
			'componentgroupview':
			{
				'afterrender': this.afterViewComponentGroupRender
			},
			'thresholdrules':
			{
				'afterrender': this.afterThresholdViewMainRender
			},
			'thresholdrules grid[id="thresholdRulesGrid"]':
			{
				itemmouseenter: this.showTool,
				itemmouseleave: this.hideTool
			},
			'thresholdrules trigger[id="searchRuleTrigger"]':
			{
				'change': this.thresholdRuleSearchEvent
			},
			'thresholdrules button[id="addNewRuleBtn"]':
			{
				'click': this.addNewRuleEvent
			},
			'thresholdrules button[id="thresholdRulesAssociateBtn"]':
			{
				'click': this.gotoAssociatePageEvent
			},
			'thresholdrules button[id="rulePageMainBackBtn"]':
			{
				'click': this.rulePageBackEvent
			},
			'thresholdrule':
			{
				'afterrender': this.afterThreshRuleCreateRender
			},
			'thresholdrule grid[id="measureGrid"]':
			{
				itemmouseenter: this.showModifyTool,
				itemmouseleave: this.hideModifyTool
			},
			'thresholdrule [id="noMeasureGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'thresholdrule button[id="newRulePageBackBtn"]':
			{
				'click': this.newRulePageBackEvent
			},
			'thresholdrule combo[id="ruleCompTypeCombo"]':
			{
				'select': this.ruleCompTypeChangeEvent
			},
			'thresholdrule combo[id="ruleTestNameCombo"]':
			{
				'select': this.ruleTestNameChangeEvent
			},
			'thresholdrule button[id="addNewRuleBtn"]':
			{
				'click': this.createNewRuleEvent
			},
			'configurethresholds':
			{
				'boxready': this.configureMainRender,
			},
			'configurethresholds checkbox[id="minStaticCheck"]':
			{
				'change': this.minStaticCheckChange,
			},
			'configurethresholds checkbox[id="minAutoCheck"]':
			{
				'change': this.minAutoCheckChange,
			},
			'configurethresholds checkbox[id="maxStaticCheck"]':
			{
				'change': this.maxStaticCheckChange,
			},
			'configurethresholds checkbox[id="maxAutoCheck"]':
			{
				'change': this.maxAutoCheckChange,
			},
			'configurethresholds combo[id="alarmPolicyCombo"]':
			{
				'select': this.alarmPolicyChange,
			},
			'configurethresholds button[id="updateBtn"]':
			{
				'click': this.applyThresholdsData
			},
			'configurethresholds button[id="configureBackBtn"]':
			{
				'click': this.configureThresholdsPageBack,
			},
			'configurethresholds slider[id="relMinCritical"]':
			{
				'drag': this.minRelCriticalSlider,
				'change': this.minRelCriticalSlider,
			},
			'configurethresholds slider[id="relMinMajor"]':
			{
				'drag': this.minRelMajorSlider,
				'change': this.minRelMajorSlider,
			},
			'configurethresholds slider[id="relMinMinor"]':
			{
				'drag': this.minRelMinorSlider,
				'change': this.minRelMinorSlider,
			},
			'configurethresholds slider[id="relMaxCritical"]':
			{
				'drag': this.maxRelCriticalSlider,
				'change': this.maxRelCriticalSlider,
			},
			'configurethresholds slider[id="relMaxMajor"]':
			{
				'drag': this.maxRelMajorSlider,
				'change': this.maxRelMajorSlider,
			},
			'configurethresholds slider[id="relMaxMinor"]':
			{
				'drag': this.maxRelMinorSlider,
				'change': this.maxRelMinorSlider,
			},
			'associaterule':
			{
				'afterrender': this.afterAssociateRuleRender
			},
			'associaterule combo[id="associateRuleNameCombo"]':
			{
				'select': this.associateRuleNameComboEvent
			},
			'associaterule combo[id="applyRuleTypeCombo"]':
			{
				'select': this.applyRuleTypeComboEvent
			},
			'associaterule button[id="associateRuleUpdateBtn"]':
			{
				'click': this.associateRuleUpdateEvent
			},
			'associaterule button[id="associateRuleBackBtn"]':
			{
				'click': this.associateRuleBackEvent
			},
			'associaterule combo[id="pattNameCombo"]':
			{
				'select': this.associatePatternComboEvent
			},
			'associatedescriptors':
			{
				'afterrender': this.afterAssociateDescriptorRender
			},
			'associatedescriptors button[id="associateDescUpdateBtn"]':
			{
				'click': this.associateDescriptorUpdateEvent
			},
			'associatedescriptors button[id="associateDescBackBtn"]':
			{
				'click': this.associateDescBackEvent
			},
			//'associatedescriptors trigger[id="strManagedSearch"]':
			//{
				//'change': this.descriptorSearch
			//},
			//'associatedescriptors trigger[id="strUnmanagedSearch"]':
			//{
				//'change': this.descriptorSearch
			//}
		});
	},
	descPatterRuleUpdateEvent : function()
	{
		var comp_type =  Ext.getCmp('applyRuleTypeCombo').getValue();
		var applyRule = comp_type;
		var policyNA = Ext.getCmp('associateRuleNameCombo').getValue(); 

		var pattNameComboVal =  Ext.getCmp('pattNameCombo').getValue();
		var pattNameText =  Ext.getCmp('pattNameText').getValue();
		var descPattern = pattNameComboVal;
		var fromModify = true;
		if (!Ext.isEmpty(Ext.getCmp('pattNameCombo')) && !Ext.getCmp('pattNameCombo').isVisible())
		{
			fromModify = false;
			descPattern = pattNameText;
		}
		else if (!Ext.isEmpty(pattNameComboVal) && (pattNameComboVal == null || pattNameComboVal.toLowerCase() == "null" || pattNameComboVal.toLowerCase() == "-1"))
		{
			fromModify = false;
			descPattern = pattNameText;
		}

		var allowUpdate = true;
		var patternName = descPattern; 

		var regExp = /[&,~^$%=<>;?\"\'\|]/;
		var patCheck = regExp.test(patternName);
		var testName = strTestName;

		if(Ext.isEmpty(patternName) || patternName == 'null' || patternName == 'undefined')
		{
			Ext.Msg.show({
				title: pageName,
				msg: pattErrMsg1,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus(true);
			return;
		}
		if(patternName.indexOf('*') != -1 && !checkStars(patternName))
		{
			Ext.getCmp('pattNameText').focus(true);
			allowUpdate = false;
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus(true);
			allowUpdate = false;
			return;
		}
		else if (!Ext.isEmpty(patternName) && patternName.indexOf('*') != -1  && patternName.length < 2)
		{
			Ext.Msg.show({ 
				title: pageName,
				msg: pattErrMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			allowUpdate = false;
			Ext.getCmp('pattNameText').focus(true);
			return false;
		}

		var pattNamesJson = publicJson['existInfoArr'];
		if(!fromModify && pattNamesJson != null && pattNamesJson.length > 0)
		{
			for(var x=0;x<pattNamesJson.length;x++)
			{
				if(pattNamesJson[x].toLowerCase() == patternName.toLowerCase())
				{
					Ext.Msg.show({
						title: pageName,
						msg: existPattNameAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('pattNameText').focus(true,true);
						}
					 });

					return;
				}
			}
		}

		if (!fromModify && !Ext.isEmpty(patternName) && patternName.indexOf('*') != -1)
		{
			var allContainsWildCardPatterns = publicJson['containsWildCardPatterns'];
			var allStartsWithWildCardPatterns = publicJson['startsWithWildCardPatterns'];
			var allEndsWithWildCardPatterns = publicJson['endsWithWildCardPatterns'];

			var containsWildCardPatterns = new Array();
			if (!Ext.isEmpty(allContainsWildCardPatterns))
			{
				containsWildCardPatterns = allContainsWildCardPatterns[policyNA];
			}
			var startsWithWildCardPatterns = new Array();
			if (!Ext.isEmpty(allStartsWithWildCardPatterns))
			{
				startsWithWildCardPatterns = allStartsWithWildCardPatterns[policyNA];
			}
			var endsWithWildCardPatterns = new Array();
			if (!Ext.isEmpty(allEndsWithWildCardPatterns))
			{
				endsWithWildCardPatterns = allEndsWithWildCardPatterns[policyNA];
			}

			var startsWithCond = false;
			var endsWithCond = false;

			// Make it  not case sensitive
			if (patternName.startsWith("*"))
				endsWithCond = true;
			if (patternName.endsWith("*"))
				startsWithCond = true;

			if (containsWildCardPatterns != null && containsWildCardPatterns.length > 0)
			{
				var currPattName = patternName;
				for(var c=0;c<containsWildCardPatterns.length;c++)
				{
					var existPattName = containsWildCardPatterns[c];
					if (startsWithCond && endsWithCond)
					{
						currPattName = patternName.substring(1, patternName.length -1);
						if(existPattName.toLowerCase() == currPattName.toLowerCase() || 
							existPattName.toLowerCase().indexOf(currPattName.toLowerCase()) != -1 ||
							currPattName.toLowerCase().indexOf(existPattName.toLowerCase()) != -1 )
						{
							Ext.Msg.show({
								title: pageName,
								msg: existPattNameAlertMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function()
								{
									Ext.getCmp('pattNameText').focus(true);
								}
							 });
							return;
						}
					}
					else if (startsWithCond || endsWithCond)
					{
						if (startsWithCond)
						{
							currPattName = patternName.substring(0, patternName.length -1);
						}
						else if (endsWithCond)
						{
							currPattName = patternName.substring(1);
						}

						if (existPattName.toLowerCase() == currPattName.toLowerCase() || 
							existPattName.startsWith(currPattName) ||
							existPattName.endsWith(currPattName))
						{
							Ext.Msg.show({
								title: pageName,
								msg: existPattNameAlertMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function()
								{
									Ext.getCmp('pattNameText').focus(true);
								}
							 });
							return;
						}
					}
				}
			}

			if (startsWithWildCardPatterns != null && startsWithWildCardPatterns.length > 0)
			{
				var currPattName = patternName.substring(0, patternName.length -1);

				for(var s=0;s<startsWithWildCardPatterns.length;s++)
				{
					var existPattName = startsWithWildCardPatterns[s];

					if (existPattName.toLowerCase() == currPattName.toLowerCase() || 
						existPattName.toLowerCase().startsWith(currPattName.toLowerCase()))
					{
						Ext.Msg.show({
							title: pageName,
							msg: existPattNameAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('pattNameText').focus(true);
							}
						});
						return;
					}
				}
			}

			if (endsWithWildCardPatterns != null && endsWithWildCardPatterns.length > 0)
			{
				var currPattName = patternName.substring(1);
				for(var e=0;e<endsWithWildCardPatterns.length;e++)
				{
					var existPattName = endsWithWildCardPatterns[e];

					if (existPattName.toLowerCase() == currPattName.toLowerCase() || 
						existPattName.toLowerCase().endsWith(currPattName.toLowerCase()))
					{
						Ext.Msg.show({
							title: pageName,
							msg: existPattNameAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('pattNameText').focus(true);
							}
						});
						return;
					}
				}
			}
		}

		var funmng = new Array();
		var fmng = new Array();
		var thisForm = document.TestList;
		var unmnglen = Ext.getCmp('associateRuleItemSelector').toField.store.getCount(); //thisForm.unmanaged.options.length;
		var mnglen = Ext.getCmp('associateRuleItemSelector').fromField.store.getCount(); //thisForm.managed.options.length;
		var funmglst = Ext.getCmp('associateRuleItemSelector').toField.store; //thisForm.unmanaged;
		var fmglst = Ext.getCmp('associateRuleItemSelector').fromField.store; //thisForm.managed;

		var hasFilterInToStore = Ext.getCmp('associateRuleItemSelector').toField.store.isFiltered();
		var hasFilterInFromStore = Ext.getCmp('associateRuleItemSelector').fromField.store.isFiltered();

		if (hasFilterInToStore)
		{
			var toFieldStore = Ext.getCmp('associateRuleItemSelector').toField.store;

			unmnglen = toFieldStore.snapshot.length;;
			funmglst = toFieldStore.snapshot;
		}

		if (hasFilterInFromStore)
		{
			var fromFieldStore = Ext.getCmp('associateRuleItemSelector').fromField.store;

			mnglen = fromFieldStore.snapshot.length;
			fmglst = fromFieldStore.snapshot;
		}


		for(var z = 0 ; z < unmnglen ; z++)
		{
			if(funmglst.getAt(z).get('valueField') == null)
			{
				continue;
			}
			else
			{
				funmng[z] = funmglst.getAt(z).get('valueField');
			}
		}

		for(var y = 0 ; y < mnglen ; y++)
		{
			if(fmglst.getAt(y).get('valueField') == null)
			{
				continue;
			}
			else
			{
				fmng[y] = fmglst.getAt(y).get('valueField');
			}
		}
		var fmanage = fmng;
		var funmanage = funmng;

		//thisForm.policyName.options[thisForm.policyName.selectedIndex].value;
		if(policyNA != -1)
		{
			var flagEnable = false;
			var flagDisable = false;
			var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
			var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
			if (grpAssoCompGroupsArr != null && grpAssoCompGroupsArr != "undefined")
			{
				for (var k=0;k<grpAssoCompGroupsArr.length;k++)
				{
					for (var m=0;m<funmng.length;m++)
					{
						if (funmng[m] == grpAssoCompGroupsArr[k].valueField)
						{
							flagEnable = true;
							break;
						}
					}
				}
			}
			if (grpDisAssoCompGroupsArr != null && grpDisAssoCompGroupsArr != "undefined")
			{
				for (var j=0;j<grpDisAssoCompGroupsArr.length ;j++ )
				{
					for (var i=0;i<fmng.length;i++)
					{
						var allValue = fmng[i];
						if (allValue == grpDisAssoCompGroupsArr[j].valueField)
						{
							flagDisable = true;
							break;
						}
					}
				}
			}

			if (fmng.length == 0 && funmng.length == 0)
			{
				Ext.Msg.show({
					title: pageName,
					msg: noGrpForSelectPolicyMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				return;
			}

			if (!flagEnable && !flagDisable)
			{
				Ext.Msg.show({
					title: pageName,
					msg: noAssociateOrDisAssociateSelectMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				return;
			}

			if(fmng.length != 0 || funmng.length != 0 )
			{
				//Egassociatethreshpolicyp
				var hiddenVal = this.getHiddenFields();
				var params = hiddenVal+'fmanage='+encodeURIComponent(fmanage)+'&funmanage='+encodeURIComponent(funmanage)+'&applyRule='+applyRule+'&policyName='+encodeURIComponent(policyNA)+'&fromModify='+fromModify+'&pageFrom=descpattern&fmanageInfos='+descPattern;
				var homepage = Ext.getCmp('viewportId');
				myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
				myMask.show();
				Ext.Ajax.request({
					url:'GroupThreshold/data/EgassociatethreshpolicypJson.jsp?'+params,
					method:'POST',
					scope:this,
					//async: false,
					timeout: 6000000,
					success:function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							jsonText = Ext.decode(response.responseText);
							if (jsonText.successUpdate)
							{
								myMask.hide();
								Ext.Msg.show({
									title: pageName,
									msg: jsonText.successMsg,
									buttons: Ext.MessageBox.OK,
									icon: 'iconInformation',
									fn: me.callBack
								 });
							}
						}
					}
				});
			}
			
		}
		else
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSelectPolicyMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			return;
		}
	},
	associatePatternComboEvent : function()
	{
		var itemSelectorObj = Ext.getCmp('associateRuleItemSelector');
		var fromTriggerObj =  itemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  itemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		var patternComboVal = Ext.getCmp('pattNameCombo').getValue();
		var action = patternComboVal;
		if (!Ext.isEmpty(patternComboVal) && patternComboVal != '-1')
		{
			Ext.getCmp('pattNameText').hide();
		}
		else
		{
			Ext.getCmp('pattNameText').show();
		}

		var ServerType = publicJson['ServerType'];
		var serv = publicJson['serv'];
		var thisForm = document.TestList;
		var rulE = Ext.getCmp('applyRuleTypeCombo').getValue();
		var policyNA = Ext.getCmp('associateRuleNameCombo').getValue();
		associateRuleType = rulE;

		if (policyNA == "-1" && (!Ext.isEmpty(rulE) && rulE != 'All'))
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSelectRuleMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('applyRuleTypeCombo').setValue('All');
		}

		{
			var params = "rulE=" +encodeURI(rulE)+"&policyN=" + encodeURI(policyNA)+"&ServerType="+encodeURI(ServerType)+"&serv="+encodeURI(serv);
			Ext.Ajax.request({
				url:'GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?'+params+'&clicked='+clicked+'&associateBtnClicked='+associateBtnClicked+'&fromUI=descpattern&action='+encodeURIComponent(parent.filterEncode(action)),
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var isNoData = publicJson['isNoData'];
						if (!isNoData)
						{
							var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
							var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
							if (Ext.getCmp('associateRuleItemSelector').fromField.store.getCount() >= 1)
							{
								Ext.getCmp('associateRuleItemSelector').fromField.store.removeAll();
							}
							if (Ext.getCmp('associateRuleItemSelector').toField.store.getCount() >= 1)
							{
								Ext.getCmp('associateRuleItemSelector').toField.store.removeAll();
							}

							if(grpAssoCompGroupsArr != null && !Ext.isEmpty(grpAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').fromField.store.add(grpAssoCompGroupsArr);
							if(grpDisAssoCompGroupsArr != null && !Ext.isEmpty(grpDisAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').toField.store.add(grpDisAssoCompGroupsArr);
						}
						else
						{
							if (Ext.getCmp('associateComboContainer').isVisible())
							{
								Ext.getCmp('associateComboContainer').hide();
								Ext.getCmp('associateItemSelectorContainer').hide();
								Ext.getCmp('associateButtonContainer').hide();
							}
							
							Ext.getCmp('noAssociatePolicyContainer').show();
						}
					}
				}
			});
		}
	},
	descPatternView : function(policyNA,ServerType,serv)
	{
		var action = Ext.getCmp('pattNameCombo').getValue();
		var itemSelectorObj = Ext.getCmp('associateRuleItemSelector');
		var fromTriggerObj =  itemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  itemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		var thisForm = document.TestList;
		var rulE = 'descpattern'; 
		associateRuleType = rulE;
		if (policyNA == "-1")
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSelectRuleMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('applyRuleTypeCombo').setValue('All');
		}

		{
			var params = "rulE=" +encodeURI(rulE)+"&policyN=" + encodeURI(policyNA)+"&ServerType="+encodeURI(ServerType)+"&serv="+encodeURI(serv);
			Ext.Ajax.request({
				url:'GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?'+params+'&clicked='+clicked+'&associateBtnClicked='+associateBtnClicked+'&fromUI=descpattern&action=-1',//+encodeURIComponent(parent.filterEncode(action)),
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);

						var isNoData = publicJson['isNoData'];
						var isExistPatterns = publicJson['isExistPatterns'];
						var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
						var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
						if (Ext.getCmp('associateRuleItemSelector').fromField.store.getCount() >= 1)
						{
							Ext.getCmp('associateRuleItemSelector').fromField.store.removeAll();
						}
						if (Ext.getCmp('associateRuleItemSelector').toField.store.getCount() >= 1)
						{
							Ext.getCmp('associateRuleItemSelector').toField.store.removeAll();
						}

						if (!isNoData)
						{
							if (!isExistPatterns)
							{
								Ext.getCmp('pattNameCombo').hide();
								Ext.getCmp('pattNameText').show();
							}
							else
							{
								Ext.getCmp('pattNameCombo').show();
								
								var existInfoComboArr = publicJson['existInfoComboArr'];
								Ext.getCmp('pattNameCombo').getStore().removeAll();
								Ext.getCmp('pattNameCombo').getStore().loadRawData(existInfoComboArr);

								Ext.getCmp('pattNameCombo').getStore().sort('displayField', 'ASC');
								Ext.getCmp('pattNameCombo').getStore().insert(0,{displayField:'--Define new descriptor pattern--', valueField:'-1'});
								Ext.getCmp('pattNameCombo').setValue('-1');
								Ext.getCmp('pattNameText').show();
							}

							if(grpAssoCompGroupsArr != null && !Ext.isEmpty(grpAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').fromField.store.add(grpAssoCompGroupsArr);
							if(grpDisAssoCompGroupsArr != null && !Ext.isEmpty(grpDisAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').toField.store.add(grpDisAssoCompGroupsArr);

						}
						else
						{
							if (Ext.getCmp('associateComboContainer').isVisible())
							{
								Ext.getCmp('associateComboContainer').hide();
								Ext.getCmp('associateItemSelectorContainer').hide();
								Ext.getCmp('associateButtonContainer').hide();
							}
							
							Ext.getCmp('noAssociatePolicyContainer').show();
						}
					}
				}
			});
		}
	},
	specificThreshBack : function()
	{
		if (Ext.isEmpty(strCompType))
		{
			strCompType = '';
		}
		window.location.href = 'EgSpecificThresh.jsp?server='+encodeURIComponent(strCompType)+'&fromWizard='+fromWizard;
	},
	associateRuleBackEvent : function()
	{
		associatePolicyName = '';
		associateRuleType = '';
		//alert('associateBtnClicked : '+associateBtnClicked);
		if (associateBtnClicked != null && associateBtnClicked == 'Component group page')
		{
			clicked = 'componentgroups';
			var homepage = Ext.getCmp('viewportId');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'componentgroups' });
			myMask.hide();
		}
		else
		{
			clicked = 'thresholdrules';
			var homepage = Ext.getCmp('viewportId');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'thresholdrules' });
			myMask.hide();
		}
	},
	associateDescBackEvent : function()
	{
		clicked = 'associaterule';
		var ruleExistType = publicJson['hiddenObj']['seletedRuleType'];
		ruleType = ruleExistType;
		var policyName = Ext.getCmp('associateDescNameText').getValue();
		associateRuleBackUrl = 'GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?rulE='+ruleExistType+'&policyN='+encodeURIComponent(policyName)+'&ServerType=Groups&serv=null';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'associaterule' });
		myMask.hide();
	},
	//descriptorSearch : function(type)
	//{
		//var thisForm = document.TestList;
		//var pName = Ext.getCmp('associateDescNameText').getValue();
		//var mServers = publicJson['hiddenObj']['mServers'];
		//var sHiddenVal = publicJson['hiddenObj']['sHiddenVal'];
		//var v_url = "";
		//var strComponent = "";
		//if (type.id == 'strManagedSearch')
		//{
			//strComponent = 'managed';
		//}
		//else
			//strComponent = 'unmanaged';

		//if (strComponent == "managed")
		//{
			//var strManagedSearch = Ext.getCmp('strManagedSearch').getValue();
			//var strUnmanagedSearch = Ext.getCmp('strUnmanagedSearch');
			//var strUnmanagedSearchVal = '';
			//if(!Ext.isEmpty(strUnmanagedSearch) && strUnmanagedSearch != undefined)
			//{
				//strUnmanagedSearchVal = strUnmanagedSearch.value;
				//if(strUnmanagedSearchVal == null || strUnmanagedSearchVal == "undefined" || strUnmanagedSearchVal == "Search")
				//{
					//strUnmanagedSearchVal = "";
				//}
			//}

			//if (strManagedSearch == "" || strManagedSearch.length == 0)
			//{
				//Ext.get('MyTrigger_0').setStyle('display','none');
				//Ext.get('MyTrigger_1').setStyle('display','block');
			//}
			//else
			//{
				//Ext.get('MyTrigger_1').setStyle('display','none');
				//Ext.get('MyTrigger_0').setStyle('display','block');
			//}

			////if (strManagedSearch == null || strManagedSearch == "" || strManagedSearch == "Search" )
			////{
				////v_url = "GroupThreshold/data/EgAssociateInfosJson.jsp?policyN=" + encodeURIComponent(pName) +"&strComponent="+strComponent+"&strHiddenVal="+sHiddenVal+"&managedServers="+encodeURI(mServers);
			////}
			////else
			//{
				//v_url = "GroupThreshold/data/EgAssociateInfosJson.jsp?policyN=" +encodeURIComponent(pName) +"&strManagedSearch="+strManagedSearch+"&strUnmanagedSearch="+strUnmanagedSearchVal+"&strComponent="+strComponent+"&strHiddenVal="+sHiddenVal+"&managedServers="+encodeURI(mServers);
			//}
		//}
		//else
		//{
			//var strManagedSearch = Ext.getCmp('strManagedSearch');
			//var strUnmanagedSearch = Ext.getCmp('strUnmanagedSearch').getValue();
			//var  strManagedSearchVal = '';
			//if(!Ext.isEmpty(strManagedSearch) && strManagedSearch != undefined)
			//{
				//strManagedSearchVal = strManagedSearch.value;
				//if(strManagedSearchVal == null || strManagedSearchVal == "undefined" || strManagedSearchVal == "Search")
				//{
					//strManagedSearchVal = "";
				//}
			//}

			//if (strUnmanagedSearch == "" || strUnmanagedSearch.length == 0)
			//{
				//Ext.get('MyUnmanageTrigger_0').setStyle('display','none');
				//Ext.get('MyUnmanageTrigger_1').setStyle('display','block');
			//}
			//else
			//{
				//Ext.get('MyUnmanageTrigger_1').setStyle('display','none');
				//Ext.get('MyUnmanageTrigger_0').setStyle('display','block');
			//}

			////if (strUnmanagedSearch == null || strUnmanagedSearch == "" || strUnmanagedSearch == "Search")
			////{
				////v_url = "GroupThreshold/data/EgAssociateInfosJson.jsp?policyN=" +encodeURIComponent(pName)+"&strComponent="+strComponent+"&strHiddenVal="+sHiddenVal+"&managedServers="+encodeURI(mServers);
			////}
			////else
			//{
				//v_url = "GroupThreshold/data/EgAssociateInfosJson.jsp?policyN=" +encodeURIComponent(pName)+"&strManagedSearch="+strManagedSearchVal+"&strUnmanagedSearch="+strUnmanagedSearch+"&strComponent="+strComponent+"&strHiddenVal="+sHiddenVal+"&managedServers="+encodeURI(mServers);
			//}
		//}
		
		//Ext.Ajax.request({
			//url:v_url,
			//method:'post',
			//scope:this,
			//timeout: 6000000,
			//success:function(response)
			//{	
				//var jsonText = response.responseText;
				//publicJson = Ext.decode(jsonText);

				//var isNoData = publicJson['isNoData'];
				//if (!isNoData)
				//{
					//if (Ext.getCmp('noAssociateDescPolicyContainer').isVisible())
					//{
						//Ext.getCmp('noAssociateDescPolicyContainer').hide();
					//}
					//Ext.getCmp('associateTextContainer').show();
					//Ext.getCmp('associateDescItemSelectContainer').show();
					//Ext.getCmp('associateDescButtonContainer').show();

					//var ruleName = publicJson['ruleName'];
					 //if (ruleName != null && !Ext.isEmpty(ruleName))
					 //{
						//Ext.getCmp('associateDescNameText').setValue(ruleName);
						////Ext.getCmp('associateDescNameText').setReadOnly(true);
					 //}
					//var grpDisAssoDescArr = publicJson['grpDisAssoDescArr'];
					//var grpAssoDescArr = publicJson['grpAssoDescArr'];

					//if (Ext.getCmp('associateDescItemSelect').fromField.store.getCount() >= 1)
					//{
						//Ext.getCmp('associateDescItemSelect').fromField.store.removeAll();
					//}
					//if (Ext.getCmp('associateDescItemSelect').toField.store.getCount() >= 1)
					//{
						//Ext.getCmp('associateDescItemSelect').toField.store.removeAll();
					//}

					//if(grpAssoDescArr != null && !Ext.isEmpty(grpAssoDescArr))
						//Ext.getCmp('associateDescItemSelect').fromField.store.add(grpAssoDescArr);
					//if(grpDisAssoDescArr != null && !Ext.isEmpty(grpDisAssoDescArr))
						//Ext.getCmp('associateDescItemSelect').toField.store.add(grpDisAssoDescArr);
				//}
				//else
				//{
					//if (Ext.getCmp('associateTextContainer').isVisible())
					//{
						//Ext.getCmp('associateTextContainer').hide();
						//Ext.getCmp('associateDescItemSelectContainer').hide();
						//Ext.getCmp('associateDescButtonContainer').hide();
					//}
					
					//Ext.getCmp('noAssociateDescPolicyContainer').show();
				//}
			//}
		//});
	//},
	associateDescriptorUpdateEvent: function()
	{
		var funmng = new Array();
		var fmng = new Array();
		var thisForm = document.TestList;
		var hasFilterInToStore = Ext.getCmp('associateDescItemSelect').toField.store.isFiltered();
		var hasFilterInFromStore = Ext.getCmp('associateDescItemSelect').fromField.store.isFiltered();

		var unmnglen = Ext.getCmp('associateDescItemSelect').toField.store.getCount(); //thisForm.unmanaged.options.length;
		var mnglen = Ext.getCmp('associateDescItemSelect').fromField.store.getCount(); //thisForm.managed.options.length;
		var funmglst = Ext.getCmp('associateDescItemSelect').toField.store; //thisForm.unmanaged;
		var fmglst = Ext.getCmp('associateDescItemSelect').fromField.store; //thisForm.managed;
		
		if (hasFilterInToStore)
		{
			var toFieldStore = Ext.getCmp('associateDescItemSelect').toField.store;

			unmnglen = toFieldStore.snapshot.length;;
			funmglst = toFieldStore.snapshot;
		}

		if (hasFilterInFromStore)
		{
			var fromFieldStore = Ext.getCmp('associateDescItemSelect').fromField.store;

			mnglen = fromFieldStore.snapshot.length;
			fmglst = fromFieldStore.snapshot;
		}

		for(var z = 0 ; z < unmnglen ; z++)
		{
			if(funmglst.getAt(z).get('valueField') == null)
			{
				continue;
			}
			else
			{
				funmng[z] = funmglst.getAt(z).get('valueField');
			}
		}

		for(var y = 0 ; y < mnglen ; y++)
		{
			if(fmglst.getAt(y).get('valueField') == null)
			{
				continue;
			}
			else
			{
				fmng[y] = fmglst.getAt(y).get('valueField');
			}
		}
		var fmanageInfos = fmng;
		var funmanage = funmng;

		//thisForm.fmanageInfos.value = fmng;
		//thisForm.funmanage.value = funmng;
		var flagEnable = false;
		var flagDisable = false;
		var grpAssoCompGroupsArr = publicJson['grpAssoDescArr'];
		var grpDisAssoCompGroupsArr = publicJson['grpDisAssoDescArr'];
		if (grpAssoCompGroupsArr != null && grpAssoCompGroupsArr != "undefined")
		{
			for (var k=0;k<grpAssoCompGroupsArr.length;k++)
			{
				for (var m=0;m<funmng.length;m++)
				{
					if (funmng[m] == grpAssoCompGroupsArr[k].valueField)
					{
						flagEnable = true;
						break;
					}
				}
			}
		}
		if (grpDisAssoCompGroupsArr != null && grpDisAssoCompGroupsArr != "undefined")
		{
			for (var j=0;j<grpDisAssoCompGroupsArr.length ;j++ )
			{
				for (var i=0;i<fmng.length;i++)
				{
					var allValue = fmng[i];
					if (allValue == grpDisAssoCompGroupsArr[j].valueField)
					{
						flagDisable = true;
						break;
					}
				}
			}
		}
		if (!flagEnable && !flagDisable)
		{
			Ext.Msg.show({
				title: pageName,
				msg: noAssoOrDisAssoDescSelectMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			return;
		}

		if(fmng.length != 0 || funmng.length != 0 )
		{
			var policyNA = Ext.getCmp('associateDescNameText').getValue();
			var hiddenVal = this.getHiddenFields();
			var params = hiddenVal+'&policyName='+encodeURIComponent(policyNA);
			//var params = hiddenVal+'fmanageInfos='+fmanageInfos+'&funmanage='+funmanage+'&policyName='+policyNA;
			Ext.getCmp("fmanageInfos").setValue(window.parent.filterEncode(fmanageInfos.toString()));
			Ext.getCmp("funmanage").setValue(window.parent.filterEncode(funmanage.toString()));
			var homepage = Ext.getCmp('viewportId');
			myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
			myMask.show();
			var formObj = this.getAssociatedescriptors().getForm();
			var strOriginalManagedInfo = publicJson['strOriginalManagedInfo'];
			var strOriginalUnManagedInfo = publicJson['strOriginalUnManagedInfo'];
			if (!Ext.isEmpty(strOriginalUnManagedInfo) && strOriginalUnManagedInfo != undefined && strOriginalUnManagedInfo.length > 0)
			{
				Ext.getCmp('strOriginalUnManagedInfo').setValue(window.parent.filterEncode(strOriginalUnManagedInfo.toString()));
			}
			if (!Ext.isEmpty(strOriginalManagedInfo) && strOriginalManagedInfo != undefined && strOriginalManagedInfo.length > 0)
			{
				Ext.getCmp('strOriginalManagedInfo').setValue(window.parent.filterEncode(strOriginalManagedInfo.toString()));
			}
			
			if (formObj.isValid())
			{
				this.getAssociatedescriptors().submit({
					url:'GroupThreshold/data/EgassociatethreshpolicypJson.jsp?'+params,
					method:'POST',
					scope:this,
					//async: false,
					timeout: 9000,
					success: function(form, action){
						var tmpJosnData = Ext.decode(action.response.responseText);
						if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText))
						{
							jsonText = Ext.decode(action.response.responseText);
							Ext.getCmp("fmanageInfos").setValue("");
							Ext.getCmp("funmanage").setValue("");
							Ext.getCmp("strOriginalManagedInfo").setValue("");
							Ext.getCmp("strOriginalUnManagedInfo").setValue("");
							if (jsonText.successUpdate)
							{
								myMask.hide();
								Ext.Msg.show({
									title: pageName,
									msg: jsonText.successMsg,
									buttons: Ext.MessageBox.OK,
									icon: 'iconInformation',
									fn: me.callBack
								 });
							}
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						Ext.getCmp("fmanageInfos").setValue("");
						Ext.getCmp("funmanage").setValue("");
						Ext.getCmp("strOriginalManagedInfo").setValue("");
						Ext.getCmp("strOriginalUnManagedInfo").setValue("");

						myMask.hide();

						 switch (action.failureType) {
							case Ext.form.action.Action.CLIENT_INVALID:
								Ext.Msg.show ({
									title: pageName,
									msg: 'Form fields may not be submitted with invalid values',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation',
								});
								break;
							case Ext.form.action.Action.CONNECT_FAILURE:
								Ext.Msg.show ({
									title: pageName,
									msg: 'Ajax communication failed',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation',
								});
								break;
							case Ext.form.action.Action.SERVER_INVALID:
								Ext.Msg.show ({
									title: action.result.msg,
									msg: 'Ajax communication failed',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation',
								});
					   }
					}
				});
			}
		}
	},
	afterAssociateDescriptorRender: function()
	{
		if (modifyAssoInfoUrl != null && !Ext.isEmpty(modifyAssoInfoUrl))
		{
			var parent = window.parent;
			Ext.Ajax.request({
				url: modifyAssoInfoUrl+'&modifyAssoInfoUrl='+encodeURIComponent(parent.filterEncode(modifyAssoInfoUrl)),
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var isNoData = publicJson['isNoData'];
						if (!isNoData)
						{
							if (Ext.getCmp('noAssociateDescPolicyContainer').isVisible())
							{
								Ext.getCmp('noAssociateDescPolicyContainer').hide();
							}
							Ext.getCmp('associateTextContainer').show();
							Ext.getCmp('associateDescItemSelectContainer').show();
							Ext.getCmp('associateDescButtonContainer').show();

							var ruleName = publicJson['ruleName'];
							 if (ruleName != null && !Ext.isEmpty(ruleName))
							 {
								Ext.getCmp('associateDescNameText').setValue(ruleName);
								Ext.getCmp('associateDescNameText').setReadOnly(true);
							 }
							var grpDisAssoDescArr = publicJson['grpDisAssoDescArr'];
							var grpAssoDescArr = publicJson['grpAssoDescArr'];

							// commented for explicit search functionality coz search implemented inbuilt in itemselector xtype

							/*var isNeedManagedInfoSearchBox = publicJson['isNeedManagedInfoSearchBox'];
							var isNeedUnManagedInfoSearchBox = publicJson['isNeedUnManagedInfoSearchBox'];
							if (isNeedManagedInfoSearchBox)
							{
								Ext.getCmp('searchContainer').show();
								Ext.getCmp('strUnmanagedSearch').hide();
							}
							if (isNeedUnManagedInfoSearchBox)
							{
								Ext.getCmp('searchContainer').show();
								Ext.getCmp('strUnmanagedSearch').show();
								if (!isNeedManagedInfoSearchBox)
								{
									Ext.getCmp('strManagedSearch').hide();
								}
							}
							if(!isNeedManagedInfoSearchBox && !isNeedUnManagedInfoSearchBox)
							{
								Ext.getCmp('searchContainer').hide();
							}*/

							if (Ext.getCmp('associateDescItemSelect').fromField.store.getCount() >= 1)
							{
								Ext.getCmp('associateDescItemSelect').fromField.store.removeAll();
							}
							if (Ext.getCmp('associateDescItemSelect').toField.store.getCount() >= 1)
							{
								Ext.getCmp('associateDescItemSelect').toField.store.removeAll();
							}

							if(grpAssoDescArr != null && !Ext.isEmpty(grpAssoDescArr))
								Ext.getCmp('associateDescItemSelect').fromField.store.add(grpAssoDescArr);
							if(grpDisAssoDescArr != null && !Ext.isEmpty(grpDisAssoDescArr))
								Ext.getCmp('associateDescItemSelect').toField.store.add(grpDisAssoDescArr);
						}
						else
						{
							if (Ext.getCmp('associateTextContainer').isVisible())
							{
								Ext.getCmp('associateTextContainer').hide();
								Ext.getCmp('associateDescItemSelectContainer').hide();
							}
							if (Ext.getCmp('associateDescButtonContainer').isVisible())
							{
								Ext.getCmp('associateDescButtonContainer').hide();
							}

							Ext.getCmp('noAssociateDescPolicyContainer').show();
						}
					}
				}
			});
		}
	},
	associateRuleUpdateEvent : function()
	{
		var funmng = new Array();
		var fmng = new Array();
		var thisForm = document.TestList;
		var unmnglen = Ext.getCmp('associateRuleItemSelector').toField.store.getCount(); //thisForm.unmanaged.options.length;
		var mnglen = Ext.getCmp('associateRuleItemSelector').fromField.store.getCount(); //thisForm.managed.options.length;
		var funmglst = Ext.getCmp('associateRuleItemSelector').toField.store; //thisForm.unmanaged;
		var fmglst = Ext.getCmp('associateRuleItemSelector').fromField.store; //thisForm.managed;

		var hasFilterInToStore = Ext.getCmp('associateRuleItemSelector').toField.store.isFiltered();
		var hasFilterInFromStore = Ext.getCmp('associateRuleItemSelector').fromField.store.isFiltered();

		if (hasFilterInToStore)
		{
			var toFieldStore = Ext.getCmp('associateRuleItemSelector').toField.store;

			unmnglen = toFieldStore.snapshot.length;;
			funmglst = toFieldStore.snapshot;
		}

		if (hasFilterInFromStore)
		{
			var fromFieldStore = Ext.getCmp('associateRuleItemSelector').fromField.store;

			mnglen = fromFieldStore.snapshot.length;
			fmglst = fromFieldStore.snapshot;
		}


		for(var z = 0 ; z < unmnglen ; z++)
		{
			if(funmglst.getAt(z).get('valueField') == null)
			{
				continue;
			}
			else
			{
				funmng[z] = funmglst.getAt(z).get('valueField');
			}
		}

		for(var y = 0 ; y < mnglen ; y++)
		{
			if(fmglst.getAt(y).get('valueField') == null)
			{
				continue;
			}
			else
			{
				fmng[y] = fmglst.getAt(y).get('valueField');
			}
		}
		var fmanage = fmng;
		var funmanage = funmng;

		//thisForm.fmanage.value = fmng;
		//thisForm.funmanage.value = funmng;
		var comp_type =  Ext.getCmp('applyRuleTypeCombo').getValue();
		if(comp_type == "descpattern")
		{
			me.descPatterRuleUpdateEvent();
			return;
		}
		
		var applyRule = comp_type;
		if(comp_type == "All")
		{
			var policyNA = Ext.getCmp('associateRuleNameCombo').getValue(); //thisForm.policyName.options[thisForm.policyName.selectedIndex].value;
			if(policyNA != -1)
			{
				var flagEnable = false;
				var flagDisable = false;
				var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
				var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
				if (grpAssoCompGroupsArr != null && grpAssoCompGroupsArr != "undefined")
				{
					for (var k=0;k<grpAssoCompGroupsArr.length;k++)
					{
						for (var m=0;m<funmng.length;m++)
						{
							if (funmng[m] == grpAssoCompGroupsArr[k].valueField)
							{
								flagEnable = true;
								break;
							}
						}
					}
				}
				if (grpDisAssoCompGroupsArr != null && grpDisAssoCompGroupsArr != "undefined")
				{
					for (var j=0;j<grpDisAssoCompGroupsArr.length ;j++ )
					{
						for (var i=0;i<fmng.length;i++)
						{
							var allValue = fmng[i];
							if (allValue == grpDisAssoCompGroupsArr[j].valueField)
							{
								flagDisable = true;
								break;
							}
						}
					}
				}

				if (fmng.length == 0 && funmng.length == 0)
				{
					Ext.Msg.show({
						title: pageName,
						msg: noGrpForSelectPolicyMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					return;
				}

				if (!flagEnable && !flagDisable)
				{
					Ext.Msg.show({
						title: pageName,
						msg: noAssociateOrDisAssociateSelectMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					return;
				}

				if(fmng.length != 0 || funmng.length != 0 )
				{
					//Egassociatethreshpolicyp
					var hiddenVal = this.getHiddenFields();
					var params = hiddenVal+'fmanage='+encodeURIComponent(fmanage)+'&funmanage='+encodeURIComponent(funmanage)+'&applyRule='+applyRule+'&policyName='+encodeURIComponent(policyNA);
					var homepage = Ext.getCmp('viewportId');
					myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
					myMask.show();
					Ext.Ajax.request({
						url:'GroupThreshold/data/EgassociatethreshpolicypJson.jsp?'+params,
						method:'POST',
						scope:this,
						//async: false,
						timeout: 6000000,
						success:function(response)
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								jsonText = Ext.decode(response.responseText);
								if (jsonText.successUpdate)
								{
									myMask.hide();
									Ext.Msg.show({
										title: pageName,
										msg: jsonText.successMsg,
										buttons: Ext.MessageBox.OK,
										icon: 'iconInformation',
										fn: me.callBack
									 });
								}
							}
						}
					});
				}
				
			}
			else
			{
				Ext.Msg.show({
					title: pageName,
					msg: noSelectPolicyMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				return;
			}
		}
		else
		{
			var funmng = new Array();
			var fmng = new Array();
			var thisForm = document.TestList;
			var unmnglen = Ext.getCmp('associateRuleItemSelector').toField.store.getCount(); //thisForm.unmanaged.options.length;
			var mnglen = Ext.getCmp('associateRuleItemSelector').fromField.store.getCount(); //thisForm.managed.options.length;
			var funmglst = Ext.getCmp('associateRuleItemSelector').toField.store; //thisForm.unmanaged;
			var fmglst = Ext.getCmp('associateRuleItemSelector').fromField.store; //thisForm.managed;

			for(var z = 0 ; z < unmnglen ; z++)
			{
				if(funmglst.getAt(z).get('valueField') == null)
				{
					continue;
				}
				else
				{
					funmng[z] = funmglst.getAt(z).get('valueField');
				}
			}

			for(var y = 0 ; y < mnglen ; y++)
			{
				if(fmglst.getAt(y).get('valueField') == null)
				{
					continue;
				}
				else
				{
					fmng[y] = fmglst.getAt(y).get('valueField');
				}
			}
			var fmanage = fmng;
			var funmanage = funmng;
			var policyNA = Ext.getCmp('associateRuleNameCombo').getValue(); 
			if(fmng != "" )
			{
				var strHidVal = publicJson['hiddenObj']['strHiddenVal'];
				strHidVal = strHidVal.substring(1);
				if(policyNA != -1)
				{
					clicked = 'associatedescriptors';
					var hiddenValues = this.getHiddenFields();
					modifyAssoInfoUrl = 'GroupThreshold/data/EgAssociateInfosJson.jsp?'+hiddenValues+'policyN=' +encodeURI(policyNA)+'&managedServers='+encodeURI(fmng)+'&strHiddenVal='+strHidVal+'&seletedRuleType='+applyRule+'&clicked='+clicked+'&associateBtnClicked='+associateBtnClicked;
					var homepage = Ext.getCmp('viewportId');
					myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
					homepage.removeAll();
					myMask.show();
					homepage.add({ xtype : 'associatedescriptors' });
					myMask.hide();
				}
			}
			else if (funmng != "")
			{
				var flagEnable = false;
				var flagDisable = false;
				var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
				var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
				if (grpAssoCompGroupsArr != null && grpAssoCompGroupsArr != "undefined")
				{
					for (var k=0;k<grpAssoCompGroupsArr.length;k++)
					{
						for (var m=0;m<funmng.length;m++)
						{
							if (funmng[m] == grpAssoCompGroupsArr[k].valueField)
							{
								flagEnable = true;
								break;
							}
						}
					}
				}
				if (grpDisAssoCompGroupsArr != null && grpDisAssoCompGroupsArr != "undefined")
				{
					for (var j=0;j<grpDisAssoCompGroupsArr.length ;j++ )
					{
						for (var i=0;i<fmng.length;i++)
						{
							var allValue = fmng[i];
							if (allValue == grpDisAssoCompGroupsArr[j].valueField)
							{
								flagDisable = true;
								break;
							}
						}
					}
				}

				if (!flagEnable && !flagDisable)
				{
					Ext.Msg.show({
						title: pageName,
						msg: noAssociateOrDisAssociateSelectMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					return;
				}
				else
				{
					var hiddenVal = this.getHiddenFields();
					var params = hiddenVal+'fmanage='+encodeURIComponent(fmanage)+'&funmanage='+encodeURIComponent(funmanage)+'&applyRule='+applyRule+'&policyName='+encodeURIComponent(policyNA);
					//alert('params : '+params);
					var homepage = Ext.getCmp('viewportId');
					myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
					myMask.show();
					Ext.Ajax.request({
						url:'GroupThreshold/data/EgassociatethreshpolicypJson.jsp?'+params,
						method:'POST',
						scope:this,
						//async: false,
						timeout: 6000000,
						success:function(response)
						{
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								jsonText = Ext.decode(response.responseText);
								if (jsonText.successUpdate)
								{
									myMask.hide();
									Ext.Msg.show({
										title: pageName,
										msg: jsonText.successMsg,
										buttons: Ext.MessageBox.OK,
										icon: 'iconInformation',
										fn: me.callBack
									 });
								}
							}
						}
					});
				}
			}
			else
			{
				Ext.Msg.show({
					title: pageName,
					msg: noGrpForSelectPolicyMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				return;
			}
		}
	},
	applyRuleTypeComboEvent : function()
	{
		var itemSelectorObj = Ext.getCmp('associateRuleItemSelector');
		var fromTriggerObj =  itemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  itemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		if (!Ext.isEmpty(Ext.getCmp('pattNameCombo')) && Ext.getCmp('pattNameCombo').isVisible())
		{
			Ext.getCmp('pattNameCombo').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('pattNameText')) && Ext.getCmp('pattNameText').isVisible())
		{
			Ext.getCmp('pattNameText').hide();
		}

		var ServerType = publicJson['ServerType'];
		var serv = publicJson['serv'];
		var thisForm = document.TestList;
		var rulE = Ext.getCmp('applyRuleTypeCombo').getValue(); //thisForm.ComponentsType.options[thisForm.ComponentsType.selectedIndex].value;
		var policyNA = Ext.getCmp('associateRuleNameCombo').getValue(); //thisForm.policyName.options[thisForm.policyName.selectedIndex].value;
		associateRuleType = rulE;
		//alert('policyNA  : '+policyNA+'\n rulE  : '+rulE);
		if (policyNA == "-1" && (!Ext.isEmpty(rulE) && rulE != 'All'))
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSelectRuleMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('applyRuleTypeCombo').setValue('All');
			//this.associateRuleNameComboEvent();
			//window.location.href = "EgAssociateThreshPolicy.jsp?ServerType="+encodeURI(ServerType)+"&serv=<%=EgURLEncoder.encode(serv,"UTF-8")%>";
		}

		if (policyNA != "-1" && (!Ext.isEmpty(rulE) && rulE.toLowerCase() == 'descpattern'))
		{
			me.descPatternView(policyNA,ServerType,serv);
		}
		else
		{
			var params = "rulE=" +encodeURI(rulE)+"&policyN=" + encodeURI(policyNA)+"&ServerType="+encodeURI(ServerType)+"&serv="+encodeURI(serv);
			Ext.Ajax.request({
				url:'GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?'+params+'&clicked='+clicked+'&associateBtnClicked='+associateBtnClicked,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						//associateRuleType = publicJson['selectedType'];
						//associatePolicyName = publicJson['selectedPolicyName'];

						var isNoData = publicJson['isNoData'];
						if (!isNoData)
						{
							var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
							var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
							if (Ext.getCmp('associateRuleItemSelector').fromField.store.getCount() >= 1)
							{
								Ext.getCmp('associateRuleItemSelector').fromField.store.removeAll();
							}
							if (Ext.getCmp('associateRuleItemSelector').toField.store.getCount() >= 1)
							{
								Ext.getCmp('associateRuleItemSelector').toField.store.removeAll();
							}

							if(grpAssoCompGroupsArr != null && !Ext.isEmpty(grpAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').fromField.store.add(grpAssoCompGroupsArr);
							if(grpDisAssoCompGroupsArr != null && !Ext.isEmpty(grpDisAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').toField.store.add(grpDisAssoCompGroupsArr);
						}
						else
						{
							if (Ext.getCmp('associateComboContainer').isVisible())
							{
								Ext.getCmp('associateComboContainer').hide();
								Ext.getCmp('associateItemSelectorContainer').hide();
								Ext.getCmp('associateButtonContainer').hide();
							}
							
							Ext.getCmp('noAssociatePolicyContainer').show();
						}
					}
				}
			});
		}
	},
	associateRuleNameComboEvent : function()
	{
		//EgAssociateThreshPolicy.jsp?policyN=NetRule&ServerType=null&rulE=All&serv=&test=null
		//EgAssociateThreshPolicy.jsp?ServerType=null
		var itemSelectorObj = Ext.getCmp('associateRuleItemSelector');
		var fromTriggerObj =  itemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  itemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		if (!Ext.isEmpty(Ext.getCmp('pattNameCombo')) && Ext.getCmp('pattNameCombo').isVisible())
		{
			Ext.getCmp('pattNameCombo').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('pattNameText')) && Ext.getCmp('pattNameText').isVisible())
		{
			Ext.getCmp('pattNameText').hide();
		}

		var ruleName = Ext.getCmp('associateRuleNameCombo').getValue();
		var urlValue = 'GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?';
		var params =  '';
		var associateRuleType =  '';
		if ( ruleName != null && !Ext.isEmpty(ruleName))
		{
			if (ruleName == '-1')
			{
				params = 'ServerType=null';
				associateRuleType = 'All';
			}
			else
			{
				params = 'ServerType=null&serv=&test=null&policyN='+encodeURIComponent(ruleName);
			}
			associatePolicyName = ruleName;
			if (ruleType != null && !Ext.isEmpty(ruleType))
			{
				params += '&rulE='+ruleType;
			}
			else
			{
				if (!Ext.isEmpty(associateRuleType))
				{
					params += '&rulE='+associateRuleType;
				}
				else
				{
					params += '&rulE=All';
				}
			}

			Ext.Ajax.request({
				url:'GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?'+params+'&clicked='+clicked+'&associateBtnClicked='+associateBtnClicked,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var isNoData = publicJson['isNoData'];
						//associateRuleType = publicJson['selectedType'];
						//associatePolicyName = publicJson['selectedPolicyName'];
						if (!isNoData)
						{
							if(Ext.getCmp('noAssociatePolicyContainer').isVisible())
								Ext.getCmp('noAssociatePolicyContainer').hide();

							Ext.getCmp('associateComboContainer').show();
							Ext.getCmp('associateItemSelectorContainer').show();
							Ext.getCmp('associateButtonContainer').show();
							var grpThreshPolicyTypeArr = publicJson['grpThreshPolicyTypeArr'];
							var grpDisAssoCompGroupsArr = publicJson['grpDisAssoCompGroupsArr'];
							var grpAssoCompGroupsArr = publicJson['grpAssoCompGroupsArr'];
							var selectedType = publicJson['selectedType'];
							//associateRuleType = selectedType;
							Ext.getCmp('applyRuleTypeCombo').getStore().removeAll();
							Ext.getCmp('applyRuleTypeCombo').getStore().loadRawData(grpThreshPolicyTypeArr);
							//alert('selectedType : '+selectedType);
							if (selectedType != null && !Ext.isEmpty(selectedType))
							{
								Ext.getCmp('applyRuleTypeCombo').setValue(selectedType);
								Ext.getCmp('applyRuleTypeCombo').fireEvent('select', Ext.getCmp('applyRuleTypeCombo'));
							}
							else
							{
								Ext.getCmp('applyRuleTypeCombo').setValue(grpThreshPolicyTypeArr[0].valueField);
							//}
							//Ext.getCmp('applyRuleTypeCombo').setValue(grpThreshPolicyTypeArr[0].valueField);
							if (Ext.getCmp('associateRuleItemSelector').fromField.store.getCount() >= 1)
							{
								Ext.getCmp('associateRuleItemSelector').fromField.store.removeAll();
							}
							if (Ext.getCmp('associateRuleItemSelector').toField.store.getCount() >= 1)
							{
								Ext.getCmp('associateRuleItemSelector').toField.store.removeAll();
							}

							if(grpAssoCompGroupsArr != null && !Ext.isEmpty(grpAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').fromField.store.add(grpAssoCompGroupsArr);
							if(grpDisAssoCompGroupsArr != null && !Ext.isEmpty(grpDisAssoCompGroupsArr))
								Ext.getCmp('associateRuleItemSelector').toField.store.add(grpDisAssoCompGroupsArr);
							}
						}
						else
						{
							if (Ext.getCmp('associateComboContainer').isVisible())
							{
								Ext.getCmp('associateComboContainer').hide();
								Ext.getCmp('associateItemSelectorContainer').hide();
								Ext.getCmp('associateButtonContainer').hide();
							}
							
							Ext.getCmp('noAssociatePolicyContainer').show();
						}
					}
				}
			});
		}

	},
	afterAssociateRuleRender: function()
	{
		//no rule url://EgAssociateThreshPolicy.jsp?ServerType=null&serv=null&test=null
		//EgAssociateThreshPolicy.jsp?rulE=specific&policyN=PRule&ServerType=Groups&serv=null
		//alert('associateRuleBackUrl  : '+associateRuleBackUrl);
		var urlValue ='GroupThreshold/data/EgAssociateThreshPolicyJson.jsp?ServerType=null&serv=null&test=null';
		if (associateRuleBackUrl != null && !Ext.isEmpty(associateRuleBackUrl))
		{
			urlValue = associateRuleBackUrl;
		}
		else
		{
			if (associatePolicyName != null && !Ext.isEmpty(associatePolicyName))
			{
				urlValue += '&policyN='+associatePolicyName;
			}
			if (associateRuleType != null && !Ext.isEmpty(associateRuleType))
			{
				urlValue += '&rulE='+associateRuleType;
			}
		}

		if (!Ext.isEmpty(Ext.getCmp('pattNameCombo')) && Ext.getCmp('pattNameCombo').isVisible())
		{
			Ext.getCmp('pattNameCombo').hide();
		}

		if (!Ext.isEmpty(Ext.getCmp('pattNameText')) && Ext.getCmp('pattNameText').isVisible())
		{
			Ext.getCmp('pattNameText').hide();
		}

		Ext.Ajax.request({
			url:urlValue+'&clicked='+clicked+'&associateBtnClicked='+associateBtnClicked,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					associateRuleType = publicJson['selectedType'];
					associatePolicyName = publicJson['selectedPolicyName'];
					var isNoData = publicJson['isNoData'];
					if (!isNoData)
					{
						if(Ext.getCmp('noAssociatePolicyContainer').isVisible())
							Ext.getCmp('noAssociatePolicyContainer').hide();
						Ext.getCmp('associateComboContainer').show();
						Ext.getCmp('associateItemSelectorContainer').show();
						Ext.getCmp('associateButtonContainer').show();
						var grpThreshPolicyArr = publicJson['grpThreshPolicyArr'];
						var grpThreshPolicyTypeArr = publicJson['grpThreshPolicyTypeArr'];
						var selectedPolicyName = publicJson['selectedPolicyName'];
						Ext.getCmp('associateRuleNameCombo').getStore().removeAll();
						Ext.getCmp('associateRuleNameCombo').getStore().loadRawData(grpThreshPolicyArr);
						if (selectedPolicyName != null && !Ext.isEmpty(selectedPolicyName))
						{
							Ext.getCmp('associateRuleNameCombo').setValue(selectedPolicyName);
							Ext.getCmp('associateRuleNameCombo').fireEvent('select', Ext.getCmp('associateRuleNameCombo'));
						}
						else
						{
							Ext.getCmp('associateRuleNameCombo').setValue(grpThreshPolicyArr[0].valueField);
						}

						Ext.getCmp('applyRuleTypeCombo').getStore().removeAll();
						Ext.getCmp('applyRuleTypeCombo').getStore().loadRawData(grpThreshPolicyTypeArr);
						Ext.getCmp('applyRuleTypeCombo').setValue(grpThreshPolicyTypeArr[0].valueField);
						
					}
					else
					{
						if (Ext.getCmp('associateComboContainer').isVisible())
						{
							Ext.getCmp('associateComboContainer').hide();
							Ext.getCmp('associateItemSelectorContainer').hide();
						}
						if (Ext.getCmp('associateButtonContainer').isVisible())
						{
							Ext.getCmp('associateButtonContainer').hide();
						}

						Ext.getCmp('noAssociatePolicyContainer').show();
					}
				}
				associateRuleBackUrl = '';
			}
		});
	},
	//updateData: function ()
	//{
		//var flag = this.applyThresholdsData();
		//if (flag)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: successMsg3,
				//icon: 'iconInformation',
				//buttons: Ext.Msg.OK,
				//fn: function (){
					//modifyThreshRuleUrl = 'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?policyName='+strPolicyName+'&actionFrom=modify';
					//isModifyRule = 'true';
					//var homepage = Ext.getCmp('viewportId');
					//myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
					//homepage.removeAll();
					//myMask.show();
					//homepage.add({ xtype : 'thresholdrule' });
					//myMask.hide();
				//}
			//});
		//}
	//},
	applyThresholdsData: function()
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if (abs_MinCriticalDecimal == "0000" || 
				abs_MinCriticalDecimal == "000" || 
				abs_MinCriticalDecimal == "00" || 
				abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if ((abs_MinCriticalDecimal.charAt(3) == "0" && abs_MinCriticalDecimal.charAt(2) == "0") || 
					(abs_MinCriticalDecimal.charAt(3) == "0"))
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if (abs_MinMajorDecimal == "0000" || 
				abs_MinMajorDecimal == "000" || 
				abs_MinMajorDecimal == "00" || 
				abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if ((abs_MinMajorDecimal.charAt(3) == "0" && abs_MinMajorDecimal.charAt(2) == "0") ||
					(abs_MinMajorDecimal.charAt(3) == "0"))
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if (abs_MinMinorDecimal == "0000" || 
				abs_MinMinorDecimal == "000" || 
				abs_MinMinorDecimal == "00" || 
				abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if ((abs_MinMinorDecimal.charAt(3) == "0" && abs_MinMinorDecimal.charAt(2) == "0") ||
					(abs_MinMinorDecimal.charAt(3) == "0"))
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if (abs_MaxCriticalDecimal == "0000" || 
				abs_MaxCriticalDecimal == "000" || 
				abs_MaxCriticalDecimal == "00" || 
				abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if ((abs_MaxCriticalDecimal.charAt(3) == "0" && abs_MaxCriticalDecimal.charAt(2) == "0") ||
					(abs_MaxCriticalDecimal.charAt(3) == "0"))
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if (abs_MaxMajorDecimal == "0000" || 
				abs_MaxMajorDecimal == "000" || 
				abs_MaxMajorDecimal == "00" || 
				abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if ((abs_MaxMajorDecimal.charAt(3) == "0" && abs_MaxMajorDecimal.charAt(2) == "0") || 
					(abs_MaxMajorDecimal.charAt(3) == "0"))
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if (abs_MaxMinorDecimal == "0000" || 
				abs_MaxMinorDecimal == "000" || 
				abs_MaxMinorDecimal == "00" || 
				abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if ((abs_MaxMinorDecimal.charAt(3) == "0" && abs_MaxMinorDecimal.charAt(2) == "0") ||
					(abs_MaxMinorDecimal.charAt(3) == "0"))
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		if (flag)
		{
			var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
			myHomeMask.show();
			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			//this.updateThresholds(v_testname,v_threshold);
			strTestName = v_testname;
			var params = '';
			var urlVal = '';
			var policyName = publicJson['hiddenObj']['strPolicyName'];
			strPolicyName = policyName;

			var check = Ext.getCmp('allMeasureCheck').getValue();
			var allMeasVal = "";
			if(check)
			{
				allMeasVal = "true";
			}
			params = "policyName="+encodeURIComponent(policyName)+"&testName="+v_testname+"&threshold="+escape(parent.filterEncode(v_threshold))+"&operation=updateThresholds&allMeasure="+allMeasVal;
			urlVal = 'GroupThreshold/data/EgApplyGroupThresholdsJson.jsp?'+params;

			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 60000000,
				//async:false,
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicGrpJson = Ext.decode(jsonText);
					if (response.status == 200 && !Ext.isEmpty(jsonText) && publicGrpJson.successUpdate == true)
					{
						myHomeMask.hide();
						Ext.Msg.show({
							title: pageName,
							msg: successMsg3,
							icon: 'iconInformation',
							buttons: Ext.Msg.OK,
							fn: function (){
								modifyThreshRuleUrl = 'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?policyName='+encodeURIComponent(strPolicyName)+'&actionFrom=modify';
								isModifyRule = 'true';
								var homepage = Ext.getCmp('viewportId');
								myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'thresholdrule' });
								myMask.hide();
							}
						});
					}
				},
				failure: function()
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	//updateThresholds: function (v_test,v_threshValue)
	//{
		//strTestName = v_test;
		//var params = '';
		//var urlVal = '';
		//{
		////var params = "policyName=<%=strPolicyName%>&testName="+v_test+"&threshold="+escape(v_threshValue)+"&operation=updateThresholds";
		////var url = "/final/admin/EgApplyGroupThresholds.jsp";

			//var policyName = publicJson['hiddenObj']['strPolicyName'];
			//strPolicyName = policyName;

			//params = "policyName="+policyName+"&testName="+v_test+"&threshold="+escape(v_threshValue)+"&operation=updateThresholds";
			//urlVal = 'GroupThreshold/data/EgApplyGroupThresholdsJson.jsp?'+params;

		//}
		
		//Ext.Ajax.request({
			//url:urlVal,
			//method:'POST',
			//timeout: 6000000,
			//async:false,
			//scope:this,
			//success:function(response)
			//{
				//if (response.status == 200 && !Ext.isEmpty(response.responseText))
				//{
					//var jsonText = response.responseText;
					//if(jsonText.successUpdate == true)
					//{
						//return true;
					//}
					//else
						//return false;
				//}

			//}
		//});
	//},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	configureThresholdsPageBack: function()
	{
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		myMask.show();
		homepage.removeAll();
		homepage.add({ xtype : 'thresholdrule' });
		myMask.hide();
	},
	noThreshMeasureModify: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var isRecordType = record.get('action');
		if (!Ext.isEmpty(isRecordType) && isRecordType != undefined  && isRecordType == 'view')
		{
			return;
		}
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		actualMeasName = publicJson['measureDataObj'][cellvalue];
		if (actualMeasName != null && actualMeasName != 'undefined' && actualMeasName != '')
		{
			var entryVal = publicJson['hiddenObj']['entry'];
			if(entryVal != null && entryVal == "first")
			{
				var policyname = Ext.getCmp('ruleNameText').getValue(); //thisForm.ThresholdPolicy.value;
				var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
				var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
				var policyNames = new Array();
				if(policyname == '' || policyname == 'null' || policyname == 'undefined')
				{
					Ext.Msg.show({
						title: pageName,
						msg: noRuleNameMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('ruleNameText').focus();
					return;
				}
				if (policyname.indexOf(" ") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: noSpaceMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('ruleNameText').focus();
					return;
				}
				else if(patCheck)
				{
					Ext.Msg.show({
						title: pageName,
						msg: specialCharMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('ruleNameText').focus();
					return;
				}

				policyNamesJson = publicJson['groupNames'];
				if(policyNamesJson != null && policyNamesJson != "" && !Ext.isEmpty(policyNamesJson))
				{
					var policyNames = policyNamesJson.split(',');
					for(var x=0;x<policyNames.length;x++)
					{
						if(policyNames[x] == policyname)
						{
							Ext.Msg.show({
								title: pageName,
								msg: existRuleNameAlertMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation'
							 });
							Ext.getCmp('ruleNameText').focus();
							return;
						}
					}
				}
				this.createNewRuleEvent1();
			}

			hiddenFieldsVal = this.getHiddenFieldsForMeasure(actualMeasName);
			clicked = 'thresholdrule';
			var homepage = Ext.getCmp('viewportId');
			homepage.removeAll();
			homepage.add({ xtype : 'configurethresholds' });
		}
	},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		//Ext.getCmp('alarmDispField').el.update(tmpDescription);
		Ext.getCmp('alarmDispField').setValue(tmpDescription);
	},
	maxStaticFieldChange: function(field){
		var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (maxStaticCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	maxAutoFieldChange: function(field){
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (maxAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minStaticFieldChange: function(field){
		var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (minStaticCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minAutoFieldChange: function(field){
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);

		if (minAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
    },
	maxStaticCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
		Ext.Array.forEach(fieldset.query('textfield'), function(field) {
			field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});

		if(checked)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	maxAutoCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{
				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		if(checked)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	minStaticCheckChange: function(box, checked)
	{
		 //min static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMinMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();

		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
		Ext.Array.forEach(fieldset.query('textfield'), function(field) {
			field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});
		if(checked)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	minAutoCheckChange: function(box, checked)
	{
		//min auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
		Ext.Array.forEach(fieldset.query('slider'), function(field) {
			field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});
		Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
		Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{
				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		if(checked)
		{
			var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
			var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
			var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
			var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
			if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
			{
				Ext.getCmp('allMeasureContainer').show();
			}
			else
			{
				Ext.getCmp('allMeasureContainer').hide();
			}
		}
    },
	handleSetThresholdEditIconClick: function(grid, rowIndex, colIndex)
	{
		var record = Ext.getCmp('measureGrid').getStore().getAt(rowIndex);
		this.showEditWindow(record);
    },
	getHiddenFieldsForMeasure : function(measureActualVal)
	{
		var hiddenFields = publicJson['hiddenDataObj'][measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			if(key == 'strPolicyName' && Ext.isEmpty(hiddenFields[key]))
			{
				var policyValue = Ext.getCmp('ruleNameText').getValue();
				hiddenQstr += key+'='+encodeURIComponent(policyValue)+"&";
			}
			else
				hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	showEditWindow: function(task)
	{
		var measureName = task.get('Measure');
		var thresholds = task.get('Thresholds');
		var alarmPol = task.get('AlarmPolicy');
		if(measureName.lastIndexOf(' ') != -1)
		{
			measureName = measureName.substring(0,measureName.lastIndexOf(' '));
		}
		var measureActualObj = publicJson.measureDataObj;
		hiddenFieldsVal = this.getHiddenFieldsForMeasure(measureActualObj[measureName.trim()]);
		
		var entryVal = publicJson['hiddenObj']['entry'];
		if(entryVal != null && entryVal == "first")
		{
			var policyname = Ext.getCmp('ruleNameText').getValue(); //thisForm.ThresholdPolicy.value;
			strPolicyName = policyname;
			var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
			var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
			var policyNames = new Array();
			if(policyname == '' || policyname == 'null' || policyname == 'undefined')
			{
				Ext.Msg.show({
					title: pageName,
					msg: noRuleNameMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				Ext.getCmp('ruleNameText').focus();
				return;
			}
			if (policyname.indexOf(" ") > -1)
			{
				Ext.Msg.show({
					title: pageName,
					msg: noSpaceMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				Ext.getCmp('ruleNameText').focus();
				return;
			}
			else if(patCheck)
			{
				Ext.Msg.show({
					title: pageName,
					msg: specialCharMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				Ext.getCmp('ruleNameText').focus();
				return;
			}

			policyNamesJson = publicJson['groupNames'];
			if(policyNamesJson != null && policyNamesJson != "" && !Ext.isEmpty(policyNamesJson))
			{
				var policyNames = policyNamesJson.split(',');
				for(var x=0;x<policyNames.length;x++)
				{
					if(policyNames[x] == policyname)
					{
						Ext.Msg.show({
							title: pageName,
							msg: existRuleNameAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
						 });
						Ext.getCmp('ruleNameText').focus();
						return;
					}
				}
			}
			this.createNewRuleEvent1();
		}
		clicked = 'thresholdrule';
		var homepage = Ext.getCmp('viewportId');
		homepage.removeAll();
		homepage.add({ xtype : 'configurethresholds' });
	},
	configureMainRender: function()
	{
		//alert('hiddenFieldsVal : '+hiddenFieldsVal);
		//if (Ext.isEmpty(hiddenFieldsVal))
		//{
			//if(measure != null && !Ext.isEmpty(measure))
			//{
				//hiddenFieldsVal = this.getHiddenFieldsForMeasure(measure);
			//}
		//}
		//alert('strCompType from Cinfigure Thresholds : '+strCompType+'\n strServer : '+strServer);
		var urlVal = 'GroupThreshold/data/EgConfigureGroupThresholdsJson.jsp?'+hiddenFieldsVal+'&clicked='+clicked;
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			timeout: 6000000,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var strTestName =  publicJson['hiddenObj']['testName'];
				var polName =  publicJson['hiddenObj']['strPolicyName'];
				if (Ext.getCmp('allMeasureContainer').isVisible())
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
				modifyThreshRuleUrl = 'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?policyName='+encodeURIComponent(polName)+'&actionFrom=modify&testName='+strTestName+'&clicked='+clicked;
				isModifyRule = 'true';
				var testDescription = publicJson['screenLabels']['test_description'];
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var isGlobalThresholds = publicJson['isGlobalThresholds'];
				if(isGlobalThresholds)
				{
					Ext.getCmp('minAutoCheck').hide();
					Ext.getCmp('minAutoFieldContainer').hide();
					Ext.getCmp('maxAutoCheck').hide();
					Ext.getCmp('maxAutoFieldContainer').hide();
				}

				var toolTipMsg = publicJson.isToolTip;

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					//min static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMinMajor').setFieldLabel(majorText);
					}

					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
					
				}
				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var minAutomaticOption = minThreshObj.minAutomaticOption;
						var minAutomaticBlock = minThreshObj.minAutomaticBlock;
						if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
						{
							var relMinCritical = minThreshObj.relMinCritical;
							var relMinMajor = minThreshObj.relMinMajor;
							var relMinMinor = minThreshObj.relMinMinor;
							Ext.getCmp('minAutoCheck').show();
							Ext.getCmp('minAutoFieldContainer').show();
							Ext.getCmp('minAutoCheck').setValue(false);
							Ext.getCmp('relMinCritical').setValue(relMinCritical);
							Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
							Ext.getCmp('relMinMajor').setValue(relMinMajor);
							Ext.getCmp('relMinMajorText').setValue(relMinMajor);
							Ext.getCmp('relMinMinor').setValue(relMinMinor);
							Ext.getCmp('relMinMinorText').setValue(relMinMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					//max static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
					}

					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
					
				}

				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
						var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
						if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
						{
							var relMaxCritical = maxThreshObj.relMaxCritical;
							var relMaxMajor = maxThreshObj.relMaxMajor;
							var relMaxMinor = maxThreshObj.relMaxMinor;
							Ext.getCmp('maxAutoCheck').show();
							Ext.getCmp('maxAutoFieldContainer').show();
							Ext.getCmp('maxAutoCheck').setValue(false);
							Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
							Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
							Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
							Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
							Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
							Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}
				var isHostTest = publicJson['isHostTest'];
				descComp.update('<center>'+testDescription+'</center>');

				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					Ext.getCmp('alarmDispField').el.animate({opacity: 1});
					Ext.getCmp('alarmPolicyCombo').getStore().removeAll();
					Ext.getCmp('alarmPolicyCombo').getStore().suspendEvents();
					Ext.getCmp('alarmPolicyCombo').getStore().loadRawData(alarmPolicyCombo);
					Ext.getCmp('alarmPolicyCombo').getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						Ext.getCmp('alarmPolicyCombo').setValue(selectAlarm);
					}
					else
					{
						//selectAlarm = alarmPolicyCombo[0].valueField;
						Ext.getCmp('alarmPolicyCombo').setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//alarmDispField.el.update(selectedAlarmDescription);
						Ext.getCmp('alarmDispField').setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//alarmDispField.el.update(tmpDescription);
						Ext.getCmp('alarmDispField').setValue(tmpDescription);
					}
				}

				var allMeasureCheck = publicJson['allMeasureCheck'];
				if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
				{
					Ext.getCmp('allMeasureContainer').show();
				}
			}
		});
	},
	createNewRuleEvent: function()
	{
		var testName = Ext.getCmp('ruleTestNameCombo').getValue(); //thisForm.testName.options[thisForm.testName.selectedIndex].value;
		var policyname = Ext.getCmp('ruleNameText').getValue(); //thisForm.ThresholdPolicy.value;
		var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
		var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
		var policyNames = new Array();
		if(policyname == '' || policyname == 'null' || policyname == 'undefined')
		{
			Ext.Msg.show({
				title: pageName,
				msg: noRuleNameMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('ruleNameText').focus();
			return;
		}
		if (policyname.indexOf(" ") > -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSpaceMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('ruleNameText').focus();
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('ruleNameText').focus();
			return;
		}

		policyNamesJson = publicJson['groupNames'];
		if(policyNamesJson != null && policyNamesJson != "" && !Ext.isEmpty(policyNamesJson))
		{
			var policyNames = policyNamesJson.split(',');
			for(var x=0;x<policyNames.length;x++)
			{
				if(policyNames[x] == policyname)
				{
					Ext.Msg.show({
						title: pageName,
						msg: existRuleNameAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('ruleNameText').focus();
					return;
				}
			}
		}

		var myRuleMask = new Ext.LoadMask(Ext.getBody(), {msg:"Loading..."});
		myRuleMask.show();

		var params = "testName="+testName+"&policyName="+encodeURIComponent(policyname)+"&operation=newRuleName";
		Ext.Ajax.request({
			url:'GroupThreshold/data/EgApplyGroupThresholdsJson.jsp?'+params,
			method: 'POST',
			scope: this,
			timeout: 60000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					myRuleMask.hide();
					var jsonText = Ext.decode(response.responseText);
					var successUpdate = jsonText['successUpdate'];
					if(successUpdate)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: successMsg1,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function()
							{
								modifyUrl = '';
								var homepage = Ext.getCmp('viewportId');
								myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'thresholdrules' });
								myMask.hide();
							}
						});
					}
				}
			}
		});
	},
	createNewRuleEvent1: function()
	{
		var testName = Ext.getCmp('ruleTestNameCombo').getValue(); //thisForm.testName.options[thisForm.testName.selectedIndex].value;
		var policyname = Ext.getCmp('ruleNameText').getValue(); //thisForm.ThresholdPolicy.value;
		var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
		var patCheck = regExp.test(policyname)||(policyname.indexOf('\\')>=0);
		var policyNames = new Array();
		if(policyname == '' || policyname == 'null' || policyname == 'undefined')
		{
			Ext.Msg.show({
				title: pageName,
				msg: noRuleNameMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('ruleNameText').focus();
			return;
		}
		if (policyname.indexOf(" ") > -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSpaceMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('ruleNameText').focus();
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('ruleNameText').focus();
			return;
		}

		policyNamesJson = publicJson['groupNames'];
		if(policyNamesJson != null && policyNamesJson != "" && !Ext.isEmpty(policyNamesJson))
		{
			var policyNames = policyNamesJson.split(',');
			for(var x=0;x<policyNames.length;x++)
			{
				if(policyNames[x] == policyname)
				{
					Ext.Msg.show({
						title: pageName,
						msg: existRuleNameAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('ruleNameText').focus();
					return;
				}
			}
		}

		var params = "testName="+testName+"&policyName="+encodeURIComponent(policyname)+"&operation=newRuleName";
		Ext.Ajax.request({
			url:'GroupThreshold/data/EgApplyGroupThresholdsJson.jsp?'+params,
			method: 'POST',
			scope: this,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = Ext.decode(response.responseText);
					var successUpdate = jsonText['successUpdate'];
					if(successUpdate)
					{

					}
				}
			}
		});
	},
	showModifyTool: function(view, record, item, index, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			if (actionVal != null && !Ext.isEmpty(actionVal) && actionVal != 'view')
			{
				//Ext.get(icon).removeCls('x-hidden');
			}
		 });
	},
	hideModifyTool: function( view, record, item, index, e, eOpts )
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			if (actionVal != null && !Ext.isEmpty(actionVal) && actionVal != 'view')
			{
				//Ext.get(icon).addCls('x-hidden');
			}
		});
	},
	ruleTestNameChangeEvent: function()
	{
		Ext.getCmp('displayContainer').hide();
		//EgGroupThreshPolicies.jsp?from=addPolicy&compType=Citrix_server&testName=CtxLicenseStatsTest&comeFrom=admin
		var ruleCompType = Ext.getCmp('ruleCompTypeCombo').getValue();
		var ruleTestName = Ext.getCmp('ruleTestNameCombo').getValue();

		if (ruleTestName != null && !Ext.isEmpty(ruleTestName) )
		{
			if (ruleTestName == '-1')
			{
				ruleTestName = 'Groups';
			}
			strTestName = ruleTestName;
			Ext.Ajax.request({
				url:'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?from=addPolicy&comeFrom=admin&compType='+encodeURIComponent(ruleCompType)+'&testName='+ruleTestName+'&clicked='+clicked,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						strCompType = publicJson['selectedCType'];
						strTestName = publicJson['selectedTestName'];
						var isTextBox = publicJson['text_box'];
						var measureValArr = publicJson['measureValArr'];
						var noMeasureValArr = publicJson['noMeasureValArr'];
						var displayTestName = publicJson['displayTestName'];
						var displayPolicyName = publicJson['displayPolicyName'];
						if (isTextBox)
						{
							Ext.getCmp('ruleNameText').show();
							Ext.getCmp('addBtnContainer').show();
						}
						else
						{
							Ext.getCmp('ruleNameText').hide();
							Ext.getCmp('addBtnContainer').hide();
						}

						if (measureValArr != null && !Ext.isEmpty(measureValArr))
						{
							Ext.getCmp('measureGrid').show();
							Ext.getCmp('measureGrid').getStore().removeAll();
							Ext.getCmp('measureGrid').getStore().loadRawData(measureValArr);
						}else
						{
							Ext.getCmp('measureGrid').hide();
						}
						if (noMeasureValArr != null && !Ext.isEmpty(noMeasureValArr))
						{
							Ext.getCmp('noMeasureGrid').show();
							Ext.getCmp('noMeasureGrid').getStore().removeAll();
							Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureValArr);
						}else
						{
							Ext.getCmp('noMeasureGrid').hide();
						}
					}
				}
			});
		}
	},
	ruleCompTypeChangeEvent: function()
	{
		ruleCompType = Ext.getCmp('ruleCompTypeCombo').getValue();
		
		if (ruleCompType != null && !Ext.isEmpty(ruleCompType) )
		{
			if (ruleCompType == '-1')
			{
				ruleCompType = 'Groups';
			}
			strCompType = ruleCompType;
			var tmpTest = '';
			if (strTestName != null && !Ext.isEmpty(strTestName))
			{
				tmpTest = strTestName;
			}
			else
			{
				tmpTest = 'Groups';
			}

			Ext.Ajax.request({
				url:'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?from=addPolicy&testName='+tmpTest+'&comeFrom=admin&compType='+encodeURIComponent(ruleCompType)+'&clicked='+clicked,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var isManagedCompAvailable = publicJson['isManagedCompAvailable'];
						strCompType = publicJson['selectedCType'];
						strTestName = publicJson['selectedTestName'];
						var action = publicJson['hiddenObj']['action'];
						if((action == null || Ext.isEmpty(action) || action == 'undefined') && (action != 'modify' && action != 'view'))
						{
							var grpTestNameArr = publicJson['grpTestNameArr'];
							Ext.getCmp('ruleTestNameCombo').getStore().removeAll();
							Ext.getCmp('ruleTestNameCombo').getStore().clearFilter(true);
							Ext.getCmp('ruleTestNameCombo').getStore().loadRawData(grpTestNameArr);
							if (!Ext.isEmpty(strTestName))
							{
								Ext.getCmp('ruleTestNameCombo').setValue(strTestName);
							}
							else
							{
								Ext.getCmp('ruleTestNameCombo').setValue(grpTestNameArr[0].valueField);
							}
							Ext.getCmp('ruleTestNameCombo').fireEvent('select', Ext.getCmp('ruleTestNameCombo'));
						}
					}
				}
			});
		}
	},
	afterThreshRuleCreateRender: function()
	{
		Ext.getCmp('displayContainer').hide();
		Ext.getCmp('addBtnContainer').hide();
		if (specificThreshPage != null && !Ext.isEmpty(specificThreshPage))
		{
			if (!Ext.isEmpty(strCompType))
			{
				strServer = strCompType;
				tName = strTestName;
				urlVal =  'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?specthreshpage='+specificThreshPage+'&testName='+strTestName+'&strServer='+encodeURIComponent(strCompType)+'&component='+encodeURIComponent(strCompName)+'&comeFrom=admin';

			}
			else
			{
				urlVal =  'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?specthreshpage='+specificThreshPage+'&testName='+tName+'&strServer='+encodeURIComponent(strServer)+'&component='+encodeURIComponent(strCompName)+'&comeFrom=admin';
			}

			//EgGroupThreshPolicies.jsp?specthreshpage=yes&test=NetworkTest&component=win_1:NULL&strServer=Windows_server&comeFrom=admin
			//urlVal =  'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?specthreshpage='+specificThreshPage+'&testName='+strTestName+'&strServer='+encodeURIComponent(strCompType)+'&component='+encodeURIComponent(strCompName)+'&comeFrom=admin';

		}
		else if (!Ext.isEmpty(isModifyRule) && isModifyRule == 'true')
		{
			if(modifyThreshRuleUrl != null && !Ext.isEmpty(modifyThreshRuleUrl) )
			{
				urlVal = modifyThreshRuleUrl+'&urlForModifyRule='+encodeURIComponent(modifyThreshRuleUrl)+'&isModifyRule='+isModifyRule;
			}
			else if (!Ext.isEmpty(urlForModifyRule))
			{
				urlVal = urlForModifyRule+'&urlForModifyRule='+encodeURIComponent(urlForModifyRule)+'&isModifyRule='+isModifyRule;
			}
			
		}
		else if (!Ext.isEmpty(measure) && !Ext.isEmpty(strTestName))
		{
			urlVal =  'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?testName='+strTestName+'&comeFrom=admin&policyName='+encodeURIComponent(strPolName)+'&actionFrom=modify';
		}
		else
		{
			urlVal = 'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?from=addPolicy&comeFrom=admin';

			if (strCompType != null && !Ext.isEmpty(strCompType))
			{
				urlVal += '&compType='+encodeURIComponent(strCompType);
			}
			else
			{
				urlVal += '&compType=Groups';
			}
		
			if (strTestName != null && !Ext.isEmpty(strTestName))
			{
				urlVal += '&testName='+strTestName;
			}
			else
			{
				urlVal += '&testName=Groups';
			}
		}
		
		Ext.Ajax.request({
			url:urlVal+'&clicked='+clicked,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					var isManagedCompAvailable = publicJson['isManagedCompAvailable'];
					if (!isManagedCompAvailable)
					{
						Ext.getCmp('noComponentsContainer').show();
						Ext.getCmp('comboBoxContainer').hide();
					}
					else
					{
						Ext.getCmp('noComponentsContainer').hide();
						Ext.getCmp('comboBoxContainer').show();

						strCompType = publicJson['selectedCType'];
						strTestName = publicJson['selectedTestName'];
						var action = publicJson['hiddenObj']['action'];
						if((action == null || Ext.isEmpty(action) || action == 'undefined') && (action != 'modify' && action != 'view'))
						{
							Ext.getCmp('comboBoxContainer').show();
							//Ext.getCmp('addBtnContainer').show();
							var grpCompTypeArr = publicJson['grpCompTypeArr'];
							var grpTestNameArr = publicJson['grpTestNameArr'];
							Ext.getCmp('ruleCompTypeCombo').getStore().removeAll();
							Ext.getCmp('ruleCompTypeCombo').getStore().clearFilter(true);
							Ext.getCmp('ruleCompTypeCombo').getStore().loadRawData(grpCompTypeArr);
							Ext.getCmp('ruleCompTypeCombo').setValue(grpCompTypeArr[0].valueField);
							if (!Ext.isEmpty(strCompType))
							{
								Ext.getCmp('ruleCompTypeCombo').setValue(strCompType);
							}
							else
							{
								Ext.getCmp('ruleCompTypeCombo').setValue(grpTestNameArr[0].valueField);
							}
							Ext.getCmp('ruleCompTypeCombo').fireEvent('select', Ext.getCmp('ruleCompTypeCombo'));
						}
						else
						{
							var measureValArr = publicJson['measureValArr'];
							var noMeasureValArr = publicJson['noMeasureValArr'];
							var displayTestName = publicJson['displayTestName'];
							var displayPolicyName = publicJson['displayPolicyName'];

							Ext.getCmp('comboBoxContainer').hide();
							Ext.getCmp('addBtnContainer').hide();
							Ext.getCmp('displayContainer').show();
							
							Ext.getCmp('testNameDisplayField').setValue(displayTestName);
							Ext.getCmp('ruleNameDisplayField').setValue(displayPolicyName);

							if (measureValArr != null && !Ext.isEmpty(measureValArr))
							{
								Ext.getCmp('measureGrid').show();
								Ext.getCmp('measureGrid').getStore().removeAll();
								Ext.getCmp('measureGrid').getStore().loadRawData(measureValArr);
							}else
							{
								Ext.getCmp('measureGrid').hide();
							}
							if (noMeasureValArr != null && !Ext.isEmpty(noMeasureValArr))
							{
								Ext.getCmp('noMeasureGrid').show();
								Ext.getCmp('noMeasureGrid').getStore().removeAll();
								Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureValArr);
							}else
							{
								Ext.getCmp('noMeasureGrid').hide();
							}
						}
					}
				}
			}
		});
	},
	afterThresholdViewMainRender: function()
	{
		var searchVal = Ext.getCmp('searchRuleTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchRuleTrigger').reset();
		}
		Ext.getCmp('searchRuleTrigger').setDisabled(true);

		//no rule url://localhost:7077/final/admin/EgShowThresholdPolicies.jsp?ServerType=null&serv=null&test=null
		var urlVal = 'GroupThreshold/data/EgShowThresholdPoliciesJson.jsp?';
		//var qString = 
		if (strCompType != null && !Ext.isEmpty(strCompType))
		{
			urlVal += 'ServerType='+encodeURIComponent(strCompType);
		}
		else
		{
			urlVal += 'ServerType=Groups';
		}
		if (strTestName != null && !Ext.isEmpty(strTestName))
		{
			urlVal += '&testName='+strTestName;
		}
		else
		{
			urlVal += '&testName=Groups';
		}
		modifyThreshRuleUrl = '';
		isModifyRule = 'false';
		Ext.Ajax.request({
			url:urlVal+'&clicked='+clicked,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					var isNoData = publicJson['isNoData'];
					Ext.getCmp('thresholdRulesGrid').show();
					var grpRuleGridDataArr = publicJson['grpRuleGridDataArr'];
					Ext.getCmp('thresholdRulesGrid').getStore().removeAll();
					Ext.getCmp('thresholdRulesGrid').getStore().loadRawData(grpRuleGridDataArr);

					if (!isNoData)
					{
						Ext.getCmp('searchRuleTrigger').setDisabled(false);
						componentRawData = grpRuleGridDataArr;
					}
					else
					{
						Ext.getCmp('searchRuleTrigger').setDisabled(true);
					}
				}
			}
		});
	},
	gotoAssociatePageEvent: function(type)
	{
		clicked = 'associaterule';
		associatePolicyName = '';
		if (type.id == 'compGrpAssociateBtn')
		{
			associateBtnClicked = 'Component group page';  
		}
		else
		{
			associateBtnClicked = 'Threshold rule page';
		}
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'associaterule' });
		myMask.hide();
	},
	addNewRuleEvent: function()
	{
		clicked = 'thresholdrule';
		specificThreshPage = '';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'thresholdrule' });
		myMask.hide();
	},
	newRulePageBackEvent : function()
	{
		if (specificThreshPage != null && !Ext.isEmpty(specificThreshPage))
		{
			//server=Windows_server&compName=win_1:NULL&test=NetworkTest&isBack=yes
			window.location.href= '/final/admin/EgSpecificThresh.jsp?server='+encodeURIComponent(strServer)+'&compName='+encodeURIComponent(strCompName)+'&test='+strTestName+'&fromWizard='+fromWizard;
		}
		else
		{
			strCompType = '';
			strTestName = '';
			clicked = 'thresholdrules';
			var homepage = Ext.getCmp('viewportId');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'thresholdrules' });
			myMask.hide();
		}
	},
	newGroupPageBackEvent : function()
	{
		clicked = 'componentgroups';
		strCompType = '';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'componentgroups' });
		myMask.hide();
	},
	rulePageBackEvent : function()
	{
		clicked = 'componentgroups';
		strCompType = '';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'componentgroups' });
		myMask.hide();
	},
	compGroupSearchEvent: function(obj)
	{
		var findVal = obj.getValue();
		if (findVal == "" || findVal.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		var compStore = componentRawData;//publicJson['grpDataGridArr'];

		var compObj = Ext.getCmp('componentGroupGrid');
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compObj.getStore().loadRawData(compStore);
		}
		else
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['ComponentGroup','AssociatedRules','modifyUrl','deleteUrl','isView'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['ComponentGroup'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'ComponentGroup': compStore[i]['ComponentGroup'],
						'AssociatedRules': compStore[i]['AssociatedRules'],
						'modifyUrl': compStore[i]['modifyUrl'],
						'deleteUrl': compStore[i]['deleteUrl'],
						'isView': compStore[i]['isView'],
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll();    
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
			}
			else
			{
				compObj.getStore().removeAll();
				var htmlPreDefData = "<div class='error_panel' style='height:95%;display:flex;flex-direction: column;align-items:center;justify-content:center;'><div class='iconInformation' style='margin:0px auto'></div><div class='commonErrorMsgText'>"+noGrpSearchText+".</div></div>";

				compObj.store.loadData('');
				compObj.getView().emptyText = htmlPreDefData;
				compObj.getView().refresh();
			}
			obj.focus();
		}
	},
	thresholdRuleSearchEvent: function(obj)
	{
		var findVal = obj.getValue();
		if (findVal == "" || findVal.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		var compStore = componentRawData;//publicJson['grpDataGridArr'];

		var compObj = Ext.getCmp('thresholdRulesGrid');
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compObj.getStore().loadRawData(compStore);
		}
		else
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['ThresholdRule','AssociatedGroups','modifyUrl','deleteUrl','isView'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['ThresholdRule'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'ThresholdRule': compStore[i]['ThresholdRule'],
						'AssociatedGroups': compStore[i]['AssociatedGroups'],
						'modifyUrl': compStore[i]['modifyUrl'],
						'deleteUrl': compStore[i]['deleteUrl'],
						'isView': compStore[i]['isView'],
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll();    
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
			}
			else
			{
				compObj.getStore().removeAll();
				//var htmlPreDefData = "<table align='center'><tr><td align='center' height='400'><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+noRuleSearchText+".</td></tr></table></td></tr></table>";
				var htmlPreDefData = "<div class='egFlexCenterByColumnWise' style='height:98%'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+noRuleSearchText+".</div></div> ";

				compObj.store.loadData('');
				compObj.getView().emptyText = htmlPreDefData;
				compObj.getView().refresh();
			}
			obj.focus();
		}
	},
	filterGridTriggerClick : function(obj)
    {
		var compStore = componentRawData;
		var compObj = Ext.getCmp('componentGroupGrid');

		if ( Ext.isEmpty( obj) )
		{
			compObj.getStore().loadRawData(compStore);
		}
		else
		{
			var findVal = obj;
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['ComponentGroup','AssociatedRules','modifyUrl','deleteUrl','isView'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['ComponentGroup'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'ComponentGroup': compStore[i]['ComponentGroup'],
						'AssociatedRules': compStore[i]['AssociatedRules'],
						'modifyUrl': compStore[i]['modifyUrl'],
						'deleteUrl': compStore[i]['deleteUrl'],
						'isView': compStore[i]['isView'],
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll();    
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
			}
			else
			{
				compObj.getStore().removeAll();
				var htmlPreDefData = "<table align='center'><tr><td align='center' height='400'><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+noGrpSearchText+".</td></tr></table></td></tr></table>";

				compObj.store.loadData('');
				compObj.getView().emptyText = htmlPreDefData;
				compObj.getView().refresh();

			}
			Ext.getCmp('searchTrigger').focus();
		}
	},
	filterThresholdRuleTriggerEvent : function(obj)
    {
		var compStore = componentRawData;
		var compObj = Ext.getCmp('thresholdRulesGrid');

		if ( Ext.isEmpty( obj) )
		{
			compObj.getStore().loadRawData(compStore);
		}
		else
		{
			var findVal = obj;
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['ThresholdRule','AssociatedGroups','modifyUrl','deleteUrl','isView'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['ThresholdRule'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'ThresholdRule': compStore[i]['ThresholdRule'],
						'AssociatedGroups': compStore[i]['AssociatedGroups'],
						'modifyUrl': compStore[i]['modifyUrl'],
						'deleteUrl': compStore[i]['deleteUrl'],
						'isView': compStore[i]['isView'],
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll();    
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
			}
			else
			{
				compObj.getStore().removeAll();
				var htmlPreDefData = "<table align='center'><tr><td align='center' height='400'><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+noRuleSearchText+".</td></tr></table></td></tr></table>";

				compObj.store.loadData('');
				compObj.getView().emptyText = htmlPreDefData;
				compObj.getView().refresh();
			}
			Ext.getCmp('searchRuleTrigger').focus();
		}
	},
	showTool: function(view, record, item, index, e)
	{
		var hideIcon = view.getStore().getAt(index);
		var isView = hideIcon.get('isView');
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			if (!isView)
			{
				//Ext.get(icons[0]).removeCls('x-hidden');
				//Ext.get(icons[1]).removeCls('x-hidden');
			}
			else
			{
				//Ext.get(icons[2]).removeCls('x-hidden');
			}
		 });
	},
	hideTool: function( view, record, item, index, e, eOpts )
	{
		var hideIcon = view.getStore().getAt(index);
		var isView = hideIcon.get('isView');

		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			if (!isView)
			{
				//Ext.get(icons[0]).addCls('x-hidden');
				//Ext.get(icons[1]).addCls('x-hidden');
			}
			else
			{
				//Ext.get(icons[2]).addCls('x-hidden');
			}
		});
	},
	showAddCompGroupWindowEvent: function(){
		clicked = 'componentgroup';
		strCompType = '';
		modifyUrl = '';
		isModifyGroup = 'false';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'componentgroup' });
		myMask.hide();
	},
	showAddThresholdRuleWindowEvent: function(){
		clicked = 'thresholdrules';
		modifyUrl = '';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'thresholdrules' });
		myMask.hide();
	},
	handleViewIconClick: function(grid, rowIndex, colIndex){
		clicked = 'componentgroups';
		isModifyGroup = 'true';

		var rec = Ext.getCmp('componentGroupGrid').getStore().getAt(rowIndex);
		var grpName = rec.get('ComponentGroup');
		modifyUrl = 'GroupThreshold/data/EgConfigServerGroupsJson.jsp?mode=view&groupName='+encodeURIComponent(grpName);
		var viewCompGrpWindow = Ext.widget('componentgroupview');
		viewCompGrpWindow.show();
	},
	handleEditIconClick: function(grid, rowIndex, colIndex){
		//EgConfigServerGroups.jsp?groupName=vvEsx&mode=view
		clicked = 'componentgroup';
		isModifyGroup = 'true';
		var rec = Ext.getCmp('componentGroupGrid').getStore().getAt(rowIndex);
		var grpName = rec.get('ComponentGroup');
		modifyUrl = rec.get('modifyUrl');
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'componentgroup' });
		myMask.hide();
	},

	handleDeleteIconClick: function(grid, rowIndex, colIndex){
		var rec = Ext.getCmp('componentGroupGrid').getStore().getAt(rowIndex);
		var grpName = rec.get('ComponentGroup');
		var deleteUrl = rec.get('deleteUrl');
		Ext.Msg.show({
			title: pageName,
			msg: deleteGrpConfirmMsg+" '"+grpName+"'?", 
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function(btnText) {
				if (btnText == "yes") 
				{
					Ext.Ajax.request({
						url: deleteUrl,
						method: 'POST',
						scope: this,
						timeout: 6000000,
						success: function( response )
						{
							if (response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var jsonText = Ext.decode(response.responseText);
								if (jsonText.successUpdate)
								{
									me.afterMainRender();
								}
								else
								{
									Ext.Msg.show({
										title: pageName+' : '+jsonText.errorMsgTitle,
										msg: jsonText.errorMsg,
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation'
									 });
									return;
								}
							}
						}
					});
				}
			}
		});
	},
	handleThreshRuleViewIconClick: function(grid, rowIndex, colIndex){
		var rec = Ext.getCmp('thresholdRulesGrid').getStore().getAt(rowIndex);
		var ruleName = rec.get('ThresholdRule');
		var isView = rec.get('isView');
		if(isView)
		{
			actionVal = 'view';
		}
		else
		{
			actionVal = 'modify';
		}
		specificThreshPage = '';
		clicked = 'thresholdrule';
		modifyThreshRuleUrl = 'GroupThreshold/data/EgGroupThreshPoliciesJson.jsp?actionFrom=view&policyName='+encodeURIComponent(ruleName);
		isModifyRule = 'true';
		//EgGroupThreshPolicies.jsp?policyName=cisFanRule&actionFrom=view
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'thresholdrule' });
		myMask.hide();
	},
	handleThreshRuleEditIconClick: function(grid, rowIndex, colIndex){
		actionVal = 'modify';
		//final/admin/EgGroupThreshPolicies.jsp?policyName=HttpRule&actionFrom=modify
		var rec = Ext.getCmp('thresholdRulesGrid').getStore().getAt(rowIndex);
		var ruleName = rec.get('ThresholdRule');
		specificThreshPage = '';
		clicked = 'thresholdrule';
		modifyThreshRuleUrl = rec.get('modifyUrl');
		isModifyRule = 'true';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'thresholdrule' });
		myMask.hide();
	},

	handleThreshRuleDeleteIconClick: function(grid, rowIndex, colIndex){
		actionVal = 'modify';
		//var GridValues = grid.getStore().getAt(rowIndex);
		var GridValues = Ext.getCmp('thresholdRulesGrid').getStore().getAt(rowIndex);

		var ruleName = GridValues.get('ThresholdRule');
		var deleteUrl = GridValues.get('deleteUrl');
		Ext.Msg.show({
			title: pageName,
			msg: deleteRuleConfirmMsg+" '"+ruleName+"'?", 
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function(response) {
				if (response == "yes") 
				{
					Ext.Ajax.request({
						url: deleteUrl,
						method: 'POST',
						scope: this,
						timeout: 6000000,
						success: function( response )
						{
							if (response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var jsonText = Ext.decode(response.responseText);
								if (jsonText.successUpdate)
								{
									me.afterThresholdViewMainRender();
								}
								else
								{
									Ext.Msg.show({
										title: pageName+' : '+jsonText.errorMsgTitle,
										msg: jsonText.errorMsg,
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation'
									 });
									return;
								}
							}
						}
					});
				}
			}
		});
	},
	destroyWindow: function()
	{
		clicked = 'componentgroups';
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'componentgroups' });
		myMask.hide();
	},
	callBack: function()
	{
		var addXtype = 'componentgroups';
		if (associateBtnClicked != null && associateBtnClicked != 'Component group page')
		{
			addXtype = 'thresholdrules';
		}
		clicked = addXtype;
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : addXtype });
		myMask.hide();
	},
	updateGroupEvent: function(btn)
	{
		var funmng = new Array();
		var fmng = new Array();
		var groupNames = new Array() //tt
		var unmnglen = Ext.getCmp('compAssociateItemSelector').toField.store.getCount();
		var mnglen = Ext.getCmp('compAssociateItemSelector').fromField.store.getCount();
		var funmglst = Ext.getCmp('compAssociateItemSelector').toField.store;
		var fmglst = Ext.getCmp('compAssociateItemSelector').fromField.store;

		var hasFilterInToStore = Ext.getCmp('compAssociateItemSelector').toField.store.isFiltered();
		var hasFilterInFromStore = Ext.getCmp('compAssociateItemSelector').fromField.store.isFiltered();

		if (hasFilterInToStore)
		{
			var toFieldStore = Ext.getCmp('compAssociateItemSelector').toField.store;

			unmnglen = toFieldStore.snapshot.length;;
			funmglst = toFieldStore.snapshot;
		}

		if (hasFilterInFromStore)
		{
			var fromFieldStore = Ext.getCmp('compAssociateItemSelector').fromField.store;

			mnglen = fromFieldStore.snapshot.length;
			fmglst = fromFieldStore.snapshot;
		}


		var groupname = Ext.getCmp('groupTextId').getValue();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var regExp = /[@#*&,~^!$()+%=:<>;?\"\'\]\|\}\/\[\{]/;
		var patCheck = regExp.test(groupname)||(groupname.indexOf('\\')>=0);
		groupNamesJson = publicJson['groupNames'];
		pfmanage = publicJson['pfmanage'];
		var prevGroup = '';
		if (compGrpFrom != null && compGrpFrom == 'modify')
		{
			var old_groupname = publicJson['hiddenObj']['groupName'];
			prevGroup = old_groupname;

			if (old_groupname != null && old_groupname != 'undefined' && old_groupname != groupname)
			{
				if(groupNamesJson != null && groupNamesJson != "" && !Ext.isEmpty(groupNamesJson))
				{
					var groupNames = groupNamesJson.split(',');
					for(var x=0;x<groupNames.length;x++)
					{
						if(groupNames[x] == groupname)
						{
							Ext.Msg.show({
								title: pageName,
								msg: existGrpAlertMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation'
							 });
							return;
						}
					}
				}
			}
		}
		else
		{
			if(groupNamesJson != null && groupNamesJson != "" && !Ext.isEmpty(groupNamesJson))
			{
				var groupNames = groupNamesJson.split(',');
				for(var x=0;x<groupNames.length;x++)
				{
					if(groupNames[x] == groupname)
					{
						Ext.Msg.show({
							title: pageName,
							msg: existGrpAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation'
						 });
						return;
					}
				}
			}
		}
		

		for(var z = 0 ; z < unmnglen ; z++)
		{
			if(funmglst.getAt(z).get('valueField') == null)
			{
				continue;
			}
			else
			{
				funmng[z] = funmglst.getAt(z).get('valueField');
			}
		}

		for(var y = 0 ; y < mnglen ; y++)
		{
			if(fmglst.getAt(y).get('valueField') == null)
			{
				continue;
			}
			else
			{
				fmng[y] = fmglst.getAt(y).get('valueField');
			}
		}
		var fmanage = fmng;
		var funmanage = funmng;
		if (!Ext.isEmpty(compType) && (compType == '-1' || compType == 'Groups' || compType == 'groups'))
		{
			Ext.Msg.show({
				title: pageName,
				msg: noCompTypeMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('compTypeCombo').focus();
			return;
		}
		if(!checkblank(groupname))
		{
			Ext.Msg.show({
				title: pageName,
				msg: noGroupNameMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('groupTextId').focus();
			return;
		}
		else if (groupname.indexOf(" ") > -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: noSpaceMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('groupTextId').focus();
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('groupTextId').focus();
			return;
		}
		else if(mnglen!= 0)
		{
			var hiddenVal = this.getHiddenFieldsForCompGrp();
			var server = Ext.getCmp('compTypeCombo').getValue();
			var homepage = Ext.getCmp('componentgroupId');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			myMask.show();
			var formObj = this.getComponentgroup().getForm();
			if (formObj.isValid())
			{
				Ext.getCmp('fmanage').setValue(fmanage);
				Ext.getCmp('funmanage').setValue(funmanage);
				if (!Ext.isEmpty(pfmanage))
				{
					Ext.getCmp('pfmanage').setValue(pfmanage);
				}
				this.getComponentgroup().submit({
					url:'GroupThreshold/data/EgconfigservergroupspJson.jsp?'+hiddenVal+'server='+encodeURIComponent(server)+'&group='+encodeURIComponent(groupname)+'&prevGroup='+encodeURIComponent(prevGroup),
					method:'POST',
					scope:this,
					//async: false,
					timeout: 9000,
					success: function(form, action){
						if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText))
						{
							var jsonText = Ext.decode(action.response.responseText);
							if (jsonText.successUpdate == 'true')
							{
								Ext.getCmp('fmanage').setValue('');
								Ext.getCmp('funmanage').setValue('');
								Ext.getCmp('pfmanage').setValue('');
								myMask.hide();
								Ext.Msg.show({
									title: pageName,
									msg: successMsg2,
									width: 350,
									buttons: Ext.MessageBox.OK,
									icon: 'iconInformation',
									fn: me.destroyWindow
								});
							}
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						Ext.getCmp('fmanage').setValue('');
						Ext.getCmp('funmanage').setValue('');
						Ext.getCmp('pfmanage').setValue('');
						myMask.hide();

						 switch (action.failureType) {
							case Ext.form.action.Action.CLIENT_INVALID:
								Ext.Msg.show ({
									title: pageName,
									msg: 'Form fields may not be submitted with invalid values',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation',
								});
								break;
							case Ext.form.action.Action.CONNECT_FAILURE:
								Ext.Msg.show ({
									title: pageName,
									msg: 'Ajax communication failed',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation',
								});
								break;
							case Ext.form.action.Action.SERVER_INVALID:
								Ext.Msg.show ({
									title: action.result.msg,
									msg: 'Ajax communication failed',
									buttons: Ext.MessageBox.OK,
									icon: 'iconExclamation',
								});
					   }
					}
				});
			}
		}
		else
		{
			Ext.Msg.show({
				title: pageName,
				msg: noUpdateMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			return;
		}
	},
	getHiddenFieldsForCompGrp : function()
	{
		var hiddenFields = publicJson['hiddenObj'];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			if (key == 'pfmanage' || key == 'prev')
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	getHiddenFields : function()
	{
		var hiddenFields = publicJson['hiddenObj'];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	compTypeComboEvent: function()
	{
		var compItemSelectorObj = Ext.getCmp('compAssociateItemSelector');
		var fromTriggerObj =  compItemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  compItemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		Ext.getCmp('noComponentsContainer').hide();
		Ext.getCmp('itemSelectorContainer').hide();
		Ext.getCmp('updateBtnContainer').hide();
		Ext.getCmp('groupTextId').hide();

		//var hiddenVal = this.getHiddenFields();
		//alert('hiddenVal : '+hiddenVal);
		var compType = Ext.getCmp('compTypeCombo').getValue();
		if (Ext.isEmpty(compType) || compType == '-1')
		{
			compType = 'Groups';
			strCompType = compType;
		}

		compGrpFrom = 'add';
		if (compType != null && !Ext.isEmpty(compType) && compType != '-1')
		{
			Ext.Ajax.request({
				url:'GroupThreshold/data/EgConfigServerGroupsJson.jsp?from=add&serv='+encodeURIComponent(compType)+'&clicked='+clicked,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 60000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var grpAssoCompArr = publicJson['grpAssoCompArr'];
						var grpRemainCompArr = publicJson['grpRemainCompArr'];
						if (!Ext.isEmpty(compType) && compType == 'Groups')
						{
							Ext.getCmp('itemSelectorContainer').show();
							Ext.getCmp('updateBtnContainer').show();
							if (Ext.getCmp('compAssociateItemSelector').fromField.store.getCount() >= 1)
							{
								Ext.getCmp('compAssociateItemSelector').fromField.store.removeAll();
							}
							if (Ext.getCmp('compAssociateItemSelector').toField.store.getCount() >= 1)
							{
								Ext.getCmp('compAssociateItemSelector').toField.store.removeAll();
							}
						}
						else
						{
							if (grpRemainCompArr != null && grpRemainCompArr != 'undefined' && !Ext.isEmpty(grpRemainCompArr))
							{
								Ext.getCmp('groupTextId').show();
								//Ext.getCmp('groupTextId').setReadOnly(false);
								Ext.getCmp('groupTextId').reset();

								Ext.getCmp('itemSelectorContainer').show();
								Ext.getCmp('updateBtnContainer').show();
								if (Ext.getCmp('compAssociateItemSelector').fromField.store.getCount() >= 1)
								{
									Ext.getCmp('compAssociateItemSelector').fromField.store.removeAll();
								}
								if (Ext.getCmp('compAssociateItemSelector').toField.store.getCount() >= 1)
								{
									Ext.getCmp('compAssociateItemSelector').toField.store.removeAll();
								}

								if(grpAssoCompArr != null && !Ext.isEmpty(grpAssoCompArr))
									Ext.getCmp('compAssociateItemSelector').fromField.store.add(grpAssoCompArr);
								if(grpRemainCompArr != null && !Ext.isEmpty(grpRemainCompArr))
									Ext.getCmp('compAssociateItemSelector').toField.store.add(grpRemainCompArr);
							}
							else
							{
								//var noDataLabel = publicJson['screenLabels']['No_components_msg'];
								Ext.getCmp('noComponentsContainer').show();
								//Ext.getCmp('noComponentGroupLabel').update(noDataLabel);
							}
						}
					}
				}
			});
		}
		else
		{
			Ext.getCmp('groupTextId').hide();
			Ext.getCmp('itemSelectorContainer').hide();
			Ext.getCmp('updateBtnContainer').hide();
			Ext.getCmp('noComponentsContainer').hide();
		}
	},
	setToolTipForPanel: function(tipMsg) {
		new Ext.ToolTip({
			target: document.getElementById('homeTitle'),
			anchor: 'top',
			anchorOffset:42,
			mouseOffset: [-55, 0],
			html: tipMsg,
			cls: "adminInfoTooltip"
		});
	},
	afterAddComponentGroupRender: function()
	{
		//alert('clicked from AddGroupButton  : '+clicked);
		var urlString  = 'GroupThreshold/data/EgConfigServerGroupsJson.jsp?from=add&test=Groups';
		var parent = window.parent;

		if (!Ext.isEmpty(isModifyGroup) && isModifyGroup == 'true' )
		{
			compGrpFrom = 'modify';
			if(modifyUrl != null && !Ext.isEmpty(modifyUrl))
			{
				urlString = modifyUrl+'&urlForModifyGroup='+encodeURIComponent(parent.filterEncode(modifyUrl))+'&isModifyGroup='+isModifyGroup;
			}
			else if (!Ext.isEmpty(urlForModifyGroup))
			{
				urlString = urlForModifyGroup+'&urlForModifyGroup='+encodeURIComponent(parent.filterEncode(urlForModifyGroup))+'&isModifyGroup='+isModifyGroup;
			}
		}
		else
		{
			compGrpFrom = 'add';
			if (strCompType != null && !Ext.isEmpty(strCompType))
			{
				urlString += '&serv='+strCompType
			}
			else
			{
				urlString += '&serv=Groups&mode=add';
			}
		}
		Ext.Ajax.request({
			url:urlString+'&clicked='+clicked,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					var isNoData = publicJson['isNoData'];
					if (isNoData)
					{
						Ext.getCmp('comboContainer').hide();
						Ext.getCmp('itemSelectorContainer').hide();
						Ext.getCmp('updateBtnContainer').hide();
						Ext.getCmp('noComponentsContainer').show();
					}
					else
					{
						Ext.getCmp('comboContainer').show();
						Ext.getCmp('itemSelectorContainer').show();
						Ext.getCmp('updateBtnContainer').show();
						Ext.getCmp('noComponentsContainer').hide();

						var selectedCType = publicJson['selectedCType'];
						var grpCompTypeArr = publicJson['grpCompTypeArr'];
						var windowTitle = publicJson['screenLabels']['title_grpName'];
						if (windowTitle != null && !Ext.isEmpty(windowTitle))
						{
							var compGrpTitle = '<div>'+windowTitle+' <img src="/final/images/spacer.gif" id="homeTitle" class="iconInfoCircle" style="vertical-align:text-top;position:relative;top:2px"/></div>';
							Ext.getCmp('componentgroupId').setTitle(compGrpTitle);
							this.setToolTipForPanel(pageDesc4);
						}

						if (selectedCType != null && !Ext.isEmpty(selectedCType))
						{
							var groupName = publicJson['hiddenObj']['groupName'];
							var grpAssoCompArr = publicJson['grpAssoCompArr'];
							var grpRemainCompArr = publicJson['grpRemainCompArr'];
							//alert('grpAssoCompArr  : '+grpAssoCompArr+'\n  grpRemainCompArr : '+grpRemainCompArr);
							Ext.getCmp('compTypeCombo').getStore().removeAll();
							Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
							Ext.getCmp('compTypeCombo').getStore().loadRawData(grpCompTypeArr);
							Ext.getCmp('compTypeCombo').setValue(selectedCType);
							strCompType = selectedCType;
							//Ext.getCmp('compTypeCombo').fireEvent('select', Ext.getCmp('compTypeCombo'));
							Ext.getCmp('groupTextId').show();
							Ext.getCmp('itemSelectorContainer').show();
							Ext.getCmp('updateBtnContainer').show();
							Ext.getCmp('groupTextId').setValue(groupName);
							//Ext.getCmp('groupTextId').setReadOnly(true);
							if (Ext.getCmp('compAssociateItemSelector').fromField.store.getCount() >= 1)
							{
								Ext.getCmp('compAssociateItemSelector').fromField.store.removeAll();
							}
							if (Ext.getCmp('compAssociateItemSelector').toField.store.getCount() >= 1)
							{
								Ext.getCmp('compAssociateItemSelector').toField.store.removeAll();
							}

							if(grpAssoCompArr != null && !Ext.isEmpty(grpAssoCompArr))
								Ext.getCmp('compAssociateItemSelector').fromField.store.add(grpAssoCompArr);
							if(grpRemainCompArr != null && !Ext.isEmpty(grpRemainCompArr))
								Ext.getCmp('compAssociateItemSelector').toField.store.add(grpRemainCompArr);
						}
						else
						{
							Ext.getCmp('compTypeCombo').getStore().removeAll();
							Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
							Ext.getCmp('compTypeCombo').getStore().loadRawData(grpCompTypeArr);
							Ext.getCmp('compTypeCombo').setValue(grpCompTypeArr[0].valueField);
						}
					}
				}
			}
		});
	},
	afterViewComponentGroupRender: function()
	{
		//alert('modifyUrl  : '+modifyUrl);
		var urlString  = 'GroupThreshold/data/EgConfigServerGroupsJson.jsp?from=add&test=Groups&serv=Groups&clicked='+clicked;
		if(modifyUrl != null && !Ext.isEmpty(modifyUrl))
		{
			urlString = modifyUrl;
		}
		Ext.Ajax.request({
			url:urlString,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					var grpViewOnlyCompArr = publicJson['grpViewOnlyCompArr'];
					var componentGroupViewGridTitle = publicJson['componentGroupViewGridTitle'];
					Ext.getCmp('componentGrpViewGrid').setTitle(componentGroupViewGridTitle);
					Ext.getCmp('componentGrpViewGrid').getStore().removeAll();
					Ext.getCmp('componentGrpViewGrid').getStore().loadRawData(grpViewOnlyCompArr);
				}
			}
		});
	},
	afterMainRender: function()
	{
		var searchVal = Ext.getCmp('searchTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchTrigger').reset();
		}
		Ext.getCmp('searchTrigger').setDisabled(true);

		if (specificThreshPage != null && !Ext.isEmpty(specificThreshPage))
		{
			strServer = strCompType;
			tName = strTestName;
			//strCompName = strComponent;
			var homepage = Ext.getCmp('viewportId');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'thresholdrule' });
			myMask.hide();
		}
		else
		{
			if (clicked != null && !Ext.isEmpty(clicked) && clicked != 'componentgroups')
			{
				var homepage = Ext.getCmp('viewportId');
				myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
				homepage.removeAll();
				myMask.show();
				homepage.add({ xtype : clicked });
				myMask.hide();
			}
			else
			{

			Ext.Ajax.request({
				url:'GroupThreshold/data/EgShowServerGroupsJson.jsp?ServerType=null&test=null&clicked='+clicked,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 60000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var isNoData = publicJson['isNoData'];
						if (!Ext.isEmpty(fromSpecs))
						{
							Ext.getCmp('fromSpecificBackBtn').show();
						}
						else
						{
							Ext.getCmp('fromSpecificBackBtn').hide();
						}

						Ext.getCmp('componentGroupGrid').show();
						var grpDataGridArr = publicJson['grpDataGridArr'];
						Ext.getCmp('componentGroupGrid').getStore().removeAll();
						Ext.getCmp('componentGroupGrid').getStore().loadRawData(grpDataGridArr);

						if (!isNoData)
						{
							Ext.getCmp('searchTrigger').setDisabled(false);
							componentRawData = grpDataGridArr;
						}
						else
						{
							Ext.getCmp('searchTrigger').setDisabled(true);
						}
					}
				}
			});
			}
		}
	}
});

function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkStars(fieldvalue)
{
	var val = fieldvalue;
	if (val.length == 2)
	{
		if(val.charAt(0) == '*' && val.charAt(val.length - 1) == '*')
		{
			Ext.Msg.show ({
				title: pageName,
				msg: checkStarMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return false;
		}
	}
	else
	{
		for(var k=0;k < val.length;k++)
		{
			if(val.charAt(k) == '*' && val.charAt(k + 1) == '*')
			{
				Ext.Msg.show ({
					title: pageName,
					msg: checkStarMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
				return false;
			}
			else
			{
				continue;
			}
		}
	}
	return true;
}









