﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$rptNMea=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$rptNMea[0].Trim()
$rptNam=$rptNMea[1].Trim()
$lastRptConfId=$TestInputs[3]
$prxyDtls=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyDtls[0].Trim()
$proxyPass=Eg-O365Dcr -EncStr $prxyDtls[1]
$proxyserverip=$prxyDtls[2].Trim()
$debuglog=$TestInputs[5].Trim()
#>


##### LOG-Start ###########
$logDir=$egurkhaPath+'\agent\MTM\'+$rptNam+'\logs'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$LogFile = $logDir+"\MTMStreamBase.log"
$LogFile1 = $logDir+"\MTMStreamBase1.log"
$strmBasDebug=$false

Function Write-Log {
	Param ([string]$string)
		if($strmBasDebug){
		[string]$date = Get-Date -Format G
		( "[" + $date + "] -  [O365]  -  " + $string ) | Out-File -FilePath $LogFile -Append
		if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
			if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
				Remove-Item $LogFile1 
			} 
			Rename-Item $LogFile $LogFile1   
		}
	}
}
##### LOG - End ##########

##### MTMCallQlityReport Deletion - start ##########
<#
if($debuglog -eq 'true'){
    $logDelDir=$egurkhaPath+'\agent\MTM\logs'
    $logDelFiles=Get-ChildItem -Path $logDelDir
    if($logDelFiles.Count -gt 0){
        foreach($logDelFile in $logDelFiles){
            $logDel=$logDelDir+'\'+$logDelFile
            Remove-Item -Path $logDel
        }
    }
}
#>
##### MTMCallQlityReport Deletion - End ##########

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($lastRptConfId -ne 'none'){
    $confDatArr=($lastRptConfId -Split '~!~')
    $chklastRptConfId=($confDatArr[0]).ToString()
    $lstDat=[DateTime]($confDatArr[1]).ToString()
}
if($lstDat -ne $null -and $lstDat -ne ''){
    $currDat=(Get-Date)
    Write-Log("confId and curr date -->> $lstDat -- $currDat")
    if($lstDat.Date -eq $currDat.Date){
        $dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
    }
    else{
        $dat1=(Get-Date).AddMinutes(-($mPeriodInMin+1440)).ToUniversalTime()
    }
}else{
    $dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
}
#$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2
Write-Log("start and end date -->> $startDat -- $endDat")

if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$allStmsPath=$dir+'\AllStrmsBase'+ $timenow +".csv"

$measures='Measures.Audio Stream Count','Measures.Audio Good Stream Count','Measures.Audio Poor Stream Count','Measures.Audio Unclassified Stream Count','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count','Measures.Video Stream Count','Measures.Video Poor Due To VideoPostFecplr Count','Measures.Video Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.Video Poor Due To VideoFrameRateAvg Count','Measures.Video Poor Stream Count','Measures.Video Good Stream Count','Measures.Video Unclassified Stream Count','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Recv Frame Rate Average','Measures.Avg Video Low Frame Rate Call Percent','Measures.Avg Video Packet Loss Rate','Measures.Avg Video Frame Rate','Measures.Avg Video Dynamic Capability Percent','Measures.VBSS Stream Count','Measures.VBSS Good Stream Count','Measures.VBSS Poor Stream Count','Measures.VBSS Unclassified Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count','Measures.Total Stream Count','Measures.Total CDR Available Stream Count','Measures.Total Media Failed Stream Count','Measures.Total Call Setup Failed Stream Count','Measures.Total Call Dropped Stream Count','Measures.Total Media Succeeded Stream Count','Measures.Total Call Setup Succeeded Stream Count','Measures.Total Call Setup Failure Percentage','Measures.Total Call Dropped Failure Percentage','Measures.Total Answer Seizure Ratio','Measures.Total Short Call Percentage','Measures.Total Media Failure Percentage','Measures.Avg Call Duration','Measures.Media Failed Due To Firewall DPI Stream Count','Measures.Firewall DPI Media Failure Percentage','Measures.Media Failed Due To Firewall IP Blocked Stream Count','Measures.Firewall IP Blocked Media Failure Percentage','Measures.Media Failed Due To Other Stream Count','Measures.Other Media Failure Percentage','Measures.First Feedback Rating Avg','Measures.Second Feedback Rating Avg','Measures.First Feedback Rating Count','Measures.Second Feedback Rating Count','Measures.First Feedback Rating Poor Count','Measures.Second Feedback Rating Poor Count','Measures.First Feedback Rating Poor Percentage','Measures.Second Feedback Rating Poor Percentage','Measures.First Feedback Token Audio Issue Count','Measures.Second Feedback Token Audio Issue Count','Measures.First Feedback Token Video Issue Count','Measures.Second Feedback Token Video Issue Count','Measures.Avg Audio Degradation','Measures.Avg Jitter','Measures.Avg Jitter Max','Measures.Avg Packet Loss Rate','Measures.Avg Packet Loss Rate Max','Measures.Avg Send Listen MOS','Measures.Avg Overall Avg Network MOS','Measures.Avg Ratio Concealed Samples','Measures.Avg Ratio Stretched Samples','Measures.Avg Round Trip','Measures.Avg Round Trip Max'
$Dimentions='AllStreams.Is Teams','AllStreams.Poor','AllStreams.Unclassified','AllStreams.Date','AllStreams.Hour','AllStreams.Start Time','AllStreams.End Time','AllStreams.First UPN','AllStreams.Second UPN','AllStreams.Organizer UPN','AllStreams.Duration (Minutes)','AllStreams.Media Type','AllStreams.Poor Reason','AllStreams.Conference Id','AllStreams.First Inside Corp','AllStreams.Second Inside Corp','AllStreams.First Network Connection Detail','AllStreams.Second Network Connection Detail','AllStreams.First VPN','AllStreams.Second VPN','AllStreams.Transport','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.First Reflexive Local IP','AllStreams.Second Reflexive Local IP','AllStreams.First Feedback Rating','AllStreams.Second Feedback Rating','AllStreams.First Capture Dev Name','AllStreams.Second Capture Dev Name','AllStreams.First Render Dev Name','AllStreams.Second Render Dev Name','AllStreams.First User Agent','AllStreams.Second User Agent','AllStreams.First CPU Name','AllStreams.Second CPU Name','AllStreams.First OS','AllStreams.Second OS','AllStreams.First Virtualization Flag','AllStreams.Second Virtualization Flag','AllStreams.First Capture Dev','AllStreams.Second Capture Dev','AllStreams.First Capture Dev Driver','AllStreams.Second Capture Dev Driver','AllStreams.First Render Dev','AllStreams.Second Render Dev','AllStreams.First Render Dev Driver','AllStreams.Second Render Dev Driver','AllStreams.First MAC Address','AllStreams.Second MAC Address','AllStreams.First Client Endpoint Name','AllStreams.Second Client Endpoint Name','AllStreams.First ASN Country','AllStreams.Second ASN Country','AllStreams.First ASN City','AllStreams.Second ASN City','AllStreams.First ASN State','AllStreams.Second ASN State','AllStreams.Region','AllStreams.First Connectivity Ice','AllStreams.Second Connectivity Ice','AllStreams.First Link Speed','AllStreams.Second Link Speed','AllStreams.Bandwidth Est','AllStreams.Inside Corp Pair','AllStreams.First Tenant Id','AllStreams.Second Tenant Id','AllStreams.Is Federated','AllStreams.First Is Caller','AllStreams.Stream Direction','AllStreams.Audio and Video Call','AllStreams.First Domain','AllStreams.Second Domain','AllStreams.Conference Type','AllStreams.First Client App Version','AllStreams.Second Client App Version','AllStreams.Meeting Id','AllStreams.Error Report Sender','AllStreams.Is Media Error','AllStreams.Media Failure Type','AllStreams.Call Setup Failure Reason','AllStreams.Session Type','AllStreams.CDR Response Reason','AllStreams.First Video Duration Seconds','AllStreams.Second Video Duration Seconds','AllStreams.Audio Degradation Avg','AllStreams.Jitter','AllStreams.Packet Loss Rate','AllStreams.Send Listen MOS','AllStreams.Overall Avg Network MOS','AllStreams.Ratio Concealed Samples Avg','AllStreams.Ratio Stretched Samples Avg','AllStreams.Round Trip','AllStreams.Packet Utilization','AllStreams.Jitter Buffer Size Avg','AllStreams.Relative OneWay Gap Duration','AllStreams.Audio Post FECPLR','AllStreams.Network Jitter Avg','AllStreams.Video Post FECPLR','AllStreams.Video Local Frame Loss Percentage Avg','AllStreams.Recv Frame Rate Average','AllStreams.Low Frame Rate Call Percent','AllStreams.Video Packet Loss Rate','AllStreams.Video Frame Rate Avg','AllStreams.Dynamic Capability Percent','AllStreams.Spoiled Tile Percent Total','AllStreams.First Network Bandwidth Low Event Ratio','AllStreams.Second Network Bandwidth Low Event Ratio','AllStreams.Video Poor Due to Freeze','AllStreams.Video Poor Due To VideoPostFecplr','AllStreams.Video Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.Video Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.First Feedback Tokens','AllStreams.Second Feedback Tokens','AllStreams.First Feedback Has Audio Issue','AllStreams.Second Feedback Has Audio Issue','AllStreams.First Feedback Has Video Issue','AllStreams.Second Feedback Has Video Issue','AllStreams.First Feedback Has AppSharing Issue','AllStreams.Second Feedback Has AppSharing Issue','AllStreams.First Feedback Text','AllStreams.Second Feedback Text'
Try{
    Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 -debugLog $debuglog | Export-Csv $allStmsPath -Encoding $encTyp #-Descending -debugLog $debuglog
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
    Write-Log($ExcepMsg)
    [System.GC]::GetTotalMemory($true) | out-null
    Start-Sleep -Seconds 20

    Try{
        Write-Host 'Second try....'
        Write-Log('Second try....')
        Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 -debugLog $debuglog | Export-Csv $allStmsPath -Encoding $encTyp #-Descending -debugLog $debuglog
    }Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host 'After catching exception -->> '$ExcepMsg
        Write-Log ("After catching exception -->> $ExcepMsg")
    }
}
[System.GC]::GetTotalMemory($true) | out-null

if($allStmsPath -ne $null -and [System.IO.File]::Exists($allStmsPath) -eq 'True'){
	$allStrms= import-csv $allStmsPath -Encoding $encTyp
    $csvCnt='allStrms Count -- '+($allStrms.Count).ToString()
    Write-Log($csvCnt)
    if(Test-Path -Path $allStmsPath -PathType Leaf){
        Remove-Item $allStmsPath -Force
    }
}else{
    Write-Log($allStmsPath+" -- file is empty or null")
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$mdifyStmsPath=$dir+'\MdifyStrmsBase'+ $timenow +".csv"
Write-Log($mdifyStmsPath+" -- mdifyStmsPath")
foreach($strms in $allStrms){
    $strmsHash =[ordered] @{}
    $isOccur=$false;$isFirst=$true
    foreach( $property in $strms.psobject.properties.name)
    {
        if($property -eq 'First CPU Name'){$isOccur=$true}
        #if($property -eq 'Audio Poor Stream Count'){$isOccur=$false}
        if($property -eq 'Audio Stream Count'){$isOccur=$false}
        if($isOccur -and $isFirst){
            $isFirst=$false
            $sysDtls=$strms.'First CPU Name'+'~#~'+$strms.'Second CPU Name'+'~#~'+$strms.'First OS'+'~#~'+$strms.'Second OS'+'~#~'+$strms.'First Virtualization Flag'+'~#~'+$strms.'Second Virtualization Flag'+'~#~'+$strms.'First Capture Dev'+'~#~'+$strms.'Second Capture Dev'+'~#~'+$strms.'First Capture Dev Driver'+'~#~'+$strms.'Second Capture Dev Driver'+'~#~'+$strms.'First Render Dev'+'~#~'+$strms.'Second Render Dev'+'~#~'+$strms.'First Render Dev Driver'+'~#~'+$strms.'Second Render Dev Driver'+'~#~'+$strms.'First MAC Address'+'~#~'+$strms.'Second MAC Address'+'~#~'+$strms.'First Client Endpoint Name'+'~#~'+$strms.'Second Client Endpoint Name'
            $netWrkDtls=$strms.'First ASN Country'+'~#~'+$strms.'Second ASN Country'+'~#~'+$strms.'First ASN City'+'~#~'+$strms.'Second ASN City'+'~#~'+$strms.'First ASN State'+'~#~'+$strms.'Second ASN State'+'~#~'+$strms.'Region'+'~#~'+$strms.'First Connectivity Ice'+'~#~'+$strms.'Second Connectivity Ice'+'~#~'+$strms.'First Link Speed'+'~#~'+$strms.'Second Link Speed'+'~#~'+$strms.'Bandwidth Est'+'~#~'+$strms.'Inside Corp Pair'
            $callDtls=$strms.'First Tenant Id'+'~#~'+$strms.'Second Tenant Id'+'~#~'+$strms.'Is Federated'+'~#~'+$strms.'First Is Caller'+'~#~'+$strms.'Stream Direction'+'~#~'+$strms.'Audio and Video Call'+'~#~'+$strms.'First Domain'+'~#~'+$strms.'Second Domain'+'~#~'+$strms.'Conference Type'+'~#~'+$strms.'First Client App Version'+'~#~'+$strms.'Second Client App Version'+'~#~'+$strms.'Meeting Id'+'~#~'+$strms.'Error Report Sender'+'~#~'+$strms.'Is Media Error'+'~#~'+$strms.'Media Failure Type'+'~#~'+$strms.'Call Setup Failure Reason'+'~#~'+$strms.'Session Type'+'~#~'+$strms.'CDR Response Reason'+'~#~'+$strms.'First Video Duration Seconds'+'~#~'+$strms.'Second Video Duration Seconds'
            $metricsDtls=$strms.'Audio Degradation Avg'+'~#~'+$strms.'Jitter'+'~#~'+$strms.'Packet Loss Rate'+'~#~'+$strms.'Send Listen MOS'+'~#~'+$strms.'Overall Avg Network MOS'+'~#~'+$strms.'Ratio Concealed Samples Avg'+'~#~'+$strms.'Ratio Stretched Samples Avg'+'~#~'+$strms.'Round Trip'+'~#~'+$strms.'Packet Utilization'+'~#~'+$strms.'Jitter Buffer Size Avg'+'~#~'+$strms.'Relative OneWay Gap Duration'+'~#~'+$strms.'Audio Post FECPLR'+'~#~'+$strms.'Network Jitter Avg'+'~#~'+$strms.'Video Post FECPLR'+'~#~'+$strms.'Video Local Frame Loss Percentage Avg'+'~#~'+$strms.'Recv Frame Rate Average'+'~#~'+$strms.'Low Frame Rate Call Percent'+'~#~'+$strms.'Video Packet Loss Rate'+'~#~'+$strms.'Video Frame Rate Avg'+'~#~'+$strms.'Dynamic Capability Percent'+'~#~'+$strms.'Spoiled Tile Percent Total'+'~#~'+$strms.'First Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Second Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Video Poor Due to Freeze'+'~#~'+$strms.'Video Poor Due To VideoPostFecplr'+'~#~'+$strms.'Video Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'Video Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'VBSS Poor Due To VideoPostFecplr'+'~#~'+$strms.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'VBSS Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'AppSharing Poor Due To SpoiledTilePercentTotal'+'~#~'+$strms.'AppSharing Poor Due To RelativeOneWayAverage'+'~#~'+$strms.'AppSharing Poor Due To RDPTileProcessingLatencyAverage'+'~#~'+$strms.'Audio Poor Due To Jitter'+'~#~'+$strms.'Audio Poor Due To RoundTrip'+'~#~'+$strms.'Audio Poor Due To PacketLoss'+'~#~'+$strms.'Audio Poor Due To Degradation'+'~#~'+$strms.'Audio Poor Due To ConcealedRatio'
            $feedBackDtls=$strms.'First Feedback Tokens'+'~#~'+$strms.'Second Feedback Tokens'+'~#~'+$strms.'First Feedback Has Audio Issue'+'~#~'+$strms.'Second Feedback Has Audio Issue'+'~#~'+$strms.'First Feedback Has Video Issue'+'~#~'+$strms.'Second Feedback Has Video Issue'+'~#~'+$strms.'First Feedback Has AppSharing Issue'+'~#~'+$strms.'Second Feedback Has AppSharing Issue'+'~#~'+$strms.'First Feedback Text'+'~#~'+$strms.'Second Feedback Text'
            
            $strmsHash.Add('Video Frame Rate Avg',$strms.'Video Frame Rate Avg')
            $strmsHash.Add('First Transport Protocol',$strms.'First Transport Protocol')
            $strmsHash.Add('Second Transport Protocol',$strms.'Second Transport Protocol')
            $strmsHash.Add('Session Type',$strms.'Session Type')
            $strmsHash.Add('Stream Direction',$strms.'Stream Direction')
            $strmsHash.Add('Jitter',$strms.'Jitter')
            $strmsHash.Add('Packet Loss Rate',$strms.'Packet Loss Rate')
            $strmsHash.Add('Round Trip',$strms.'Round Trip')

            $strmsHash.Add('System Details',$sysDtls)
            $strmsHash.Add('Network Details',$netWrkDtls)
            $strmsHash.Add('Call Details',$callDtls)
            $strmsHash.Add('Metrics Details',$metricsDtls)
            $strmsHash.Add('Feedback Details',$feedBackDtls)

        }
        if(!$isOccur){
            $strmsHash.Add($property,$strms.$property)
        } 
    }
    [pscustomobject]$strmsHash | Export-Csv $mdifyStmsPath -Encoding $encTyp -Append 
}

if($mdifyStmsPath -ne $null -and [System.IO.File]::Exists($mdifyStmsPath) -eq 'True'){
	$allStrmsCSV= import-csv $mdifyStmsPath -Encoding $encTyp | Sort-Object -Property 'End Time'
    if(Test-Path -Path $mdifyStmsPath -PathType Leaf){
        Remove-Item $mdifyStmsPath -Force
    }
}
Write-Log("allStrmsCSV cnt -->> "+$allStrmsCSV.Count)
if($allStrmsCSV.Count -gt 0){
    $writPath=$dir+'\MTMStrmsBase'+ $timenow +".csv"
    $iswrite=$false
    $obj=$allStrmsCSV| select -Last 1
    #$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
    $rptLastConfID=([String]$obj.'Conference Id').Trim()+"~!~"+([String]$obj.'Date').Trim()

    if($lastRptConfId -ne 'none'){
        $isChkTim=$true
        foreach($strms in $allStrmsCSV){
            $chkConfIdNam=([String]$strms.'Conference Id').Trim()
            if($iswrite){ 
                if($chklastRptConfId -ne $chkConfIdNam){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append
                }
            }
            if($isChkTim){
                if($chklastRptConfId -eq $chkConfIdNam){
                    Write-Log("initial - entering conf id -->> $chklastRptConfId")
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $allStrmsCSV){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            Write-Log("compare time -->> $cmprTime")
            Write-Log("dat1 time -->> $dat1")
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }

    $confIdStr='LastConferenceID#'+$rptLastConfID
    Write-Log("last - entering conf id -->> $rptLastConfID")
    Write-Host $confIdStr
    Write-Host 'LastReporting WritePath#'$writPath

    #<#
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAD  -AzureEnvironmentName $azureEnvArr[0] -Credential $credential |select *
    $iniDomainDtls=Get-AzureADDomain | select *
    Write-Host 'TenantDomains#'$iniDomainDtls.Name
    Disconnect-AzureAD
    #>

}

[System.GC]::GetTotalMemory($true) | out-null





# SIG # Begin signature block
# MIIlcAYJKoZIhvcNAQcCoIIlYTCCJV0CAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCBNJSG3Ze62ryUz
# mcTSNB+91MN1tXi63BtblV/VA6IAvqCCHnIwggUwMIIEGKADAgECAhAECRgbX9W7
# ZnVTQ7VvlVAIMA0GCSqGSIb3DQEBCwUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNV
# BAMTG0RpZ2lDZXJ0IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0xMzEwMjIxMjAwMDBa
# Fw0yODEwMjIxMjAwMDBaMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3
# DQEBAQUAA4IBDwAwggEKAoIBAQD407Mcfw4Rr2d3B9MLMUkZz9D7RZmxOttE9X/l
# qJ3bMtdx6nadBS63j/qSQ8Cl+YnUNxnXtqrwnIal2CWsDnkoOn7p0WfTxvspJ8fT
# eyOU5JEjlpB3gvmhhCNmElQzUHSxKCa7JGnCwlLyFGeKiUXULaGj6YgsIJWuHEqH
# CN8M9eJNYBi+qsSyrnAxZjNxPqxwoqvOf+l8y5Kh5TsxHM/q8grkV7tKtel05iv+
# bMt+dDk2DZDv5LVOpKnqagqrhPOsZ061xPeM0SAlI+sIZD5SlsHyDxL0xY4PwaLo
# LFH3c7y9hbFig3NBggfkOItqcyDQD2RzPJ6fpjOp/RnfJZPRAgMBAAGjggHNMIIB
# yTASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
# BggrBgEFBQcDAzB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
# Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHow
# eDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBPBgNVHSAESDBGMDgGCmCGSAGG/WwA
# AgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAK
# BghghkgBhv1sAzAdBgNVHQ4EFgQUWsS5eyoKo6XqcQPAYPkt9mV1DlgwHwYDVR0j
# BBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQELBQADggEBAD7s
# DVoks/Mi0RXILHwlKXaoHV0cLToaxO8wYdd+C2D9wz0PxK+L/e8q3yBVN7Dh9tGS
# dQ9RtG6ljlriXiSBThCk7j9xjmMOE0ut119EefM2FAaK95xGTlz/kLEbBw6RFfu6
# r7VRwo0kriTGxycqoSkoGjpxKAI8LpGjwCUR4pwUR6F6aGivm6dcIFzZcbEMj7uo
# +MUSaJ/PQMtARKUT8OZkDCUIQjKyNookAv4vcn4c10lFluhZHen6dGRrsutmQ9qz
# sIzV6Q3d9gEgzpkxYz0IGhizgZtPxpMQBvwHgfqL2vmCSfdibqFT+hKUGIUukpHq
# aGxEMrJmoecYpJpkUe8wggWNMIIEdaADAgECAhAOmxiO+dAt5+/bUOIIQBhaMA0G
# CSqGSIb3DQEBDAUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJ
# bmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNVBAMTG0RpZ2lDZXJ0
# IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0yMjA4MDEwMDAwMDBaFw0zMTExMDkyMzU5
# NTlaMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
# BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQg
# Um9vdCBHNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAL/mkHNo3rvk
# XUo8MCIwaTPswqclLskhPfKK2FnC4SmnPVirdprNrnsbhA3EMB/zG6Q4FutWxpdt
# HauyefLKEdLkX9YFPFIPUh/GnhWlfr6fqVcWWVVyr2iTcMKyunWZanMylNEQRBAu
# 34LzB4TmdDttceItDBvuINXJIB1jKS3O7F5OyJP4IWGbNOsFxl7sWxq868nPzaw0
# QF+xembud8hIqGZXV59UWI4MK7dPpzDZVu7Ke13jrclPXuU15zHL2pNe3I6PgNq2
# kZhAkHnDeMe2scS1ahg4AxCN2NQ3pC4FfYj1gj4QkXCrVYJBMtfbBHMqbpEBfCFM
# 1LyuGwN1XXhm2ToxRJozQL8I11pJpMLmqaBn3aQnvKFPObURWBf3JFxGj2T3wWmI
# dph2PVldQnaHiZdpekjw4KISG2aadMreSx7nDmOu5tTvkpI6nj3cAORFJYm2mkQZ
# K37AlLTSYW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWMcCxBYKqxYxhElRp2Yn72
# gLD76GSmM9GJB+G9t+ZDpBi4pncB4Q+UDCEdslQpJYls5Q5SUUd0viastkF13nqs
# X40/ybzTQRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBRa2+xq4aLT8LWRV+dIPyh
# HsXAj6KxfgommfXkaS+YHS312amyHeUbAgMBAAGjggE6MIIBNjAPBgNVHRMBAf8E
# BTADAQH/MB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qYrhwPTzAfBgNVHSMEGDAW
# gBRF66Kv9JLLgjEtUYunpyGd823IDzAOBgNVHQ8BAf8EBAMCAYYweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwRQYDVR0fBD4wPDA6oDigNoY0aHR0cDovL2NybDMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDARBgNVHSAE
# CjAIMAYGBFUdIAAwDQYJKoZIhvcNAQEMBQADggEBAHCgv0NcVec4X6CjdBs9thbX
# 979XB72arKGHLOyFXqkauyL4hxppVCLtpIh3bb0aFPQTSnovLbc47/T/gLn4offy
# ct4kvFIDyE7QKt76LVbP+fT3rDB6mouyXtTP0UNEm0Mh65ZyoUi0mcudT6cGAxN3
# J0TU53/oWajwvy8LpunyNDzs9wPHh6jSTEAZNUZqaVSwuKFWjuyk1T3osdz9HNj0
# d1pcVIxv76FQPfx2CWiEn2/K2yCNNWAcAgPLILCsWKAOQGPFmCLBsln1VWvPJ6ts
# ds5vIy30fnFqI2si/xK4VC0nftg62fC2h5b9W9FcrBjDTZ9ztwGpn1eqXijiuZQw
# ggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUxMA0GCSqGSIb3DQEBCwUAMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAwMDAwWhcNMjQwNTI5MjM1OTU5
# WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEPMA0GA1UEBxMG
# SXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9ucywgSW5jLjEdMBsGA1UEAxMU
# ZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIK
# AoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDfAZHYpsPdplqB5IT6QbS0qQSx
# Didrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+YS+YrEJuIkVMKkqSZnixrkFl8
# 7uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V4g1eGBDbFnpOMQr6luGqZVe+
# vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPOSFlJl90K0a0S8Tmkt6xdJZ+n
# NR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8n8o1gCRQIvbeueHfz+ZrG1K9
# 16KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAkijRkSxTIMA2nskgiMx4/Ow4x
# jN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rkuy0ZBE1s42OmwIFMSBm7AR+R
# 05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+jx4PzUTlUNCqYmIZYqr+z2OF
# uRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMGlp7fHai/li+NjxmjxEXS1e/J
# LSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUeYAfqTTIUeZZgKhQA1sEHRhH+
# Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uGZeg8IFyjQQIDAQABo4IBxDCC
# AcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFPnI
# RJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggr
# BgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5j
# b20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwSwYDVR0gBEQwQjA2Bglg
# hkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDovL3d3dy5kaWdpY2VydC5jb20v
# Q1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2MCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUHMAKGQmh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1cmVkSURDb2RlU2lnbmluZ0NB
# LmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IBAQCUCOdwU+8srLBP
# /gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/KnELeD4StX3JFXz5ddILA5oon
# e/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5zmRFGm8WxDZdI20ztcvW0sOb
# qn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53w7pWG170nktocFWTeUhkAy0f
# oAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkoxV9ldaXJ8Px1navd6PpDW4A78
# 1u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5SsCr29MlpK8UxK9y2Qmb+jEt
# RxR0QZLfMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipeWzANBgkqhkiG9w0B
# AQsFADBiMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVk
# IFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAwWhcNMzcwMzIyMjM1OTU5WjBjMQswCQYD
# VQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lD
# ZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBMIIC
# IjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUDxPKR
# N6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo+n3znIkLf50fng8zH1ATCyZz
# lm34V6gCff1DtITaEfFzsbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
# LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald68Dd5n12sy+iEZLRS8nZH
# 92GDGd1ftFQLIWhuNyG7QKxfst5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRA
# p8ByxbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWHpo9OdhVVJnCYJn+g
# GkcgQ+NDY4B7dW4nJZCYOjgRs/b2nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU
# 8lKVEStYdEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/8KI8ykLcGEh/
# FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWcZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwj
# jVj33GHek/45wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKowSYI+RQQ
# EgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXiYKNYCQEoAA6EVO7O6V3IXjASvUae
# tdN2udIOa5kM0jO0zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8CAQAw
# HQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshvMB8GA1UdIwQYMBaAFOzX44LS
# cV1kTN8uZz/nupiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
# BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
# Z2ljZXJ0LmNvbTBBBggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0fBDwwOjA4oDagNIYy
# aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
# cmwwIAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEB
# CwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbYIULhsBguEE0TzzBTzr8Y+8dQXeJLKftw
# ig2qKWn8acHPHQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwIgqgWvalW
# zxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XNQ1/tYLaqT5Fmniye4Iqs5f2MvGQm
# h2ySvZ180HAKfO+ovHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSumScb
# qyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7pp1yr8THwcFqcdnGE4AJxLaf
# zYeHJLtPo0m5d2aR8XKc6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
# Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6umAU+9Pzt4rUyt+8SVe+0K
# XzM5h0F4ejjpnOHdI/0dKNPH+ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm
# 8heZWcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVBtzrVFZgxtGIJDwq9
# gdkT/r+k0fNX2bwE+oLeMt8EifAAzV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8a
# pIUP/JiW9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8/DCCBsAwggSo
# oAMCAQICEAxNaXJLlPo8Kko9KQeAPVowDQYJKoZIhvcNAQELBQAwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0y
# MjA5MjEwMDAwMDBaFw0zMzExMjEyMzU5NTlaMEYxCzAJBgNVBAYTAlVTMREwDwYD
# VQQKEwhEaWdpQ2VydDEkMCIGA1UEAxMbRGlnaUNlcnQgVGltZXN0YW1wIDIwMjIg
# LSAyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAz+ylJjrGqfJru43B
# DZrboegUhXQzGias0BxVHh42bbySVQxh9J0Jdz0Vlggva2Sk/QaDFteRkjgcMQKW
# +3KxlzpVrzPsYYrppijbkGNcvYlT4DotjIdCriak5Lt4eLl6FuFWxsC6ZFO7Khbn
# UEi7iGkMiMbxvuAvfTuxylONQIMe58tySSgeTIAehVbnhe3yYbyqOgd99qtu5Wbd
# 4lz1L+2N1E2VhGjjgMtqedHSEJFGKes+JvK0jM1MuWbIu6pQOA3ljJRdGVq/9XtA
# bm8WqJqclUeGhXk+DF5mjBoKJL6cqtKctvdPbnjEKD+jHA9QBje6CNk1prUe2nhY
# HTno+EyREJZ+TeHdwq2lfvgtGx/sK0YYoxn2Off1wU9xLokDEaJLu5i/+k/kezbv
# BkTkVf826uV8MefzwlLE5hZ7Wn6lJXPbwGqZIS1j5Vn1TS+QHye30qsU5Thmh1EI
# a/tTQznQZPpWz+D0CuYUbWR4u5j9lMNzIfMvwi4g14Gs0/EH1OG92V1LbjGUKYvm
# QaRllMBY5eUuKZCmt2Fk+tkgbBhRYLqmgQ8JJVPxvzvpqwcOagc5YhnJ1oV/E9mN
# ec9ixezhe7nMZxMHmsF47caIyLBuMnnHC1mDjcbu9Sx8e47LZInxscS451NeX1XS
# fRkpWQNO+l3qRXMchH7XzuLUOncCAwEAAaOCAYswggGHMA4GA1UdDwEB/wQEAwIH
# gDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1UdIAQZ
# MBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNVHSMEGDAWgBS6FtltTYUvcyl2
# mi91jGogj57IbzAdBgNVHQ4EFgQUYore0GH8jzEU7ZcLzT0qlBTfUpwwWgYDVR0f
# BFMwUTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1
# c3RlZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUH
# AQEEgYMwgYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBY
# BggrBgEFBQcwAoZMaHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
# VHJ1c3RlZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNydDANBgkqhkiG
# 9w0BAQsFAAOCAgEAVaoqGvNG83hXNzD8deNP1oUj8fz5lTmbJeb3coqYw3fUZPwV
# +zbCSVEseIhjVQlGOQD8adTKmyn7oz/AyQCbEx2wmIncePLNfIXNU52vYuJhZqMU
# KkWHSphCK1D8G7WeCDAJ+uQt1wmJefkJ5ojOfRu4aqKbwVNgCeijuJ3XrR8cuOyY
# QfD2DoD75P/fnRCn6wC6X0qPGjpStOq/CUkVNTZZmg9U0rIbf35eCa12VIp0bcrS
# BWcrduv/mLImlTgZiEQU5QpZomvnIj5EIdI/HMCb7XxIstiSDJFPPGaUr10CU+ue
# 4p7k0x+GAWScAMLpWnR1DT3heYi/HAGXyRkjgNc2Wl+WFrFjDMZGQDvOXTXUWT5D
# mhiuw8nLw/ubE19qtcfg8wXDWd8nYiveQclTuf80EGf2JjKYe/5cQpSBlIKdrAqL
# xksVStOYkEVgM4DgI974A6T2RUflzrgDQkfoQTZxd639ouiXdE4u2h4djFrIHprV
# wvDGIqhPm73YHJpRxC+a9l+nJ5e6li6FV8Bg53hWf2rvwpWaSxECyIKcyRoFfLpx
# tU56mWz06J7UWpjIn7+NuxhcQ/XQKujiYu54BNu90ftbCqhwfvCXhHjjCANdRyxj
# qCU4lwHSPzra5eX25pvcfizM/xdMTQCi2NYBDriL7ubgclWJLCcZYfZ3AYwxggZU
# MIIGUAIBATCBhjByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
# MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBT
# SEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBAhAImnSeuC3D7CfqZerb+DUx
# MA0GCWCGSAFlAwQCAQUAoHwwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkD
# MQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJ
# KoZIhvcNAQkEMSIEIB/h0uuOWOTsalL/juQXhJ1Pz/WknicMNJurYwyc0tURMA0G
# CSqGSIb3DQEBAQUABIICAHqvX2CXXFbMxv+h0Ntwh+U/5tTnL9qz0cXYLAjSHYvS
# MuNNQmxGNcjhciLq4A5/HNHONvZb4m3reUPsw0vo6F3rf32IsTok6IqvrLGMjYEO
# JDBtwM0Zq9VtO/cghP7ovbPxBVYDOIILnqypR4wYEjLQfe7279KJ3ycibJBaX6Iw
# Hha24ZPW8/X7UvgrAzfVcAD434aTDBeUonrAJ4MS2Dum2mX2LbHE88U6rDRM0kRs
# 1RhwmlU/Vg+u2lqyaXo4CSSQqujVpVqhFKlKtgKO+lI5ky7/XSPUjU4wvSa2bAYM
# UjMjtlMDCr5DqeiGydJSubGJRcco1QUCqm1gSY7ECP8HfySgLt2+FEO16zTiQKVr
# cDbB341UN1VMmkbT+K9BGr6g+5EiJ/u8NqvT6z4Hg9cqWbqUc0BLQIhcWS5albkE
# fLwL6cMCX3R5sgUGpwe3HCSBmr9gfVv+VARNAVn7spZKXcsCPHsKD8pov/85xvMl
# aXyb4Y7wjQr4c0xzm65IMLbIo8TinxflqI2niId1Y9NG1u/MlzPrf2F8F5Z8ZbGH
# YhwTJJ7SoMkseZ+ZEn8EEHg2o44O87Tr8topfVsOfi1nZ/KmDwjUJEgnFpPQ6Lpv
# ekHQCiisxa5M7CebUXmUeAo8O48uiL6V2XfReiUv7BLId84FJnvMOrZS0tJLZtTW
# oYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UEBhMCVVMx
# FzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVz
# dGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQDE1pckuU+jwq
# Sj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0B
# BwEwHAYJKoZIhvcNAQkFMQ8XDTIzMDgwMzA3MTYwMFowLwYJKoZIhvcNAQkEMSIE
# IGg+S2Z5Ll986eQ3nsOG4xAeIVvJlAaUrNHJVSi0qLGIMA0GCSqGSIb3DQEBAQUA
# BIICAGdtODIw8+0/L/zaJRiZa0M3uTTRoKJ1sSLw25bgBm92uofDau0XMKY0RyVh
# Dj9zLPhKnPeqF7tPKwQk2nn8rvvELsV8PfO6d6H/ZbfsZ+cUqUylpbgl1fSSF2x9
# ZKJIzoycrETxixu/ki0rhqGy+sGf0gk0UKmYxsQB4no/vkDvWlAnx4xjHRht95Ha
# CvzkUK1tA+yCn/+WQ+Tl/Ek6or5pBBBLXhtXNR/WrclnyiXx3fo26HdEgfqYwt3S
# H/fTvwUBnFZtnRKXsUfyzNAFj2n9bflMAL8SX/22BW6Ms0nGYtUhgyfhTvAEH1QZ
# fMHqaiHjERodDAsaA+xFTuA/FiKsnX89NnyZDTUf2LZKeqwjAgkBLxkMIT1d/RCC
# 6gtXAAzOS6aDiDvhO1DCsVnsY5um9GpqElhJgyN75YmG7ltpaXwbo74BogmPzQu1
# fl0hqT5RTnPcxRRjqYRHL9bWP1frcbowmjjZIVfsqBIfKn06pEKvez3EYMUx0SWv
# UOYxm4VyEmAcPlec2eelxwczDaoLL3b0K3E7ogHfIheQ3p9wGlNfKspToO2fB7rf
# H2xGkhltlkRptMjMrWWppie5GHdm6dO4Y8syyiUfUNjBZGtWPJKu8paIA2zp6bYr
# oZ7A9blWLRsCbqlKRTtlFWuZdjS/zWaUr9/06VLvuBJgNPY2
# SIG # End signature block
