
const { CpuLoad } = require('bindings')('sysstat');

class CpuStats {
  constructor() {
    this.cpuLoad = new CpuLoad();
  }

  getStats() {
    return {
      threadCpuPct: Number(this.cpuLoad.getThreadCpuLoad().toFixed(2)),
      processCpuPct: Number(this.cpuLoad.getProcessCpuLoad().toFixed(2)),
    };
  }

  reset() {
    this.cpuLoad.reset();
  }

}

module.exports = CpuStats;
