'use strict'

module.exports = Timer
/**
 * Timer class used for find the diff time in nano secs
 * refer process.hrtime
 * https://nodejs.org/api/process.html#process_process_hrtime_time
 */
function Timer() {
  this.ended = false
  this.start = Date.now()
  this._hrtime = process.hrtime()
  this._diff = null
  this.duration = null;
}

Timer.prototype.end = function (duration) {
  if (this.ended) return;
  this.duration = duration;
  this._diff = process.hrtime(this._hrtime);
  this.ended = true
}

Timer.prototype.offset = function (timer) {
  var a = timer._hrtime
  var b = this._hrtime
  var ns = (b[0] - a[0]) * 1e9 + (b[1] - a[1])
  return ns / 1e6
}

Timer.prototype.durationInMs = function (isDecimal, evenIfNotEnded) {
  if (!this.ended && !evenIfNotEnded) return null;
  if (this.duration) return this.duration;
  this._diff = this._diff || process.hrtime(this._hrtime);

  if (isDecimal) {
    return Number((((this._diff[0] * 1e9) + this._diff[1]) / 1e6).toFixed(3));
  } else {
    return parseInt(((this._diff[0] * 1e9) + this._diff[1]) / 1e6);
  }
}

Timer.prototype.runningTime = function () {
  const _diff = process.hrtime(this._hrtime);
  return Number((((_diff[0] * 1e9) + _diff[1]) / 1e6).toFixed(3));
}