'use strict'

const fs = require('fs');
const logger = require('../logger');

const CRIO = "crio";
const AWS_ECS = "ecs";
const DOCKER = "docker";
const POD = "kubepods.slice";
const KUBE_PODS = "kubepods";
const CONTAINERD = "containerd";
const AWS_DOCKER_POD = "kubepods";
const appendMsg = 'Container-Type:';
const CGROUP_FILENAME = "/proc/self/cgroup";

function Docker() { }
Docker.prototype.isDocker = _ => true;
Docker.prototype.isCrio = _ => false;
Docker.prototype.isK8Pod = _ => false;
Docker.prototype.toString = _ => "DOCKER";
Docker.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup | grep -e "cpu" | grep -o  -e "docker-.*.scope" | head -n 1 | sed "s/docker-\\(.*\\).scope/\\\\1/"`;

function Crio() { }
Crio.prototype.isDocker = _ => true;
Crio.prototype.isCrio = _ => true;
Crio.prototype.isK8Pod = _ => false;
Crio.prototype.toString = _ => "CRIO";
Crio.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup | grep -e "cpu" | grep -o  -e "crio-.*.scope" | head -n 1 | sed "s/crio-\\(.*\\).scope/\\\\1/"`;

function CrioK8() { }
CrioK8.prototype.isDocker = _ => true;
CrioK8.prototype.isCrio = _ => true;
CrioK8.prototype.isK8Pod = _ => true;
CrioK8.prototype.toString = _ => "CRIO_K8";
CrioK8.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup | grep -e "cpu" | grep -o  -e "crio-.*.scope" | head -n 1 | sed "s/crio-\\(.*\\).scope/\\\\1/"`;

function DockerK8() { }
DockerK8.prototype.isDocker = _ => true;
DockerK8.prototype.isCrio = _ => false;
DockerK8.prototype.isK8Pod = _ => true;
DockerK8.prototype.toString = _ => "DOCKER_K8";
DockerK8.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup | grep -e "cpu" | grep -o  -e "docker-.*.scope" | head -n 1 | sed "s/docker-\\(.*\\).scope/\\\\1/"`;

function Containerd() { }
Containerd.prototype.isDocker = _ => true;
Containerd.prototype.isCrio = _ => true;
Containerd.prototype.isK8Pod = _ => true;
Containerd.prototype.toString = _ => "CONTAINERD";
Containerd.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup | grep -e "cpu" | awk -F":" '{print $NF}' | head -n 1`;

function AwsEcs() { }
AwsEcs.prototype.isDocker = _ => true;
AwsEcs.prototype.isCrio = _ => false;
AwsEcs.prototype.isK8Pod = _ => true;
AwsEcs.prototype.toString = _ => "AWS_ECS";
AwsEcs.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup  | grep -e "cpu" | awk -F"/" '{print $NF}' | head -n 1`;

function AwsK8() { }
AwsK8.prototype.isDocker = _ => true;
AwsK8.prototype.isCrio = _ => false;
AwsK8.prototype.isK8Pod = _ => true;
AwsK8.prototype.toString = _ => "AWS_K8";
AwsK8.prototype.getCmdForContainerID = _ => `cat /proc/self/cgroup  | grep -e "cpu" | awk -F"/" '{print $NF}' | head -n 1`;

function getContainerType() {
  try {
    let type = null;
    const cgroups = _getCGroup() || [];
    if (!cgroups.length) return;

    cgroups.some(line => {
      if (!line) return false;
      type = _getType(line);
      type && (type.getContainerTypeDecidedLine = _ => line);
      return !!type;
    });

    return type;
  } catch (e) {
    logger.error(appendMsg, '_getContainerType error', e);
  }
}

function _getType(line) {
  if (line.indexOf(DOCKER) > -1) {
    if (line.indexOf(POD) > 1 || line.indexOf(KUBE_PODS) > 1) {
      return new DockerK8();
    }

    const ecsVariable = process.env.ECS_ENABLE_TASK_CPU_MEM_LIMIT;
    if (ecsVariable == false) return new AwsEcs();

    return new Docker();
  }

  if (line.indexOf(CRIO) > -1) {
    if (line.indexOf(POD) > 1 || line.indexOf(KUBE_PODS) > 1) {
      return new CrioK8();
    }
    return new Crio();
  }

  if (line.indexOf(CONTAINERD) > -1) return new Containerd();
  if (line.indexOf(AWS_DOCKER_POD) > -1) return new AwsK8();
  if (line.indexOf(AWS_ECS) > -1) return new AwsEcs();
}

function _getCGroup() {
  try {
    const cgroups = fs.readFileSync(CGROUP_FILENAME, 'utf-8');
    return cgroups ? cgroups.toString().split(/\r?\n/) : [];
  } catch (e) {
    logger.error(appendMsg, 'CGroup error', e);
  }
}

exports.get = getContainerType;