/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.concurrent;

import com.eg.org.apache.commons.lang3.Validate;
import com.eg.org.apache.commons.lang3.concurrent.BackgroundInitializer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableBackgroundInitializer<T>
extends BackgroundInitializer<T> {
    private final Callable<T> callable;

    public CallableBackgroundInitializer(Callable<T> callable) {
        this.checkCallable(callable);
        this.callable = callable;
    }

    public CallableBackgroundInitializer(Callable<T> callable, ExecutorService executorService) {
        super(executorService);
        this.checkCallable(callable);
        this.callable = callable;
    }

    @Override
    protected T initialize() throws Exception {
        return this.callable.call();
    }

    private void checkCallable(Callable<T> callable) {
        Validate.isTrue(callable != null, "Callable must not be null!", new Object[0]);
    }
}

