/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.util;

import com.eg.ch.qos.logback.classic.BasicConfigurator;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.joran.JoranConfigurator;
import com.eg.ch.qos.logback.classic.spi.Configurator;
import com.eg.ch.qos.logback.classic.util.EnvUtil;
import com.eg.ch.qos.logback.core.LogbackException;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.status.ErrorStatus;
import com.eg.ch.qos.logback.core.status.InfoStatus;
import com.eg.ch.qos.logback.core.status.StatusManager;
import com.eg.ch.qos.logback.core.status.WarnStatus;
import com.eg.ch.qos.logback.core.util.Loader;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import com.eg.ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "eg_logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "eg_logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "eg.logback.configurationFile";
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public void configureByResource(URL uRL) throws JoranException {
        if (uRL == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String string = uRL.toString();
        if (!string.endsWith("xml")) {
            throw new LogbackException("Unexpected filename extension of file [" + uRL.toString() + "]. Should be .xml");
        }
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.loggerContext);
        joranConfigurator.doConfigure(uRL);
    }

    void joranConfigureByResource(URL uRL) throws JoranException {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.loggerContext);
        joranConfigurator.doConfigure(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean bl2) {
        String string = OptionHelper.getSystemProperty(CONFIG_FILE_PROPERTY);
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource(string, classLoader);
                if (uRL != null) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
                File file = new File(string);
                if (file.exists() && file.isFile()) {
                    try {
                        URL uRL4 = uRL = file.toURI().toURL();
                        return uRL4;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                if (bl2) {
                    this.statusOnResourceSearch(string, classLoader, uRL);
                }
            }
        }
        return null;
    }

    public URL findURLOfDefaultConfigurationFile(boolean bl2) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
        URL uRL = this.findConfigFileURLFromSystemProperties(classLoader, bl2);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(TEST_AUTOCONFIG_FILE, classLoader, bl2);
        if (uRL != null) {
            return uRL;
        }
        return this.getResource(AUTOCONFIG_FILE, classLoader, bl2);
    }

    private URL getResource(String string, ClassLoader classLoader, boolean bl2) {
        URL uRL = Loader.getResource(string, classLoader);
        if (bl2) {
            this.statusOnResourceSearch(string, classLoader, uRL);
        }
        return uRL;
    }

    public void autoConfig() throws JoranException {
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        URL uRL = this.findURLOfDefaultConfigurationFile(true);
        if (uRL != null) {
            this.configureByResource(uRL);
        } else {
            Configurator configurator = EnvUtil.loadFromServiceLoader(Configurator.class);
            if (configurator != null) {
                try {
                    configurator.setContext(this.loggerContext);
                    configurator.configure(this.loggerContext);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = configurator != null ? configurator.getClass().getCanonicalName() : "null";
                    throw new LogbackException(String.format("Failed to initialize Configurator: %s using ServiceLoader", objectArray), exception);
                }
            } else {
                BasicConfigurator basicConfigurator = new BasicConfigurator();
                basicConfigurator.setContext(this.loggerContext);
                basicConfigurator.configure(this.loggerContext);
            }
        }
    }

    private void statusOnResourceSearch(String string, ClassLoader classLoader, URL uRL) {
        StatusManager statusManager = this.loggerContext.getStatusManager();
        if (uRL == null) {
            statusManager.add(new InfoStatus("Could NOT find resource [" + string + "]", this.loggerContext));
        } else {
            statusManager.add(new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", this.loggerContext));
            this.multiplicityWarning(string, classLoader);
        }
    }

    private void multiplicityWarning(String string, ClassLoader classLoader) {
        Set<URL> set = null;
        StatusManager statusManager = this.loggerContext.getStatusManager();
        try {
            set = Loader.getResources(string, classLoader);
        }
        catch (IOException iOException) {
            statusManager.add(new ErrorStatus("Failed to get url list for resource [" + string + "]", this.loggerContext, iOException));
        }
        if (set != null && set.size() > 1) {
            statusManager.add(new WarnStatus("Resource [" + string + "] occurs multiple times on the classpath.", this.loggerContext));
            for (URL uRL : set) {
                statusManager.add(new WarnStatus("Resource [" + string + "] occurs at [" + uRL.toString() + "]", this.loggerContext));
            }
        }
    }
}

