/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.egurkha.util.MultipartWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;

public class MultipartFilter
implements Filter {
    private FilterConfig config = null;
    private String dir = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.dir = filterConfig.getInitParameter("uploadDir");
        if (this.dir == null) {
            File file = (File)filterConfig.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
            if (file != null) {
                this.dir = file.toString();
            } else {
                throw new ServletException("MultipartFilter: No upload directory found: set an uploadDir init parameter or ensure the jakarta.servlet.context.tempdir directory is valid");
            }
        }
    }

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = httpServletRequest.getHeader("Content-Type");
        if (string == null || !string.startsWith("multipart/form-data")) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            MultipartWrapper multipartWrapper = new MultipartWrapper(httpServletRequest, this.dir);
            filterChain.doFilter((ServletRequest)multipartWrapper, servletResponse);
        }
    }
}

