/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class FileMonLogFileReader {
    private int buf_pos = 0;
    private int buf_end = 0;
    private long oldFileSize = 0L;
    private long newFileSize = 0L;
    private File logFile = null;
    private ArrayList al_buffStr = null;
    public boolean useUTF8 = false;
    private RandomAccessFile raf = null;
    private int line = 0;
    public ArrayList lineIndexList = new ArrayList();
    private int lineIndex = 1;
    private boolean isFileOpen = true;
    private boolean isFirstSet = true;
    boolean bomChk = false;

    public FileMonLogFileReader(String string, long l, String string2) throws FileNotFoundException {
        boolean bl;
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            this.useUTF8 = true;
        }
        if (!this.useUTF8 && (bl = this.checkForBOM(string))) {
            this.useUTF8 = true;
        }
        this.oldFileSize = l;
        this.logFile = new File(string);
        if (!this.logFile.exists()) {
            throw new FileNotFoundException();
        }
        this.newFileSize = this.logFile.length();
    }

    public FileMonLogFileReader(String string, long l) throws FileNotFoundException {
        boolean bl;
        this.useUTF8 = false;
        if (!this.useUTF8 && (bl = this.checkForBOM(string))) {
            this.useUTF8 = true;
        }
        this.oldFileSize = l;
        this.logFile = new File(string);
        if (!this.logFile.exists()) {
            throw new FileNotFoundException();
        }
        this.newFileSize = this.logFile.length();
    }

    public FileMonLogFileReader(File file, long l) throws FileNotFoundException {
        boolean bl = this.checkForBOM(file);
        if (bl) {
            this.useUTF8 = true;
        }
        this.logFile = file;
        this.oldFileSize = l;
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.newFileSize = file.length();
    }

    private void openFile() throws IOException {
        try {
            this.raf = new RandomAccessFile(this.logFile, "r");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void closeFile() throws IOException {
        try {
            this.raf.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ArrayList getPrevLines(int n) throws Exception {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.lineIndex < 1) {
            return arrayList;
        }
        int n3 = 0;
        if (this.lineIndex <= n) {
            this.raf.seek(this.oldFileSize);
        } else {
            n2 = this.lineIndex - n - 2;
            if (n2 < 0) {
                n2 = 0;
            }
            n3 = (Integer)this.lineIndexList.get(n2);
            this.raf.seek(n3);
        }
        String string = null;
        while ((string = this.raf.readLine()) != null) {
            char[] cArray;
            if (this.useUTF8) {
                string = new String(string.getBytes(), "UTF-8");
            }
            if ((cArray = string.toCharArray()).length != 0 && cArray[0] == '\ufeff') {
                string = string.substring(1);
                this.bomChk = true;
            }
            arrayList.add(string);
            n3 = this.bomChk ? n3 + string.length() + 3 : n3 + string.length() + 2;
            this.bomChk = false;
            this.raf.seek(n3);
            if (n3 == this.line) break;
        }
        this.setCurrentLine();
        return arrayList;
    }

    private void setCurrentLine() throws Exception {
        this.raf.seek(this.line);
    }

    public ArrayList getNextLines(int n) throws Exception {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        int n3 = 0;
        if (this.lineIndexList.size() <= 1) {
            this.raf.seek(this.oldFileSize);
        } else {
            if (this.lineIndexList != null) {
                n2 = this.lineIndexList.size() - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            n3 = (Integer)this.lineIndexList.get(n2);
            this.raf.seek(n3);
        }
        try {
            string = this.raf.readLine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
        }
        while (string != null) {
            if (this.useUTF8) {
                string = new String(string.getBytes(), "UTF-8");
            }
            arrayList.add(string);
            n3 = n3 + string.length() + 2;
            this.raf.seek(n3);
            if (--n == 0) break;
        }
        this.setCurrentLine();
        return arrayList;
    }

    private ArrayList fillBuffer() throws IOException {
        ArrayList<String> arrayList = null;
        this.buf_pos = 0;
        this.buf_end = 0;
        if (this.newFileSize <= this.oldFileSize) {
            return null;
        }
        if (this.isFirstSet) {
            if (this.oldFileSize > 0L) {
                this.raf.seek(this.oldFileSize);
            }
            this.buf_end = (int)(this.newFileSize - this.oldFileSize);
            if (this.buf_end <= 0) {
                return null;
            }
            this.lineIndexList.add(new Integer((int)this.oldFileSize));
            this.line = (int)this.oldFileSize;
            this.isFirstSet = false;
        }
        String string = null;
        arrayList = new ArrayList<String>();
        try {
            string = this.raf.readLine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
        }
        while (string != null) {
            arrayList.add(string);
            this.line = this.line + string.length() + 2;
            this.lineIndexList.add(this.lineIndex, new Integer(this.line));
            ++this.lineIndex;
            this.raf.seek(this.line);
            if (arrayList.size() == 1) break;
            try {
                string = this.raf.readLine();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = null;
            }
        }
        if (string == null && this.raf != null) {
            this.closeFile();
        }
        return arrayList;
    }

    public ArrayList readLine() throws IOException {
        if (this.isFileOpen) {
            this.openFile();
            this.isFileOpen = false;
        }
        this.al_buffStr = this.fillBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        int n = this.al_buffStr.size();
        if (this.al_buffStr != null && n > 0) {
            int n2 = 0;
            while (n2 < n) {
                string = (String)this.al_buffStr.get(n2);
                string2 = this.useUTF8 ? new String(string.getBytes(), "UTF-8") : string;
                char[] cArray = string2.toCharArray();
                if (cArray.length != 0 && cArray[0] == '\ufeff') {
                    string2 = string2.substring(1);
                }
                arrayList.add(string2.trim());
                ++n2;
            }
        }
        return arrayList;
    }

    public ArrayList readLineUTF16() throws IOException {
        if (this.isFileOpen) {
            this.openFile();
            this.isFileOpen = false;
        }
        this.al_buffStr = this.fillBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        int n = this.al_buffStr.size();
        if (this.al_buffStr != null && n > 0) {
            int n2 = 0;
            while (n2 < n) {
                string = (String)this.al_buffStr.get(n2);
                string2 = this.useUTF8 ? new String(string.getBytes(), "UTF-16") : string;
                arrayList.add(string2.trim());
                ++n2;
            }
        }
        return arrayList;
    }

    private boolean checkForBOM(String string) {
        try {
            char[] cArray;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            String string2 = bufferedReader.readLine();
            if (string2 != null && (cArray = string2.toCharArray()).length != 0) {
                return cArray[0] == '\ufeff';
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkForBOM(File file) {
        try {
            char[] cArray;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string = bufferedReader.readLine();
            if (string != null && (cArray = string.toCharArray()).length != 0) {
                return cArray[0] == '\ufeff';
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

