'use strict'

const v8 = require('v8');
const logger = require('../logger');
const threads = require('../utils/threads');

const appendMsg = 'Memory:';

class Memory {

  constructor() {
    this.maxHeap = null;
  }

  start() {
    try {
      const heapstat = v8.getHeapStatistics();
      this.maxHeap = heapstat.heap_size_limit;
      logger.info(appendMsg, `monitoring started and maxHeap: ${this.maxHeap / 1048576} MB`);
    } catch (e) {
      logger.error(appendMsg, 'resourceUsage', e);
    }
  }

  /**
 * To calculate  process memory usage
 * @return  {Object}  rss, heaptotal,nonheap,heapused in MBS
 */
  getUsage() {
    try {
      const memory = process.memoryUsage();
      const memoryUsage = {
        heapUsed: memory.heapUsed,
        maxHeap: this.maxHeap,
        freeHeap: this.maxHeap - memory.heapUsed,
      }

      if (threads.isMainThread) {
        memoryUsage.rss = memory.rss;
        memoryUsage.external = memory.external;
        memoryUsage.arrayBuffers = memory.arrayBuffers;
        const spacestat = v8.getHeapSpaceStatistics();
        memoryUsage.heapSpaceDetails = [];

        spacestat.forEach(space => {
          memoryUsage.heapSpaceDetails.push({
            name: space.space_name,
            used: space.space_used_size,
          });
        });
      }

      return memoryUsage;
    } catch (e) {
      logger.error(appendMsg, 'memoryUsage', e);
    }
  }
}

module.exports = Memory;