'use strict'

const Config = require('../default_config');
const logger = require('./../logger');
const appendMsg = 'Queue:';

/**
 * A queue is a simple data structure that allows elements to be inserted from one end, 
 * called the rear (also called tail), and deleted from the other end, called the front
 * @param {number} size 
 */
const Queue = function (config) {
  this.QUEUE_MAX_SIZE = config.max_queue_size || Config.max_queue_size;
  this.bucket = [];
  this.priorityBucket = [];
}

Queue.prototype.isEmpty = function () {
  return this.bucket.length === 0;
}

Queue.prototype.enqueue = function (data) {
  if (data.sendBeforeComponentVerification) {
    delete data.sendBeforeComponentVerification;
    this.priorityBucket.push(data);
    return;
  }

  //Check if queue reached max size then delete old data
  if (this.bucket.length >= this.QUEUE_MAX_SIZE) {
    logger.info(appendMsg, 'Queue is full so going to ignore the first added element.')
    logger.debug(appendMsg, "elemet going to ignore is ", this.bucket[0]);
    this.bucket.shift();
  }

  this.bucket.push(data);
}

Queue.prototype.dequeue = function (data) {
  return this.bucket.shift();
}

Queue.prototype.peek = function () {
  return this.bucket[0];
}

Queue.prototype.size = function () {
  return this.bucket.length;
}

Queue.prototype.getAll = function () {
  return this.bucket;
}

Queue.prototype.reset = function () {
  this.bucket = [];
}

Queue.prototype.get = function (size) {
  return this.bucket.splice(0, size || this.bucket.length);
}

Queue.prototype.getPriorityItems = function () {
  return this.priorityBucket.splice(0, this.priorityBucket.length);
}

module.exports = Queue;