﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Users Mails and Mailboxes Details
    Created           :       15/09/2020    
    /*****************************************************************************
#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$strgLimit=$TestInputs[5]
$toreadDate_UsrsMailbx=[datetime]$TestInputs[6]
$toreadDate_UsrsMailactvty=[datetime]$TestInputs[7]
$toreadDate_UsrsMailAppUsg=[datetime]$TestInputs[8]
$rptNam=$TestInputs[9]
$rchRecvrQuotaLmt=$TestInputs[10]
$graphDetails=$TestInputs[11]
$appDetails=$TestInputs[12]
$debug=$false
try{
    $debug=$TestInputs[13]
}catch{
$debug=$false
}


if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.ToString().ToLower().Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

$allDomains=''
if($rptNam -match '_exd'){
    $dhash=@{}
    $dmnshash=Eg-O635Domains -username $username -password $password -rptNam $rptNam -proxyserverip $proxyserver -proxyUsr $proxyUser -proxyPass $proxyPass -appDetails $appDetails
    $hashVal=[String]$dmnshash[$rptNam]
    $allDomns=$hashVal.Split('~')
    if($allDomns.Count -gt 0){
        $allDomains=$allDomns[0]
    }
}

$rptPath=$egurkhaPath+'\agent\EXO\'+$rptNam+'\usermailsnmailbox'
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

Function DeleteDatFiles(){
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$FilePath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Pattern
    )
    Process
    {
        $FilePath=$FilePath+'\'
        $count=1
        $fileRead=Get-ChildItem -Path $FilePath |Where-Object {$_.Name -like $Pattern+'*.dat' }| Sort-Object LastWriteTime -Descending | Select Name 
        foreach($file in $fileRead){
            if($count -gt 2){
                $fileNameTemp=([String]$file.Name).Trim()
                $keyFileName=$FilePath+'k'+$fileNameTemp
                $fileName=$FilePath+$fileNameTemp
                if([System.IO.File]::Exists($keyFileName) -eq 'True'){
                    Remove-Item $keyFileName -Force
                }
                if([System.IO.File]::Exists($fileName) -eq 'True'){
                    Remove-Item $fileName -Force
                }
            }
            $count++ 
        }
    }
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
if($debug -and $debug -ne 'false'){
    $keyName='\kMailboxUsageDetail'+ $timenow + ".dat"
    $key=Get-CryptoKey -FileDir $rptPath -FileName $keyName
}
$MailboxUsageDetailCSV=$rptPath+'\MailboxUsageDetail'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $MailboxUsageDetailCSV

$url1 = "https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')"
$TotalMailboxUsageDetail=@()
while($true){
    Eg-InvokeGraphUrl -Url $url1 -filePath $MailboxUsageDetailCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    if($rptNam -match '_exd'){
        $csvOut=Import-Csv $MailboxUsageDetailCSV -Encoding $encTyp
        foreach($res in $csvOut){
            $domainUsr=$res.UserPrincipalName
            if($domainUsr -ne $null -and $domainUsr -ne ''){
                $usrDmn=$domainUsr.Split('@')[1]
                if($allDomains -match $usrDmn){
                    $TotalMailboxUsageDetail+=$res
                }
            }
        }   
    }else{
        $TotalMailboxUsageDetail=Import-Csv $MailboxUsageDetailCSV -Encoding $encTyp
    }
    $url1=$TotalMailboxUsageDetail.'@odata.nextLink'
    if($url1 -eq $null -or $url1 -eq ''){
        break
    }
}
$firstRecord1=$TotalMailboxUsageDetail | select ReportRefreshDate -First 1
$ReportRefreshDate1=($firstRecord1.ReportRefreshDate)
$diffence1=(NEW-TIMESPAN –Start $toreadDate_UsrsMailbx –End $ReportRefreshDate1 | Select-Object Days).Days
if($diffence1 -ge 1){$reportRefreshed1=$true}
if($debug -and $debug -ne 'false'){
    $null=Protect-File  $MailboxUsageDetailCSV -Algorithm AES -KeyAsPlainText $key -RemoveSource
}

[System.GC]::GetTotalMemory($true) | out-null
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
if($debug -and $debug -ne 'false'){
    $keyName2='\kUserEmailActivities'+ $timenow + ".dat"
    $key2=Get-CryptoKey -FileDir $rptPath -FileName $keyName2
}
$UserEmailActivitiesCSV=$rptPath+'\UserEmailActivities'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $UserEmailActivitiesCSV

$url2 = "https://graph.microsoft.com/v1.0/reports/getEmailActivityUserDetail(period='D7')"
$UserEmailActivities=@()
while($true){
    Eg-InvokeGraphUrl -Url $url2 -filePath $UserEmailActivitiesCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    if($rptNam -match '_exd'){
        $csvOut=Import-Csv $UserEmailActivitiesCSV -Encoding $encTyp
        foreach($res in $csvOut){
            $domainUsr=$res.UserPrincipalName
            if($domainUsr -ne $null -and $domainUsr -ne ''){
                $usrDmn=$domainUsr.Split('@')[1]
                if($allDomains -match $usrDmn){
                    $UserEmailActivities+=$res
                }
            }
        }   
    }else{
        $UserEmailActivities=Import-Csv $UserEmailActivitiesCSV -Encoding $encTyp
    }
    $url2=$UserEmailActivities.'@odata.nextLink'
    if($url2 -eq $null -or $url2 -eq ''){
        break
    }
}
$firstRecord2=$UserEmailActivities | select ReportRefreshDate -First 1
$ReportRefreshDate2=($firstRecord2.ReportRefreshDate)
$diffence2=(NEW-TIMESPAN –Start $toreadDate_UsrsMailactvty –End $ReportRefreshDate2 | Select-Object Days).Days
if($diffence2 -ge 1){$reportRefreshed2=$true}
if($debug -and $debug -ne 'false'){
    $null=Protect-File  $UserEmailActivitiesCSV -Algorithm AES -KeyAsPlainText $key2 -RemoveSource
}
[System.GC]::GetTotalMemory($true) | out-null
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
if($debug -and $debug -ne 'false'){
    $keyName3='\kMailAppUsage'+ $timenow + ".dat"
    $key3=Get-CryptoKey -FileDir $rptPath -FileName $keyName3
}
$MailAppUsageCSV=$rptPath+'\MailAppUsage'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $MailAppUsageCSV

$url3 = "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageUserDetail(period='D7')"
$TotalMailAppUsage=@()
while($true){
    Eg-InvokeGraphUrl -Url $url3 -filePath $MailAppUsageCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource 
    if($rptNam -match '_exd'){
        $csvOut=Import-Csv $MailAppUsageCSV -Encoding $encTyp
        foreach($res in $csvOut){
            $domainUsr=$res.UserPrincipalName
            if($domainUsr -ne $null -and $domainUsr -ne ''){
                $usrDmn=$domainUsr.Split('@')[1]
                if($allDomains -match $usrDmn){
                    $TotalMailAppUsage+=$res
                }
            }
        }   
    }else{
        $TotalMailAppUsage=Import-Csv $MailAppUsageCSV -Encoding $encTyp
    }
    $url3=$TotalMailAppUsage.'@odata.nextLink'
    if($url3 -eq $null -or $url3 -eq ''){
        break
    }
}
$firstRecord3=$TotalMailAppUsage | select ReportRefreshDate -First 1
$ReportRefreshDate3=($firstRecord3.ReportRefreshDate)
$diffence3=(NEW-TIMESPAN –Start $toreadDate_UsrsMailAppUsg –End $ReportRefreshDate3 | Select-Object Days).Days
if($diffence3 -ge 1){$reportRefreshed3=$true}
if($debug -and $debug -ne 'false'){
    $null=Protect-File  $MailAppUsageCSV -Algorithm AES -KeyAsPlainText $key3 -RemoveSource
}
[System.GC]::GetTotalMemory($true) | out-null
if($reportRefreshed1 -and $reportRefreshed2 -and $reportRefreshed3){
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailbx –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailbx=$toreadDate_UsrsMailbx.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailbx
        $notFirsttime = $true
        $TotalMailboxUsage =$TotalMailboxUsageDetail | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalMailboxUsage)
        {
            Write-Host 'ReadDate of UsersMailbox Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailbox Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
	[System.GC]::GetTotalMemory($true) | out-null
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailactvty –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailactvty=$toreadDate_UsrsMailactvty.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailactvty
        $notFirsttime = $true
        $UserEmailAct =$UserEmailActivities | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($UserEmailAct)
        {
            Write-Host 'ReadDate of UsersMailActivity Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailActivity Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
	[System.GC]::GetTotalMemory($true) | out-null
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailAppUsg –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailAppUsg=$toreadDate_UsrsMailAppUsg.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailAppUsg
        $notFirsttime = $true
        $TotalMailAppUsg =$TotalMailAppUsage | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalMailAppUsg)
        {
            Write-Host 'ReadDate of UsersMailAppUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailAppUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
	[System.GC]::GetTotalMemory($true) | out-null
}
$TotalMailboxUsage = $TotalMailboxUsage | Where-Object { $_.UserPrincipalName -ne '(Unknown)' -and $_.IsDeleted -ne 'True'} 
foreach($User in $TotalMailboxUsage){
    $ItemCount=$User.ItemCount

    if([long]$User.StorageUsed -ge 0){$StorageUsd=[math]::Round(([long]$User.StorageUsed/1073741824),2)}else{$StorageUsd=0}          
    if($User.DeletedItemSize -ge 0){ $DeletedItemSize=[math]::Round(($User.DeletedItemSize/1073741824),2) }else{ $DeletedItemSize=0 }
    if([long]$User.IssueWarningQuota -ge 0){$IssueWarningQuotaD=[math]::Round(([long]$User.IssueWarningQuota/1073741824),2)}else{ $IssueWarningQuotaD=0 }        
    if([long]$User.ProhibitSendQuota -ge 0){$ProhibitSendQuotaD=[math]::Round(([long]$User.ProhibitSendQuota/1073741824),2)}else{$ProhibitSendQuotaD=0}        
    if([long]$User.'ProhibitSend/ReceiveQuota' -ge 0){$ProhibitSendReceiveQuotaD=[math]::Round(([long]$User.'ProhibitSend/ReceiveQuota'/1073741824),2)}else{$ProhibitSendReceiveQuotaD=0}    

    if($StorageUsd -ge 0 -and $IssueWarningQuotaD -gt 0){ $IssueWarningQuotaLimit =($StorageUsd/$IssueWarningQuotaD)*100 }else{$IssueWarningQuotaLimit=0}                                
    if($IssueWarningQuotaLimit -ge $strgLimit){ 
        $ReachingIssueWarningQuotaLimit=1 
    }else{ 
        if($DeletedItemSize -ge 0 -and $IssueWarningQuotaD -gt 0){ $IssueWarningQuotaLimit =($DeletedItemSize/$IssueWarningQuotaD)*100 }else{$IssueWarningQuotaLimit=0}
        
        if($IssueWarningQuotaLimit -ge $strgLimit){ 
            $ReachingIssueWarningQuotaLimit=1 
        }else{
            $ReachingIssueWarningQuotaLimit=0 
        }
    } 
    
    if($StorageUsd -ge 0 -and $ProhibitSendQuotaD -gt 0){ $ProhibitSendQuotaLimit =($StorageUsd/$ProhibitSendQuotaD)*100 }else{$ProhibitSendQuotaLimit=0}  
    if($ProhibitSendQuotaLimit -ge $strgLimit){ 
        $ReachingProhibitSendQuotaLimit=1 
    }else{
        if($DeletedItemSize -ge 0 -and $ProhibitSendQuotaD -gt 0){ $ProhibitSendQuotaLimit =($DeletedItemSize/$ProhibitSendQuotaD)*100 }else{$ProhibitSendQuotaLimit=0}  
        
        if($ProhibitSendQuotaLimit -ge $strgLimit){ 
            $ReachingProhibitSendQuotaLimit=1 
        }else{ 
            $ReachingProhibitSendQuotaLimit=0 
        }
    }   
    
    if($StorageUsd -ge 0 -and $ProhibitSendReceiveQuotaD -gt 0){ $ProhibitSendRecvQuotaLimit =($StorageUsd/$ProhibitSendReceiveQuotaD)*100 }else{$ProhibitSendRecvQuotaLimit=0}
    if($ProhibitSendRecvQuotaLimit -ge $strgLimit){ 
        $ReachingProhibitSendRecvQuotaLimit=1 
    }else{ 
        if($DeletedItemSize -ge 0 -and $ProhibitSendReceiveQuotaD -gt 0){ $ProhibitSendRecvQuotaLimit =($DeletedItemSize/$ProhibitSendReceiveQuotaD)*100 }else{$ProhibitSendRecvQuotaLimit=0}

        if($ProhibitSendRecvQuotaLimit -ge $strgLimit){ 
            $ReachingProhibitSendRecvQuotaLimit=1 
        }else{
            $ReachingProhibitSendRecvQuotaLimit=0 
        }
    }
        
    
    $DeletedItemCount=$User.DeletedItemCount    
    
    $UserID=$User.UserPrincipalName

    $rchedRecvrQuota=''
    $rcvQuotaPercent=[math]::Round((($User.DeletedItemSize/$User.DeletedItemQuota)*100),2)
    if($rcvQuotaPercent -gt $rchRecvrQuotaLmt){
        $rchedRecvrQuota='1'
    }else{
        $rchedRecvrQuota='0'
    }
    
    $Output='MailboxUsage~'+$UserID+'~'+$ItemCount+'~'+$StorageUsd+'~'+$IssueWarningQuotaD+'~'+$ProhibitSendQuotaD+'~'+$ProhibitSendReceiveQuotaD+'~'+$ReachingIssueWarningQuotaLimit+'~'+$ReachingProhibitSendQuotaLimit+'~'+$ReachingProhibitSendRecvQuotaLimit+'~'+$DeletedItemCount+'~'+$DeletedItemSize+'~'+$rchedRecvrQuota
    Write-Host $Output 
}
[System.GC]::GetTotalMemory($true) | out-null
if($debug -and $debug -ne 'false'){
    DeleteDatFiles -FilePath $rptPath -Pattern 'MailboxUsageDetail'
}else{
    if([System.IO.File]::Exists($MailboxUsageDetailCSV) -eq 'True'){
        Remove-Item $MailboxUsageDetailCSV
    }
}

$UserEmailAct = $UserEmailAct | Where-Object { $_.UserPrincipalName -ne '(Unknown)' -and $_.IsDeleted -ne 'True'} 
foreach($User in $UserEmailAct){
        $hasLicenses=0
        $assignedProducts=$User.AssignedProducts
        if($assignedProducts -and $assignedProducts.Trim().Length -gt 0){
            $hasLicenses=1
        }
        $UserPrincipalName=$User.UserPrincipalName
        $SendCount=$User.SendCount
        $ReceiveCount=$User.ReceiveCount
        $ReadCount=$User.ReadCount        
        $Output = 'EmailActivity~'+$UserPrincipalName+'~'+$SendCount+'~'+$ReceiveCount+'~'+$ReadCount+'~'+$hasLicenses
        Write-Host $Output        
}
[System.GC]::GetTotalMemory($true) | out-null
if($debug -and $debug -ne 'false'){
    DeleteDatFiles -FilePath $rptPath -Pattern 'UserEmailActivities'
}else{
    if([System.IO.File]::Exists($UserEmailActivitiesCSV) -eq 'True'){
        Remove-Item $UserEmailActivitiesCSV
    }
}

$TotalMailAppUsg = $TotalMailAppUsg | Where-Object { $_.UserPrincipalName -ne '(Unknown)' -and $_.IsDeleted -ne 'True'} 
foreach($Apps in $TotalMailAppUsg){
    #----------------MailForMac ---------------------
    if($Apps.MailForMac -eq ""){$MailForMac = "0"}elseif($Apps.MailForMac -eq "Undetermined"){$MailForMac = "1"}else{$MailForMac="2"}
    #---------------OutlookForMac---------------------
    if($Apps.OutlookForMac -eq ""){$OutlookForMac = "0"}elseif($Apps.OutlookForMac -eq "Undetermined"){$OutlookForMac = "1"}else{$OutlookForMac="2"}             
    #---------------OutlookForWindows---------------------
    if($Apps.OutlookForWindows -eq ""){$OutlookForWindows = "0"}elseif($Apps.OutlookForWindows -eq "Undetermined"){$OutlookForWindows = "1"}else{$OutlookForWindows="2"}        
    #---------------OutlookForMobile---------------------
    if($Apps.OutlookForMobile -eq ""){$OutlookForMobile = "0"}elseif($Apps.OutlookForMobile -eq "Undetermined"){$OutlookForMobile = "1"}else{$OutlookForMobile="2"}
    #---------------OtherForMobile---------------------
    if($Apps.OtherForMobile -eq ""){$OtherForMobile = "0"}elseif($Apps.OtherForMobile -eq "Undetermined"){$OtherForMobile = "1"}else{$OtherForMobile="2"}        
    #---------------OutlookForWeb---------------------
    if($Apps.OutlookForWeb -eq ""){$OutlookForWeb = "0"}elseif($Apps.OutlookForWeb -eq "Undetermined"){$OutlookForWeb = "1"}else{$OutlookForWeb="2"}
    #---------------POP3App---------------------
    if($Apps.POP3App -eq ""){$POP3App = "0"}elseif($Apps.POP3App -eq "Undetermined"){$POP3App = "1"}else{$POP3App="2"}
    #---------------IMAP4App---------------------
    if($Apps.IMAP4App -eq ""){$IMAP4App = "0"}elseif($Apps.IMAP4App -eq "Undetermined"){$IMAP4App = "1"}else{$IMAP4App="2"}
    #---------------SMTPApp---------------------
    if($Apps.SMTPApp -eq ""){$SMTPApp = "0"}elseif($Apps.SMTPApp -eq "Undetermined"){$SMTPApp = "1"}else{$SMTPApp="2"}

$MailAppUsage='AppUsage~'+$Apps.UserPrincipalName+'~'+$MailForMac+'~'+$OutlookForMac+'~'+$OutlookForWindows+'~'+$OutlookForMobile+'~'+$OtherForMobile+'~'+$OutlookForWeb+'~'+$POP3App+'~'+$IMAP4App+'~'+$SMTPApp
Write-Host $MailAppUsage
}
[System.GC]::GetTotalMemory($true) | out-null
if($debug -and $debug -ne 'false'){
    DeleteDatFiles -FilePath $rptPath -Pattern 'MailAppUsage'
}else{
    if([System.IO.File]::Exists($MailAppUsageCSV) -eq 'True'){
        Remove-Item $MailAppUsageCSV
    }
}
# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUJzb4q/j+Au/L+OglcEyiP3we
# /Deggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFGAyYERlK+8ukeJI
# f7+IjDw05JZVMA0GCSqGSIb3DQEBAQUABIICAGanMS3QmiYLeiERqS7YVP+Xaqeo
# Y5/I4Jzfy5kvqhxHZghB4sAi2ZlxPYE6IY+1WK/S0sf1re2KZ7ZxICMIe/tthEu0
# CZcF6R6I+SjWSbKJH+eMzuJjf/98uhST+VerP+iT3Acf+gpR38LclPjwJ0TbaaO3
# +pq4m69Cbml4VmcAAswr3ix1e5LV/eQbl26QWfJe6eN46Tbkeo59RkMlzCx6AS9F
# ao+3UVDroC1oNeY53YyIozBAfIDLzRF3PVlfnlvZaaxhzW9Sw8lre+haRIfimE49
# xE2xBDPvvMUwZdT/4EmoQ5QKSCUQoerb00c1C8ChiEt8y1iQ82OcV2f7V3CVulwD
# Fan32Il4Fi9vRSJTAn3KjJNk1vQ4l1Q0OzPcLPVX8YlBxRPcajqz5L6eRa8usFxM
# Dvvxe2YAJkZ0v3pqBzfuWFy2EVxpfzovkSdZTUIvWeiX6xaOoBPGXVUBxoNOY/OP
# d/Y3dXltluQ86AA2sAscurB2B/SpET54rVyvgcI45gpDMMcqT76Ca8cPpHOj1EnA
# oGS2yU8aXgQ9kYraZ5do1v5QPVtSwndPvM04ZitFETmfCGy5Hl3NLiMNVWi2P5De
# sGJ5eGe5XP9A4BCnD6GbADYBNU4KoQSCu3S9/tGjpoqjkT+uctpbqPlD7oYq/Yd6
# ddGldHe9ggolwm6EoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIzMDEyNDEyNDc0MlowLwYJ
# KoZIhvcNAQkEMSIEIC/K7XVmDpRgSeA0Pxave1h1s/3hJF84qkz8pekuDyCTMA0G
# CSqGSIb3DQEBAQUABIICAFnQdwIj5GAKW3ZQaea9Oa/vb404ArMFSDAaF3DF97az
# 5TGPF4c5CRO75cOpWmG48r+7AWRMTbAxjjRF1yGbeG/U+BBpLMa2AHjJs8QnyjKm
# 2ADteqMVt+b2ZsbKwiRhZc1AwiRIql6SQ3dKe2859OPpwam3K5raUI+ktZbmr0fD
# rsiNC5d5CbnXX3rS7r6R/mXlquamw0DZX+6M3GG055SFf1AJhybsbq24UDDpMtBo
# fj8dc3O9bR6gAkeFqGgK0BRZ/zI6h4/+jn+2gREBurVBnutfcHolMvA7ejIaFZXt
# Tttu3DcoEt1w8z9PJ/7CrXvU3RBZYaitt4TICLMfQ0Ie2xQCaby0nm6v1YRhyUvt
# wWHyvT6/WPtxa5rU2n1qy3tvySclZtSNsTfGXGyMoQoUvp1lWhy6r1Met6OlNMUf
# OYJva3ujQ2D0mMQPP132gjXTOT1mORa41eqE21/fHj13tWl2vbEXWPSwMU0kITPO
# vdDn4/Xpi0apMzI628WiKcXlAMC7EjPwZZ/NUZ6K78XuAzj/mjzquzqfsl17jUtK
# VAXbRVPGiHw883c1uZrnseRY7GLg+G5Z7BR6NXK4/4wtUseReZ/1rLEUuZhrhGVg
# KKvqK2aGBTh+suCoA+mGxc5Mh/yx333ihciH1YYgEfGsZaKBkEhvwvDrpD2nJdsT
# SIG # End signature block
