/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.Attribute;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.FieldVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.ModuleVisitor;
import com.eg.org.objectweb.asm.RecordComponentVisitor;
import com.eg.org.objectweb.asm.TypePath;
import com.eg.org.objectweb.asm.commons.AnnotationRemapper;
import com.eg.org.objectweb.asm.commons.FieldRemapper;
import com.eg.org.objectweb.asm.commons.MethodRemapper;
import com.eg.org.objectweb.asm.commons.ModuleHashesAttribute;
import com.eg.org.objectweb.asm.commons.ModuleRemapper;
import com.eg.org.objectweb.asm.commons.RecordComponentRemapper;
import com.eg.org.objectweb.asm.commons.Remapper;
import java.util.List;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor, Remapper remapper) {
        this(589824, classVisitor, remapper);
    }

    protected ClassRemapper(int n2, ClassVisitor classVisitor, Remapper remapper) {
        super(n2, classVisitor);
        this.remapper = remapper;
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.className = string;
        super.visit(n2, n3, this.remapper.mapType(string), this.remapper.mapSignature(string2, false), this.remapper.mapType(string3), stringArray == null ? null : this.remapper.mapTypes(stringArray));
    }

    public ModuleVisitor visitModule(String string, int n2, String string2) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(string), n2, string2);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(string), bl2);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(string, annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(n2, typePath, this.remapper.mapDesc(string), bl2);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(string, annotationVisitor);
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
            List<String> list = moduleHashesAttribute.modules;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                list.set(i2, this.remapper.mapModuleName(list.get(i2)));
            }
        }
        super.visitAttribute(attribute);
    }

    public RecordComponentVisitor visitRecordComponent(String string, String string2, String string3) {
        RecordComponentVisitor recordComponentVisitor = super.visitRecordComponent(this.remapper.mapRecordComponentName(this.className, string, string2), this.remapper.mapDesc(string2), this.remapper.mapSignature(string3, true));
        return recordComponentVisitor == null ? null : this.createRecordComponentRemapper(recordComponentVisitor);
    }

    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        FieldVisitor fieldVisitor = super.visitField(n2, this.remapper.mapFieldName(this.className, string, string2), this.remapper.mapDesc(string2), this.remapper.mapSignature(string3, true), object == null ? null : this.remapper.mapValue(object));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        String string4 = this.remapper.mapMethodDesc(string2);
        MethodVisitor methodVisitor = super.visitMethod(n2, this.remapper.mapMethodName(this.className, string, string2), string4, this.remapper.mapSignature(string3, false), stringArray == null ? null : this.remapper.mapTypes(stringArray));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        super.visitInnerClass(this.remapper.mapType(string), string2 == null ? null : this.remapper.mapType(string2), string3 == null ? null : this.remapper.mapInnerClassName(string, string2, string3), n2);
    }

    public void visitOuterClass(String string, String string2, String string3) {
        super.visitOuterClass(this.remapper.mapType(string), string2 == null ? null : this.remapper.mapMethodName(string, string2, string3), string3 == null ? null : this.remapper.mapMethodDesc(string3));
    }

    public void visitNestHost(String string) {
        super.visitNestHost(this.remapper.mapType(string));
    }

    public void visitNestMember(String string) {
        super.visitNestMember(this.remapper.mapType(string));
    }

    public void visitPermittedSubclass(String string) {
        super.visitPermittedSubclass(this.remapper.mapType(string));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    @Deprecated
    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, null, annotationVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(String string, AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, string, annotationVisitor, this.remapper).orDeprecatedValue(this.createAnnotationRemapper(annotationVisitor));
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }

    protected RecordComponentVisitor createRecordComponentRemapper(RecordComponentVisitor recordComponentVisitor) {
        return new RecordComponentRemapper(this.api, recordComponentVisitor, this.remapper);
    }
}

