/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.util;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.spi.ContextAware;
import com.eg.ch.qos.logback.core.spi.LifeCycle;
import com.eg.ch.qos.logback.core.status.OnConsoleStatusListener;
import com.eg.ch.qos.logback.core.status.StatusListener;
import com.eg.ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    public static void installIfAsked(Context context) {
        String string = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(string)) {
            StatusListenerConfigHelper.addStatusListener(context, string);
        }
    }

    private static void addStatusListener(Context context, String string) {
        StatusListener statusListener = null;
        statusListener = "SYSOUT".equalsIgnoreCase(string) ? new OnConsoleStatusListener() : StatusListenerConfigHelper.createListenerPerClassName(context, string);
        StatusListenerConfigHelper.initAndAddListener(context, statusListener);
    }

    private static void initAndAddListener(Context context, StatusListener statusListener) {
        if (statusListener != null) {
            boolean bl2;
            if (statusListener instanceof ContextAware) {
                ((ContextAware)((Object)statusListener)).setContext(context);
            }
            if ((bl2 = context.getStatusManager().add(statusListener)) && statusListener instanceof LifeCycle) {
                ((LifeCycle)((Object)statusListener)).start();
            }
        }
    }

    private static StatusListener createListenerPerClassName(Context context, String string) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName(string, StatusListener.class, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void addOnConsoleListenerInstance(Context context, OnConsoleStatusListener onConsoleStatusListener) {
        onConsoleStatusListener.setContext(context);
        boolean bl2 = context.getStatusManager().add(onConsoleStatusListener);
        if (bl2) {
            onConsoleStatusListener.start();
        }
    }
}

