'use strict'

const logger = require('../logger');
const threads = require('../utils/threads');
const ModuleHooker = require('../module-hooker');

const appendMsg = 'Thread Instrumentation:';
const MODULES = {
  worker_threads: { enabled: true },
}

class ThreadInstrumentation {
  constructor(agent) {
    this.agent = agent;
    this._started = false;
    this.moduleHooker = new ModuleHooker(MODULES, agent, './worker-threads/modules/');
  }

  start() {
    if (!threads.workerThread || this._started) return;
    if (!this.agent.getConfig('enable_worker_thread_metrics')) {
      logger.info(appendMsg, 'Worker thread monitoring is disabled');
      return;
    }

    logger.info(appendMsg, 'starting...!');
    this.moduleHooker.start();
    this._started = true;
    logger.info(appendMsg, 'started');
  }

  stop() {
    if (!this._started) return;
    this.moduleHooker.stop();
    this._started = false;
    logger.info(appendMsg, 'stopped');
  }
}

module.exports = ThreadInstrumentation;