$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Import-Module FileServerResourceManager -EA SilentlyContinue

$Quotas  = Get-FsrmQuota
If ($Quotas -ne $null)
{
	foreach($Quota in $Quotas)
	{
		$Path = $Quota.Path -replace("\\","/")
		$Path = $Path -replace(" ","\ ")
		$QuotaMB = [math]::Round($Quota.Size/1MB,4)
		$UsedMB = [math]::Round($Quota.Usage/1MB,4)
		$FreeMB = $QuotaMB - $UsedMB
		If ($QuotaMB -gt 0 -and $UsedMB -ge 0)
		{
			$UsagePct = [math]::Round(($UsedMB/$QuotaMB)*100,4)
		}
		Else
		{
			$UsagePct = 0
		}
		Write-Host ($Path, $QuotaMB, $UsedMB, $FreeMB, $UsagePct, $Quota.SoftLimit, $Quota.MatchesTemplate, 
			    $Quota.Disabled, $Quota.Template, $Quota.Description) -separator "#~#"
	}
}


