/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.spi;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.spi.ContextAware;
import com.eg.ch.qos.logback.core.status.ErrorStatus;
import com.eg.ch.qos.logback.core.status.InfoStatus;
import com.eg.ch.qos.logback.core.status.Status;
import com.eg.ch.qos.logback.core.status.StatusManager;
import com.eg.ch.qos.logback.core.status.WarnStatus;

public class ContextAwareImpl
implements ContextAware {
    private int noContextWarning = 0;
    protected Context context;
    final Object origin;

    public ContextAwareImpl(Context context, Object object) {
        this.context = context;
        this.origin = object;
    }

    protected Object getOrigin() {
        return this.origin;
    }

    public void setContext(Context context) {
        if (this.context == null) {
            this.context = context;
        } else if (this.context != context) {
            throw new IllegalStateException("Context has been already set");
        }
    }

    public Context getContext() {
        return this.context;
    }

    public StatusManager getStatusManager() {
        if (this.context == null) {
            return null;
        }
        return this.context.getStatusManager();
    }

    public void addStatus(Status status) {
        if (this.context == null) {
            if (this.noContextWarning++ == 0) {
                System.out.println("LOGBACK: No context given for " + this);
            }
            return;
        }
        StatusManager statusManager = this.context.getStatusManager();
        if (statusManager != null) {
            statusManager.add(status);
        }
    }

    public void addInfo(String string) {
        this.addStatus(new InfoStatus(string, this.getOrigin()));
    }

    public void addInfo(String string, Throwable throwable) {
        this.addStatus(new InfoStatus(string, this.getOrigin(), throwable));
    }

    public void addWarn(String string) {
        this.addStatus(new WarnStatus(string, this.getOrigin()));
    }

    public void addWarn(String string, Throwable throwable) {
        this.addStatus(new WarnStatus(string, this.getOrigin(), throwable));
    }

    public void addError(String string) {
        this.addStatus(new ErrorStatus(string, this.getOrigin()));
    }

    public void addError(String string, Throwable throwable) {
        this.addStatus(new ErrorStatus(string, this.getOrigin(), throwable));
    }
}

