/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.turbo;

import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.turbo.LRUMessageCache;
import com.eg.ch.qos.logback.classic.turbo.TurboFilter;
import com.eg.ch.qos.logback.core.spi.FilterReply;
import com.eg.org.slf4j.Marker;

public class DuplicateMessageFilter
extends TurboFilter {
    public static final int DEFAULT_CACHE_SIZE = 100;
    public static final int DEFAULT_ALLOWED_REPETITIONS = 5;
    public int allowedRepetitions = 5;
    public int cacheSize = 100;
    private LRUMessageCache msgCache;

    public void start() {
        this.msgCache = new LRUMessageCache(this.cacheSize);
        super.start();
    }

    public void stop() {
        this.msgCache.clear();
        this.msgCache = null;
        super.stop();
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        int n2 = this.msgCache.getMessageCountAndThenIncrement(string);
        if (n2 <= this.allowedRepetitions) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public int getAllowedRepetitions() {
        return this.allowedRepetitions;
    }

    public void setAllowedRepetitions(int n2) {
        this.allowedRepetitions = n2;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n2) {
        this.cacheSize = n2;
    }
}

