/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.html;

import com.eg.ch.qos.logback.classic.PatternLayout;
import com.eg.ch.qos.logback.classic.html.DefaultCssBuilder;
import com.eg.ch.qos.logback.classic.html.DefaultThrowableRenderer;
import com.eg.ch.qos.logback.classic.pattern.MDCConverter;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.CoreConstants;
import com.eg.ch.qos.logback.core.helpers.Transform;
import com.eg.ch.qos.logback.core.html.HTMLLayoutBase;
import com.eg.ch.qos.logback.core.html.IThrowableRenderer;
import com.eg.ch.qos.logback.core.pattern.Converter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLayout
extends HTMLLayoutBase<ILoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++n2;
        }
        if (n2 == 0) {
            super.start();
        }
    }

    @Override
    protected Map<String, String> getDefaultConverterMap() {
        return PatternLayout.DEFAULT_CONVERTER_MAP;
    }

    @Override
    public String doLayout(ILoggingEvent iLoggingEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        this.startNewTableIfLimitReached(stringBuilder);
        boolean bl2 = true;
        if ((this.counter++ & 1L) == 0L) {
            bl2 = false;
        }
        String string = iLoggingEvent.getLevel().toString().toLowerCase();
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        stringBuilder.append("<tr class=\"");
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" odd\">");
        } else {
            stringBuilder.append(" even\">");
        }
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        for (Converter<ILoggingEvent> converter = this.head; converter != null; converter = converter.getNext()) {
            this.appendEventToBuffer(stringBuilder, converter, iLoggingEvent);
        }
        stringBuilder.append("</tr>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.throwableRenderer.render(stringBuilder, iLoggingEvent);
        }
        return stringBuilder.toString();
    }

    private void appendEventToBuffer(StringBuilder stringBuilder, Converter<ILoggingEvent> converter, ILoggingEvent iLoggingEvent) {
        stringBuilder.append("<td class=\"");
        stringBuilder.append(this.computeConverterName(converter));
        stringBuilder.append("\">");
        stringBuilder.append(Transform.escapeTags(converter.convert(iLoggingEvent)));
        stringBuilder.append("</td>");
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
    }

    public IThrowableRenderer getThrowableRenderer() {
        return this.throwableRenderer;
    }

    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> iThrowableRenderer) {
        this.throwableRenderer = iThrowableRenderer;
    }

    @Override
    protected String computeConverterName(Converter converter) {
        if (converter instanceof MDCConverter) {
            MDCConverter mDCConverter = (MDCConverter)converter;
            String string = mDCConverter.getFirstOption();
            if (string != null) {
                return string;
            }
            return "MDC";
        }
        return super.computeConverterName(converter);
    }
}

