/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponentDiscoveryInfo;
import com.eg.apm.APMExceptionDataRepository;
import com.eg.apm.APMExceptionObject;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMStatusCodeDataRepository;
import com.eg.apm.APMStatusCodeObject;
import com.eg.apm.ClientSocketHandler;
import com.eg.apm.Component;
import com.eg.apm.ConfigurationHelper;
import com.eg.apm.HandlerController;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.SnapShotTaker;
import com.eg.apm.SnapShotTakerWatcher;
import com.eg.apm.Status;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APMComponent
extends Component {
    private APMLanguage language;
    private String hostWithPortWithType;
    private String nickWithPortWithType;
    private ArrayList<String> entityList;
    private ArrayList<String> entityListForConfigRequest;
    private Status modeStatus;
    private Status componentOrEntityStatus;
    private Status heartBeatStatus;
    private Hashtable<String, String> sessionUserMapping = null;
    private Hashtable<String, HashMap> masterThresholdDetails;
    private Hashtable<String, HashMap> masterPropsDetails;
    private final Hashtable<Long, ConfigurationHelper> configByWorkerId = new Hashtable();
    private String applicationTimeZone = null;
    private long heartBeatTime = -1L;
    private APMComponentDiscoveryInfo discoveryInfo = new APMComponentDiscoveryInfo();
    protected final HandlerController control = new HandlerController();
    private Timer snapShotTakerTimer = null;
    private SnapShotTaker snapShotTaker = null;
    private PropsManager propsManager = null;
    private UPDManager UPDManagerObj = null;
    private HashMap cpcPatternMap = null;
    private APMExceptionDataRepository apmExceptionRepository = null;
    private APMStatusCodeDataRepository apmStatusCodeDataRepository = null;
    private HashMap masterInfraTestConfigDetails = null;
    private static final String loggerDispStr = "[APMComponent]";
    private boolean appServerRestarted = false;
    private boolean prepareBtmTestConfigs = false;
    private boolean prepareJvmTestConfigs = false;
    private boolean prepareCpcConfigs = false;
    private boolean prepareThresholdConfigs = false;
    private static final String threshConfigRequest = "_Threshold_Config_Request";
    private static final String btmConfigRequest = "_BTM_Config_Request";

    public APMComponent(String string) {
        super(string);
        this.entityList = new ArrayList();
        this.modeStatus = Status.NONE;
        this.componentOrEntityStatus = Status.NEW_COMPONENT;
        this.heartBeatStatus = Status.NONE;
    }

    public APMComponent(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string3, string4, string5);
        this.entityList = new ArrayList();
        this.modeStatus = Status.NONE;
        this.componentOrEntityStatus = Status.NEW_COMPONENT;
        this.heartBeatStatus = Status.NONE;
        this.hostWithPortWithType = string3 + ":" + string4 + ":" + string5;
        this.nickWithPortWithType = string2 + ":" + string4 + ":" + string5;
    }

    public void changeComponentOrEntityStatus() {
        this.componentOrEntityStatus = Status.MANAGED_ALREADY;
    }

    public boolean isComponentOrEntityStatus() {
        return this.componentOrEntityStatus == Status.NEW_COMPONENT || this.componentOrEntityStatus == Status.NEW_ENTITY;
    }

    public String hostWithPortWithType() {
        return this.hostWithPortWithType;
    }

    public String getNickWithPortWithType() {
        return this.nickWithPortWithType;
    }

    public void addEntity(String string) {
        if (!this.entityList.contains(string)) {
            this.entityList.add(string);
            this.componentOrEntityStatus = Status.NEW_ENTITY;
        }
    }

    public boolean isEntityExists(String string) {
        return this.entityList.contains(string);
    }

    public boolean removeEntity(String string) {
        boolean bl = this.entityList.remove(string);
        if (this.masterThresholdDetails != null) {
            this.masterThresholdDetails.remove(string);
        }
        if (this.masterPropsDetails != null) {
            this.masterPropsDetails.remove(string);
        }
        if (bl) {
            this.clearStoredData(string);
        }
        return bl;
    }

    private void clearStoredData(String string) {
        if (this.language == APMLanguage.JAVA) {
            if (string.equalsIgnoreCase("BusinessTransTest")) {
                this.UPDManagerObj.clearStoredDataForBusinessTransTest();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data cleared for {}:{} ", new Object[]{loggerDispStr, string, this.getID()});
            } else if (string.equalsIgnoreCase("KBusinessTransTest")) {
                this.UPDManagerObj.clearStoredDataForKbusinessTransTest();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data cleared for {}:{} ", new Object[]{loggerDispStr, string, this.getID()});
            }
        } else if (this.language == APMLanguage.NODEJS) {
            if (string.equalsIgnoreCase("NodeTransTest")) {
                this.UPDManagerObj.clearStoredDataForBusinessTransTest();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data cleared for {}:{} ", new Object[]{loggerDispStr, string, this.getID()});
            } else if (string.equalsIgnoreCase("KNodeTransTest")) {
                this.UPDManagerObj.clearStoredDataForKbusinessTransTest();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data cleared for {}:{} ", new Object[]{loggerDispStr, string, this.getID()});
            }
        }
    }

    public Status getStatus() {
        return this.modeStatus;
    }

    public void setStatus(Status status) {
        this.modeStatus = status;
    }

    public void setHeartBeatStatus(Status status) {
        this.heartBeatStatus = status;
    }

    public Status getHeartbeatStatus() {
        return this.heartBeatStatus;
    }

    public boolean isHeartBeating() {
        return this.getHeartbeatStatus() == Status.HEART_BEATING;
    }

    public void setHandlerObject(Long l, Object object) {
        this.control.setObject(l, object);
    }

    public ClientSocketHandler getHandlerObject(Long l) {
        return (ClientSocketHandler)this.control.getObject(l);
    }

    public String getTimeZone() {
        return this.applicationTimeZone;
    }

    public void setTimeZone(String string) {
        this.applicationTimeZone = string;
    }

    public void setHeartBeatTime(long l) {
        this.heartBeatTime = l;
    }

    public long getHeartBeatTime() {
        return this.heartBeatTime;
    }

    public APMLanguage getAPMLanguage() {
        return this.language;
    }

    void setAPMLanguage(APMLanguage aPMLanguage) {
        this.language = aPMLanguage;
    }

    void setInfraTestConfig(HashMap hashMap) {
        if (this.masterInfraTestConfigDetails == null) {
            this.masterInfraTestConfigDetails = hashMap;
        } else {
            this.masterInfraTestConfigDetails.putAll(hashMap);
        }
        ConfigurationHelper configurationHelper = this.getDefaultWorkerIDConfigHelper();
        this.updateConfigToAllWorkers("INFRA", 3);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} INFRA - Registered config. for {}  with {} into MASTER INFRA {} ", new Object[]{loggerDispStr, this.getID(), hashMap, this.masterInfraTestConfigDetails});
    }

    HashMap getInfraTestConfig(Long l, Long l2) {
        HashMap hashMap = null;
        if (this.masterInfraTestConfigDetails != null) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} INFRA - Config. for {} & Worker ID {}", new Object[]{loggerDispStr, this.getID(), l});
            ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} INFRA - ConfigHelper object {} for {} & Worker ID {}", new Object[]{loggerDispStr, configurationHelper, this.getID(), l});
            if (configurationHelper != null) {
                if (configurationHelper.isInfraTestConfigExists()) {
                    hashMap = this.masterInfraTestConfigDetails;
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} INFRA - Configuration {} for {} & Worker ID {}", new Object[]{loggerDispStr, hashMap, this.getID(), l});
                }
            } else {
                try {
                    ConfigurationHelper configurationHelper2;
                    if (l.intValue() > -1 && l2 != null && (configurationHelper2 = this.configByWorkerId.get(Component.DEFAULT_WORKER_ID)) != null && configurationHelper2.isInfraTestConfigExists()) {
                        int n = l2.intValue();
                        for (int i = 0; i < n; ++i) {
                            Long l3 = new Long(i);
                            ConfigurationHelper configurationHelper3 = this.getConfigHelperObject(l3);
                            configurationHelper3.setInfraTestConfigExists(true);
                        }
                        configurationHelper2.setInfraTestConfigExists(false);
                        hashMap = this.masterInfraTestConfigDetails;
                    }
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} INFRA - Exception while getting Infra config details for {} & Worker ID {} - WorkerCount {}., which is due to {}", new Object[]{loggerDispStr, this.getID(), l, l2, exception});
                }
            }
        }
        return hashMap;
    }

    void clearInfraTestConfig(Long l) {
        ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
        if (configurationHelper != null) {
            configurationHelper.setInfraTestConfigExists(false);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} INFRA - Cleared config. for {} & Worker ID {} ", new Object[]{loggerDispStr, this.getID(), l});
        }
    }

    protected void init() {
        this.propsManager = new PropsManager();
        this.propsManager.initProps();
        this.propsManager.applyBTMProps();
        this.UPDManagerObj = new UPDManager(this.propsManager);
        this.sessionUserMapping = new Hashtable();
        SnapShotTakerWatcher.isWatcherNull((boolean)true, (String)this.getID());
    }

    void updateSnapShot() {
        this.UPDManagerObj.updateTransmitCopy4Auto();
        this.UPDManagerObj.updateTransmitCopy4Manual();
        this.UPDManagerObj.cleanupDeadPatterns();
    }

    Timer getSnapShotTakerTimer() {
        return this.snapShotTakerTimer;
    }

    void setSnapShotTakerTimer(Timer timer) {
        this.snapShotTakerTimer = timer;
    }

    void setSnapShotTaker(SnapShotTaker snapShotTaker) {
        this.snapShotTaker = snapShotTaker;
    }

    SnapShotTaker getSnapShotTaker() {
        return this.snapShotTaker;
    }

    void updateSessionUserMapping(String string, String string2) {
        this.sessionUserMapping.put(string, string2);
    }

    public HashMap getSessionUserMapping() {
        if (this.sessionUserMapping.size() > 0) {
            Hashtable hashtable = (Hashtable)this.sessionUserMapping.clone();
            this.sessionUserMapping = new Hashtable();
            HashMap hashMap = new HashMap(hashtable);
            return hashMap;
        }
        return null;
    }

    public void setPropsDetails(String string, HashMap hashMap) {
        Object object;
        if (this.masterPropsDetails == null) {
            this.masterPropsDetails = new Hashtable(2);
            this.masterPropsDetails.put(string, hashMap);
        } else {
            object = this.masterPropsDetails.get(string);
            if (object == null) {
                this.masterPropsDetails.put(string, hashMap);
            } else {
                ((HashMap)object).putAll(hashMap);
                this.masterPropsDetails.put(string, (HashMap)object);
            }
        }
        object = this.getDefaultWorkerIDConfigHelper();
        this.updateConfigToAllWorkers(string, 0);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} PROPS - Registered config.for {}-{} with {} into MASTER PROPS {} - {} .", new Object[]{loggerDispStr, this.getID(), string, hashMap, this.masterPropsDetails});
    }

    private void updateConfigToAllWorkers(String string, int n) {
        block5: {
            Iterator<ConfigurationHelper> iterator;
            block7: {
                block6: {
                    block4: {
                        Collection<ConfigurationHelper> collection = this.configByWorkerId.values();
                        int n2 = collection.size();
                        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Updating config. to all workers( Total - {}) for {}-{} with param value {} ", new Object[]{loggerDispStr, n2, this.getID(), string, n});
                        iterator = collection.iterator();
                        if (n != 0) break block4;
                        while (iterator.hasNext()) {
                            ConfigurationHelper configurationHelper = iterator.next();
                            configurationHelper.setPropsConfigExists(string, true);
                        }
                        break block5;
                    }
                    if (n != 1) break block6;
                    while (iterator.hasNext()) {
                        ConfigurationHelper configurationHelper = iterator.next();
                        configurationHelper.setThresholdConfigExits(string, true);
                    }
                    break block5;
                }
                if (n != 2) break block7;
                while (iterator.hasNext()) {
                    ConfigurationHelper configurationHelper = iterator.next();
                    configurationHelper.setCPCConfigExists(true);
                }
                break block5;
            }
            if (n != 3) break block5;
            while (iterator.hasNext()) {
                ConfigurationHelper configurationHelper = iterator.next();
                configurationHelper.setInfraTestConfigExists(true);
            }
        }
    }

    HashMap getPropsDetails(String string, Long l, Long l2) {
        HashMap hashMap = null;
        if (this.masterPropsDetails != null) {
            boolean bl = this.masterPropsDetails.containsKey(string);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} PROPS - Is any config exists? {} for the {}-{} & Worker ID {}", new Object[]{loggerDispStr, bl, this.getID(), string, l});
            ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} PROPS - ConfigHelper object {} for the {}-{} & Worker ID {}", new Object[]{loggerDispStr, configurationHelper, this.getID(), string, l});
            if (configurationHelper != null) {
                if (configurationHelper.isPropsConfigExists(string)) {
                    hashMap = this.masterPropsDetails.get(string);
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} PROPS - Configuration {} for the {}-{} & Worker ID {}", new Object[]{loggerDispStr, hashMap, this.getID(), string, l});
                }
                if (!bl) {
                    configurationHelper.setPropsConfigExists(string, false);
                }
            } else if (bl) {
                try {
                    ConfigurationHelper configurationHelper2;
                    if (l.intValue() > -1 && l2 != null && (configurationHelper2 = this.configByWorkerId.get(Component.DEFAULT_WORKER_ID)) != null && configurationHelper2.isPropsConfigExists(string)) {
                        int n = l2.intValue();
                        for (int i = 0; i < n; ++i) {
                            Long l3 = new Long(i);
                            ConfigurationHelper configurationHelper3 = this.getConfigHelperObject(l3);
                            configurationHelper3.setPropsConfigExists(string, true);
                        }
                        configurationHelper2.setPropsConfigExists(string, false);
                        hashMap = this.masterPropsDetails.get(string);
                    }
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} PROPS - Exception while getting Props Details - {}:{}, WorkerID :{}, WorkerCount :{}, which is due to {}", new Object[]{loggerDispStr, this.getID(), string, l, l2, exception});
                }
            }
        }
        return hashMap;
    }

    void clearPropsDetails(String string, Long l) {
        ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
        if (configurationHelper != null) {
            configurationHelper.setPropsConfigExists(string, false);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} PROPS - Cleared config. for {}-{} & Worker ID {}.", new Object[]{loggerDispStr, this.getID(), string, l});
        }
    }

    public void setThresholdDetails(String string, HashMap hashMap) {
        Object object;
        if (this.masterThresholdDetails == null) {
            this.masterThresholdDetails = new Hashtable(2);
            this.masterThresholdDetails.put(string, hashMap);
        } else {
            object = this.masterThresholdDetails.get(string);
            if (object == null) {
                this.masterThresholdDetails.put(string, hashMap);
            } else {
                ((HashMap)object).putAll(hashMap);
                this.masterThresholdDetails.put(string, (HashMap)object);
            }
        }
        object = this.getDefaultWorkerIDConfigHelper();
        this.updateConfigToAllWorkers(string, 1);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} THRESHOLD - Registered config.for {}-{} with {} into MASTER THRESHOLD {} - {} .", new Object[]{loggerDispStr, this.getID(), string, hashMap, this.masterPropsDetails});
    }

    HashMap getThresholdDetails(String string, Long l, Long l2) {
        HashMap hashMap = null;
        if (this.masterThresholdDetails != null) {
            boolean bl = this.masterPropsDetails.containsKey(string);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} THRESHOLD - Is any threshold config exists? {} for the {}-{} & Worker ID {}", new Object[]{loggerDispStr, bl, this.getID(), string, l});
            ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} THRESHOLD - ConfigHelper object {} for the {}-{} & Worker ID {}", new Object[]{loggerDispStr, configurationHelper, this.getID(), string, l});
            if (configurationHelper != null) {
                if (configurationHelper.isThresholdConfigExits(string)) {
                    hashMap = this.masterThresholdDetails.get(string);
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} THRESHOLD - Configuration {} for the {}-{} & Worker ID {}", new Object[]{loggerDispStr, hashMap, this.getID(), string, l});
                }
                if (!bl) {
                    configurationHelper.setThresholdConfigExits(string, false);
                }
            } else if (bl) {
                try {
                    ConfigurationHelper configurationHelper2;
                    if (l.intValue() > -1 && l2 != null && (configurationHelper2 = this.configByWorkerId.get(Component.DEFAULT_WORKER_ID)) != null && configurationHelper2.isThresholdConfigExits(string)) {
                        int n = l2.intValue();
                        for (int i = 0; i < n; ++i) {
                            Long l3 = new Long(i);
                            ConfigurationHelper configurationHelper3 = this.getConfigHelperObject(l3);
                            configurationHelper3.setThresholdConfigExits(string, true);
                        }
                        configurationHelper2.setThresholdConfigExits(string, false);
                        hashMap = this.masterThresholdDetails.get(string);
                    }
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} THRESHOLD - Exception while getting threshold details - {}:{}, WorkerID :{}, WorkerCount :{}, which is due to {}", new Object[]{loggerDispStr, this.getID(), string, l, l2, exception});
                }
            }
        }
        return hashMap;
    }

    void clearThresholdDetails(String string, Long l) {
        ConfigurationHelper configurationHelper;
        if (this.masterThresholdDetails != null && this.masterThresholdDetails.containsKey(string) && (configurationHelper = this.configByWorkerId.get(l)) != null) {
            configurationHelper.setThresholdConfigExits(string, false);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} THRESHOLD - Cleared config. for {}-{} & Worker ID {}.", new Object[]{loggerDispStr, this.getID(), string, l});
        }
    }

    private ConfigurationHelper getDefaultWorkerIDConfigHelper() {
        Long l = Component.DEFAULT_WORKER_ID;
        ConfigurationHelper configurationHelper = this.getConfigHelperObject(l);
        return configurationHelper;
    }

    private ConfigurationHelper getConfigHelperObject(Long l) {
        ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
        if (configurationHelper == null) {
            configurationHelper = new ConfigurationHelper(l);
            this.configByWorkerId.put(l, configurationHelper);
        }
        return configurationHelper;
    }

    void initiateSnapShotTaker() {
        SnapShotTakerWatcher.isWatcherNull((boolean)true, (String)this.getID());
    }

    public PropsManager getPropsManager() {
        return this.propsManager;
    }

    public UPDManager getUPDManager() {
        return this.UPDManagerObj;
    }

    public String getPropsManagerAsString() {
        if (this.propsManager == null) {
            return null;
        }
        return this.propsManager.toString();
    }

    public String getUPDManagerAsString() {
        if (this.UPDManagerObj == null) {
            return null;
        }
        return this.UPDManagerObj.toString();
    }

    public String getSessionUSERMapping() {
        if (this.sessionUserMapping == null) {
            return null;
        }
        return this.sessionUserMapping.toString();
    }

    public String getPropsDetails() {
        if (this.masterPropsDetails == null) {
            return null;
        }
        return this.masterPropsDetails.toString();
    }

    public String getThresholdDetails() {
        if (this.masterThresholdDetails == null) {
            return null;
        }
        return this.masterThresholdDetails.toString();
    }

    public String getInfraTestConfig() {
        if (this.masterInfraTestConfigDetails == null) {
            return null;
        }
        return this.masterInfraTestConfigDetails.toString();
    }

    public APMExceptionDataRepository getApmRepositoryForException() {
        if (this.apmExceptionRepository == null) {
            this.apmExceptionRepository = new APMExceptionDataRepository();
        }
        return this.apmExceptionRepository;
    }

    public ArrayList<APMExceptionObject> getAPMExceptions() {
        if (this.apmExceptionRepository != null) {
            return this.apmExceptionRepository.getExceptions();
        }
        return null;
    }

    public APMStatusCodeDataRepository getApmRepositoryForStatusCode() {
        if (this.apmStatusCodeDataRepository == null) {
            this.apmStatusCodeDataRepository = new APMStatusCodeDataRepository();
        }
        return this.apmStatusCodeDataRepository;
    }

    public ArrayList<APMStatusCodeObject> getAPMStatusCode() {
        if (this.apmStatusCodeDataRepository != null) {
            return this.apmStatusCodeDataRepository.getStatusCodes();
        }
        return null;
    }

    public void setNewlyDiscoverd(boolean bl) {
        this.discoveryInfo.setNewlyDiscoverd(bl);
    }

    public boolean isNewlyDiscoverd() {
        return this.discoveryInfo.isNewlyDiscoverd();
    }

    public void setAsDiscoverdManagedComponent(boolean bl) {
        this.discoveryInfo.setAsDiscoverdManagedComponent(bl);
    }

    public boolean isDiscoverdAndManagedComponent() {
        return this.discoveryInfo.isDiscoverdAndManagedComponent();
    }

    public void setDiscoveredDetailsStored(boolean bl) {
        this.discoveryInfo.setDiscoveredDetailsStored(bl);
    }

    public boolean isDiscoveredDetailsStored() {
        return this.discoveryInfo.isDiscoveredDetailsStored();
    }

    public void setDiscoveredDetailsFinalized(boolean bl) {
        this.discoveryInfo.setDiscoveredDetailsFinalized(bl);
    }

    public boolean isDiscoveredDetailsFinalaized() {
        return this.discoveryInfo.isDiscoveredDetailsFinalaized();
    }

    public HashMap getCPCPatternMap(Long l, Long l2) {
        HashMap hashMap = null;
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} CPC - Config. for {} & Worker ID {}", new Object[]{loggerDispStr, this.getID(), l});
        ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} CPC - ConfigHelper object {} for {} & Worker ID {}", new Object[]{loggerDispStr, configurationHelper, this.getID(), l});
        if (configurationHelper != null) {
            if (configurationHelper.isCPCConfigExists()) {
                hashMap = this.cpcPatternMap;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} CPC - Configuration {} for {} & Worker ID {}", new Object[]{loggerDispStr, hashMap, this.getID(), l});
            }
        } else {
            try {
                ConfigurationHelper configurationHelper2;
                if (l.intValue() > -1 && l2 != null && (configurationHelper2 = this.configByWorkerId.get(Component.DEFAULT_WORKER_ID)) != null && configurationHelper2.isCPCConfigExists()) {
                    int n = l2.intValue();
                    for (int i = 0; i < n; ++i) {
                        Long l3 = new Long(i);
                        ConfigurationHelper configurationHelper3 = this.getConfigHelperObject(l3);
                        configurationHelper3.setCPCConfigExists(true);
                    }
                    configurationHelper2.setCPCConfigExists(false);
                    hashMap = this.cpcPatternMap;
                }
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} CPC - Exception while getting CPC config details for {} & Worker ID {} - WorkerCount {}., which is due to {}", new Object[]{loggerDispStr, this.getID(), l, l2, exception});
            }
        }
        return hashMap;
    }

    public void setCPCPatternMap(HashMap hashMap) {
        if (hashMap != null && hashMap.size() > 0) {
            this.cpcPatternMap = hashMap;
            ConfigurationHelper configurationHelper = this.getDefaultWorkerIDConfigHelper();
            this.updateConfigToAllWorkers("CPC", 2);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} CPC - {} Patterns are registered {}", new Object[]{loggerDispStr, this.getID(), hashMap});
        }
    }

    public void clearCPCDataMap(Long l) {
        ConfigurationHelper configurationHelper = this.configByWorkerId.get(l);
        if (configurationHelper != null) {
            configurationHelper.setCPCConfigExists(false);
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} CPC - Cleared patterns for {}, Worker ID :{} ", new Object[]{loggerDispStr, this.getID(), l});
        }
    }

    public void reset() {
        this.propsManager = new PropsManager();
        this.propsManager.initProps();
        this.propsManager.applyBTMProps();
        this.apmExceptionRepository = null;
        this.apmStatusCodeDataRepository = null;
        this.UPDManagerObj = new UPDManager(this.propsManager);
        this.sessionUserMapping = new Hashtable();
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} RESET. BTM repository reset done for {} .", (Object)loggerDispStr, (Object)this.getID());
    }

    protected void helpGC() {
        this.entityList = null;
        this.modeStatus = null;
        this.masterInfraTestConfigDetails = null;
        this.UPDManagerObj = null;
        this.propsManager = null;
        this.sessionUserMapping = null;
        this.masterPropsDetails = null;
        this.masterThresholdDetails = null;
        this.apmExceptionRepository = null;
        this.cpcPatternMap = null;
        if (this.snapShotTakerTimer != null) {
            this.snapShotTakerTimer.cancel();
        }
        this.snapShotTaker = null;
        this.snapShotTakerTimer = null;
    }

    public boolean isAppServerRestarted() {
        return this.appServerRestarted;
    }

    void prepareConfigs(Long l, Long l2) {
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Preparing ALL config details as requested from PROFILER for {}, and Worker ID {} , TotalWorkers {}", new Object[]{loggerDispStr, this.getID(), l, l2});
        this.entityListForConfigRequest = new ArrayList(2);
        this.setAppServerRestarted(true);
        this.setPrepareBtmTestConfigs(this.language.getBusinessTransTestName(), true);
        this.setPrepareBtmTestConfigs(this.language.getKeyBusinessTransTestName(), true);
        this.setPrepareThresholdConfigs(this.language.getBusinessTransTestName(), true);
        this.setPrepareThresholdConfigs(this.language.getKeyBusinessTransTestName(), true);
        this.setPrepareJvmTestConfigs(true);
        this.setPrepareCpcConfigs(true);
        ConfigurationHelper configurationHelper = this.getConfigHelperObject(l);
        configurationHelper.setPropsConfigExists(this.language.getBusinessTransTestName(), true);
        configurationHelper.setPropsConfigExists(this.language.getKeyBusinessTransTestName(), true);
        configurationHelper.setThresholdConfigExits(true);
        configurationHelper.setInfraTestConfigExists(true);
    }

    void setAppServerRestarted(boolean bl) {
        this.appServerRestarted = bl;
    }

    public boolean isPrepareBtmTestConfigs(String string) {
        if (this.entityListForConfigRequest != null) {
            return this.entityListForConfigRequest.contains(string + btmConfigRequest);
        }
        return this.prepareBtmTestConfigs;
    }

    public void setPrepareBtmTestConfigs(String string, boolean bl) {
        String string2 = string + btmConfigRequest;
        if (this.entityListForConfigRequest != null) {
            if (bl && !this.entityListForConfigRequest.contains(string2)) {
                this.entityListForConfigRequest.add(string2);
            } else {
                this.entityListForConfigRequest.remove(string2);
            }
        }
        this.prepareBtmTestConfigs = bl;
    }

    public boolean isPrepareJvmTestConfigs() {
        return this.prepareJvmTestConfigs;
    }

    void setPrepareJvmTestConfigs(boolean bl) {
        this.prepareJvmTestConfigs = bl;
    }

    public boolean isPrepareCpcConfigs() {
        return this.prepareCpcConfigs;
    }

    void setPrepareCpcConfigs(boolean bl) {
        this.prepareCpcConfigs = bl;
    }

    public boolean isPrepareThresholdConfigs(String string) {
        if (this.entityListForConfigRequest != null) {
            return this.entityListForConfigRequest.contains(string + threshConfigRequest);
        }
        return this.prepareThresholdConfigs;
    }

    public void setPrepareThresholdConfigs(String string, boolean bl) {
        String string2 = string + threshConfigRequest;
        if (this.entityListForConfigRequest != null) {
            if (bl && !this.entityListForConfigRequest.contains(string2)) {
                this.entityListForConfigRequest.add(string2);
            } else {
                this.entityListForConfigRequest.remove(string2);
            }
        }
        this.prepareThresholdConfigs = bl;
    }

    public void printAPMRepositoryDetails(Logger logger) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} Details of Component : {}", (Object)loggerDispStr, (Object)super.toString());
            logger.trace("{} Entity List           : {}", (Object)loggerDispStr, this.entityList);
            logger.trace("{} Heart Beat Status     : {}, \t HeartBeatTime - {}, \t jvmTimeZone - {}", new Object[]{loggerDispStr, this.heartBeatStatus, this.getHeartBeatTime(), this.getTimeZone()});
            logger.trace("{} HandlerController     : {}, \t snapShotTakerTimer - {}, \t snapShotTaker - {}", new Object[]{loggerDispStr, this.control.toString(), this.getSnapShotTakerTimer(), this.getSnapShotTaker()});
            logger.trace("{} Props Details         : {} {}", (Object)loggerDispStr, (Object)this.getPropsDetails());
            logger.trace("{} CPCPatternMap         : {}", (Object)loggerDispStr, (Object)this.cpcPatternMap);
            logger.trace("{} Threshold Details     : {}, \t  jvmTestConfigDetails - {}, \t propsManager - {}, \t UPDManagerObj - {}", new Object[]{loggerDispStr, this.getThresholdDetails(), this.getInfraTestConfig(), this.getPropsManagerAsString(), this.getUPDManagerAsString()});
            logger.trace("{} SessionUserMapping    : {}, \t javaExceptionRepository - {} ", new Object[]{loggerDispStr, this.getSessionUSERMapping(), this.getApmRepositoryForException()});
            logger.trace("{} appServerRestarted    : {}, prepareBtmTestConfigs : {}, prepareCpcConfigs : {}, prepareJvmTestConfigs  : {}, prepareThresholdConfigs : {}, entityListForConfigRequest : {}", new Object[]{loggerDispStr, this.appServerRestarted, this.prepareBtmTestConfigs, this.prepareCpcConfigs, this.prepareJvmTestConfigs, this.prepareThresholdConfigs, this.entityListForConfigRequest});
            logger.trace("{} isDiscoverdAndManagedComponent - {}", (Object)loggerDispStr, (Object)this.isDiscoverdAndManagedComponent());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("APMComponent - [hostWithPortWithType=").append(this.hostWithPortWithType).append(", nickWithPortWithType=").append(this.nickWithPortWithType);
        stringBuilder.append(", modeStatus=").append(this.modeStatus).append(", componentOrEntityStatus=").append(this.componentOrEntityStatus);
        stringBuilder.append(", heartBeatStatus=").append(this.heartBeatStatus);
        stringBuilder.append(", configByWorkerId=").append(this.configByWorkerId);
        stringBuilder.append(", masterThresholdDetails=").append(this.masterThresholdDetails);
        stringBuilder.append(", masterPropsDetails=").append(this.masterPropsDetails).append("]");
        return stringBuilder.toString();
    }

    public abstract void removeAllEntities();

    public abstract void clearCommonGUIDConfiguration(Long var1);
}

