/*
 * Decompiled with CFR 0.152.
 */
import com.eg.VmSessionInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.xml.ws.BindingProvider;

public class Vm25Connection {
    public static long lastDisconnCheckTime = 0L;
    public static long disconnTimeOut = EgConfigInfo.msecPerMin * 15L;
    public static int inProgressCount = 0;
    public static long maxConcurrent = EgMainAgent.maxConCurrVmConns;
    public static String syncString = new String("syncString");
    private static final String SVC_INST_NAME = "ServiceInstance";
    public boolean isAnyTimeout = false;
    public VimPortType _service;
    public boolean isServerConnected = false;
    public ServiceContent _sic;
    public ManagedObjectReference _svcRef;
    public long startTime = 0L;
    public float vcVersion = -5.0f;
    private String session_url = "";
    private String session_id = "";
    public Map headersResult;
    public boolean isDebugEnabled = false;
    public String validateMsg = "";
    private static long timeout = 5L * EgConfigInfo.msecPerMin;
    public Hashtable lockMap = new Hashtable();
    public Hashtable unlockMap = new Hashtable();
    public static boolean needToRestartAgent = false;
    public int vSpherConnTimeout = 900000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String string) {
        if (maxConcurrent <= 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (true) {
            String string2 = syncString;
            synchronized (string2) {
                if ((long)inProgressCount < maxConcurrent) {
                    ++inProgressCount;
                    Long l2 = (Long)this.lockMap.get(string);
                    if (l2 == null) {
                        this.lockMap.put(string, new Long(1L));
                    } else {
                        this.lockMap.put(string, new Long(l2 + 1L));
                    }
                    return;
                }
            }
            long l3 = System.currentTimeMillis();
            if (l3 - l > timeout) {
                String string3 = syncString;
                synchronized (string3) {
                    if ((long)inProgressCount >= maxConcurrent) {
                        System.err.println("LockMap issue possibly. - inProgressCount =" + inProgressCount + " Lock Map is " + this.lockMap + " and Unlock Map is " + this.unlockMap);
                        this.Vm25ConnectionLog("LockMap issue possibly. CurrentTime " + System.currentTimeMillis() + " - inProgressCount =" + inProgressCount + " Lock Map is " + this.lockMap + " and Unlock Map is " + this.unlockMap + "\tstackTrack is " + this.getStackTrace());
                        inProgressCount = 0;
                        if (++n >= 200) {
                            needToRestartAgent = true;
                        }
                    }
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String string) {
        if (maxConcurrent <= 0L) {
            return;
        }
        String string2 = syncString;
        synchronized (string2) {
            Long l;
            if (--inProgressCount < 0) {
                inProgressCount = 0;
            }
            if ((l = (Long)this.unlockMap.get(string)) == null) {
                this.unlockMap.put(string, new Long(1L));
            } else {
                this.unlockMap.put(string, new Long(l + 1L));
            }
        }
    }

    public boolean getEsxConnection(URL uRL, String string, String string2) {
        try {
            if (uRL.toString().startsWith("https")) {
                this.setSSL();
            }
            if (this.isDebugEnabled) {
                System.out.println("Inside of Vm25Connection up :" + uRL + "\tusername :" + string + "\tpassword :" + EgCrypt.encrypt((String)string2));
            }
            this._svcRef = new ManagedObjectReference();
            this._svcRef.setType(SVC_INST_NAME);
            this._svcRef.setValue(SVC_INST_NAME);
            VimService vimService = new VimService();
            this._service = vimService.getVimPort();
            if (this._service == null) {
                return false;
            }
            Map map = ((BindingProvider)this._service).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", uRL.toString());
            map.put("javax.xml.ws.session.maintain", new Boolean(true));
            map.put("com.sun.xml.internal.ws.connect.timeout", new Integer(this.vSpherConnTimeout));
            map.put("com.sun.xml.internal.ws.request.timeout", new Integer(this.vSpherConnTimeout));
            this._sic = this._service.retrieveServiceContent(this._svcRef);
            if (this._sic == null) {
                return false;
            }
            ManagedObjectReference managedObjectReference = null;
            try {
                managedObjectReference = this._sic.getSessionManager();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (managedObjectReference != null) {
                UserSession userSession = this._service.login(managedObjectReference, string, string2, null);
                this.headersResult = (Map)((BindingProvider)this._service).getResponseContext().get("javax.xml.ws.http.response.headers");
                UserSession userSession2 = (UserSession)this.getCurrentSesionProperty(managedObjectReference, "currentSession");
                this.session_url = uRL.toString();
                if (userSession2 != null) {
                    this.session_id = userSession2.getKey();
                }
                if (this.session_url != null && this.session_id != null) {
                    VmSessionInfo.setValue((String)this.session_url, (String)this.session_id, (String)"true");
                }
            }
            System.out.println(" Vm25Connection Successfully Connected  for " + uRL);
            this.startTime = System.currentTimeMillis();
            this.isServerConnected = true;
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception occured while connecting to the Esx/VC server url=" + uRL + "\tusername=" + string);
            try {
                this.validateMsg = exception instanceof InvalidLoginFaultMsg ? " Invalid username/password; logon denied" : (exception instanceof InvalidLocaleFaultMsg ? "The locale is invalid or unknown to the server" : (exception instanceof RuntimeFaultFaultMsg ? "Runtime fault" : "The URL " + uRL.toString() + " with user " + string + " Reason: " + exception));
            }
            catch (Exception exception2) {
                this.validateMsg = "The URL " + uRL.toString() + " with user " + string + " Reason: " + exception2;
            }
            this.isServerConnected = false;
            System.err.println(" error message is " + this.validateMsg);
            exception.printStackTrace();
            return false;
        }
    }

    public void disconnectEsx() {
        block8: {
            this.startTime = 0L;
            long l = System.currentTimeMillis();
            try {
                Object object;
                Hashtable hashtable;
                if (this._service != null && this._sic != null) {
                    hashtable = new EsxDisconnectThread(this._service, this._sic, this.session_url, this.session_id);
                    this._service = null;
                    this._sic = null;
                }
                if (this.session_url != null && this.session_id != null) {
                    VmSessionInfo.deleteVariables((String)this.session_url, (String)this.session_id);
                }
                if (l - lastDisconnCheckTime <= disconnTimeOut) break block8;
                hashtable = EsxDisconnectThread.curThreads;
                Enumeration enumeration = hashtable.keys();
                ArrayList arrayList = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Long l2 = (Long)hashtable.get(k);
                    if (l2 - l <= disconnTimeOut) continue;
                    try {
                        object = (EsxDisconnectThread)k;
                        object.interrupt();
                        Thread.currentThread();
                        Thread.yield();
                        object.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList.add(k);
                }
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    object = arrayList.get(i);
                    hashtable.remove(object);
                }
                lastDisconnCheckTime = System.currentTimeMillis();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setSSL() {
        try {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            TrustManager[] trustManagerArray = new TrustManager[1];
            TrustAllTrustManager trustAllTrustManager = new TrustAllTrustManager();
            trustManagerArray[0] = trustAllTrustManager;
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
            sSLSessionContext.setSessionTimeout(0);
            sSLContext.init(null, trustManagerArray, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].trim().equals("-url") && ++i < stringArray.length) {
                        string = stringArray[i];
                        continue;
                    }
                    if (stringArray[i].trim().equals("-user") && ++i < stringArray.length) {
                        string2 = stringArray[i];
                        continue;
                    }
                    if (!stringArray[i].trim().equals("-pass") || ++i >= stringArray.length) continue;
                    string3 = EgCrypt.decrypt((String)stringArray[i]);
                }
            } else {
                System.out.println("Format should be : java Vm25Connection -url <urlString> -user <userName> -pass <password>");
                return;
            }
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vm25Connection vm25Connection = new Vm25Connection();
            vm25Connection.isDebugEnabled = true;
            boolean bl = vm25Connection.getEsxConnection(uRL, string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void Vm25ConnectionLog(String string) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string2 = egDateInfo.egetDate(false);
        String string3 = EgInstallInfo.getInstallDir() + "/agent/logs/Vm25Connection_log.log";
        File file = new File(string3);
        if (file.exists() && file.length() >= 0x500000L) {
            EgInstallInfo.fileRename((String)string3, (String)(string3 + ".1"));
        }
        try {
            printWriter = new PrintWriter(new FileWriter(string3, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string4 = new String(string2 + " : " + string);
        printWriter.println(string4);
        printWriter.close();
    }

    public Object getCurrentSesionProperty(ManagedObjectReference managedObjectReference, String string) {
        try {
            Object object;
            List list;
            ObjectContent[] objectContentArray = null;
            if (managedObjectReference != null && string != null) {
                objectContentArray = this.getObjectContentForMorefs(managedObjectReference.getType(), new ManagedObjectReference[]{managedObjectReference}, new String[]{string});
            }
            Object object2 = null;
            if (objectContentArray != null && (list = objectContentArray[0].getPropSet()) != null && list.size() > 0 && (object = ((DynamicProperty)list.get(0)).getVal()) != null) {
                String string2 = object.getClass().getName();
                if (string2.indexOf("ArrayOf") != -1) {
                    String string3 = string2.substring(string2.indexOf("ArrayOf") + "ArrayOf".length(), string2.length());
                    string3 = this.methodExists(object, "get" + string3, null) ? "get" + string3 : "get_" + string3.toLowerCase();
                    Method method = object.getClass().getDeclaredMethod(string3, null);
                    if (method != null) {
                        object2 = method.invoke(object, (Object[])null);
                    }
                } else {
                    object2 = object.getClass().isArray() ? object : object;
                }
            }
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ObjectContent[] getObjectContentForMorefs(String string, ManagedObjectReference[] managedObjectReferenceArray, String[] stringArray) {
        try {
            if (this._sic == null || managedObjectReferenceArray == null || managedObjectReferenceArray.length == 0 || stringArray == null || stringArray.length == 0) {
                return null;
            }
            List<ManagedObjectReference> list = Arrays.asList(managedObjectReferenceArray);
            ManagedObjectReference managedObjectReference = this._sic.getViewManager();
            ManagedObjectReference managedObjectReference2 = this._sic.getPropertyCollector();
            ManagedObjectReference managedObjectReference3 = null;
            try {
                managedObjectReference3 = this._service.createListView(managedObjectReference, list);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ObjectSpec objectSpec = new ObjectSpec();
            objectSpec.setObj(managedObjectReference3);
            objectSpec.setSkip(Boolean.TRUE);
            TraversalSpec traversalSpec = new TraversalSpec();
            traversalSpec.setName("traverseEntities");
            traversalSpec.setPath("view");
            traversalSpec.setSkip(Boolean.FALSE);
            traversalSpec.setType("ListView");
            objectSpec.getSelectSet().add(traversalSpec);
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.setType(string);
            for (int i = 0; i < stringArray.length; ++i) {
                propertySpec.getPathSet().add(stringArray[i]);
            }
            PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
            propertyFilterSpec.getObjectSet().add(objectSpec);
            propertyFilterSpec.getPropSet().add(propertySpec);
            ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
            arrayList.add(propertyFilterSpec);
            ObjectContent[] objectContentArray = null;
            if (this.vcVersion <= 4.0f) {
                if (this._service != null) {
                    try {
                        List list2 = null;
                        try {
                            this._service.retrieveProperties(managedObjectReference2, arrayList);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (list2 != null) {
                            objectContentArray = list2.toArray(new ObjectContent[list2.size()]);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                RetrieveOptions retrieveOptions = new RetrieveOptions();
                RetrieveResult retrieveResult = null;
                try {
                    if (this._service != null && managedObjectReference2 != null) {
                        retrieveResult = this._service.retrievePropertiesEx(managedObjectReference2, arrayList, retrieveOptions);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList arrayList2 = new ArrayList();
                if (retrieveResult != null) {
                    arrayList2 = this.getResultFromRetrieveResult(arrayList2, retrieveResult, managedObjectReference2);
                }
                if (arrayList2 != null && arrayList2.size() > 0) {
                    try {
                        objectContentArray = arrayList2.toArray(new ObjectContent[arrayList2.size()]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                if (this._service != null && managedObjectReference3 != null) {
                    this._service.destroyView(managedObjectReference3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return objectContentArray;
        }
        catch (Exception exception) {
            System.out.println(" [Vm25Connection] exception occured in getObjectContentForMorefs method");
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getResultFromRetrieveResult(ArrayList arrayList, RetrieveResult retrieveResult, ManagedObjectReference managedObjectReference) {
        try {
            if (retrieveResult != null) {
                String string;
                List list = retrieveResult.getObjects();
                if (list != null) {
                    arrayList.addAll(list);
                }
                if ((string = retrieveResult.getToken()) != null && managedObjectReference != null && this._service != null) {
                    RetrieveResult retrieveResult2 = null;
                    try {
                        retrieveResult2 = this._service.continueRetrievePropertiesEx(managedObjectReference, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.getResultFromRetrieveResult(arrayList, retrieveResult2, managedObjectReference);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println(" [Vm25Connection] exception occured in getResultFromRetrieveResult method ");
            exception.printStackTrace();
            return null;
        }
    }

    private String getStackTrace() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = i != 0 ? string + "; " + stackTraceElementArray[i].toString() : stackTraceElementArray[i].toString();
        }
        return string;
    }

    boolean methodExists(Object object, String string, Class[] classArray) {
        boolean bl = false;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            if (method != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

