/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.action;

import com.eg.ch.qos.logback.core.joran.action.Action;
import com.eg.ch.qos.logback.core.joran.event.SaxEvent;
import com.eg.ch.qos.logback.core.joran.event.SaxEventRecorder;
import com.eg.ch.qos.logback.core.joran.spi.ActionException;
import com.eg.ch.qos.logback.core.joran.spi.InterpretationContext;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import com.eg.ch.qos.logback.core.util.Loader;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.xml.sax.Attributes;

public class IncludeAction
extends Action {
    private static final String INCLUDED_TAG = "included";
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    private String attributeInUse;
    private boolean optional;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        this.attributeInUse = null;
        this.optional = OptionHelper.toBoolean(attributes.getValue(OPTIONAL_ATTR), false);
        if (!this.checkAttributes(attributes)) {
            return;
        }
        InputStream inputStream = this.getInputStream(interpretationContext, attributes);
        try {
            if (inputStream != null) {
                this.parseAndRecord(inputStream, saxEventRecorder);
                this.trimHeadAndTail(saxEventRecorder);
                interpretationContext.getJoranInterpreter().getEventPlayer().addEventsDynamically(saxEventRecorder.saxEventList, 2);
            }
        }
        catch (JoranException joranException) {
            this.addError("Error while parsing  " + this.attributeInUse, joranException);
        }
        finally {
            this.close(inputStream);
        }
    }

    void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkAttributes(Attributes attributes) {
        String string = attributes.getValue(FILE_ATTR);
        String string2 = attributes.getValue(URL_ATTR);
        String string3 = attributes.getValue(RESOURCE_ATTR);
        int n2 = 0;
        if (!OptionHelper.isEmpty(string)) {
            ++n2;
        }
        if (!OptionHelper.isEmpty(string2)) {
            ++n2;
        }
        if (!OptionHelper.isEmpty(string3)) {
            ++n2;
        }
        if (n2 == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (n2 > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + n2 + "] is not expected");
    }

    URL attributeToURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = "URL [" + string + "] is not well formed.";
            this.addError(string2, malformedURLException);
            return null;
        }
    }

    InputStream openURL(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            this.optionalWarning("Failed to open [" + uRL.toString() + "]");
            return null;
        }
    }

    URL resourceAsURL(String string) {
        URL uRL = Loader.getResourceBySelfClassLoader(string);
        if (uRL == null) {
            this.optionalWarning("Could not find resource corresponding to [" + string + "]");
            return null;
        }
        return uRL;
    }

    private void optionalWarning(String string) {
        if (!this.optional) {
            this.addWarn(string);
        }
    }

    URL filePathAsURL(String string) {
        URI uRI = new File(string).toURI();
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    URL getInputURL(InterpretationContext interpretationContext, Attributes attributes) {
        String string = attributes.getValue(FILE_ATTR);
        String string2 = attributes.getValue(URL_ATTR);
        String string3 = attributes.getValue(RESOURCE_ATTR);
        if (!OptionHelper.isEmpty(string)) {
            this.attributeInUse = interpretationContext.subst(string);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isEmpty(string2)) {
            this.attributeInUse = interpretationContext.subst(string2);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isEmpty(string3)) {
            this.attributeInUse = interpretationContext.subst(string3);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned");
    }

    InputStream getInputStream(InterpretationContext interpretationContext, Attributes attributes) {
        URL uRL = this.getInputURL(interpretationContext, attributes);
        if (uRL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, uRL);
        return this.openURL(uRL);
    }

    private void trimHeadAndTail(SaxEventRecorder saxEventRecorder) {
        SaxEvent saxEvent;
        List<SaxEvent> list = saxEventRecorder.saxEventList;
        if (list.size() == 0) {
            return;
        }
        SaxEvent saxEvent2 = list.get(0);
        if (saxEvent2 != null) {
            if (saxEvent2.qName.equalsIgnoreCase(INCLUDED_TAG)) {
                list.remove(0);
            }
        }
        if ((saxEvent = list.get(saxEventRecorder.saxEventList.size() - 1)) != null) {
            if (saxEvent.qName.equalsIgnoreCase(INCLUDED_TAG)) {
                list.remove(saxEventRecorder.saxEventList.size() - 1);
            }
        }
    }

    private void parseAndRecord(InputStream inputStream, SaxEventRecorder saxEventRecorder) throws JoranException {
        saxEventRecorder.setContext(this.context);
        saxEventRecorder.recordEvents(inputStream);
    }

    public void end(InterpretationContext interpretationContext, String string) throws ActionException {
    }
}

