'use strict'

const Path = require('path');
const propertiesReader = require('properties-reader');

const logger = require('./logger');
const appendMsg = 'Config-Reader:';
const keyToIgnore = ['COMPONENT_GUID', 'NODE_ID'];

exports.load = function (agent) {
  try {
    const props = `${__dirname}/../../conf/${agent.config.unique_component_id.replace(':', '_')}.props`;
    const confPath = Path.normalize(props);

    const newConfig = {};
    const properties = propertiesReader(confPath);
    logger.info(appendMsg, `Some config is present in ${confPath}`);

    properties.each((key, value) => {
      if (keyToIgnore.indexOf(key) > -1) return;
      newConfig[key] = value;
    });

    logger.debug(appendMsg, 'Config from props is', newConfig);
    agent.configWatcher.onConfigChange(newConfig);
  } catch (e) {
    logger.error(appendMsg, 'load error', e.message);
  }
}