/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlParamMaskHelper {
    private static int options = 10;
    private static final String MASK_SYMBOL = "*";
    private static Pattern URLParamsPattern = Pattern.compile("(?:\\?|&|;)([^=]+)=([^&|;]+)", 2);
    private static Pattern staticResourcePattern = Pattern.compile("(.*/)?(.*).(css|js|tiff|gif|png|ico|bmp|jpg|jpeg|webp|svg|svgz)$", options);
    private static Pattern tidyUriMatcherPattern = Pattern.compile("\\d+", options);

    public static String maskURLParams(String urlStr) {
        Matcher urlParamMatcher = URLParamsPattern.matcher(urlStr);
        StringBuilder builder = new StringBuilder().append("");
        int endIndx = 0;
        if (urlParamMatcher.find()) {
            builder.append(urlStr.substring(0, urlParamMatcher.start() + 1));
            builder.append(urlParamMatcher.group(1));
            builder.append("=?");
            endIndx = urlParamMatcher.end();
        }
        while (urlParamMatcher.find()) {
            builder.append(urlParamMatcher.group().split("=")[0]);
            builder.append("=?");
            endIndx = urlParamMatcher.end();
        }
        builder.append(urlStr.substring(endIndx));
        if (builder.length() > 0) {
            return builder.toString();
        }
        return urlStr;
    }

    public static String normalizeURI(String uri) {
        Matcher staticResourceMatcher;
        if ("/".equals(uri)) {
            return uri;
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(uri.indexOf(47) + 1);
        }
        if ((staticResourceMatcher = staticResourcePattern.matcher(uri)).matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(staticResourceMatcher.group(1).trim()).append("*.").append(staticResourceMatcher.group(3));
            uri = sb.toString();
        }
        Matcher tidyMatcher = tidyUriMatcherPattern.matcher(uri);
        uri = tidyMatcher.replaceAll(MASK_SYMBOL);
        return uri;
    }

    public static String normalizeAndMaskURL(String url) {
        return UrlParamMaskHelper.maskURLParams(UrlParamMaskHelper.normalizeURI(url));
    }

    public static String maskHeaderValues(String key, String value, ArrayList<String> unmaskedHeaderList) {
        int listSize = unmaskedHeaderList.size();
        if (listSize >= 1 && unmaskedHeaderList.contains(key)) {
            return value;
        }
        return MASK_SYMBOL;
    }

    public static String maskCookiesValues(String cookies) {
        StringBuilder maskCookieValue = null;
        try {
            if (cookies != null && !cookies.equals("-")) {
                maskCookieValue = new StringBuilder();
                StringTokenizer stringTokenizer = new StringTokenizer(cookies, ";");
                while (stringTokenizer.hasMoreElements()) {
                    String objString = (String)stringTokenizer.nextElement();
                    int equalIdx = objString.indexOf("=");
                    if (equalIdx == -1) continue;
                    String values = objString.substring(0, equalIdx + 1);
                    maskCookieValue.append(values).append(MASK_SYMBOL).append(";");
                }
                return maskCookieValue.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookies;
    }

    public static void main(String[] args) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader("D:\\Backup\\SpringBootWebstore\\WebStore-UI\\d-sqlparser\\urlList.txt"));
            String urlStr = reader.readLine();
            while (urlStr != null) {
                System.out.println(" Masked URL   = " + UrlParamMaskHelper.maskURLParams(urlStr));
                urlStr = reader.readLine();
                System.out.println("----------------------------------------------------------------------------------------------------");
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

