/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.JavaProcess;
import com.eg.apm.PatternMatcher;
import com.eg.apm.TAG;
import java.util.ArrayList;

public class ProcessPatternMatcher
extends PatternMatcher {
    private ArrayList executableIncludeList;
    private ArrayList executableExcludeList;
    private ArrayList cmdLineIncludeList;
    private ArrayList cmdLineExcludeList;
    private ArrayList javaVersionIncludeList;
    private ArrayList javaVersionExcludeList;
    private ArrayList sysPropsExcludeList;
    private static final String loggerDispStr = "[ProcessPatternMatcher]";

    public boolean isMatched(String string) {
        if (this.executableIncludeList != null && this.executableIncludeList != null) {
            for (int i = 0; i < this.executableIncludeList.size(); ++i) {
                boolean bl;
                String string2 = (String)this.executableIncludeList.get(i);
                if (string2 == null || !(bl = ProcessPatternMatcher.patternMatchWithRegex((String)string, (String)string2))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCmdLineMatched(String string) {
        if (this.cmdLineIncludeList != null && this.cmdLineIncludeList != null) {
            for (int i = 0; i < this.cmdLineIncludeList.size(); ++i) {
                String string2 = (String)this.cmdLineIncludeList.get(i);
                if (string2 == null) continue;
                boolean bl = ProcessPatternMatcher.patternMatchWithRegex((String)string, (String)string2);
                if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} {} : {} , {} IN {}  ", new Object[]{loggerDispStr, "", bl, string2, string});
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isJavaVersionMatched(String string, JavaProcess javaProcess) {
        if (this.javaVersionIncludeList != null) {
            for (int i = 0; i < this.javaVersionIncludeList.size(); ++i) {
                String string2 = (String)this.javaVersionIncludeList.get(i);
                if (string2 == null) continue;
                boolean bl = ProcessPatternMatcher.patternMatchWithRegex((String)string, (String)string2);
                if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} {} : {} , {} IN {}  ", new Object[]{loggerDispStr, "", bl, string2, string});
                }
                if (!bl) continue;
                javaProcess.setMsg((Object)((Object)TAG.JAVA_VERSION_INCLUDE_PATTERN_FOUND) + " - " + string2);
                return true;
            }
        }
        return false;
    }

    public void getConfigurations() {
        ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
        this.executableIncludeList = apmConfigManager.getIncludeProcesses();
        this.executableExcludeList = apmConfigManager.getExcludeProcesses();
        this.cmdLineIncludeList = apmConfigManager.getIncludeCommandLineList();
        this.cmdLineExcludeList = apmConfigManager.getExcludeCommandLineList();
        this.javaVersionIncludeList = apmConfigManager.getJavaVersionIncludeList();
        this.javaVersionExcludeList = apmConfigManager.getJavaVersionExcludeList();
        this.sysPropsExcludeList = apmConfigManager.getExcludeSystemProperties();
        this.addToConfigHash("executableIncludeList", this.executableIncludeList.toString());
        this.addToConfigHash("executableExcludeList", this.executableExcludeList.toString());
        this.addToConfigHash("cmdLineIncludeList", this.cmdLineIncludeList.toString());
        this.addToConfigHash("cmdLineExcludeList", this.cmdLineExcludeList.toString());
        this.addToConfigHash("javaVersionIncludeList", this.javaVersionIncludeList.toString());
        this.addToConfigHash("javaVersionExcludeList", this.javaVersionExcludeList.toString());
        this.addToConfigHash("sysPropsExcludeList", this.sysPropsExcludeList.toString());
    }

    public boolean isIgnoredJvm(JavaProcess javaProcess) {
        if (this.processExcludePatterns(this.javaVersionExcludeList, javaProcess, javaProcess.getJavaVersionCmdResult(), TAG.JAVA_VERSION_EXCLUDE_PATTERN_FOUND)) {
            return true;
        }
        if (this.processExcludePatterns(this.executableExcludeList, javaProcess, javaProcess.getExecutable(), TAG.EXECUTABLE_EXCLUDE_PATTERN_FOUND)) {
            return true;
        }
        if (this.processExcludePatterns(this.cmdLineExcludeList, javaProcess, javaProcess.getCommand(), TAG.CMDLINE_EXCLUDE_PATTERN_FOUND)) {
            return true;
        }
        return this.processExcludePatterns(this.sysPropsExcludeList, javaProcess, javaProcess.getSystemPropertiesAsString(), TAG.SYSTEM_PROPERTY_EXCLUDE_PATTERN_FOUND);
    }

    private boolean processExcludePatterns(ArrayList arrayList, JavaProcess javaProcess, String string, TAG tAG) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2 == null) continue;
                boolean bl = ProcessPatternMatcher.patternMatchWithRegex((String)string, (String)string2);
                if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} {} : {} , {} IN {}  ", new Object[]{loggerDispStr, tAG, bl, string2, string});
                }
                if (!bl) continue;
                if (string2.contains("EG_LOG_HOME") || string2.contains("EG_BTM_HOME") || string2.contains("eg_btm.jar")) {
                    javaProcess.setMsg((Object)((Object)tAG) + " - " + (Object)((Object)TAG.EG_BTM_PROFILER_FOUND) + " - " + string2);
                } else {
                    javaProcess.setMsg((Object)((Object)tAG) + " - " + string2);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isIncludeCmdLineAvailable() {
        return this.cmdLineIncludeList != null && this.cmdLineIncludeList.size() > 0;
    }

    public boolean isIncludeJavaVersionListAvailable() {
        return this.javaVersionIncludeList != null && this.javaVersionIncludeList.size() > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ProcessPatternMatcher={");
        stringBuilder.append(",executableIncludeList=").append(this.executableIncludeList);
        stringBuilder.append(",executableExcludeList=").append(this.executableExcludeList);
        stringBuilder.append(",cmdLineIncludeList=").append(this.cmdLineIncludeList);
        stringBuilder.append(",cmdLineExcludeList=").append(this.cmdLineExcludeList);
        stringBuilder.append(",sysPropsExcludeList=").append(this.sysPropsExcludeList);
        stringBuilder.append(",javaVersionIncludeList=").append(this.javaVersionIncludeList);
        stringBuilder.append(",javaVersionExcludeList=").append(this.javaVersionExcludeList);
        stringBuilder.append(",md5ConfigHash=").append(this.getConfigHash());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

