/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.AgentLogger;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ContainerDataRepo;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.KubernetesAPI;
import com.eg.apm.PatternMatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContainerUtils {
    private static final String loggerDispStr = "[ContainerUtils]";
    private static final String PROC = "/proc/";
    private static final String CGROUP = "/cgroup";
    private static final String containerIdPattern = "([a-f0-9]{64})";
    private static String logDispStr = "";

    private static String getHostProcCgroupFilePath(String string) {
        return PROC + string + CGROUP;
    }

    private static boolean canRead(String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.canRead()) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred ", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDockerContainerId(String string) {
        String string2 = ContainerUtils.getHostProcCgroupFilePath(string);
        if (ContainerUtils.canRead(string2)) {
            PatternMatcher patternMatcher = new PatternMatcher();
            Pattern pattern = patternMatcher.getCompiledPatteren(containerIdPattern);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                while (true) {
                    String string3;
                    if ((string3 = bufferedReader.readLine()) == null) break;
                    Matcher matcher = pattern.matcher(string3 = string3.substring(string3.lastIndexOf("/")));
                    if (!matcher.find()) continue;
                    String string4 = matcher.group(1);
                    return string4;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to read : {}, {}", new Object[]{loggerDispStr, string2, exception.getMessage()});
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            APMDiscoveryLogger.discoveryLogger.trace("{} No read permission for - {} ", (Object)loggerDispStr, (Object)string2);
        }
        return null;
    }

    static String getDockerFileSystemPath(String string) {
        String string2 = string + "/root";
        Path path = Paths.get(PROC + string2, new String[0]);
        if (Files.isSymbolicLink(path)) {
            try {
                Path path2 = Files.readSymbolicLink(path);
                int n = path2.getNameCount();
                if (n > 0) {
                    StringBuilder stringBuilder = new StringBuilder(string2);
                    for (int i = 0; i < n; ++i) {
                        stringBuilder.append("/..");
                    }
                    return stringBuilder.toString();
                }
                return path.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path.toString();
    }

    public static boolean isCrioDaemonRunning() {
        boolean bl;
        HashMap<String, Serializable> hashMap;
        block16: {
            hashMap = new HashMap<String, Serializable>();
            bl = false;
            boolean bl2 = false;
            try {
                String string;
                int n;
                ArrayList arrayList = null;
                String string2 = "";
                if (!APMUtils.isLinux()) break block16;
                if (new File("/var/run/crio/crio.sock").exists() || new File("/var/run/containerd/containerd.sock").exists()) {
                    n = 0;
                    try {
                        string = "which crictl";
                        ArrayList arrayList2 = APMUtils.executeCmd(string, false);
                        hashMap.put(string, arrayList2);
                        String string3 = null;
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            string3 = (String)arrayList2.get(0);
                        }
                        if (string3 != null && string3.length() > 0) {
                            n = 1;
                            bl2 = true;
                            hashMap.put("isCrioSrv", Boolean.valueOf(n != 0));
                            hashMap.put("sockExist", Boolean.valueOf(bl2));
                        }
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to verify crio cmd : {} debug log  :{}", new Object[]{loggerDispStr, exception, hashMap});
                    }
                    if (n != 0) {
                        string2 = "crictl images";
                        arrayList = APMUtils.executeCmd(string2, false);
                        hashMap.put(string2, arrayList);
                        if (arrayList == null || arrayList.size() == 0) {
                            string2 = "sudo crictl images";
                            arrayList = APMUtils.executeCmd(string2, false);
                            hashMap.put(string2, arrayList);
                        }
                    }
                } else {
                    hashMap.put("flag", Boolean.valueOf(bl));
                    APMDiscoveryLogger.discoveryLogger.info("{} No CRIO SOCK found debug log : {}", (Object)loggerDispStr, hashMap);
                    return false;
                }
                if ((arrayList == null || arrayList.size() == 0) && bl2) {
                    string2 = "ps -aef | grep \"crio.sock\"";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                }
                if ((arrayList == null || arrayList.size() == 0) && bl2) {
                    string2 = "ps -aef | grep containerd.sock";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                }
                if (arrayList == null || arrayList.size() == 0) {
                    hashMap.put("flag", Boolean.valueOf(bl));
                    APMDiscoveryLogger.discoveryLogger.info("{} No CRIO SOCK found debug log : {}", (Object)loggerDispStr, hashMap);
                    return false;
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    string = ((String)arrayList.get(n)).trim();
                    if (string == null) continue;
                    if (string.toLowerCase().indexOf("image") >= 0) {
                        bl = true;
                        hashMap.put("flag", Boolean.valueOf(bl));
                        hashMap.put("output contains \"image\"", arrayList);
                    } else {
                        if (string.toLowerCase().indexOf("crio.sock") < 0 && string.toLowerCase().indexOf("containerd.sock") < 0) continue;
                        bl = true;
                        hashMap.put("flag", Boolean.valueOf(bl));
                        hashMap.put("Output contains \"crio.sock\" or \"containerd.sock\"", arrayList);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} {} Exception occurred ", (Object)loggerDispStr, (Object)exception);
            }
        }
        APMDiscoveryLogger.discoveryLogger.warn("{} Checking current server is crio  : {}, debug log :{}", new Object[]{loggerDispStr, bl, hashMap});
        return bl;
    }

    public static boolean isDockerDaemonRunning() {
        HashMap<String, Serializable> hashMap;
        boolean bl;
        block13: {
            bl = false;
            String string = "";
            hashMap = new HashMap<String, Serializable>();
            try {
                ArrayList arrayList = null;
                String string2 = "";
                string2 = "whoami";
                arrayList = APMUtils.executeCmd(string2, false);
                hashMap.put(string2, arrayList);
                if (!APMUtils.isLinux()) break block13;
                if (new File("/usr/bin/docker").exists()) {
                    string = "/usr/bin/";
                    string2 = "/usr/bin/docker info";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                    if (arrayList == null || arrayList.size() == 0 || arrayList.toString().contains("permission denied")) {
                        string2 = "sudo /usr/bin/docker info";
                        arrayList = APMUtils.executeCmd(string2, false);
                        hashMap.put(string2, arrayList);
                    }
                } else if (new File("/usr/sbin/docker").exists()) {
                    string = "/usr/sbin/";
                    string2 = "/usr/sbin/docker info";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                    if (arrayList == null || arrayList.size() == 0 || arrayList.toString().contains("permission denied")) {
                        string2 = "sudo /usr/sbin/docker info";
                        arrayList = APMUtils.executeCmd(string2, false);
                        hashMap.put(string2, arrayList);
                    }
                } else if (new File("/bin/docker").exists()) {
                    string = "/bin/";
                    string2 = "/bin/docker info";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                    if (arrayList == null || arrayList.size() == 0 || arrayList.toString().contains("permission denied")) {
                        string2 = "sudo /bin/docker info";
                        arrayList = APMUtils.executeCmd(string2, false);
                        hashMap.put(string2, arrayList);
                    }
                } else {
                    hashMap.put("flag", Boolean.valueOf(bl));
                    APMDiscoveryLogger.discoveryLogger.warn("{}  No docker server found, debug log :{}", (Object)loggerDispStr, hashMap);
                    return false;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    hashMap.put("flag", Boolean.valueOf(bl));
                    APMDiscoveryLogger.discoveryLogger.warn("{}  No docker server found, debug log :{}", (Object)loggerDispStr, hashMap);
                    return false;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = ((String)arrayList.get(i)).trim();
                    if (string3 == null || string3.indexOf("Containers:") < 0 && string3.indexOf("Images:") < 0) continue;
                    bl = true;
                    hashMap.put("flag", Boolean.valueOf(bl));
                    hashMap.put("Found Containers: or Images: in resultset", arrayList);
                    break;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occured while checking current server is docker {} :", (Object)loggerDispStr, (Object)exception);
            }
        }
        APMDiscoveryLogger.discoveryLogger.warn("{}  Checking current server is docker : {},debug log : {}", new Object[]{loggerDispStr, bl, hashMap});
        return bl;
    }

    public static boolean isPodmanDaemonRunning() {
        boolean bl;
        HashMap<String, Serializable> hashMap;
        block10: {
            hashMap = new HashMap<String, Serializable>();
            String string = System.getProperty("os.name").toLowerCase();
            bl = false;
            try {
                ArrayList arrayList = null;
                String string2 = "";
                if (!APMUtils.isLinux()) break block10;
                if (new File("/usr/bin/podman").exists()) {
                    string2 = "/usr/bin/podman images";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                    if (arrayList == null || arrayList.size() == 0) {
                        string2 = "sudo /usr/bin/podman images";
                        arrayList = APMUtils.executeCmd(string2, false);
                        hashMap.put(string2, arrayList);
                    }
                } else if (new File("/var/run/podman").exists()) {
                    string2 = "podman images";
                    arrayList = APMUtils.executeCmd(string2, false);
                    hashMap.put(string2, arrayList);
                    if (arrayList == null || arrayList.size() == 0) {
                        string2 = "sudo podman images";
                        arrayList = APMUtils.executeCmd(string2, false);
                        hashMap.put(string2, arrayList);
                    }
                } else {
                    hashMap.put("flag", Boolean.valueOf(bl));
                    APMDiscoveryLogger.discoveryLogger.warn("{} podman is not available, debug log : {}", (Object)loggerDispStr, hashMap);
                    return false;
                }
                if (arrayList == null || arrayList.size() == 0 || arrayList.size() == 1) {
                    hashMap.put("flag", Boolean.valueOf(bl));
                    APMDiscoveryLogger.discoveryLogger.warn("{} podman is not available, debug log : {}", (Object)loggerDispStr, hashMap);
                    return false;
                }
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string3 = ((String)arrayList.get(i)).trim();
                    if (string3 == null || string3.toLowerCase().indexOf("image") < 0 || n <= i + 1) continue;
                    bl = true;
                    hashMap.put("flag", Boolean.valueOf(bl));
                    hashMap.put("Found image in resultset", arrayList);
                    break;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occured in podman while checking current server is podman :{} ", (Object)loggerDispStr, (Object)exception);
                exception.printStackTrace();
            }
        }
        APMDiscoveryLogger.discoveryLogger.warn("{} Checking current server is podman {}, debug log :{}", new Object[]{loggerDispStr, bl, hashMap});
        return bl;
    }

    public static String getEgPayloadDataAsJsonString(Hashtable hashtable, String string, HashMap hashMap, HashMap hashMap2, String string2) {
        if (hashtable != null) {
            try {
                String[] stringArray;
                String string3;
                APMDiscoveryLogger.discoveryLogger.trace("{} {} DD data  of container [{}]: {}, containerIdWithAppNameTierName : {} ", new Object[]{loggerDispStr, string, string2, hashtable, hashMap2});
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                boolean bl = false;
                boolean bl2 = false;
                if (string2 != null && hashMap2 != null && hashMap2.size() > 0 && (string3 = (String)hashMap2.get(string2)) != null && string3.length() > 0 && (stringArray = string3.split(":")).length == 2) {
                    String string4;
                    String string5 = stringArray[0];
                    if (!(string5 == null || string5.length() <= 0 || string5.equalsIgnoreCase("none") || string5.equalsIgnoreCase("MyApp") || string5.equalsIgnoreCase("null"))) {
                        hashMap.put("eG-ServiceName", string5);
                        bl = true;
                    }
                    if (!((string4 = stringArray[1]) == null || string4.length() <= 0 || string4.equalsIgnoreCase("none") || string4.equalsIgnoreCase("MyTier") || string4.equalsIgnoreCase("null"))) {
                        hashMap.put("eG-GroupName", string4);
                        bl2 = true;
                    }
                    APMDiscoveryLogger.discoveryLogger.trace("{} {} [{}]: app name/tier name from container -javaagent/env options : {}:{} ", new Object[]{loggerDispStr, string, string2, string5, string4});
                }
                if (!bl) {
                    hashMap.put("eG-ServiceName", (String)hashtable.get("eG-ServiceName"));
                }
                if (!bl2) {
                    hashMap.put("eG-GroupName", (String)hashtable.get("eG-GroupName"));
                }
                hashMap.put("eG-K8sClusterName", (String)hashtable.get("eG-K8sClusterName"));
                hashMap.put("nameSpace", (String)hashtable.get("nameSpace"));
                hashMap.put("serviceName", (String)hashtable.get("serviceName"));
                hashMap.put("deploymentName", (String)hashtable.get("deploymentName"));
                hashMap.put("eG-AccountId", (String)hashtable.get("eG-AccountId"));
                return APMUtils.getAsJsonString(hashMap);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while converting to json {} :", (Object)loggerDispStr, (Object)exception);
            }
        }
        return "{}";
    }

    public static void updateEgPayloadData(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable2 == null || hashtable == null) {
            return;
        }
        try {
            hashtable.put("eG-ServiceName", hashtable2.get("eG-ServiceName") + "");
            hashtable.put("eG-GroupName", hashtable2.get("eG-GroupName") + "");
            hashtable.put("eG-K8sClusterName", hashtable2.get("eG-K8sClusterName") + "");
            hashtable.put("eG-AccountId", hashtable2.get("eG-AccountId") + "");
            hashtable.put("deploymentName", hashtable2.get("deploymentName") + "");
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while extracing payload data {} :", (Object)loggerDispStr, (Object)exception);
        }
    }

    public static void updateEnv(Hashtable hashtable, ArrayList arrayList) {
        String string;
        String string2 = (String)hashtable.get("eG-ServiceName");
        if (string2 != null && string2.equalsIgnoreCase("none")) {
            ContainerUtils.extractEgEnvDetailsFromPod(hashtable, arrayList, "eG-ServiceName", "EG_SERVICE_NAME");
        }
        if ((string = (String)hashtable.get("eG-GroupName")) != null && string.equalsIgnoreCase("none")) {
            ContainerUtils.extractEgEnvDetailsFromPod(hashtable, arrayList, "eG-GroupName", "EG_GROUP_NAME");
        }
        ContainerUtils.extractEgEnvDetailsFromAgent(hashtable, arrayList, "eG-K8sClusterName", "EG_KUBERNETES_CLUSTER_NAME");
        ContainerUtils.extractEgEnvDetailsFromAgent(hashtable, arrayList, "eG-AccountId", "EG_AGENT_IDENTIFIER_ID");
    }

    public static void extractEgEnvDetailsFromPod(Hashtable hashtable, ArrayList arrayList, String string, String string2) {
        try {
            String string3 = ContainerUtils.getContainerEnv(arrayList, string2);
            if (string3 != null) {
                hashtable.put(string, string3);
            } else {
                hashtable.put(string, "none");
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeContainerInfo(HashMap hashMap) {
        IniFile iniFile = EgApmFilesSync.getInstance((String)(EgInstallInfo.getInstallDir() + "/agent/logs/eg_metadata.ini"), (boolean)true);
        boolean bl = false;
        try {
            String string = (String)hashMap.get("containerID");
            if (string != null && string.length() > 0) {
                String string2 = iniFile.getValue("K8S_CONTAINER_META", string);
                String string3 = hashMap.toString();
                if (string3 != null && string3.length() > 0 && !(bl = string3.equalsIgnoreCase(string2))) {
                    iniFile.setValue("K8S_CONTAINER_META", string, string3);
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} - Exception occurs while storing container meta data : {}", (Object)"DockerContainerStTest_DD", (Object)exception);
        }
        finally {
            if (!bl) {
                iniFile.saveFile();
            }
            EgApmFilesSync.releaseInstance((IniFile)iniFile);
        }
    }

    public static void extractEgEnvDetailsFromAgent(Hashtable hashtable, ArrayList arrayList, String string, String string2) {
        try {
            String string3 = ContainerUtils.getAgentEnv(string2);
            if (string3 != null) {
                hashtable.put(string, string3);
            } else {
                hashtable.put(string, "none");
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
    }

    public static String getAgentNick() {
        String string = null;
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_nick.ini");
        try {
            string = iniFile.getValue("NICKNAME", "Nick");
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return string;
    }

    private static String getContainerEnv(ArrayList arrayList, String string) {
        try {
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = arrayList.get(i).toString();
                    if (string2.indexOf(string) < 0 || string2.indexOf("=") <= 0) continue;
                    return string2.split("=")[1];
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return null;
    }

    public static String getAgentEnv(String string) {
        try {
            String string2;
            if (string != null && string.length() > 0 && (string2 = System.getenv(string)) != null && string2.length() > 0) {
                return string2;
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return null;
    }

    public static String getContainerEnv(Hashtable hashtable, String string) {
        try {
            if (hashtable != null && hashtable.containsKey("ContainerEnv")) {
                ArrayList arrayList = (ArrayList)hashtable.get("ContainerEnv");
                AgentLogger.discoveryLogger.trace("{} ContainerEnv : ", (Object)logDispStr, (Object)arrayList);
                if (arrayList != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string2 = arrayList.get(i).toString();
                        if (string2.indexOf(string) < 0 || string2.indexOf("=") <= 0) continue;
                        AgentLogger.discoveryLogger.debug("{} ContainerEnv key : {}, result value : ", new Object[]{logDispStr, string, string2.split("=")[1]});
                        return string2.split("=")[1];
                    }
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return null;
    }

    public static String trimTo12Char(String string) {
        if (string != null && string.length() >= 12) {
            string = string.substring(0, 12);
        }
        return string;
    }

    public static void discoverSpecInfo(KubernetesAPI kubernetesAPI, Hashtable hashtable, String string) {
        if (hashtable == null) {
            return;
        }
        if (kubernetesAPI == null) {
            kubernetesAPI = KubernetesAPI.createInstance();
        }
        try {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(hashtable);
            ContainerUtils.getSpecInfo(kubernetesAPI, concurrentHashMap, "nameSpace", "podName", string);
            hashtable.putAll(concurrentHashMap);
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} discoverSpecInfo() exception {} ", (Object)logDispStr, (Object)exception);
        }
    }

    public static void getSpecInfo(KubernetesAPI kubernetesAPI, ConcurrentHashMap concurrentHashMap, String string, String string2, String string3) {
        if (concurrentHashMap == null) {
            return;
        }
        Iterator iterator = concurrentHashMap.entrySet().iterator();
        HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string4 = (String)entry.getKey();
                Hashtable hashtable = (Hashtable)entry.getValue();
                String string5 = (String)hashtable.get(string);
                String string6 = (String)hashtable.get(string2);
                if (string6 == null || string5 == null) continue;
                if (kubernetesAPI == null) {
                    kubernetesAPI = KubernetesAPI.createInstance();
                }
                HashMap hashMap2 = null;
                boolean bl = false;
                HashMap hashMap3 = ContainerDataRepo.getContainerSpecInfo((String)string3);
                String string7 = string5 + "|" + string6;
                if (hashMap3 != null && hashMap3.containsKey(string7)) {
                    hashMap2 = (HashMap)hashMap3.get(string7);
                } else {
                    hashMap2 = kubernetesAPI.getContainerInfoFromPod(string5, string6);
                    bl = true;
                }
                if (hashMap2 == null || hashMap2.isEmpty()) continue;
                hashtable.putAll(hashMap2);
                if (!bl) continue;
                hashMap.put(string7, hashMap2);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)logDispStr, (Object)exception);
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            ContainerDataRepo.updateContainerSpecInfo((String)string3, hashMap);
        }
        ContainerDataRepo.cleanUpContainerSpecInfo((String)string3);
        if (AgentLogger.discoveryLogger.isTraceEnabled()) {
            AgentLogger.discoveryLogger.trace("apiData: {}", hashMap);
            AgentLogger.discoveryLogger.trace("getContainerSpecInfo(): {}", (Object)ContainerDataRepo.getContainerSpecInfo());
        }
    }

    public static HashMap getAppNameTierNameInputsOfContainers() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_apmdiscovery.ini");
        try {
            String[] stringArray = iniFile.getLinesUnderSubject("APPFLOW_SERVICE_AUTO_NAME_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    int n = string.indexOf("=");
                    if (n < 0) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    String string4 = string2.trim();
                    int n2 = string4.indexOf(":");
                    if (n2 < 0) continue;
                    string4 = string4.substring(0, n2);
                    hashMap.put(string4, string3.trim());
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred in getLinesAsMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public static String getMaskedToken(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() > 30) {
            String string2 = string.substring(0, 10) + "***********" + string.substring(string.length() - 10);
            return string2;
        }
        return string;
    }
}

