/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMConfigUtils;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMWorkerHelper;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.Component;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.Status;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.PropsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentWatcher
extends TimerTask {
    private static final String loggerDispStr = "[ComponentWatcher]";
    private static final HashMap<String, HashMap> previousTable = new HashMap();
    private long lastModifiedTime = -1L;
    String egApmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.agentConfigPath + "eg_apm.ini";
    EgAgentInfo egApmIniInfo = new EgAgentInfo("agent", this.egApmIniFile);
    private boolean isFirstTime = true;
    private boolean prepareCpcData = true;
    private boolean doReadForDeletedComponent = false;
    boolean isEgApmIniModified = false;
    private long lastHeartBeatTimeCheck = -1L;
    private static final HashMap<APMLanguage, ArrayList<String>> apmOffloadTests = new HashMap();
    private static final HashMap<String, APMLanguage> languageMap = new HashMap();

    @Override
    public void run() {
        try {
            if (ApmDemoInfo.isDemoMode() && ApmDemoInfo.checkForUpdate()) {
                ApmConfigManager.getInstance().updateDemoConfigs();
            }
            ApmConfigManager.getInstance().checkForUpdate();
            if (!ApmConfigManager.getInstance().isAPMMonitoringEnabled()) {
                return;
            }
            this.isEgApmIniModified = this.egApmIniInfo.checkForUpdate();
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isEgApmIniModified : {}", (Object)loggerDispStr, (Object)this.isEgApmIniModified);
            APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
            try {
                this.componentWatcher(aPMComponentIDRepository);
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do component watcher tracker : {} ", (Object)loggerDispStr, (Object)exception);
            }
            try {
                this.getCPCData();
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get Custom BTM configuration from eg_apm.ini : {}", (Object)loggerDispStr, (Object)exception);
            }
            try {
                boolean bl = ApmConfigManager.getInstance().isCleanUpEnabled();
                if (bl) {
                    APMCleanUpUtils aPMCleanUpUtils = new APMCleanUpUtils();
                    aPMCleanUpUtils.initCleanUpProcess(this.isEgApmIniModified);
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do ini clean up process {}", (Object)loggerDispStr, (Object)exception);
            }
            this.isFirstTime = false;
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do component watcher tracker : {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private HashMap computeCpcdata(String string, HashMap hashMap, boolean bl) {
        String[] stringArray = this.egApmIniInfo.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            List<String> list = Arrays.asList(stringArray);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Offload CPC components from eg_apm.ini :  {} ", (Object)loggerDispStr, list);
            for (int i = 0; i < list.size(); ++i) {
                HashMap hashMap2;
                String string2 = list.get(i);
                string2 = string2 != null ? string2 : "";
                String[] stringArray2 = string2.split(":");
                if (stringArray2 == null || stringArray2.length != 3) continue;
                String string3 = stringArray2[0];
                String string4 = stringArray2[1];
                String string5 = stringArray2[2];
                String string6 = string3 + ":" + string4;
                if (!APMComponentIDRepository.getRepository().isSiteIdAvailable(string6)) continue;
                String string7 = this.egApmIniInfo.getValue(string, string2);
                String string8 = string7 = string7 != null ? string7 : "";
                if (bl) {
                    string7 = string5 + "#B=" + string7;
                } else {
                    int n = 1;
                    if (hashMap.containsKey(string6)) {
                        hashMap2 = (HashMap)hashMap.get(string6);
                        n = hashMap2.size();
                    }
                    string7 = "CPC" + n + "#KB=" + string7;
                }
                HashMap hashMap3 = this.parseCpcData(string7);
                if (hashMap.containsKey(string6)) {
                    hashMap2 = (HashMap)hashMap.get(string6);
                    hashMap2.putAll(hashMap3);
                    hashMap.put(string6, hashMap2);
                    continue;
                }
                hashMap.put(string6, hashMap3);
            }
        }
        return hashMap;
    }

    private void getCPCData() {
        try {
            if (this.isEgApmIniModified || this.isFirstTime || this.prepareCpcData) {
                HashMap hashMap = new HashMap();
                String string = "CUSTOM_PATTERN_CONFIGURATION_BT";
                hashMap = this.computeCpcdata(string, hashMap, true);
                string = "CUSTOM_PATTERN_CONFIGURATION_KBT";
                hashMap = this.computeCpcdata(string, hashMap, false);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  fullCPCData : {}", (Object)loggerDispStr, (Object)hashMap);
                if (hashMap.size() > 0) {
                    this.setCpcTable(hashMap);
                }
                this.checkForDeletedComponents();
                this.prepareCpcData = false;
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get Custom BTM configuration from eg_apm.ini : {} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void heartBeatCheck(EgAgentInfo egAgentInfo) {
        try {
            boolean bl = false;
            long l = System.currentTimeMillis();
            if (this.lastHeartBeatTimeCheck > 0L) {
                long l2 = l - this.lastHeartBeatTimeCheck;
                if (l2 > 300000L) {
                    bl = true;
                    this.lastHeartBeatTimeCheck = l;
                }
            } else {
                this.lastHeartBeatTimeCheck = l;
                bl = true;
            }
            if (bl) {
                ConcurrentHashMap concurrentHashMap = APMComponentIDRepository.getRepository().getComponentRepository();
                for (Map.Entry entry : concurrentHashMap.entrySet()) {
                    String string = (String)entry.getKey();
                    if (string != null && string.startsWith("DISCOVER_ME_")) continue;
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing heartbeat check for : {}", (Object)loggerDispStr, (Object)string);
                    APMComponent aPMComponent = APMComponentIDRepository.getRepository().getAPMComponent(string);
                    if (aPMComponent == null) continue;
                    this.checkAutoUnmanage(aPMComponent);
                    this.prepareConfigs(aPMComponent, egAgentInfo);
                }
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do heartbeat time check BTM : {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void prepareConfigs(APMComponent aPMComponent, EgAgentInfo egAgentInfo) {
        if (aPMComponent.isPrepareJvmTestConfigs()) {
            JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing jvm test configs for {} - {}", new Object[]{loggerDispStr, aPMComponent.getID(), aPMComponent.getNickWithPort()});
            this.getEnabledTestsAndConfigsFromIni(aPMComponent, egAgentInfo, true, false);
            aPMComponent.setPrepareJvmTestConfigs(false);
        }
        if (aPMComponent.isPrepareCpcConfigs()) {
            JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing cpc configs for {} - {}", new Object[]{loggerDispStr, aPMComponent.getID(), aPMComponent.getNickWithPort()});
            this.prepareCpcData = true;
            aPMComponent.setPrepareCpcConfigs(false);
        }
    }

    private void setCpcTable(HashMap hashMap) {
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            HashMap hashMap2 = (HashMap)entry.getValue();
            APMComponent aPMComponent = APMComponentIDRepository.getRepository().getAPMComponent(string);
            if (aPMComponent == null) continue;
            aPMComponent.setCPCPatternMap(hashMap2);
        }
    }

    private void checkForDeletedComponents() {
        ConcurrentHashMap concurrentHashMap = APMComponentIDRepository.getRepository().getComponentRepository();
        for (Map.Entry entry : concurrentHashMap.entrySet()) {
            String string = (String)entry.getKey();
            APMComponent aPMComponent = APMComponentIDRepository.getRepository().getAPMComponent(string);
            HashMap hashMap = aPMComponent.getCPCPatternMap(Component.DEFAULT_WORKER_ID, Component.DEFAULT_WORKER_ID);
            if (hashMap != null) continue;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("cpcInfo", "cpcInfo");
            aPMComponent.setCPCPatternMap(hashMap);
        }
    }

    private HashMap parseCpcData(String string) {
        String[] stringArray;
        HashMap hashMap = new HashMap();
        if (string != null && string.length() > 0 && string != null && string.length() > 0 && (stringArray = string.split(",")) != null && stringArray.length > 0) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() <= 0) continue;
                String string3 = string2.substring(0, string2.indexOf("=")).trim();
                String string4 = string2.substring(string2.indexOf("=") + 1).trim();
                if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                hashMap2.put(string3, string4);
            }
            if (hashMap2 != null && hashMap2.size() > 0) {
                hashMap.putAll(hashMap2);
                hashMap.put("cpcInfo", "cpcInfo");
            }
        }
        return hashMap;
    }

    private void updateOffLoadTestDetails(APMLanguage aPMLanguage, String string) {
        if (apmOffloadTests.containsKey(aPMLanguage)) {
            ArrayList<String> arrayList = apmOffloadTests.get(aPMLanguage);
            arrayList.add(string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            apmOffloadTests.put(aPMLanguage, arrayList);
        }
    }

    private void getOffloadTestsByLanguage(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        apmOffloadTests.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            int n = string.indexOf("=");
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            boolean bl = false;
            int n2 = string3.indexOf(",");
            if (n2 > 0) {
                object = new StringTokenizer(string3, ",");
                int n3 = ((StringTokenizer)object).countTokens();
                for (int j = 0; j < n3; ++j) {
                    String string4 = ((StringTokenizer)object).nextToken();
                    APMLanguage aPMLanguage = languageMap.get(string4);
                    if (aPMLanguage == null) continue;
                    this.updateOffLoadTestDetails(aPMLanguage, string2);
                    bl = true;
                }
            } else {
                object = languageMap.get(string3);
                if (object == null) continue;
                this.updateOffLoadTestDetails((APMLanguage)object, string2);
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(string2);
        }
    }

    private void getOffloadTestNamesFromIni() {
        try {
            String[] stringArray;
            if ((this.isEgApmIniModified || this.isFirstTime) && (stringArray = this.egApmIniInfo.getLinesUnderSubject("OFFLOAD_SUPPORTING_TEST_NAMES")) != null && stringArray.length > 0) {
                this.getOffloadTestsByLanguage(stringArray);
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} unable to get offloadtestnames from eg_apm.Ini {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void componentWatcher(APMComponentIDRepository aPMComponentIDRepository) {
        int n = aPMComponentIDRepository.getComponentRepository().size();
        if (n == 0) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} APM Component repository is empty.", (Object)loggerDispStr);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        EgAgentInfo egAgentInfo = new EgAgentInfo("agent");
        long l = egAgentInfo.lastModified();
        if (this.lastModifiedTime > -1L) {
            if (l != this.lastModifiedTime) {
                bl2 = true;
                this.lastModifiedTime = l;
            }
        } else {
            this.lastModifiedTime = l;
            bl2 = true;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isAgentsIniModified : {}", (Object)loggerDispStr, (Object)bl2);
        if (bl2 || this.isFirstTime) {
            this.getOffloadTestNamesFromIni();
            if (JavaBTMOffloadLogger.btmOffLoadLogger.isTraceEnabled()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} eg_agents.ini is modified {} ", (Object)loggerDispStr, (Object)l);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isFirstTime : {}", (Object)loggerDispStr, (Object)this.isFirstTime);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} offloadTestNames : {}", (Object)loggerDispStr, apmOffloadTests);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} ComponentIDTable : {}", (Object)loggerDispStr, (Object)aPMComponentIDRepository.getComponentRepository());
            }
            if (apmOffloadTests == null || apmOffloadTests.isEmpty()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} offloadTestNames is null or empty, trying to read offloadTestNames from eg_apm.ini", (Object)loggerDispStr);
                this.isEgApmIniModified = true;
                this.getOffloadTestNamesFromIni();
            }
            if (apmOffloadTests == null || apmOffloadTests.isEmpty()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} offloadTestNames is null or empty, Skipping further processes of ComponentWatcher Tracker ", (Object)loggerDispStr);
                return;
            }
            ConcurrentHashMap concurrentHashMap = aPMComponentIDRepository.getComponentRepository();
            for (Map.Entry entry : concurrentHashMap.entrySet()) {
                String string = (String)entry.getKey();
                if (string != null && string.startsWith("DISCOVER_ME_")) continue;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing Component tracker task for : {}", (Object)loggerDispStr, (Object)string);
                APMComponent aPMComponent = aPMComponentIDRepository.getAPMComponent(string);
                if (aPMComponent == null) continue;
                this.checkAutoUnmanage(aPMComponent);
                bl = true;
                this.getEnabledTestsAndConfigsFromIni(aPMComponent, egAgentInfo, bl2, true);
            }
            this.doReadForDeletedComponent = false;
        }
        if (!bl) {
            this.heartBeatCheck(egAgentInfo);
        }
    }

    private String[] getOffLoadTestsByLanguage(APMLanguage aPMLanguage) {
        String[] stringArray = null;
        ArrayList<String> arrayList = apmOffloadTests.get(aPMLanguage);
        if (arrayList != null) {
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    private void getEnabledTestsAndConfigsFromIni(APMComponent aPMComponent, EgAgentInfo egAgentInfo, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (aPMComponent.isComponentOrEntityStatus()) {
            bl3 = true;
        }
        String string = aPMComponent.getNickName();
        String string2 = aPMComponent.getHostPort();
        APMLanguage aPMLanguage = aPMComponent.getAPMLanguage();
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} doReadForDeletedCommonent : {}", (Object)loggerDispStr, (Object)this.doReadForDeletedComponent);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} doReadForNewComponent : {}", (Object)loggerDispStr, (Object)bl3);
        if (bl || bl3 || this.doReadForDeletedComponent) {
            String[] stringArray;
            String[] stringArray2 = egAgentInfo.getTestsForTarget(string, "offload");
            if (stringArray2 == null) {
                stringArray = this.getOffLoadTestsByLanguage(aPMLanguage);
                String string3 = egAgentInfo.getSubjectForThisCompoent(string, string2, stringArray);
                if (string3 == null) {
                    String string4 = aPMComponent.getID();
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} SECTION not found in eg_agents.ini {} - {}", new Object[]{loggerDispStr, string, string3});
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} SECTION not found in eg_agents.ini for {}. Marking as unmanaged component and removed from respository ", (Object)loggerDispStr, (Object)string4);
                    APMConfigUtils.getInstance().processApmConfigIni(string4, true, "delete_all", aPMLanguage, "agent");
                    APMComponentIDRepository.getRepository().unRegisterComponent(string4, false, false);
                    this.doReadForDeletedComponent = true;
                    return;
                }
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} SECTION found in eg_agents.ini for {} - {}", new Object[]{loggerDispStr, string, string3});
                stringArray2 = egAgentInfo.getTestsForTarget(string3, "offload");
            }
            stringArray = egAgentInfo.getTests(stringArray2, "offload");
            this.updateTestConfigs(aPMComponent, stringArray2, stringArray, false, bl2);
            APMWorkerHelper.getInstance().clearRepository(aPMComponent);
            if (bl3) {
                aPMComponent.changeComponentOrEntityStatus();
            }
        }
    }

    private void updateInfraTestConfig(String string, String string2, HashMap<String, String> hashMap, HashMap hashMap2, boolean bl) {
        if (string2.startsWith("Jvm")) {
            String string3;
            boolean bl2 = false;
            try {
                string3 = hashMap.get("metric_collection_type");
                if (string3 != null && string3.equalsIgnoreCase("false")) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("Exception while finding metric_collection_mode for the {} and entity {} - {}", new Object[]{string, string2, exception.getMessage()});
            }
            if (bl2) {
                if (string2.equalsIgnoreCase("JvmMemoryDetailsTest")) {
                    string3 = hashMap.get("Heap_Analysis");
                    String string4 = hashMap.get("Java_Home");
                    if (string3 != null) {
                        hashMap2.put("Heap_Analysis", string3);
                    }
                    if (string4 != null) {
                        hashMap2.put("Heap_Analysis", string3);
                    }
                } else if (string2.equalsIgnoreCase("JvmThreadTest")) {
                    string3 = "-1";
                    hashMap2.put("Thread_Dump_Limit", string3);
                    String string5 = hashMap.get("Thread_Dump_Limit");
                    try {
                        int n = Integer.parseInt(string5);
                        hashMap2.put("Thread_Dump_Limit", string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hashMap2.put("JVM_METRIC_COLLECTION", "true");
            } else {
                hashMap2.put("JVM_METRIC_COLLECTION", "false");
            }
            string3 = hashMap.get("agentless");
            if (string3 != null && string3.length() > 0 && string3.equalsIgnoreCase("y")) {
                bl = true;
                hashMap2.put("isAgentLess", "true");
            } else {
                hashMap2.put("isAgentLess", "false");
            }
        }
    }

    private void updateTestConfigs(APMComponent aPMComponent, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = apmOffloadTests.get(aPMComponent.getAPMLanguage());
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        String string = aPMComponent.getHostPort();
        String string2 = aPMComponent.getNickName();
        List<String> list = Arrays.asList(stringArray2);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Enabled agents tests with port:  {}", (Object)loggerDispStr, list);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = aPMComponent.getID();
        APMLanguage aPMLanguage = aPMComponent.getAPMLanguage();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string4 = arrayList.get(i);
            String string5 = string4 + "_" + string;
            boolean bl3 = false;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                boolean bl4;
                String string6 = list.get(j);
                if (string6 == null || !string5.equalsIgnoreCase(string6)) continue;
                String string7 = stringArray[j];
                HashMap hashMap2 = this.getFullConfigs(string7, string4);
                String string8 = (String)hashMap2.get("egMeasPeriod");
                String string9 = (String)hashMap2.get("rptName");
                String string10 = (String)hashMap2.get("port");
                boolean bl5 = bl4 = string9 != null && string9.equalsIgnoreCase(string2) && string10 != null && string10.equalsIgnoreCase(string);
                if (!bl4) continue;
                if (string8 != null) {
                    hashMap.put(string4, "true");
                    hashMap.put(string4 + "Frequency", string8);
                }
                bl3 = true;
                if (aPMLanguage == APMLanguage.JAVA) {
                    this.updateInfraTestConfig(string3, string4, hashMap2, hashMap, bl);
                } else if (aPMLanguage == APMLanguage.NODEJS) {
                    this.updateInfraTestConfig(string3, string4, hashMap2, hashMap, bl);
                }
                APMComponentIDRepository.getRepository().registerComponent(string3, string4, aPMLanguage);
            }
            if (bl3) continue;
            aPMComponent.removeEntity(string4);
            hashMap.put(string4, "false");
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Offload test config:- compareWithPreviousData - {} ", (Object)loggerDispStr, (Object)bl2);
        if (hashMap.size() > 0) {
            HashMap hashMap3 = new HashMap(hashMap);
            previousTable.put(string3, hashMap3);
            hashMap.put("JVMTestsInfo", "JVMTestsInfo");
            aPMComponent.setInfraTestConfig(hashMap);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Current JVM Configuration for ({}) : {}", new Object[]{loggerDispStr, string3, aPMComponent.getInfraTestConfig()});
    }

    private HashMap getFullConfigs(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string.substring(string.indexOf("-host") + 1, string.lastIndexOf(","));
        string3 = string3.replace("   ", " ");
        string3 = string3.replace("  ", " ");
        String[] stringArray = string3.split(" -");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(" ");
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    private void checkAutoUnmanage(APMComponent aPMComponent) {
        long l = System.currentTimeMillis();
        boolean bl = aPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
        long l2 = aPMComponent.getHeartBeatTime();
        long l3 = System.currentTimeMillis() - l2;
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} lastHeartBeatTime :{} , currenTime :{} ,diffs :{}", new Object[]{loggerDispStr, l2, l, l3});
        if (l2 < 0L) {
            return;
        }
        PropsManager propsManager = aPMComponent.getPropsManager();
        if (propsManager == null) {
            return;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Measure period for {} :{}", new Object[]{loggerDispStr, aPMComponent.getID(), propsManager.getEgMeasPeriod()});
        if (l3 >= 6L * propsManager.getEgMeasPeriod() && bl) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Doing  BTM repository reset due to no heart beat for a few couple of measure peroid : {} ", (Object)loggerDispStr, (Object)aPMComponent.getID());
            aPMComponent.setHeartBeatStatus(Status.NO_HEART_BEATING);
            aPMComponent.reset();
        }
    }

    protected static HashMap getModifiedConfig(HashMap hashMap, HashMap hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                if (hashMap2.containsKey(string)) {
                    String string3 = (String)hashMap2.get(string);
                    if (string2.equals(string3)) continue;
                    hashMap3.put(string, string2);
                    continue;
                }
                hashMap3.put(string, string2);
            }
        }
        return hashMap3;
    }

    static {
        languageMap.put("JAVA", APMLanguage.JAVA);
        languageMap.put("NODEJS", APMLanguage.NODEJS);
        languageMap.put("true", APMLanguage.JAVA);
    }
}

