/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.EgIniInfo;
import com.eg.apm.JavaInfo;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.OS;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.sampling.SamplingController;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ApmConfigManager {
    public static final String EG_APM = "[EG_APM]";
    public static final String EG_DISCOVERY = "[EG_DISCOVERY]";
    private IniFile apmFileObj;
    private long lastModifiedTime;
    private long lastSize;
    private static String apmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
    private static final String APM = new String("APM");
    private static final String APM_DISCOVERY = "APM_DISCOVERY";
    private static final String loggerPrefix = "[ApmConfigManager] ";
    private static final String CLEANUP_TIME_UNIT = "CLEANUP_TIME_UNIT";
    private static final String APM_DISCOVERY_INI_CLEANUP = "APM_DISCOVERY_INI_CLEANUP";
    private static final String APM_DISCOVERY_AUTO_DELETE = "APM_DISCOVERY_AUTO_DELETE";
    private static final String DELETE_DURATION_FOR_CONTAINER_APPS = "Delete_Duration_For_Container_Apps";
    private static final String DELETE_DURATION_FOR_NONCONTAINER_APPS = "Delete_Duration_For_NonContainer_Apps";
    private static final String NOTMANAGED_DELETE_THRESHOLD_FOR_CONTAINER_SERVERS = "NOTMANAGED_DELETE_THRESHOLD_FOR_CONTAINER_SERVERS";
    private static final String NOTMANAGED_DELETE_THRESHOLD_FOR_NONCONTAINER_SERVERS = "NOTMANAGED_DELETE_THRESHOLD_FOR_NONCONTAINER_SERVERS";
    private static final String SAVE_DELETED_DETAILS_TO_TEMP_FILE = "SAVE_DELETED_DETAILS_TO_TEMP_FILE";
    private static final String CLEANUP_CHECK_INTERVAL = "CLEANUP_CHECK_INTERVAL";
    private static final String CLEANUP_ENABLED = "CLEANUP_ENABLED";
    private static final String EGAPM_DISCOVERY = "EGAPM_DISCOVERY";
    private static final String SAMPLING_SETTINGS = "SAMPLING_SETTINGS";
    private long discoveryContributorSleepTime = 15000L;
    private long appflowDataContributorSleepTime = 15000L;
    private boolean isAPMMonitoringEnabled = false;
    private boolean isManageByCustomPort = false;
    private boolean isManageByCustomPortForDocker = false;
    private boolean createBTMJarZipFile = false;
    private boolean isSaveDetailsOnTempFile = false;
    private boolean logBigSizeObjects = false;
    private boolean invokeHTTPRequest = false;
    private boolean isStartupDelayEnabledForOffloadPort = true;
    private long startupDelayPeriodForOffloadPort = 30000L;
    private boolean isK8ServiceNameDiscoveryEnabled = true;
    private static final long ONE_MIN = 60000L;
    private static final long FIFTEEN_SECONDS = 15000L;
    private static final long ONE_SEC = 1000L;
    private static long managedComponentsReUploadTime = 21600000L;
    private String cleanupSymbol = "s";
    private boolean isUnitHH = false;
    private boolean isIniCleanUpEnabled = false;
    private long cleanUpInterval = 6L;
    private long maxTimeToDeleteContainerApps = 15L;
    private long maxTimeToDeleteNonContainerApps = 1440L;
    private long notManagedContainerDeleteThreshold = 6L;
    private long notManagedNonContainerDeleteThreshold = 24L;
    private HashMap classNameMapper = null;
    private HashMap systemPropertyNameMapper = null;
    private HashMap executableNameMapper = null;
    private boolean isEgProcessBasedDiscoveryEnabled = false;
    private boolean isJavaProcessDiscoveryEnabled = false;
    private boolean isJavaProcessHandleDiscoveryEnabled = false;
    private boolean isJavaProcessHandleDiscoveryEnabledForContainerZ = false;
    private boolean IsTerminateLeftOverExecProcesses = false;
    private ArrayList executableIncludeList = null;
    private ArrayList executableExcludeList = null;
    private ArrayList cmdLineIncludeList = null;
    private ArrayList cmdLineExcludeList = null;
    private ArrayList javaVersionIncludeList = null;
    private ArrayList javaVersionExcludeList = null;
    private ArrayList systemPropertyExcludeList = null;
    private HashMap serverTypeDeciderPriorityMap = null;
    private final ConcurrentHashMap appDiscoveryPriorityPorts = new ConcurrentHashMap();
    private final ConcurrentHashMap egPortDiscoveryMap = new ConcurrentHashMap();
    private long appDiscoveryExecTimeOut = 500L;
    private String appDiscoverySep = "|";
    private final HashMap<String, EgIniInfo> iniInfo = new HashMap();
    private static ApmConfigManager instance = null;
    private OS osName = OS.NONE;
    private String javaVendor = null;
    private String javaVersion = null;
    private boolean java9Above = false;
    private boolean isAgentDiscoveryEnabled = false;
    private long javaProcessDiscoveryStartupDelay = 60000L;
    private long javaProcessDiscoveryRediscoverPeriod = 900000L;
    private boolean useStartupMbeanBasedDiscovery = true;
    private boolean useRequestBasedDiscovery = false;
    private boolean transmitDiscoveryDataViaAgentDiscovery = false;
    private boolean transmitDiscoveryDataViaEgApmBtmDiscovery = true;
    private boolean transmitContBTMDiscoveryDataViaContainerDDTest = false;
    private boolean transmitContBTMDiscoveryDataViaEgApmBtmDiscovery = true;
    private boolean isNetStatExistsOnLinux = true;
    private boolean isThresholdWriteEnabledToGuidProps = true;
    private boolean isReadBTMThresholdFromGlobalThresholdEnabled = true;

    private ApmConfigManager() {
        this.findOperatingSystem();
        this.findJavaDetails();
        this.init();
    }

    private void findJavaDetails() {
        this.javaVendor = JavaInfo.getJavaVendor();
        this.javaVersion = JavaInfo.getJavaVersionString();
        this.java9Above = JavaInfo.getJavaVersion().isJava9Higher();
    }

    private void findOperatingSystem() {
        String string = System.getProperty("os.name");
        boolean bl = string.equalsIgnoreCase("LINUX");
        boolean bl2 = string.equalsIgnoreCase("SUNOS");
        boolean bl3 = string.equalsIgnoreCase("WINDOWS") || string.toLowerCase().indexOf("win") >= 0;
        boolean bl4 = string.equalsIgnoreCase("HP-UX") || string.equalsIgnoreCase("HPUX") || string.startsWith("HP");
        boolean bl5 = string.equalsIgnoreCase("AIX");
        if (bl3) {
            this.osName = OS.WINDOWS;
            return;
        }
        if (bl) {
            this.osName = OS.LINUX;
            return;
        }
        if (bl2) {
            this.osName = OS.SOLARIS;
            return;
        }
        if (bl4) {
            this.osName = OS.HPUX;
            return;
        }
        if (bl5) {
            this.osName = OS.AIX;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApmConfigManager getInstance() {
        if (instance != null) return instance;
        Class<ApmConfigManager> clazz = ApmConfigManager.class;
        synchronized (ApmConfigManager.class) {
            if (instance != null) return instance;
            instance = new ApmConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        this.decideApmIniConfigLocation();
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.apmFileObj = new IniFile(apmIniFile);
        this.updateConfigs();
        if (ApmDemoInfo.isDemoMode((boolean)true)) {
            ApmDemoInfo.initDemoMode();
            this.updateDemoConfigs();
        }
        this.printConfigs();
        if (this.osName != OS.WINDOWS) {
            this.setNetStatExistsOnLinux();
        }
    }

    private void decideApmIniConfigLocation() {
        try {
            File file = new File(BTMConstants.SELF_APM_INI);
            if (file.exists() && file.canRead()) {
                apmIniFile = BTMConstants.SELF_APM_INI;
                APMDiscoveryLogger.discoveryLogger.warn("{} {} Self config available, Loading self configs from : {} ", new Object[]{loggerPrefix, "[EG_EVENT_INFO]", apmIniFile});
            } else {
                apmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
            }
        }
        catch (Exception exception) {
            apmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to locate self eg_apm.ini file path", (Object)loggerPrefix, (Object)exception);
        }
    }

    private void printConfigs() {
        if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled()) {
            APMDiscoveryLogger.discoveryLogger.info(" {} Configs loaded from  {} ", (Object)loggerPrefix, (Object)this.apmFileObj.fileName);
            APMDiscoveryLogger.discoveryLogger.info(" {} Java vendor : {} {}, isJava9Higher : {} ", new Object[]{loggerPrefix, this.javaVendor, this.javaVersion, this.java9Above});
            APMDiscoveryLogger.discoveryLogger.info(" {} isApmMonitoringEnabled : {}, discoveryContributorSleepTime : {}, appflowDataContributorSleepTime : {}, useCustomPortsToManage : {}, useCustomPortsToManageDockerComponents : {}, createBTMJarZipFile : {}", new Object[]{loggerPrefix, this.isAPMMonitoringEnabled, this.discoveryContributorSleepTime, this.appflowDataContributorSleepTime, this.isManageByCustomPort, this.isManageByCustomPortForDocker, this.createBTMJarZipFile});
            APMDiscoveryLogger.discoveryLogger.info(" {} isIniCleanUpEnabled : {}, isSaveDetailsOnTempFile : {}, cleanupSymbol : {}, isUnitHH : {} , cleanUpInterval : {}, deleteDurationContainerApps : {}, deleteDurationNonContainerApps : {}, notManagedContainerDeleteThreshold : {}, notManagedNonContainerDeleteThreshold : {} ", new Object[]{loggerPrefix, this.isIniCleanUpEnabled, this.isSaveDetailsOnTempFile, this.cleanupSymbol, this.isUnitHH, this.cleanUpInterval, this.maxTimeToDeleteContainerApps, this.maxTimeToDeleteNonContainerApps, this.notManagedContainerDeleteThreshold, this.notManagedNonContainerDeleteThreshold});
            APMDiscoveryLogger.discoveryLogger.info(" {} managedComponentsReUploadTime : {}, logBigSizeObjects : {} ", new Object[]{loggerPrefix, managedComponentsReUploadTime, this.logBigSizeObjects});
            APMDiscoveryLogger.discoveryLogger.info(" {} isManualHttpReqEnabledForBTMDiscovery : {}, isKubernetesServiceNameDiscoveryEnabled : {}", new Object[]{loggerPrefix, this.invokeHTTPRequest, this.isK8ServiceNameDiscoveryEnabled});
            APMDiscoveryLogger.discoveryLogger.info(" {} isBtmOffloadPortStartupDelayEnabled : {}, btmOffloadPortStartupDelayPeriod : {}", new Object[]{loggerPrefix, this.isStartupDelayEnabledForOffloadPort, this.startupDelayPeriodForOffloadPort});
            APMDiscoveryLogger.discoveryLogger.info(" {} Ini file tracker obj : {}, ", (Object)loggerPrefix, this.iniInfo);
            APMDiscoveryLogger.discoveryLogger.info(" {} transmitDiscoveryDataViaEgApmBtmDiscovery : {}, transmitDiscoveryDataViaAgentDiscovery : {}, transmitContBTMDiscoveryDataViaContainerDDTest : {}, transmitContBTMDiscoveryDataViaEgApmBtmDiscovery : {}", new Object[]{loggerPrefix, this.transmitDiscoveryDataViaEgApmBtmDiscovery, this.transmitDiscoveryDataViaAgentDiscovery, this.transmitContBTMDiscoveryDataViaContainerDDTest, this.transmitContBTMDiscoveryDataViaEgApmBtmDiscovery});
            APMDiscoveryLogger.discoveryLogger.info(" {} useStartupMbeanBasedDiscovery : {}, useRequestBasedDiscovery : {}", new Object[]{loggerPrefix, this.useStartupMbeanBasedDiscovery, this.useRequestBasedDiscovery});
            APMDiscoveryLogger.discoveryLogger.info(" {} isThresholdWriteEnabledToGuidProps : {}, isNetStatExistsOnLinux : {}, isReadBTMThresholdFromGlobalThresholdEnabled : {}", new Object[]{loggerPrefix, this.isThresholdWriteEnabledToGuidProps, this.isNetStatExistsOnLinux, this.isReadBTMThresholdFromGlobalThresholdEnabled});
            APMDiscoveryLogger.discoveryLogger.info(" {} [ENVIRONMENT VALUES]  EG_FULL_DEBUG_ON : {} ", (Object)loggerPrefix, (Object)System.getenv("EG_FULL_DEBUG_ON"));
            this.printConfigsFromAgentTestsIni();
            this.printConfigsOfAppDiscovery();
        }
    }

    private void printConfigsFromAgentTestsIni() {
        APMDiscoveryLogger.discoveryLogger.info(" {} isAgentDiscoveryEnabled : {}, egPortDiscoveryMap  : {}", new Object[]{loggerPrefix, this.isAgentDiscoveryEnabled, this.egPortDiscoveryMap});
    }

    private void printConfigsOfAppDiscovery() {
        APMDiscoveryLogger.discoveryLogger.info(" {} isEgProcessBasedDiscoveryEnabled: {}, isJavaProcessDiscoveryEnabled : {}, appDiscoveryExecTimeOut[MilliSeconds] : {}, appDiscoverySep : {}, IsTerminateLeftOverExecProcesses : {}, javaProcessDiscoveryStartupDelay[MilliSeconds] : {}, javaProcessDiscoveryRediscoverPeriod[MilliSeconds] : {}", new Object[]{loggerPrefix, this.isEgProcessBasedDiscoveryEnabled, this.isJavaProcessDiscoveryEnabled, this.appDiscoveryExecTimeOut, this.appDiscoverySep, this.IsTerminateLeftOverExecProcesses, this.javaProcessDiscoveryStartupDelay, this.javaProcessDiscoveryRediscoverPeriod});
        APMDiscoveryLogger.discoveryLogger.info(" {} isJavaProcessHandleDiscoveryEnabled : {}, classNameMapper : {}, cmdLineIncludeList : {}, cmdLineExcludeList : {}, executableIncludeList : {}, executableExcludeList : {}, appDiscoveryPriorityPorts : {}, systemPropertyExcludeList : {}, serverTypeDeciderPriorityMap : {}", new Object[]{loggerPrefix, this.isJavaProcessHandleDiscoveryEnabled, this.classNameMapper, this.cmdLineIncludeList, this.cmdLineExcludeList, this.executableIncludeList, this.executableExcludeList, this.appDiscoveryPriorityPorts, this.systemPropertyExcludeList, this.serverTypeDeciderPriorityMap});
        APMDiscoveryLogger.discoveryLogger.info(" {} executableNameMapper : {}, systemPropertyNameMapper : {}, isJavaProcessHandleDiscoveryEnabledForContainerZ : {}, javaVersionIncludeList :{}, javaVersionExcludeList :{}", new Object[]{loggerPrefix, this.executableNameMapper, this.systemPropertyNameMapper, this.isJavaProcessHandleDiscoveryEnabledForContainerZ, this.javaVersionIncludeList, this.javaVersionExcludeList});
    }

    public void updateDemoConfigs() {
        this.discoveryContributorSleepTime = ApmDemoInfo.getDiscoveryContributorSleepTime();
        this.appflowDataContributorSleepTime = ApmDemoInfo.getAppflowDataContributorSleepTime();
    }

    private void updateConfigs() {
        this.updateFromAgentTestsIni();
        this.updateJavaAppDiscoveryConfigs();
        this.discoveryContributorSleepTime = APMUtils.getAndValidateLongValue(this.apmFileObj, APM, "APMDiscoveryContributorSleepTime", 60000L, 15000L, APMDiscoveryLogger.discoveryLogger);
        this.appflowDataContributorSleepTime = APMUtils.getAndValidateLongValue(this.apmFileObj, APM, "APMAppflowDataContributorSleepTime", 60000L, 15000L, APMDiscoveryLogger.discoveryLogger);
        this.isAPMMonitoringEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM, "APM_Monitoring");
        this.isManageByCustomPort = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Manage_Components_With_Custom_Ports");
        this.isManageByCustomPortForDocker = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Manage_Components_With_Custom_Ports_In_Docker");
        this.createBTMJarZipFile = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM, "CreateBTMJarZipFileOnAgent");
        managedComponentsReUploadTime = APMUtils.getAndValidateLongValue(this.apmFileObj, APM_DISCOVERY, "Discovery_ReUpload_Time", 60000L, managedComponentsReUploadTime, APMDiscoveryLogger.discoveryLogger);
        String string = this.apmFileObj.getValue(APM_DISCOVERY_AUTO_DELETE, DELETE_DURATION_FOR_CONTAINER_APPS);
        this.assignContainerDeleteDuration(string);
        String string2 = this.apmFileObj.getValue(APM_DISCOVERY_AUTO_DELETE, DELETE_DURATION_FOR_NONCONTAINER_APPS);
        this.assignNonContainerDeleteDuration(string2);
        this.cleanUpInterval = APMUtils.getAndValidateLongValue(this.apmFileObj, APM_DISCOVERY_INI_CLEANUP, CLEANUP_CHECK_INTERVAL, 1L, 6L, APMDiscoveryLogger.discoveryLogger);
        String string3 = this.apmFileObj.getValue(APM_DISCOVERY_INI_CLEANUP, CLEANUP_TIME_UNIT).trim();
        this.assignCleanupDetails(string3);
        String string4 = this.apmFileObj.getValue(APM_DISCOVERY_INI_CLEANUP, NOTMANAGED_DELETE_THRESHOLD_FOR_CONTAINER_SERVERS).trim();
        this.assignNotManagedContainerDeleteThreshold(string4);
        String string5 = this.apmFileObj.getValue(APM_DISCOVERY_INI_CLEANUP, NOTMANAGED_DELETE_THRESHOLD_FOR_NONCONTAINER_SERVERS).trim();
        this.assignNotManagedNonContainerDeleteThreshold(string5);
        this.isSaveDetailsOnTempFile = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY_INI_CLEANUP, SAVE_DELETED_DETAILS_TO_TEMP_FILE);
        this.isIniCleanUpEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY_INI_CLEANUP, CLEANUP_ENABLED);
        this.transferApmIniToCleanUpIni();
        this.logBigSizeObjects = APMUtils.getAndValidateBooleanValue(this.apmFileObj, "APM_MISC", "Log_Big_Size_Objects");
        String string6 = System.getenv("EG_FULL_DEBUG_ON");
        if (string6 != null && string6.equalsIgnoreCase("true")) {
            this.logBigSizeObjects = true;
        }
        this.invokeHTTPRequest = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Invoke_HTTP_Request");
        this.isK8ServiceNameDiscoveryEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, "CONTAINERZ_CLOUD_APM", "Discover_K8_Service_Names");
        this.isStartupDelayEnabledForOffloadPort = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM, "Startup_Delay_For_BTM_Offload_Port");
        this.startupDelayPeriodForOffloadPort = APMUtils.getAndValidateLongValue(this.apmFileObj, APM, "Startup_Delay_Period_For_BTM_Offload_Port", 1000L, 30000L, APMDiscoveryLogger.discoveryLogger);
        this.checkSamplingUpdate();
        String string7 = this.apmFileObj.getValue(APM_DISCOVERY, "BTM_Discovery_Data_Transmit_Mode").trim();
        if (string7.equalsIgnoreCase("eg")) {
            this.transmitDiscoveryDataViaAgentDiscovery = true;
            this.transmitDiscoveryDataViaEgApmBtmDiscovery = false;
        } else if (string7.equalsIgnoreCase("apm")) {
            this.transmitDiscoveryDataViaEgApmBtmDiscovery = true;
            this.transmitDiscoveryDataViaAgentDiscovery = false;
        } else if (string7.length() == 0) {
            this.transmitDiscoveryDataViaEgApmBtmDiscovery = true;
            this.transmitDiscoveryDataViaAgentDiscovery = false;
        } else if (string7.equalsIgnoreCase("na") || string7.length() > 0) {
            this.transmitDiscoveryDataViaEgApmBtmDiscovery = false;
            this.transmitDiscoveryDataViaAgentDiscovery = false;
        }
        String string8 = this.apmFileObj.getValue(APM_DISCOVERY, "Container_BTM_Discovery_Data_Transmit_Mode").trim();
        if (string8 != null) {
            if (string8.equalsIgnoreCase("dd")) {
                this.transmitContBTMDiscoveryDataViaContainerDDTest = true;
                this.transmitContBTMDiscoveryDataViaEgApmBtmDiscovery = false;
            } else if (string8.equalsIgnoreCase("apm")) {
                this.transmitContBTMDiscoveryDataViaEgApmBtmDiscovery = true;
                this.transmitContBTMDiscoveryDataViaContainerDDTest = false;
            } else if (string8.length() == 0) {
                this.transmitContBTMDiscoveryDataViaEgApmBtmDiscovery = true;
                this.transmitContBTMDiscoveryDataViaContainerDDTest = false;
            } else if (string8.equalsIgnoreCase("na") || string8.length() > 0) {
                this.transmitContBTMDiscoveryDataViaEgApmBtmDiscovery = false;
                this.transmitContBTMDiscoveryDataViaContainerDDTest = false;
            }
        }
    }

    private void checkSamplingUpdate() {
        try {
            boolean bl = APMUtils.getAndValidateBooleanValue(this.apmFileObj, SAMPLING_SETTINGS, "SamplingEnabled");
            SamplingController.getInstance().reinit(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean updateFromAgentTestsIni() {
        String string = "eg_agentTests.ini";
        boolean bl = false;
        try {
            EgIniInfo egIniInfo;
            if (this.iniInfo.containsKey(string)) {
                if (this.iniInfo.get(string).checkForUpdate()) {
                    bl = true;
                }
            } else {
                egIniInfo = new EgIniInfo(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_TEST_FILEPATH);
                this.iniInfo.put(string, egIniInfo);
                bl = true;
            }
            if (bl) {
                egIniInfo = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_TEST_FILEPATH);
                this.isAgentDiscoveryEnabled = APMUtils.getAndValidateBooleanValue((IniFile)egIniInfo, "AGENT_SETTINGS", "AgentDiscover");
                HashMap hashMap = this.getAgentPortDiscoveryMap((IniFile)egIniInfo);
                if (hashMap.size() > 0) {
                    this.egPortDiscoveryMap.clear();
                    this.egPortDiscoveryMap.putAll(hashMap);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(" {} Unable to create ini tracker object {}, ", (Object)loggerPrefix, (Object)string);
        }
        return bl;
    }

    private void updateJavaAppDiscoveryConfigs() {
        try {
            this.isEgProcessBasedDiscoveryEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, EGAPM_DISCOVERY, "eG_Process_Based_Discovery");
            this.isJavaProcessDiscoveryEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, EGAPM_DISCOVERY, "Java_Process_Discovery");
            this.javaProcessDiscoveryStartupDelay = APMUtils.getAndValidateLongValue(this.apmFileObj, EGAPM_DISCOVERY, "eG_Process_Based_Discovery_StartUp_Delay_Time", 60000L, 60000L, APMDiscoveryLogger.discoveryLogger);
            this.javaProcessDiscoveryRediscoverPeriod = APMUtils.getAndValidateLongValue(this.apmFileObj, EGAPM_DISCOVERY, "eG_Process_Based_Discovery_Rediscovery_Time", 60000L, 900000L, APMDiscoveryLogger.discoveryLogger);
            this.useRequestBasedDiscovery = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Use_Request_Based_Discovery_Data", false);
            this.useStartupMbeanBasedDiscovery = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Use_Startup_Mbean_Based_Discovery_Data", true);
            this.appDiscoveryExecTimeOut = APMUtils.getAndValidateLongValue(this.apmFileObj, EGAPM_DISCOVERY, "Exec_TimeOut", 1L, 500L, APMDiscoveryLogger.discoveryLogger);
            this.appDiscoverySep = APMUtils.getAndValidateStringValue(this.apmFileObj, EGAPM_DISCOVERY, "Separator", "|");
            this.isJavaProcessHandleDiscoveryEnabled = APMUtils.IsThisAvailableInIniValue(this.apmFileObj, EGAPM_DISCOVERY, "Java_Process_Discovery_Modes", ",", "JPH", APMDiscoveryLogger.discoveryLogger);
            this.isJavaProcessHandleDiscoveryEnabledForContainerZ = APMUtils.IsThisAvailableInIniValue(this.apmFileObj, EGAPM_DISCOVERY, "Java_Process_Discovery_Modes_For_ContainerZ", ",", "JPH", APMDiscoveryLogger.discoveryLogger);
            this.IsTerminateLeftOverExecProcesses = APMUtils.getAndValidateBooleanValue(this.apmFileObj, EGAPM_DISCOVERY, "Kill_LeftOver_Exec_Processes");
            this.classNameMapper = APMUtils.getLinesAsArrayListMap(this.apmFileObj, "COMP_TYPE_CLASS_NAME_MAPPING", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.systemPropertyNameMapper = APMUtils.getLinesAsArrayListMap(this.apmFileObj, "COMP_TYPE_SYSTEM_PROPERTY_MAPPING", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.executableNameMapper = APMUtils.getLinesAsArrayListMap(this.apmFileObj, "COMP_TYPE_EXECUTABLE_NAME_MAPPING", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.executableIncludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "EXECUTABLE_INCLUDE_LIST", "Include", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.executableExcludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "EXECUTABLE_EXCLUDE_LIST", "Exclude", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.cmdLineIncludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "CMD_LINE_INCLUDE_LIST", "Include", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.cmdLineExcludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "CMD_LINE_EXCLUDE_LIST", "Exclude", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.javaVersionIncludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "JAVA_VERSION_INCLUDE_LIST", "Include", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.javaVersionExcludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "JAVA_VERSION_EXCLUDE_LIST", "Exclude", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.systemPropertyExcludeList = APMUtils.getStringAsArrayList(this.apmFileObj, "SYSTEM_PROPERTY_EXCLUDE_LIST", "Exclude", this.getAppDiscoverySep(), APMDiscoveryLogger.discoveryLogger);
            this.serverTypeDeciderPriorityMap = APMUtils.getLinesAsMap(this.apmFileObj, "JAVA_APP_DISCOVERY_COMP_TYPE_PRIORITY", APMDiscoveryLogger.discoveryLogger);
            HashMap hashMap = APMUtils.getLinesAsArrayListMap(this.apmFileObj, "JAVA_APP_DISCOVERY_PRIORITY_PORTS", APMDiscoveryLogger.discoveryLogger);
            if (hashMap != null && hashMap.size() > 0) {
                this.appDiscoveryPriorityPorts.clear();
                this.appDiscoveryPriorityPorts.putAll(hashMap);
            }
            this.isThresholdWriteEnabledToGuidProps = APMUtils.getAndValidateBooleanValue(this.apmFileObj, "APM_MISC", "Write_BTM_Thresholds_To_Common_Props", true);
            this.isReadBTMThresholdFromGlobalThresholdEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, "APM_MISC", "Read_BTM_Thresholds_From_Global_Threshold", true);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn(" {} Unable to read configs", (Object)loggerPrefix, (Object)exception);
        }
    }

    public void updateConfiguration(boolean bl) {
        this.updateConfigsFromAgentTestsIni(bl);
    }

    private void updateConfigsFromAgentTestsIni(boolean bl) {
        if (this.updateFromAgentTestsIni()) {
            this.printConfigsFromAgentTestsIni();
        }
    }

    private HashMap getAgentPortDiscoveryMap(IniFile iniFile) {
        HashMap hashMap = APMUtils.getLinesAsMap(iniFile, "AGENT_DISCOVERY", APMDiscoveryLogger.discoveryLogger);
        HashMap hashMap2 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string;
                int n;
                String string2 = (String)iterator.next();
                String string3 = (String)hashMap.get(string2);
                if (string3 == null || (n = string3.indexOf("-port")) <= -1 || (string = string3.substring(n + 5)) == null) continue;
                string = string.trim();
                int n2 = string.indexOf(":");
                ArrayList<String> arrayList = new ArrayList<String>();
                if (n2 > -1) {
                    String[] stringArray = string.split(":");
                    if (stringArray != null) {
                        arrayList.addAll(Arrays.asList(stringArray));
                    }
                } else {
                    arrayList.add(string);
                }
                if (arrayList.size() <= 0) continue;
                hashMap2.put(string2, arrayList);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn(" {} Unable to read AGENT_DISCOVERY port details {}, ", (Object)loggerPrefix, (Object)iniFile.fileName);
            }
        }
        return hashMap2;
    }

    private void transferApmIniToCleanUpIni() {
        String string = "Apm_Discovery_Cleanup";
        String string2 = this.getValue("APM_DISCOVERY_CLEANUP", string);
        IniFile iniFile = new IniFile(BTMConstants.EG_APM_DISCOVERY_CLEANUP_INI);
        String string3 = iniFile.getValue("APM_DISCOVERY_CLEANUP", string);
        APMDiscoveryLogger.discoveryLogger.debug(" apmIniLogCleanUpflag : {}, logCleanUpflag : {} ", (Object)string2, (Object)string3);
        if (string2.length() > 0 && !string2.equalsIgnoreCase(string3)) {
            JavaTransactionFlowUtility.addToIniFile((String)BTMConstants.EG_APM_DISCOVERY_CLEANUP_INI, (String)"APM_DISCOVERY_CLEANUP", (String)string, (String)string2);
        }
    }

    private void assignCleanupDetails(String string) {
        this.isUnitHH = false;
        if (string != null && string.length() > 0 && (string.equalsIgnoreCase("HH") || string.equalsIgnoreCase("MM"))) {
            this.cleanupSymbol = "m";
            if (string.equalsIgnoreCase("HH")) {
                this.isUnitHH = true;
            }
        } else {
            this.cleanupSymbol = "s";
        }
    }

    private void assignContainerDeleteDuration(String string) {
        this.maxTimeToDeleteContainerApps = 15L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.maxTimeToDeleteContainerApps = l;
        }
    }

    private void assignNonContainerDeleteDuration(String string) {
        this.maxTimeToDeleteNonContainerApps = 1440L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.maxTimeToDeleteNonContainerApps = l;
        }
    }

    private void assignNotManagedContainerDeleteThreshold(String string) {
        this.notManagedContainerDeleteThreshold = 6L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.notManagedContainerDeleteThreshold = l;
        }
    }

    private void assignNotManagedNonContainerDeleteThreshold(String string) {
        this.notManagedNonContainerDeleteThreshold = 24L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.notManagedNonContainerDeleteThreshold = l;
        }
    }

    private long getResult(String string) {
        long l = -1L;
        if (string != null && string.length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public long getDiscoveryContributorSleepTime() {
        return this.discoveryContributorSleepTime;
    }

    public long getAppflowDataContributorSleepTime() {
        return this.appflowDataContributorSleepTime;
    }

    public long getDiscoveryDataReUploadTime() {
        return managedComponentsReUploadTime;
    }

    public boolean isAPMMonitoringEnabled() {
        return this.isAPMMonitoringEnabled;
    }

    public boolean isManageByCustomPort() {
        return this.isManageByCustomPort;
    }

    public boolean isSaveDetailsOnTempFile() {
        return this.isSaveDetailsOnTempFile;
    }

    public boolean isCleanUpEnabled() {
        return this.isIniCleanUpEnabled;
    }

    public boolean isManageByCustomPortForDocker() {
        return this.isManageByCustomPortForDocker;
    }

    private long lastModified() {
        return IniFile.getLastModified((String)apmIniFile);
    }

    private long lastSize() {
        return IniFile.getLastSize((String)apmIniFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && l2 == this.lastSize) {
            return false;
        }
        String string = APM;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == this.lastModifiedTime && l2 == this.lastSize) {
                return false;
            }
            this.init();
            return true;
        }
    }

    private void setNetStatExistsOnLinux() {
        boolean bl;
        block3: {
            bl = true;
            try {
                String string = "which netstat";
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = egUtilities.getExecOutputLines(string);
                if (arrayList == null || arrayList.size() < 2) break block3;
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 == null || arrayList3.size() <= 0) break block3;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)arrayList3.get(i);
                    if (string2 == null || string2.trim().length() == 0 || (string2 = string2.trim()).indexOf("no netstat in") < 0) continue;
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                bl = true;
                exception.printStackTrace();
            }
        }
        this.isNetStatExistsOnLinux = bl;
    }

    private void setValue(String string, String string2, String string3) {
        this.apmFileObj.setValue(string, string2, string3);
    }

    private String getValue(String string, String string2) {
        return this.apmFileObj.getValue(string, string2);
    }

    private String[] getVariables(String string) {
        return this.apmFileObj.getVariables(string);
    }

    private Vector getValues(String string) {
        return this.apmFileObj.getAllValues(string);
    }

    private String[] getLinesUnderSubject(String string) {
        return this.apmFileObj.getLinesUnderSubject(string);
    }

    public String getCleanupSymbol() {
        return this.cleanupSymbol;
    }

    public boolean isUnitHH() {
        return this.isUnitHH;
    }

    public long getDeleteDurationContainerApps() {
        return this.maxTimeToDeleteContainerApps;
    }

    public long getDeleteDurationNonContainerApps() {
        return this.maxTimeToDeleteNonContainerApps;
    }

    public long getUnManagedDeleteThresholdContainerApps() {
        return this.notManagedContainerDeleteThreshold;
    }

    public long getUnManagedDeleteThresholdNonContainerApps() {
        return this.notManagedNonContainerDeleteThreshold;
    }

    public boolean createBTMJarZipFile() {
        return this.createBTMJarZipFile;
    }

    public long getCleanUpInterval() {
        return this.cleanUpInterval;
    }

    public boolean isLogBigSizeObjects() {
        return this.logBigSizeObjects;
    }

    public boolean isK8ServiceNameDiscoveryEnabled() {
        return this.isK8ServiceNameDiscoveryEnabled;
    }

    public boolean isManualHttpInvocationEnabled() {
        return this.invokeHTTPRequest;
    }

    public boolean isBtmOffloadPortStartupDelayEnabled() {
        return this.isStartupDelayEnabledForOffloadPort;
    }

    public long getBtmOffloadPortStartupDelayPeriod() {
        return this.startupDelayPeriodForOffloadPort;
    }

    public HashMap getClassNameMapper() {
        if (this.classNameMapper == null || this.classNameMapper.size() == 0) {
            this.classNameMapper = this.getDefaultClassNameMapper();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default data for class name mapper !!!", (Object)loggerPrefix);
        }
        return this.classNameMapper;
    }

    public HashMap getExecutableNameMapper() {
        if (this.executableNameMapper == null || this.executableNameMapper.size() == 0) {
            this.executableNameMapper = this.getDefaultExecutableNameMapper();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default data for executable name mapper !!!", (Object)loggerPrefix);
        }
        return this.executableNameMapper;
    }

    public HashMap getSystemPropertyNameMapper() {
        if (this.systemPropertyNameMapper == null || this.systemPropertyNameMapper.size() == 0) {
            this.systemPropertyNameMapper = this.getDefaultSystemPropertyNameMapper();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default data for system property name mapper !!!", (Object)loggerPrefix);
        }
        return this.systemPropertyNameMapper;
    }

    public boolean isEgProcessBasedDiscoveryEnabled() {
        return this.isEgProcessBasedDiscoveryEnabled;
    }

    public boolean isJavaProcessDiscoveryEnabled() {
        return this.isJavaProcessDiscoveryEnabled;
    }

    public long getJavaProcessDiscoveryStartupDelay() {
        return this.javaProcessDiscoveryStartupDelay;
    }

    public long getJavaProcessDiscoveryRediscoverPeriod() {
        return this.javaProcessDiscoveryRediscoverPeriod;
    }

    public boolean isJavaProcessHandleDiscoveryEnabled() {
        return this.isJavaProcessHandleDiscoveryEnabled;
    }

    public boolean isJPHDEnabledForContainerZ() {
        return this.isJavaProcessHandleDiscoveryEnabledForContainerZ;
    }

    public OS getOsType() {
        return this.osName;
    }

    public ArrayList getIncludeProcesses() {
        if (this.executableIncludeList == null || this.executableIncludeList.size() == 0) {
            this.executableIncludeList = this.getDefaultProcessIncludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default process on included details !!! ", (Object)loggerPrefix);
        }
        return this.executableIncludeList;
    }

    public ArrayList getExcludeProcesses() {
        if (this.executableExcludeList == null || this.executableExcludeList.size() == 0) {
            this.executableExcludeList = this.getDefaultProcessExcludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default process on excluded details !!! ", (Object)loggerPrefix);
        }
        return this.executableExcludeList;
    }

    public ArrayList getIncludeCommandLineList() {
        if (this.cmdLineIncludeList == null || this.cmdLineIncludeList.size() == 0) {
            this.cmdLineIncludeList = this.getDefaultCmdLineIncludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default cmd line on included details !!! ", (Object)loggerPrefix);
        }
        return this.cmdLineIncludeList;
    }

    public ArrayList getExcludeCommandLineList() {
        if (this.cmdLineExcludeList == null || this.cmdLineExcludeList.size() == 0) {
            this.cmdLineExcludeList = this.getDefaultCmdLineExcludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default cmd line on excluded details !!! ", (Object)loggerPrefix);
        }
        return this.cmdLineExcludeList;
    }

    public ArrayList getJavaVersionIncludeList() {
        if (this.javaVersionIncludeList == null || this.javaVersionIncludeList.size() == 0) {
            this.javaVersionIncludeList = this.getDefaultJavaVersionIncludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default java version on included details !!! ", (Object)loggerPrefix);
        }
        return this.javaVersionIncludeList;
    }

    public ArrayList getJavaVersionExcludeList() {
        if (this.javaVersionExcludeList == null || this.javaVersionExcludeList.size() == 0) {
            this.javaVersionExcludeList = this.getDefaultJavaVersionExcludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default java version on excluded details !!! ", (Object)loggerPrefix);
        }
        return this.javaVersionExcludeList;
    }

    public ArrayList getExcludeSystemProperties() {
        if (this.systemPropertyExcludeList == null || this.systemPropertyExcludeList.size() == 0) {
            this.systemPropertyExcludeList = this.getDefaultSystemPropertyExcludeList();
            APMDiscoveryLogger.discoveryLogger.debug("{} loaded default system property on excluded details !!! ", (Object)loggerPrefix);
        }
        return this.systemPropertyExcludeList;
    }

    public ConcurrentHashMap getAppDiscoveryPriorityPorts() {
        return this.appDiscoveryPriorityPorts;
    }

    public ConcurrentHashMap getEgPortDiscoveryMap() {
        return this.egPortDiscoveryMap;
    }

    public HashMap getServerTypeDeciderPriorityMap() {
        return this.serverTypeDeciderPriorityMap;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public boolean isJava9Higher() {
        return this.java9Above;
    }

    public String getJavaInfo() {
        return this.getJavaVendor() + " " + this.getJavaVersion();
    }

    public String getAppDiscoverySep() {
        return this.appDiscoverySep;
    }

    public long getAppDiscoveryExecTimeOut() {
        return this.appDiscoveryExecTimeOut;
    }

    public boolean IsTerminateLeftOverExecProcesses() {
        return this.IsTerminateLeftOverExecProcesses;
    }

    private ArrayList getDefaultProcessExcludeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".*(?i)tomcat.*w.exe.*");
        arrayList.add(".*eGurkha\\\\manager\\\\tomcat\\\\bin\\\\tomcat.*");
        arrayList.add(".*egurkha/manager/tomcat/bin/tomcat.*");
        arrayList.add(".*egurkha/rum/tomcat/bin/tomcat.*");
        return arrayList;
    }

    private ArrayList getDefaultProcessIncludeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".*java.*");
        arrayList.add(".*(?i)tomcat.*");
        return arrayList;
    }

    private ArrayList getDefaultCmdLineIncludeList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private ArrayList getDefaultCmdLineExcludeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".*EgMainAgent.*");
        arrayList.add(".*eg_agent.jar.*");
        arrayList.add(".*EgCheckAgent.*");
        arrayList.add(".*EgHttpGet.*");
        arrayList.add(".*com.eg.EgStartManager.*");
        arrayList.add(".*com.eg.apm.ProcessInfo.*");
        arrayList.add(".*org.eclipse.equinox.launcher.*");
        arrayList.add(".*com.intellij.idea.Main.*");
        return arrayList;
    }

    private ArrayList getDefaultJavaVersionIncludeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".*(?i)OpenJDK.*");
        arrayList.add(".*(?i)Java HotSpot.*");
        return arrayList;
    }

    private ArrayList getDefaultJavaVersionExcludeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".*OpenJ9.*");
        arrayList.add(".*IBM J9.*");
        arrayList.add(".*IBM.*");
        return arrayList;
    }

    private ArrayList getDefaultSystemPropertyExcludeList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private HashMap getDefaultClassNameMapper() {
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        hashMap.put("Tomcat_server", this.getAsList(".*org.apache.catalina.startup.Bootstrap.*"));
        hashMap.put("WildFly", this.getAsList(".*org.jboss.modules.Main.*"));
        hashMap.put("JBoss_server", this.getAsList(".*org.jboss.Main.*"));
        hashMap.put("WebLogic_server", this.getAsList(".*weblogic.Server.*"));
        hashMap.put("Web_server", this.getAsList(".*com.ibm.ws.runtime.WsServer.*"));
        return hashMap;
    }

    private ArrayList getAsList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return arrayList;
    }

    private HashMap getDefaultExecutableNameMapper() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    private HashMap getDefaultSystemPropertyNameMapper() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    public boolean isAgentDiscoveryEnabled() {
        return this.isAgentDiscoveryEnabled;
    }

    public boolean isTransmitBTMDiscoveryDataViaEgApmBtmDiscovery() {
        return this.transmitDiscoveryDataViaEgApmBtmDiscovery;
    }

    public boolean isTransmitBTMDiscoveryDataViaAgentDiscovery() {
        return this.transmitDiscoveryDataViaAgentDiscovery;
    }

    public boolean isTransmitContBTMDiscoveryDataViaContainerDDTest() {
        return this.transmitContBTMDiscoveryDataViaContainerDDTest;
    }

    public boolean isTransmitContBTMDiscoveryDataViaEgApmBtmDiscovery() {
        return this.transmitContBTMDiscoveryDataViaEgApmBtmDiscovery;
    }

    public boolean isUseRequestBasedDiscovery() {
        return this.useRequestBasedDiscovery;
    }

    public boolean isUseStartupMbeanBasedDiscovery() {
        return this.useStartupMbeanBasedDiscovery;
    }

    public boolean isNetStatExistsOnLinux() {
        return this.isNetStatExistsOnLinux;
    }

    private void setNetStatExistsOnLinux(boolean bl) {
        this.isNetStatExistsOnLinux = bl;
    }

    public boolean isThresholdWriteEnabledToGuidProps() {
        return this.isThresholdWriteEnabledToGuidProps;
    }

    public boolean isReadBTMThresholdFromGlobalThresholdEnabled() {
        return this.isReadBTMThresholdFromGlobalThresholdEnabled;
    }
}

