/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EgMaintenanceInfo {
    private static String entity = null;
    private static boolean isAgent = false;
    private static IniFile maintenanceFilePointer = null;
    private static File maintenanceFile = null;
    private static String maintenanceFileName = null;
    private static long lastModifiedTime = 0L;
    private static long lastSize = 0L;
    private static final String egMaintenanceFile = "eg_maintenance.ini";
    private static final String policySection = "POLICIES";
    private static final String groupSection = "GROUPS";
    private static final String serverSection = "SERVERS";
    private static final String defaultGroup = "default";
    private static final String unplannedPolicySection = "UNPLANNED_POLICIES";
    private static final String unplannedPolicySectionDisplay = "UNPLANNED_POLICIES_DISPLAY";
    private static final String unplannedPolicyMappingSection = "UNPLANNED_POLICY_MAPPING";
    private static ConcurrentHashMap maintenancePeriods = new ConcurrentHashMap();
    private static ConcurrentHashMap maintenanceDetails = new ConcurrentHashMap();
    private static ConcurrentHashMap unplannedMaintenancePeriods = new ConcurrentHashMap();
    private static ConcurrentHashMap unplannedMaintenancePeriodsDisplay = new ConcurrentHashMap();
    private static ConcurrentHashMap unplannedMaintenanceDetails = new ConcurrentHashMap();
    private static ConcurrentHashMap unplannedMaintenanceDetailsDisplay = new ConcurrentHashMap();
    private static HashSet wildCardMaintenanceTests = new HashSet();
    private static List wildCardMaintenanceTestPatterns = new ArrayList();
    private static boolean keepDataInMemory = false;
    private static String[] upm_vars = null;
    private static Vector upm_vv = null;

    public static void main(String[] stringArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public EgMaintenanceInfo(String string) {
        entity = string;
        if (maintenanceFile == null) {
            String string2 = policySection;
            // MONITORENTER : "POLICIES"
            if (maintenanceFile == null) {
                if (string.equalsIgnoreCase("agent")) {
                    isAgent = true;
                    maintenanceFileName = new String(EgConfigInfo.egAgentConfigDir + egMaintenanceFile);
                } else {
                    isAgent = false;
                    maintenanceFileName = new String(EgConfigInfo.egMgrConfigDir + egMaintenanceFile);
                }
                File file = new File(maintenanceFileName);
                maintenancePeriods = new ConcurrentHashMap();
                unplannedMaintenancePeriods = new ConcurrentHashMap();
                unplannedMaintenancePeriodsDisplay = new ConcurrentHashMap();
                maintenanceDetails = new ConcurrentHashMap();
                lastModifiedTime = EgMaintenanceInfo.lastModified();
                lastSize = EgMaintenanceInfo.lastSize();
                maintenanceFilePointer = new IniFile(maintenanceFileName, false);
                maintenanceFile = file;
                unplannedMaintenanceDetails = new ConcurrentHashMap();
                unplannedMaintenanceDetailsDisplay = new ConcurrentHashMap();
                wildCardMaintenanceTests = new HashSet();
                wildCardMaintenanceTestPatterns = new ArrayList();
                String string3 = maintenanceFilePointer.getValue("keepDataInMemory", "keepDataInMemory");
                boolean bl = keepDataInMemory = string3 != null && (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true"));
                if (keepDataInMemory) {
                    upm_vars = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                    upm_vv = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
                } else {
                    upm_vars = null;
                    upm_vv = null;
                }
            }
            // MONITOREXIT : string2
        }
        EgMaintenanceInfo.checkForUpdate();
    }

    private static ArrayList removeDuplicates(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList;
        }
        HashSet hashSet = new HashSet(arrayList);
        arrayList.clear();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static long lastModified() {
        long l = 0L;
        if (maintenanceFile != null) {
            l = isAgent ? maintenanceFile.lastModified() : IniFile.getLastModified((String)maintenanceFileName);
        }
        return l;
    }

    public static long lastSize() {
        long l = 0L;
        if (maintenanceFile != null) {
            l = isAgent ? maintenanceFile.length() : IniFile.getLastSize((String)maintenanceFileName);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForUpdate() {
        long l = EgMaintenanceInfo.lastModified();
        long l2 = EgMaintenanceInfo.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = policySection;
        synchronized (policySection) {
            l = EgMaintenanceInfo.lastModified();
            l2 = EgMaintenanceInfo.lastSize();
            if (l == lastModifiedTime && l2 == lastSize) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return false;
            }
            lastModifiedTime = l;
            lastSize = l2;
            maintenanceFilePointer = new IniFile(maintenanceFile.getAbsolutePath());
            maintenancePeriods = new ConcurrentHashMap();
            maintenanceDetails = new ConcurrentHashMap();
            String string2 = maintenanceFilePointer.getValue("keepDataInMemory", "keepDataInMemory");
            boolean bl = keepDataInMemory = string2 != null && (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true"));
            if (keepDataInMemory) {
                upm_vars = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                upm_vv = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            } else {
                upm_vars = null;
                upm_vv = null;
            }
            unplannedMaintenancePeriods = new ConcurrentHashMap();
            unplannedMaintenancePeriodsDisplay = new ConcurrentHashMap();
            unplannedMaintenanceDetails = new ConcurrentHashMap();
            unplannedMaintenanceDetailsDisplay = new ConcurrentHashMap();
            wildCardMaintenanceTests = new HashSet();
            wildCardMaintenanceTestPatterns = new ArrayList();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return true;
        }
    }

    private static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3.trim());
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3.trim());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPolicyInfo(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        String string3 = policySection;
        synchronized (policySection) {
            string2 = maintenanceFilePointer.getValue(policySection, string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getGroupInfo(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        Object object = policySection;
        synchronized (policySection) {
            string2 = maintenanceFilePointer.getValue(groupSection, string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (string2 == null || string2.trim().length() == 0 || string2.equalsIgnoreCase("none")) {
                return null;
            }
            object = EgMaintenanceInfo.myTokenizer(string2, ",");
            if (object == null || ((ArrayList)object).size() == 0) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            int n = ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                ArrayList arrayList2;
                String string3 = this.getPolicyInfo((String)((ArrayList)object).get(i));
                if (string3 == null || (arrayList2 = EgMaintenanceInfo.myTokenizer(string3, ",")) == null) continue;
                int n2 = arrayList2.size();
                for (int j = 0; j < n2; ++j) {
                    String string4 = (String)arrayList2.get(j);
                    arrayList.add(string4);
                }
            }
            arrayList = EgMaintenanceInfo.removeDuplicates(arrayList);
            return arrayList;
        }
    }

    public ArrayList getMaintenancePeriods(String string, String string2, String string3) {
        return this.getMaintenancePeriods(string, string2, string3, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string4 = string + ":" + string2;
        String string5 = string;
        String string6 = null;
        String string7 = string4;
        if (string3 != null && string3.length() > 0) {
            string7 = string6 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string7)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string8 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string7, arrayList2);
                    // ** MonitorExit[var13_14] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5) && !stringArray[i].equals(string4) && (string6 == null || !stringArray[i].equals(string6))) continue;
                bl = true;
                String string9 = null;
                string9 = (String)vector.get(i);
                if (string9 == null || string9.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string9, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string10 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string10);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string11 = (String)arrayList3.get(j);
                        arrayList2.add(string11);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string7, arrayList2);
            return arrayList2;
        }
    }

    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, String string5) {
        return this.getMaintenancePeriods(string, string2, string3, string4, string5, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, String string5, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string6 = "";
        string6 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string + ":" + string5;
        String string7 = string2 + '#' + string + ":" + string5;
        String string8 = null;
        String string9 = string6;
        if (string4 != null && string4.length() > 0) {
            string8 = string6 + ":" + string4;
            string9 = string8 = string8 + '#' + string + ":" + string5;
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string9)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var14_14] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string10 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string9, arrayList2);
                    // ** MonitorExit[var15_16] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string7) && !stringArray[i].equalsIgnoreCase(string6) && (string8 == null || !stringArray[i].equalsIgnoreCase(string8))) continue;
                bl = true;
                String string11 = null;
                string11 = (String)vector.get(i);
                if (string11 == null || string11.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string11, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string12 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string12);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string13 = (String)arrayList3.get(j);
                        arrayList2.add(string13);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            String string14 = policySection;
            synchronized (policySection) {
                maintenancePeriods.put(string9, arrayList2);
                // ** MonitorExit[var16_20] (shouldn't be in output)
                return arrayList2;
            }
        }
    }

    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4) {
        return this.getMaintenancePeriods(string, string2, string3, string4, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string5 = "";
        string5 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string;
        String string6 = string2 + '#' + string;
        String string7 = null;
        String string8 = string5;
        if (string4 != null && string4.length() > 0) {
            string7 = string5 + ":" + string4;
            string8 = string7 = string7 + '#' + string;
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string8)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var13_13] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string9 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string8, arrayList2);
                    // ** MonitorExit[var14_15] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6) && !stringArray[i].equals(string5) && (string7 == null || !stringArray[i].equals(string7))) continue;
                bl = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string11);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string12 = (String)arrayList3.get(j);
                        arrayList2.add(string12);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string8, arrayList2);
            return arrayList2;
        }
    }

    public ArrayList getMaintenancePeriods(String string) {
        return this.getMaintenancePeriods(string, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, int n) {
        String string2;
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string2 = '#' + string)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string3 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string2, arrayList2);
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl = true;
                String string4 = null;
                string4 = (String)vector.get(i);
                if (string4 == null || string4.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string5);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string6 = (String)arrayList3.get(j);
                        arrayList2.add(string6);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string2, arrayList2);
            return arrayList2;
        }
    }

    public ArrayList getMaintenancePeriods(String string, String string2) {
        return this.getMaintenancePeriods(string, string2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getMaintenancePeriods(String string, String string2, int n) {
        String string3;
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        if ((arrayList = (ArrayList)maintenancePeriods.get(string3 = '#' + string + ":" + string2)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 == null || arrayList2.size() <= 0) return arrayList2;
                String string4 = policySection;
                synchronized (policySection) {
                    maintenancePeriods.put(string3, arrayList2);
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    return arrayList2;
                }
            }
            arrayList2 = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string3)) continue;
                bl = true;
                String string5 = null;
                string5 = (String)vector.get(i);
                if (string5 == null || string5.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string6);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string7 = (String)arrayList3.get(j);
                        arrayList2.add(string7);
                    }
                }
            }
            if (!bl) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) == null || arrayList2.size() <= 0) return arrayList2;
            maintenancePeriods.put(string3, arrayList2);
            return arrayList2;
        }
    }

    private static ArrayList splitDate(String string) {
        ArrayList arrayList = EgMaintenanceInfo.myTokenizer(string, " ");
        String string2 = (String)arrayList.get(0);
        String string3 = (String)arrayList.get(1);
        arrayList = EgMaintenanceInfo.myTokenizer(string2, "/");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add((String)arrayList.get(0));
        arrayList2.add((String)arrayList.get(1));
        arrayList2.add((String)arrayList.get(2));
        arrayList = EgMaintenanceInfo.myTokenizer(string3, ":");
        arrayList2.add((String)arrayList.get(0));
        arrayList2.add((String)arrayList.get(1));
        return arrayList2;
    }

    public boolean isItMaintenanceTime(String string, ArrayList arrayList) {
        return this.isItMaintenanceTime(string, arrayList, 1);
    }

    public boolean isItMaintenanceTime(String string, ArrayList arrayList, int n) {
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        ArrayList arrayList2 = EgMaintenanceInfo.splitDate(string);
        String string2 = (String)arrayList2.get(0);
        String string3 = (String)arrayList2.get(1);
        String string4 = (String)arrayList2.get(2);
        String string5 = (String)arrayList2.get(3);
        String string6 = (String)arrayList2.get(4);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string7 = (String)arrayList.get(i);
            if (!this.isMatch(string2, string3, string4, string5, string6, string7)) continue;
            return true;
        }
        return false;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4) {
        return this.isItMaintenanceTime(string, string2, string3, string4, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, int n) {
        ArrayList arrayList = new ArrayList();
        arrayList = this.getMaintenancePeriods(string2, string3, string4, n);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        arrayList3 = this.getUnplannedMaintenancePeriods(string2, string3, string4, n);
        boolean bl = false;
        if (arrayList != null) {
            arrayList2.addAll(arrayList);
        }
        if (arrayList2 != null) {
            if (arrayList3 != null) {
                arrayList2.addAll(arrayList3);
            }
        } else if (arrayList3 != null) {
            arrayList2 = arrayList3;
        }
        if (arrayList2 != null && arrayList2.size() > 0 && this.isItMaintenanceTime(string, arrayList2, n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5) {
        return this.isItMaintenanceTime(string, string2, string3, string4, string5, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, int n) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, n);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2) {
        return this.isItMaintenanceTime(string, string2, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, int n) {
        ArrayList arrayList = this.getMaintenancePeriods(string, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, n);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3) {
        return this.isItMaintenanceTime(string, string2, string3, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, int n) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, n);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.isItMaintenanceTime(string, string2, string3, string4, string5, string6, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, string6, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, string6, n);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl = true;
        }
        return bl;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, boolean bl) {
        return this.isItMaintenanceTime(string, string2, string3, bl, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, boolean bl, int n) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, n);
        ArrayList arrayList3 = new ArrayList();
        boolean bl2 = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        return this.isItMaintenanceTime(string, string2, string3, string4, string5, string6, bl, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) {
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, string6, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, string6, n);
        ArrayList arrayList3 = new ArrayList();
        boolean bl2 = false;
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl2 = true;
        }
        return bl2;
    }

    public static double findNthWeekDayOfTheMonth(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] nArray2 = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (n > 0) {
            return (double)((n - 1) * 7 + 1) + ((double)(7 + n2) - EgMaintenanceInfo.findDayOfTheWeek((n - 1) * 7 + 1, n3, n4)) % 7.0;
        }
        int n5 = 0;
        n5 = EgMaintenanceInfo.leapYear(n4) ? nArray2[n3 - 1] : nArray[n3 - 1];
        return (double)n5 - (EgMaintenanceInfo.findDayOfTheWeek(n5, n3, n4) - (double)n2 + 7.0) % 7.0;
    }

    public static boolean leapYear(int n) {
        if ((double)(n / 4) != Math.floor(n / 4)) {
            return false;
        }
        if ((double)(n / 100) != Math.floor(n / 100)) {
            return true;
        }
        return (double)(n / 400) == Math.floor(n / 400);
    }

    public static double findDayOfTheWeek(int n, int n2, int n3) {
        double d = Math.floor((14 - n2) / 12);
        double d2 = (double)n3 - d;
        double d3 = (double)n2 + 12.0 * d - 2.0;
        double d4 = ((double)n + d2 + Math.floor(d2 / 4.0) - Math.floor(d2 / 100.0) + Math.floor(d2 / 400.0) + Math.floor(31.0 * d3 / 12.0)) % 7.0;
        return d4 + 1.0;
    }

    public int convertTimeInMinutes(String string) {
        int n;
        if (string != null && (n = string.indexOf(":")) != -1) {
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = Integer.parseInt(string.substring(n + 1));
            int n4 = n2 * 60 + n3;
            return n4;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMatch(String string, String string2, String string3, String string4, String string5, String string6) {
        Object object;
        String string7;
        int n;
        int n2;
        int n3;
        String string8;
        String string9;
        String string10;
        String string11;
        GregorianCalendar gregorianCalendar;
        int n4;
        int n5;
        int n6;
        block33: {
            block34: {
                n6 = 0;
                n5 = 0;
                n4 = 0;
                try {
                    n6 = Integer.parseInt(string);
                    n5 = Integer.parseInt(string2);
                    n4 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                gregorianCalendar = new GregorianCalendar(n4, n5 - 1, 1);
                ArrayList arrayList = EgMaintenanceInfo.myTokenizer(string6, "#");
                string11 = (String)arrayList.get(1);
                string10 = (String)arrayList.get(0);
                string9 = "";
                string8 = "";
                if (string10 != null && string10.indexOf("-") > 0) {
                    string9 = string10.substring(0, string10.indexOf("-"));
                    string8 = string10.substring(string10.indexOf("-") + 1, string10.length());
                }
                n3 = this.convertTimeInMinutes(string9);
                n2 = this.convertTimeInMinutes(string8);
                if (!string11.equals("*")) break block34;
                n = 0;
                int n7 = 0;
                if (string9 != null && string9.indexOf(":") > 0) {
                    n = Integer.parseInt(string9.substring(0, string9.indexOf(":")));
                }
                if (string8 != null && string8.indexOf(":") > 0) {
                    n7 = Integer.parseInt(string8.substring(0, string8.indexOf(":")));
                }
                if (n > n7) {
                    string7 = string9 + "-23:59";
                    object = "00:00-" + string8;
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    if (this.checkTime((String)object, string4, string5)) {
                        return true;
                    }
                    break block33;
                } else if (n3 > n2) {
                    string7 = string9 + "-23:59";
                    object = "00:00-" + string8;
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    if (this.checkTime((String)object, string4, string5)) {
                        return true;
                    }
                    break block33;
                } else {
                    if (!this.checkTime(string10, string4, string5)) return false;
                    return true;
                }
            }
            if (string11.equalsIgnoreCase("LDM")) {
                n = gregorianCalendar.getActualMaximum(5);
                if (n6 != n) return false;
                if (n3 > n2) {
                    String string12 = string9 + "-23:59";
                    string7 = "00:00-" + string8;
                    if (this.checkTime(string12, string4, string5)) {
                        return true;
                    }
                    if (this.checkTime(string7, string4, string5)) {
                        return true;
                    }
                    break block33;
                } else {
                    if (!this.checkTime(string10, string4, string5)) return false;
                    return true;
                }
            }
            if (string11.equalsIgnoreCase("FDM")) {
                if (n6 != 1) return false;
                if (n3 > n2) {
                    String string13 = string9 + "-23:59";
                    String string14 = "00:00-" + string8;
                    if (this.checkTime(string13, string4, string5)) {
                        return true;
                    }
                    if (!this.checkTime(string14, string4, string5)) return false;
                    return true;
                }
                if (!this.checkTime(string10, string4, string5)) return false;
                return true;
            }
            if (string11.indexOf("Every") > -1) {
                String string15 = string11.substring(6);
                int n8 = Integer.parseInt(string15);
                if (n6 != n8) return false;
                if (n3 > n2) {
                    String string16 = string9 + "-23:59";
                    String string17 = "00:00-" + string8;
                    if (this.checkTime(string16, string4, string5)) {
                        return true;
                    }
                    if (!this.checkTime(string17, string4, string5)) return false;
                    return true;
                }
                if (!this.checkTime(string10, string4, string5)) return false;
                return true;
            }
        }
        gregorianCalendar = new GregorianCalendar(n4, n5 - 1, n6);
        n = gregorianCalendar.get(7);
        if (string11.startsWith("Sun") && n == 1 || string11.startsWith("Mon") && n == 2 || string11.startsWith("Tue") && n == 3 || string11.startsWith("Wed") && n == 4 || string11.startsWith("Thu") && n == 5 || string11.startsWith("Fri") && n == 6 || string11.startsWith("Sat") && n == 7) {
            if (string11 != null && string11.indexOf("$") > 0 && string11.indexOf("_") > 0) {
                int n9;
                int n10;
                String string18 = string11.substring(string11.indexOf("_") + 1);
                int n11 = Integer.parseInt(string18);
                double d = EgMaintenanceInfo.findNthWeekDayOfTheMonth(n11, n, n10 = n5, n9 = n4);
                int n12 = (int)d;
                if (n6 != n12) return false;
                if (n3 > n2) {
                    String string19 = string9 + "-23:59";
                    String string20 = "00:00-" + string8;
                    if (this.checkTime(string19, string4, string5)) {
                        return true;
                    }
                    if (!this.checkTime(string20, string4, string5)) return false;
                    return true;
                }
                if (!this.checkTime(string10, string4, string5)) return false;
                return true;
            }
            if (n3 > n2) {
                String string21 = string9 + "-23:59";
                string7 = "00:00-" + string8;
                if (this.checkTime(string21, string4, string5)) {
                    return true;
                }
                if (!this.checkTime(string7, string4, string5)) return false;
                return true;
            }
            if (!this.checkTime(string10, string4, string5)) return false;
            return true;
        }
        if (string11.indexOf("/") <= 1) return false;
        String string22 = "";
        string7 = "";
        if (string11 != null && string11.indexOf("|") > 0) {
            string22 = string11.substring(0, string11.indexOf("|"));
            string7 = string11.substring(string11.indexOf("|") + 1, string11.length());
        } else {
            string22 = string11.substring(string11.indexOf("#") + 1, string11.length());
            string7 = string11.substring(string11.indexOf("#") + 1, string11.length());
        }
        object = new Date(string22 + " " + string9);
        Date date = new Date(string7 + " " + string8);
        Date date2 = new Date(n5 + "/" + n6 + "/" + n4 + " " + string4 + ":" + string5);
        if (!date2.after((Date)object)) {
            if (!date2.equals(object)) return false;
        }
        if (date2.before(date)) return true;
        if (!date2.equals(date)) return false;
        return true;
    }

    private boolean checkTime(String string, String string2, String string3) {
        try {
            long l;
            ArrayList arrayList = EgMaintenanceInfo.myTokenizer(string, "-");
            String string4 = (String)arrayList.get(0);
            String string5 = (String)arrayList.get(1);
            arrayList = EgMaintenanceInfo.myTokenizer(string4, ":");
            int n = Integer.parseInt((String)arrayList.get(0));
            int n2 = Integer.parseInt((String)arrayList.get(1));
            arrayList = EgMaintenanceInfo.myTokenizer(string5, ":");
            int n3 = Integer.parseInt((String)arrayList.get(0));
            int n4 = Integer.parseInt((String)arrayList.get(1));
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                return false;
            }
            long l2 = n * 60 + n2;
            long l3 = n3 * 60 + n4;
            long l4 = Integer.parseInt(string2);
            long l5 = l4 * 60L + (l = (long)Integer.parseInt(string3));
            return l5 >= l2 && l5 <= l3;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, boolean bl) {
        return this.isItMaintenanceTime(string, string2, string3, string4, bl, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, boolean bl, int n) {
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string2, string3, string4, true, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string2, string3, string4, true, n);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string, arrayList3, n)) {
            bl2 = true;
        }
        return bl2;
    }

    public Hashtable getMaintenanceTimePeriod(String string, String string2, String string3, String string4, boolean bl) {
        return this.getMaintenanceTimePeriod(string, string2, string3, string4, bl, 1);
    }

    public Hashtable getMaintenanceTimePeriod(String string, String string2, String string3, String string4, boolean bl, int n) {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string2, string3, string4, true, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string2, string3, string4, true, n);
        ArrayList arrayList3 = this.getUnplannedMaintenancePeriodsDisplay(string2, string3, string4, true);
        ArrayList arrayList4 = new ArrayList();
        if (arrayList != null) {
            arrayList4.addAll(arrayList);
        }
        if (arrayList4 != null) {
            if (arrayList3 != null) {
                arrayList4.addAll(arrayList3);
            }
        } else if (arrayList3 != null) {
            arrayList4 = arrayList3;
        }
        try {
            if (arrayList4 != null && arrayList4.size() > 0 && this.isItMaintenanceTime(string, arrayList2, n)) {
                bl2 = true;
                hashtable.put("isUnderMaintenance", new Boolean(bl2));
                hashtable.put("MaintenancePeriods", arrayList4);
            } else {
                hashtable.put("isUnderMaintenance", new Boolean(bl2));
                hashtable.put("MaintenancePeriods", new ArrayList());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            hashtable = new Hashtable();
            hashtable.put("isUnderMaintenance", new Boolean(false));
            hashtable.put("MaintenancePeriods", new ArrayList());
        }
        return hashtable;
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return this.isItMaintenanceTime(string, string2, string3, string4, string5, bl, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, String string3, String string4, String string5, boolean bl, int n) {
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string, string3, string4, string5, true, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, string3, string4, string5, true, n);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isItMaintenanceTime(String string, String string2, boolean bl) {
        return this.isItMaintenanceTime(string, string2, bl, 1);
    }

    public boolean isItMaintenanceTime(String string, String string2, boolean bl, int n) {
        boolean bl2 = false;
        ArrayList arrayList = this.getMaintenancePeriods(string, true, n);
        ArrayList arrayList2 = this.getUnplannedMaintenancePeriods(string, true, n);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList3 != null) {
            if (arrayList2 != null) {
                arrayList3.addAll(arrayList2);
            }
        } else if (arrayList2 != null) {
            arrayList3 = arrayList2;
        }
        if (arrayList3 != null && arrayList3.size() > 0 && this.isItMaintenanceTime(string2, arrayList3, n)) {
            bl2 = true;
        }
        return bl2;
    }

    public ArrayList getMaintenancePeriods(String string, boolean bl) {
        return this.getMaintenancePeriods(string, bl, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMaintenancePeriods(String string, boolean bl, int n) {
        String string2;
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        if ((arrayList = (ArrayList)maintenanceDetails.get(string2 = '#' + string)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    maintenanceDetails.put(string2, arrayList2);
                }
                return arrayList2;
            }
            arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl2 = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string4);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string5 = (String)arrayList3.get(j);
                        arrayList2.add(string5);
                    }
                }
            }
            if (!bl2) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                maintenanceDetails.put(string2, arrayList2);
            }
            return arrayList2;
        }
    }

    public ArrayList getMaintenancePeriods(String string, String string2, String string3, boolean bl) {
        return this.getMaintenancePeriods(string, string2, string3, bl, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, boolean bl, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string4 = string;
        if (string2 != null && !string2.equals("")) {
            string4 = string + ":" + string2;
        }
        String string5 = null;
        String string6 = string4;
        if (string3 != null && string3.length() > 0) {
            string6 = string5 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)maintenanceDetails.get(string6)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    maintenanceDetails.put(string6, arrayList2);
                }
                return arrayList2;
            }
            arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6)) continue;
                bl2 = true;
                String string7 = null;
                string7 = (String)vector.get(i);
                if (string7 == null || string7.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string8);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string9 = (String)arrayList3.get(j);
                        arrayList2.add(string9);
                    }
                }
            }
            if (!bl2) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                maintenanceDetails.put(string6, arrayList2);
            }
            return arrayList2;
        }
    }

    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, boolean bl) {
        return this.getMaintenancePeriods(string, string2, string3, string4, bl, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMaintenancePeriods(String string, String string2, String string3, String string4, boolean bl, int n) {
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string5 = string2;
        if (string3 != null && string3.length() > 0) {
            string5 = string5 + ":" + string3;
        }
        if (string4 != null && string4.length() > 0) {
            string5 = string5 + ":" + string4;
            string5 = string5 + '#' + string;
        } else {
            string5 = string5 + '#' + string;
        }
        ArrayList arrayList = (ArrayList)maintenanceDetails.get(string5);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        ArrayList arrayList2 = policySection;
        synchronized (policySection) {
            stringArray = maintenanceFilePointer.getVariables(serverSection);
            vector = maintenanceFilePointer.getAllValues(serverSection);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            if (stringArray == null || stringArray.length == 0) {
                arrayList2 = this.getGroupInfo(defaultGroup);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    maintenanceDetails.put(string5, arrayList2);
                }
                return arrayList2;
            }
            arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5)) continue;
                bl2 = true;
                String string6 = null;
                string6 = (String)vector.get(i);
                if (string6 == null || string6.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getGroupInfo(string7);
                    if (arrayList3 == null) continue;
                    int n2 = arrayList3.size();
                    for (int j = 0; j < n2; ++j) {
                        String string8 = (String)arrayList3.get(j);
                        arrayList2.add(string8);
                    }
                }
            }
            if (!bl2) {
                arrayList2 = this.getGroupInfo(defaultGroup);
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                maintenanceDetails.put(string5, arrayList2);
            }
            return arrayList2;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3) {
        return this.getUnplannedMaintenancePeriods(string, string2, string3, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string4 = string + ":" + string2;
        String string5 = string;
        String string6 = null;
        String string7 = string4;
        if (string3 != null && string3.length() > 0) {
            string7 = string6 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string7)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var12_12] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string8 = stringArray[i];
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                String string9 = "";
                if (string8.startsWith("*") && string8.endsWith("*")) {
                    string9 = string8.substring(1, string8.lastIndexOf("*"));
                    bl2 = true;
                } else if (string8.startsWith("*")) {
                    string9 = string8.substring(1);
                    bl3 = true;
                } else if (string8.endsWith("*")) {
                    string9 = string8.substring(0, string8.lastIndexOf("*"));
                    bl4 = true;
                }
                string9 = string9.toLowerCase();
                String string10 = string5.toLowerCase();
                string10 = this.replaceStringWithEquals(string10);
                if (!(stringArray[i].equals(string5) || stringArray[i].equals(string4) || string6 != null && stringArray[i].equals(string6) || bl2 && string10.indexOf(string9) > -1 || bl3 && string10.endsWith(string9)) && (!bl4 || !string10.startsWith(string9))) continue;
                bl = true;
                String string11 = null;
                string11 = (String)vector.get(i);
                if (string11 == null || string11.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string11, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string12 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string12);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string13 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string13);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string7, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getUnplannedPolicyInfo(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = policySection;
        synchronized (policySection) {
            string2 = maintenanceFilePointer.getValue(unplannedPolicySection, string);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ArrayList getUnplannedPolicyInfoDisplay(String string) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = unplannedPolicySectionDisplay;
        // MONITORENTER : "UNPLANNED_POLICIES_DISPLAY"
        string2 = maintenanceFilePointer.getValue(unplannedPolicySectionDisplay, string);
        // MONITOREXIT : object
        if (string2 == null || string2.trim().length() == 0) {
            object = unplannedPolicySection;
            // MONITORENTER : "UNPLANNED_POLICIES"
            string2 = maintenanceFilePointer.getValue(unplannedPolicySection, string);
            // MONITOREXIT : object
        }
        if (string2 == null) return null;
        if (string2.trim().length() == 0) {
            return null;
        }
        object = new StringTokenizer(string2, ",");
        while (((StringTokenizer)object).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object).nextToken());
        }
        return arrayList;
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4) {
        return this.getUnplannedMaintenancePeriods(string, string2, string3, string4, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string5 = "";
        string5 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string;
        String string6 = string2 + '#' + string;
        String string7 = null;
        String string8 = string5;
        if (string4 != null && string4.length() > 0) {
            string7 = string5 + ":" + string4;
            string8 = string7 = string7 + '#' + string;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string8)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string6) && !stringArray[i].equals(string5) && (string7 == null || !stringArray[i].equals(string7))) continue;
                bl = true;
                String string9 = null;
                string9 = (String)vector.get(i);
                if (string9 == null || string9.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string9, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string10 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string10);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string11 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string11);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string8, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, String string5) {
        return this.getUnplannedMaintenancePeriods(string, string2, string3, string4, string5, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, String string5, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        string5 = this.replaceStringWithEquals(string5);
        String string6 = "";
        string6 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string + ":" + string5;
        String string7 = string2 + '#' + string + ":" + string5;
        String string8 = null;
        String string9 = string6;
        if (string4 != null && string4.length() > 0) {
            string8 = string6 + ":" + string4;
            string9 = string8 = string8 + '#' + string + ":" + string5;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string9.trim())) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var14_14] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string7) && !stringArray[i].equalsIgnoreCase(string6) && (string8 == null || !stringArray[i].equalsIgnoreCase(string8))) continue;
                bl = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string11);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string12 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string12);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string9, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriodsDisplay(String string, String string2, String string3, String string4, String string5) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        string5 = this.replaceStringWithEquals(string5);
        String string6 = "";
        string6 = string4 != null && string4.length() > 0 ? string2 + ":" + string3 : string2 + ":" + string3 + '#' + string + ":" + string5;
        String string7 = string2 + '#' + string + ":" + string5;
        String string8 = null;
        String string9 = string6;
        if (string4 != null && string4.length() > 0) {
            string8 = string6 + ":" + string4;
            string9 = string8 = string8 + '#' + string + ":" + string5;
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriodsDisplay.get(string9.trim())) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string7) && !stringArray[i].equalsIgnoreCase(string6) && (string8 == null || !stringArray[i].equalsIgnoreCase(string8))) continue;
                bl = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfoDisplay(string11);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string12 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string11 + "|@|" + string12);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriodsDisplay.put(string9, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string) {
        return this.getUnplannedMaintenancePeriods(string, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, int n) {
        String string2;
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        if ((arrayList = (ArrayList)unplannedMaintenancePeriods.get(string2 = '#' + string)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string4);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string5 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string5);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriods.put(string2, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, String string2) {
        return this.getUnplannedMaintenancePeriods(string, string2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, int n) {
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        string2 = this.replaceStringWithEquals(string2);
        String string3 = '#' + string + ":" + string2.trim();
        ArrayList arrayList = (ArrayList)unplannedMaintenancePeriods.get(string3);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        boolean bl = false;
        Object object = policySection;
        synchronized (policySection) {
            HashSet hashSet;
            String string4;
            int n2;
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            object = this.getWildCardMaintenanceTestPatterns();
            if (object != null && !object.isEmpty()) {
                int n3 = object.size();
                String string5 = string;
                if (string5 != null) {
                    string5 = string5.toUpperCase();
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    string4 = (String)object.get(n2);
                    if (string5 == null || !string5.startsWith(string4)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl && (hashSet = this.getWildCardMaintenanceTestList()) != null && hashSet.size() > 0 && string != null && hashSet.contains(string)) {
                bl = true;
            }
            ArrayList arrayList2 = new ArrayList();
            boolean bl2 = false;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string4 = stringArray[n2];
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                String string6 = "";
                if (string4.startsWith("*") && string4.endsWith("*")) {
                    string6 = string4.substring(1, string4.lastIndexOf("*"));
                    bl3 = true;
                } else if (string4.startsWith("*")) {
                    string6 = string4.substring(1);
                    bl4 = true;
                } else if (string4.endsWith("*")) {
                    string6 = string4.substring(0, string4.lastIndexOf("*"));
                    bl5 = true;
                }
                string6 = string6.toLowerCase();
                String string7 = string2.toLowerCase();
                if (!stringArray[n2].equalsIgnoreCase(string3) && (!bl || !(bl3 && string7.indexOf(string6) > -1 || bl4 && string7.endsWith(string6)) && (!bl5 || !string7.startsWith(string6)))) continue;
                bl2 = true;
                String string8 = null;
                string8 = (String)vector.get(n2);
                if (string8 == null || string8.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string8, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string9 = stringTokenizer.nextToken();
                    ArrayList arrayList3 = this.getUnplannedPolicyInfo(string9);
                    if (arrayList3 == null) continue;
                    int n4 = arrayList3.size();
                    for (int i = 0; i < n4; ++i) {
                        String string10 = (String)arrayList3.get(i);
                        arrayList2.add(string10);
                    }
                }
            }
            if ((arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2)) != null && arrayList2.size() > 0) {
                unplannedMaintenancePeriods.put(string3, arrayList2);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriodsDisplay(String string, String string2) {
        EgMaintenanceInfo.checkForUpdate();
        string2 = this.replaceStringWithEquals(string2);
        String string3 = '#' + string + ":" + string2.trim();
        ArrayList arrayList = (ArrayList)unplannedMaintenancePeriodsDisplay.get(string3);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            object = new ArrayList();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                String string5 = "";
                if (string4.startsWith("*") && string4.endsWith("*")) {
                    string5 = string4.substring(1, string4.lastIndexOf("*"));
                    bl2 = true;
                } else if (string4.startsWith("*")) {
                    string5 = string4.substring(1);
                    bl3 = true;
                } else if (string4.endsWith("*")) {
                    string5 = string4.substring(0, string4.lastIndexOf("*"));
                    bl4 = true;
                }
                string5 = string5.toLowerCase();
                String string6 = string2.toLowerCase();
                if (!stringArray[i].equalsIgnoreCase(string3) && (string == null || !string.startsWith("Vmg") || !(bl2 && string6.indexOf(string5) > -1 || bl3 && string6.endsWith(string5)) && (!bl4 || !string6.startsWith(string5)))) continue;
                bl = true;
                String string7 = null;
                string7 = (String)vector.get(i);
                if (string7 == null || string7.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfoDisplay(string8);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string9 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string8 + "|@|" + string9);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenancePeriodsDisplay.put(string3, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, boolean bl) {
        return this.getUnplannedMaintenancePeriods(string, bl, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, boolean bl, int n) {
        String string2;
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        if ((arrayList = (ArrayList)unplannedMaintenanceDetails.get(string2 = '#' + string)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl2 = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string4);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string5 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string5);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetails.put(string2, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriodsDisplay(String string, boolean bl) {
        EgMaintenanceInfo.checkForUpdate();
        String string2 = '#' + string;
        ArrayList arrayList = (ArrayList)unplannedMaintenanceDetailsDisplay.get(string2);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                bl2 = true;
                String string3 = null;
                string3 = (String)vector.get(i);
                if (string3 == null || string3.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfoDisplay(string4);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string5 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string4 + "|@|" + string5);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetailsDisplay.put(string2, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, boolean bl) {
        return this.getUnplannedMaintenancePeriods(string, string2, string3, bl, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, boolean bl, int n) {
        ArrayList arrayList;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string4 = string;
        if (string2 != null && !string2.equals("")) {
            string4 = string + ":" + string2;
        }
        String string5 = null;
        String string6 = string4;
        if (string3 != null && string3.length() > 0) {
            string6 = string5 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)unplannedMaintenanceDetails.get(string6)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var12_12] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = stringArray[i];
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                String string8 = "";
                if (string7.startsWith("*") && string7.endsWith("*")) {
                    string8 = string7.substring(1, string7.lastIndexOf("*"));
                    bl3 = true;
                } else if (string7.startsWith("*")) {
                    string8 = string7.substring(1);
                    bl4 = true;
                } else if (string7.endsWith("*")) {
                    string8 = string7.substring(0, string7.lastIndexOf("*"));
                    bl5 = true;
                }
                string8 = string8.toLowerCase();
                String string9 = string6.toLowerCase();
                string9 = this.replaceStringWithEquals(string9);
                if (!(stringArray[i].equals(string6) || bl3 && string9.indexOf(string8) > -1 || bl4 && string9.endsWith(string8)) && (!bl5 || !string9.startsWith(string8))) continue;
                bl2 = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string11);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string12 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string12);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetails.put(string6, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriodsDisplay(String string, String string2, String string3, boolean bl) {
        ArrayList arrayList;
        EgMaintenanceInfo.checkForUpdate();
        String string4 = string;
        if (string2 != null && !string2.equals("")) {
            string4 = string + ":" + string2;
        }
        String string5 = null;
        String string6 = string4;
        if (string3 != null && string3.length() > 0) {
            string6 = string5 = string4 + ":" + string3;
        }
        if ((arrayList = (ArrayList)unplannedMaintenanceDetailsDisplay.get(string6)) != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = stringArray[i];
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                String string8 = "";
                if (string7.startsWith("*") && string7.endsWith("*")) {
                    string8 = string7.substring(1, string7.lastIndexOf("*"));
                    bl3 = true;
                } else if (string7.startsWith("*")) {
                    string8 = string7.substring(1);
                    bl4 = true;
                } else if (string7.endsWith("*")) {
                    string8 = string7.substring(0, string7.lastIndexOf("*"));
                    bl5 = true;
                }
                string8 = string8.toLowerCase();
                String string9 = string6.toLowerCase();
                string9 = this.replaceStringWithEquals(string9);
                if (!(stringArray[i].equals(string6) || bl3 && string9.indexOf(string8) > -1 || bl4 && string9.endsWith(string8)) && (!bl5 || !string9.startsWith(string8))) continue;
                bl2 = true;
                String string10 = null;
                string10 = (String)vector.get(i);
                if (string10 == null || string10.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfoDisplay(string11);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string12 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string11 + "|@|" + string12);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetailsDisplay.put(string6, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, boolean bl) {
        return this.getUnplannedMaintenancePeriods(string, string2, string3, string4, bl, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriods(String string, String string2, String string3, String string4, boolean bl, int n) {
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String string5 = string2;
        if (string3 != null && string3.length() > 0) {
            string5 = string5 + ":" + string3;
        }
        if (string4 != null && string4.length() > 0) {
            string5 = string5 + ":" + string4;
            string5 = string5 + '#' + string;
        } else {
            string5 = string5 + '#' + string;
        }
        ArrayList arrayList = (ArrayList)unplannedMaintenanceDetails.get(string5);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5)) continue;
                bl2 = true;
                String string6 = null;
                string6 = (String)vector.get(i);
                if (string6 == null || string6.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfo(string7);
                    if (arrayList2 == null) continue;
                    int n2 = arrayList2.size();
                    for (int j = 0; j < n2; ++j) {
                        String string8 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string8);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetails.put(string5, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUnplannedMaintenancePeriodsDisplay(String string, String string2, String string3, String string4, boolean bl) {
        EgMaintenanceInfo.checkForUpdate();
        String string5 = string2;
        if (string3 != null && string3.length() > 0) {
            string5 = string5 + ":" + string3;
        }
        if (string4 != null && string4.length() > 0) {
            string5 = string5 + ":" + string4;
            string5 = string5 + '#' + string;
        } else {
            string5 = string5 + '#' + string;
        }
        ArrayList arrayList = (ArrayList)unplannedMaintenanceDetailsDisplay.get(string5);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object = policySection;
        synchronized (policySection) {
            if (keepDataInMemory) {
                stringArray = upm_vars;
                vector = upm_vv;
            } else {
                stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
                vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
            }
            // ** MonitorExit[var10_10] (shouldn't be in output)
            object = new ArrayList();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string5)) continue;
                bl2 = true;
                String string6 = null;
                string6 = (String)vector.get(i);
                if (string6 == null || string6.length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    ArrayList arrayList2 = this.getUnplannedPolicyInfoDisplay(string7);
                    if (arrayList2 == null) continue;
                    int n = arrayList2.size();
                    for (int j = 0; j < n; ++j) {
                        String string8 = (String)arrayList2.get(j);
                        ((ArrayList)object).add(string7 + "|@|" + string8);
                    }
                }
            }
            if ((object = EgMaintenanceInfo.removeDuplicates((ArrayList)object)) != null && ((ArrayList)object).size() > 0) {
                unplannedMaintenanceDetailsDisplay.put(string5, object);
            }
            return object;
        }
    }

    public ArrayList getUnplannedMaintenanceDetails(ArrayList arrayList) {
        return this.getUnplannedMaintenanceDetails(arrayList, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ArrayList getUnplannedMaintenanceDetails(ArrayList arrayList, int n) {
        Object object;
        Object object2;
        int n2;
        if (n == 1) {
            EgMaintenanceInfo.checkForUpdate();
        }
        String[] stringArray = null;
        Vector vector = null;
        Object object3 = policySection;
        // MONITORENTER : "POLICIES"
        if (keepDataInMemory) {
            stringArray = upm_vars;
            vector = upm_vv;
        } else {
            stringArray = maintenanceFilePointer.getVariables(unplannedPolicyMappingSection);
            vector = maintenanceFilePointer.getAllValues(unplannedPolicyMappingSection);
        }
        // MONITOREXIT : object3
        object3 = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string = stringArray[n2];
            String string2 = (String)vector.get(n2);
            if (string2 == null || string2.length() == 0) continue;
            if (string.startsWith("*") || string.endsWith("*")) {
                ((ArrayList)object3).add(string + "=" + string2);
                object2 = new StringTokenizer(string2, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object2).nextToken();
                    arrayList2.add(string3);
                }
                continue;
            }
            if (string.startsWith("#")) {
                ((ArrayList)object3).add(string + "=" + string2);
                object2 = new StringTokenizer(string2, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object2).nextToken();
                    arrayList2.add(string4);
                }
                continue;
            }
            object2 = string;
            int n3 = string.indexOf(":");
            if (n3 != -1) {
                object2 = string.substring(0, n3);
            } else {
                int n4 = string.indexOf("#");
                if (n4 != -1) {
                    object2 = string.substring(0, n4);
                }
            }
            if (!arrayList.contains(object2)) continue;
            ((ArrayList)object3).add(string + "=" + string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                arrayList2.add(object);
            }
        }
        arrayList2 = EgMaintenanceInfo.removeDuplicates(arrayList2);
        n2 = ((ArrayList)object3).size();
        if (n2 <= 0) return arrayList3;
        arrayList3.add("[UNPLANNED_POLICY_MAPPING]");
        arrayList3.addAll((Collection<String>)object3);
        arrayList3.add("[UNPLANNED_POLICIES]");
        int n5 = arrayList2.size();
        for (int i = 0; i < n5; ++i) {
            object2 = (String)arrayList2.get(i);
            String string = null;
            String string5 = policySection;
            // MONITORENTER : "POLICIES"
            string = maintenanceFilePointer.getValue(unplannedPolicySection, (String)object2);
            // MONITOREXIT : string5
            if (string == null || string.trim().length() <= 0) continue;
            arrayList3.add((String)object2 + "=" + string);
        }
        String[] stringArray2 = null;
        object2 = policySection;
        // MONITORENTER : "POLICIES"
        stringArray2 = maintenanceFilePointer.getSubjects();
        // MONITOREXIT : object2
        int n6 = 0;
        while (n6 < stringArray2.length) {
            String string = stringArray2[n6];
            if (!string.equalsIgnoreCase(unplannedPolicySection) && !string.equalsIgnoreCase(unplannedPolicyMappingSection)) {
                String[] stringArray3 = null;
                object = null;
                String string6 = policySection;
                // MONITORENTER : "POLICIES"
                stringArray3 = maintenanceFilePointer.getVariables(string);
                object = maintenanceFilePointer.getAllValues(string);
                // MONITOREXIT : string6
                int n7 = stringArray3.length;
                if (n7 > 0) {
                    arrayList3.add("[" + string + "]");
                    for (int i = 0; i < n7; ++i) {
                        String string7 = stringArray3[i];
                        String string8 = (String)((Vector)object).get(i);
                        arrayList3.add(string7 + "=" + string8);
                    }
                }
            }
            ++n6;
        }
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWildCardMaintenanceTestPatterns() {
        String string;
        EgMaintenanceInfo.checkForUpdate();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (wildCardMaintenanceTestPatterns != null && wildCardMaintenanceTestPatterns.size() > 0) {
                return wildCardMaintenanceTestPatterns;
            }
            string = "";
            Object object = policySection;
            synchronized (policySection) {
                string = maintenanceFilePointer.getValue("MISC_ARGS", "WildcardMaintenanceTestPatterns");
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (string != null && string.length() <= 0) {
                    string = "Vmg,Vsg,XDVD,VD,Vs,Vm";
                }
                if (string != null && string.length() > 0) {
                    object = new StringTokenizer(string, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string2 = ((StringTokenizer)object).nextToken();
                        if (string2 != null) {
                            string2 = string2.toUpperCase();
                        }
                        arrayList.add(string2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        {
            string = policySection;
            synchronized (policySection) {
                wildCardMaintenanceTestPatterns = arrayList;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return arrayList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getWildCardMaintenanceTestList() {
        String string;
        EgMaintenanceInfo.checkForUpdate();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            if (wildCardMaintenanceTests != null && wildCardMaintenanceTests.size() > 0) {
                return (HashSet)wildCardMaintenanceTests.clone();
            }
            string = "";
            Object object = policySection;
            synchronized (policySection) {
                string = maintenanceFilePointer.getValue("MISC_ARGS", "WildCardMaintenanceTests");
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (string != null && string.length() > 0) {
                    object = new StringTokenizer(string, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string2 = ((StringTokenizer)object).nextToken();
                        hashSet.add(string2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        {
            string = policySection;
            synchronized (policySection) {
                wildCardMaintenanceTests = hashSet;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return wildCardMaintenanceTests;
            }
        }
    }

    public String replaceStringWithEquals(String string) {
        string = string.replace("=", "|equ|");
        return string;
    }
}

