/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.EgCrypt;
import com.eg.EgUtils;
import com.eg.IniFile;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public abstract class RedisBase
extends GenericTest {
    public RedisInfo redisInfo = null;
    boolean isItAgentLessComp = false;
    private static final String COLON_DELIMITER = ":";
    private static final String COMMA_DELIMITER = ",";
    private static final String EQUALS_DELIMITER = "=";
    private static final String HASH_DELIMITER = "#";
    private static final int REDIS_DEFAULT_PORT = 6379;
    private static final String REDIS_DEFAULT_IP = "127.0.0.1";
    public static String installDir = EgInstallInfo.getInstallDir();
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    public static final Logger logger = AgentLogger.testLogger;
    protected final String testStart = " " + this.entity + " - " + "Test cycle START";
    protected final String testEnd = " " + this.entity + " - " + "Test cycle END";
    protected String logPrefix = " [" + this.reportingName + ":" + this.portNo + "] [" + this.entity + "] ";
    private String descriptorName = "";
    boolean isDescriptorName = false;
    public Hashtable hshValidatorList = new Hashtable();
    private double previousUpTime = 0.0;
    private boolean isRestarted = false;

    public RedisBase(String[] args) {
        super(args);
        try {
            logger.info("{} Initializing RedisBase ...", (Object)this.logPrefix);
            this.redisInfo = new RedisInfo(this.reportingName);
            String expectedRedisRole = this.getValueForParam("expected_redis_role");
            if (expectedRedisRole == null || expectedRedisRole.length() <= 0 || expectedRedisRole.equalsIgnoreCase("none")) {
                logger.info("{} Expected REDIS Role is null or empty or none : {}", (Object)this.logPrefix, (Object)expectedRedisRole);
                logger.info("{} Continuing without REDIS Role", (Object)this.logPrefix);
                this.redisInfo.setRedisRole(expectedRedisRole);
            } else {
                this.redisInfo.setRedisRole(expectedRedisRole);
                logger.info("{} Redis Server is configured with expected Redis role :{}", (Object)this.logPrefix, (Object)expectedRedisRole);
            }
            String redisUsername = this.getValueForParam("username");
            if (redisUsername == null || redisUsername.length() <= 0 || redisUsername.equalsIgnoreCase("none")) {
                logger.info("{} REDIS username is null or empty or none : {}", (Object)this.logPrefix, (Object)redisUsername);
                logger.info("{} Continuing without username", (Object)this.logPrefix);
            } else {
                this.redisInfo.setRedisUser(redisUsername);
                logger.info("{} Redis Server is enabled with username authentication.", (Object)this.logPrefix);
            }
            String redisPass = this.getValueForParam("Redis_password");
            if (redisPass == null || redisPass.length() <= 0 || redisPass.equalsIgnoreCase("none")) {
                logger.info("{} REDIS password is null or empty or none : {}", (Object)this.logPrefix, (Object)redisPass);
                logger.info("{} Continuing without password", (Object)this.logPrefix);
            } else {
                this.redisInfo.setRedisPass(redisPass);
                logger.info("{} Redis Server is enabled with password authentication.", (Object)this.logPrefix);
            }
            this.isItAgentLessComp = this.isSSH && this.alos != null && this.alos.equalsIgnoreCase("LINUX");
            logger.debug("{} isItAgentLessComp flag : {}", (Object)this.logPrefix, (Object)this.isItAgentLessComp);
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info("{} REDIS IPAddress is null or empty or none : {}", (Object)this.logPrefix, (Object)this.targetHost);
                logger.info("{} Using Default REDIS IPAddress :", (Object)this.logPrefix, (Object)REDIS_DEFAULT_IP);
                this.redisInfo.setRedisIp(REDIS_DEFAULT_IP);
            } else {
                logger.info("{} Using REDIS IPAddress : {}", (Object)this.logPrefix, (Object)this.targetHost);
                this.redisInfo.setRedisIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info("{} REDIS Port is null or empty or none : {}", (Object)this.logPrefix, (Object)this.portNo);
                logger.info("{} Using Default REDIS port : {}", (Object)this.logPrefix, (Object)6379);
                this.redisInfo.setRedisPort(6379);
            } else {
                try {
                    int redisPort = Integer.parseInt(this.portNo);
                    logger.info("{} Using REDIS Port : {}", (Object)this.logPrefix, (Object)redisPort);
                    this.redisInfo.setRedisPort(redisPort);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info("{} Invalid Redis port number :{}", (Object)this.logPrefix, (Object)this.portNo);
                    logger.info("{} Using Default REDIS port : {}", (Object)this.logPrefix, (Object)6379);
                    this.redisInfo.setRedisPort(6379);
                }
            }
            try {
                String redisSsl = this.getValueForParam("ssl");
                boolean ssl = Boolean.parseBoolean(redisSsl);
                this.redisInfo.setRedisSsl(ssl);
                logger.info("{} Using Redis SSL : {}", (Object)this.logPrefix, (Object)this.redisInfo.isRedisSsl());
            }
            catch (Exception e) {
                logger.warn("{} Exception while getting ssl param {}", (Object)this.logPrefix, (Object)e);
            }
            this.updateINIFileObject();
            logger.info("{} RedisBase initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception e) {
            logger.warn("{} Exception while initializing RedisBase {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public List getKeys(String pattern, int maxCount) {
        ArrayList keys;
        block6: {
            keys = new ArrayList();
            Jedis jedis = null;
            try {
                try {
                    ScanResult scanResult;
                    jedis = this.getConnection();
                    ScanParams params = new ScanParams();
                    params.count(Integer.valueOf(maxCount));
                    params.match(pattern);
                    String cursor = "0";
                    do {
                        List result;
                        if ((result = (scanResult = jedis.scan(cursor, params)).getResult()) == null || result.size() <= 0) continue;
                        keys.addAll(result);
                    } while (!(cursor = scanResult.getCursor()).equals("0"));
                    keys = this.getKeyTypeAsStream(keys, jedis);
                }
                catch (Exception ex) {
                    logger.warn("{} Exception while getKeysFromClusterNode {}", (Object)this.logPrefix, (Object)ex);
                    this.logToErrorFile("ERROR", this.entity, "Exception occurred in getKeys: : " + ex.getMessage());
                    jedis.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                jedis.close();
                throw throwable;
            }
            jedis.close();
        }
        logger.info("{} RedisBase keys successfully", (Object)this.logPrefix, keys);
        return keys;
    }

    public ArrayList getKeyTypeAsStream(ArrayList arrList, Jedis jedis) {
        ArrayList<String> arrNewList = new ArrayList<String>();
        ArrayList arrInfoList = new ArrayList();
        try {
            int i = 0;
            while (i < arrList.size()) {
                String strKey = (String)arrList.get(i);
                String strType = jedis.type(strKey);
                if (strType != null && strType.length() > 0 && strType.equalsIgnoreCase("stream")) {
                    arrNewList.add(strKey);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.warn("{} Exception while getKeyTypeAsStream {}", (Object)this.logPrefix, (Object)ex);
            this.logToErrorFile("ERROR", this.entity, "Exception occurred in getKeyTypeAsStream: : " + ex.getMessage());
        }
        logger.info("{} RedisBase updated keys ", (Object)this.logPrefix, arrNewList);
        return arrNewList;
    }

    public String getMetrics(String redisCommand) {
        Jedis jedisConnection;
        String redisCommandOutput;
        block6: {
            if (redisCommand == null || redisCommand.length() <= 0) {
                logger.info("{} REDIS_COMMAND is NULL or EMPTY hence returning null String", (Object)this.logPrefix);
                return null;
            }
            redisCommandOutput = null;
            jedisConnection = null;
            jedisConnection = this.getConnection();
            if (jedisConnection != null) break block6;
            logger.info("{} JEDIS Connection object is NULL hence returning null String", (Object)this.logPrefix);
            this.closeConnection(jedisConnection);
            jedisConnection = null;
            return null;
        }
        try {
            try {
                redisCommandOutput = jedisConnection.info(redisCommand);
                logger.debug("{} Successfully executed the REDIS Command", (Object)this.logPrefix);
            }
            catch (Exception e) {
                logger.warn("{} [getRedisMetrics] Exception occured while connecting to Redis..", (Object)this.logPrefix, (Object)e);
                this.closeConnection(jedisConnection);
                jedisConnection = null;
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(jedisConnection);
            jedisConnection = null;
            throw throwable;
        }
        this.closeConnection(jedisConnection);
        jedisConnection = null;
        logger.debug("{} Result for REDIS Command [" + redisCommand + "] :{}", (Object)this.logPrefix, (Object)redisCommandOutput);
        return redisCommandOutput;
    }

    public Jedis getConnection() throws Exception {
        Jedis jedis = null;
        try {
            jedis = new Jedis(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort(), this.redisInfo.isRedisSsl());
            String redisUser = this.redisInfo.getRedisUser();
            String redisPwd = this.redisInfo.getRedisPass();
            logger.debug("{} {}", (Object)this.logPrefix, (Object)this.redisInfo);
            try {
                if (redisPwd != null && redisPwd.length() > 0 && !redisPwd.equalsIgnoreCase("none") && redisUser != null && redisUser.length() > 0 && !redisUser.equalsIgnoreCase("none")) {
                    jedis.auth(redisUser, redisPwd);
                    this.hshValidatorList.put("Connection", "connection ok with authenication");
                    logger.trace("{} JEDIS Connection authenticated with username {}, password[Encrypted] :{} .", new Object[]{this.logPrefix, redisUser, EgCrypt.encrypt((String)redisPwd)});
                    logger.debug("{} JEDIS Connection is created successfully with username & password", (Object)this.logPrefix);
                    return jedis;
                }
            }
            catch (Throwable e) {
                logger.warn("{} [getConnection] Error while connecting to Redis Server {}", (Object)this.logPrefix, (Object)e);
            }
            if (redisPwd == null || redisPwd.length() <= 0 || redisPwd.equalsIgnoreCase("none")) {
                logger.debug("{} REDIS password is null or empty or none : {} Hence returning the JEDIS Connection WITHOUT authenticating.", (Object)this.logPrefix, (Object)redisPwd);
                logger.debug("{} JEDIS Connection is created successfully !!!", (Object)this.logPrefix);
                this.hshValidatorList.put("Connection", "connection ok with out authenication");
                return jedis;
            }
            jedis.auth(redisPwd);
            this.hshValidatorList.put("Connection", "connection ok with authenication");
            logger.trace("{} Password authentication is success !!!", (Object)this.logPrefix);
            logger.debug("{} JEDIS Connection is created successfully with password authentication !!!", (Object)this.logPrefix);
            return jedis;
        }
        catch (JedisConnectionException connectionError) {
            logger.warn("{} [getConnection] Error while connecting to Redis Server {}", (Object)this.logPrefix, (Object)connectionError);
            this.hshValidatorList.put("Connection", "JedisConnectionException:" + connectionError.getMessage());
            this.closeConnection(jedis);
            throw connectionError;
        }
        catch (JedisDataException dataError) {
            logger.warn("{} [getConnection] Error while authenticating Redis Server {}", (Object)this.logPrefix, (Object)dataError);
            this.hshValidatorList.put("Connection", "dataError:" + dataError.getMessage());
            this.closeConnection(jedis);
            throw dataError;
        }
        catch (Exception e) {
            logger.warn("{} [getConnection] Error while authenticating Redis Server {}", (Object)this.logPrefix, (Object)e);
            this.hshValidatorList.put("Connection", "Exception:" + e.getMessage());
            this.closeConnection(jedis);
            throw e;
        }
    }

    public Jedis getConnection(String ip, int port) throws Exception {
        Jedis jedis = null;
        try {
            jedis = new Jedis(ip, port, this.redisInfo.isRedisSsl());
            String redisUser = this.redisInfo.getRedisUser();
            String redisPwd = this.redisInfo.getRedisPass();
            logger.debug("{} {}", (Object)this.logPrefix, (Object)this.redisInfo);
            try {
                if (redisPwd != null && redisPwd.length() > 0 && !redisPwd.equalsIgnoreCase("none") && redisUser != null && redisUser.length() > 0 && !redisUser.equalsIgnoreCase("none")) {
                    jedis.auth(redisUser, redisPwd);
                    this.hshValidatorList.put("Connection", "connection ok with authenication");
                    logger.trace("{} JEDIS Connection authenticated with username {}, password length :{} .", new Object[]{this.logPrefix, redisUser, redisPwd.length()});
                    logger.debug("{} JEDIS Connection is created successfully with username & password", (Object)this.logPrefix);
                    return jedis;
                }
            }
            catch (Throwable e) {
                logger.warn("{} [getConnection] Error while connecting to Redis Server {}", (Object)this.logPrefix, (Object)e);
            }
            if (redisPwd == null || redisPwd.length() <= 0 || redisPwd.equalsIgnoreCase("none")) {
                logger.debug("{} REDIS password is null or empty or none : {} Hence returning the JEDIS Connection WITHOUT authenticating.", (Object)this.logPrefix, (Object)redisPwd);
                logger.debug("{} JEDIS Connection is created successfully !!!", (Object)this.logPrefix);
                this.hshValidatorList.put("Connection", "connection ok with out authenication");
                return jedis;
            }
            jedis.auth(redisPwd);
            this.hshValidatorList.put("Connection", "connection ok with authenication");
            logger.trace("{} Password authentication is success !!!", (Object)this.logPrefix);
            logger.debug("{} JEDIS Connection is created successfully with password authentication !!!", (Object)this.logPrefix);
            return jedis;
        }
        catch (JedisConnectionException connectionError) {
            logger.warn("{} [getConnection] Error while connecting to Redis Server {}", (Object)this.logPrefix, (Object)connectionError);
            this.hshValidatorList.put("Connection", "JedisConnectionException:" + connectionError.getMessage());
            this.closeConnection(jedis);
            throw connectionError;
        }
        catch (JedisDataException dataError) {
            logger.warn("{} [getConnection] Error while authenticating Redis Server {}", (Object)this.logPrefix, (Object)dataError);
            this.hshValidatorList.put("Connection", "dataError:" + dataError.getMessage());
            this.closeConnection(jedis);
            throw dataError;
        }
        catch (Exception e) {
            logger.warn("{} [getConnection] Error while authenticating Redis Server {}", (Object)this.logPrefix, (Object)e);
            this.hshValidatorList.put("Connection", "Exception:" + e.getMessage());
            this.closeConnection(jedis);
            throw e;
        }
    }

    public void closeConnection(Jedis jedis) {
        if (jedis == null) {
            logger.trace("{} JEDIS Connection null or already closed !!!", (Object)this.logPrefix);
        } else {
            try {
                if (jedis.isConnected()) {
                    jedis.close();
                    jedis = null;
                    logger.debug("{} JEDIS Connection is closed successfully !!!", (Object)this.logPrefix);
                } else {
                    jedis = null;
                    logger.debug("{} JEDIS Connection is already closed !!!", (Object)this.logPrefix);
                }
            }
            catch (Exception localException3) {
                logger.warn("{} [closeConnection] Error while closing the Jedis connection {}", (Object)this.logPrefix, (Object)localException3);
            }
        }
    }

    public void updateINIFileObject() {
        if (iniFilePath != null && iniFilePath.length() != 0 && !iniFilePath.equalsIgnoreCase("none")) {
            try {
                IniFile egMeasures = new IniFile(String.valueOf(installDir) + iniFilePath);
                this.redisInfo.setEgMeasures(egMeasures);
                logger.debug("{} [updateINIFileObject] updating the INI File : {}", (Object)this.logPrefix, (Object)iniFilePath);
            }
            catch (Exception iniException) {
                logger.warn("{} [updateINIFileObject] Exception Occured  : {} {}", new Object[]{this.logPrefix, iniFilePath, iniException});
            }
        }
    }

    private boolean hasDescriptorName(String lineString) {
        if (lineString == null || lineString.length() <= 0) {
            return false;
        }
        return lineString.indexOf(COLON_DELIMITER) > -1 && lineString.indexOf(EQUALS_DELIMITER) > -1;
    }

    public boolean isValidMeasureLine(String lineString, String delimiter) {
        if (lineString == null || lineString.length() <= 0) {
            return false;
        }
        return lineString.indexOf(delimiter) > -1;
    }

    public boolean isValidCategoryLine(String lineString) {
        if (lineString == null || lineString.length() <= 0) {
            return false;
        }
        return lineString.indexOf(HASH_DELIMITER) >= 0;
    }

    public Hashtable parseMetrics(String measureString, boolean infoBased) {
        logger.debug("{} Inside [parseMetrics] the redis measures are being parsed ", (Object)this.logPrefix);
        Hashtable resultTable = new Hashtable();
        if (measureString == null) {
            measureString = "";
        }
        try {
            StringTokenizer lineTokenizer = new StringTokenizer(measureString, "\n");
            String category = "";
            Hashtable<String, String> nonInfoMeasureTable = new Hashtable<String, String>();
            Hashtable<String, String> infoMeasureTable = new Hashtable<String, String>();
            Hashtable<String, Hashtable<String, String>> descriptorTable = new Hashtable<String, Hashtable<String, String>>();
            while (lineTokenizer.hasMoreTokens()) {
                String descriptorName = "";
                String measureName = "";
                String measureValue = "";
                String lineString = lineTokenizer.nextToken().trim();
                if (this.isValidMeasureLine(lineString, COLON_DELIMITER)) {
                    if (infoBased && this.hasDescriptorName(lineString)) {
                        descriptorName = lineString.substring(0, lineString.indexOf(COLON_DELIMITER)).trim();
                        StringTokenizer measureTokenizer = new StringTokenizer(lineString.substring(lineString.indexOf(COLON_DELIMITER) + 1).trim(), COMMA_DELIMITER);
                        infoMeasureTable = new Hashtable();
                        while (measureTokenizer.hasMoreTokens()) {
                            String measureToken = measureTokenizer.nextToken();
                            if (!this.isValidMeasureLine(measureToken, EQUALS_DELIMITER)) continue;
                            measureName = measureToken.substring(0, measureToken.indexOf(EQUALS_DELIMITER)).trim();
                            measureValue = measureToken.substring(measureToken.indexOf(EQUALS_DELIMITER) + 1).trim();
                            measureName = measureName.contains(COLON_DELIMITER) ? measureName.replace(COLON_DELIMITER, "") : measureName;
                            infoMeasureTable.put(measureName, measureValue);
                        }
                        descriptorTable.put(descriptorName, infoMeasureTable);
                        continue;
                    }
                    measureName = lineString.substring(0, lineString.indexOf(COLON_DELIMITER)).trim();
                    measureValue = lineString.substring(lineString.indexOf(COLON_DELIMITER) + 1).trim();
                    nonInfoMeasureTable.put(measureName, measureValue);
                    continue;
                }
                if (!this.isValidCategoryLine(lineString)) continue;
                category = lineString.substring(1).trim();
            }
            if (infoBased) {
                logger.debug("{} [parseMetrics] the result table is info based ", (Object)this.logPrefix);
                resultTable.put(category, descriptorTable);
            } else {
                logger.debug("{} [parseMetrics] the result table is non-info based ", (Object)this.logPrefix);
                resultTable.put(category, nonInfoMeasureTable);
            }
        }
        catch (Exception e) {
            logger.warn("{} [parseMetrics] Exception occured while fetching the values from testTable ", (Object)this.logPrefix, (Object)e);
        }
        logger.info("{} [parseMetrics] The Resultant table of parsed metrics : \n {}", (Object)this.logPrefix, resultTable);
        return resultTable;
    }

    public long getModifiedTime() {
        IniFile egMeasure = this.redisInfo.getEgMeasures();
        long last = IniFile.getLastModified((String)(String.valueOf(installDir) + iniFilePath));
        logger.info("{} [getModifiedTime] The INI File : {} was modified latestly on {}", new Object[]{this.logPrefix, iniFilePath, last});
        return last;
    }

    public Hashtable getIndexTable(String redisIndexSubject) {
        IniFile egMeasure = this.redisInfo.getEgMeasures();
        String[] indexTable = egMeasure.getVariables(redisIndexSubject);
        Hashtable<String, String> indexMappingTable = new Hashtable<String, String>();
        int i = 0;
        while (i < indexTable.length) {
            indexMappingTable.put(indexTable[i], egMeasure.getValue(redisIndexSubject, indexTable[i]));
            ++i;
        }
        logger.info("{} [getIndexTable] returning the table of INI name and index of the Subject {} in indexMappingTable : {}", new Object[]{this.logPrefix, redisIndexSubject, indexMappingTable});
        return indexMappingTable;
    }

    public Hashtable getNameTable(String redisNameSubject) {
        IniFile egMeasure = this.redisInfo.getEgMeasures();
        String[] nameTable = egMeasure.getVariables(redisNameSubject);
        Hashtable<String, String> nameMappingTable = new Hashtable<String, String>();
        int j = 0;
        while (j < nameTable.length) {
            String name = egMeasure.getValue(redisNameSubject, nameTable[j]);
            String versionBasedNameing = "";
            if (name.contains(COMMA_DELIMITER)) {
                StringTokenizer stringTokenizer = new StringTokenizer(name, COMMA_DELIMITER);
                while (stringTokenizer.hasMoreTokens()) {
                    versionBasedNameing = stringTokenizer.nextToken();
                    nameMappingTable.put(versionBasedNameing, nameTable[j]);
                }
            } else {
                nameMappingTable.put(name, nameTable[j]);
            }
            ++j;
        }
        logger.info("{} [getNameTable] returning the table of redis name and INI name of the Subject {} in nameMappingTable : ", new Object[]{this.logPrefix, redisNameSubject, nameMappingTable});
        return nameMappingTable;
    }

    public ArrayList getNameList(String redisNameSubject) {
        ArrayList<String> redisNameList = new ArrayList<String>();
        Hashtable nameMappingTable = this.getNameTable(redisNameSubject);
        Iterator names = (Iterator)((Object)nameMappingTable.keys());
        while (names.hasNext()) {
            String name = (String)names.next();
            redisNameList.add(name);
        }
        logger.info("{} [getNameList] returning the list of redis name of the Subject {} in redisNameList : {}", new Object[]{this.logPrefix, redisNameSubject, redisNameList});
        return redisNameList;
    }

    public ArrayList finalMeasures(int size) {
        ArrayList<Double> measure = new ArrayList<Double>();
        int z = 0;
        while (z < size) {
            measure.add(new Double(-5.0));
            ++z;
        }
        logger.trace("{} [finalMeasures] creating and initializing the measure list ", (Object)this.logPrefix);
        return measure;
    }

    public void getRedisMeasureNonInfoBased(Hashtable metricObject, String nameSubject, String indexSubject, Hashtable measureIndexTable, Hashtable measureNameTable, ArrayList redisNameList, long lastModifiedTime) {
        if (metricObject == null || metricObject.size() == 0) {
            logger.debug("{} [getRedisMeasureNonInfoBased]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long modifiedTime = this.getModifiedTime();
            if (modifiedTime - lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)metricObject);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)redisNameList);
            ArrayList measure = this.finalMeasures(this.measureCount);
            Iterator testKeys = (Iterator)((Object)metricObject.keys());
            while (testKeys.hasNext()) {
                String testKey = (String)testKeys.next();
                Hashtable testKeyValue = null;
                try {
                    testKeyValue = (Hashtable)metricObject.get(testKey);
                    logger.debug("{} [getRedisMeasureNonInfoBased] The Metric key and value table is : ", (Object)this.logPrefix, (Object)testKeyValue);
                }
                catch (Exception localException1) {
                    logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)localException1);
                }
                if (testKeyValue == null || testKeyValue.size() <= 0) continue;
                Iterator metricKeys = (Iterator)((Object)testKeyValue.keys());
                while (metricKeys.hasNext()) {
                    String metricKey = (String)metricKeys.next();
                    Object metricKeyValue = null;
                    try {
                        metricKeyValue = testKeyValue.get(metricKey);
                    }
                    catch (Exception loaclException2) {
                        logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)loaclException2);
                    }
                    if (!redisNameList.contains(metricKey)) continue;
                    String metricName = (String)measureNameTable.get(metricKey);
                    int index = Integer.parseInt(measureIndexTable.get(metricName).toString());
                    try {
                        double value = Double.parseDouble(metricKeyValue.toString());
                        measure.set(index, new Double(value));
                        logger.debug("{} [getRedisMeasureNonInfoBased] index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, index, metricKey, value});
                    }
                    catch (Exception numberFormatException) {
                        logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)numberFormatException);
                    }
                }
                logger.info("{} [getRedisMeasureNonInfoBased]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)measure);
                this.addMeasures(measure);
            }
        }
        catch (Exception redisMeasureException) {
            logger.warn("{} Exception occurred in [getRedisMeasureNonInfoBased] {}", (Object)this.logPrefix, (Object)redisMeasureException);
        }
    }

    public void getRedisMeasureInfoBased(Hashtable metricObject, String nameSubject, String indexSubject, Hashtable measureIndexTable, Hashtable measureNameTable, ArrayList redisNameList, long lastModifiedTime) {
        if (metricObject == null || metricObject.size() == 0) {
            logger.debug("{} [getRedisMeasureInfoBased]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long modifiedTime = this.getModifiedTime();
            if (modifiedTime - lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                lastModifiedTime = modifiedTime;
            }
            logger.debug(" metricObject      : {}", (Object)metricObject);
            logger.debug(" measureIndexTable : {}", (Object)measureIndexTable);
            logger.debug(" measureNameTable  : {}", (Object)measureNameTable);
            logger.debug(" redisNameList     : {}", (Object)redisNameList);
            ArrayList measure = this.finalMeasures(this.measureCount);
            Iterator testKeys = (Iterator)((Object)metricObject.keys());
            while (testKeys.hasNext()) {
                String testKey = (String)testKeys.next();
                logger.debug("{} [getRedisMeasureInfoBased] The Test Name is  : {}", (Object)this.logPrefix, (Object)testKey);
                Hashtable testKeyValue = null;
                try {
                    testKeyValue = (Hashtable)metricObject.get(testKey);
                    logger.debug("{} [getRedisMeasureInfoBased] The Discriptor Table is : {}", (Object)this.logPrefix, (Object)testKeyValue);
                }
                catch (Exception localException1) {
                    logger.warn("{} [getRedisMeasureInfoBased] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)localException1);
                }
                if (testKeyValue == null || testKeyValue.size() <= 0) continue;
                Iterator discriptorKeys = (Iterator)((Object)testKeyValue.keys());
                while (discriptorKeys.hasNext()) {
                    String discriptorKey = (String)discriptorKeys.next();
                    Hashtable discriptorKeyValue = null;
                    try {
                        discriptorKeyValue = (Hashtable)testKeyValue.get(discriptorKey);
                    }
                    catch (Exception localException2) {
                        logger.warn("{} [getRedisMeasureInfoBased] Exception occured while getting fetching the values from discriptor table {}", (Object)this.logPrefix, (Object)localException2);
                    }
                    this.isDescriptorName = true;
                    this.descriptorName = discriptorKey;
                    if (discriptorKeyValue == null || discriptorKeyValue.size() <= 0) continue;
                    Iterator metricKeys = (Iterator)((Object)discriptorKeyValue.keys());
                    while (metricKeys.hasNext()) {
                        String metricKey = (String)metricKeys.next();
                        Object metricKeyValue = null;
                        try {
                            metricKeyValue = discriptorKeyValue.get(metricKey);
                        }
                        catch (Exception localExceprtion3) {
                            logger.warn("{} [getRedisMeasureInfoBased] Exception occured while getting fetching the values from metric table {} {}", new Object[]{this.logPrefix, discriptorKeyValue, localExceprtion3});
                        }
                        if (!redisNameList.contains(metricKey)) continue;
                        String metricName = (String)measureNameTable.get(metricKey);
                        int index = Integer.parseInt(measureIndexTable.get(metricName).toString());
                        try {
                            double value = Double.parseDouble(metricKeyValue.toString());
                            measure.set(index, new Double(value));
                            logger.debug("{} [getRedisMeasureInfoBased] discriptor : {} index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, this.descriptorName, index, metricKey, value});
                        }
                        catch (Exception numberFormatException) {
                            logger.warn("{} [getRedisMeasureInfoBased] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)numberFormatException);
                        }
                    }
                    logger.info("{} [getRedisMeasureInfoBased] {},The ArrayList  measure contains = ", new Object[]{this.logPrefix, this.descriptorName, measure});
                    this.addMeasures(this.descriptorName, measure);
                }
            }
        }
        catch (Exception redisMeasureException) {
            logger.warn("{} Exception occurred in [getRedisMeasureNonInfoBased] {}", (Object)this.logPrefix, (Object)redisMeasureException);
        }
    }

    public boolean isRedisRestarted() {
        String serverString = this.getMetrics("Server");
        Hashtable results = this.parseMetrics(serverString, false);
        Hashtable serverKey = (Hashtable)results.get("Server");
        Object serverUpTime = serverKey.get("uptime_in_seconds");
        try {
            double upTime = Double.parseDouble(serverUpTime.toString());
            logger.debug("{} The up time of Redis : {}", (Object)this.logPrefix, (Object)upTime);
            logger.debug("{} The previous uptime of Redis : {}", (Object)this.logPrefix, (Object)this.previousUpTime);
            if (this.previousUpTime > upTime && this.previousUpTime > 0.0) {
                this.isRestarted = true;
                this.previousUpTime = upTime;
                logger.debug("{} [getRedisMeasureForCommandStats] Redis Server has been restarted......", (Object)this.logPrefix);
            } else {
                this.isRestarted = false;
                this.previousUpTime = upTime;
            }
        }
        catch (Exception exception) {
            logger.warn("{} [getRedisMeasureForCommandStats] Exception occured while parsing the String to Double {}", (Object)this.logPrefix, (Object)exception);
            this.isRestarted = false;
        }
        logger.debug("{} Is Redis server restarted : {}", (Object)this.logPrefix, (Object)this.isRestarted);
        return this.isRestarted;
    }

    public String getclientList() {
        String clientList;
        block6: {
            Jedis jedis = null;
            clientList = "";
            try {
                try {
                    jedis = this.getConnection();
                    if (jedis == null) {
                        logger.debug("[getRedisMeasureClient] [getclientList] jedis is returning null...");
                        break block6;
                    }
                    clientList = jedis.clientList();
                    logger.debug("[getRedisMeasureClient] [getclientList] The Client List is :  \n {}", (Object)clientList);
                    jedis.close();
                }
                catch (Exception e) {
                    logger.warn("{} {}", (Object)this.logPrefix, (Object)e);
                    this.closeConnection(jedis);
                }
            }
            finally {
                this.closeConnection(jedis);
            }
        }
        return clientList;
    }

    public String convertMemoryValues(String inputData, String srcUnit, String targetUnit) {
        try {
            return EgUtils.convertMemoryValues((String)inputData, (String)srcUnit, (String)targetUnit);
        }
        catch (Exception e) {
            logger.trace("{} The ClientDetails are {}", (Object)this.logPrefix, (Object)e.getMessage());
            return null;
        }
    }
}

