/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgExternalInfo;
import com.eg.EgSpecsInfo;
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class OracleValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String sid = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String oracle_homeDir = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean meAgentLess = false;
    public boolean service = true;
    public boolean isSID = true;
    public String serviceName = "";
    public String service_name = "";
    public boolean isOracleInstanceOk = false;
    public boolean isServiceNameOk = true;
    public boolean isConnectivityOk = true;
    public boolean isMultitenantDb = false;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    EgSpecsInfo specsInfo = new EgSpecsInfo("agent");
    EgExternalInfo extInfo = new EgExternalInfo("agent");
    boolean isCDB = false;
    boolean isOracle12c = false;
    private static final String TEST_NAME = "OracleValidator";
    private static final String DEBUG = "DEBUG    ";
    public String isSSL = "";
    public String trustStorePath = "";
    public String trustStoreType = "";
    public String trustStorePassword = "";
    public boolean isSSLEnabled = false;
    static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    public Hashtable sslParametersHT = new Hashtable();

    public OracleValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                string2 = string3.substring(0, string3.indexOf(":"));
                string = string3.substring(string3.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-info")) {
                    this.sid = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-oracle_sid")) {
                    this.sid = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string = EgCrypt.decrypt((String)string)).indexOf("~EG~") != -1) {
                        string = string.substring(0, string.indexOf("~EG~"));
                    }
                    this.password = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string;
                    if (this.isAgentLess == null || !this.isAgentLess.equalsIgnoreCase("y")) continue;
                    this.meAgentLess = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string = EgCrypt.decrypt((String)string)).indexOf("~EG~") != -1) {
                        string = string.substring(0, string.indexOf("~EG~"));
                    }
                    this.alPassword = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-oracle_home")) {
                    this.oracle_homeDir = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-oraclesid")) {
                    this.sid = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-orasid")) {
                    this.sid = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-servicename")) {
                    this.serviceName = string;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    this.isSSL = string;
                    if (this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"))) {
                        this.isSSLEnabled = true;
                        continue;
                    }
                    this.isSSLEnabled = false;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-truststore_path")) {
                    this.trustStorePath = string;
                    if (this.trustStorePath != null && !this.trustStorePath.equalsIgnoreCase("NULL") && !this.trustStorePath.equalsIgnoreCase("none")) continue;
                    this.trustStorePath = "";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-truststore_type")) {
                    this.trustStoreType = string;
                    if (this.trustStoreType != null && !this.trustStoreType.equalsIgnoreCase("NULL") && !this.trustStoreType.equalsIgnoreCase("none")) continue;
                    this.trustStoreType = "";
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-truststore_password")) continue;
                if ((string = EgCrypt.decrypt((String)string)).indexOf("~EG~") != -1) {
                    string = string.substring(0, string.indexOf("~EG~"));
                }
                this.trustStorePassword = string;
                if (this.trustStorePassword != null && !this.trustStorePassword.equalsIgnoreCase("NULL") && !this.trustStorePassword.equalsIgnoreCase("none")) continue;
                this.trustStorePassword = "";
            }
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        if (this.sid == null || this.sid.equalsIgnoreCase("NULL") || this.sid.equalsIgnoreCase("none") || this.sid.length() == 0) {
            this.isSID = false;
        }
        if (this.isSSLEnabled) {
            OracleValidator.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                String string4 = "tcps";
                string3 = this.host;
                string2 = this.port;
                string = "";
                String string5 = "";
                if (this.service) {
                    string = this.serviceName;
                    string5 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string4 + ")(HOST=" + string3 + ")(PORT=" + string2 + "))(CONNECT_DATA=(SERVICE_NAME=" + string + ")))";
                } else {
                    string = this.sid;
                    string5 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string4 + ")(HOST=" + string3 + ")(PORT=" + string2 + "))(CONNECT_DATA=(SID=" + string + ")))";
                }
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string5);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.test);
            } else {
                OracleValidator.printOut("Please provide valid key store details");
            }
        } else {
            OracleValidator.printOut("SSL is not enabled");
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.sid;
        this.validationMsgs = new ArrayList();
        if (this.extInfo.isRemoteBased(this.reportingName)) {
            this.meAgentLess = true;
        }
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.checkOracleConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port is down or listener is down");
                } else if (!this.isOracleInstanceReachable()) {
                    String string = (String)this.validationErrorMap.get("Oracle_Instance");
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    this.validationMsgs.add("Oracle Instance Name$#$" + string);
                } else if (!this.isOracleServiceReachable()) {
                    String string = (String)this.validationErrorMap.get("Oracle_Service");
                    this.validationMsgs.add("Oracle Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    this.validationMsgs.add("Oracle Service Name$#$" + string);
                } else {
                    String string = (String)this.validationErrorMap.get("Oracle_Connectivity");
                    String string2 = (String)this.validationErrorMap.get("Oracle_Instance");
                    this.validationMsgs.add("Oracle Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("Oracle Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("Oracle SID/Service Name$#$OK");
            }
            this.logMsgToStatusFile(this.subject, this.key, "OK#" + this.getCurrentTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    public boolean isOracleInstanceReachable() {
        if (this.meAgentLess || this.service || this.isSID) {
            this.validationErrorMap.put("Oracle_Instance", "NA");
            return true;
        }
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string = "";
        this.agentOS = this.agentOS.toLowerCase();
        ArrayList arrayList = new ArrayList();
        String string2 = "";
        String string3 = this.getNBTName(this.host);
        if (this.agentOS != null && this.agentOS.indexOf("windows") > -1) {
            string2 = "oracleservice" + this.sid.toLowerCase();
            string = " net start ";
            arrayList = egUtilities.getCommandOutputLines(string);
            if (arrayList != null && !arrayList.isEmpty()) {
                for (String string4 : arrayList) {
                    string4 = string4.toLowerCase();
                    if ((string4 = string4.trim()) == null || !string4.equalsIgnoreCase(string2)) continue;
                    this.isOracleInstanceOk = true;
                    break;
                }
            }
            if (!this.isOracleInstanceOk) {
                this.validationErrorMsg = "Oracle Instance '" + this.sid + "' is not running or unavailable";
                this.validationErrorMap.put("Oracle_Instance", this.validationErrorMsg);
            }
        } else if (this.agentOS != null && (this.agentOS.indexOf("linux") > -1 || this.agentOS.indexOf("sunos") > -1 || this.agentOS.indexOf("hpux") > -1 || this.agentOS.indexOf("aix") > -1 || this.agentOS.indexOf("osf1") > -1)) {
            string2 = "ora_pmon_" + this.sid;
            string = "ps -e | grep '" + string2 + "'";
            arrayList = egUtilities.getCommandOutputLines(string, true);
            if (arrayList != null && !arrayList.isEmpty()) {
                for (String string5 : arrayList) {
                    string5 = string5.toLowerCase();
                    if ((string5 = string5.trim()) == null || !string5.equalsIgnoreCase(string2)) continue;
                    this.isOracleInstanceOk = true;
                    break;
                }
            }
            if (!this.isOracleInstanceOk) {
                this.validationErrorMsg = "Oracle Instance '" + this.sid + "' is not running or unavailable";
                this.validationErrorMap.put("Oracle_Instance", this.validationErrorMsg);
            }
        }
        return this.isOracleInstanceOk;
    }

    private void setServiceName(String string) {
        this.service_name = string;
    }

    private String getServiceName() {
        return this.service_name;
    }

    public boolean isOracleServiceReachable() {
        String string = this.getServiceName();
        if (string != null && !string.equals("") && !string.equals(this.serviceName)) {
            this.isServiceNameOk = false;
        }
        if (!this.isServiceNameOk) {
            this.validationErrorMsg = "Oracle Service '" + this.serviceName + "' is not running or unavailable";
            this.validationErrorMap.put("Oracle_Service", this.validationErrorMsg);
        }
        return this.isServiceNameOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean checkOracleConnectivity() {
        block16: {
            Connection connection;
            block15: {
                boolean bl = false;
                boolean bl2 = false;
                String string = "";
                connection = null;
                Object var5_5 = null;
                Object var6_6 = null;
                this.host = IPV6Helper.getValidIPAddress((String)this.host);
                Class.forName("oracle.jdbc.driver.OracleDriver");
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                String string2 = "jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.sid;
                connection = this.isSSLEnabled ? this.getConnection("oracle.jdbc.driver.OracleDriver", string2, properties, this.sslParametersHT) : this.getConnection("oracle.jdbc.driver.OracleDriver", string2, properties);
                if (!this.service) {
                    this.serviceName = this.sid;
                }
                if (connection == null) {
                    string2 = "jdbc:oracle:thin:@//" + this.host + ":" + this.port + "/" + this.serviceName;
                    connection = this.isSSLEnabled ? this.getConnection("oracle.jdbc.driver.OracleDriver", string2, properties, this.sslParametersHT) : this.getConnection("oracle.jdbc.driver.OracleDriver", string2, properties);
                }
                if (connection != null) break block15;
                boolean bl3 = false;
                Object var13_10 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return bl3;
            }
            Object var13_11 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block16;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block16;
            {
                catch (Exception exception) {
                    boolean bl = false;
                    Object var13_12 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkORAUserRoles() {
        boolean bl;
        block31: {
            String string;
            String string2;
            Object object;
            String string3;
            Object object2;
            bl = false;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            this.host = IPV6Helper.getValidIPAddress((String)this.host);
            Class.forName("oracle.jdbc.driver.OracleDriver");
            String string4 = "";
            if (this.service) {
                if (this.isSSLEnabled) {
                    object2 = "tcps";
                    string3 = this.host;
                    object = this.port;
                    string2 = this.serviceName;
                    string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object2 + ")(HOST=" + string3 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SERVICE_NAME=" + string2 + ")))";
                } else {
                    string4 = "jdbc:oracle:thin:@//" + this.host + ":" + this.port + "/" + this.serviceName;
                }
            } else {
                this.checkOracleVersion();
                if (this.isMultitenantDb && !this.isCDB) {
                    if (this.isSSLEnabled) {
                        object2 = "tcps";
                        string3 = this.host;
                        object = this.port;
                        string2 = this.sid;
                        string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object2 + ")(HOST=" + string3 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SID=" + string2 + ")))";
                    } else {
                        string4 = "jdbc:oracle:thin:@//" + this.host + ":" + this.port + "/" + this.sid;
                    }
                } else if (this.isSSLEnabled) {
                    object2 = "tcps";
                    string3 = this.host;
                    object = this.port;
                    string2 = this.sid;
                    string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object2 + ")(HOST=" + string3 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SID=" + string2 + ")))";
                } else {
                    string4 = "jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.sid;
                }
            }
            object2 = new Properties();
            ((Properties)object2).put("user", this.user);
            ((Properties)object2).put("password", this.password);
            if (this.isSSLEnabled) {
                ((Properties)object2).setProperty("javax.net.ssl.trustStore", this.trustStorePath);
                ((Properties)object2).setProperty("javax.net.ssl.trustStoreType", this.trustStoreType);
                ((Properties)object2).setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            }
            if (this.domain != null && !this.domain.equalsIgnoreCase("none")) {
                ((Properties)object2).put("domain", this.domain);
            }
            connection = DriverManager.getConnection(string4, (Properties)object2);
            statement = connection.createStatement();
            string3 = "SELECT  GRANTED_ROLE  from user_role_privs";
            resultSet = statement.executeQuery(string3);
            object = new ArrayList();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                ((ArrayList)object).add(string2);
            }
            if (object != null && ((ArrayList)object).contains("SELECT_CATALOG_ROLE")) {
                bl = true;
            }
            resultSet.close();
            statement.close();
            connection.close();
            Object var12_12 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block31;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block31;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var12_13 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block31;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return bl;
    }

    public boolean checkOracleHome() {
        boolean bl = false;
        if (this.oracle_homeDir != null && !this.oracle_homeDir.equals("") && !this.oracle_homeDir.equalsIgnoreCase("null")) {
            if (!bl) {
                this.validationErrorMsg = "Oracle Home Directory:Oracle Home Directory '" + this.oracle_homeDir + "' does not exist or corrupted ";
            }
        } else {
            this.validationErrorMsg = "NA";
        }
        this.validationErrorMap.put("Oracle_Home", this.validationErrorMsg);
        return bl;
    }

    public String getNBTName(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = !this.isTargetIp ? "nbtstat -a " + string : "nbtstat -A " + string;
        String string3 = string;
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        ArrayList arrayList2 = null;
        String string4 = null;
        if (arrayList != null && (arrayList2 = (ArrayList)arrayList.get(0)) != null) {
            int n = arrayList2.size();
            if (n <= 0) {
                return string3;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                string4 = (String)arrayList2.get(i);
                if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("Name") || string4.startsWith("-") || (n3 = (stringTokenizer = new StringTokenizer(string4)).countTokens()) < 3 || string4.indexOf("<00>") <= 0 || string4.indexOf("UNIQUE") <= 0) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.endsWith("<00>")) {
                    n2 = string3.indexOf("<00>");
                    string3 = string3.substring(0, n2);
                }
                if (string3.indexOf("~") >= 0) continue;
                n2 = string3.indexOf("~");
                string3 = string3.toLowerCase().trim();
                break;
            }
        }
        return string3;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void checkOracleVersion() {
        ArrayList arrayList = new ArrayList();
        arrayList = this.isSSLEnabled ? ConnectionManager.checkOracleVersion("", this.host, this.port, this.sid, this.user, this.password, true, this.sslParametersHT) : ConnectionManager.checkOracleVersion("", this.host, this.port, this.sid, this.user, this.password, true);
        if (arrayList != null && arrayList.size() > 2) {
            int n = (Integer)arrayList.get(0);
            String string = (String)arrayList.get(1);
            if (string.equalsIgnoreCase("true")) {
                this.isCDB = true;
            }
            if (n >= 12) {
                this.isOracle12c = true;
                String string2 = (String)arrayList.get(2);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this.isMultitenantDb = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Connection getConnection(String string, String string2, Properties properties) {
        Connection connection;
        block34: {
            String string3;
            boolean bl;
            boolean bl2;
            ResultSet resultSet;
            Statement statement;
            block33: {
                connection = null;
                statement = null;
                resultSet = null;
                bl2 = false;
                bl = false;
                string3 = "";
                long l = System.currentTimeMillis();
                Class.forName(string);
                connection = DriverManager.getConnection(string2, properties);
                statement = connection.createStatement();
                String string4 = "select value from v$parameter where name='service_names'";
                resultSet = statement.executeQuery(string4);
                if (!resultSet.next()) break block33;
                String string5 = resultSet.getString("VALUE");
                this.setServiceName(string5);
            }
            Object var20_17 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block34;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block34;
            {
                catch (SQLException sQLException) {
                    int n = sQLException.getErrorCode();
                    String string6 = sQLException.getMessage();
                    this.isConnectivityOk = false;
                    switch (n) {
                        case 1017: {
                            string6 = " Invalid username/password; logon denied";
                            bl = true;
                            break;
                        }
                        case 1045: {
                            string6 = " User '" + this.user + "' lacks CONNECT/CREATE SESSION privilege; logon denied";
                            bl = true;
                            break;
                        }
                        case 942: {
                            bl2 = this.checkORAUserRoles();
                            string6 = !bl2 ? " User '" + this.user + "' doesn't have  SELECT_CATALOG role" : " User '" + this.user + "' has sufficient privileges error occurred while selecting with data dictionary. Please check with actual exception";
                            bl = true;
                            break;
                        }
                        case 28000: {
                            string6 = " The account '" + this.user + "' is locked";
                            bl = true;
                            break;
                        }
                        case 12519: {
                            string6 = " Listener refused the connection due to ' TNS:no appropriate service handler found'";
                            bl = true;
                            break;
                        }
                        case 12505: {
                            string6 = " Listener refused the connection due to 'Unknown  SID'";
                            bl = true;
                            break;
                        }
                        case 12514: {
                            string6 = " Listener refused the connection due to 'Unknown  SID/Service Name'";
                            bl = true;
                        }
                    }
                    String string7 = this.getStackTraceAsString(sQLException);
                    string3 = string7.substring(0, string7.indexOf("at"));
                    this.validationErrorMsg = bl ? string6.trim() : string3;
                    if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                        StringBuffer stringBuffer = new StringBuffer();
                        while (stringTokenizer.hasMoreTokens()) {
                            String string8 = stringTokenizer.nextToken();
                            stringBuffer.append(string8.trim() + " ");
                        }
                        this.validationErrorMsg = stringBuffer.toString();
                        this.validationErrorMsg = this.validationErrorMsg.trim();
                    }
                    this.validationErrorMap.put("Oracle_Connectivity", this.validationErrorMsg);
                    this.errorMsg = string6.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string7.trim() + "#" + this.getCurrentTime();
                    Object var20_18 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block34;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block34;
                }
                catch (Exception exception) {
                    this.isConnectivityOk = false;
                    String string9 = this.getStackTraceAsString(exception);
                    this.validationErrorMsg = string3;
                    this.validationErrorMap.put("Oracle_Connectivity", this.validationErrorMsg);
                    this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string9.trim() + "#" + this.getCurrentTime();
                    Object var20_19 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block34;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Connection getConnection(String string, String string2, Properties properties, Hashtable hashtable) {
        Connection connection;
        block40: {
            String string3;
            boolean bl;
            boolean bl2;
            ResultSet resultSet;
            Statement statement;
            block39: {
                String string4;
                String string5;
                connection = null;
                statement = null;
                resultSet = null;
                bl2 = false;
                bl = false;
                string3 = "";
                long l = System.currentTimeMillis();
                Class.forName(string);
                OracleValidator.printOut("[ checkConnection ] Hashtable sslParametersHT  :" + hashtable);
                if (!OracleValidator.isHashtableNull(hashtable)) {
                    if (hashtable.containsKey("isSSLEnabled")) {
                        string5 = hashtable.get("isSSLEnabled") + "";
                        if (string5.equalsIgnoreCase("true")) {
                            string4 = hashtable.get("urlWithSSL") + "";
                            String string6 = hashtable.get("trustStorePath") + "";
                            String string7 = hashtable.get("trustStoreType") + "";
                            String string8 = hashtable.get("trustStorePassword") + "";
                            String string9 = hashtable.get("egReportName") + "";
                            String string10 = hashtable.get("eGTestName") + "";
                            string2 = string4;
                            properties.setProperty("javax.net.ssl.trustStore", string6);
                            properties.setProperty("javax.net.ssl.trustStoreType", string7);
                            properties.setProperty("javax.net.ssl.trustStorePassword", string8);
                            OracleValidator.printOut("[ " + string10 + " ] :  [ " + string9 + "  ] : [ checkConnection ] :isSSLEnabled     :" + string5);
                            OracleValidator.printOut("[ " + string10 + " ] :  [ " + string9 + "  ] : [ checkConnection ] :URL              :" + string2);
                            OracleValidator.printOut("[ " + string10 + " ] :  [ " + string9 + "  ] : [ checkConnection ] :trustStorePath     :" + string6);
                            OracleValidator.printOut("[ " + string10 + " ] :  [ " + string9 + "  ] : [ checkConnection ] :trustStoreType     :" + string7);
                        } else {
                            OracleValidator.printOut(" [ checkConnection ] : SSL not enabled.");
                        }
                    } else {
                        OracleValidator.printOut(" [ checkConnection ] : Hashtable doesnt contain key \"isSSLEnabled\" .");
                    }
                } else {
                    OracleValidator.printOut("[ checkConnection ] : Hashtable is null.");
                }
                connection = DriverManager.getConnection(string2, properties);
                OracleValidator.printOut(" [ getConnection ] :Connection Successful :");
                statement = connection.createStatement();
                string5 = "select value from v$parameter where name='service_names'";
                resultSet = statement.executeQuery(string5);
                if (!resultSet.next()) break block39;
                string4 = resultSet.getString("VALUE");
                this.setServiceName(string4);
            }
            Object var21_28 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block40;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block40;
            {
                catch (SQLException sQLException) {
                    int n = sQLException.getErrorCode();
                    String string11 = sQLException.getMessage();
                    this.isConnectivityOk = false;
                    switch (n) {
                        case 1017: {
                            string11 = " Invalid username/password; logon denied";
                            bl = true;
                            break;
                        }
                        case 1045: {
                            string11 = " User '" + this.user + "' lacks CONNECT/CREATE SESSION privilege; logon denied";
                            bl = true;
                            break;
                        }
                        case 942: {
                            bl2 = this.checkORAUserRoles();
                            string11 = !bl2 ? " User '" + this.user + "' doesn't have  SELECT_CATALOG role" : " User '" + this.user + "' has sufficient privileges error occurred while selecting with data dictionary. Please check with actual exception";
                            bl = true;
                            break;
                        }
                        case 28000: {
                            string11 = " The account '" + this.user + "' is locked";
                            bl = true;
                            break;
                        }
                        case 12519: {
                            string11 = " Listener refused the connection due to ' TNS:no appropriate service handler found'";
                            bl = true;
                            break;
                        }
                        case 12505: {
                            string11 = " Listener refused the connection due to 'Unknown  SID'";
                            bl = true;
                            break;
                        }
                        case 12514: {
                            string11 = " Listener refused the connection due to 'Unknown  SID/Service Name'";
                            bl = true;
                        }
                    }
                    String string12 = this.getStackTraceAsString(sQLException);
                    string3 = string12.substring(0, string12.indexOf("at"));
                    this.validationErrorMsg = bl ? string11.trim() : string3;
                    if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                        StringBuffer stringBuffer = new StringBuffer();
                        while (stringTokenizer.hasMoreTokens()) {
                            String string13 = stringTokenizer.nextToken();
                            stringBuffer.append(string13.trim() + " ");
                        }
                        this.validationErrorMsg = stringBuffer.toString();
                        this.validationErrorMsg = this.validationErrorMsg.trim();
                    }
                    this.validationErrorMap.put("Oracle_Connectivity", this.validationErrorMsg);
                    this.errorMsg = string11.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string12.trim() + "#" + this.getCurrentTime();
                    Object var21_29 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block40;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block40;
                }
                catch (Exception exception) {
                    this.isConnectivityOk = false;
                    String string14 = this.getStackTraceAsString(exception);
                    this.validationErrorMsg = string3;
                    this.validationErrorMap.put("Oracle_Connectivity", this.validationErrorMsg);
                    this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string14.trim() + "#" + this.getCurrentTime();
                    Object var21_30 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block40;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_31 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return connection;
    }

    protected static boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() < 1;
    }

    protected static String methodNameTemplate(String string) {
        return "[ " + string + " ] :";
    }

    public static void printOut(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ]  : [ " + TEST_NAME + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public static void main(String[] stringArray) {
        OracleValidator oracleValidator = new OracleValidator(stringArray, new Boolean(false));
    }
}

