/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraTsStatusTest
extends GenericTest {
    String username = null;
    String password = null;
    String oraSid = null;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraTsStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        this.password = this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.password);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object4 = "tcps";
                object3 = this.targetHost;
                object2 = this.portNo;
                string = this.oraSid;
                object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + object4 + ")(HOST=" + (String)object3 + ")(PORT=" + (String)object2 + "))(CONNECT_DATA=(SERVICE_NAME=" + string + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", object);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object4 = new ArrayList();
            object4 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object4 != null && ((ArrayList)object4).size() > 2) {
                int n = (Integer)((ArrayList)object4).get(0);
                object2 = (String)((ArrayList)object4).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object4).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object4, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object4 = new Hashtable();
            object4 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object4 == null || ((Hashtable)object4).size() == 0) {
                return;
            }
            object3 = (ArrayList)((Hashtable)object4).get(this.reportingName + ":" + this.oraSid);
            if (object3 != null && ((ArrayList)object3).size() > 0) {
                object2 = (String)((ArrayList)object3).get(2);
                string = (String)((ArrayList)object3).get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object4 = null;
        object3 = null;
        object2 = null;
        string = "select tablespace_name,status from dba_tablespaces";
        try {
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraTsStatusTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                object4 = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            } else {
                object4 = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            }
            if (object4 == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object3 = object4.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTsStatusTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object4 != null) {
                        object4.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return;
            }
            object2 = object3.executeQuery(string);
            object = null;
            String string2 = "";
            String string3 = "";
            double d = 0.0;
            while (object2.next()) {
                string2 = object2.getString(1);
                string3 = object2.getString(2);
                object = new ArrayList();
                if (string3.equalsIgnoreCase("online")) {
                    d = 100.0;
                    ((ArrayList)object).add(new Double(d));
                } else if (string3.equalsIgnoreCase("read only")) {
                    d = 10.0;
                    ((ArrayList)object).add(new Double(d));
                } else if (string3.equalsIgnoreCase("read write")) {
                    d = 20.0;
                    ((ArrayList)object).add(new Double(d));
                } else if (string3.equalsIgnoreCase("offline")) {
                    d = 0.0;
                    ((ArrayList)object).add(new Double(d));
                } else {
                    if (this.isPassive) {
                        d = -5.0;
                    }
                    ((ArrayList)object).add(new Double(d));
                }
                System.out.println("[OraTsStatusTest] INFO NAME ==>" + string2 + "==measure==>" + object);
                this.addNewMeasure(string2, (ArrayList)object);
            }
            try {
                object2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object3.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object4.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            try {
                object2.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                object3.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
            try {
                object4.close();
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTsStatusTest oraTsStatusTest = new OraTsStatusTest(stringArray);
        oraTsStatusTest.computeMeasures(new Hashtable());
    }
}

