/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraSystemWaitTest
extends GenericTest {
    private String oraSid = "";
    private String userName;
    private String userPasswd;
    private String queryStmt;
    private String queryStmt1;
    private double defValue = -1.0;
    private boolean foundVersion = false;
    private boolean isSql9 = false;
    private boolean isSql10 = false;
    ArrayList excludeInfo;
    Hashtable previous = new Hashtable();
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public static void main(String[] stringArray) {
        OraSystemWaitTest oraSystemWaitTest = new OraSystemWaitTest(stringArray);
        oraSystemWaitTest.executeTest();
    }

    public OraSystemWaitTest(String[] stringArray) {
        super(stringArray);
        String[] stringArray2;
        Object object;
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
        this.userName = this.getValueForParam("user");
        this.userPasswd = this.getValueForParam("password");
        this.userPasswd = this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.userPasswd);
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("sid");
        }
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        String string = this.getValueForParam("cloud_hosted");
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        String string2 = this.getValueForParam("exclude");
        String string3 = "";
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            object = new StringTokenizer(string2, ",");
            this.excludeInfo = new ArrayList();
            while (((StringTokenizer)object).countTokens() > 0) {
                this.excludeInfo.add(((StringTokenizer)object).nextToken().trim());
            }
        }
        if ((stringArray2 = (object = new EgThresholdInfo("agent")).getMeasurementsForTest("OraSystemWaitTest")) != null) {
            this.numOutputFields = stringArray2.length;
        }
        object = null;
        this.queryStmt = "";
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Object object;
        Object object2;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object2 = "tcps";
                object = this.targetHost;
                string2 = this.portNo;
                string = this.oraSid;
                String string3 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + object2 + ")(HOST=" + (String)object + ")(PORT=" + string2 + "))(CONNECT_DATA=(SERVICE_NAME=" + string + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string3);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                string2 = (String)((ArrayList)object2).get(1);
                if (string2.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = new Hashtable();
            object2 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object2 == null) return;
            if (((Hashtable)object2).size() == 0) {
                return;
            }
            object = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (object == null) return;
            if (((ArrayList)object).size() <= 0) return;
            string2 = (String)((ArrayList)object).get(2);
            string = (String)((ArrayList)object).get(3);
            if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        Connection connection = null;
        Object var10_11 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                Object object3;
                ArrayList arrayList;
                connection = this.isMultitenantDb && !this.isCDB ? (this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug)) : (this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug));
                if (connection == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    Object var41_14 = null;
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                this.queryStmt = "Select Event, Total_waits,Total_timeouts,Time_waited from v$system_event where wait_class# <> 6 union  select 'CPU Time' Event, 0 total_waits,0 total_timeouts, value/100 time_waited from v$sysstat where name='CPU used by this session' order by Time_waited desc";
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", "OraSystemWaitTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(connection);
                    Object var41_15 = null;
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                resultSet = statement.executeQuery(this.queryStmt);
                Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
                while (resultSet.next()) {
                    arrayList = new ArrayList();
                    object3 = new ArrayList();
                    object2 = resultSet.getString("event");
                    double d = resultSet.getDouble("Total_waits");
                    double d2 = resultSet.getDouble("total_timeouts");
                    double d3 = resultSet.getDouble("time_waited");
                    if (this.excludeInfo != null && this.excludeInfo.size() > 0 && this.excludeInfo.contains(object2)) continue;
                    ((ArrayList)object3).add(new Double(d));
                    ((ArrayList)object3).add(new Double(d2));
                    ((ArrayList)object3).add(new Double(d3));
                    hashtable2.put(object2, object3);
                }
                resultSet.close();
                statement.close();
                connection.close();
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    Object object4;
                    double d;
                    object3 = (String)enumeration.nextElement();
                    ArrayList arrayList2 = (ArrayList)hashtable2.get(object3);
                    ArrayList arrayList3 = (ArrayList)this.previous.get(object3);
                    if (arrayList3 == null || arrayList3 == null || arrayList3.size() <= 0) continue;
                    arrayList = new ArrayList();
                    double d4 = (Double)arrayList3.get(0);
                    double d5 = (Double)arrayList3.get(1);
                    double d6 = (Double)arrayList3.get(2);
                    double d7 = (Double)arrayList2.get(0);
                    double d8 = (Double)arrayList2.get(1);
                    double d9 = (Double)arrayList2.get(2);
                    double d10 = d7 - d4;
                    double d11 = d8 - d5;
                    double d12 = d = d9 - d6;
                    if (((String)object3).trim().equalsIgnoreCase("CPU Time")) {
                        d10 = -5.0;
                        d11 = -5.0;
                        d = -5.0;
                    } else {
                        if (d > 0.0) {
                            d = d7 > 0.0 ? d9 * 0.01 / d7 : 0.0;
                        }
                        if (d < 0.0) {
                            d = -5.0;
                        }
                        if (Double.isNaN(d)) {
                            d = 0.0;
                        }
                        object4 = this.round(d, 4);
                        d = Double.parseDouble((String)object4);
                    }
                    d10 = d10 < 0.0 ? -5.0 : d10;
                    d11 = d11 < 0.0 ? -5.0 : d11;
                    d = d < 0.0 ? -5.0 : d;
                    double d2 = d12 = d12 < 0.0 ? -5.0 : d12;
                    if (!(d > 0.0 || d11 > 0.0 || d10 > 0.0) && !(d12 > 0.0)) continue;
                    object4 = new ArrayList();
                    ((ArrayList)object4).add(new Double(d10));
                    ((ArrayList)object4).add(new Double(d11));
                    ((ArrayList)object4).add(new Double(d));
                    ((ArrayList)object4).add(new Double(d12));
                    this.addNewMeasure((String)object3, (ArrayList)object4);
                }
                this.previous = (Hashtable)hashtable2.clone();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                this.errorMsg = new String("Exception while executing  OraSystemWaitTest for target: " + this.targetHost);
                try {
                    connection.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.previous = new Hashtable();
                Object var41_17 = null;
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var41_18 = null;
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            throw throwable;
        }
        Object var41_16 = null;
        this.closeRs(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            long l = (long)d;
            string = string + l;
            d -= (double)l;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (long)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

