/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;

public class OraSessionTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    private String queryStmt;
    private String oracleVersion = "-";
    public double numActive;
    public double numInactive;
    public double numTotal;
    public double numKilled;
    public double numCached;
    public double numSniped;
    public double numBlocked;
    public double numBackground;
    public Hashtable dataForDDTable = null;
    public Hashtable blockerTable = null;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int versionNum = 11;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    ArrayList activeList = new ArrayList();
    ArrayList inactiveList = new ArrayList();
    ArrayList killedList = new ArrayList();
    ArrayList cachedList = new ArrayList();
    ArrayList snipedList = new ArrayList();
    ArrayList totalList = new ArrayList();
    ArrayList blockingList = new ArrayList();
    ArrayList backgroundList = new ArrayList();
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public static void main(String[] stringArray) {
        OraSessionTest oraSessionTest = new OraSessionTest(stringArray);
        oraSessionTest.computeMeasures(new Hashtable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraSessionTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("user");
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        this.userPasswd = this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.userPasswd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.queryStmt = this.numOutputFields > 2 ? "select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, sq.sql_fulltext from  v$session se,v$sql sq where  se.sql_address = sq.address and se.sql_id = sq.sql_id  and  se.sql_child_number = sq.child_number and  se.sql_hash_value = sq.hash_value union all select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, null sql_fulltext from  v$session se order  by 1,2" : "select distinct (status ||';;' || nvl(username,'-') || ';;' ||  nvl(osuser,'-') || ';;' || nvl(program,'-')) as data, count (*) from v$session where username is not null group by (status ||';;' || nvl(username,'-') || ';;' ||  nvl(osuser,'-') || ';;' || nvl(program,'-')) order by 2 desc";
        if (this.numOutputFields <= 2) {
            this.numOutputFields = 2;
        }
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        this.needAgentlessDD = true;
        System.out.println(this.entity + " measureCount :" + this.measureCount + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " portNo :" + this.portNo);
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object3 = "tcps";
                object2 = this.targetHost;
                object = this.portNo;
                string2 = this.oraSid;
                string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object3 + ")(HOST=" + (String)object2 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SERVICE_NAME=" + string2 + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        this.blockerTable = new Hashtable();
        this.activeList = new ArrayList();
        this.inactiveList = new ArrayList();
        this.killedList = new ArrayList();
        this.cachedList = new ArrayList();
        this.snipedList = new ArrayList();
        this.totalList = new ArrayList();
        this.blockingList = new ArrayList();
        this.backgroundList = new ArrayList();
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            System.out.println(this.entity + " versionList :" + object3 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " portNo :" + this.portNo);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                this.versionNum = (Integer)((ArrayList)object3).get(0);
                object2 = (String)((ArrayList)object3).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (this.versionNum >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)object3).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = new Hashtable();
            object3 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object3 == null) return;
            if (((Hashtable)object3).size() == 0) {
                return;
            }
            object2 = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.oraSid);
            if (object2 == null) return;
            if (((ArrayList)object2).size() <= 0) return;
            object = (String)((ArrayList)object2).get(2);
            string2 = (String)((ArrayList)object2).get(3);
            if (!((String)object).equalsIgnoreCase("PRIMARY") && string2.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        System.out.println(this.entity + " versionNum :" + this.versionNum + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " portNo :" + this.portNo);
        try {
            try {
                Object object4;
                if (this.isMultitenantDb) {
                    if (this.isCDB) {
                        if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                            this.logToErrorFile("INFO", "OraSessionTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.msgLogCounter = 0;
                        }
                        ++this.msgLogCounter;
                        return;
                    }
                    this.queryStmt = "select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, sq.sql_fulltext from  v$session se,v$sql sq where  se.con_id > 0 and sq.con_id > 0 and se.sql_address = sq.address and se.sql_id = sq.sql_id  and  se.sql_child_number = sq.child_number and  se.sql_hash_value = sq.hash_value union all select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, null sql_fulltext from  v$session se order  by 1,2";
                    object3 = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
                } else {
                    object3 = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
                }
                if (object3 == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    return;
                }
                try {
                    object2 = object3.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", "OraSessionTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                    exception.printStackTrace();
                    try {
                        if (object3 == null) return;
                        object3.close();
                        return;
                    }
                    catch (Exception exception2) {
                    }
                    return;
                }
                try {
                    string2 = "SELECT /*+ORDERED */lock2.sid, lock1.sid AS blockers FROM v$lock lock1 INNER JOIN v$lock lock2 ON lock1.id1 = lock2.id1  AND\tlock1.id2 = lock2.id2  WHERE lock1.block = 1 and lock2.request > 0";
                    System.out.println(this.entity + " lockQuery :" + string2 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    object = object2.executeQuery(string2);
                    while (object.next()) {
                        string = object.getString(1);
                        String string3 = object.getString(2);
                        this.blockerTable.put(string, string3);
                    }
                    System.out.println(this.entity + " blockerTable :" + this.blockerTable + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                }
                catch (Exception exception) {
                    System.out.println("Exception while getting blocked / blocking session");
                }
                boolean bl = false;
                if (this.oracleVersion != null && this.versionNum >= 11) {
                    bl = true;
                }
                double d = this.measurePeriod / 60000L;
                String string4 = "";
                TreeSet<String> treeSet = new TreeSet<String>();
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                if (bl) {
                    Cloneable cloneable;
                    String string5;
                    String string6;
                    string4 = "select status, type, sid, serial#, username, osuser,machine, terminal, program, module,last_call_et,blocking_session,sql_id,sql_child_number  from v$session where PREV_EXEC_START >= sysdate - (" + d + "/(24* 60))";
                    object4 = "select  sql_id,child_number ,sql_fulltext from v$sql where to_date(last_Load_Time, 'yyyy-mm-dd/hh24:mi:ss') >= sysdate - (" + d + "/(24* 60)) order by sql_id";
                    System.out.println(this.entity + " selectQuery :" + string4 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    System.out.println(this.entity + " sqlTextQuery :" + (String)object4 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    String string7 = "";
                    String string8 = "";
                    String string9 = "";
                    String string10 = "";
                    String string11 = "";
                    String string12 = "";
                    String string13 = "";
                    String string14 = "";
                    String string15 = "";
                    String string16 = "";
                    String string17 = "";
                    String string18 = "";
                    String string19 = "";
                    String string20 = "";
                    String string21 = "";
                    Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                    Hashtable<String, Cloneable> hashtable3 = new Hashtable<String, Cloneable>();
                    object = object2.executeQuery(string4);
                    while (object.next()) {
                        boolean bl2 = false;
                        string7 = object.getString(1);
                        string8 = object.getString(2);
                        string9 = object.getString(3);
                        string10 = object.getString(4);
                        string11 = object.getString(5);
                        string13 = object.getString(6);
                        string14 = object.getString(7);
                        string15 = object.getString(8);
                        string16 = object.getString(9);
                        string17 = object.getString(10);
                        string21 = object.getString(11);
                        string18 = object.getString(12);
                        string19 = object.getString(13);
                        string20 = object.getString(14);
                        string7 = this.getValue(string7);
                        string10 = this.getValue(string10);
                        string11 = this.checkSize(string11, 32);
                        string13 = this.checkSize(string13, 128);
                        string10 = this.checkSize(string10, 32);
                        string15 = this.checkSize(string15, 128);
                        string16 = this.checkSize(string16, 128);
                        string17 = this.checkSize(string17, 128);
                        string21 = this.checkSize(string21, 32);
                        string18 = this.checkSize(string18, 32);
                        string19 = this.checkSize(string19, 32);
                        string20 = this.checkSize(string20, 32);
                        if (treeSet.contains(string9)) continue;
                        treeSet.add(string9);
                        string6 = "";
                        string6 = string8 != null && string8.equalsIgnoreCase("BACKGROUND") ? string8 + fieldSep + string9 + fieldSep + string10 + fieldSep + string11 + fieldSep + string13 + fieldSep + string14 + fieldSep + string15 + fieldSep + string16 + fieldSep + string17 + fieldSep + string21 + fieldSep + string18 : string7 + fieldSep + string9 + fieldSep + string10 + fieldSep + string11 + fieldSep + string13 + fieldSep + string14 + fieldSep + string15 + fieldSep + string16 + fieldSep + string17 + fieldSep + string21 + fieldSep + string18;
                        string5 = string19 + "%" + string20;
                        hashtable2.put(string5, string6);
                        if (!string18.equalsIgnoreCase("-") && !string9.equalsIgnoreCase("-")) {
                            this.blockerTable.put(string9, string18);
                            bl2 = true;
                        }
                        if (!bl2) continue;
                        if (hashtable3.containsKey(string5)) {
                            cloneable = (ArrayList)hashtable3.get(string5);
                            ((ArrayList)cloneable).add(string6);
                            hashtable3.put(string5, cloneable);
                            continue;
                        }
                        cloneable = new ArrayList();
                        ((ArrayList)cloneable).add(string6);
                        hashtable3.put(string5, cloneable);
                    }
                    this.closeRs((ResultSet)object);
                    System.out.println(this.entity + " infoHash :" + hashtable2 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    String string22 = "";
                    string6 = "";
                    string5 = "";
                    cloneable = new Hashtable<String, String>();
                    String string23 = "";
                    object = object2.executeQuery((String)object4);
                    while (object.next()) {
                        string22 = object.getString(1);
                        string6 = object.getString(2);
                        string5 = object.getString(3);
                        string22 = this.checkSize(string22, 32);
                        string6 = this.checkSize(string6, 32);
                        string5 = this.checkSize(string5, 2048);
                        string23 = string22 + "%" + string6;
                        ((Hashtable)cloneable).put(string23, string5);
                    }
                    this.closeRs((ResultSet)object);
                    System.out.println(this.entity + " sqlTextDDHash :" + cloneable + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        String string24;
                        Object object5;
                        String string25 = (String)enumeration.nextElement();
                        String string26 = (String)hashtable2.get(string25);
                        String string27 = "-";
                        string27 = ((Hashtable)cloneable).get(string25) != null ? (String)((Hashtable)cloneable).get(string25) : "-";
                        String string28 = string26 + fieldSep + string27;
                        String string29 = string28.substring(0, string28.indexOf(fieldSep));
                        String string30 = string28.substring(string28.indexOf(fieldSep) + 3, string28.length());
                        if (string29.equalsIgnoreCase("BACKGROUND")) {
                            this.backgroundList.add(string30);
                        } else if (string29.equalsIgnoreCase("ACTIVE")) {
                            this.activeList.add(string30);
                        } else if (string29.equalsIgnoreCase("INACTIVE")) {
                            this.inactiveList.add(string30);
                        } else if (string29.equalsIgnoreCase("KILLED")) {
                            this.killedList.add(string30);
                        } else if (string29.equalsIgnoreCase("CACHED")) {
                            this.cachedList.add(string30);
                        } else if (string29.equalsIgnoreCase("SNIPED")) {
                            this.snipedList.add(string30);
                        }
                        String string31 = "-";
                        if (hashtable3.containsKey(string25)) {
                            object5 = (ArrayList)hashtable3.get(string25);
                            string24 = (String)((ArrayList)object5).get(0);
                            if (string24 == null || string24.trim().length() == 0) {
                                string24 = "-";
                            }
                            if ((string27 = (String)((Hashtable)cloneable).get(string25)) == null || string27.trim().length() == 0) {
                                string27 = "-";
                            }
                            string31 = string24 + fieldSep + string27;
                        }
                        if (string31.equalsIgnoreCase("-")) continue;
                        object5 = string31.substring(0, string31.indexOf(fieldSep));
                        string24 = string31.substring(string31.indexOf(fieldSep) + 3, string31.length());
                        this.blockingList.add(string24);
                    }
                } else {
                    string4 = "select  se.status, se.type, se.sid, se.serial#, se.username, se.osuser,se.machine, se.terminal, se.program, se.module, se.last_call_et,se.blocking_session, sq.sql_fulltext from  v$session se left outer join v$sql sq on se.sql_id = sq.sql_id and se.sql_child_number = sq.child_number order by 1,2 ";
                    System.out.println(this.entity + " selectQuery :" + string4 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    object4 = "";
                    String string32 = "";
                    String string33 = "";
                    String string34 = "";
                    String string35 = "";
                    String string36 = "";
                    String string37 = "";
                    String string38 = "";
                    String string39 = "";
                    String string40 = "";
                    String string41 = "";
                    String string42 = "";
                    String string43 = "";
                    String string44 = "";
                    object = object2.executeQuery(string4);
                    while (object.next()) {
                        boolean bl3 = false;
                        object4 = object.getString(1);
                        string32 = object.getString(2);
                        string33 = object.getString(3);
                        string34 = object.getString(4);
                        string35 = object.getString(5);
                        string37 = object.getString(6);
                        string38 = object.getString(7);
                        string39 = object.getString(8);
                        string40 = object.getString(9);
                        string41 = object.getString(10);
                        string43 = object.getString(11);
                        string42 = object.getString(12);
                        string44 = object.getString(12);
                        if (treeSet.contains(string33)) continue;
                        treeSet.add(string33);
                        object4 = this.getValue((String)object4);
                        string34 = this.getValue(string34);
                        string35 = this.checkSize(string35, 32);
                        string37 = this.checkSize(string37, 128);
                        string34 = this.checkSize(string34, 32);
                        string39 = this.checkSize(string39, 128);
                        string40 = this.checkSize(string40, 128);
                        string41 = this.checkSize(string41, 128);
                        string43 = this.checkSize(string43, 32);
                        string42 = this.checkSize(string42, 32);
                        string44 = this.checkSize(string44, 2048);
                        String string45 = "-";
                        if (this.blockerTable.containsKey(string33)) {
                            string45 = (String)this.blockerTable.get(string33);
                            bl3 = true;
                        }
                        String string46 = "";
                        string46 = string32 != null && string32.equalsIgnoreCase("BACKGROUND") ? string33 + fieldSep + string34 + fieldSep + string35 + fieldSep + string37 + fieldSep + string38 + fieldSep + string39 + fieldSep + string40 + fieldSep + string41 + fieldSep + string43 + fieldSep + string42 + fieldSep + string44 : string33 + fieldSep + string34 + fieldSep + string35 + fieldSep + string37 + fieldSep + string38 + fieldSep + string39 + fieldSep + string40 + fieldSep + string41 + fieldSep + string43 + fieldSep + string42 + fieldSep + string44;
                        if (string32.equalsIgnoreCase("BACKGROUND")) {
                            this.backgroundList.add(string46);
                        } else if (((String)object4).equalsIgnoreCase("ACTIVE")) {
                            this.activeList.add(string46);
                        } else if (((String)object4).equalsIgnoreCase("INACTIVE")) {
                            this.inactiveList.add(string46);
                        } else if (((String)object4).equalsIgnoreCase("KILLED")) {
                            this.killedList.add(string46);
                        } else if (((String)object4).equalsIgnoreCase("CACHED")) {
                            this.cachedList.add(string46);
                        } else if (((String)object4).equalsIgnoreCase("SNIPED")) {
                            this.snipedList.add(string46);
                        }
                        if (!bl3) continue;
                        this.blockingList.add(string46);
                    }
                }
                System.out.println(this.entity + " backgroundList :" + this.backgroundList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + " activeList :" + this.activeList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + " inactiveList :" + this.inactiveList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + " killedList :" + this.killedList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + " cachedList :" + this.cachedList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + " snipedList :" + this.snipedList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + " blockingList :" + this.blockingList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                d3 = this.activeList.size();
                d4 = this.backgroundList.size();
                d5 = this.inactiveList.size();
                d6 = this.killedList.size();
                d7 = this.cachedList.size();
                d8 = this.snipedList.size();
                d9 = this.blockingList.size();
                d2 = d3 + d4 + d5 + d6 + d7 + d8 + d9;
                object4 = new ArrayList();
                ((ArrayList)object4).add(new Double(d2));
                ((ArrayList)object4).add(new Double(d3));
                if (this.measureCount > 2) {
                    ((ArrayList)object4).add(new Double(d4));
                    ((ArrayList)object4).add(new Double(d5));
                    ((ArrayList)object4).add(new Double(d6));
                    ((ArrayList)object4).add(new Double(d7));
                    ((ArrayList)object4).add(new Double(d8));
                    ((ArrayList)object4).add(new Double(d9));
                }
                System.out.println(this.entity + " measureList :" + object4 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                this.addNewMeasure((ArrayList)object4);
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in computeMeasure of OraSessionTest");
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var60_18 = null;
            throw throwable;
        }
    }

    private String checkSize(String string, int n) {
        if (string != null && string.trim().length() > 0) {
            int n2 = string.length();
            if (n2 > n) {
                string = string.substring(0, n - 4) + "..";
            }
        } else {
            string = "-";
        }
        return string;
    }

    public String getValue(String string) {
        string = string == null || string.trim().length() == 0 ? "-" : string.trim();
        return string;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void freeTest() {
        this.activeList = new ArrayList();
        this.inactiveList = new ArrayList();
        this.killedList = new ArrayList();
        this.cachedList = new ArrayList();
        this.snipedList = new ArrayList();
        this.totalList = new ArrayList();
        this.blockingList = new ArrayList();
        this.backgroundList = new ArrayList();
    }
}

