/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class OraRacTimeWorkloadTest
extends GenericTest {
    private String oraSid = "";
    private String user = "";
    private String passwd = "";
    private Connection conn = null;
    private double defValue = -1.0;
    private boolean isFirstTime = true;
    double numberOfProcessor = -1.0;
    private boolean agentLessSupport = false;
    private String serviceName = "";
    private boolean service = true;
    private Hashtable prevHash = new Hashtable();
    private Hashtable currHash;
    private boolean isNumProcFound = false;
    private boolean isOracle10GAndAbove = false;
    private boolean foundVersion = false;
    private static final double DEFAULT_MINUS_ONE = -1.0;
    private ArrayList prevInfoList = new ArrayList();
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraRacTimeWorkloadTest(String[] stringArray) {
        super(stringArray);
        this.printOut("OraRacTimeWorkloadTest constructor");
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("username");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.passwd = this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.passwd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.printOut("OraRacTimeWorkloadTest computer measure");
        this.currHash = new Hashtable();
        Statement statement = null;
        String string = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = "select 'DBO'||inst_id,value/100 cpu_time_secs from gv$sysstat where name='CPU used by this session'";
        String string3 = "select 'DBO'||inst_id,value redo_size_bytes from gv$sysstat where name='redo size'";
        String string4 = "select 'DBO'||inst_id,value logical_reads_count from gv$sysstat where name='session logical reads'";
        String string5 = "select 'DBO'||inst_id,value block_changes_count from gv$sysstat where name='db block changes'";
        String string6 = "select 'DBO'||inst_id,value physical_reads_count from gv$sysstat where name='physical reads'";
        String string7 = "select 'DBO'||inst_id,value physical_writes_count from gv$sysstat where name='physical writes'";
        String string8 = "select 'DBO'||inst_id,value user_calls_count from gv$sysstat where name='user calls'";
        String string9 = "select 'DBO'||inst_id,value parse_count from gv$sysstat where name='parse count (total)'";
        String string10 = "select 'DBO'||inst_id,value hard_parse_count from gv$sysstat where name ='parse count (hard)'";
        String string11 = "select 'DBO'||inst_id,value/1024 WA_memory_MB from gv$sysstat where name='workarea memory allocated'";
        String string12 = "select 'DBO'||inst_id,value as count_in_number from gv$sysstat where lower(name) ='logons cumulative'";
        String string13 = "select 'DBO'||inst_id,value execute_count from gv$sysstat where name='execute count'";
        String string14 = "select 'DBO'||inst_id,value transaction_rollbacks_count from gv$sysstat where name='transaction rollbacks'";
        String string15 = "select 'DBO'||inst_id,sum(value) from gv$sysstat where NAME in ('user commits','transaction rollbacks') group by inst_id";
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object4 = "tcps";
                object3 = this.targetHost;
                object2 = this.portNo;
                object = "";
                String string16 = "";
                if (this.service) {
                    string16 = this.serviceName;
                    object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object4 + ")(HOST=" + (String)object3 + ")(PORT=" + (String)object2 + "))(CONNECT_DATA=(SERVICE_NAME=" + string16 + ")))";
                } else {
                    string16 = this.oraSid;
                    object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + (String)object4 + ")(HOST=" + (String)object3 + ")(PORT=" + (String)object2 + "))(CONNECT_DATA=(SID=" + string16 + ")))";
                }
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", object);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        try {
            try {
                block38: {
                    block40: {
                        block41: {
                            int i;
                            block36: {
                                block39: {
                                    block37: {
                                        block35: {
                                            try {
                                                this.printOut("OraRacTimeWorkloadTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                                                this.conn = this.isSSLEnabled ? ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug, this.sslParametersHT) : ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug);
                                            }
                                            catch (Exception exception) {
                                                exception.printStackTrace();
                                                this.logToErrorFile("[OraRacTimeWorkloadTest] compute Measure()", "failed to connect database", exception.toString());
                                                Object var110_35 = null;
                                                this.closeStmt(statement);
                                                this.closeConn(this.conn);
                                                return;
                                            }
                                            if (this.conn != null) break block35;
                                            this.printOut("OraRacTimeWorkloadTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
                                            this.logToErrorFile("[OraRacTimeWorkloadTest] executeQry method ", "database conn is null ", "TargetHost" + this.targetHost);
                                            i = 0;
                                            break block36;
                                        }
                                        this.prevInfoList = new ArrayList();
                                        try {
                                            statement = this.conn.createStatement();
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                            this.closeConn(this.conn);
                                            Object var110_37 = null;
                                            this.closeStmt(statement);
                                            this.closeConn(this.conn);
                                            return;
                                        }
                                        if (!this.foundVersion) {
                                            object4 = new Properties();
                                            ((Properties)object4).put("user", this.user);
                                            ((Properties)object4).put("password", this.passwd);
                                            this.foundVersion = this.getVersion(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, (Properties)object4, debug);
                                        }
                                        if (!this.isNumProcFound) {
                                            object4 = "";
                                            object4 = this.isOracle10GAndAbove ? "select VALUE from v$osstat where stat_name='NUM_CPUS'" : "select value from v$parameter where name='cpu_count'";
                                            this.printOut("OraTimeWorkloadTest cpuCountQuery:::" + (String)object4);
                                            object3 = null;
                                            try {
                                                object3 = statement.executeQuery((String)object4);
                                                while (object3.next()) {
                                                    this.numberOfProcessor = object3.getDouble(1);
                                                }
                                            }
                                            catch (Exception exception) {
                                                exception.printStackTrace();
                                            }
                                            if (this.numberOfProcessor > 0.0) {
                                                this.isNumProcFound = true;
                                            }
                                        }
                                        this.printOut("OraRacTimeWorkloadTest numberOfProcessor:::" + this.numberOfProcessor);
                                        this.executeQry(statement, string2);
                                        this.executeQry(statement, string3);
                                        this.executeQry(statement, string4);
                                        this.executeQry(statement, string5);
                                        this.executeQry(statement, string6);
                                        this.executeQry(statement, string7);
                                        this.executeQry(statement, string8);
                                        this.executeQry(statement, string9);
                                        this.executeQry(statement, string10);
                                        this.executeQry(statement, string11);
                                        this.executeQry(statement, string12);
                                        this.executeQry(statement, string13);
                                        this.executeQry(statement, string14);
                                        this.executeQry(statement, string15);
                                        if (!this.isFirstTime) break block37;
                                        this.isFirstTime = false;
                                        arrayList = new ArrayList();
                                        for (int i2 = 0; i2 < this.measureCount; ++i2) {
                                            arrayList.add(new Double(-1.0));
                                        }
                                        break block38;
                                    }
                                    if (this.prevHash == null || this.prevHash.size() <= 0 || this.currHash == null || this.currHash.size() <= 0) break block39;
                                    if (this.prevHash.size() != this.currHash.size()) break block40;
                                    object4 = this.prevHash.keys();
                                    break block41;
                                }
                                arrayList = new ArrayList();
                                for (int i3 = 0; i3 < this.measureCount; ++i3) {
                                    arrayList.add(new Double(-5.0));
                                    this.addNewMeasure(arrayList);
                                }
                                break block40;
                            }
                            while (true) {
                                if (i >= this.prevInfoList.size()) {
                                    Object var110_36 = null;
                                    this.closeStmt(statement);
                                    this.closeConn(this.conn);
                                    return;
                                }
                                arrayList = new ArrayList();
                                object3 = (String)this.prevInfoList.get(i);
                                for (int j = 0; j < this.measureCount; ++j) {
                                    arrayList.add(new Double(-1.0));
                                }
                                this.printOut("Adding MeasureList :" + arrayList);
                                this.addNewMeasure((String)object3, arrayList);
                                ++i;
                            }
                        }
                        while (object4.hasMoreElements()) {
                            object3 = (String)object4.nextElement();
                            object2 = (ArrayList)this.prevHash.get(object3);
                            object = (ArrayList)this.currHash.get(object3);
                            double d = (Double)((ArrayList)object).get(0);
                            double d2 = (Double)((ArrayList)object).get(1);
                            double d3 = (Double)((ArrayList)object).get(2);
                            double d4 = (Double)((ArrayList)object).get(3);
                            double d5 = (Double)((ArrayList)object).get(4);
                            double d6 = (Double)((ArrayList)object).get(5);
                            double d7 = (Double)((ArrayList)object).get(6);
                            double d8 = (Double)((ArrayList)object).get(7);
                            double d9 = (Double)((ArrayList)object).get(8);
                            double d10 = (Double)((ArrayList)object).get(9);
                            double d11 = (Double)((ArrayList)object).get(10);
                            double d12 = (Double)((ArrayList)object).get(11);
                            double d13 = (Double)((ArrayList)object).get(12);
                            double d14 = (Double)((ArrayList)object).get(13);
                            double d15 = (Double)((ArrayList)object2).get(0);
                            double d16 = (Double)((ArrayList)object2).get(1);
                            double d17 = (Double)((ArrayList)object2).get(2);
                            double d18 = (Double)((ArrayList)object2).get(3);
                            double d19 = (Double)((ArrayList)object2).get(4);
                            double d20 = (Double)((ArrayList)object2).get(5);
                            double d21 = (Double)((ArrayList)object2).get(6);
                            double d22 = (Double)((ArrayList)object2).get(7);
                            double d23 = (Double)((ArrayList)object2).get(8);
                            double d24 = (Double)((ArrayList)object2).get(9);
                            double d25 = (Double)((ArrayList)object2).get(10);
                            double d26 = (Double)((ArrayList)object2).get(11);
                            double d27 = (Double)((ArrayList)object2).get(12);
                            double d28 = (Double)((ArrayList)object2).get(13);
                            double d29 = this.getDiff(d, d15);
                            double d30 = this.getDiff(d2, d16);
                            double d31 = this.getDiff(d3, d17);
                            double d32 = this.getDiff(d4, d18);
                            double d33 = this.getDiff(d5, d19);
                            double d34 = this.getDiff(d6, d20);
                            double d35 = this.getDiff(d7, d21);
                            double d36 = this.getDiff(d8, d22);
                            double d37 = this.getDiff(d9, d23);
                            double d38 = this.getDiff(d10, d24);
                            double d39 = this.getDiff(d11, d25);
                            double d40 = this.getDiff(d12, d26);
                            double d41 = this.getDiff(d13, d27);
                            double d42 = this.getDiff(d14, d28);
                            double d43 = -5.0;
                            if (this.numberOfProcessor > 0.0) {
                                d43 = d29 / this.numberOfProcessor;
                            }
                            if (d30 > 0.0) {
                                d30 /= 1048576.0;
                            }
                            if (this.timeSinceLastTest > 0.0) {
                                d43 = d43 / this.timeSinceLastTest * 100.0;
                                d30 /= this.timeSinceLastTest;
                                d31 /= this.timeSinceLastTest;
                                d32 /= this.timeSinceLastTest;
                                d33 /= this.timeSinceLastTest;
                                d34 /= this.timeSinceLastTest;
                                d35 /= this.timeSinceLastTest;
                                d36 /= this.timeSinceLastTest;
                                d37 /= this.timeSinceLastTest;
                                d38 /= this.timeSinceLastTest;
                                d39 /= this.timeSinceLastTest;
                                d40 /= this.timeSinceLastTest;
                                d41 /= this.timeSinceLastTest;
                                d42 /= this.timeSinceLastTest;
                            } else {
                                d43 = 0.0;
                                d30 = 0.0;
                                d31 = 0.0;
                                d32 = 0.0;
                                d33 = 0.0;
                                d34 = 0.0;
                                d35 = 0.0;
                                d36 = 0.0;
                                d37 = 0.0;
                                d38 = 0.0;
                                d39 = 0.0;
                                d40 = 0.0;
                                d41 = 0.0;
                                d42 = 0.0;
                            }
                            d43 = d43 < 0.0 ? -5.0 : d43;
                            d29 = d29 < 0.0 ? -5.0 : d29;
                            d30 = d30 < 0.0 ? -5.0 : d30;
                            d31 = d31 < 0.0 ? -5.0 : d31;
                            d32 = d32 < 0.0 ? -5.0 : d32;
                            d33 = d33 < 0.0 ? -5.0 : d33;
                            d34 = d34 < 0.0 ? -5.0 : d34;
                            d35 = d35 < 0.0 ? -5.0 : d35;
                            d36 = d36 < 0.0 ? -5.0 : d36;
                            d37 = d37 < 0.0 ? -5.0 : d37;
                            d38 = d38 < 0.0 ? -5.0 : d38;
                            d39 = d39 < 0.0 ? -5.0 : d39;
                            d40 = d40 < 0.0 ? -5.0 : d40;
                            d41 = d41 < 0.0 ? -5.0 : d41;
                            d42 = d42 < 0.0 ? -5.0 : d42;
                            arrayList = new ArrayList();
                            arrayList.add(new Double(d43));
                            arrayList.add(new Double(d29));
                            arrayList.add(new Double(d30));
                            arrayList.add(new Double(d31));
                            arrayList.add(new Double(d32));
                            arrayList.add(new Double(d33));
                            arrayList.add(new Double(d34));
                            arrayList.add(new Double(d35));
                            arrayList.add(new Double(d36));
                            arrayList.add(new Double(d37));
                            arrayList.add(new Double(d38));
                            arrayList.add(new Double(d39));
                            arrayList.add(new Double(d40));
                            arrayList.add(new Double(d41));
                            arrayList.add(new Double(d42));
                            this.addNewMeasure((String)object3, arrayList);
                            this.prevInfoList.add(object3);
                        }
                    }
                    if (this.currHash != null && this.currHash.size() > 0) {
                        this.prevHash = (Hashtable)this.currHash.clone();
                    }
                }
                this.closeStmt(statement);
                this.closeConn(this.conn);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("[OraRacTimeWorkloadTest] compute Measure()", "Exception ", exception.toString());
                int i = 0;
                while (true) {
                    if (i >= this.prevInfoList.size()) {
                        Object var110_39 = null;
                        this.closeStmt(statement);
                        this.closeConn(this.conn);
                        return;
                    }
                    arrayList = new ArrayList();
                    object2 = (String)this.prevInfoList.get(i);
                    for (int j = 0; j < this.measureCount; ++j) {
                        arrayList.add(new Double(-1.0));
                    }
                    this.printOut("Adding MeasureList :" + arrayList);
                    this.addNewMeasure((String)object2, arrayList);
                    ++i;
                }
            }
            Object var110_38 = null;
            this.closeStmt(statement);
            this.closeConn(this.conn);
            return;
        }
        catch (Throwable throwable) {
            Object var110_40 = null;
            this.closeStmt(statement);
            this.closeConn(this.conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double executeQry(Statement statement, String string) {
        double d;
        ResultSet resultSet;
        block9: {
            resultSet = null;
            d = -5.0;
            if (this.conn != null) break block9;
            this.printOut("OraRacTimeWorkloadTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            this.logToErrorFile("[OraRacTimeWorkloadTest] executeQry method ", "database conn is null ", "TargetHost" + this.targetHost);
            double d2 = d;
            Object var10_8 = null;
            this.closeRs(resultSet);
            return d2;
        }
        try {
            try {
                if (statement == null) {
                    statement = this.conn.createStatement();
                }
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string2 = resultSet.getString(1);
                    d = resultSet.getDouble(2);
                    if (this.currHash != null && this.currHash.size() > 0) {
                        ArrayList arrayList2 = (ArrayList)this.currHash.get(string2);
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            arrayList2.add(new Double(d));
                            this.currHash.put(string2, arrayList2);
                            continue;
                        }
                        arrayList.add(new Double(d));
                        this.currHash.put(string2, arrayList);
                        continue;
                    }
                    arrayList.add(new Double(d));
                    this.currHash.put(string2, arrayList);
                }
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                double d3 = d;
                Object var10_10 = null;
                this.closeRs(resultSet);
                return d3;
            }
            Object var10_9 = null;
            this.closeRs(resultSet);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeRs(resultSet);
            throw throwable;
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d >= 0.0 && d2 >= 0.0) {
            d3 = d - d2;
        }
        return d3;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getVersion(String string, String string2, String string3, String string4, boolean bl, String string5, Properties properties, boolean bl2) {
        boolean bl3;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string6 = "";
        String string7 = "select version from v$instance";
        connection = this.isSSLEnabled ? ConnectionManager.getOraClstrConn(string + "getVersion()", string2, string3, string4, bl, string5, properties, bl2, this.sslParametersHT) : ConnectionManager.getOraClstrConn(string + "getVersion()", string2, string3, string4, bl, string5, properties, bl2);
        if (connection == null) {
            return false;
        }
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string7);
                while (resultSet != null && resultSet.next()) {
                    string6 = resultSet.getString(1);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                if (string6 == null || string6.trim().length() == 0) {
                    this.logToErrorFile("OraRacTimeWorkloadTest:", "Query  select version from v$instance returning null ", "Hence assuming that the result set is empty");
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, ".");
                    int n = stringTokenizer.countTokens();
                    if (n > 0) {
                        string6 = stringTokenizer.nextToken();
                    }
                }
                if (string6 != null && string6.length() > 0) {
                    int n = Integer.parseInt(string6);
                    this.isOracle10GAndAbove = n >= 10;
                }
                bl3 = true;
                Object var17_20 = null;
            }
            catch (Exception exception) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                exception.printStackTrace();
                boolean bl4 = false;
                Object var17_21 = null;
                try {
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return bl4;
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            try {}
            catch (Exception exception2) {
                exception2.printStackTrace();
                throw throwable;
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            exception.printStackTrace();
            return bl3;
        }
        this.closeRs(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
        return bl3;
    }

    public static void main(String[] stringArray) {
        OraRacTimeWorkloadTest oraRacTimeWorkloadTest = new OraRacTimeWorkloadTest(stringArray);
        oraRacTimeWorkloadTest.computeMeasures(new Hashtable());
    }
}

