/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraDbGrowthTest
extends GenericTest {
    public String user;
    public String passwd;
    public String oraSid;
    public String viewName;
    private static final int i_measureCount = 5;
    private static double gbConvertor = 1.073741824E9;
    private boolean useMaxSize = true;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraDbGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        String string = this.getValueForParam("use_max_size");
        this.isNewDynamicInfoTest = true;
        this.viewName = this.getValueForParam("alternate_view");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string2 = this.getValueForParam("cloud_hosted");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.passwd = this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.passwd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.useMaxSize = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                var2_2 = "tcps";
                var3_3 = this.targetHost;
                var4_5 = this.portNo;
                var5_6 = this.oraSid;
                var6_7 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + var2_2 + ")(HOST=" + (String)var3_3 + ")(PORT=" + (String)var4_5 + "))(CONNECT_DATA=(SERVICE_NAME=" + (String)var5_6 + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", var6_7);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled != false ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug, this.reportingName);
            var2_2 = new ArrayList<E>();
            var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (var2_2 != null && var2_2.size() > 2) {
                var3_4 = (Integer)var2_2.get(0);
                var4_5 = (String)var2_2.get(1);
                if (var4_5.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (var3_4 >= 12) {
                    this.isOracle12c = true;
                    var5_6 = (String)var2_2.get(2);
                    if (var5_6.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + var2_2, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            var2_2 = new Hashtable<K, V>();
            var2_2 = this.isSSLEnabled != false ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug, this.reportingName);
            if (var2_2 == null) return;
            if (var2_2.size() == 0) {
                return;
            }
            var3_3 = (ArrayList)var2_2.get(this.reportingName + ":" + this.oraSid);
            if (var3_3 == null) return;
            if (var3_3.size() <= 0) return;
            var4_5 = (String)var3_3.get(2);
            var5_6 = (String)var3_3.get(3);
            if (!var4_5.equalsIgnoreCase("PRIMARY") && var5_6.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        var2_2 = new ArrayList<E>();
        var3_3 = null;
        var4_5 = null;
        var5_6 = null;
        var6_8 = 0.0;
        var8_9 = 0.0;
        var10_10 = 0.0;
        var12_11 = 0.0;
        var14_12 = 0.0;
        var16_13 = "";
        var17_14 = 0.0;
        try {
            block83: {
                block82: {
                    block80: {
                        block81: {
                            var16_13 = this.viewName == null || this.viewName.equals("") != false || this.viewName.equalsIgnoreCase("NULL") != false || this.viewName.equalsIgnoreCase("none") != false ? "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from DBA_FREE_SPACE group by file_id) b on a.file_id = b.file_id" : "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from " + this.viewName + " group by file_id) b on a.file_id = b.file_id";
                            if (!this.isMultitenantDb) break block80;
                            if (!this.isCDB) break block81;
                            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                                this.logToErrorFile("INFO", "OraDbGrowthTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                this.msgLogCounter = 0;
                            }
                            ++this.msgLogCounter;
                            var28_15 = null;
                            ** GOTO lbl229
                        }
                        var3_3 = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug);
                        break block82;
                    }
                    var3_3 = this.isSSLEnabled != false ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDbGrowthTest.debug);
                }
                if (var3_3 != null) break block83;
                System.out.println(this.entity + " connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                ** GOTO lbl250
            }
            try {
                var4_5 = var3_3.createStatement();
            }
            catch (Exception var19_33) {
                this.logToErrorFile("Error :", "OraDbGrowthTest Failed to Create Statement reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var19_33.toString());
                var19_33.printStackTrace();
                try {
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                }
                catch (Exception var20_37) {
                }
                var28_17 = null;
                try {
                    if (var5_6 != null) {
                        try {
                            var5_6.close();
                        }
                        catch (Exception var29_25) {
                            // empty catch block
                        }
                    }
                    if (var4_5 != null) {
                        try {
                            var4_5.close();
                        }
                        catch (Exception var29_25) {
                            // empty catch block
                        }
                    }
                    if (var3_3 == null) return;
                    var3_3.close();
                    return;
                }
                catch (Exception var29_26) {
                    System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + var29_26.toString());
                }
                return;
            }
            var5_6 = var4_5.executeQuery(var16_13);
            while (var5_6.next()) {
                var19_34 = var5_6.getDouble(1);
                var21_41 = var5_6.getDouble(2);
                var23_42 = var5_6.getDouble(3);
                var25_43 = var5_6.getDouble(4);
                if (var21_41 == 0.0) {
                    var21_41 = var23_42;
                }
                if (this.useMaxSize) {
                    var10_10 += var21_41;
                    var17_14 = var21_41 - var23_42 + var25_43;
                    var6_8 += var17_14;
                    continue;
                }
                var10_10 += var23_42;
                var17_14 = var25_43;
                var6_8 += var17_14;
            }
            var12_11 = var10_10 / OraDbGrowthTest.gbConvertor;
            var12_11 = var10_10 / OraDbGrowthTest.gbConvertor;
            var8_9 = var6_8 / OraDbGrowthTest.gbConvertor;
            var2_2.add(new Double(var12_11));
            var2_2.add(new Double(var12_11 - var8_9));
            var2_2.add(new Double(var8_9));
            var19_35 = new BigDecimal((var12_11 - var8_9) / var12_11 * 100.0);
            var19_35 = var19_35.setScale(2, 6);
            var2_2.add(new Double(var19_35.doubleValue()));
            var20_38 = new BigDecimal(var8_9 / var12_11 * 100.0);
            var20_38 = var20_38.setScale(2, 6);
            var2_2.add(new Double(var20_38.doubleValue()));
            this.addNewMeasure((ArrayList)var2_2);
            var5_6.close();
            var4_5.close();
            ** GOTO lbl272
        }
        catch (Exception var19_36) {
            block71: {
                block70: {
                    this.logToErrorFile("Error :", "OraDbGrowthTest Failed to computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var19_36.toString());
                    System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures():" + var19_36.toString());
                    if (var5_6 != null) {
                        try {
                            var5_6.close();
                        }
                        catch (Exception var20_39) {
                            // empty catch block
                        }
                    }
                    if (var4_5 != null) {
                        try {
                            var4_5.close();
                        }
                        catch (Exception var20_40) {
                        }
                    }
                    var28_19 = null;
                    try {}
                    catch (Exception var29_30) {
                        System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + var29_30.toString());
                        return;
                    }
                    if (var5_6 != null) {
                        ** try [egrp 7[TRYBLOCK] [14 : 1897->1907)] { 
lbl190:
                        // 1 sources

                        var5_6.close();
                        break block70;
lbl192:
                        // 1 sources

                        catch (Exception var29_29) {
                            // empty catch block
                        }
                    }
                }
                if (var4_5 != null) {
                    ** try [egrp 8[TRYBLOCK] [15 : 1914->1924)] { 
lbl197:
                    // 1 sources

                    var4_5.close();
                    break block71;
lbl199:
                    // 1 sources

                    catch (Exception var29_29) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }
        {
            block79: {
                block78: {
                    block77: {
                        block76: {
                            block75: {
                                block74: {
                                    catch (Throwable var27_44) {
                                        block73: {
                                            block72: {
                                                var28_20 = null;
                                                ** try [egrp 6[TRYBLOCK] [16 : 1892->1939)] { 
lbl209:
                                                // 1 sources

                                                if (var5_6 != null) {
                                                    ** try [egrp 7[TRYBLOCK] [14 : 1897->1907)] { 
lbl211:
                                                    // 1 sources

                                                    var5_6.close();
                                                    break block72;
lbl213:
                                                    // 1 sources

                                                    catch (Exception var29_31) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (var4_5 != null) {
                                                ** try [egrp 8[TRYBLOCK] [15 : 1914->1924)] { 
lbl218:
                                                // 1 sources

                                                var4_5.close();
                                                break block73;
lbl220:
                                                // 1 sources

                                                catch (Exception var29_31) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var3_3 == null) throw var27_44;
                                        var3_3.close();
                                        throw var27_44;
lbl226:
                                        // 1 sources

                                        catch (Exception var29_32) {
                                            System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + var29_32.toString());
                                        }
                                        throw var27_44;
                                    }
lbl229:
                                    // 1 sources

                                    ** try [egrp 6[TRYBLOCK] [16 : 1892->1939)] { 
lbl230:
                                    // 1 sources

                                    if (var5_6 != null) {
                                        ** try [egrp 7[TRYBLOCK] [14 : 1897->1907)] { 
lbl232:
                                        // 1 sources

                                        var5_6.close();
                                        break block74;
lbl234:
                                        // 1 sources

                                        catch (Exception var29_21) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var4_5 != null) {
                                    ** try [egrp 8[TRYBLOCK] [15 : 1914->1924)] { 
lbl239:
                                    // 1 sources

                                    var4_5.close();
                                    break block75;
lbl241:
                                    // 1 sources

                                    catch (Exception var29_21) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (var3_3 == null) return;
                            var3_3.close();
                            return;
lbl247:
                            // 1 sources

                            catch (Exception var29_22) {
                                System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + var29_22.toString());
                            }
                            return;
lbl250:
                            // 1 sources

                            var28_16 = null;
                            ** try [egrp 6[TRYBLOCK] [16 : 1892->1939)] { 
lbl252:
                            // 1 sources

                            if (var5_6 != null) {
                                ** try [egrp 7[TRYBLOCK] [14 : 1897->1907)] { 
lbl254:
                                // 1 sources

                                var5_6.close();
                                break block76;
lbl256:
                                // 1 sources

                                catch (Exception var29_23) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var4_5 != null) {
                            ** try [egrp 8[TRYBLOCK] [15 : 1914->1924)] { 
lbl261:
                            // 1 sources

                            var4_5.close();
                            break block77;
lbl263:
                            // 1 sources

                            catch (Exception var29_23) {
                                // empty catch block
                            }
                        }
                    }
                    if (var3_3 == null) return;
                    var3_3.close();
                    return;
lbl269:
                    // 1 sources

                    catch (Exception var29_24) {
                        System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + var29_24.toString());
                    }
                    return;
lbl272:
                    // 1 sources

                    var28_18 = null;
                    try {}
                    catch (Exception var29_28) {}
                    System.out.println("Exception Occured in OraDbGrowthTest.computeMeasures() in finllay block:" + var29_28.toString());
                    return;
                    if (var5_6 != null) {
                        ** try [egrp 7[TRYBLOCK] [14 : 1897->1907)] { 
lbl279:
                        // 1 sources

                        var5_6.close();
                        break block78;
lbl281:
                        // 1 sources

                        catch (Exception var29_27) {
                            // empty catch block
                        }
                    }
                }
                if (var4_5 != null) {
                    ** try [egrp 8[TRYBLOCK] [15 : 1914->1924)] { 
lbl286:
                    // 1 sources

                    var4_5.close();
                    break block79;
lbl288:
                    // 1 sources

                    catch (Exception var29_27) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }
    }
}

