/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraDBFileStTest
extends GenericTest {
    private static final int dbMeasureCount = 2;
    private String orclSID = "";
    private String user = "";
    private String password = "";
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private ArrayList measureList;
    private ArrayList statusArrayList;
    private ArrayList modeArrayList;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraDBFileStTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.orclSID = this.getValueForParam("info");
        String string = this.getValueForParam("cloud_hosted");
        if (this.orclSID == null) {
            this.orclSID = this.getValueForParam("oracle_sid");
        }
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        this.isNewDynamicInfoTest = true;
        if (this.orclSID == null || this.orclSID.equalsIgnoreCase("NULL") || this.orclSID.equalsIgnoreCase("none")) {
            this.orclSID = "";
        }
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.password = this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.password);
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.orclSID);
        }
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.statusArrayList = new ArrayList();
        this.statusArrayList.add("OFFLINE");
        this.statusArrayList.add("SYSTEM");
        this.statusArrayList.add("ONLINE");
        this.statusArrayList.add("RECOVER");
        this.modeArrayList = new ArrayList();
        this.modeArrayList.add("DISABLED");
        this.modeArrayList.add("READ ONLY");
        this.modeArrayList.add("READ WRITE");
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object3 = "tcps";
                object2 = this.targetHost;
                object = this.portNo;
                string2 = this.orclSID;
                string = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + object3 + ")(HOST=" + (String)object2 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SERVICE_NAME=" + string2 + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.orclSID);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                int n = (Integer)((ArrayList)object3).get(0);
                object = (String)((ArrayList)object3).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string2 = (String)((ArrayList)object3).get(2);
                    if (string2.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = new Hashtable();
            object3 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.reportingName);
            if (object3 == null || ((Hashtable)object3).size() == 0) {
                return;
            }
            object2 = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.orclSID);
            if (object2 != null && ((ArrayList)object2).size() > 0) {
                object = (String)((ArrayList)object2).get(2);
                string2 = (String)((ArrayList)object2).get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string2.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        string2 = "";
        string = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string = "select file#, name,status, enabled as access_mode from v$datafile";
        if (this.isMultitenantDb) {
            if (this.isCDB) {
                if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", "OraDBfileStTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                return;
            }
            string = "select file#, name,status, enabled as access_mode from v$datafile where con_id > 0";
            object3 = this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug);
        } else {
            object3 = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug);
        }
        if (object3 == null) {
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID);
            return;
        }
        try {
            object2 = object3.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraDBFileStTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID, exception.toString());
            exception.printStackTrace();
            this.closeConn((Connection)object3);
            return;
        }
        try {
            try {
                System.out.println("[OraDBFileStTest ] Used Query is : " + string);
                object = object2.executeQuery(string);
                while (object.next()) {
                    string2 = object.getString(1).trim();
                    string3 = object.getString(2).trim();
                    string4 = object.getString(3).trim().toUpperCase();
                    string5 = object.getString(4).trim().toUpperCase();
                    this.measureList = new ArrayList();
                    int n = this.statusCheck(string4);
                    int n2 = this.access_modeCheck(string5);
                    this.measureList.add(new Double(n));
                    this.measureList.add(new Double(n2));
                    System.out.println("[OraDBFileStTest] DBF name  " + string3 + "\t Measures " + this.measureList);
                    this.addNewMeasure(string3, this.measureList);
                }
                Object var13_15 = null;
                if (object != null) {
                    this.closeRs((ResultSet)object);
                }
                if (object2 != null) {
                    this.closeStmt((Statement)object2);
                }
                if (object3 != null) {
                    this.closeConn((Connection)object3);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", " OraDBfileStTest computeMeasures() reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID, exception.toString());
                exception.printStackTrace();
                Object var13_16 = null;
                if (object != null) {
                    this.closeRs((ResultSet)object);
                }
                if (object2 != null) {
                    this.closeStmt((Statement)object2);
                }
                if (object3 != null) {
                    this.closeConn((Connection)object3);
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (object != null) {
                this.closeRs((ResultSet)object);
            }
            if (object2 != null) {
                this.closeStmt((Statement)object2);
            }
            if (object3 != null) {
                this.closeConn((Connection)object3);
            }
            throw throwable;
        }
    }

    private int statusCheck(String string) {
        int n = this.statusArrayList.indexOf(string);
        if (n == -1) {
            n = 4;
        } else if (n <= -1 || n > 3) {
            n = 4;
        }
        System.out.println("[OraDBFileStTest] Oracle DBF Status value is   :" + n);
        return n;
    }

    private int access_modeCheck(String string) {
        int n = this.modeArrayList.indexOf(string);
        if (n == -1) {
            n = 3;
        } else if (n <= -1 || n > 2) {
            n = 3;
        }
        System.out.println("[OraDBFileStTest] oracle DBF Access Mode Value is     :" + n);
        return n;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraDBFileStTest oraDBFileStTest = new OraDBFileStTest(stringArray);
        oraDBFileStTest.computeMeasures(new Hashtable());
    }
}

