/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraDBFileGrowthTest
extends GenericTest {
    public String user;
    public String passwd;
    public String oraSid;
    public String viewName;
    private static final int i_measureCount = 5;
    private static double gbConvertor = 1048576.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private int msgLogCounter = 0;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraDBFileGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.viewName = this.getValueForParam("alternate_view");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("sid");
        }
        this.isNewDynamicInfoTest = true;
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.passwd = this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.passwd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                var2_2 = "tcps";
                var3_3 = this.targetHost;
                var4_5 = this.portNo;
                var5_6 = this.oraSid;
                var6_7 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + var2_2 + ")(HOST=" + (String)var3_3 + ")(PORT=" + (String)var4_5 + "))(CONNECT_DATA=(SERVICE_NAME=" + (String)var5_6 + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", var6_7);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled != false ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug, this.reportingName);
            var2_2 = new ArrayList<E>();
            var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (var2_2 != null && var2_2.size() > 2) {
                var3_4 = (Integer)var2_2.get(0);
                var4_5 = (String)var2_2.get(1);
                if (var4_5.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (var3_4 >= 12) {
                    this.isOracle12c = true;
                    var5_6 = (String)var2_2.get(2);
                    if (var5_6.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + var2_2, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            var2_2 = new Hashtable<K, V>();
            var2_2 = this.isSSLEnabled != false ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug, this.reportingName);
            if (var2_2 == null) return;
            if (var2_2.size() == 0) {
                return;
            }
            var3_3 = (ArrayList)var2_2.get(this.reportingName);
            if (var3_3 == null) return;
            if (var3_3.size() <= 0) return;
            var4_5 = (String)var3_3.get(2);
            var5_6 = (String)var3_3.get(3);
            if (!var4_5.equalsIgnoreCase("PRIMARY") && var5_6.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        var2_2 = new ArrayList<E>();
        var3_3 = null;
        var4_5 = null;
        var5_6 = null;
        var6_8 = 0.0;
        var8_9 = 0.0;
        var10_10 = 0.0;
        var12_11 = "";
        try {
            block74: {
                var12_11 = this.viewName == null || this.viewName.equals("") != false || this.viewName.equalsIgnoreCase("NULL") != false || this.viewName.equalsIgnoreCase("none") != false ? "SELECT FILE_NAME,NVL(FILE_SIZE_MB,0) \"FILE_SIZE(MB)\",NVL(USED_SIZE_MB,0) AS \"USED_SIZE(MB)\", NVL(FREE_SIZE_MB,0) AS \"FREE_SIZE(MB)\" FROM (SELECT FILE_NAME FILE_NAME,FILE_SIZE FILE_SIZE_MB,USED_SIZE USED_SIZE_MB,(FILE_SIZE - USED_SIZE) FREE_SIZE_MB FROM (SELECT FILE_ID,FILE_NAME,SUM(MAXBYTES) FILE_SIZE,sum(bytes) used_size FROM DBA_DATA_FILES GROUP BY FILE_ID,FILE_NAME) B )order by \"USED_SIZE(MB)\" desc" : "SELECT FILE_NAME,NVL(FILE_SIZE_MB,0) \"FILE_SIZE(MB)\",NVL(USED_SIZE_MB,0) AS \"USED_SIZE(MB)\", NVL(FREE_SIZE_MB,0) AS \"FREE_SIZE(MB)\" FROM (SELECT FILE_NAME FILE_NAME,FILE_SIZE FILE_SIZE_MB,USED_SIZE USED_SIZE_MB,(FILE_SIZE - USED_SIZE) FREE_SIZE_MB FROM (SELECT FILE_ID,FILE_NAME,SUM(MAXBYTES) FILE_SIZE,sum(bytes) used_size FROM DBA_DATA_FILES GROUP BY FILE_ID,FILE_NAME) B )order by \"USED_SIZE(MB)\" desc";
                var3_3 = this.isMultitenantDb && !this.isCDB ? (this.isSSLEnabled ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug, this.sslParametersHT) : ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug)) : (this.isSSLEnabled != false ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.user, this.passwd, OraDBFileGrowthTest.debug));
                if (var3_3 != null) break block74;
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                var17_12 = null;
                ** GOTO lbl207
            }
            try {
                var4_5 = var3_3.createStatement();
            }
            catch (Exception var13_27) {
                this.logToErrorFile("Error :", "OraDBFileGrowthTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var13_27.toString());
                var13_27.printStackTrace();
                try {
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                }
                catch (Exception var14_30) {
                }
                var17_13 = null;
                try {
                    if (var5_6 != null) {
                        try {
                            var5_6.close();
                        }
                        catch (Exception var18_19) {
                            // empty catch block
                        }
                    }
                    if (var4_5 != null) {
                        try {
                            var4_5.close();
                        }
                        catch (Exception var18_19) {
                            // empty catch block
                        }
                    }
                    if (var3_3 == null) return;
                    var3_3.close();
                    return;
                }
                catch (Exception var18_20) {
                    System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + var18_20.toString());
                }
                return;
            }
            var5_6 = var4_5.executeQuery(var12_11);
            System.out.println("[OraDBFileGrowthTest]query--------->" + var12_11);
            while (var5_6.next()) {
                var13_28 = new ArrayList<Double>();
                var14_31 = var5_6.getString("FILE_NAME");
                var6_8 = var5_6.getDouble("FILE_SIZE(MB)") / OraDBFileGrowthTest.gbConvertor;
                var13_28.add(new Double(var6_8));
                var8_9 = var5_6.getDouble("USED_SIZE(MB)") / OraDBFileGrowthTest.gbConvertor;
                var13_28.add(new Double(var8_9));
                var10_10 = var5_6.getDouble("FREE_SIZE(MB)") / OraDBFileGrowthTest.gbConvertor;
                var13_28.add(new Double(var10_10));
                if (var6_8 != 0.0) {
                    var15_34 = new BigDecimal(var8_9 / var6_8 * 100.0).setScale(2, 6);
                    var13_28.add(new Double(var15_34.doubleValue()));
                } else {
                    var13_28.add(new Double(-5.0));
                }
                if (var6_8 != 0.0) {
                    var15_34 = new BigDecimal(var10_10 / var6_8 * 100.0).setScale(2, 6);
                    var13_28.add(new Double(var15_34.doubleValue()));
                } else {
                    var13_28.add(new Double(-5.0));
                }
                this.addNewMeasure(var14_31, var13_28);
            }
            var5_6.close();
            var4_5.close();
            ** GOTO lbl228
        }
        catch (Exception var13_29) {
            block67: {
                block66: {
                    this.logToErrorFile("Error :", "OraDBFileGrowthTest computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var13_29.toString());
                    System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures():" + var13_29.toString());
                    if (var5_6 != null) {
                        try {
                            var5_6.close();
                        }
                        catch (Exception var14_32) {
                            // empty catch block
                        }
                    }
                    if (var4_5 != null) {
                        try {
                            var4_5.close();
                        }
                        catch (Exception var14_33) {
                        }
                    }
                    var17_15 = null;
                    try {}
                    catch (Exception var18_24) {
                        System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + var18_24.toString());
                        return;
                    }
                    if (var5_6 != null) {
                        ** try [egrp 7[TRYBLOCK] [12 : 1682->1692)] { 
lbl168:
                        // 1 sources

                        var5_6.close();
                        break block66;
lbl170:
                        // 1 sources

                        catch (Exception var18_23) {
                            // empty catch block
                        }
                    }
                }
                if (var4_5 != null) {
                    ** try [egrp 8[TRYBLOCK] [13 : 1699->1709)] { 
lbl175:
                    // 1 sources

                    var4_5.close();
                    break block67;
lbl177:
                    // 1 sources

                    catch (Exception var18_23) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }
        {
            block73: {
                block72: {
                    block71: {
                        block70: {
                            catch (Throwable var16_35) {
                                block69: {
                                    block68: {
                                        var17_16 = null;
                                        ** try [egrp 6[TRYBLOCK] [14 : 1677->1724)] { 
lbl187:
                                        // 1 sources

                                        if (var5_6 != null) {
                                            ** try [egrp 7[TRYBLOCK] [12 : 1682->1692)] { 
lbl189:
                                            // 1 sources

                                            var5_6.close();
                                            break block68;
lbl191:
                                            // 1 sources

                                            catch (Exception var18_25) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var4_5 != null) {
                                        ** try [egrp 8[TRYBLOCK] [13 : 1699->1709)] { 
lbl196:
                                        // 1 sources

                                        var4_5.close();
                                        break block69;
lbl198:
                                        // 1 sources

                                        catch (Exception var18_25) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var3_3 == null) throw var16_35;
                                var3_3.close();
                                throw var16_35;
lbl204:
                                // 1 sources

                                catch (Exception var18_26) {
                                    System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + var18_26.toString());
                                }
                                throw var16_35;
                            }
lbl207:
                            // 1 sources

                            ** try [egrp 6[TRYBLOCK] [14 : 1677->1724)] { 
lbl208:
                            // 1 sources

                            if (var5_6 != null) {
                                ** try [egrp 7[TRYBLOCK] [12 : 1682->1692)] { 
lbl210:
                                // 1 sources

                                var5_6.close();
                                break block70;
lbl212:
                                // 1 sources

                                catch (Exception var18_17) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var4_5 != null) {
                            ** try [egrp 8[TRYBLOCK] [13 : 1699->1709)] { 
lbl217:
                            // 1 sources

                            var4_5.close();
                            break block71;
lbl219:
                            // 1 sources

                            catch (Exception var18_17) {
                                // empty catch block
                            }
                        }
                    }
                    if (var3_3 == null) return;
                    var3_3.close();
                    return;
lbl225:
                    // 1 sources

                    catch (Exception var18_18) {
                        System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + var18_18.toString());
                    }
                    return;
lbl228:
                    // 1 sources

                    var17_14 = null;
                    try {}
                    catch (Exception var18_22) {}
                    System.out.println("Exception Occured in OraDBFileGrowthTest.computeMeasures() in finllay block:" + var18_22.toString());
                    return;
                    if (var5_6 != null) {
                        ** try [egrp 7[TRYBLOCK] [12 : 1682->1692)] { 
lbl235:
                        // 1 sources

                        var5_6.close();
                        break block72;
lbl237:
                        // 1 sources

                        catch (Exception var18_21) {
                            // empty catch block
                        }
                    }
                }
                if (var4_5 != null) {
                    ** try [egrp 8[TRYBLOCK] [13 : 1699->1709)] { 
lbl242:
                    // 1 sources

                    var4_5.close();
                    break block73;
lbl244:
                    // 1 sources

                    catch (Exception var18_21) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }
    }
}

