/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraArchiveTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    private String queryStmt;
    private double defValue = -1.0;
    private double version = 11.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public static void main(String[] stringArray) {
        OraArchiveTest oraArchiveTest = new OraArchiveTest(stringArray);
        oraArchiveTest.computeMeasures(new Hashtable());
    }

    public OraArchiveTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        this.userPasswd = this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.userPasswd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    public double findVersion() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "select version from v$instance";
        double d = 0.0;
        try {
            connection = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return 0.0;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraArchiveTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                string2 = string2.substring(0, string2.indexOf("."));
                d = Double.parseDouble(string2);
            }
            resultSet.close();
            statement.close();
            connection.close();
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg = new String("Exception while executing  OraArchiveTest for target: " + this.targetHost);
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return d;
        }
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        block76: {
            block75: {
                block69: {
                    block74: {
                        block65: {
                            block66: {
                                if (this.isSSLEnabled) {
                                    this.printOut("SSL enabled");
                                    if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                                        var2_2 = "tcps";
                                        var3_3 = this.targetHost;
                                        var4_5 = this.portNo;
                                        var5_6 = this.oraSid;
                                        var6_7 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + var2_2 + ")(HOST=" + (String)var3_3 + ")(PORT=" + (String)var4_5 + "))(CONNECT_DATA=(SERVICE_NAME=" + (String)var5_6 + ")))";
                                        this.sslParametersHT.put("isSSLEnabled", "True");
                                        this.sslParametersHT.put("urlWithSSL", var6_7);
                                        this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                                        this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                                        this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                                        this.sslParametersHT.put("egReportName", this.reportingName);
                                        this.sslParametersHT.put("eGTestName", this.entity);
                                    } else {
                                        this.printOut("Please provide valid key store details");
                                    }
                                } else {
                                    this.printOut("SSL is not enabled");
                                }
                                if (this.isInitCheckNeeded) {
                                    this.isDataguardEnabled = this.isSSLEnabled != false ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraArchiveTest.debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraArchiveTest.debug, this.reportingName);
                                    var2_2 = new ArrayList<E>();
                                    var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                                    if (var2_2 != null && var2_2.size() > 2) {
                                        var3_4 = (Integer)var2_2.get(0);
                                        var4_5 = (String)var2_2.get(1);
                                        if (var4_5.equalsIgnoreCase("true")) {
                                            this.isCDB = true;
                                        }
                                        if (var3_4 >= 12) {
                                            this.isOracle12c = true;
                                            var5_6 = (String)var2_2.get(2);
                                            if (var5_6.equalsIgnoreCase("true")) {
                                                this.isMultitenantDb = true;
                                            }
                                        }
                                        this.version = var3_4;
                                        this.isInitCheckNeeded = false;
                                    } else {
                                        if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                                            this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + var2_2, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                            this.msgLogCounter = 0;
                                        }
                                        ++this.msgLogCounter;
                                    }
                                }
                                if (this.isDataguardEnabled) {
                                    var2_2 = new Hashtable<K, V>();
                                    var2_2 = this.isSSLEnabled != false ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraArchiveTest.debug, this.reportingName) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraArchiveTest.debug, this.reportingName);
                                    if (var2_2 == null) return;
                                    if (var2_2.size() == 0) {
                                        return;
                                    }
                                    var3_3 = (ArrayList)var2_2.get(this.reportingName + ":" + this.oraSid);
                                    if (var3_3 == null) return;
                                    if (var3_3.size() <= 0) return;
                                    var4_5 = (String)var3_3.get(2);
                                    var5_6 = (String)var3_3.get(3);
                                    if (!var4_5.equalsIgnoreCase("PRIMARY") && var5_6.equalsIgnoreCase("MOUNTED")) {
                                        return;
                                    }
                                }
                                var3_3 = null;
                                var4_5 = null;
                                if (this.isMultitenantDb && !this.isCDB) {
                                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                                        this.logToErrorFile("INFO", "OraArchiveTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                        this.msgLogCounter = 0;
                                    }
                                    ++this.msgLogCounter;
                                    return;
                                }
                                System.out.println("[OraArcheiveTest]version=====>" + this.version);
                                this.queryStmt = "SELECT DECODE(log_mode,'ARCHIVELOG',100,'NOARCHIVELOG',0,0) AS ARCHIVE_LOG_ON FROM V$database";
                                var5_6 = null;
                                var6_7 = null;
                                try {
                                    try {
                                        var5_6 = this.isSSLEnabled != false ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraArchiveTest.debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, OraArchiveTest.debug);
                                        if (var5_6 == null) {
                                            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                            var11_8 = null;
                                            if (var4_5 == null) break block65;
                                            break block66;
                                        }
                                        try {
                                            var3_3 = var5_6.createStatement();
                                        }
                                        catch (Exception var7_18) {
                                            this.logToErrorFile("Error :", "OraArchiveTest Failed to Create Statement reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var7_18.toString());
                                            var7_18.printStackTrace();
                                            if (var5_6 != null) {
                                                try {
                                                    var5_6.close();
                                                }
                                                catch (Exception var8_21) {
                                                }
                                            }
                                            var11_9 = null;
                                            if (var4_5 != null) {
                                                try {
                                                    var4_5.close();
                                                }
                                                catch (Exception var12_14) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var3_3 != null) {
                                                try {
                                                    var3_3.close();
                                                }
                                                catch (Exception var12_14) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var5_6 == null) return;
                                            try {
                                                var5_6.close();
                                                return;
                                            }
                                            catch (Exception var12_14) {
                                                // empty catch block
                                            }
                                            return;
                                        }
                                        var4_5 = var3_3.executeQuery(this.queryStmt);
                                        if (var4_5.next()) {
                                            this.defValue = var7_19 = var4_5.getDouble(1);
                                            var9_25 = new ArrayList<Double>();
                                            var9_25.add(new Double(this.defValue));
                                            this.addNewMeasure(var9_25);
                                        }
                                        var4_5.close();
                                        var3_3.close();
                                        var5_6.close();
                                        break block69;
                                    }
                                    catch (Exception var7_20) {
                                        block71: {
                                            block70: {
                                                var7_20.printStackTrace();
                                                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var7_20.toString());
                                                if (var4_5 != null) {
                                                    try {
                                                        var4_5.close();
                                                    }
                                                    catch (Exception var8_22) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (var3_3 != null) {
                                                    try {
                                                        var3_3.close();
                                                    }
                                                    catch (Exception var8_23) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (var5_6 != null) {
                                                    try {
                                                        var5_6.close();
                                                    }
                                                    catch (Exception var8_24) {
                                                        // empty catch block
                                                    }
                                                }
                                                this.errorMsg = new String("Exception while executing OraArchiveTest for target: " + this.targetHost);
                                                var11_11 = null;
                                                if (var4_5 != null) {
                                                    ** try [egrp 7[TRYBLOCK] [13 : 1488->1498)] { 
lbl154:
                                                    // 1 sources

                                                    var4_5.close();
                                                    break block70;
lbl156:
                                                    // 1 sources

                                                    catch (Exception var12_16) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (var3_3 != null) {
                                                ** try [egrp 8[TRYBLOCK] [14 : 1504->1513)] { 
lbl161:
                                                // 1 sources

                                                var3_3.close();
                                                break block71;
lbl163:
                                                // 1 sources

                                                catch (Exception var12_16) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var5_6 == null) return;
                                        try {}
                                        catch (Exception var12_16) {
                                            return;
                                        }
                                        var5_6.close();
                                        return;
                                    }
                                }
                                catch (Throwable var10_26) {
                                    block73: {
                                        block72: {
                                            var11_12 = null;
                                            if (var4_5 != null) {
                                                ** try [egrp 7[TRYBLOCK] [13 : 1488->1498)] { 
lbl177:
                                                // 1 sources

                                                var4_5.close();
                                                break block72;
lbl179:
                                                // 1 sources

                                                catch (Exception var12_17) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var3_3 != null) {
                                            ** try [egrp 8[TRYBLOCK] [14 : 1504->1513)] { 
lbl184:
                                            // 1 sources

                                            var3_3.close();
                                            break block73;
lbl186:
                                            // 1 sources

                                            catch (Exception var12_17) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var5_6 == null) throw var10_26;
                                    ** try [egrp 9[TRYBLOCK] [15 : 1520->1530)] { 
lbl191:
                                    // 1 sources

                                    var5_6.close();
                                    throw var10_26;
lbl193:
                                    // 1 sources

                                    catch (Exception var12_17) {
                                        // empty catch block
                                    }
                                    throw var10_26;
                                }
                            }
                            ** try [egrp 7[TRYBLOCK] [13 : 1488->1498)] { 
lbl198:
                            // 1 sources

                            var4_5.close();
                            break block65;
lbl200:
                            // 1 sources

                            catch (Exception var12_13) {
                                // empty catch block
                            }
                        }
                        if (var3_3 != null) {
                            ** try [egrp 8[TRYBLOCK] [14 : 1504->1513)] { 
lbl205:
                            // 1 sources

                            var3_3.close();
                            break block74;
lbl207:
                            // 1 sources

                            catch (Exception var12_13) {
                                // empty catch block
                            }
                        }
                    }
                    if (var5_6 == null) return;
                    ** try [egrp 9[TRYBLOCK] [15 : 1520->1530)] { 
lbl212:
                    // 1 sources

                    var5_6.close();
                    return;
lbl214:
                    // 1 sources

                    catch (Exception var12_13) {
                        // empty catch block
                    }
                    return;
                }
                var11_10 = null;
                if (var4_5 != null) {
                    ** try [egrp 7[TRYBLOCK] [13 : 1488->1498)] { 
lbl221:
                    // 1 sources

                    var4_5.close();
                    break block75;
lbl223:
                    // 1 sources

                    catch (Exception var12_15) {
                        // empty catch block
                    }
                }
            }
            if (var3_3 != null) {
                ** try [egrp 8[TRYBLOCK] [14 : 1504->1513)] { 
lbl228:
                // 1 sources

                var3_3.close();
                break block76;
lbl230:
                // 1 sources

                catch (Exception var12_15) {
                    // empty catch block
                }
            }
        }
        if (var5_6 == null) return;
        try {}
        catch (Exception var12_15) {}
        var5_6.close();
        return;
    }
}

