/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraArchiveAreaTest
extends GenericTest {
    private String userName = "";
    private String userPasswd = "";
    private String oraSid = "";
    private String archivefilepath = "";
    private String dumpfilepath = "";
    public String logFilePath = "";
    private double prev_archUnix = -5.0;
    private double prev_archWin = -5.0;
    private Hashtable prevHash = new Hashtable();
    private int checkCt = 0;
    private static int maxCheckCt = 24;
    private static final int i_measureCount = 6;
    public String archiveQry = "select name, value from v$parameter where name like 'log_archive_dest%' and name not like 'log_archive_dest_state%'";
    public String dumpAreaQry = "select name, value from v$parameter where name in ('background_dump_dest','user_dump_dest','core_dump_dest','max_dump_file_size','db_block_size')";
    private boolean isFirstTime = true;
    private String maxDumpFileSize = "";
    private double dbBlockSize = 0.0;
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private boolean isArchMsgLogged = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private int archiveLocationCounter = 0;
    private int dumpLocationCounter = 0;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraArchiveAreaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.archivefilepath = this.getValueForParam("archivefilepath");
        this.dumpfilepath = this.getValueForParam("dumpfilepath");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        this.setSid(this.oraSid);
        System.out.println("File path : " + this.archivefilepath);
        this.isNewDynamicInfoTest = true;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        String string2;
        Object object2;
        Object object3;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object3 = "tcps";
                object2 = this.targetHost;
                string2 = this.portNo;
                string = this.oraSid;
                object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + object3 + ")(HOST=" + (String)object2 + ")(PORT=" + string2 + "))(CONNECT_DATA=(SERVICE_NAME=" + string + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", object);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                int n = (Integer)((ArrayList)object3).get(0);
                string2 = (String)((ArrayList)object3).get(1);
                if (string2.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object3).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = new Hashtable();
            object3 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object3 == null || ((Hashtable)object3).size() == 0) {
                return;
            }
            object2 = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 0) {
                string2 = (String)((ArrayList)object2).get(2);
                string = (String)((ArrayList)object2).get(3);
                if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        System.out.println("Calling " + this.entity + " OraArchiveAreaTest computeMeasures ..........");
        if (this.isMultitenantDb && !this.isCDB) {
            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                this.logToErrorFile("INFO", "OraArchiveAreaTest doesnot run for PDB : ", this.targetHost);
                this.msgLogCounter = 0;
            }
            ++this.msgLogCounter;
            return;
        }
        try {
            if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                if (this.archivefilepath.equalsIgnoreCase("none") && this.userName != null && !this.userName.equalsIgnoreCase("none")) {
                    System.out.println("Query for path : " + this.archiveQry);
                    System.out.println("archiveLocationCounter: " + this.archiveLocationCounter);
                    if (this.archiveLocationCounter == 0 || this.archiveLocationCounter > 2) {
                        this.logFilePath = this.getArea(this.archiveQry);
                        this.archiveLocationCounter = 0;
                    }
                    ++this.archiveLocationCounter;
                } else {
                    this.logFilePath = this.archivefilepath;
                    System.out.println("File Path  is executed======>" + this.logFilePath);
                    this.isFirstTime = false;
                }
            }
            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                if (this.dumpfilepath.equalsIgnoreCase("none") && this.userName != null && !this.userName.equalsIgnoreCase("none")) {
                    System.out.println("Query for path : " + this.dumpAreaQry);
                    if (this.dumpLocationCounter == 0 || this.dumpLocationCounter > 2) {
                        this.logFilePath = this.getArea(this.dumpAreaQry);
                        this.dumpLocationCounter = 0;
                    }
                    ++this.dumpLocationCounter;
                } else {
                    this.logFilePath = this.dumpfilepath;
                    System.out.println("File Path  is executed======>" + this.logFilePath);
                    this.isFirstTime = false;
                }
            }
            object3 = "";
            long l = 0L;
            if (!this.meAgentless) {
                string = System.getProperty("os.name");
                System.out.println("Calling " + this.entity + "AgentOS .........." + string);
                if (string.toLowerCase().startsWith("win")) {
                    System.out.println("[" + this.entity + "]   logFilePath ===> \t" + this.logFilePath);
                    if (this.logFilePath == null) {
                        if (!this.isArchMsgLogged) {
                            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                this.logToErrorFile("INFO", "OraDumpAreaTest - Dump destination is not configured : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            }
                            if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                                this.logToErrorFile("INFO", "OraArchiveAreaTest - Archive destination  is not configured : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            }
                            this.isArchMsgLogged = true;
                        }
                        object = new ArrayList();
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        this.addNewMeasure((ArrayList)object);
                        return;
                    }
                    if (this.logFilePath.indexOf(",") > -1) {
                        object = new StringTokenizer(this.logFilePath, ",");
                        int n = ((StringTokenizer)object).countTokens();
                        System.out.println(" Count token  : " + n);
                        if (n > 0) {
                            for (int i = 0; i < n; ++i) {
                                Object object4;
                                File file;
                                String string3 = ((StringTokenizer)object).nextToken().trim();
                                boolean bl = false;
                                System.out.println("[" + this.entity + "]   logFileName ===> \t" + string3);
                                if (string3 != null && string3.length() > 0 && string3.startsWith("+")) {
                                    bl = true;
                                }
                                if ((file = new File(string3)).exists()) {
                                    ArrayList arrayList;
                                    l = this.getArchiveLogFileSize(file);
                                    object3 = string3.substring(0, string3.indexOf(":"));
                                    object4 = "cmd /c cscript.exe " + EgMainAgent.strCScriptOptionalParamters + " " + EgInstallInfo.getInstallDir() + "/lib/eg_diskspace.vbs";
                                    ArrayList arrayList2 = new ArrayList();
                                    EgUtilities egUtilities = EgUtilities.createInstance();
                                    arrayList2 = egUtilities.getExecOutputLines((String)object4);
                                    System.out.println("[" + this.entity + "] ====>   a \t" + arrayList2);
                                    if (debug) {
                                        System.out.println("[" + this.entity + "] ====>   a \t" + arrayList2);
                                    }
                                    if (arrayList2 == null || arrayList2.size() < 2) {
                                        this.errorMsg = new String("[" + this.entity + "] could not be executed");
                                    }
                                    if ((arrayList = (ArrayList)arrayList2.get(0)) == null) {
                                        this.errorMsg = new String("[" + this.entity + "] could not be executed");
                                    }
                                    this.processWindowsOutput(arrayList, (String)object3, string3, l);
                                    continue;
                                }
                                if (bl) {
                                    if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                        this.logToErrorFile("INFO  :", this.entity, " Dump destination " + string3 + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                    }
                                    if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                                        this.logToErrorFile("INFO  :", this.entity, " Archive destination " + string3 + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                    }
                                }
                                object4 = new ArrayList<Double>();
                                ((ArrayList)object4).add(new Double(-5.0));
                                ((ArrayList)object4).add(new Double(-5.0));
                                ((ArrayList)object4).add(new Double(-5.0));
                                ((ArrayList)object4).add(new Double(-5.0));
                                ((ArrayList)object4).add(new Double(-5.0));
                                ((ArrayList)object4).add(new Double(-5.0));
                                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][file does not exist]-MEASURELIST==>" + object4);
                                if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                    ((ArrayList)object4).add(new Double(-5.0));
                                    ((ArrayList)object4).add(new Double(-5.0));
                                    ((ArrayList)object4).add(new Double(-5.0));
                                }
                                this.addNewMeasure(string3, (ArrayList)object4);
                                System.out.println("I block ");
                                System.out.println("LogFile Name======>" + string3);
                            }
                        }
                    } else {
                        object = new File(this.logFilePath);
                        boolean bl = false;
                        if (this.logFilePath != null && this.logFilePath.length() > 0 && this.logFilePath.startsWith("+")) {
                            bl = true;
                        }
                        System.out.println(" File  : " + object);
                        if (((File)object).exists()) {
                            System.out.println("One log file only");
                            l = this.getArchiveLogFileSize((File)object);
                            System.out.println("logFileSize   " + l);
                            object3 = this.logFilePath.substring(0, this.logFilePath.indexOf(":"));
                            System.out.println("logFileFrive        " + (String)object3);
                            String string4 = "cmd /c cscript.exe " + EgMainAgent.strCScriptOptionalParamters + " " + EgInstallInfo.getInstallDir() + "/lib/eg_diskspace.vbs";
                            ArrayList arrayList = new ArrayList();
                            EgUtilities egUtilities = EgUtilities.createInstance();
                            arrayList = egUtilities.getExecOutputLines(string4);
                            System.out.println(" Array a : " + arrayList);
                            if (arrayList == null || arrayList.size() < 2) {
                                this.errorMsg = new String("[" + this.entity + "] could not be executed");
                            }
                            ArrayList arrayList3 = (ArrayList)arrayList.get(0);
                            System.out.println(" Array out : " + arrayList3);
                            if (arrayList3 == null) {
                                this.errorMsg = new String("[" + this.entity + "] could not be executed");
                            }
                            this.processWindowsOutput(arrayList3, (String)object3, this.logFilePath, l);
                        } else {
                            if (bl) {
                                if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                    this.logToErrorFile("INFO  :", this.entity, " Dump destination " + this.logFilePath + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                }
                                if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                                    this.logToErrorFile("INFO  :", this.entity, " Archive destination " + this.logFilePath + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                }
                            }
                            ArrayList<Double> arrayList = new ArrayList<Double>();
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][file does not exist]-MEASURELIST==>" + arrayList);
                            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                arrayList.add(new Double(-5.0));
                                arrayList.add(new Double(-5.0));
                                arrayList.add(new Double(-5.0));
                            }
                            this.addNewMeasure(this.logFilePath, arrayList);
                        }
                    }
                } else {
                    System.out.println("Unix else part " + this.entity + "logFilePath .........." + this.logFilePath);
                    if (this.logFilePath == null || this.logFilePath.equalsIgnoreCase("")) {
                        if (!this.isArchMsgLogged) {
                            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                this.logToErrorFile("INFO", "OraDumpAreaTest - Dump destination is not configured : ", this.targetHost);
                            }
                            if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                                this.logToErrorFile("INFO", "OraArchiveAreaTest - Archive destination  is not configured : ", this.targetHost);
                            }
                            this.isArchMsgLogged = true;
                        }
                        object = new ArrayList<Double>();
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        ((ArrayList)object).add(new Double(-5.0));
                        this.addNewMeasure((ArrayList)object);
                        return;
                    }
                    if (this.logFilePath.indexOf(",") > -1) {
                        object = new StringTokenizer(this.logFilePath, ",");
                        int n = ((StringTokenizer)object).countTokens();
                        if (n > 0) {
                            for (int i = 0; i < n; ++i) {
                                Object object5;
                                File file;
                                String string5 = ((StringTokenizer)object).nextToken();
                                boolean bl = false;
                                System.out.println("[" + this.entity + "]   logFileName ===> \t" + string5);
                                if (string5 != null && string5.length() > 0 && string5.startsWith("+")) {
                                    bl = true;
                                }
                                if ((file = new File(string5)).exists()) {
                                    l = this.getArchiveLogFileSize(file);
                                    object5 = new StringTokenizer(string5, "/");
                                    object3 = ((StringTokenizer)object5).nextToken();
                                    System.out.println("Test==>   \t" + this.entity + "  logFileDrive   \t" + (String)object3);
                                    System.out.println("Test==>   \t" + this.entity + "  logFileName   \t" + string5);
                                    System.out.println("Test==>   \t" + this.entity + "  logFileSize   \t" + l);
                                    String string6 = new String("df -k " + string5);
                                    ArrayList arrayList = new ArrayList();
                                    EgUtilities egUtilities = EgUtilities.createInstance();
                                    arrayList = egUtilities.getExecOutputLines(string6);
                                    if (arrayList == null || arrayList.size() < 2) {
                                        this.errorMsg = new String("[unix][" + this.entity + "] could not be executed");
                                    }
                                    ArrayList arrayList4 = (ArrayList)arrayList.get(0);
                                    System.out.println("Test==>" + this.entity + "   out       \t" + arrayList4);
                                    if (arrayList4 == null) {
                                        this.errorMsg = new String("[unix][" + this.entity + "] could not be executed");
                                    }
                                    ArrayList arrayList5 = null;
                                    arrayList5 = string.toLowerCase().startsWith("hp") ? this.getActualResultsOnHpux(arrayList4) : this.getActualResultsOnUnix(arrayList4);
                                    this.processUnixOutput(arrayList5, (String)object3, string5, l);
                                    continue;
                                }
                                System.out.println("Test===> " + this.entity + "  multi file path doesnot exist   ");
                                if (bl) {
                                    if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                        this.logToErrorFile("INFO  :", this.entity, " Dump destination " + string5 + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                    }
                                    if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                                        this.logToErrorFile("INFO  :", this.entity, " Archive destination " + string5 + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                    }
                                }
                                object5 = new ArrayList();
                                ((ArrayList)object5).add(new Double(-5.0));
                                ((ArrayList)object5).add(new Double(-5.0));
                                ((ArrayList)object5).add(new Double(-5.0));
                                ((ArrayList)object5).add(new Double(-5.0));
                                ((ArrayList)object5).add(new Double(-5.0));
                                ((ArrayList)object5).add(new Double(-5.0));
                                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][file does not exist[processUnixOutput()]]-MEASURELIST==>" + object5);
                                if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                    ((ArrayList)object5).add(new Double(-5.0));
                                    ((ArrayList)object5).add(new Double(-5.0));
                                    ((ArrayList)object5).add(new Double(-5.0));
                                }
                                this.addNewMeasure(string5, (ArrayList)object5);
                            }
                        }
                    } else {
                        File file;
                        System.out.println("Test===> " + this.entity + "  single file path The file exist   ");
                        boolean bl = false;
                        if (this.logFilePath != null && this.logFilePath.length() > 0 && this.logFilePath.startsWith("+")) {
                            bl = true;
                        }
                        if ((file = new File(this.logFilePath)).exists()) {
                            ArrayList arrayList;
                            l = this.getArchiveLogFileSize(file);
                            StringTokenizer stringTokenizer = new StringTokenizer(this.logFilePath, "/");
                            object3 = stringTokenizer.nextToken();
                            String string7 = new String("df -k " + this.logFilePath);
                            ArrayList arrayList6 = new ArrayList();
                            EgUtilities egUtilities = EgUtilities.createInstance();
                            arrayList6 = egUtilities.getExecOutputLines(string7);
                            if (arrayList6 == null || arrayList6.size() < 2) {
                                this.errorMsg = new String("[unix][" + this.entity + "] could not be executed");
                            }
                            if ((arrayList = (ArrayList)arrayList6.get(0)) == null) {
                                this.errorMsg = new String("[unix][" + this.entity + "] could not be executed");
                            }
                            ArrayList arrayList7 = null;
                            arrayList7 = string.toLowerCase().startsWith("hp") ? this.getActualResultsOnHpux(arrayList) : this.getActualResultsOnUnix(arrayList);
                            this.processUnixOutput(arrayList7, (String)object3, this.logFilePath, l);
                        } else {
                            if (bl && bl) {
                                if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                    this.logToErrorFile("INFO  :", this.entity, " Dump destination " + this.logFilePath + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                }
                                if ("OraArchiveAreaTest".equalsIgnoreCase(this.entity)) {
                                    this.logToErrorFile("INFO  :", this.entity, " Archive destination " + this.logFilePath + " is configured in ASM check the Oracle Asm Diskspace test for the space utilization measures  targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                                }
                            }
                            System.out.println("Test===> " + this.entity + "  single file path The file doesnot exist   ");
                            ArrayList<Double> arrayList = new ArrayList<Double>();
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][single path - file does not exist]-MEASURELIST==>" + arrayList);
                            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                                arrayList.add(new Double(-5.0));
                                arrayList.add(new Double(-5.0));
                                arrayList.add(new Double(-5.0));
                            }
                            this.addNewMeasure(this.logFilePath, arrayList);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception Occured in [" + ((Object)((Object)this)).getClass().getName() + "].computeMeasures():" + exception.toString());
            exception.printStackTrace();
        }
    }

    private long getArchiveLogFileSize(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] != null && fileArray[i].isFile()) {
                    long l2 = fileArray[i].length();
                    l += l2;
                    continue;
                }
                if (fileArray[i] == null || !fileArray[i].isDirectory()) continue;
                this.getArchiveLogFileSize(fileArray[i]);
            }
        }
        return l;
    }

    private void processWindowsOutput(ArrayList arrayList, String string, String string2, long l) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Serializable serializable;
            String string3 = (String)arrayList.get(i);
            System.out.println("ProcessWindowsOutput Line output is " + string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
            if (stringTokenizer.countTokens() < 5) continue;
            String string4 = stringTokenizer.nextToken().trim();
            String string5 = stringTokenizer.nextToken().trim();
            String string6 = stringTokenizer.nextToken().trim();
            String string7 = stringTokenizer.nextToken().trim();
            String string8 = stringTokenizer.nextToken().trim();
            System.out.println("Drive " + string4);
            System.out.println("Total " + string5);
            System.out.println("Freee " + string6);
            System.out.println("Used " + string7);
            if (!string.equalsIgnoreCase(string4)) continue;
            double d4 = -5.0;
            double d5 = -5.0;
            double d6 = -5.0;
            double d7 = -5.0;
            d4 = Double.parseDouble(string5);
            System.out.println("total Space------------>" + d4);
            d5 = Double.parseDouble(string6);
            System.out.println("freeSpace------------>" + d5);
            d6 = Double.parseDouble(string7);
            System.out.println("usedSpace------------>" + d6);
            d7 = d4 <= 0.0 ? -5.0 : (d4 < 0.0 && d6 < 0.0 ? -5.0 : d6 * 100.0 / d4);
            System.out.println("pctUsed------------>" + d7);
            if (d4 < 0.0) {
                d4 = -5.0;
            }
            if (d5 < 0.0) {
                d5 = -5.0;
            }
            if (d6 < 0.0) {
                d6 = -5.0;
            }
            d = (double)l / 1048576.0;
            System.out.println("totalArchiveArea------------>" + d);
            d2 = d < 0.0 && d6 < 0.0 ? -5.0 : d / d6 * 100.0;
            System.out.println("archiveAreaUsedPct------------>" + d2);
            d3 = d4 <= 0.0 || d5 < 0.0 ? -5.0 : d5 / d4 * 100.0;
            System.out.println("availablePct------------>" + d3);
            double d8 = -5.0;
            System.out.println("[" + this.entity + "]  arch_growth    per measure period \t" + d8);
            System.out.println("[" + this.entity + "]  totalArchiveArea  \t" + d);
            System.out.println("[" + this.entity + "]  prev_archWin\t \t" + this.prev_archWin);
            this.prev_archWin = -1.0;
            if (this.prevHash != null && this.prevHash.containsKey(string2) && (serializable = (Double)this.prevHash.get(string2)) != null) {
                this.prev_archWin = (Double)serializable;
            }
            d8 = (d - this.prev_archWin) / this.timeSinceLastTest;
            if (this.prev_archWin < 0.0 || this.timeSinceLastTest < 0.0) {
                d8 = -5.0;
            }
            this.prevHash.put(string2, new Double(d));
            serializable = new ArrayList();
            ((ArrayList)serializable).add(new Double(d));
            ((ArrayList)serializable).add(new Double(d6));
            ((ArrayList)serializable).add(new Double(d2));
            ((ArrayList)serializable).add(new Double(d5));
            ((ArrayList)serializable).add(new Double(d3));
            ((ArrayList)serializable).add(new Double(d8));
            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                if ("UNLIMITED".equalsIgnoreCase(this.maxDumpFileSize)) {
                    ((ArrayList)serializable).add(new Double(-5.0));
                    ((ArrayList)serializable).add(new Double(-5.0));
                    ((ArrayList)serializable).add(new Double(-5.0));
                } else {
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    block26: {
                        d12 = 0.0;
                        d11 = 0.0;
                        d10 = 0.0;
                        d9 = 0.0;
                        try {
                            System.out.println("dumpfilepath = " + this.dumpfilepath);
                            System.out.println("userName = " + this.userName);
                            if (!this.dumpfilepath.equalsIgnoreCase("none") && this.userName != null && this.userName.equalsIgnoreCase("none")) {
                                System.out.println("Log file path inside" + this.logFilePath);
                                d12 = -5.0;
                            } else {
                                System.out.println("Enter the block inside ---------------- Murugan");
                                System.out.println("MaxDunpFileSize -------" + this.maxDumpFileSize);
                                d12 = Double.parseDouble(this.maxDumpFileSize);
                                System.out.println("availDumpArea------------>" + d12);
                                d12 = d12 * this.dbBlockSize / 1048576.0;
                                System.out.println("availDumpArea111111------------>" + d12);
                                System.out.println("Enter the block inside end of block ");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string9;
                            int n;
                            if (this.maxDumpFileSize.indexOf("M") != -1 || this.maxDumpFileSize.indexOf("m") != -1) {
                                n = 0;
                                n = this.maxDumpFileSize.indexOf("M") != -1 ? this.maxDumpFileSize.indexOf("M") : this.maxDumpFileSize.indexOf("m");
                                string9 = "";
                                if (this.maxDumpFileSize != null) {
                                    string9 = this.maxDumpFileSize.substring(0, n);
                                }
                                try {
                                    d12 = Double.parseDouble(string9);
                                    System.out.println("availDumpArea-MMMMMMMM ----------->" + d12);
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    numberFormatException2.printStackTrace();
                                }
                            }
                            if (this.maxDumpFileSize.indexOf("K") == -1 && this.maxDumpFileSize.indexOf("k") == -1) break block26;
                            n = 0;
                            n = this.maxDumpFileSize.indexOf("K") != -1 ? this.maxDumpFileSize.indexOf("K") : this.maxDumpFileSize.indexOf("k");
                            string9 = "";
                            if (this.maxDumpFileSize != null) {
                                string9 = this.maxDumpFileSize.substring(0, n);
                            }
                            try {
                                d12 = Double.parseDouble(string9);
                                System.out.println("availDumpArea   KKKKKKK------------>" + d12);
                            }
                            catch (NumberFormatException numberFormatException3) {
                                numberFormatException3.printStackTrace();
                            }
                            System.out.println("availDumpArea------------>" + (d12 /= 1024.0));
                        }
                    }
                    System.out.println("********* My Calculation part *****************");
                    System.out.println("-----------------------------------------------");
                    System.out.println(" Used Dump Prcnt Calculation part:");
                    System.out.println("totalArchiveArea=====>" + d);
                    System.out.println("availDumpArea=====>" + d12);
                    if (d12 > 0.0) {
                        d9 = d / d12 * 100.0;
                        System.out.println("usedDumpPrcnt=====>" + d9);
                    }
                    System.out.println("Free dump space calculation");
                    System.out.println("availDumpArea=====>" + d12);
                    System.out.println("totalArchiveArea=====>" + d);
                    if (d12 > 0.0) {
                        d11 = d12 - d;
                        System.out.println("freeDumpSpace=====>" + d11);
                    }
                    System.out.println("freeDumpPrcnt Calculation ");
                    System.out.println("freeDumpSpace=====>" + d11);
                    System.out.println("availDumpArea=====>" + d12);
                    if (d12 > 0.0) {
                        d10 = d11 / d12 * 100.0;
                        System.out.println("freeDumpPrcnt=====>" + d10);
                    }
                    if (d12 <= 0.0) {
                        ((ArrayList)serializable).add(new Double(-5.0));
                        ((ArrayList)serializable).add(new Double(-5.0));
                        ((ArrayList)serializable).add(new Double(-5.0));
                    } else {
                        ((ArrayList)serializable).add(new Double(d12));
                        ((ArrayList)serializable).add(new Double(d9));
                        ((ArrayList)serializable).add(new Double(d10));
                    }
                }
            }
            System.out.println("LogFileName : " + string2 + " MeasureList :  " + serializable);
            this.addNewMeasure(string2, (ArrayList)serializable);
        }
    }

    public void processUnixOutput(ArrayList arrayList, String string, String string2, long l) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            String string3;
            String string4 = (String)arrayList.get(i);
            if (string4 == null) continue;
            Object var17_12 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "#");
            if (stringTokenizer.countTokens() < 5 || (string3 = stringTokenizer.nextToken()).indexOf(string) <= -1 && string3.indexOf("/") <= -1) continue;
            double d5 = -1.0;
            try {
                d5 = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d6 = -1.0;
            try {
                d6 = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d7 = -1.0;
            try {
                d7 = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d8 = -1.0;
            try {
                d8 = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            d4 = d5 <= 0.0 ? -5.0 : (d5 < 0.0 && d6 < 0.0 ? -5.0 : d6 * 100.0 / d5);
            d = (double)l / 1048576.0;
            d2 = d < 0.0 && d6 < 0.0 ? -5.0 : d / d6 * 100.0;
            if (d < 0.0 && d7 < 0.0) {
                d2 = -5.0;
            } else {
                d3 = d7 / d5 * 100.0;
            }
            double d9 = -5.0;
            this.prev_archUnix = -1.0;
            if (this.prevHash != null && this.prevHash.containsKey(string2) && (serializable = (Double)this.prevHash.get(string2)) != null) {
                this.prev_archUnix = (Double)serializable;
            }
            d9 = (d - this.prev_archUnix) / this.timeSinceLastTest;
            System.out.println("Test==> " + this.entity + "    totalArchiveArea     \t" + d);
            System.out.println("Test==> " + this.entity + "    prev_archUnix     \t" + this.prev_archUnix);
            System.out.println("Test==> " + this.entity + "    arch_growth     \t" + d9);
            if (this.prev_archUnix < 0.0 || this.timeSinceLastTest < 0.0) {
                d9 = -5.0;
            }
            this.prevHash.put(string2, new Double(d));
            serializable = new ArrayList();
            ((ArrayList)serializable).add(new Double(d));
            ((ArrayList)serializable).add(new Double(d6));
            ((ArrayList)serializable).add(new Double(d2));
            ((ArrayList)serializable).add(new Double(d7));
            ((ArrayList)serializable).add(new Double(d3));
            ((ArrayList)serializable).add(new Double(d9));
            if ("OraDumpAreaTest".equalsIgnoreCase(this.entity)) {
                if ("UNLIMITED".equalsIgnoreCase(this.maxDumpFileSize)) {
                    ((ArrayList)serializable).add(new Double(-5.0));
                    ((ArrayList)serializable).add(new Double(-5.0));
                    ((ArrayList)serializable).add(new Double(-5.0));
                } else {
                    double d10;
                    block25: {
                        d10 = 0.0;
                        try {
                            d10 = Double.parseDouble(this.maxDumpFileSize);
                            d10 = d10 * this.dbBlockSize / 1048576.0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            int n2;
                            if (this.maxDumpFileSize.indexOf("M") != -1 || this.maxDumpFileSize.indexOf("m") != -1) {
                                n2 = 0;
                                n2 = this.maxDumpFileSize.indexOf("M") != -1 ? this.maxDumpFileSize.indexOf("M") : this.maxDumpFileSize.indexOf("m");
                                String string5 = "";
                                if (this.maxDumpFileSize != null) {
                                    string5 = this.maxDumpFileSize.substring(0, n2);
                                }
                                try {
                                    d10 = Double.parseDouble(string5);
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    numberFormatException2.printStackTrace();
                                }
                            }
                            if (this.maxDumpFileSize.indexOf("K") == -1 && this.maxDumpFileSize.indexOf("k") == -1) break block25;
                            n2 = 0;
                            n2 = this.maxDumpFileSize.indexOf("K") != -1 ? this.maxDumpFileSize.indexOf("K") : this.maxDumpFileSize.indexOf("k");
                            String string6 = "";
                            if (this.maxDumpFileSize != null) {
                                string6 = this.maxDumpFileSize.substring(0, n2);
                            }
                            try {
                                d10 = Double.parseDouble(string6);
                            }
                            catch (NumberFormatException numberFormatException3) {
                                numberFormatException3.printStackTrace();
                            }
                            d10 /= 1024.0;
                        }
                    }
                    double d11 = d / d10 * 100.0;
                    double d12 = d10 - d;
                    double d13 = d12 / d10 * 100.0;
                    ((ArrayList)serializable).add(new Double(d10));
                    ((ArrayList)serializable).add(new Double(d11));
                    ((ArrayList)serializable).add(new Double(d13));
                }
            }
            this.addNewMeasure(string2, (ArrayList)serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getArea(String string) {
        String string2;
        block32: {
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block31: {
                block29: {
                    block25: {
                        connection = null;
                        statement = null;
                        resultSet = null;
                        string2 = null;
                        System.out.println(this.entity + " getArea()  query :::" + string + "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        connection = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
                        if (connection != null) break block25;
                        this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        System.out.println("[OraArchiveAreaTest] connection is null for:" + this.targetHost + " currentTime:" + new Date());
                        String string3 = null;
                        Object var12_11 = null;
                        try {
                            this.closeRset(resultSet);
                            this.closeStmt(statement);
                            this.closeConn(connection);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return string3;
                    }
                    System.out.println("Connection Statement :" + connection);
                    System.out.println("Query===>" + string);
                    try {
                        statement = connection.createStatement();
                    }
                    catch (Exception exception) {
                        this.logToErrorFile("Error :", "OraArchiveAreaTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                        exception.printStackTrace();
                        this.closeConn(connection);
                        String string4 = null;
                        Object var12_12 = null;
                        try {
                            this.closeRset(resultSet);
                            this.closeStmt(statement);
                            this.closeConn(connection);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        return string4;
                    }
                    resultSet = statement.executeQuery(string);
                    System.out.println("Result set :" + resultSet);
                    String string5 = null;
                    String string6 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        block28: {
                            string5 = resultSet.getString("NAME");
                            System.out.println("name is====>" + string5);
                            string6 = resultSet.getString("VALUE");
                            System.out.println("value is====>" + string6);
                            if (string5 == null || string6 == null || string5.trim().length() == 0 || string6.trim().length() == 0) continue;
                            if (string5.equalsIgnoreCase("db_block_size")) {
                                String string7 = string6;
                                try {
                                    this.dbBlockSize = Double.parseDouble(string7);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.dbBlockSize = 1.0;
                                }
                                continue;
                            }
                            if (string5.equalsIgnoreCase("max_dump_file_size")) {
                                this.maxDumpFileSize = string6;
                                System.out.println("MaxDumpFileSize : " + this.maxDumpFileSize);
                                continue;
                            }
                            try {
                                if (string6.indexOf("=") == -1) break block28;
                                int n = string6.indexOf("=");
                                string6 = string6.substring(n + 1);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue;
                            }
                        }
                        string6 = string6.trim();
                        stringBuffer.append(string6);
                        stringBuffer.append(",");
                    }
                    this.closeRset(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    string2 = stringBuffer.toString();
                    if (string2 != null) break block29;
                    String string8 = string2;
                    Object var12_13 = null;
                    try {
                        this.closeRset(resultSet);
                        this.closeStmt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return string8;
                }
                int n = string2.lastIndexOf(",");
                if (n == -1) break block31;
                string2 = string2.substring(0, n);
                string2 = string2.trim();
            }
            Object var12_14 = null;
            try {
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block32;
            {
                catch (SQLException sQLException) {
                    this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() Could not connect to the database targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, sQLException.toString());
                    System.out.println("[ " + this.entity + " ] ==> Could not connect to the database: " + sQLException.getMessage());
                    Object var12_15 = null;
                    try {
                        this.closeRset(resultSet);
                        this.closeStmt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block32;
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                    Object var12_16 = null;
                    try {
                        this.closeRset(resultSet);
                        this.closeStmt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                try {
                    this.closeRset(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return string2;
    }

    void closeRset(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    public ArrayList getActualResultsOnUnix(ArrayList arrayList) {
        String string = null;
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        int n = 0;
        if (arrayList == null) {
            return null;
        }
        n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            for (int i = 0; i < n; ++i) {
                double d;
                int n2;
                string = (String)arrayList.get(i);
                if (string.startsWith("Filesystem") || (n2 = (stringTokenizer = new StringTokenizer(string)).countTokens()) < 5) continue;
                string2 = stringTokenizer.nextToken();
                if (n2 == 6) {
                    string2 = stringTokenizer.nextToken();
                }
                long l = 0L;
                long l2 = 0L;
                try {
                    l = Long.parseLong(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    l2 = Long.parseLong(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.indexOf("cdrom") >= 0 || string3.indexOf("/dev/fd") >= 0 || string3.indexOf("/mnt/floppy") >= 0 || (d = (double)(l + l2)) == 0.0) continue;
                double d2 = (double)l * 100.0 / d;
                arrayList2.add(string3 + "#" + d / 1024.0 + "#" + (double)l / 1024.0 + "#" + (double)l2 / 1024.0 + "#" + d2);
            }
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getActualResultsOnHpux(ArrayList arrayList) {
        String string = null;
        StringTokenizer stringTokenizer = null;
        Object var4_4 = null;
        int n = 0;
        if (arrayList == null) {
            return null;
        }
        n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = null;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            for (int i = 0; i < n; ++i) {
                string = (String)arrayList.get(i);
                if (string.indexOf("used") != -1) continue;
                if (string.startsWith("/")) {
                    stringTokenizer = new StringTokenizer(string, ":");
                    int n3 = stringTokenizer.countTokens();
                    string5 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken().trim();
                    n2 = string2.indexOf("total");
                    string2 = string2.substring(0, n2).trim();
                    try {
                        l = Long.parseLong(string2);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (string.indexOf("free") != -1) {
                    stringTokenizer = new StringTokenizer(string);
                    string3 = stringTokenizer.nextToken().trim();
                    try {
                        l3 = Long.parseLong(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (l == 0L) continue;
                l2 = l - l3;
                l4 = l2 * 100L / l;
                if (string5.indexOf("cdrom") >= 0 || string5.indexOf("/dev/fd") >= 0 || string5.indexOf("/mnt/floppy") >= 0) continue;
                arrayList2.add(string5 + "#" + (double)l / 1024.0 + "#" + (double)l2 / 1024.0 + "#" + (double)l3 / 1024.0 + "#" + l4);
            }
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        OraArchiveAreaTest oraArchiveAreaTest = new OraArchiveAreaTest(stringArray);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    oraArchiveAreaTest.computeMeasures(new Hashtable());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }
}

