/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class IIBStatisticsAccountingParserHandler
extends DefaultHandler {
    private boolean insideDebug = false;
    Hashtable messageFlowHashtable = new Hashtable();
    ArrayList msgArrayList = new ArrayList();
    Hashtable threadsHashtable = new Hashtable();
    ArrayList threadsArrayList = new ArrayList();
    Hashtable nodeHashtable = new Hashtable();
    ArrayList nodeArrayList = new ArrayList();
    Hashtable intervalHashtable = new Hashtable();
    ArrayList intervalArrayList = new ArrayList();
    long statsInterval = 0L;
    String executionGroupName = null;
    String messageFlowName = null;
    String threadNumber = null;
    String nodeLabel = null;
    Hashtable allHastable = new Hashtable();

    IIBStatisticsAccountingParserHandler() {
    }

    public void startDocument() throws SAXException {
        if (this.insideDebug) {
            System.out.println("start of the document   : ");
        }
    }

    public void endDocument() throws SAXException {
        if (this.insideDebug) {
            System.out.println("end of the document document     : ");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = "";
        if (string3.equalsIgnoreCase("WMQIStatisticsAccounting")) {
            this.messageFlowHashtable = new Hashtable();
            this.executionGroupName = "";
            this.intervalHashtable = new Hashtable();
        }
        if (string3.equalsIgnoreCase("Threads")) {
            this.threadsHashtable = new Hashtable();
        }
        if (string3.equalsIgnoreCase("Nodes")) {
            this.nodeHashtable = new Hashtable();
        }
        if (string3.equalsIgnoreCase("MessageFlow")) {
            this.msgArrayList = new ArrayList();
            if (this.insideDebug) {
                System.out.println("Start Element qName   :" + string3);
            }
            this.executionGroupName = attributes.getValue("ExecutionGroupName");
            this.messageFlowName = attributes.getValue("MessageFlowName");
            String string5 = attributes.getValue("EndDate");
            String string6 = attributes.getValue("EndTime");
            String string7 = attributes.getValue("StartDate");
            String string8 = attributes.getValue("StartTime");
            this.statsInterval = this.convertingTimeStamp(string7, string8, string5, string6);
            string4 = attributes.getValue("TotalElapsedTime");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("MaximumElapsedTime");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalCPUTime");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("MaximumCPUTime");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalInputMessages");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalSizeOfInputMessages");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TimesMaximumNumberOfThreadsReached");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalNumberOfMQErrors");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalNumberOfMessagesWithErrors");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalNumberOfErrorsProcessingMessages");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalNumberOfCommits");
            this.msgArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalNumberOfBackouts");
            this.msgArrayList.add(new Double(string4));
        }
        if (string3.equalsIgnoreCase("ThreadStatistics")) {
            this.threadsArrayList = new ArrayList();
            this.threadNumber = attributes.getValue("Number");
            string4 = attributes.getValue("TotalElapsedTime");
            this.threadsArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalCPUTime");
            this.threadsArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalNumberOfInputMessages");
            this.threadsArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalSizeOfInputMessages");
            this.threadsArrayList.add(new Double(string4));
        }
        if (string3.equalsIgnoreCase("NodeStatistics")) {
            this.nodeArrayList = new ArrayList();
            if (this.insideDebug) {
                System.out.println("Start Element qName   :" + string3);
            }
            this.nodeLabel = attributes.getValue("Label");
            string4 = attributes.getValue("TotalElapsedTime");
            this.nodeArrayList.add(new Double(string4));
            string4 = attributes.getValue("MaximumElapsedTime");
            this.nodeArrayList.add(new Double(string4));
            string4 = attributes.getValue("TotalCPUTime");
            this.nodeArrayList.add(new Double(string4));
            string4 = attributes.getValue("MaximumCPUTime");
            this.nodeArrayList.add(new Double(string4));
            string4 = attributes.getValue("CountOfInvocations");
            this.nodeArrayList.add(new Double(string4));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("MessageFlow")) {
            this.messageFlowHashtable.put(this.executionGroupName + "/" + this.messageFlowName, this.msgArrayList);
            if (this.insideDebug) {
                System.out.println("End Element messageFlowHashtable  :" + this.messageFlowHashtable);
            }
            String string4 = this.executionGroupName + "/" + this.messageFlowName;
            this.intervalArrayList = new ArrayList();
            this.intervalArrayList.add(new Double(this.statsInterval));
            this.intervalHashtable.put(string4, this.intervalArrayList);
        }
        if (string3.equalsIgnoreCase("ThreadStatistics")) {
            this.threadsHashtable.put(this.executionGroupName + "/" + this.messageFlowName + ":" + this.threadNumber, this.threadsArrayList);
            if (this.insideDebug) {
                System.out.println("End Element threadsHashtable  :" + this.threadsHashtable);
            }
        }
        if (string3.equalsIgnoreCase("NodeStatistics")) {
            this.nodeHashtable.put(this.executionGroupName + "/" + this.messageFlowName + ":" + this.nodeLabel, this.nodeArrayList);
            if (this.insideDebug) {
                System.out.println("End Element nodeHashtable  :" + this.nodeHashtable);
            }
        }
        if (string3.equalsIgnoreCase("WMQIStatisticsAccounting")) {
            this.allHastable.put("MSG", this.messageFlowHashtable);
            this.allHastable.put("THREAD", this.threadsHashtable);
            this.allHastable.put("NODE", this.nodeHashtable);
            this.allHastable.put("INTERVAL", this.intervalHashtable);
            if (this.insideDebug) {
                System.out.println("End Element messageFlowHashtable  :" + this.messageFlowHashtable);
                System.out.println("End Element threadsHashtable  :" + this.threadsHashtable);
                System.out.println("End Element nodeHashtable  :" + this.nodeHashtable);
                System.out.println("End Element intervalHashtable  :" + this.intervalHashtable);
            }
        }
    }

    public Hashtable getAllDataHashtable() {
        return this.allHastable;
    }

    protected long convertingTimeStamp(String string, String string2, String string3, String string4) {
        if (string2.lastIndexOf(".") > -1) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        if (string4.lastIndexOf(".") > -1) {
            string4 = string4.substring(0, string4.lastIndexOf("."));
        }
        String string5 = string + " " + string2;
        String string6 = string3 + " " + string4;
        long l = this.timeStampToMillsecond(string5);
        long l2 = this.timeStampToMillsecond(string6);
        long l3 = l2 - l;
        if (l3 > 0L) {
            l3 /= 1000L;
        }
        return l3;
    }

    protected long timeStampToMillsecond(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long l = 0L;
        try {
            Date date = simpleDateFormat.parse(string);
            l = date.getTime();
        }
        catch (Exception exception) {
            System.out.println("Error  in timeStampToMillsecond()  :" + exception.getMessage().toString());
        }
        return l;
    }
}

