/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.EgTesterInfo;
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionException;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class AsAbapJco3Base
extends GenericTest {
    public static final String myDFStr = "dd/MM/yy hh:mm:ss a";
    private String unknown_inst = "UNKNOWN";
    public final SimpleDateFormat timestampSDF = new SimpleDateFormat("yyyyMMdd HHmmss");
    public final SimpleDateFormat dateOnlySDF = new SimpleDateFormat("yyyyMMdd");
    public final SimpleDateFormat timeOnlySDF = new SimpleDateFormat("HHmmss");
    public final SimpleDateFormat mySDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a");
    public static final int NaInt = -5;
    private static final long comm_Timeout_Chk = 50L;
    private static final long oneDayMillis = 86400000L;
    public static final String DdpRegSynch = "DdpRegSynch";
    private static final String def_IdleTimeout = "120";
    protected static final Double NaDbl = new Double(-5.0);
    protected static final Double zeroDbl = new Double(0.0);
    protected static final Integer oneInt = new Integer(1);
    protected final String timeOnlyFormat = "yyyyMMdd_HHmmss";
    protected final String timeFormat = "yyyyMMdd_HHmmss";
    protected final String dateOnlyFormat = "yyyyMMdd";
    protected final String eGTimeFormat = "MM/dd/yyyy HH:mm:ss";
    private final String eGDateOnlyFormat = "MM/dd/yyyy";
    private final String eGTimeOnlyFormat = "HH:mm ss";
    private static final String syncString = new String("SAP_R3_SERVER");
    public static final String TCodeMapSync = new String("TCODE_MAP");
    private static final String instanceSyncString1 = new String("SAP_R3_SERVER");
    private static Hashtable instanceSyncHashtable = new Hashtable();
    private static Hashtable oldinstSyncHashtable = new Hashtable();
    static Hashtable ht_TCodeMap = new Hashtable();
    private EgUtilities egutil = null;
    protected static Hashtable errCodeTbl;
    protected static Hashtable ht_SapTimeCal;
    protected static Hashtable ht_GetTimeMillis;
    protected static Hashtable ht_QueryTimeMillis;
    protected String user = null;
    String pass = null;
    protected String sysnr = null;
    String clt = null;
    String saprouter = null;
    protected String max_concurrent = null;
    protected String idle_close_time = null;
    protected String idle_chk_period = null;
    protected String max_idle_conns = null;
    protected String max_conn_wait = null;
    protected String destName = null;
    protected String instanceName;
    private String XMIAuditLevel = "";
    private int AuditLevel = 0;
    protected String sessID = null;
    protected boolean isDebugOn = true;
    private long comm_Timeout;
    protected String thisServer = null;
    protected String eGSapXMIUser = null;
    static AsAbapDdp DestDataPrvdr;
    static AsAbapSrp SessRefPrvdr;
    protected static String fieldSep;
    private String errorMsgForValidation = new String("SUCCESS");
    private String instanceNameForValidation = new String("none");
    private String targetOS = "";
    String appSrvr = null;
    String msgSrvr = null;
    String logongroup = null;
    String sapsid = null;
    String connectionType = null;
    protected static final Hashtable ht_NumCPUs;

    protected static JCoDestination getDestination(String string) {
        System.out.println(" : Getting destination object for name " + string);
        JCoDestination jCoDestination = null;
        try {
            jCoDestination = JCoDestinationManager.getDestination((String)string);
            return jCoDestination;
        }
        catch (Exception exception) {
            System.out.println(" : ERROR : Exception while trying to get destination " + string + " : " + exception.toString());
            return null;
        }
    }

    public static String getHostName(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostName().toLowerCase();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public boolean isIPAddress(String string) {
        String string2;
        int n;
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            string2 = "" + string.charAt(n);
            if (!string2.equals(".")) continue;
            ++n2;
        }
        if (n2 != 3) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            string2 = "" + string.charAt(n);
            if (string2.equals("0") || string2.equals("1") || string2.equals("2") || string2.equals("3") || string2.equals("4") || string2.equals("5") || string2.equals("6") || string2.equals("7") || string2.equals("8") || string2.equals("9") || string2.equals(".")) continue;
            return false;
        }
        return true;
    }

    public String getHostNameFromCommand(String string) {
        String string2 = "";
        AsAbapJco3Base asAbapJco3Base = this;
        String string3 = asAbapJco3Base.egutil.getOSName().toUpperCase();
        if (string3.startsWith("WINDOWS")) {
            string2 = "ping -a " + string + " -4";
        } else if (string3.equalsIgnoreCase("LINUX") || string3.equalsIgnoreCase("SUNOS") || string3.equalsIgnoreCase("HP-UX") || string3.equalsIgnoreCase("AIX") || string3.equalsIgnoreCase("OSF1")) {
            string2 = "ping -c 4 " + string;
        }
        ArrayList arrayList = this.egutil.getCommandOutputLines(string2);
        this.printOut("ipaddrList " + arrayList);
        String string4 = "";
        if (arrayList != null && arrayList.size() > 3) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5 = arrayList.get(i).toString();
                string5 = string5.replaceAll("\\s", "");
                this.printOut("ipaddrList strList" + string5);
                if (string3.startsWith("WINDOWS")) {
                    if (string5 == null || string5.indexOf("Pinging") <= -1 || string5.indexOf("[") <= -1) continue;
                    string4 = string5.substring(string5.indexOf("Pinging") + 7, string5.indexOf("["));
                    this.printOut("remote host " + string4);
                    return string4.toLowerCase();
                }
                if (!string3.equalsIgnoreCase("LINUX") && !string3.equalsIgnoreCase("SUNOS") && !string3.equalsIgnoreCase("HP-UX") && !string3.equalsIgnoreCase("AIX") && !string3.equalsIgnoreCase("OSF1") || string5 == null || string5.indexOf("PING") <= -1 || string5.indexOf("(") <= -1) continue;
                string4 = string5.substring(string5.indexOf("PING") + 4, string5.indexOf("("));
                this.printOut("remote host " + string4);
                return string4.toLowerCase();
            }
        }
        return "";
    }

    protected static void printDestnStats(JCoDestination jCoDestination) {
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        System.out.println("POOL STATS : Printing stats for destination " + jCoDestination.getDestinationName());
        JCoDestinationMonitor jCoDestinationMonitor = null;
        try {
            jCoDestinationMonitor = jCoDestination.getMonitor();
        }
        catch (Exception exception) {
            System.out.println("POOL STATS : Exception while getting destination monitor for destination " + jCoDestination.getDestinationName() + " : " + exception.toString());
            return;
        }
        System.out.println("is Valid = " + jCoDestinationMonitor.isValid());
        System.out.println(jCoDestinationMonitor.getPooledConnectionCount() + " Of " + jCoDestinationMonitor.getPoolCapacity() + " connections held open");
        System.out.println("Used conns " + jCoDestinationMonitor.getUsedConnectionCount() + ".  Pooled conns " + jCoDestinationMonitor.getPooledConnectionCount());
        System.out.println(jCoDestinationMonitor.getMaxUsedCount() + " Of " + jCoDestinationMonitor.getPeakLimit() + " max connections limit reached so far");
        System.out.println("Last activity timestamp : " + jCoDestinationMonitor.getLastActivityTimestamp());
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endSession() {
        this.printOut("INFO : Marking session '" + this.sessID + "' as ended");
        try {
            String string = this.sessID;
            synchronized (string) {
                JFnThread.ht_CurrSessRefs.remove(this.sessID);
            }
            this.printOut("INFO : Removed the session '" + this.sessID + "' from the table");
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while removing session from session hashtable " + exception.toString());
            JFnThread.ht_CurrSessRefs.put(this.sessID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AsAbapJco3Base(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        System.out.println("***********************************************");
        this.fixedTestPeriod = true;
        this.needAgentlessDD = true;
        this.user = this.getValueForParam("sapuser");
        this.pass = this.getValueForParam("password");
        this.sysnr = this.getValueForParam("sysno");
        this.clt = this.getValueForParam("clientname");
        this.saprouter = this.getValueForParam("router");
        this.targetOS = this.getValueForParam("os");
        this.appSrvr = this.getValueForParam("Application_server");
        this.sapsid = this.getValueForParam("sid");
        this.logongroup = this.getValueForParam("logon_group");
        this.connectionType = this.getValueForParam("Connection_type");
        this.msgSrvr = this.getValueForParam("Message_Server");
        if (this.connectionType == null || this.connectionType.length() == 0) {
            this.connectionType = "application_server";
        }
        if (this.logongroup == null || this.logongroup.length() == 0) {
            this.logongroup = "SPACE";
        }
        if (this.appSrvr == null || this.appSrvr.length() == 0 || this.appSrvr.equalsIgnoreCase("none")) {
            this.appSrvr = this.targetHost;
        }
        if (this.msgSrvr == null || this.msgSrvr.length() == 0) {
            this.msgSrvr = this.targetHost;
        }
        Hashtable hashtable = this.readPoolIniParams();
        this.max_concurrent = (String)hashtable.get("max_concurrent");
        this.idle_close_time = (String)hashtable.get("idle_close_time");
        this.idle_chk_period = (String)hashtable.get("idle_chk_period");
        this.max_idle_conns = (String)hashtable.get("max_idle_conns");
        this.max_conn_wait = (String)hashtable.get("max_conn_wait");
        this.destName = this.reportingName + ":" + this.portNo;
        if (this.connectionType.equalsIgnoreCase("group_server")) {
            this.thisServer = this.reportingName + "#" + this.clt + "#" + this.user + "#" + this.sapsid + "#" + this.msgSrvr + "#" + this.portNo;
            this.eGSapXMIUser = "eGAgt" + this.sapsid + "#" + this.user + "#" + this.clt;
            this.printOut("msgSrvr = " + this.msgSrvr);
        } else {
            this.thisServer = this.reportingName + "#" + this.clt + "#" + this.user + "#" + this.sysnr + "#" + this.targetHost + "#" + this.portNo;
            this.eGSapXMIUser = "eGAgt" + this.sysnr + "#" + this.user + "#" + this.clt;
            this.printOut("appSrvr = " + this.appSrvr);
        }
        this.egutil = EgUtilities.createInstance();
        this.printOut("connectionType :" + this.connectionType);
        this.printOut("logongroup :" + this.logongroup);
        this.printOut("sapsid :" + this.sapsid);
        Integer n = (Integer)ht_NumCPUs.get(this.reportingName);
        if (n == null) {
            string2 = "FINDCPU";
            // MONITORENTER : "FINDCPU"
            if (n == null) {
                n = new Integer(this.findNumProcessors());
                ht_NumCPUs.put(this.thisServer, n);
            }
            // MONITOREXIT : string2
        }
        if (!Environment.isDestinationDataProviderRegistered()) {
            string2 = DdpRegSynch;
            // MONITORENTER : "DdpRegSynch"
            if (!Environment.isDestinationDataProviderRegistered()) {
                this.printOut("DEBUG", this.entity + "  " + this.thisServer, " : DestDataPrvdr not registered yet. Trying to register");
                try {
                    Environment.registerDestinationDataProvider((DestinationDataProvider)DestDataPrvdr);
                    this.printOut("DEBUG", this.entity + "  " + this.thisServer, " : DestDataPrvdr registered successfully");
                }
                catch (IllegalStateException illegalStateException) {
                    this.printOut("WARNING", this.entity + "  " + this.thisServer, " : Received " + illegalStateException.toString() + " while registering DestDataPrvdr. DestDataPrvdr was already registered previously");
                }
            }
            if (!Environment.isSessionReferenceProviderRegistered()) {
                this.printOut("DEBUG", this.entity + "  " + this.thisServer, " : SessRefPrvdr not registered yet. Trying to register");
                try {
                    Environment.registerSessionReferenceProvider((SessionReferenceProvider)SessRefPrvdr);
                    this.printOut("DEBUG", this.entity + "  " + this.thisServer, " : SessRefPrvdr registered successfully");
                }
                catch (IllegalStateException illegalStateException) {
                    this.printOut("WARNING", this.entity + "  " + this.thisServer, " : Received " + illegalStateException.toString() + " while registering SessRefPrvdr. SessRefPrvdr was already registered previously");
                }
            }
            // MONITOREXIT : string2
        }
        if (this.connectionType.equalsIgnoreCase("group_server")) {
            DestDataPrvdr.checkAndUpdateDestinationLogonGroup(this.destName, this.user, this.pass, this.clt, this.msgSrvr, this.sapsid, this.logongroup, this.saprouter, this.max_concurrent, this.idle_close_time, this.idle_chk_period, this.max_idle_conns, this.max_conn_wait);
        } else {
            DestDataPrvdr.checkAndUpdateDestination(this.destName, this.user, this.pass, this.sysnr, this.clt, this.appSrvr, this.saprouter, this.max_concurrent, this.idle_close_time, this.idle_chk_period, this.max_idle_conns, this.max_conn_wait);
        }
        string2 = this.getValueForParam("timeout");
        if (string2 == null) {
            string2 = def_IdleTimeout;
        }
        try {
            this.comm_Timeout = Long.parseLong(string2) * 800L;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.comm_Timeout = Long.parseLong(def_IdleTimeout) * 800L;
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        this.printOut("INFO : Max allowed thread run time = " + this.comm_Timeout + " ms. Timeout check period = " + 50L + " ms.");
        String string3 = this.getValueForParam("instancename");
        this.printOut("Before instancehshtable : " + instanceSyncHashtable);
        this.printOut("Before oldinstSyncHashtable : " + oldinstSyncHashtable);
        if (string3 == null || string3.trim().length() == 0) {
            this.printOut("Instance param value is null.So calling setInstance method to set the instance name");
            this.setInstanceName();
        } else if (string3.equalsIgnoreCase("none") || string3.equalsIgnoreCase("default")) {
            this.printOut("Instance param is none or default ,So calling setInstance method to set the instance name");
            if (oldinstSyncHashtable != null && oldinstSyncHashtable.get(this.thisServer) != null && instanceSyncHashtable != null && instanceSyncHashtable.get(this.thisServer) != null) {
                string = instanceSyncString1;
                // MONITORENTER : string
                instanceSyncHashtable.remove(this.thisServer);
                oldinstSyncHashtable.remove(this.thisServer);
                this.printOut("instanceSyncHashtable removed: " + this.thisServer);
                // MONITOREXIT : string
            }
            this.setInstanceName();
        } else {
            string = instanceSyncString1;
            // MONITORENTER : string
            instanceSyncHashtable.put(this.thisServer, new String(string3));
            oldinstSyncHashtable.put(this.thisServer, new String(string3));
            // MONITOREXIT : string
        }
        this.printOut("After oldinstSyncHashtable : " + oldinstSyncHashtable);
        this.printOut("After instancehshtable : " + instanceSyncHashtable);
        this.printOut("INSTANCE is " + this.getInstanceName() + " for " + this.entity);
        if (fieldSep.length() != 0) return;
        string = "fieldSepStr";
        // MONITORENTER : "fieldSepStr"
        if (fieldSep.length() == 0) {
            EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
            fieldSep = egTesterInfo.getDDSeparator1();
        }
        // MONITOREXIT : string
    }

    protected void decryptPassword() {
        String string = EgCrypt.decrypt((String)this.pass);
        DestDataPrvdr.checkAndUpdateDestination(this.destName, this.user, string, this.sysnr, this.clt, this.appSrvr, this.saprouter, this.max_concurrent, this.idle_close_time, this.idle_chk_period, this.max_idle_conns, this.max_conn_wait);
        this.printOut("Password decrypted and destination updated");
    }

    protected boolean logonToXMI(String string, String string2) {
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(this.destName);
        if (jCoDestination == null) {
            return false;
        }
        JCoFunction jCoFunction = this.getFunction("BAPI_XMI_LOGON");
        if (jCoFunction == null) {
            return false;
        }
        try {
            jCoFunction.getImportParameterList().setValue("EXTCOMPANY", "eGInnovations");
            jCoFunction.getImportParameterList().setValue("EXTPRODUCT", "eG");
            jCoFunction.getImportParameterList().setValue("INTERFACE", string);
            jCoFunction.getImportParameterList().setValue("VERSION", string2);
            this.executeFunction(jCoFunction, true);
            this.printOut("INFO : Logged onto " + string2 + " version of the " + string + " interface");
            return true;
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to logon to " + string2 + " version of the " + string + " interface: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while trying to logon to " + string2 + " version of the " + string + " interface: " + exception.toString());
            this.printOut(EgInstallInfo.getStackTraceAsString(exception));
            return false;
        }
    }

    boolean logoffFromXMI() {
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(this.destName);
        if (jCoDestination == null) {
            return false;
        }
        JCoFunction jCoFunction = this.getFunction("BAPI_XMI_LOGOFF");
        if (jCoFunction == null) {
            return false;
        }
        try {
            this.executeFunction(jCoFunction, true);
            this.printOut("INFO : Logged off from XMI.");
            return true;
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to logoff from XMI : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while trying to logoff from XMI : " + exception.toString());
            this.printOut(EgInstallInfo.getStackTraceAsString(exception));
            return false;
        }
    }

    public void setXMIAuditLevel(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.printOut("Exception while parsing audit level " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + " : " + this.thisServer, "Exception while parsing audit level " + string + " : " + exception.toString());
            return;
        }
        if (n == 0) {
            return;
        }
        JCoFunction jCoFunction = this.getFunction("BAPI_XMI_SET_AUDITLEVEL");
        if (jCoFunction == null) {
            return;
        }
        jCoFunction.getImportParameterList().setValue("AUDITLEVEL", this.XMIAuditLevel);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while setting XMI audit level to " + string + " : " + exception.toString());
            this.printOut("ERROR : " + EgInstallInfo.getStackTraceAsString(exception));
            this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Exception while setting XMI audit level to " + string + " : " + exception.toString());
            return;
        }
        this.printOut("INFO : Set XMI Audit level to " + string);
    }

    protected static boolean beginContext(String string) {
        System.out.println("debug : >>> Going to begin Context");
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(string);
        if (jCoDestination == null) {
            return false;
        }
        System.out.println("debug  : >>> destination has been obtained");
        JCoContext.begin((JCoDestination)jCoDestination);
        System.out.println("INFO : >>> Context has begun");
        return true;
    }

    protected static boolean endContext(String string) {
        System.out.println("INFO : <<< Ending context");
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(string);
        if (jCoDestination == null) {
            return false;
        }
        try {
            JCoContext.end((JCoDestination)jCoDestination);
            return true;
        }
        catch (Exception exception) {
            System.out.println("ERROR : Exception while releasing context for destination " + string + " : " + exception.toString());
            return false;
        }
    }

    protected void setSessID() {
        this.sessID = this.reportingName + "_" + this.portNo + "_" + this.entity + "_" + System.currentTimeMillis();
        this.printOut("INFO : Generated session ID " + this.sessID);
    }

    protected String removeString(String string, String string2) {
        int n = string.indexOf(string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 1;
            n = string.indexOf(string2, n + 1);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    protected Double getDblFromTable(JCoTable jCoTable, String string) {
        double d = -5.0;
        try {
            d = jCoTable.getDouble(string);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from table " + jCoTable.getMetaData().getName() + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Could not obtain field " + string + " from table " + jCoTable.getMetaData().getName() + " : " + exception.toString());
            d = -5.0;
        }
        return new Double(d);
    }

    protected int getIntFromStruct(JCoStructure jCoStructure, String string) {
        int n = -5;
        try {
            n = jCoStructure.getInt(string);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from structure " + jCoStructure.getMetaData().getName());
            n = -5;
        }
        return n;
    }

    protected Double getDblFromStruct(JCoStructure jCoStructure, String string) {
        Double d = NaDbl;
        String string2 = null;
        try {
            string2 = jCoStructure.getString(string);
            try {
                d = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.printOut("Exception while parsing double value " + string2 + " for field " + string + " : " + numberFormatException.toString());
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while parsing double value " + string2 + " for field " + string + " : " + numberFormatException.toString());
                d = NaDbl;
            }
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from structure " + jCoStructure.getMetaData().getName());
            d = NaDbl;
        }
        return d;
    }

    private Hashtable readPoolIniParams() {
        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOMaxConns");
        hashtable.put("max_concurrent", this.parseIniParam("JCOMaxConns", string, 25L, 1));
        String string2 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOMaxIdleConns");
        hashtable.put("max_idle_conns", this.parseIniParam("JCOMaxIdleConns", string2, 14L, 1));
        String string3 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOConnTimeout");
        hashtable.put("idle_close_time", this.parseIniParam("JCOConnTimeout", string3, 30L, 1000));
        String string4 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOTimeoutCheckPeriod");
        hashtable.put("idle_chk_period", this.parseIniParam("JCOTimeoutCheckPeriod", string4, 5L, 1000));
        String string5 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOMaxWaitTime");
        hashtable.put("max_conn_wait", this.parseIniParam("JCOMaxWaitTime", string5, 30L, 1000));
        return hashtable;
    }

    private String parseIniParam(String string, String string2, long l, int n) {
        if (string2 == null) {
            this.printOut("WARNING", this.entity + "  " + this.thisServer, "Could not find " + string + " in agent eg_tests.ini. Defaulting to " + l);
            return String.valueOf(l);
        }
        try {
            long l2 = Long.parseLong(string2);
            this.printOut("INFO", this.entity + "  " + this.thisServer, "JCO connection parameter " + string + " = " + l2 * (long)n);
            return String.valueOf(l2 * (long)n);
        }
        catch (NumberFormatException numberFormatException) {
            this.printOut("ERROR", this.entity + "  " + this.thisServer, "Could not parse " + string + " value " + string2 + " in agent eg_tests.ini. Defaulting to " + l * (long)n);
            return String.valueOf(l * (long)n);
        }
    }

    protected JCoFunction getFunction(String string) {
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(this.destName);
        if (jCoDestination == null) {
            return null;
        }
        JCoRepository jCoRepository = null;
        try {
            jCoRepository = jCoDestination.getRepository();
        }
        catch (JCoException jCoException) {
            this.setErrorMsgForValidation(jCoException.toString());
            this.printOut("ERROR : Could not get repository while getting function " + string + " : " + jCoException.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, this.reportingName + " : Could not get repository while getting function " + string + " : " + jCoException.toString());
            return null;
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not get repository while getting function " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, this.reportingName + " : Could not get repository while getting function " + string + " : " + exception.toString());
            return null;
        }
        JCoFunction jCoFunction = null;
        try {
            jCoFunction = jCoRepository.getFunction(string.toUpperCase());
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not get function " + string + " : " + exception.toString());
            return null;
        }
        if (jCoFunction == null) {
            this.printOut("ERROR : Underlying function template for function " + string + " could not be obtained.");
            return null;
        }
        return jCoFunction;
    }

    protected boolean executeCommand() {
        this.printOut("executeCommand : ");
        this.setSessID();
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(this.destName);
        if (jCoDestination == null) {
            this.endSession();
            return false;
        }
        try {
            JCoFunction jCoFunction = this.getFunction("STFC_CONNECTION");
            if (jCoFunction == null) {
                this.endSession();
                return false;
            }
            jCoFunction.getImportParameterList().setValue("REQUTEXT", this.destName);
            this.printOut("DEBUG: executeCommand : Set request text to " + this.destName);
            this.executeFunction(jCoFunction, false);
            this.printOut("DEBUG : Got echotext " + jCoFunction.getExportParameterList().getValue("ECHOTEXT"));
            this.printOut("DEBUG : Got resptext " + jCoFunction.getExportParameterList().getValue("RESPTEXT"));
            this.printOut("executeCommand succeeded");
            this.endSession();
            return true;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception in executeCommand method : " + exception.toString());
            this.printOut("ERROR : Exception in executeCommand method : " + exception.toString());
            this.endSession();
            return false;
        }
    }

    protected boolean executeCommandValidation() {
        this.printOut("executeCommandValidation : ");
        this.setSessID();
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(this.destName);
        if (jCoDestination == null) {
            this.endSession();
            return false;
        }
        try {
            JCoFunction jCoFunction = this.getFunction("STFC_CONNECTION");
            if (jCoFunction == null) {
                this.endSession();
                return false;
            }
            jCoFunction.getImportParameterList().setValue("REQUTEXT", this.destName);
            this.printOut("DEBUG: executeCommandValidation : Set request text to " + this.destName);
            this.executeFunction(jCoFunction, false);
            this.printOut("DEBUG : Got echotext " + jCoFunction.getExportParameterList().getValue("ECHOTEXT"));
            this.printOut("DEBUG : Got resptext " + jCoFunction.getExportParameterList().getValue("RESPTEXT"));
            this.printOut("executeCommandValidation succeeded");
            this.endSession();
            this.setInstanceNameForValidation(this.collectInstanceName());
            return true;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception in executeCommandValidation method : " + exception.toString());
            this.printOut("ERROR : Exception in executeCommandValidation method : " + exception.toString());
            this.endSession();
            return false;
        }
    }

    protected void runThread(MonitoredThread monitoredThread, String string) throws Exception {
        this.runThread(monitoredThread, string, 50L);
    }

    protected void runThread(MonitoredThread monitoredThread, String string, long l) throws Exception {
        monitoredThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        long l4 = System.currentTimeMillis() - l2;
        while (monitoredThread.isAlive() && l4 < this.comm_Timeout) {
            if (this.isDebugOn) {
                this.printOut("Thread " + string + " still alive");
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string2 = "";
        if (monitoredThread.isAlive()) {
            this.printOut("Thread " + string + " is still it is alive.");
            if (monitoredThread.status == -1) {
                bl = true;
                string2 = " timed out with exception : " + monitoredThread.errMsg;
            } else {
                bl = true;
                string2 = " timed out.";
            }
        } else {
            this.printOut("Thread " + string + " completed successfully in " + l4 + " ms.");
            if (monitoredThread.status != 1) {
                if (monitoredThread.status == -1) {
                    bl = true;
                    string2 = " got done with exception : " + monitoredThread.errMsg;
                } else {
                    this.logToErrorFile("ERROR : ", this.entity + " : " + this.thisServer, "Thread aborted without exception. " + string);
                    bl = true;
                    string2 = "aborted without exception";
                }
            }
        }
        if (bl) {
            monitoredThread.interrupt();
            this.printOut("DEBUG : Thread " + string + " is interrupted. Total thread execution time is = " + l4);
            this.logToErrorFile("DEBUG : ", this.entity + " : " + this.thisServer, "Thread " + string + " is interrupted. Total thread execution time is = " + l4);
            long l5 = System.currentTimeMillis();
            try {
                Thread.yield();
                long l6 = 0L;
                boolean bl2 = false;
                long l7 = Math.round((double)(this.measurePeriod * 1000L - l4) * 0.8);
                long l8 = 86001L;
                if (l7 < l8 && l7 > 0L) {
                    l6 = l7;
                } else if (l8 <= l7) {
                    l6 = l8;
                } else {
                    this.printOut("ERROR : " + this.entity + " Cannot caluclate checkTime. So default to 40 sec wait");
                    this.logToErrorFile("ERROR : ", this.entity + " : " + this.thisServer, "Cannot caluclate checkTime. So default to 40 sec wait");
                    l6 = 40000L;
                }
                long l9 = System.currentTimeMillis();
                while (monitoredThread.isAlive() && !bl2) {
                    long l10 = System.currentTimeMillis();
                    long l11 = l10 - l9;
                    if (l11 > l6) {
                        bl2 = true;
                        this.printOut("ERROR : Long running thread found. Thread total time=" + l11 + " ms check time=" + l6 + " ms");
                        this.logToErrorFile("ERROR : ", this.entity + " : " + this.thisServer, "Long running thread found. Thread total time=" + l11 + " ms check time=" + l6 + " ms");
                    }
                    if (bl2) continue;
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.printOut("Error: Thread " + string + " with status " + string2 + " itself got interrupted when joining monitored thread and waiting for it to get completed for " + (System.currentTimeMillis() - l5) + " ms.");
                this.logToErrorFile("ERROR", this.entity + " : " + this.thisServer, "Error: Thread " + string + " with status " + string2 + " itself got interrupted when joining monitored thread and waiting for it to get completed for " + (System.currentTimeMillis() - l5) + " ms.");
                throw new Exception("Thread " + string + " " + string2 + " and could not terminate after " + (System.currentTimeMillis() - l5) + " ms.");
            }
            this.printOut("Error: Thread " + string + " " + string2 + " Thread state = " + monitoredThread.isAlive());
            this.logToErrorFile("ERROR", this.entity + " : " + this.thisServer, "Thread " + string + string2 + " Thread state = " + monitoredThread.isAlive());
            if (monitoredThread.excpn != null) {
                this.printOut("Exception stack trace : " + EgInstallInfo.getStackTraceAsString(monitoredThread.excpn));
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, EgInstallInfo.getStackTraceAsString(monitoredThread.excpn));
            }
            throw new Exception("Thread " + string + " " + string2);
        }
    }

    protected void executeFunction(JCoFunction jCoFunction, boolean bl) throws Exception {
        this.executeFunction(jCoFunction, bl, null);
    }

    protected void executeFunction(JCoFunction jCoFunction, boolean bl, String string) throws Exception {
        String string2 = jCoFunction.getName();
        long l = System.currentTimeMillis();
        if (string == null) {
            string = this.destName;
        }
        this.printOut("DEBUG : Destination name to run thread is >> " + string);
        this.runThread(new JFnThread(jCoFunction, bl, this.sessID, string), string2);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 > 50L) {
            this.printOut("Time taken to execute function " + string2 + " is " + (System.currentTimeMillis() - l) + " ms.");
        }
    }

    public void printOut(String string) {
        System.out.println(" >> " + this.reportingName + "." + this.entity + "  " + this.thisServer + ": [ " + this.mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, String string2, String string3) {
        System.out.println(this.mySDF.format(new Date()) + " [ " + string + " ] : " + this.reportingName + "." + string2 + " : " + string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getSystemTimestamp() {
        Calendar calendar = null;
        Long l = null;
        long l2 = 0L;
        long l3 = 0L;
        Date date = null;
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = null;
        String string3 = this.thisServer;
        synchronized (string3) {
            calendar = (Calendar)ht_SapTimeCal.get(this.thisServer);
            l = (Long)ht_QueryTimeMillis.get(this.thisServer);
            if (calendar == null) {
                calendar = Calendar.getInstance();
                ht_SapTimeCal.put(this.thisServer, calendar);
                this.printOut("DEBUG : Creating calendar object for component id " + this.thisServer);
            }
            long l4 = System.currentTimeMillis();
            long l5 = 0L;
            long l6 = 0L;
            if (l != null) {
                l3 = l;
            }
            if ((l6 = l4 - l3) > 86400000L) {
                this.printOut("diffQueryMillis is " + l6 + ". Connecting to SAP to refresh system time");
                JCoDestination jCoDestination = null;
                try {
                    jCoDestination = JCoDestinationManager.getDestination((String)this.destName);
                }
                catch (Exception exception) {
                    this.printOut("ERROR : Exception while getting destination with name " + this.destName + " : " + exception.toString());
                    this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while getting destination with name " + this.destName + " : " + exception.toString());
                    return null;
                }
                this.printOut("DEBUG : Got destination " + this.destName);
                JCoFunction jCoFunction = this.getFunction("MSS_GET_SY_DATE_TIME");
                if (jCoFunction == null) {
                    return null;
                }
                try {
                    this.setSessID();
                    this.executeFunction(jCoFunction, false);
                }
                catch (Exception exception) {
                    this.printOut("Error : Exception while executing MSS_GET_SY_DATE_TIME : " + exception.toString());
                    this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while executing MSS_GET_SY_DATE_TIME  " + this.destName + " : " + exception.toString());
                    exception.printStackTrace();
                    this.endSession();
                    return null;
                }
                string = jCoFunction.getExportParameterList().getString("SAPDATE");
                string = this.removeString(string, "-");
                string2 = jCoFunction.getExportParameterList().getString("SAPTIME");
                string2 = this.removeString(string2, ":");
                this.printOut("Got SAP system date time : " + string + " " + string2);
                try {
                    date = this.timestampSDF.parse(string + " " + string2);
                }
                catch (Exception exception) {
                    this.printOut("Exception while parsing SAP system timestamp '" + string + " " + string2 + "' : " + exception.toString());
                    this.logToErrorFile("ERROR", this.entity + " " + this.thisServer, "Exception while parsing SAP system timestamp '" + string + " " + string2 + "' : " + exception.toString());
                    return null;
                }
                this.endSession();
                calendar.setTime(date);
                ht_QueryTimeMillis.put(this.thisServer, new Long(l4));
            } else {
                l = (Long)ht_GetTimeMillis.get(this.thisServer);
                l2 = l;
                l5 = l4 - l2;
                calendar.add(14, (int)l5);
                date = calendar.getTime();
                String string4 = this.timestampSDF.format(date);
                int n = string4.indexOf(" ");
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
            ht_GetTimeMillis.put(this.thisServer, new Long(l4));
        }
        arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        this.printOut("Current SAP system timestamp is " + arrayList.toString());
        return arrayList;
    }

    protected ArrayList getEndAndStartTimestamps(long l) {
        return this.getEndAndStartTimestamps(l, false);
    }

    protected ArrayList getEndAndStartTimestamps(long l, boolean bl) {
        ArrayList<String> arrayList = this.getSystemTimestamp();
        if (arrayList == null) {
            return null;
        }
        Date date = null;
        try {
            try {
                date = this.timestampSDF.parse((String)arrayList.get(0) + " " + (String)arrayList.get(1));
            }
            catch (NumberFormatException numberFormatException) {
                this.printOut("Error : Exception while parsing date " + date.toString() + " : " + numberFormatException.toString());
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Error : Exception while parsing date " + date.toString() + " : " + numberFormatException.toString());
                return null;
            }
        }
        catch (ParseException parseException) {
            this.printOut("Error : Exception while parsing date " + date.toString() + " : " + parseException.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Error : Exception while parsing date " + date.toString() + " : " + parseException.toString());
            return null;
        }
        arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        string = this.dateOnlySDF.format(date);
        string2 = this.timeOnlySDF.format(date);
        arrayList.add(string);
        arrayList.add(string2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (!bl) {
            long l2 = l / 1000L;
            this.printOut("Measure period or CuttOff in seconds is " + l2);
            calendar.add(13, (int)(-l2));
        } else {
            calendar.add(10, (int)(-l));
        }
        Date date2 = calendar.getTime();
        string = this.dateOnlySDF.format(date2);
        string2 = this.timeOnlySDF.format(date2);
        this.printOut("Converted start date and start time are " + string + " and " + string2);
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    protected ArrayList getEndAndStartTimestamps() {
        return this.getEndAndStartTimestamps(this.measurePeriod);
    }

    protected long getDateDiff(ArrayList arrayList, String string, String string2) {
        return this.getDateDiff((String)arrayList.get(0), (String)arrayList.get(1), string, string2);
    }

    protected long getDateDiff(String string, String string2, String string3, String string4) {
        Date date = null;
        try {
            date = this.timestampSDF.parse(string + " " + string2);
        }
        catch (ParseException parseException) {
            this.printOut("ERROR: could not parse system timestamp '" + string + " " + string2 + "' : " + parseException.toString());
            return Long.MAX_VALUE;
        }
        Date date2 = null;
        try {
            date2 = this.timestampSDF.parse(string3 + " " + string4);
        }
        catch (ParseException parseException) {
            this.printOut("ERROR: could not parse date2 timestamp '" + string3 + " " + string4 + "' : " + parseException.toString());
            return Long.MAX_VALUE;
        }
        long l = date.getTime() - date2.getTime();
        return l;
    }

    protected void addToSortedList(ArrayList arrayList, int n, ArrayList arrayList2) {
        this.addToSortedList(arrayList, n, arrayList2, 3);
    }

    protected void addToSortedList(ArrayList arrayList, int n, ArrayList arrayList2, int n2) {
        try {
            Double d = (Double)arrayList2.get(n);
            Double d2 = null;
            ArrayList arrayList3 = null;
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList3 = (ArrayList)arrayList.get(i);
                d2 = (Double)arrayList3.get(n);
                if (!(d > d2)) continue;
                arrayList.set(i, arrayList2);
                this.addToSortedList(arrayList, n, arrayList3, n2);
                bl = true;
                break;
            }
            if (!bl) {
                if (n2 > 0) {
                    if (arrayList.size() < n2) {
                        arrayList.add(arrayList2);
                    }
                } else {
                    arrayList.add(arrayList2);
                }
            }
            if (n2 > 0 && arrayList.size() > n2) {
                arrayList.remove(n2);
            }
        }
        catch (Exception exception) {
            this.printOut("ERROR : Error in addToSortedList method : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "ERROR : Error in addToSortedList method : " + exception.toString());
        }
    }

    private void testGetDateDiff() {
        ArrayList arrayList = this.getSystemTimestamp();
        long l = 0L;
        l = this.getDateDiff(arrayList, "20130923", "143000");
        this.printOut("Millis Diff for 20130923 143000 = " + l);
        l = this.getDateDiff(arrayList, "20130923", "160000");
        this.printOut("Millis Diff for 20130923 160000 = " + l);
        if (l == Long.MAX_VALUE) {
            this.printOut("Millis Diff = found to be incorrect");
        } else {
            this.printOut("Millis Diff  = " + l);
        }
    }

    protected boolean isClassifiedActive(ArrayList arrayList, String string, long l) {
        if (arrayList == null) {
            return false;
        }
        Object var5_4 = null;
        Date date = null;
        long l2 = this.getDateDiff(arrayList, (String)arrayList.get(0), string);
        if (l2 < 0L) {
            ArrayList arrayList2 = (ArrayList)arrayList.clone();
            try {
                date = this.timestampSDF.parse((String)arrayList2.get(0) + " " + string);
            }
            catch (ParseException parseException) {
                this.printOut("ERROR: could not parse timestamp '" + (String)arrayList.get(0) + " " + string + "' : " + parseException.toString());
                return false;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -1);
            this.printOut("Subtracted 1 day from user time");
            String string2 = this.dateOnlySDF.format(date);
            l2 = this.getDateDiff(arrayList, string2, string);
        }
        long l3 = l2 / 60000L;
        return l3 <= l && l3 >= 0L;
    }

    public void pingDestination() {
        JCoDestination jCoDestination = null;
        this.setSessID();
        try {
            this.runThread(new ContextManager(this.sessID, this.destName, 1), "Begin Context");
        }
        catch (Exception exception) {
            this.printOut("ERROR", this.entity + "  " + this.thisServer, "Exception while beginning context : " + exception.toString());
            return;
        }
        SessRef sessRef = new SessRef(this.sessID);
        MonitoredThread.tl_currSessRef.set(sessRef);
        try {
            jCoDestination = JCoDestinationManager.getDestination((String)this.destName);
        }
        catch (Exception exception) {
            this.printOut("ERROR", this.entity + "  " + this.thisServer, "Error while getting destination " + this.destName + " : " + exception.toString());
            return;
        }
        this.printOut("INFO", this.entity + "  " + this.thisServer, "Obtained destination config object");
        try {
            jCoDestination.ping();
        }
        catch (Exception exception) {
            this.printOut("ERROR", this.entity + "  " + this.thisServer, "Error while pinging destination " + this.destName + " : " + exception.toString());
        }
        try {
            this.runThread(new ContextManager(this.sessID, this.destName, 2), "End Context");
        }
        catch (Exception exception) {
            this.printOut("ERROR", this.entity + "  " + this.thisServer, "Error while ending context  : " + exception.toString());
            return;
        }
        this.printOut("INFO", this.entity + "  " + this.thisServer, "Destination " + this.destName + " is available");
    }

    public int findNumProcessors() {
        int n = 1;
        try {
            String string = System.getProperty("os.name");
            if (this.targetOS == null || this.targetOS.trim().length() == 0 || this.targetOS.equalsIgnoreCase("none")) {
                this.targetOS = string;
            }
            n = this.targetOS.trim().toLowerCase().indexOf("win") != -1 ? this.getNumProcessorsInWindows(this.targetOS, this.meAgentless) : (this.targetOS.trim().toLowerCase().indexOf("hpux") != -1 ? this.getNumProcessorsInHPUX() : this.getNumProcessorsInUnix());
        }
        catch (Exception exception) {
            this.printOut("Exception raised inside findNumofProcessors");
            this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, "Exception raised inside findNumOfProcessors  method " + exception.toString());
        }
        if (n < 1) {
            this.printOut("Num Processors : 1");
            return 1;
        }
        this.printOut("Num Processors : " + n);
        return n;
    }

    private int getNumProcessorsInWindows(String string, boolean bl) {
        try {
            if (string != null) {
                string = string.trim().toLowerCase();
            }
            int n = 0;
            String[] stringArray = null;
            if (string.indexOf("2008") > -1 || string.indexOf("2012") > -1 || string.indexOf("win7") > -1 || string.indexOf("win8") > -1) {
                stringArray = bl ? EgJNIUtil.discoverPdhInstances((String)"Processor Information", (String)this.appSrvr) : EgJNIUtil.discoverInstances((String)"Processor Information", (boolean)false);
                if (stringArray != null && stringArray.length > 0) {
                    String string2 = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string2 = stringArray[i];
                        if (string2 == null || string2.trim().toLowerCase().indexOf("total") != -1) continue;
                        ++n;
                    }
                }
            } else if (string.indexOf("win") != -1 && (stringArray = bl ? EgJNIUtil.discoverPdhInstances((String)"Processor", (String)this.appSrvr) : EgJNIUtil.discoverInstances((String)"Processor", (boolean)false)) != null && stringArray.length > 0) {
                String string3 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = stringArray[i];
                    if (string3 == null || string3.trim().toLowerCase().indexOf("total") != -1) continue;
                    ++n;
                }
            }
            this.printOut("No of Processors  :" + n);
            this.printOut("agentless         :" + bl);
            if (n < 1) {
                return 1;
            }
            return n;
        }
        catch (Exception exception) {
            this.printOut("Exception raised inside findNumofProcessors (windows)");
            this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, "Exception raised inside findNumOfProcessors  method (windows) " + exception.toString());
            return 1;
        }
    }

    private int getNumProcessorsInHPUX() {
        try {
            ArrayList arrayList = this.egutil.getExecOutputLines("/usr/sbin/ioscan -fkn -C processor");
            if (arrayList == null || arrayList.size() < 2) {
                return 1;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return 1;
            }
            int n = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string = (String)arrayList2.get(i);
                if (!(string = string.toLowerCase()).startsWith("processor")) continue;
                ++n;
            }
            if (n == 0) {
                return 1;
            }
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public int getNumProcessorsInUnix() {
        try {
            String string = "cat /proc/cpuinfo | grep processor | wc -l";
            ArrayList arrayList = this.egutil.getExecOutputLines(string);
            if (arrayList == null || arrayList.size() < 2) {
                return 1;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return 1;
            }
            int n = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (string2 == null) continue;
                string2 = string2.trim();
                n = Integer.parseInt(string2);
            }
            if (n == 0) {
                return 1;
            }
            return n;
        }
        catch (Exception exception) {
            this.printOut("Exception raised inside findNumofProcessors (unix)");
            this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, "Exception raised inside findNumOfProcessors  method (unix) " + exception.toString());
            return 1;
        }
    }

    protected String convertTimeStampForEG(String string) {
        String string2 = "";
        if (string.trim().length() < 2) {
            this.printOut("Warning : Could not convert timestamp '" + string + "'");
            return string2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in convertTimeStampForEG()  :" + exception.toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in convertTimeStampForEG()  :" + exception.toString());
        }
        return string2;
    }

    protected String convertDateOnlyFormatEG(String string) {
        String string2 = "";
        if (string.trim().length() < 1) {
            this.printOut("Warning : Could not convert date '" + string + "'");
            return string2;
        }
        if (string.trim().equals("_")) {
            this.printOut("Warning : Could got empty date for DD '" + string + "'");
            return "-";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in convertDateOnlyFormatEG()  :" + exception.toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in convertDateOnlyFormatEG()  :" + exception.toString());
        }
        return string2;
    }

    protected String convertTimeOnlyFormatEG(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        String string2 = "";
        if (string.length() < 2) {
            return string2;
        }
        if (string.trim().equals("_")) {
            return "-";
        }
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
            string2 = string2.substring("MM/dd/yyyy".length() + 1);
            string2 = string2.trim();
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in convertTimeOnlyFormatEG()  :" + exception.toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in convertTimeOnlyFormatEG()  :" + exception.toString());
        }
        return string2;
    }

    protected long timeStampToMillsecond(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        long l = this.timeStampToMillsecond(string, simpleDateFormat);
        simpleDateFormat = null;
        return l;
    }

    protected long timeStampToMillsecond(String string, SimpleDateFormat simpleDateFormat) {
        long l = 0L;
        try {
            Date date = simpleDateFormat.parse(string);
            l = date.getTime();
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in timeStampToMillsecond()  :" + exception.getMessage().toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in timeStampToMillsecond()  :" + exception.getMessage().toString());
        }
        return l;
    }

    protected boolean getConnection() {
        boolean bl = false;
        JCoDestination jCoDestination = AsAbapJco3Base.getDestination(this.destName);
        if (jCoDestination == null) {
            return false;
        }
        bl = true;
        return bl;
    }

    protected double roundDouble(double d, int n) {
        Object object;
        double d2 = 0.0;
        Object object2 = "";
        if (n <= 0) {
            object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
        } else {
            String string;
            object = "";
            if (d < 0.0) {
                object = (String)object + "-";
                d = -d;
            }
            if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                int n2 = (int)d;
                object = (String)object + n2;
                d -= (double)n2;
            } else {
                object = (String)object + "0";
            }
            if (d > 0.0) {
                String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                object = (String)object + "." + string2.substring(1);
            }
            object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
        }
        object = new Double((String)object2);
        d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        return d2;
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    protected String getDDStringFromTable(JCoTable jCoTable, String string) {
        String string2 = jCoTable.getString(string);
        if (string2 == null) {
            return "-";
        }
        if ((string2 = string2.trim()).length() == 0) {
            return "-";
        }
        return string2;
    }

    protected int getIntFromTable(JCoTable jCoTable, String string) {
        return this.getIntFromTable(jCoTable, string, -5);
    }

    protected int getIntFromTable(JCoTable jCoTable, String string, int n) {
        int n2 = n;
        try {
            n2 = jCoTable.getInt(string);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from table " + jCoTable.getMetaData().getName() + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Could not obtain field " + string + " from table " + jCoTable.getMetaData().getName() + " : " + exception.toString());
            n2 = n;
        }
        return n2;
    }

    public String removePrefixSuffix(String string, String string2, boolean bl) {
        if ((string = string.trim()).length() == 2 * string2.length()) {
            if (bl) {
                return "-";
            }
            return "";
        }
        if (string.startsWith(string2)) {
            string = string.substring(1);
        }
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getTCodeDesc(String string) {
        String string2 = (String)ht_TCodeMap.get(string);
        return string2;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt((String)stringArray[i + 1]);
            break;
        }
        AsAbapJco3Base asAbapJco3Base = new AsAbapJco3Base(stringArray);
        asAbapJco3Base.decryptPassword();
        for (int i = 0; i < 3; ++i) {
            asAbapJco3Base.printOut("Current System time is " + asAbapJco3Base.getSystemTimestamp());
            if (i == 2) {
                instanceSyncHashtable.put(asAbapJco3Base.thisServer, asAbapJco3Base.unknown_inst);
                System.out.println("instance name set to unknown");
            }
            AsAbapJco3Base.printDestnStats(AsAbapJco3Base.getDestination(asAbapJco3Base.destName));
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            asAbapJco3Base.setInstanceName();
            System.out.println("instance name is " + asAbapJco3Base.getInstanceName());
        }
    }

    private String collectInstanceName() {
        try {
            System.out.println("Calling collectInstanceName method in Asabap base");
            String string = "TH_SERVER_LIST";
            JCoDestination jCoDestination = null;
            try {
                jCoDestination = JCoDestinationManager.getDestination((String)this.destName);
            }
            catch (Exception exception) {
                this.printOut("ERROR : Exception while getting destination with name " + this.destName + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Exception while getting destination with name " + this.destName + " : " + exception.toString());
                return this.unknown_inst;
            }
            this.printOut("DEBUG : Got destination " + this.destName);
            JCoFunction jCoFunction = null;
            try {
                jCoFunction = jCoDestination.getRepository().getFunction(string);
            }
            catch (Exception exception) {
                this.printOut("ERROR : Exception while getting " + string + " function for destination name " + this.destName + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity + " " + this.thisServer, "Exception while getting " + string + " function for destination name " + this.destName + " : " + exception.toString());
                return this.unknown_inst;
            }
            if (jCoFunction == null) {
                return this.unknown_inst;
            }
            long l = System.currentTimeMillis();
            try {
                this.setSessID();
                this.executeFunction(jCoFunction, false);
            }
            catch (Exception exception) {
                this.printOut("Error : Exception while executing " + string + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity + " : " + this.thisServer, "Exception while executing " + string + " : " + exception.toString());
                exception.printStackTrace();
                return this.unknown_inst;
            }
            this.endSession();
            this.printOut("DEBUG : " + string + " successfully executed in " + (System.currentTimeMillis() - l) + " ms.");
            String string2 = this.unknown_inst;
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("LIST");
            String string3 = null;
            if (jCoTable != null && jCoTable.getNumRows() == 0) {
                this.printOut("ERROR : main LIST table empty while trying to get instance list. Trying LIST_IPV6 table instead");
                this.logToErrorFile("ERROR", this.entity, "main LIST table empty while trying to get instance list. Trying LIST_IPV6 table instead");
                jCoTable = jCoFunction.getTableParameterList().getTable("LIST_IPV6");
            }
            this.printOut("Table is :" + jCoTable);
            String string4 = "";
            if (this.connectionType.equalsIgnoreCase("group_server")) {
                if (this.isIPAddress(this.msgSrvr)) {
                    string4 = AsAbapJco3Base.getHostName(this.msgSrvr).toLowerCase();
                }
            } else if (this.isIPAddress(this.appSrvr)) {
                string4 = AsAbapJco3Base.getHostName(this.appSrvr).toLowerCase();
            }
            for (int i = 0; i < jCoTable.getNumRows(); ++i) {
                jCoTable.setRow(i);
                string3 = jCoTable.getString("NAME").trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "_");
                String string5 = "";
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    if (bl) continue;
                    string5 = stringTokenizer.nextToken().toLowerCase();
                    break;
                }
                if (this.connectionType.equalsIgnoreCase("group_server") && string3 != null && string3.length() > 0) {
                    string2 = string3;
                    break;
                }
                this.printOut("strHostName : " + string4);
                if (string4 == null || string4.equalsIgnoreCase("") || this.isIPAddress(string4)) {
                    this.printOut("strHostName if ");
                    if (string3.indexOf(this.sysnr) <= -1) continue;
                    string2 = string3;
                    break;
                }
                this.printOut("strHostName else ");
                if (string3.indexOf(this.sysnr) <= -1 || string4.indexOf(string5) <= -1) continue;
                string2 = string3;
                break;
            }
            this.printOut("DEBUG : Determined instance name as " + string2);
            this.instanceName = string2;
            return string2;
        }
        catch (Exception exception) {
            this.printOut("Error : Exception while executing collectInstanceName method : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + " : " + this.thisServer, "Exception while executing collectInstanceName method : " + exception.toString());
            exception.printStackTrace();
            return this.unknown_inst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstanceName() {
        String string = this.getInstanceName();
        if (!(string == null || string.equalsIgnoreCase("none") || string.equalsIgnoreCase("default") || string.equalsIgnoreCase(this.unknown_inst))) {
            this.printOut("Instance name already set");
            return;
        }
        String string2 = instanceSyncString1;
        synchronized (string2) {
            String string3 = null;
            string3 = (String)instanceSyncHashtable.get(this.thisServer);
            String string4 = this.collectInstanceName();
            this.printOut("Calling setInstanceName method in Asabap base:" + string4);
            instanceSyncHashtable.put(this.thisServer, new String(string4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getInstanceName() {
        String string = null;
        String string2 = instanceSyncString1;
        synchronized (string2) {
            string = (String)instanceSyncHashtable.get(this.thisServer);
            if (string != null && string.equalsIgnoreCase("unknown")) {
                String string3 = this.collectInstanceName();
                this.printOut("Calling getInstanceName method in Asabap base,old instances name: " + string + ",new instance name:" + string3);
                instanceSyncHashtable.put(this.thisServer, new String(string3));
                string = string3;
            }
            this.printOut("Calling getInstanceName method in Asabap base instName:" + string);
        }
        return string;
    }

    public String getErrorMsgForValidation() {
        this.printOut("Calling getErrorMsgForValidation method in Asabap base errorMsgForValidation:" + this.errorMsgForValidation);
        return this.errorMsgForValidation;
    }

    public void setErrorMsgForValidation(String string) {
        this.errorMsgForValidation = string;
    }

    public String getInstanceNameForValidation() {
        this.printOut("Calling getInstanceNameForValidation method in Asabap base instanceNameForValidation:" + this.instanceNameForValidation);
        return this.instanceNameForValidation;
    }

    public void setInstanceNameForValidation(String string) {
        this.instanceNameForValidation = string;
    }

    static {
        ht_SapTimeCal = new Hashtable();
        ht_GetTimeMillis = new Hashtable();
        ht_QueryTimeMillis = new Hashtable();
        DestDataPrvdr = new AsAbapDdp();
        SessRefPrvdr = new AsAbapSrp();
        fieldSep = new String("");
        ht_NumCPUs = new Hashtable();
        errCodeTbl = new Hashtable();
        errCodeTbl.put("RA 334", "The specified alert ID is not defined");
        errCodeTbl.put("RA 335", "The specified alert ID is invalid");
        errCodeTbl.put("RA 336", "The C function that was ultimately called could not be exe-cuted");
        errCodeTbl.put("RA 337", "The method could not be executed due to communication problems (you should possibly check the network connection)");
        errCodeTbl.put("RA 338", "An internal problem occurred");
        errCodeTbl.put("RA 339", "The specified TID is not defined");
        errCodeTbl.put("RA 340", "The specified TID is invalid");
        errCodeTbl.put("RA 341", "An unknown problem occurred during the execution of the method");
        errCodeTbl.put("RA 342", "The underlying function call could not be performed (the func-tion parameters may be incorrectly set)");
        errCodeTbl.put("RA 343", "The required segment is not available");
        errCodeTbl.put("RA 344", "Could not expand the name of the MTE");
        errCodeTbl.put("RA 345", "The name of the MTE was note found");
        errCodeTbl.put("RA 346", "There was a problem accessing the database");
        errCodeTbl.put("RA 347", "The specified time range is invalid");
        errCodeTbl.put("RA 350", "No monitor sets were found");
        errCodeTbl.put("RA 351", "The name of the monitor set was not specified");
        errCodeTbl.put("RA 352", "The name of the monitor set is incorrect");
        errCodeTbl.put("RA 353", "The specified monitor set is empty or contains no monitors");
        errCodeTbl.put("RA 354", "The (display) properties could not be determined");
        errCodeTbl.put("RA 355", "The name of the monitor was not specified");
        errCodeTbl.put("RA 356", "The name of the monitor is invalid");
        errCodeTbl.put("RA 357", "The required data could not be read from the database");
        errCodeTbl.put("RA 361", "The monitor template is not defined");
        errCodeTbl.put("RA 362", "The monitoring tree could not be determined");
        errCodeTbl.put("RA 593", "The monitoring tree elements of the monitoring tree were not specified");
        errCodeTbl.put("RA 594", "One of the specified top nodes is invalid");
        errCodeTbl.put("RA 595", "The alert data could not be collected");
        errCodeTbl.put("RA 594", "One of the specified monitoring tree elements is invalid");
        errCodeTbl.put("RA 596", "No alerts were found");
        errCodeTbl.put("RA 377", "The requests for history data were not defined");
        errCodeTbl.put("RA 378", "An invalid type of history data was requested");
        errCodeTbl.put("RA 379", "An invalid time range was defined for history data");
        errCodeTbl.put("RA 380", "The time range was not defined");
        errCodeTbl.put("RA 381", "An error occurred while accessing another SAP R/3 System");
        errCodeTbl.put("RA 404", "The system ID was not specified");
        errCodeTbl.put("RA 405", "The name of the context was not specified");
        errCodeTbl.put("RA 406", "The specified variant is not defined");
        errCodeTbl.put("RA 407", "The specified user is not the owner of the variant");
        errCodeTbl.put("RA 408", "The Customizing settings of the specified system cannot be changed from this system");
        errCodeTbl.put("RA 409", "No data available for the MTE class of the MTE");
        errCodeTbl.put("RA 410", "No TID-specific data available for the MTE");
        errCodeTbl.put("RA 422", "The specified variant could not be created");
        errCodeTbl.put("RA 495", "You are not authorized to use the specified function");
        errCodeTbl.put("XM 048", "The name of the external user was not specified in the call. This name specifies which user started the method call in the external system");
        errCodeTbl.put("XM 031", "The method call was terminated due to an error in the SAP R/3 XMI logging system");
        errCodeTbl.put("XM 028", "The external system management tool did not log on to the CCMS XMI interface. The method call was therefore termi-nated");
        ht_TCodeMap.put("RFC", "RFC - Remote Function Call");
    }

    static class AsAbapSrp
    implements SessionReferenceProvider {
        AsAbapSrp() {
        }

        public JCoSessionReference getCurrentSessionReference(String string) {
            SessRef sessRef = (SessRef)MonitoredThread.tl_currSessRef.get();
            if (sessRef == null) {
                System.out.println(Thread.currentThread().getName() + " ERROR : Could not get session reference for this thread!");
                return null;
            }
            return sessRef;
        }

        public boolean isSessionAlive(String string) {
            System.out.println("JCO runtime is checking if session '" + string + "' is alive.");
            String string2 = null;
            Enumeration enumeration = JFnThread.ht_CurrSessRefs.keys();
            boolean bl = false;
            while (!bl && enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string2.equals(string)) continue;
                bl = true;
            }
            if (bl) {
                System.out.println("JCO runtime found that session '" + string + "' is alive.");
            } else {
                System.out.println("JCO runtime found that session '" + string + "' is NOT alive.");
            }
            return bl;
        }

        public void jcoServerSessionContinued(String string) throws SessionException {
        }

        public void jcoServerSessionFinished(String string) {
        }

        public void jcoServerSessionPassivated(String string) throws SessionException {
        }

        public JCoSessionReference jcoServerSessionStarted() throws SessionException {
            return null;
        }
    }

    static class AsAbapDdp
    implements DestinationDataProvider {
        private DestinationDataEventListener DestDataEvtLstnr;
        private Hashtable destnTbl = new Hashtable();

        AsAbapDdp() {
        }

        public Properties getDestinationProperties(String string) {
            String string2 = string;
            synchronized (string2) {
                System.out.println("DEBUG : static : Synch block - Getting destination properties for destination " + string);
                try {
                    Properties properties = (Properties)this.destnTbl.get(string);
                    if (properties == null || properties.isEmpty()) {
                        System.out.println("ERROR : static : Destination properties for " + string + " were empty or null.");
                        throw new DataProviderException(DataProviderException.Reason.INVALID_CONFIGURATION, "Destination configuration nonexistant/incorrect", null);
                    }
                    return properties;
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("ERROR : static : Runtime error while getting destination properties for destination " + string + " : " + runtimeException.toString());
                    throw new DataProviderException(DataProviderException.Reason.INTERNAL_ERROR, (Throwable)runtimeException);
                }
            }
        }

        public boolean supportsEvents() {
            return true;
        }

        public void setDestinationDataEventListener(DestinationDataEventListener destinationDataEventListener) {
            System.out.println("DEBUG : static : JCO Runtime has set Destination Data Event Listener");
            this.DestDataEvtLstnr = destinationDataEventListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAndUpdateDestination(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
            String string13 = string;
            synchronized (string13) {
                System.out.println("DEBUG : static : Sync-Block - executing checkAndUpdateDestination for destn : " + string);
                Properties properties = (Properties)this.destnTbl.get(string);
                if (properties == null) {
                    properties = new Properties();
                    this.destnTbl.put(string, properties);
                }
                boolean bl = false;
                String string14 = null;
                string14 = properties.getProperty("jco.client.ashost");
                if (string14 == null || !string14.equalsIgnoreCase(string6)) {
                    bl = true;
                    properties.setProperty("jco.client.ashost", string6);
                    System.out.println("INFO : static : Conn property JCO_ASHOST changed to " + string6);
                }
                if ((string14 = properties.getProperty("jco.client.sysnr")) == null || !string14.equalsIgnoreCase(string4)) {
                    bl = true;
                    properties.setProperty("jco.client.sysnr", string4);
                    System.out.println("INFO : static : Conn property JCO_SYSNR changed to " + string4);
                }
                if ((string14 = properties.getProperty("jco.client.client")) == null || !string14.equalsIgnoreCase(string5)) {
                    bl = true;
                    properties.setProperty("jco.client.client", string5);
                    System.out.println("INFO : static : Conn property JCO_CLIENT changed to " + string5);
                }
                if ((string14 = properties.getProperty("jco.client.user")) == null || !string14.equalsIgnoreCase(string2)) {
                    bl = true;
                    properties.setProperty("jco.client.user", string2);
                    System.out.println("INFO : static : Conn property JCO_USER changed to " + string2);
                }
                if ((string14 = properties.getProperty("jco.client.passwd")) == null || !string14.equalsIgnoreCase(string3)) {
                    bl = true;
                    properties.setProperty("jco.client.passwd", string3);
                    System.out.println("INFO : static : Conn property JCO_PASSWD changed.");
                }
                string14 = properties.getProperty("jco.client.saprouter");
                if (!(string7.equalsIgnoreCase("none") || string14 != null && string14.equalsIgnoreCase(string7))) {
                    bl = true;
                    properties.setProperty("jco.client.saprouter", string7);
                    System.out.println("INFO : static : Conn property JCO_SAPROUTER changed to " + string7);
                }
                if ((string14 = properties.getProperty("jco.destination.peak_limit")) == null || !string14.equalsIgnoreCase(string8)) {
                    bl = true;
                    properties.setProperty("jco.destination.peak_limit", string8);
                    System.out.println("INFO : static : Conn property JCO_PEAK_LIMIT changed to " + string8);
                }
                if ((string14 = properties.getProperty("jco.destination.pool_capacity")) == null || !string14.equalsIgnoreCase(string11)) {
                    bl = true;
                    properties.setProperty("jco.destination.pool_capacity", string11);
                    System.out.println("INFO : static : Conn property JCO_POOL_CAPACITY changed to " + string11);
                }
                if ((string14 = properties.getProperty("jco.destination.expiration_time")) == null || !string14.equalsIgnoreCase(string9)) {
                    bl = true;
                    properties.setProperty("jco.destination.expiration_time", string9);
                    System.out.println("INFO : static : Conn property JCO_EXPIRATION_TIME changed to " + string9);
                }
                if ((string14 = properties.getProperty("jco.destination.expiration_check_period")) == null || !string14.equalsIgnoreCase(string10)) {
                    bl = true;
                    properties.setProperty("jco.destination.expiration_check_period", string10);
                    System.out.println("INFO : static : Conn property JCO_EXPIRATION_PERIOD changed to " + string10);
                }
                if ((string14 = properties.getProperty("jco.destination.max_get_client_time")) == null || !string14.equalsIgnoreCase(string12)) {
                    bl = true;
                    properties.setProperty("jco.destination.max_get_client_time", string12);
                    System.out.println("INFO : static : Conn property JCO_MAX_GET_TIME changed to " + string12);
                }
                if (bl) {
                    System.out.println("INFO : static : Sending updated event for event listener >>>>> " + string);
                    this.DestDataEvtLstnr.updated(string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAndUpdateDestinationLogonGroup(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
            String string14 = string;
            synchronized (string14) {
                System.out.println("DEBUG : static : Sync-Block - executing checkAndUpdateDestination for destn : " + string);
                Properties properties = (Properties)this.destnTbl.get(string);
                if (properties == null) {
                    properties = new Properties();
                    this.destnTbl.put(string, properties);
                }
                boolean bl = false;
                String string15 = null;
                string15 = properties.getProperty("jco.client.mshost");
                if (string15 == null || !string15.equalsIgnoreCase(string5)) {
                    bl = true;
                    properties.setProperty("jco.client.mshost", string5);
                    System.out.println("INFO : static : Conn property JCO_MSHOST changed to " + string5);
                }
                if ((string15 = properties.getProperty("jco.client.r3name")) == null || !string15.equalsIgnoreCase(string6)) {
                    bl = true;
                    properties.setProperty("jco.client.r3name", string6);
                    System.out.println("INFO : static : Conn property JCO_R3NAME changed to " + string6);
                }
                if ((string15 = properties.getProperty("jco.client.group")) == null || !string15.equalsIgnoreCase(string7)) {
                    bl = true;
                    properties.setProperty("jco.client.group", string7);
                    System.out.println("INFO : static : Conn property JCO_GROUP changed to " + string7);
                }
                if ((string15 = properties.getProperty("jco.client.client")) == null || !string15.equalsIgnoreCase(string4)) {
                    bl = true;
                    properties.setProperty("jco.client.client", string4);
                    System.out.println("INFO : static : Conn property JCO_CLIENT changed to " + string4);
                }
                if ((string15 = properties.getProperty("jco.client.user")) == null || !string15.equalsIgnoreCase(string2)) {
                    bl = true;
                    properties.setProperty("jco.client.user", string2);
                    System.out.println("INFO : static : Conn property JCO_USER changed to " + string2);
                }
                if ((string15 = properties.getProperty("jco.client.passwd")) == null || !string15.equalsIgnoreCase(string3)) {
                    bl = true;
                    properties.setProperty("jco.client.passwd", string3);
                    System.out.println("INFO : static : Conn property JCO_PASSWD changed.");
                }
                string15 = properties.getProperty("jco.client.saprouter");
                if (!(string8.equalsIgnoreCase("none") || string15 != null && string15.equalsIgnoreCase(string8))) {
                    bl = true;
                    properties.setProperty("jco.client.saprouter", string8);
                    System.out.println("INFO : static : Conn property JCO_SAPROUTER changed to " + string8);
                }
                if ((string15 = properties.getProperty("jco.destination.peak_limit")) == null || !string15.equalsIgnoreCase(string9)) {
                    bl = true;
                    properties.setProperty("jco.destination.peak_limit", string9);
                    System.out.println("INFO : static : Conn property JCO_PEAK_LIMIT changed to " + string9);
                }
                if ((string15 = properties.getProperty("jco.destination.pool_capacity")) == null || !string15.equalsIgnoreCase(string12)) {
                    bl = true;
                    properties.setProperty("jco.destination.pool_capacity", string12);
                    System.out.println("INFO : static : Conn property JCO_POOL_CAPACITY changed to " + string12);
                }
                if ((string15 = properties.getProperty("jco.destination.expiration_time")) == null || !string15.equalsIgnoreCase(string10)) {
                    bl = true;
                    properties.setProperty("jco.destination.expiration_time", string10);
                    System.out.println("INFO : static : Conn property JCO_EXPIRATION_TIME changed to " + string10);
                }
                if ((string15 = properties.getProperty("jco.destination.expiration_check_period")) == null || !string15.equalsIgnoreCase(string11)) {
                    bl = true;
                    properties.setProperty("jco.destination.expiration_check_period", string11);
                    System.out.println("INFO : static : Conn property JCO_EXPIRATION_PERIOD changed to " + string11);
                }
                if ((string15 = properties.getProperty("jco.destination.max_get_client_time")) == null || !string15.equalsIgnoreCase(string13)) {
                    bl = true;
                    properties.setProperty("jco.destination.max_get_client_time", string13);
                    System.out.println("INFO : static : Conn property JCO_MAX_GET_TIME changed to " + string13);
                }
                if (bl) {
                    System.out.println("INFO : static : Sending updated event for event listener >>>>> " + string);
                    this.DestDataEvtLstnr.updated(string);
                }
            }
        }
    }

    static class SessRef
    implements JCoSessionReference {
        String id = null;

        SessRef(String string) {
            this.id = string;
        }

        public void contextFinished() {
            System.out.println("INFO : Stateful Session with ID '" + this.id + "' has ended.");
        }

        public void contextStarted() {
            System.out.println("INFO : Stateful Session with ID '" + this.id + "' has started.");
        }

        public String getID() {
            return this.id;
        }
    }

    protected class JFnThread
    extends MonitoredThread {
        JCoDestination thisDestn;
        final JCoFunction jFn;
        boolean checkErr;

        JFnThread(JCoFunction jCoFunction, boolean bl, String string, String string2) {
            super(string, string2);
            this.thisDestn = null;
            this.checkErr = true;
            this.jFn = jCoFunction;
            this.checkErr = bl;
            System.out.println("DEBUG : Trying out function " + jCoFunction.getName() + " with session ID " + AsAbapJco3Base.this.sessID + " for destination " + this.monitor_destName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            try {
                this.checkAndRegisterSession();
                this.thisDestn = AsAbapJco3Base.getDestination(this.monitor_destName);
                if (this.thisDestn == null) {
                    this.errMsg = "Could not obtain destination instance.";
                    this.status = -1;
                    return;
                }
                this.jFn.execute(this.thisDestn);
                if (this.checkErr) {
                    JCoStructure jCoStructure = this.jFn.getExportParameterList().getStructure("RETURN");
                    String string = jCoStructure.getString("TYPE").trim();
                    if (string.length() > 0 && !string.equals("S") && !string.equals("I")) {
                        String string2 = jCoStructure.getString("ID") + " " + jCoStructure.getString("NUMBER");
                        if (string2.equals("RA 340")) {
                            this.status = 1;
                        } else {
                            String string3;
                            this.errMsg = string3 = jCoStructure.getString("MESSAGE") + "." + (String)errCodeTbl.get(string2);
                            AsAbapJco3Base.this.printOut("ERROR : BAPI method " + this.jFn.getName() + " did not execute successfully : " + string3);
                            this.status = -1;
                        }
                    } else {
                        this.status = 1;
                    }
                } else {
                    this.status = 1;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while executing JCO function " + this.jFn.getName() + " : " + exception.toString());
                AsAbapJco3Base.this.logToErrorFile("ERROR", AsAbapJco3Base.this.entity + " : " + AsAbapJco3Base.this.thisServer, " Exception while executing JCO function " + this.jFn.toString() + " : " + exception.toString());
                this.errMsg = "Exception while executing JCO function " + this.jFn.getName() + " : " + exception.toString() + " : ";
                this.excpn = exception;
                this.status = -1;
            }
            finally {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 > 5000L) {
                    AsAbapJco3Base.this.printOut("Function " + this.jFn.getName() + " took more than 5 seconds to execute. Actual time taken = " + l3 + " ms.");
                }
            }
        }
    }

    protected class ContextManager
    extends MonitoredThread {
        public static final int BEGIN = 1;
        public static final int END = 2;
        int action;

        ContextManager(String string, String string2, int n) {
            super(string, string2);
            this.action = 0;
            this.action = n;
            this.status = 0;
            System.out.println("Instantiating context Manager thread with session " + string + " and command " + this.getCmdDesc());
        }

        String getCmdDesc() {
            if (this.action == 1) {
                return "Context begin";
            }
            return "Context end";
        }

        public void run() {
            this.checkAndRegisterSession();
            System.out.println("INFO Context Manager thread running with command '" + this.getCmdDesc() + "'");
            if (this.action == 1) {
                AsAbapJco3Base.beginContext(AsAbapJco3Base.this.destName);
            } else {
                AsAbapJco3Base.endContext(AsAbapJco3Base.this.destName);
            }
            this.status = 1;
        }
    }

    protected static abstract class MonitoredThread
    extends Thread {
        protected static final int ERR = -1;
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected int status = 0;
        protected String errMsg;
        protected Exception excpn;
        protected static ThreadLocal tl_currSessRef = new ThreadLocal();
        public static final Hashtable ht_CurrSessRefs = new Hashtable();
        private String sessID = null;
        protected String monitor_destName = null;

        MonitoredThread(String string, String string2) {
            this.sessID = string;
            this.monitor_destName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkAndRegisterSession() {
            if (ht_CurrSessRefs.get(this.sessID) == null) {
                String string = this.sessID;
                synchronized (string) {
                    if (ht_CurrSessRefs.get(this.sessID) == null) {
                        SessRef sessRef = new SessRef(this.sessID);
                        ht_CurrSessRefs.put(this.sessID, sessRef);
                        tl_currSessRef.set(sessRef);
                        System.out.println("INFO New Session '" + this.sessID + "' has been created for thread " + Thread.currentThread().getName());
                    }
                }
            } else {
                SessRef sessRef = (SessRef)ht_CurrSessRefs.get(this.sessID);
                tl_currSessRef.set(sessRef);
                System.out.println("INFO Existing Session '" + this.sessID + "' has been set for thread " + Thread.currentThread().getName());
            }
        }
    }
}

