/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public abstract class AMHBase
extends JVMInstrumentation {
    protected static final String JmsConnectionPrefix = "amh:name=amh.jms.connection.";
    protected static final String InputChannelPrefix = "amh:name=amh.inputChannel.";
    protected static final String JmsQueuePrefix = "amh:name=amh.jms.queue.";
    protected static final String CryptoServicePrefix = "amh:name=amh.service.Crypto.";
    protected static final String FileServicePrefix = "amh:name=amh.service.File.";
    protected static final String JmsServicePrefix = "amh:name=amh.service.JMS.";
    protected static final String ProcessingQueuePrefix = "amh:name=amh.service.ProcessingQueue.";
    protected static final String SAGClusterPrefix = "amh:name=amh.service.SAG-Cluster.";
    protected static final String SealQueueBulkPrefix = "amh:name=amh.service.SealQueue-Bulk.";
    protected static final String SNFInputChannelPrefix = "amh:name=amh.service.SnF-InputChannel.";
    protected static final String SNFQueueServicePrefix = "amh:name=amh.service.SnF-Queue.";
    protected static final String SNFQueueMsgPrefix = "amh:name=amh.snfQueue.";
    protected static final String SwiftConnectionPrefix = "amh:name=amh.swiftConnection.";
    protected static final HashMap<String, Double> statusCodeMap = new HashMap();
    private String loggerDispStr = "[" + this.entity + "] - [" + this.reportingName + ":" + this.portNo + "] ";

    public AMHBase(String[] stringArray) {
        super(stringArray);
    }

    protected Hashtable pullCryptoServiceDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = CryptoServicePrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullFileServiceDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = FileServicePrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullInputChannelDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = InputChannelPrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullJMSQueueDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = JmsQueuePrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullJMSServiceDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = JmsServicePrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullProcessQueueDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = ProcessingQueuePrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullSAGClusterDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = SAGClusterPrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullSealQueueDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = SealQueueBulkPrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullSNFInputChannelDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = SNFInputChannelPrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullSNFQueueMsgDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = SNFQueueMsgPrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullSNFQueueSrvDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = SNFQueueServicePrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullSwiftConnDetails() {
        Hashtable hashtable = new Hashtable();
        try {
            String string = SwiftConnectionPrefix;
            Hashtable hashtable2 = this.pullAMHStatusMeasures(string);
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable = hashtable2;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullInputChannelDetails() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    protected Hashtable pullJmsConnectionDetails() {
        String string = "amh:name=amh.jms.connection.*,*";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Value");
        ArrayList arrayList2 = this.getMeasureList();
        Hashtable<String, HashMap> hashtable = new Hashtable<String, HashMap>();
        System.out.println(this.loggerDispStr + " " + string + "  " + arrayList);
        if (this.beanServerConn != null) {
            HashMap hashMap = this.getQueryNameResult(string, arrayList);
            System.out.println(this.loggerDispStr + " Source Map :" + hashMap);
            if (hashMap != null) {
                Set set = hashMap.keySet();
                for (ObjectName objectName : set) {
                    HashMap hashMap2;
                    String string2 = objectName.getKeyProperty("name");
                    if (string2 == null || string2.equals("")) continue;
                    String string3 = "amh:name=" + string2;
                    String string4 = string3.substring(JmsConnectionPrefix.length());
                    System.out.println(this.loggerDispStr + " mbeanName :" + string3 + " detailsString :" + string4);
                    int n = string4.lastIndexOf(".");
                    if (n <= 0) continue;
                    String string5 = string4.substring(n + 1);
                    System.out.println(this.loggerDispStr + " mbeanName :" + string3 + " measureName :" + string5 + " measureNameList :" + arrayList2);
                    if (!arrayList2.contains(string5)) continue;
                    String string6 = string4.substring(0, n);
                    HashMap hashMap3 = (HashMap)hashMap.get(objectName);
                    System.out.println(this.loggerDispStr + " infoName :" + string6 + " measureName --> " + string5 + "  : " + hashMap3);
                    String string7 = "-";
                    if (hashMap3.containsKey("Value")) {
                        string7 = hashMap3.get("Value");
                    }
                    if (hashtable.containsKey(string6)) {
                        hashMap2 = (HashMap)hashtable.get(string6);
                        hashMap2.put(string5, string7);
                        continue;
                    }
                    hashMap2 = new HashMap();
                    hashMap2.put(string5, string7);
                    hashtable.put(string6, hashMap2);
                }
            }
        }
        System.out.println(this.loggerDispStr + " queryStr :" + string + "  resultTable :" + hashtable);
        return hashtable;
    }

    private Hashtable pullAMHStatusMeasures(String string) {
        Hashtable<String, HashMap> hashtable = new Hashtable<String, HashMap>();
        String string2 = string.trim() + "*,*";
        try {
            if (string == null && string.trim().length() == 0) {
                return hashtable;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Value");
            System.out.println(this.loggerDispStr + "MBean :" + string2 + " AttributeList :" + arrayList);
            ArrayList arrayList2 = this.getMeasureList();
            if (this.beanServerConn != null) {
                HashMap hashMap = this.getQueryNameResult(string2, arrayList);
                System.out.println(this.loggerDispStr + " Source Map :" + hashMap);
                if (hashMap != null) {
                    Set set = hashMap.keySet();
                    for (ObjectName objectName : set) {
                        HashMap hashMap2;
                        String string3 = objectName.getKeyProperty("name");
                        if (string3 == null || string3.equals("")) continue;
                        String string4 = "amh:name=" + string3;
                        String string5 = string4.substring(string.trim().length());
                        System.out.println(this.loggerDispStr + " mbeanName :" + string4 + " detailsString :" + string5);
                        int n = string5.lastIndexOf(".");
                        if (n <= 0) continue;
                        String string6 = string5.substring(n + 1);
                        System.out.println(this.loggerDispStr + " mbeanName :" + string4 + " measureName :" + string6 + " measureNameList :" + arrayList2);
                        if (!arrayList2.contains(string6)) continue;
                        String string7 = string5.substring(0, n);
                        HashMap hashMap3 = (HashMap)hashMap.get(objectName);
                        System.out.println(this.loggerDispStr + " infoName :" + string7 + " measureName --> " + string6 + " = " + hashMap3);
                        String string8 = "-";
                        if (hashMap3.containsKey("Value")) {
                            string8 = hashMap3.get("Value");
                        }
                        if (hashtable.containsKey(string7)) {
                            hashMap2 = (HashMap)hashtable.get(string7);
                            hashMap2.put(string6, string8);
                            continue;
                        }
                        hashMap2 = new HashMap();
                        hashMap2.put(string6, string8);
                        hashtable.put(string7, hashMap2);
                    }
                }
            }
        }
        catch (Exception exception) {
            hashtable = new Hashtable();
            this.logToErrorFile("Exception", this.entity + " Exception occured in pullAMHStatusMeasures() for " + this.targetHost, exception.toString());
        }
        System.out.println(this.loggerDispStr + " queryStr :" + string2 + "  resultTable :" + hashtable);
        return hashtable;
    }

    private HashMap getQueryNameResult(String string, ArrayList arrayList) {
        HashMap hashMap = new HashMap();
        System.out.println(this.loggerDispStr + " getQueryNameResult (queryString) :" + string + "  attributeNameList :" + arrayList);
        try {
            ObjectName objectName = new ObjectName(string);
            Set<ObjectName> set = this.beanServerConn.queryNames(objectName, null);
            if (set != null && set.size() > 0) {
                Iterator<ObjectName> iterator = set.iterator();
                while (iterator.hasNext()) {
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    try {
                        ObjectName objectName2 = iterator.next();
                        System.out.println(this.loggerDispStr + " getQueryNameResult (objectName) :" + objectName2);
                        MBeanInfo mBeanInfo = this.beanServerConn.getMBeanInfo(objectName2);
                        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                        if (mBeanAttributeInfoArray == null) continue;
                        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                            String string2 = mBeanAttributeInfoArray[i].getName();
                            System.out.println(this.loggerDispStr + " getQueryNameResult (attributeName) :" + string2);
                            if (!arrayList.contains(string2)) continue;
                            try {
                                Object object = this.beanServerConn.getAttribute(objectName2, string2);
                                hashMap2.put(string2, object);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        hashMap.put(objectName2, hashMap2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(this.loggerDispStr + " getQueryNameResult (resultTable) :" + hashMap);
        return hashMap;
    }

    public double getStatus(String string) {
        double d = -5.0;
        String string2 = string.toLowerCase();
        Double d2 = statusCodeMap.get(string2);
        if (d2 != null) {
            try {
                d = d2;
            }
            catch (Exception exception) {
                System.out.println(this.loggerDispStr + " exception while fetching code for the status " + string);
            }
        } else {
            System.out.println(this.loggerDispStr + " found new status " + string);
            d = 5.0;
        }
        return d;
    }

    public abstract ArrayList getMeasureList();

    static {
        statusCodeMap.put("started", 3.0);
        statusCodeMap.put("open", 4.0);
        statusCodeMap.put("connected", 5.0);
        statusCodeMap.put("active", 6.0);
        statusCodeMap.put("ready", 7.0);
        statusCodeMap.put("starting", 12.0);
        statusCodeMap.put("stopping", 13.0);
        statusCodeMap.put("restarting", 14.0);
        statusCodeMap.put("recovering", 15.0);
        statusCodeMap.put("reconnecting", 16.0);
        statusCodeMap.put("recovered", 32.0);
        statusCodeMap.put("alerted", 33.0);
        statusCodeMap.put("partially started", 34.0);
        statusCodeMap.put("disabled", 42.0);
        statusCodeMap.put("stopped", 43.0);
        statusCodeMap.put("not active", 44.0);
        statusCodeMap.put("start failed", 52.0);
        statusCodeMap.put("restart failed", 53.0);
        statusCodeMap.put("stop failed", 54.0);
        statusCodeMap.put("init failed", 55.0);
        statusCodeMap.put("recovery failed", 56.0);
        statusCodeMap.put("error", 65.0);
    }
}

