/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.concurrent;

import com.eg.org.apache.commons.lang3.Validate;
import com.eg.org.apache.commons.lang3.concurrent.ConcurrentException;
import com.eg.org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import com.eg.org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentRuntimeException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException executionException) throws ConcurrentException {
        ConcurrentException concurrentException = ConcurrentUtils.extractCause(executionException);
        if (concurrentException != null) {
            throw concurrentException;
        }
    }

    public static void handleCauseUnchecked(ExecutionException executionException) {
        ConcurrentRuntimeException concurrentRuntimeException = ConcurrentUtils.extractCauseUnchecked(executionException);
        if (concurrentRuntimeException != null) {
            throw concurrentRuntimeException;
        }
    }

    static Throwable checkedException(Throwable throwable) {
        Validate.isTrue(throwable != null && !(throwable instanceof RuntimeException) && !(throwable instanceof Error), "Not a checked exception: " + throwable, new Object[0]);
        return throwable;
    }

    private static void throwCause(ExecutionException executionException) {
        if (executionException.getCause() instanceof RuntimeException) {
            throw (RuntimeException)executionException.getCause();
        }
        if (executionException.getCause() instanceof Error) {
            throw (Error)executionException.getCause();
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> concurrentInitializer) throws ConcurrentException {
        return concurrentInitializer != null ? (T)concurrentInitializer.get() : null;
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> concurrentInitializer) {
        try {
            return ConcurrentUtils.initialize(concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, V v2) {
        if (concurrentMap == null) {
            return null;
        }
        V v3 = concurrentMap.putIfAbsent(k2, v2);
        return v3 != null ? v3 : v2;
    }

    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) throws ConcurrentException {
        if (concurrentMap == null || concurrentInitializer == null) {
            return null;
        }
        Object v2 = concurrentMap.get(k2);
        if (v2 == null) {
            return ConcurrentUtils.putIfAbsent(concurrentMap, k2, concurrentInitializer.get());
        }
        return v2;
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) {
        try {
            return ConcurrentUtils.createIfAbsent(concurrentMap, k2, concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <T> Future<T> constantFuture(T t2) {
        return new ConstantFuture<T>(t2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConstantFuture<T>
    implements Future<T> {
        private final T value;

        ConstantFuture(T t2) {
            this.value = t2;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T get(long l2, TimeUnit timeUnit) {
            return this.value;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel(boolean bl2) {
            return false;
        }
    }
}

