/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSize {
    private static final String LENGTH_PART = "([0-9]+)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|kb|mb|gb)s?";
    private static final int UNIT_GROUP = 2;
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)s?", 2);
    public static final long KB_COEFFICIENT = 1024L;
    public static final long MB_COEFFICIENT = 0x100000L;
    public static final long GB_COEFFICIENT = 0x40000000L;
    final long size;

    public FileSize(long l2) {
        this.size = l2;
    }

    public long getSize() {
        return this.size;
    }

    public static FileSize valueOf(String string) {
        Matcher matcher = FILE_SIZE_PATTERN.matcher(string);
        if (matcher.matches()) {
            long l2;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            long l3 = Long.valueOf(string2);
            if (string3.equalsIgnoreCase("")) {
                l2 = 1L;
            } else if (string3.equalsIgnoreCase("kb")) {
                l2 = 1024L;
            } else if (string3.equalsIgnoreCase("mb")) {
                l2 = 0x100000L;
            } else if (string3.equalsIgnoreCase("gb")) {
                l2 = 0x40000000L;
            } else {
                throw new IllegalStateException("Unexpected " + string3);
            }
            return new FileSize(l3 * l2);
        }
        throw new IllegalArgumentException("String value [" + string + "] is not in the expected format.");
    }

    public String toString() {
        long l2 = this.size / 1024L;
        if (l2 == 0L) {
            return this.size + " Bytes";
        }
        long l3 = this.size / 0x100000L;
        if (l3 == 0L) {
            return l2 + " KB";
        }
        long l4 = this.size / 0x40000000L;
        if (l4 == 0L) {
            return l3 + " MB";
        }
        return l4 + " GB";
    }
}

