'use strict'

/**
 * Default config which can be changed using snippet code, ex. agent.start({...config})
 * OR by setting env variable, ex. to change agent_host, need to set value in EG_AGENT_HOST
 * OR by passing Node.js startup arg, ex. to change agent_host, need to pass the value --eg_agent_host
 */

module.exports = {
  // Unique id for this component
  component_id: null,  // EG_COMPONENT_ID,  --eg_component_id
  unique_component_id: null,  // EG_UNIQUE_COMPONENT_ID, --eg_unique_component_id

  agent_port: 23700,  // EG_AGENT_PORT, --eg_agent_port
  agent_host: '127.0.0.1',  // EG_AGENT_HOST, --eg_agent_host
  // For docker the host should be host.docker.internal
  agent_reserved_ports: '21700,22700,23700,24700,25700,26700,27700,28700,29700,30700',  // EG_AGENT_RESERVED_PORTS, --eg_agent_reserved_ports

  /** Log config */
  log_level: 'info',  // options: error, warn, info, verbose, debug, silly
  log_file_count: 5,
  log_file_size: 2, // size in MB

  /** Transport config */
  socket_timeout: 1000, // millisecond
  flush_interval: 50, // millisecond
  max_batch_size: 50,
  max_queue_size: 1000,
  is_zipped_payload: false,
  pay_load_message_type: 'JSON', // JSON or PROTOBUF
  agent_max_inactive_time: 15 * 60 * 1000,  // after this time, agent will stop the tracing and wait for agent to connect
  connection_check_interval: 30 * 1000, // (ms) the time in which the profiler will try to connect with agent
  component_check_interval: 60 * 1000, // (ms) the time in which the profiler will try to verify with agent
  heart_beat_interval: 3 * 60 * 1000, // millisecond
  no_of_max_fast_connection_attempt: 10, // only for first 10 times, the profiler will try to connect for every 30 s. after it is 60s, 120s, 240s, 480s then always it is 960s
  connection_check_max_interval: 960 * 1000, // ms

  /** Exceptions config */
  capture_cause_of_exception: false,
  max_exception_cause_depth: 15,
  max_exception_trace_line_count: 20,
  ignore_exceptions: 'None', // comma separted exception names
  ignored_exceptions: [],  // example name "ReferenceError"
  include_exceptions: 'None',
  included_exceptions: [],
  max_exception_trace_limit: 10001,
  max_exce_stack_trace_capture_limit: 5,
  exception_fqen_capture_limit: 1001,

  /** Inframetrics config */
  enable_inframetrics: true,
  inframetrics_interval: 5 * 60, // seconds
  enable_infra_exceptions: true,
  enable_event_loop_metrics: true,
  enable_gc_metrics: true,
  enable_uptime_metrics: true,
  // cpu
  enable_cpu_metrics: true,
  enable_cpu_profiling: true,
  cpu_profiling_duration: 5000, // ms
  // memory
  enable_memory_metrics: true,
  take_memory_snapshot: false,
  // Worker Thread config 
  enable_worker_thread_metrics: true, //EG_ENABLE_WTM, --eg_enable_wtm
  enable_wtm_from_inside_thread: false, // EG_ENABLE_WTM_FROM_INSIDE_THREAD, --eg_enable_wtm_from_inside_thread

  /** BTM config Starts */
  enable_btm: true,
  btm_interval: 3 * 60, // seconds
  enable_http_status_code_test: true,
  http_status_404_interval: 60, // seconds
  disabled_modules: [],

  /** Http url patterns */
  max_url_segments: 3,
  chars_to_exclude: "\\\\",
  excluded_patterns: "*.ttf,*.otf,*.woff,*.woff2,*.eot,*.cff,*.afm,*.lwfn,*.ffil,*.fon,*.pfm,*.pfb,*.std,*.pro,*.xsf,*.jpg,*.jpeg,*.jpe,*.jif,*.jfif,*.jfi,*.jp2,*.j2k,*.jpf,*.jpx,*.jpm,*.jxr,*.hdp,*.wdp,*.mj2,*.webp,*.gif,*.png,*.apng,*.mng,*.tiff,*.tif,*.xbm,*.bmp,*.dib,*.svg,*.svgz,*.mpg,*.mpeg,*.mpeg2,*.avi,*.wmv,*.mov,*.rm,*.ram,*.swf,*.flv,*.ogg,*.webm,*.mp4,*.ts,*.mid,*.midi,*.wma,*.aac,*.wav,*.mp3,*.css,*.js,*.ico,*.cur,/egurkha*",
  slow_url_threshold: 4 * 1000,
  stalled_url_threshold: 60 * 1000,
  http_headers: false,
  http_cookies: false,
  http_status_code: false,
  threshold_config: {},
  key_threshold_config: {},
  remote_header_address: 'X-Forwarded-For',

  /** DB config */
  min_dbq_exec_track_time: 50,
  max_query_to_track_per_db: 50,
  max_error_query_to_track_per_db: 10,
  max_db_trace_limit_per_transaction: 100000,
  // nosql
  max_nosql_query_length: 1024,
  /** BTM config ends */

  /** Discovery config */
  discovery_details_interval: 30, // seconds
  discovery_reminder_interval: 5, // seconds
  portno_discovery_timeout: 5 * 60, // seconds
  cmd_to_get_container_id: "", // base64 command to get container id, EG_CMD_TO_GET_CONTAINER_ID

  /** RUM config */
  enable_rum_btm_transaction_mapping: false,
  enable_rum_injection: false,
  rum_snippet: "",
  rum_snippet_injection_place: [{
    regex: /<head.*?>/gsi,
    type: 'AFTER'
  }, {
    regex: /<\/head>/gsi,
    type: 'BEFORE',
  }, {
    regex: /<meta.*?>/gsi,
    type: 'AFTER_LAST',
  }],

  /** Debug config */
  enable_console_log: false,  // EG_ENABLE_CONSOLE_LOG, --eg_enable_console_log
}